﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Xml.Serialization;
using System.Net;
using WinnyProtocolAnalyzer;

namespace WinnyProtocolAnalyzer.Data
{
    [Serializable]
    [XmlRoot("ノード")]
    public class Node
    {
        [XmlElement("エンドポイント")]
        public EndPoint EndPoint { get; set; }
        [XmlElement("ポート0フラグ")]
        public bool Port0 { get; set; }
        [XmlElement("NAT")]
        public bool NAT { get; set; }
        [XmlElement("回線速度")]
        public float LineSpeed { get; set; }
        [XmlElement("クラスタワード")]
        public string[] ClusterWords { get; set; }

        /// <summary>
        /// Node クラスの新しいインスタンスを作成します。
        /// </summary>
        public Node()
        {
            EndPoint = new EndPoint();
            Port0 = false;
            NAT = false;
            LineSpeed = 0;
            ClusterWords = new string[] { "", "", "" };
        }

        /// <summary>
        /// Node クラスの新しいインスタンスを作成します。
        /// </summary>
        /// <param name="EndPoint">エンドポイント</param>
        public Node(EndPoint EndPoint)
        {
            this.EndPoint = EndPoint;
            Port0 = false;
            NAT = false;
            LineSpeed = 0;
            ClusterWords = new string[] { "", "", "" };
        }

        /// <summary>
        /// Node クラスの新しいインスタンスを作成します。
        /// </summary>
        /// <param name="IPAddress">IPアドレス</param>
        /// <param name="Point">ポイント</param>
        /// <param name="Port">ポート</param>
        /// <param name="Port0">ポート0フラグ</param>
        /// <param name="LineSpeed">回線速度</param>
        /// <param name="ClusterWords">クラスタワード</param>
        public Node(string IPString, int Port, bool ReverseLookup, bool Port0, float LineSpeed, string[] ClusterWords)
        {
            this.EndPoint = new EndPoint(IPString, Port, ReverseLookup);
            this.Port0 = Port0;
            this.NAT = false;
            this.LineSpeed = LineSpeed;
            for (int i = 0; i < ClusterWords.Length; i++)
            {
                ClusterWords[i] = Utility.ValidFileName(ClusterWords[i]);
            }
            this.ClusterWords = ClusterWords;
        }

        /// <summary>
        /// Node クラスの新しいインスタンスを作成します。
        /// </summary>
        /// <param name="IPAddress">IPアドレス</param>
        /// <param name="Point">ポイント</param>
        /// <param name="Port">ポート</param>
        /// <param name="Port0">ポート0フラグ</param>
        /// <param name="LineSpeed">回線速度</param>
        /// <param name="ClusterWords">クラスタワード</param>
        public Node(IPAddress IPAddress, int Port, bool ReverseLookup, bool Port0, float LineSpeed, string[] ClusterWords)
        {
            this.EndPoint = new EndPoint(IPAddress, Port, ReverseLookup);
            this.Port0 = Port0;
            this.NAT = false;
            this.LineSpeed = LineSpeed;
            for (int i = 0; i < ClusterWords.Length; i++)
            {
                ClusterWords[i] = Utility.ValidFileName(ClusterWords[i]);
            }
            this.ClusterWords = ClusterWords;
        }


    }
}
