﻿#pragma once
/*
*/
// Windows Header Files:
#include "base_window.h"
#include "taskbar.h"
namespace sf
{

  struct toplevel_window;
  typedef std::shared_ptr<toplevel_window> toplevel_window_ptr;

  /** toplevel_window を生成する関数 */
  toplevel_window_ptr create_toplevel_window (
    const std::wstring& menu_name,
    const std::wstring& name,
    const uint32_t show_flag = SW_SHOW,
    bool fit_to_display = false,
    float width = 180,
    float height = 60
    );

  /** toplevel ウィンドウクラス */
  /* このクラスは、create_toplevel_window 関数からのみ生成可能 */
  struct toplevel_window : public base_window
  {

    friend   toplevel_window_ptr create_toplevel_window
      (
      const std::wstring& menu_name,
      const std::wstring& name,
      const uint32_t show_flag,
      bool fit_to_display ,
      float width ,
      float height 
      );

    ~toplevel_window(){};
 
    void * raw_handle() const;
    void create();
    void toplevel_window::show();
    bool toplevel_window::is_show();
    void toplevel_window::hide();

    void text(std::wstring& text);
    void update();

  private:
    struct impl;
    toplevel_window(const std::wstring& menu_name,const std::wstring& name,bool fit_to_display,float width = 180,float height = 100);
    // 実装部
    std::shared_ptr<impl> impl_;
  };
}