﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

namespace wintree7
{
    class WinTreeSettings
    {
        public WinTreeSettings(bool getDefaultSettings = false)
        {
            System.IO.FileInfo setting = new System.IO.FileInfo("wintree7.xml");
            if (!setting.Exists || getDefaultSettings)
            {
                Form = new WinTreeSettingsMainForm();
                Item = new WinTreeSettingsDiplayItem();
                Order = new WinTreeSettingsDisplayOrder();
                Style = new WinTreeSettingsDisplayStyle();
                Html = new WinTreeSettingsHtml();
                Other = new WinTreeSettingsOther();
            }
            else
            {
                /// @todo 設定ファイルからデータを取得し、各設定クラスの
                ///       コンストラクタへ投入しインスタンスを生成する
            }
        }

        public WinTreeSettingsMainForm Form;
        public WinTreeSettingsDiplayItem Item;
        public WinTreeSettingsDisplayOrder Order;
        public WinTreeSettingsDisplayStyle Style;
        public WinTreeSettingsHtml Html;
        public WinTreeSettingsOther Other;
    }

    class WinTreeSettingsMainForm
    {
        public WinTreeSettingsMainForm()
            : this(System.Windows.Forms.FormStartPosition.Manual, new System.Drawing.Point(200, 150), @"", @".\")
        {
        }

        public WinTreeSettingsMainForm(System.Windows.Forms.FormStartPosition startPosition, System.Drawing.Point Location, string lastSearchDirectory, string lastOutputDirectory)
        {
            this.startPosition = startPosition;
            this.Location = Location;
            this.lastSearchDirectory = lastSearchDirectory;
            this.lastOutputDirectory = lastOutputDirectory;
        }

        public System.Windows.Forms.FormStartPosition startPosition;
        public System.Drawing.Point Location;
        public string lastSearchDirectory;
        public string lastOutputDirectory;
    }

    class WinTreeSettingsDiplayItem
    {
        public WinTreeSettingsDiplayItem()
            : this(true, true, true, false, false, true, true, false, false)
        {
        }

        public WinTreeSettingsDiplayItem(bool showFileName, bool showSize, bool showAttribute, bool showCreateDate, bool showCreateTime, bool showUpdateDate, bool showUpdateTime, bool showCRC, bool showFileVersion)
        {
            this.showFileName = showFileName;
            this.showSize = showSize;
            this.showAttribute = showAttribute;
            this.showCreateDate = showCreateDate;
            this.showCreateTime = showCreateTime;
            this.showUpdateDate = showUpdateDate;
            this.showUpdateTime = showUpdateTime;
            this.showCRC = showCRC;
            this.showFileVersion = showFileVersion;
        }

        public bool showFileName;
        public bool showSize;
        public bool showAttribute;
        public bool showCreateDate;
        public bool showCreateTime;
        public bool showUpdateDate;
        public bool showUpdateTime;
        public bool showCRC;
        public bool showFileVersion;
    }

    class WinTreeSettingsDisplayOrder
    {
        public WinTreeSettingsDisplayOrder()
            : this(DisplayOrderType.FileName, true, true, true, true)
        { 
        }

        public WinTreeSettingsDisplayOrder(DisplayOrderType orderType, bool orderByFileNameAscending, bool orderByFileSizeSmallToLarge, bool orderByFileNewToOld, bool orderNotCaseSencetive)
        {
            this.orderType = orderType;
            this.orderByFileNameAscending = orderByFileNameAscending;
            this.orderByFileSizeSmallToLarge = orderByFileSizeSmallToLarge;
            this.orderByFileNewToOld = orderByFileNewToOld;
            this.orderNotCaseSencetive = orderNotCaseSencetive;
        }

        public DisplayOrderType orderType;
        public bool orderByFileNameAscending;
        public bool orderByFileSizeSmallToLarge;
        public bool orderByFileNewToOld;
        public bool orderNotCaseSencetive;

        public enum DisplayOrderType
        {
            FileName,
            Extention,
            Size,
            CreateDate,
            UpdateDate
        }
    }

    class WinTreeSettingsDisplayStyle
    {
        public WinTreeSettingsDisplayStyle()
            : this(78, 0, BoaderWidthType.Full,
            new WinTreeSettingsBoaderStyle("|  ", "   ", "|- ", "-", "+- "),
            new WinTreeSettingsBoaderStyle("│ ", "   ", "├ ", "─", "└ "),
            true, 9, StyleFormat.Normal)
        {
        }

        public WinTreeSettingsDisplayStyle(int colomnLimit, int rowMergin, BoaderWidthType boarderWidthType, WinTreeSettingsBoaderStyle halfWidth, WinTreeSettingsBoaderStyle fullWidth, bool sizeNotOmit, int sizeColumn, StyleFormat styleFormat)
        {
            this.colomnLimit = colomnLimit;
            this.rowMergin = rowMergin;
            this.boarderWidthType = boarderWidthType;
            this.halfWidth = halfWidth;
            this.fullWidth = fullWidth;
            this.sizeNotOmit = sizeNotOmit;
            this.sizeColumn = sizeColumn;
            this.styleFormat = styleFormat;
        }

        public int colomnLimit;
        public int rowMergin;
        public BoaderWidthType boarderWidthType;
        public WinTreeSettingsBoaderStyle halfWidth;
        public WinTreeSettingsBoaderStyle fullWidth;
        public bool sizeNotOmit;
        public int sizeColumn;
        public StyleFormat styleFormat;

        public enum BoaderWidthType
        {
            Half,
            Full
        }

        public enum StyleFormat
        {
            Normal,
            Omit1,
            Omit2,
            Omit3
        }

        public class WinTreeSettingsBoaderStyle
        {
            public WinTreeSettingsBoaderStyle(string vertical, string whiteSpace, string branch, string rule, string tip)
            {
                this.vertical = vertical;
                this.whiteSpace = whiteSpace;
                this.branch = branch;
                this.rule = rule;
                this.tip = tip;
            }

            public string vertical;
            public string whiteSpace;
            public string branch;
            public string rule;
            public string tip;
        }
    }

    class WinTreeSettingsHtml
    {
        public WinTreeSettingsHtml()
            : this(false, HtmlStyle.Normal, false, true)
        {
        }

        public WinTreeSettingsHtml(bool createHtml, HtmlStyle htmlStyle, bool makeLinkToFolder, bool makeLinkToFile)
        {
            this.createHtml = createHtml;
            this.htmlStyle = htmlStyle;
            this.makeLinkToFolder = makeLinkToFolder;
            this.makeLinkToFile = makeLinkToFile;
        }

        public bool createHtml;
        public HtmlStyle htmlStyle;
        public bool makeLinkToFolder;
        public bool makeLinkToFile;

        public enum HtmlStyle
        {
            Normal = 0,
            PowerfullBoarder,
            NoBoarder
        }
    }

    class WinTreeSettingsOther
    {
        public WinTreeSettingsOther()
            : this(true, @"フォルダ リスト(&L)", true, true, true, true, false, false)
        {
        }

        public WinTreeSettingsOther(bool bootableFromShortcut, string ShortcutCaption, bool listHiddenFiles, bool useLongFileName, bool searchRecursive, bool rememberPosition, bool useFileFilter, bool openAfterCreateList)
        {
            this.bootableFromShortcut = bootableFromShortcut;
            this.ShortcutCaption = ShortcutCaption;
            this.listHiddenFiles = listHiddenFiles;
            this.useLongFileName = useLongFileName;
            this.searchRecursive = searchRecursive;
            this.rememberPosition = rememberPosition;
            this.useFileFilter = useFileFilter;
            this.openAfterCreateList = openAfterCreateList;
        }

        public bool bootableFromShortcut;
        public string ShortcutCaption;
        public bool listHiddenFiles;
        public bool useLongFileName;
        public bool searchRecursive;
        public bool rememberPosition;
        public bool useFileFilter;
        public bool openAfterCreateList;
    }
}
