﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Windows.Forms;

namespace wintree7
{
    public partial class FormWinTree : Form
    {
        public FormWinTree()
        {
            InitializeComponent();
        }

        private void FormWinTree_Load(object sender, EventArgs e)
        {
            WinTreeSettings settings = new WinTreeSettings();

            this.StartPosition = settings.Form.startPosition;
            this.Location = settings.Form.Location;
            textBoxSearchFolder.Text = settings.Form.lastSearchDirectory;
            saveFileDialog1.FileName = settings.Form.lastOutputDirectory;
        }

        private void buttonClose_Click(object sender, EventArgs e)
        {
            this.Close();
        }

        private void buttonSearchFolder_Click(object sender, EventArgs e)
        {
            folderBrowserDialog1.SelectedPath = textBoxSearchFolder.Text;
            if (folderBrowserDialog1.ShowDialog() == DialogResult.OK)
            {
                textBoxSearchFolder.Text = folderBrowserDialog1.SelectedPath;
            }
        }

        private void buttonCallSetting_Click(object sender, EventArgs e)
        {
            FormWinTreeSettings setting = new FormWinTreeSettings();
            setting.ShowDialog();
        }

        private void buttonExecute_Click(object sender, EventArgs e)
        {
            try
            {
                System.IO.DirectoryInfo di = new System.IO.DirectoryInfo(textBoxSearchFolder.Text);
                if (!di.Exists
                    || (di.FullName.ToLower().TrimEnd('\\') == @"c:")
                    || (di.FullName.ToLower().TrimEnd('\\') == @"c:\program files")
                    || (di.FullName.ToLower().TrimEnd('\\') == @"c:\program files (x86)"))
                {
                    throw (new ArgumentException());
                }

                if (di.Name.ToLower() != di.Root.Name.ToLower())
                {
                    saveFileDialog1.FileName = di.Name + "のリスト.txt";
                }
                else
                {
                    saveFileDialog1.FileName = di.Name.TrimEnd(':', '\\') + "ドライブのリスト.txt";
                }

                if (saveFileDialog1.ShowDialog() == DialogResult.OK)
                {
                    new WinTreeCreator(di, new System.IO.FileInfo(saveFileDialog1.FileName));
                }
            }
            catch (ArgumentException)
            {
                MessageBox.Show("\"" + textBoxSearchFolder.Text + "\"\nこの名前のフォルダまたはドライブが見つかりませんでした。", "WintTree7", MessageBoxButtons.OK, MessageBoxIcon.Exclamation);
            }
        }
    }
}
