/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.api.datastore;

import java.io.Serializable;
import java.util.Iterator;
import java.util.LinkedList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Key
implements Serializable,
Comparable<Key> {
    static final long NOT_ASSIGNED = 0L;
    private final Key parentKey;
    private final String kind;
    private String appId;
    private long id;
    private final String name;

    private Key() {
        this.parentKey = null;
        this.kind = null;
        this.appId = null;
        this.id = 0L;
        this.name = null;
    }

    Key(String kind) {
        this(kind, null, 0L);
    }

    Key(String kind, String name) {
        this(kind, null, name);
    }

    Key(String kind, Key parentKey) {
        this(kind, parentKey, 0L);
    }

    Key(String kind, Key parentKey, long id) {
        this(kind, parentKey, id, null, null);
    }

    Key(String kind, Key parentKey, String name) {
        this(kind, parentKey, 0L, name, null);
    }

    Key(String kind, Key parentKey, long id, String name, String appId) {
        if (kind == null || kind.length() == 0) {
            throw new IllegalArgumentException("No kind specified.");
        }
        Key.validateAppId(parentKey, appId);
        if (name != null) {
            if (name.length() == 0) {
                throw new IllegalArgumentException("Name may not be empty.");
            }
            if (Character.isDigit(name.charAt(0))) {
                throw new IllegalArgumentException("Name may not start with a digit.");
            }
            if (id != 0L) {
                throw new IllegalArgumentException("Id and name may not both be specified at once.");
            }
        }
        this.name = name;
        this.id = id;
        this.parentKey = parentKey;
        this.kind = kind;
        this.appId = appId;
    }

    private static void validateAppId(Key parentKey, String appId) {
        if (parentKey != null && appId != null && parentKey.getAppId() != null && !parentKey.getAppId().equals(appId)) {
            throw new IllegalArgumentException("Parent key must have same app id as child.");
        }
    }

    public String getKind() {
        return this.kind;
    }

    public Key getParent() {
        return this.parentKey;
    }

    public int hashCode() {
        int h = 17;
        h = h * 31 + (int)(this.id & 0xFFFFL);
        if (this.name != null) {
            h = h * 31 + this.name.hashCode();
        }
        h = h * 31 + this.kind.hashCode();
        if (this.parentKey != null) {
            h = h * 31 + this.parentKey.hashCode();
        }
        return h;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        this.appendToString(buffer);
        return buffer.toString();
    }

    private void appendToString(StringBuffer buffer) {
        if (this.parentKey != null) {
            this.parentKey.appendToString(buffer);
            buffer.append("/");
        }
        buffer.append(this.kind);
        buffer.append("(");
        if (this.name != null) {
            buffer.append(this.name);
        } else if (this.id == 0L) {
            buffer.append("no-id-yet");
        } else {
            buffer.append(String.valueOf(this.id));
        }
        buffer.append(")");
    }

    public boolean equals(Object object) {
        if (object instanceof Key) {
            Key key = (Key)object;
            if (this.name == null && this.id == 0L && key.id == 0L) {
                return this == key;
            }
            if (this.id != key.id || !this.kind.equals(key.kind) || this.name != null && !this.name.equals(key.name)) {
                return false;
            }
            return this.parentKey == key.parentKey || this.parentKey != null && this.parentKey.equals(key.parentKey);
        }
        return false;
    }

    String getAppId() {
        return this.appId;
    }

    void setAppId(String appId) {
        Key.validateAppId(this.parentKey, appId);
        this.appId = appId;
    }

    public long getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public Key getChild(String kind, long id) {
        if (!this.isComplete()) {
            throw new IllegalStateException("Cannot get a child of an incomplete key.");
        }
        return new Key(kind, this, id);
    }

    public Key getChild(String kind, String name) {
        if (!this.isComplete()) {
            throw new IllegalStateException("Cannot get a child of an incomplete key.");
        }
        return new Key(kind, this, name);
    }

    public boolean isComplete() {
        return this.id != 0L || this.name != null;
    }

    void setId(long id) {
        if (this.name != null) {
            throw new IllegalArgumentException("Cannot set id; key already has a name.");
        }
        this.id = id;
    }

    void simulatePutForTesting(long testId) {
        this.id = testId;
    }

    private static Iterator<Key> getPathIterator(Key key) {
        LinkedList<Key> stack = new LinkedList<Key>();
        do {
            stack.addFirst(key);
        } while ((key = key.getParent()) != null);
        return stack.iterator();
    }

    @Override
    public int compareTo(Key other) {
        if (this == other) {
            return 0;
        }
        Iterator<Key> thisPath = Key.getPathIterator(this);
        Iterator<Key> otherPath = Key.getPathIterator(other);
        while (thisPath.hasNext()) {
            Key thisKey = thisPath.next();
            if (otherPath.hasNext()) {
                Key otherKey = otherPath.next();
                int result = Key.compareToInternal(thisKey, otherKey);
                if (result == 0) continue;
                return result;
            }
            return 1;
        }
        return otherPath.hasNext() ? -1 : 0;
    }

    private static int compareToInternal(Key thisKey, Key otherKey) {
        if (thisKey == otherKey) {
            return 0;
        }
        int result = thisKey.getAppId().compareTo(otherKey.getAppId());
        if (result != 0) {
            return result;
        }
        result = thisKey.getKind().compareTo(otherKey.getKind());
        if (result != 0) {
            return result;
        }
        if (!thisKey.isComplete() && !otherKey.isComplete()) {
            return Key.compareToWithIdentityHash(thisKey, otherKey);
        }
        if (thisKey.getId() != 0L) {
            if (otherKey.getId() == 0L) {
                return -1;
            }
            return Long.valueOf(thisKey.getId()).compareTo(otherKey.getId());
        }
        if (otherKey.getId() != 0L) {
            return 1;
        }
        return thisKey.getName().compareTo(otherKey.getName());
    }

    static int compareToWithIdentityHash(Key k1, Key k2) {
        return Integer.valueOf(System.identityHashCode(k1)).compareTo(System.identityHashCode(k2));
    }
}

