require '../uim'

def dump_custom(custom_sym)
  custom = UIM::Custom.new(custom_sym)
  print "\n;; " + custom.label + "\n;; " + custom.desc + "\n"

  def_literal = UIM::Custom.definition_as_literal(custom_sym)
  if def_literal != nil
    print def_literal + "\n"
  end

end

def dump_group(group_sym)
  group = UIM::Custom::Group.new(group_sym)
  print ";;;\n;;; " + group.label + "\n;;;\n"

  custom_syms = UIM::Custom::collect_by_group(group_sym)
  custom_syms.each do |sym|
    dump_custom(sym)
  end
end

UIM.init
if UIM::Custom.enable == true
  primary_groups = UIM::Custom.primary_groups
  primary_groups.each do |group|
    dump_group(group)
  end
else
  puts "uim_custom_enable failed"
  UIM.quit
  exit -1
end
UIM.quit
exit 0

