﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Windows.Forms;

namespace WindowsFormsApplication1
{
    static class Program
    {
        /// <summary>
        /// アプリケーションのメイン エントリ ポイントです。
        /// </summary>
        [STAThread]
        static void Main()
        {
            Application.EnableVisualStyles();
            Application.SetCompatibleTextRenderingDefault(false);
            ReadAppConfig();
            Application.Run(new MainF());
        }

        static void ReadAppConfig()
        {
            string val;

            #region 取込標準フォルダ

            val = Properties.Settings.Default["取込標準フォルダ"].ToString();
            if (string.IsNullOrEmpty(val))
            {
                appConfigData.DefaultInputPath = Environment.GetFolderPath(Environment.SpecialFolder.MyDocuments);
            }
            else
            {
                val = val.TrimEnd();
                if (System.IO.Directory.Exists(val))
                {
                    if (val.Substring(val.Length - 1, 1) == "\\")
                    {
                        appConfigData.DefaultInputPath = val;
                    }
                    else
                    {
                        appConfigData.DefaultInputPath = val + "\\";
                    }
                }
                else
                {
                    appConfigData.DefaultInputPath = Environment.GetFolderPath(Environment.SpecialFolder.MyDocuments);
                }
            }

            #endregion

            #region 出力標準フォルダ

            val = Properties.Settings.Default["出力標準フォルダ"].ToString();
            if (string.IsNullOrEmpty(val))
            {
                appConfigData.DefaultOutputPath = Environment.GetFolderPath(Environment.SpecialFolder.MyPictures);
            }
            else
            {
                val = val.TrimEnd();
                if (System.IO.Directory.Exists(val))
                {
                    if (val.Substring(val.Length - 1, 1) == "\\")
                    {
                        appConfigData.DefaultOutputPath = val;
                    }
                    else
                    {
                        appConfigData.DefaultOutputPath = val + "\\";
                    }
                }
                else
                {
                    appConfigData.DefaultOutputPath = Environment.GetFolderPath(Environment.SpecialFolder.MyPictures);
                }
            }

            #endregion

            #region 変換方式

            val = Properties.Settings.Default["変換方式"].ToString();
            if (string.IsNullOrEmpty(val))
            {
                appConfigData.OutputLogicType = com.dnetopen.MsOffice.MsWord2007.WordToJpeg.ConvertMethodType.Doc_Mdi_Tiff_Image;
            }
            else
            {
                val = val.TrimEnd();
                if (val != "1")
                {
                    appConfigData.OutputLogicType = com.dnetopen.MsOffice.MsWord2007.WordToJpeg.ConvertMethodType.Doc_Mdi_Tiff_Image;
                }
                else
                {
                    appConfigData.OutputLogicType = com.dnetopen.MsOffice.MsWord2007.WordToJpeg.ConvertMethodType.Doc_Tiff_Image;
                }
            }

            #endregion

            #region MDI出力時の画像圧縮

            val = Properties.Settings.Default["MDI出力時の画像圧縮"].ToString();
            if (string.IsNullOrEmpty(val))
            {
                appConfigData.MdiCompImg = com.dnetopen.MsOffice.MODIWSetting.RegstSettingValues.MdiCompImgValue.NONE_COMPRESS_IMAGE;
            }
            else
            {
                val = val.TrimEnd();
                if (val != "0")
                {
                    appConfigData.MdiCompImg = com.dnetopen.MsOffice.MODIWSetting.RegstSettingValues.MdiCompImgValue.NONE_COMPRESS_IMAGE;
                }
                else
                {
                    appConfigData.MdiCompImg = com.dnetopen.MsOffice.MODIWSetting.RegstSettingValues.MdiCompImgValue.COMPRESS_IMAGE;
                }
            }

            #endregion

            #region Tif出力時のDpi

            val = Properties.Settings.Default["Tif出力時のDpi"].ToString();
            if (string.IsNullOrEmpty(val))
            {
                appConfigData.TiffDpi = 300;
            }
            else
            {
                int tiffDpiVal = 300;
                if (int.TryParse(val, out tiffDpiVal))
                {
                    appConfigData.TiffDpi = tiffDpiVal;
                }
                else
                {
                    appConfigData.TiffDpi = 300;
                }
            }

            #endregion

        }
    }
}
