﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

namespace com.dnetopen.MsOffice.MODIWSetting
{
    public class RegstChecker
    {
        private const string _office2003Key = @"HKEY_CURRENT_USER\Software\Microsoft\Office\11.0\MODI\MDI writer";
        private const string _office2007Key = @"HKEY_CURRENT_USER\Software\Microsoft\Office\12.0\MODI\MDI writer";
        private static string _officeFutureKey = @"HKEY_CURRENT_USER\Software\Microsoft\Office\@@.@\MODI\MDI writer";
        private const int MaxOfficeFutureVer = 15;
        private const int MinOfficeFutureVer = 13;

        public static string GetLatestRegistryKey()
        {
            string ret = null;
            //Office2007をチェック
            if (Microsoft.Win32.Registry.GetValue(_office2007Key, "PrivateFlags", null) != null)
            {
                return _office2007Key;
            }
            //Office2003をチェック
            if (Microsoft.Win32.Registry.GetValue(_office2003Key, "PrivateFlags", null) != null)
            {
                return _office2003Key;
            }
            //Officeの未来バージョンをチェック
            for (int i = MaxOfficeFutureVer; MinOfficeFutureVer >= i; i--)
			{
                if (Microsoft.Win32.Registry.GetValue(_officeFutureKey.Replace("@@.@",i.ToString("00.0")) , "PrivateFlags", null) != null)
                {
                    return _officeFutureKey.Replace("@@.@", i.ToString("00.0"));
                }
			}

            return ret;
        }
    }
}
