﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Printing;

namespace com.dnetopen.MsOffice.Printer
{
    public class MODIWPrinter
    {
        /// <summary>
        /// MODIのプリンタ名を取得
        /// </summary>
        /// <returns></returns>
        public static string GetMODIWName()
        {
            PrintServer server = new PrintServer();
            foreach (PrintQueue queue in server.GetPrintQueues())
            {
                
                if (queue.QueueDriver.Name == "Microsoft Office Document Image Writer Driver")
                {
                        return queue.Name;
                }
            }

            return null;
        }

        /// <summary>
        /// MODI設定レジストリが存在するかチェック
        /// </summary>
        /// <returns></returns>
        public static bool IsInstallMODIDriver()
        {
            if (GetMODIWName() != null)
            {
                return true;
            }
            else
            {
                return false;
            }
        }

    }
}
