/* File: japanese.c */


/*
* Copyright (c) 1997 Ben Harrison
*
* This software may be copied and distributed for educational, research,
* and not for profit purposes provided that this copyright and statement
* are included in all such copies.  Other copyrights may also apply.
*/

#include "angband.h"

#ifdef JP

/*
* Find valid breakpoint in a Japanese string
*/
int null_pos_j(const char* s, int maxpos)
{
    int i = 0;
	
    while (s[i] != 0 && i < ((iskanji(s[i])) ? maxpos-1 : maxpos))
		i+= iskanji(s[i]) ? 2 : 1;
	
    return(i);
}

typedef struct convert_key convert_key;

struct convert_key
{
	cptr key1;
	cptr key2;
};

static const convert_key s2j_table[] = {
	{"mb","nb"}, {"mp","np"}, {"mv","nv"}, {"mm","nm"},
	{"x","ks"},
	/* sindar:  parantir:ѥƥ  feanor:եΡ */
	{"ar$","a-ru$"}, {"ir$","ia$"}, {"or$","o-ru$"},
	{"ra",""}, {"ri",""}, {"ru",""}, {"re",""}, {"ro",""},
	{"ir","ia"}, {"ur","ua"}, {"er","ea"}, {"ar","a"},
	{"sha",""}, {"shi",""}, {"shu",""}, {"she",""}, {"sho",""},
	{"tha",""}, {"thi",""}, {"thu",""}, {"the",""}, {"tho",""},
	{"cha",""}, {"chi",""}, {"chu",""}, {"che",""}, {"cho",""},
	{"dha",""}, {"dhi",""}, {"dhu",""}, {"dhe",""}, {"dho",""},
	{"ba",""}, {"bi",""}, {"bu",""}, {"be",""}, {"bo",""},
	{"ca",""}, {"ci",""}, {"cu",""}, {"ce",""}, {"co",""},
	{"da",""}, {"di","ǥ"}, {"du","ɥ"}, {"de",""}, {"do",""},
	{"fa","ե"}, {"fi","ե"}, {"fu",""}, {"fe","ե"}, {"fo","ե"},
	{"ga",""}, {"gi",""}, {"gu",""}, {"ge",""}, {"go",""},
	{"ha",""}, {"hi",""}, {"hu",""}, {"he",""}, {"ho",""},
	{"ja",""}, {"ji",""}, {"ju",""}, {"je",""}, {"jo",""},
	{"ka",""}, {"ki",""}, {"ku",""}, {"ke",""}, {"ko",""},
	{"la",""}, {"li",""}, {"lu",""}, {"le",""}, {"lo",""},
	{"ma",""}, {"mi",""}, {"mu",""}, {"me",""}, {"mo",""},
	{"na",""}, {"ni",""}, {"nu",""}, {"ne",""}, {"no",""},
	{"pa",""}, {"pi",""}, {"pu",""}, {"pe",""}, {"po",""},
	{"qu",""},
	{"sa",""}, {"si",""}, {"su",""}, {"se",""}, {"so",""},
	{"ta",""}, {"ti","ƥ"}, {"tu","ȥ"}, {"te",""}, {"to",""},
	{"va",""}, {"vi",""}, {"vu",""}, {"ve",""}, {"vo",""},
	{"wa",""}, {"wi",""}, {"wu",""}, {"we",""}, {"wo",""},
	{"ya",""}, {"yu",""}, {"yo",""},
	{"za",""}, {"zi",""}, {"zu",""}, {"ze",""}, {"zo",""},
	{"dh",""}, {"ch",""}, {"th",""},
	{"b",""}, {"c",""}, {"d",""}, {"f",""}, {"g",""},
	{"h",""}, {"j",""}, {"k",""}, {"l",""}, {"m",""},
	{"n",""}, {"p",""}, {"q",""}, {"r",""}, {"s",""},
	{"t",""}, {"v",""}, {"w",""}, {"y",""},
	{"a",""}, {"i",""}, {"u",""}, {"e",""}, {"o",""},
	{"-",""},
	{NULL,NULL}
};

/* ѸǤδʪ̤Ƚܸ̾ɤߤѴ */
void sindarin_to_kana(char *kana, const char *sindarin)
{
	char buf[256];
	int idx;
	
	sprintf(kana, "%s$", sindarin);
	for (idx=0; kana[idx]; idx++)
		if (isupper(kana[idx])) kana[idx] = tolower(kana[idx]);
	
	for (idx = 0; s2j_table[idx].key1 != NULL; idx++)
	{
		cptr pat1 = s2j_table[idx].key1;
		cptr pat2 = s2j_table[idx].key2;
		int len = strlen(pat1);
		char *src = kana;
		char *dest = buf;
		
		while (*src) {
			if( strncmp(src, pat1, len) == 0 )
			{
				strcpy(dest, pat2);
				src += len;
				dest += strlen(pat2);
			}
			else
			{
				if( iskanji(*src) )
				{
					*dest = *src;
					src++;
					dest++;
				}
				*dest = *src;
				src++;
				dest++;
			}
		}

		*dest = 0;
		strcpy(kana, buf);
	}

	idx = 0;

	while( kana[idx] != '$' ) idx++;

	kana[idx] = '\0';
}


/* ܸư (ǤġǤä,Ǥ etc) */

#define CMPTAIL(y) strncmp(&in[l-strlen(y)], y, strlen(y))

/* , -> , */
static void jverb1( const char *in , char *out)
{
	int l = strlen(in);
	strcpy(out, in);

	/* ѳʳ */
	if( CMPTAIL("") == 0) sprintf(&out[l-4], ""); else

	/* ʳ */
	if( CMPTAIL("") == 0) sprintf(&out[l-4], ""); else

	/* ʳ */
	if( CMPTAIL("") == 0) sprintf(&out[l-4], ""); else
	if( CMPTAIL("") == 0) sprintf(&out[l-4], ""); else
	if( CMPTAIL("") == 0) sprintf(&out[l-4], ""); else
	if( CMPTAIL("") == 0) sprintf(&out[l-4], ""); else
	if( CMPTAIL("") == 0) sprintf(&out[l-4], ""); else
	if( CMPTAIL("Ƥ") == 0) sprintf(&out[l-4], ""); else
	if( CMPTAIL("Ǥ") == 0) sprintf(&out[l-4], ""); else
	if( CMPTAIL("ͤ") == 0) sprintf(&out[l-4], ""); else
	if( CMPTAIL("ؤ") == 0) sprintf(&out[l-4], ""); else
	if( CMPTAIL("٤") == 0) sprintf(&out[l-4], ""); else
	if( CMPTAIL("") == 0) sprintf(&out[l-4], ""); else
	if( CMPTAIL("") == 0) sprintf(&out[l-4], ""); else

	/* ʳ */
	if( CMPTAIL("") == 0) sprintf(&out[l-2], ""); else
	if( CMPTAIL("") == 0) sprintf(&out[l-2], ""); else
	if( CMPTAIL("") == 0) sprintf(&out[l-2], ""); else
	if( CMPTAIL("") == 0) sprintf(&out[l-2], ""); else
	if( CMPTAIL("") == 0) sprintf(&out[l-2], ""); else
	if( CMPTAIL("") == 0) sprintf(&out[l-2], ""); else
	if( CMPTAIL("") == 0) sprintf(&out[l-2], ""); else
	if( CMPTAIL("") == 0) sprintf(&out[l-2], ""); else
	if( CMPTAIL("") == 0) sprintf(&out[l-2], ""); else
	if( CMPTAIL("") == 0) sprintf(&out[l-2], ""); else
	if( CMPTAIL("") == 0) sprintf(&out[l-2], ""); else
	if( CMPTAIL("") == 0) sprintf(&out[l-2], ""); else

	sprintf(&out[l], "");
}

/* , -> äƽ */
static void jverb2( const char *in , char *out)
{
	int l = strlen(in);
	strcpy(out,in);

	/* ѳʳ */
	if( CMPTAIL("") == 0) sprintf(&out[l-4], ""); else

	/* ʳ */
	if( CMPTAIL("") == 0) sprintf(&out[l-4], ""); else

	/* ʳ */
	if( CMPTAIL("") == 0) sprintf(&out[l-4], ""); else
	if( CMPTAIL("") == 0) sprintf(&out[l-4], ""); else
	if( CMPTAIL("") == 0) sprintf(&out[l-4], ""); else
	if( CMPTAIL("") == 0) sprintf(&out[l-4], ""); else
	if( CMPTAIL("") == 0) sprintf(&out[l-4], ""); else
	if( CMPTAIL("Ƥ") == 0) sprintf(&out[l-4], "Ƥä"); else
	if( CMPTAIL("Ǥ") == 0) sprintf(&out[l-4], "Ǥ"); else
	if( CMPTAIL("ͤ") == 0) sprintf(&out[l-4], "ͤ"); else
	if( CMPTAIL("ؤ") == 0) sprintf(&out[l-4], "ؤ"); else
	if( CMPTAIL("٤") == 0) sprintf(&out[l-4], "٤"); else
	if( CMPTAIL("") == 0) sprintf(&out[l-4], ""); else
	if( CMPTAIL("") == 0) sprintf(&out[l-4], ""); else

	/* ʳ */
	if( CMPTAIL("") == 0) sprintf(&out[l-2], "ä"); else
	if( CMPTAIL("") == 0) sprintf(&out[l-2], ""); else
	if( CMPTAIL("") == 0) sprintf(&out[l-2], ""); else
	if( CMPTAIL("") == 0) sprintf(&out[l-2], ""); else
	if( CMPTAIL("") == 0) sprintf(&out[l-2], ""); else
	if( CMPTAIL("") == 0) sprintf(&out[l-2], "ä"); else
	if( CMPTAIL("") == 0) sprintf(&out[l-2], "ä"); else
	if( CMPTAIL("") == 0) sprintf(&out[l-2], "ͤ"); else
	if( CMPTAIL("") == 0) sprintf(&out[l-2], "ؤ"); else
	if( CMPTAIL("") == 0) sprintf(&out[l-2], ""); else
	if( CMPTAIL("") == 0) sprintf(&out[l-2], ""); else
	if( CMPTAIL("") == 0) sprintf(&out[l-2], "ä"); else

	sprintf(&out[l], "Ȥˤ");
}

/* , -> ä꽳ä */
static void jverb3( const char *in , char *out)
{
	int l = strlen(in);
	strcpy(out, in);

	/* ѳʳ */
	if( CMPTAIL("") == 0) sprintf(&out[l-4], ""); else

	/* ʳ */
	if( CMPTAIL("") == 0) sprintf(&out[l-4], ""); else

	/* ʳ */
	if( CMPTAIL("") == 0) sprintf(&out[l-4], ""); else
	if( CMPTAIL("") == 0) sprintf(&out[l-4], ""); else
	if( CMPTAIL("") == 0) sprintf(&out[l-4], ""); else
	if( CMPTAIL("") == 0) sprintf(&out[l-4], ""); else
	if( CMPTAIL("") == 0) sprintf(&out[l-4], ""); else
	if( CMPTAIL("Ƥ") == 0) sprintf(&out[l-4], "Ƥä"); else
	if( CMPTAIL("Ǥ") == 0) sprintf(&out[l-4], "Ǥ"); else
	if( CMPTAIL("ͤ") == 0) sprintf(&out[l-4], "ͤ"); else
	if( CMPTAIL("ؤ") == 0) sprintf(&out[l-4], "ؤ"); else
	if( CMPTAIL("٤") == 0) sprintf(&out[l-4], "٤"); else
	if( CMPTAIL("") == 0) sprintf(&out[l-4], "᤿"); else
	if( CMPTAIL("") == 0) sprintf(&out[l-4], "줿"); else

	/* ʳ */
	if( CMPTAIL("") == 0) sprintf(&out[l-2], "ä"); else
	if( CMPTAIL("") == 0) sprintf(&out[l-2], ""); else
	if( CMPTAIL("") == 0) sprintf(&out[l-2], ""); else
	if( CMPTAIL("") == 0) sprintf(&out[l-2], ""); else
	if( CMPTAIL("") == 0) sprintf(&out[l-2], ""); else
	if( CMPTAIL("") == 0) sprintf(&out[l-2], "ä"); else
	if( CMPTAIL("") == 0) sprintf(&out[l-2], "ä"); else
	if( CMPTAIL("") == 0) sprintf(&out[l-2], "ͤ"); else
	if( CMPTAIL("") == 0) sprintf(&out[l-2], "ؤ"); else
	if( CMPTAIL("") == 0) sprintf(&out[l-2], ""); else
	if( CMPTAIL("") == 0) sprintf(&out[l-2], ""); else
	if( CMPTAIL("") == 0) sprintf(&out[l-2], "ä"); else

	sprintf(&out[l], "Ȥ");
}


void jverb( const char *in , char *out , int flag)
{
  switch (flag)
  {
	  case JVERB_AND: jverb1(in , out); break;
	  case JVERB_TO : jverb2(in , out); break;
	  case JVERB_OR : jverb3(in , out); break;
  }
}

#if 0
static bool iskinsoku(cptr ch)
{
	cptr kinsoku[] =
	{
		"", "", "", "", "", "", "",
			"", "", "", "", "", "", "", 
			"", "", "", "", "", 
			"", "", "", "", "", "", "", "", "",
			"", "", "", "", "", "", "", "", "",
			NULL
	};

	int i;
	
	for (i = 0; kinsoku[i]; i++)
	{
		if (streq(ch, kinsoku[i]))
		{
			return TRUE;
		}
	}
	return FALSE;
}
#endif

/*
 * Convert SJIS string to EUC string
 */
void sjis2euc(char *str)
{
	int i;
	unsigned char c1, c2;
	unsigned char *tmp;

	int len = strlen(str);

	C_MAKE(tmp, len+1, byte);

	for (i = 0; i < len; i++)
	{
		c1 = str[i];
		if (c1 & 0x80)
		{
			i++;
			c2 = str[i];
			if (c2 >= 0x9f)
			{
				c1 = c1 * 2 - (c1 >= 0xe0 ? 0xe0 : 0x60);
				c2 += 2;
			}
			else
			{
				c1 = c1 * 2 - (c1 >= 0xe0 ? 0xe1 : 0x61);
				c2 += 0x60 + (c2 < 0x7f);
			}
			tmp[i - 1] = c1;
			tmp[i] = c2;
		}
		else
			tmp[i] = c1;
	}
	tmp[len] = 0;
	strcpy(str, (char *)tmp);

	C_KILL(tmp, len+1, byte);
}


/*
 * Convert EUC string to SJIS string
 */
void euc2sjis(char *str)
{
	int i;
	unsigned char c1, c2;
	unsigned char *tmp;

	int len = strlen(str);

	C_MAKE(tmp, len+1, byte);

	for (i = 0; i < len; i++)
	{
		c1 = str[i];
		if (c1 & 0x80)
		{
			i++;
			c2 = str[i];
			if (c1 % 2)
			{
				c1 = (c1 >> 1) + (c1 < 0xdf ? 0x31 : 0x71);
				c2 -= 0x60 + (c2 < 0xe0);
			}
			else
			{
				c1 = (c1 >> 1) + (c1 < 0xdf ? 0x30 : 0x70);
				c2 -= 2;
			}

			tmp[i - 1] = c1;
			tmp[i] = c2;
		}
		else
			tmp[i] = c1;
	}
	tmp[len] = 0;
	strcpy(str, (char *)tmp);

	C_KILL(tmp, len+1, byte);
}


/*
 * strĶ˹äʸɤѴѴʸɤ֤
 * strĹ¤Ϥʤ
 *
 * 0: Unknown
 * 1: ASCII (Never known to be ASCII in this function.)
 * 2: EUC
 * 3: SJIS
 */
byte codeconv(char *str)
{
	byte code = 0;
	int i;

	for (i = 0; str[i]; i++)
	{
		unsigned char c1;
		unsigned char c2;

		/* First byte */
		c1 = str[i];

		/* ASCII? */
		if (!(c1 & 0x80)) continue;

		/* Second byte */
		i++;
		c2 = str[i];

		if (((0xa1 <= c1 && c1 <= 0xdf) || (0xfd <= c1 && c1 <= 0xfe)) &&
		    (0xa1 <= c2 && c2 <= 0xfe))
		{
			/* Only EUC is allowed */
			if (!code)
			{
				/* EUC */
				code = 2;
			}

			/* Broken string? */
			else if (code != 2)
			{
				/* No conversion */
				return 0;
			}
		}

		else if (((0x81 <= c1 && c1 <= 0x9f) &&
			  ((0x40 <= c2 && c2 <= 0x7e) || (0x80 <= c2 && c2 <= 0xfc))) ||
			 ((0xe0 <= c1 && c1 <= 0xfc) &&
			  (0x40 <= c2 && c2 <= 0x7e)))
		{
			/* Only SJIS is allowed */
			if (!code)
			{
				/* SJIS */
				code = 3;
			}

			/* Broken string? */
			else if (code != 3)
			{
				/* No conversion */
				return 0;
			}
		}
	}


	switch (code)
	{
#ifdef EUC
	case 3:
		/* SJIS -> EUC */
		sjis2euc(str);
		break;
#endif

#ifdef SJIS
	case 2:
		/* EUC -> SJIS */
		euc2sjis(str);

		break;
#endif
	}

	/* Return kanji code */
	return code;
}

#endif
