/* File: defines.h */

/* Purpose: global constants and macro definitions */


/*
 * Do not edit this file unless you know *exactly* what you are doing.
 *
 * Some of the values in this file were chosen to preserve game balance,
 * while others are hard-coded based on the format of old save-files, the
 * definition of arrays in various places, mathematical properties, fast
 * computation, storage limits, or the format of external text files.
 *
 * Changing some of these values will induce crashes or memory errors or
 * savefile mis-reads.  Most of the comments in this file are meant as
 * reminders, not complete descriptions, and even a complete knowledge
 * of the source may not be sufficient to fully understand the effects
 * of changing certain definitions.
 *
 * Lastly, note that the code does not always use the symbolic constants
 * below, and sometimes uses various hard-coded values that may not even
 * be defined in this file, but which may be related to definitions here.
 * This is of course bad programming practice, but nobody is perfect...
 *
 * For example, there are MANY things that depend on the screen being
 * 80x24, with the top line used for messages, the bottom line being
 * used for status, and exactly 22 lines used to show the dungeon.
 * Just because your screen can hold 46 lines does not mean that the
 * game will work if you try to use 44 lines to show the dungeon.
 *
 * You have been warned.
 */


/*
 * Name of the version/variant
 */
#define VERSION_NAME "TinyAngband"


/*
 * Current version number of TinyAngband
 */
#define VERSION_MAJOR   0
#define VERSION_MINOR   0
#define VERSION_PATCH   3

#define SAVEFILE_VERSION 5

#define TINYANGBAND

/*
 * This value is not currently used
 */
#define VERSION_EXTRA   0

/*
 * Number of grids in each block (vertically)
 * Probably hard-coded to 11, see "generate.c"
 */
#define BLOCK_HGT	11

/*
 * Number of grids in each block (horizontally)
 * Probably hard-coded to 11, see "generate.c"
 */
#define BLOCK_WID	11


/*
 * Number of grids in each panel (vertically)
 * Must be a multiple of BLOCK_HGT
 */
#define PANEL_HGT	11

/*
 * Number of grids in each panel (horizontally)
 * Must be a multiple of BLOCK_WID
 */
#define PANEL_WID	33


/*
 * Number of grids used to display the dungeon (vertically).
 * Must be a multiple of 11, probably hard-coded to 22.
 */
#define SCREEN_HGT      22

/*
 * Number of grids used to display the dungeon (horizontally).
 * Must be a multiple of 33, probably hard-coded to 66.
 */
#define SCREEN_WID      66


/*
 * Maximum dungeon height in grids, must be a multiple of SCREEN_HGT,
 * probably hard-coded to SCREEN_HGT * 3.
 */
#define MAX_HGT         66

/*
 * Maximum dungeon width in grids, must be a multiple of SCREEN_WID,
 * probably hard-coded to SCREEN_WID * 3.
 */
#define MAX_WID         198


/*
 * Quest constants
 */
#define MAX_MON_QUEST       10
#define MAX_ITEM_QUEST       5

#define MIN_RANDOM_QUEST    40
#define MAX_RANDOM_QUEST    44

#define QUEST_SAURON         1
#define QUEST_MORGOTH        2

/*
 * Arena constants
 */
#define MAX_ARENA_MONS		29	/* -KMW- */


/*
 * Total number of stores (see "store.c", etc)
 */
#define MAX_STORES      9

/*
 * Number of buildings
 */
#define MAX_BLDG		32

/* Dungeon town code */
#define TOWN_DUNGEON    (max_towns - 1)

/*
 * Total number of stores (see "store.c", etc)
 */
#define MAX_STORES_PER_TOWN 12
#define MAX_STORE_TYPES      9

#define STORE_GENERAL   0
#define STORE_ARMOURY   1
#define STORE_WEAPON    2
#define STORE_TEMPLE    3
#define STORE_ALCHEMIST 4
#define STORE_MAGIC     5
#define STORE_BLACK     6
#define STORE_HOME      7
#define STORE_STATUE    8


#define BUILDING_NON_MEMBER 0
#define BUILDING_MEMBER     1
#define BUILDING_OWNER      2

/*
 * Total number of owners per store (see "store.c", etc)
 */
#define MAX_OWNERS      32

/*
 * Maximum number of player "sex" types (see "table.c", etc)
 */
#define MAX_SEXES            2

/* Number of entries in the sanity-blast descriptions */
#define MAX_SAN_HORROR 20
#define MAX_SAN_FUNNY 22
#define MAX_SAN_COMMENT 5

/* Chaos mutations */

/* "Activatable" mutations must be in MUT1_* */
/* Randomly activating mutations must be MUT2_* */
/* --- Removed --- */

#define MUT_BERS_RAGE                   0x00000001L /* Random berserk */
#define MUT_COWARDICE                   0x00000002L /* Random fear */
#define MUT_HALLU                       0x00000004L /* Random hullutination */
#define MUT_NORMALITY                   0x00000008L /* Cure mutations */
#define MUT_WASTING                     0x00000010L /* Wasting desease */
#define MUT_WARNING                     0x00000020L /* Feel dangers by monsters */
#define MUT_HYPER_STR                   0x00000040L /* STR +4 */
#define MUT_PUNY                        0x00000080L /* STR -4 */
#define MUT_HYPER_INT                   0x00000100L /* INT & WIS +4 */
#define MUT_MORONIC                     0x00000200L /* INT & WIS -4 */
#define MUT_LIMBER                      0x00000400L /* DEX +3 */
#define MUT_ARTHRITIS                   0x00000800L /* DEX -3 */
#define MUT_MOTION                      0x00001000L /* DEX +1, FreeAct */
#define MUT_RESILIENT                   0x00002000L /* CON +4 */
#define MUT_XTRA_FAT                    0x00004000L /* CON +2, SPD -2 */
#define MUT_ALBINO                      0x00008000L /* CON -4 */
#define MUT_FLESH_ROT                   0x00010000L /* CON -2, CHR -1, NO-REGEN*/
#define MUT_SILLY_VOI                   0x00020000L /* CHR -4 */
#define MUT_ILL_NORM                    0x00040000L /* Extra CHR */
#define MUT_XTRA_EYES                   0x00080000L /* Fos & Srh +15 */
#define MUT_XTRA_LEGS                   0x00100000L /* Spd +3 */
#define MUT_SHORT_LEG                   0x00200000L /* Spd -3 */
#define MUT_SCALES                      0x00400000L /* CHR -1, AC +10 */
#define MUT_IRON_SKIN                   0x00800000L /* DEX -1, AC +25 */
#define MUT_ELEC_TOUC                   0x01000000L /* Aula Elec */
#define MUT_FIRE_BODY                   0x02000000L /* Aula Fire */
#define MUT_VULN_ELEM                   0x04000000L /* Double damaged by Elements */
#define MUT_FEARLESS                    0x08000000L /* Res Fear */
#define MUT_RES_TIME                    0x10000000L /* Res Time */
#define MUT_WINGS                       0x20000000L /* Lavitation */
#define MUT_REGEN                       0x40000000L /* Regeneration */
#define MUT_ESP                         0x80000000L /* Telepathy */

/* Monk martial arts... */
# define MAX_MA 17
# define MA_KNEE 1
# define MA_SLOW 2

/* Elementalist */
#define MAX_ELEMENTS 8
/* #define MAX_ELEMENT_POWERS 8 */
#define ELEMENT_REALM_FIRE     0
#define ELEMENT_REALM_ICE      1
#define ELEMENT_REALM_SKY      2
#define ELEMENT_REALM_SEA      3
#define ELEMENT_REALM_DARKNESS 4
#define ELEMENT_REALM_CHAOS    5
#define ELEMENT_REALM_EARTH    6
#define ELEMENT_REALM_DEATH    7

#ifndef JP
/* Hallucination stuff */
#define MAX_SILLY_ATTACK 28
#endif

/* A hack for cave.c */
#define BMP_FIRST_PC_CLASS 164
#define BMP_FIRST_PC_RACE 128


/*
 * Size of memory reserved for initialization of some arrays
 */
#define FAKE_NAME_SIZE  40 * 1024L
#define FAKE_TEXT_SIZE 120 * 1024L


/*
 * Maximum number of high scores in the high score file
 */
#define MAX_HISCORES    100


/*
 * Maximum dungeon level.  The player can never reach this level
 * in the dungeon, and this value is used for various calculations
 * involving object and monster creation.  It must be at least 100.
 * Setting it below 128 may prevent the creation of some objects.
 */
#define MAX_DEPTH       128
#ifdef TINYANGBAND
#define TINY_MAX_DEPTH   40
#define MORGOTH_DEPTH    27
#endif


/*
 * Maximum size of the "lite" array (see "cave.c")
 * Note that the "lite radius" will NEVER exceed 14, and we would
 * never require more than 581 entries in the array for circular "lite".
 */
#define LITE_MAX 600

/*
 * Maximum size of the "mon_lite" array (see "cave.c")
 * Note that the "view radius" will NEVER exceed 20, monster illumination
 * flags are dependent on CAVE_VIEW, and even if the "view" was octagonal,
 * we would never require more than 1520 entries in the array.
 */
#define MON_LITE_MAX 1536

/*
 * Maximum size of the "view" array (see "cave.c")
 * Note that the "view radius" will NEVER exceed 20, and even if the "view"
 * was octagonal, we would never require more than 1520 entries in the array.
 */
#define VIEW_MAX 1536

/*
 * Maximum size of the "temp" array (see "cave.c")
 * We must be as large as "VIEW_MAX" and "LITE_MAX" for proper functioning
 * of "update_view()" and "update_lite()".  We must also be as large as the
 * largest illuminatable room, but no room is larger than 800 grids.  We
 * must also be large enough to allow "good enough" use as a circular queue,
 * to calculate monster flow, but note that the flow code is "paranoid".
 */
#define TEMP_MAX 2298


/*
 * Number of keymap modes
 */
#define KEYMAP_MODES	2

/*
 * Mode for original keyset commands
 */
#define KEYMAP_MODE_ORIG	0

/*
 * Mode for roguelike keyset commands
 */
#define KEYMAP_MODE_ROGUE	1


/*
 * OPTION: Maximum number of macros (see "io.c")
 * Default: assume at most 256 macros are used
 */
#define MACRO_MAX       256

/*
 * OPTION: Maximum number of "quarks" (see "io.c")
 * Default: assume at most 512 different inscriptions are used
 */
#define QUARK_MAX       768
/* Was 512... 256 quarks added for random artifacts */

/*
 * OPTION: Maximum number of messages to remember (see "io.c")
 * Default: assume maximal memorization of 2048 total messages
 */
#define MESSAGE_MAX     2048

/*
 * OPTION: Maximum space for the message text buffer (see "io.c")
 * Default: assume that each of the 2048 messages is repeated an
 * average of three times, and has an average length of 48
 */
#define MESSAGE_BUF     32768


/*
 * Maximum value storable in a "byte" (hard-coded)
 */
#define MAX_UCHAR       255

/*
 * Maximum value storable in a "s16b" (hard-coded)
 */
#define MAX_SHORT       32767

/*
 * Maximum length of object's name
 */
#define MAX_NLEN        160

/*
 * Special internal key
 */
#define SPECIAL_KEY_QUEST    255
#define SPECIAL_KEY_BUILDING 254
#define SPECIAL_KEY_STORE    253
#define SPECIAL_KEY_QUIT     252

/*
 * Store constants
 */
#define STORE_INVEN_MAX 24              /* Max number of discrete objs in inven */
#define STORE_CHOICES   24              /* Number of items to choose stock from */
#define STORE_OBJ_LEVEL 5               /* Magic Level for normal stores */
#define STORE_TURNOVER  9               /* Normal shop turnover, per day */
#define STORE_MIN_KEEP  6               /* Min slots to "always" keep full */
#define STORE_MAX_KEEP  18              /* Max slots to "always" keep full */
#define STORE_SHUFFLE   21              /* 1/Chance (per day) of an owner changing */
#define STORE_TURNS             1000    /* Number of turns between turnovers */

/*
 * Random energy
 */
#define ENERGY_NEED() (randnor(100, 25))

/*
 * Misc constants
 */
#define TOWN_DAWN               10000   /* Number of turns from dawn to dawn XXX */
#define BREAK_GLYPH             550             /* Rune of protection resistance */
#define BREAK_MINOR_GLYPH       99             /* For explosive runes */
#define BTH_PLUS_ADJ    3               /* Adjust BTH per plus-to-hit */
#define MON_MULT_ADJ    8               /* High value slows multiplication */
#define MON_SUMMON_ADJ  2               /* Adjust level of summoned creatures */
#define MON_DRAIN_LIFE  2               /* Percent of player exp drained per hit */
#define USE_DEVICE      3               /* x> Harder devices x< Easier devices     */


/* "Biases" for random artifact gen */

#define BIAS_ELEC            1
#define BIAS_POIS            2
#define BIAS_FIRE            3
#define BIAS_COLD            4
#define BIAS_ACID            5
#define BIAS_STR             6
#define BIAS_INT             7
#define BIAS_WIS             8
#define BIAS_DEX             9
#define BIAS_CON            10
#define BIAS_CHR            11
#define BIAS_CHAOS          12
#define BIAS_PRIESTLY       13
#define BIAS_NECROMANTIC    14
#define BIAS_LAW            15
#define BIAS_ROGUE          16
#define BIAS_MAGE           17
#define BIAS_WARRIOR        18
#define BIAS_RANGER         19


/*** Pet constants ***/


/*
 * Commands
 */
#define PET_DISMISS					1
#define PET_STAY_CLOSE				2
#define PET_FOLLOW_ME				3
#define PET_SEEK_AND_DESTROY		4
#define PET_ALLOW_SPACE				5
#define PET_STAY_AWAY				6
#define PET_OPEN_DOORS           7
#define PET_TAKE_ITEMS				8

/*
 * Follow distances
 */
#define PET_CLOSE_DIST				1
#define PET_FOLLOW_DIST				6
#define PET_SEEK_DIST				10
#define PET_DESTROY_DIST			255
#define PET_SPACE_DIST				(-10)
#define PET_AWAY_DIST				(-25)


/*
 * There is a 1/20 (5%) chance of inflating the requested object_level
 * during the creation of an object (see "get_obj_num()" in "object.c").
 * Lower values yield better objects more often.
 */
#define GREAT_OBJ       20

/*
 * There is a 1/50 (2%) chance of inflating the requested monster_level
 * during the creation of a monsters (see "get_mon_num()" in "monster.c").
 * Lower values yield harder monsters more often.
 */
#define NASTY_MON       50              /* 1/chance of inflated monster level */

/* 1/x chance of hurting even if invulnerable! */
#define PENETRATE_INVULNERABILITY 13



/*
 * Refueling constants
 */
#define FUEL_TORCH      5000    /* Maximum amount of fuel in a torch */
#define FUEL_LAMP       15000   /* Maximum amount of fuel in a lantern */


/*
 * More maximum values
 */
#define MAX_SIGHT       20      /* Maximum view distance */
#define MAX_RANGE       18      /* Maximum range (spells, etc) */



/*
 * There is a 1/160 chance per round of creating a new monster
 */
#define MAX_M_ALLOC_CHANCE      160

/*
 * Normal levels get at least 14 monsters
 */
#define MIN_M_ALLOC_LEVEL       14

/*
 * The town starts out with 4 residents during the day
 */
#define MIN_M_ALLOC_TD          4

/*
 * The town starts out with 8 residents during the night
 */
#define MIN_M_ALLOC_TN          8


/*
 * A monster can only "multiply" (reproduce) if there are fewer than 100
 * monsters on the level capable of such spontaneous reproduction.  This
 * is a hack which prevents the "m_list[]" array from exploding due to
 * reproducing monsters.  Messy, but necessary.
 */
#define MAX_REPRO       100


/*
 * Player constants
 */
#define PY_MAX_EXP      99999999L       /* Maximum exp */
#define PY_MAX_GOLD     999999999L      /* Maximum gold */
#define PY_MAX_LEVEL    50              /* Maximum level */

/*
 * Player "food" crucial values
 */
#define PY_FOOD_MAX             15000   /* Food value (Bloated) */
#define PY_FOOD_FULL    10000   /* Food value (Normal) */
#define PY_FOOD_ALERT   2000    /* Food value (Hungry) */
#define PY_FOOD_WEAK    1000    /* Food value (Weak) */
#define PY_FOOD_FAINT   500             /* Food value (Fainting) */
#define PY_FOOD_STARVE  100             /* Food value (Starving) */

/*
 * Player regeneration constants
 */
#define PY_REGEN_NORMAL         197             /* Regen factor*2^16 when full */
#define PY_REGEN_WEAK           98              /* Regen factor*2^16 when weak */
#define PY_REGEN_FAINT          33              /* Regen factor*2^16 when fainting */
#define PY_REGEN_HPBASE         1442    /* Min amount hp regen*2^16 */
#define PY_REGEN_MNBASE         524             /* Min amount mana regen*2^16 */

/*
 * Possible realms that can be chosen;
 * currently used only by birth.c and tables.c
 */
#define CH_NONE         0x00
#define CH_LIFE         0x01
#define CH_SORCERY      0x02


/*
 * Magic realms
 */
#define REALM_NONE         0
#define REALM_LIFE         1
#define REALM_SORCERY      2
#define MAX_REALM          2

/*
 * Magic-books for the realms
 */
#define REALM1_BOOK     ((realm_choices1[p_ptr->pclass] ? p_ptr->realm1 : 0) + TV_LIFE_BOOK - 1)
#if 0
#define REALM2_BOOK     (p_ptr->realm2 + TV_LIFE_BOOK - 1)
#endif

/*
 * Spell type
 */
#define ST_NONE            0
#define ST_SPELL           1
#define ST_PRAYER          2
#define ST_OTHER           3

/* Spell number */
#define MAX_SPELLS         16

/*
 * Maximum number of "normal" pack slots, and the index of the "overflow"
 * slot, which can hold an item, but only temporarily, since it causes the
 * pack to "overflow", dropping the "last" item onto the ground.  Since this
 * value is used as an actual slot, it must be less than "INVEN_WIELD" (below).
 * Note that "INVEN_PACK" is probably hard-coded by its use in savefiles, and
 * by the fact that the screen can only show 23 items plus a one-line prompt.
 */
#define INVEN_PACK              23

/*
 * Indexes used for various "equipment" slots (hard-coded by savefiles, etc).
 */
#define INVEN_WIELD     24
#define INVEN_ARM       25
#define INVEN_BOW       26
#define INVEN_RIGHT     27
#define INVEN_LEFT      28
#define INVEN_NECK      29
#define INVEN_LITE      30
#define INVEN_BODY      31
#define INVEN_OUTER     32
#define INVEN_HEAD      33
#define INVEN_HANDS     34
#define INVEN_FEET      35

/*
 * used for get_random_ego()
 */
#define INVEN_AMMO     23
#define INVEN_DIGGING  36

/*
 * Total number of inventory slots (hard-coded).
 */
#define INVEN_TOTAL     36



/*
 * Indexes of the various "stats" (hard-coded by savefiles, etc).
 */
#define A_STR   0
#define A_INT   1
#define A_WIS   2
#define A_DEX   3
#define A_CON   4
#define A_CHR   5

/*
 * Total number of stats.
 */
#define A_MAX	6


/*
 * Player sex constants (hard-coded by save-files, arrays, etc)
 */
#define SEX_FEMALE              0
#define SEX_MALE                1


/*
 * Player race constants (hard-coded by save-files, arrays, etc)
 */
#define RACE_HUMAN               0
#define RACE_HALF_ELF            1
#define RACE_ELF                 2
#define RACE_HOBBIT              3
#define RACE_DWARF               4
#define RACE_HALF_ORC            5
#define RACE_DUNADAN             6
#define RACE_HIGH_ELF            7
#define RACE_BARBARIAN           8

/*
 * Maximum number of player "race" types (see "table.c", etc)
 */
#define MAX_RACES               9

/*
 * Check the race is undead.
 */
#define is_undead() \
	((p_ptr->prace == RACE_SKELETON) || \
	 (p_ptr->prace == RACE_ZOMBIE) || \
	 (p_ptr->prace == RACE_VAMPIRE) || \
	 (p_ptr->prace == RACE_SPECTRE))

/*
 * Player class constants (hard-coded by save-files, arrays, etc)
 */
#define CLASS_WARRIOR            0
#define CLASS_MAGE               1
#define CLASS_PRIEST             2
#define CLASS_ARCHER             3
#define CLASS_PALADIN            4
#define CLASS_WARRIOR_MAGE       5

/*
 * Maximum number of player "class" types (see "table.c", etc)
 */
#define MAX_CLASS            6

/*** Screen Locations ***/

/*
 * Some screen locations for various display routines
 * Currently, row 8 and 15 are the only "blank" rows.
 * That leaves a "border" around the "stat" values.
 */

#define ROW_RACE                1
#define COL_RACE                0       /* <race name> */

#define ROW_CLASS               2
#define COL_CLASS               0       /* <class name> */

#define ROW_TITLE               3
#define COL_TITLE               0       /* <title> or <mode> */

#define ROW_LEVEL               4
#define COL_LEVEL               0       /* "LEVEL xxxxxx" */

#define ROW_EXP                 5
#define COL_EXP                 0       /* "EXP xxxxxxxx" */

#define ROW_GOLD                6
#define COL_GOLD                0       /* "AU xxxxxxxxx" */

#define ROW_EQUIPPY             7
#define COL_EQUIPPY             0       /* equippy chars */

#define ROW_STAT                8
#define COL_STAT                0       /* "xxx   xxxxxx" */

#define ROW_AC                  15
#define COL_AC                  0       /* "Cur AC xxxxx" */

#define ROW_CURHP               16
#define COL_CURHP               0       /* "Cur HP xxxxx" */

#define ROW_CURSP               17
#define COL_CURSP               0       /* "Cur SP xxxxx" */

#define ROW_INFO                18
#define COL_INFO                0       /* "xxxxxxxxxxxx" */

#define ROW_MAP						0
#define COL_MAP                  12

#define ROW_CUT                 19
#define COL_CUT                 0       /* <cut> */

#define ROW_STUN                20
#define COL_STUN                0       /* <stun> */

#define ROW_HUNGRY              21
#define COL_HUNGRY              0       /* "Weak" / "Hungry" / "Full" / "Gorged" */

#define ROW_STATE               21
#define COL_STATE               7       /* <state> */

#define ROW_DAY                 22
#define COL_DAY                 0       /* day */

#define ROW_SPEED               (-1)
#define COL_SPEED               (-30)   /* "Slow (-NN)" or "Fast (+NN)" */

#define ROW_STUDY               (-1)
#define COL_STUDY               (-19)    /* "Study" */

#define ROW_DEPTH               (-1)
#define COL_DEPTH               (-13)   /* "Lev NNN" / "NNNN ft" */

#define ROW_STATBAR             (-1)
#define COL_STATBAR             0       /* "Status bar" */
#define MAX_COL_STATBAR         (-32)


/*** Terrain Feature Indexes (see "lib/edit/f_info.txt") ***/

/* Nothing */
#define FEAT_NONE               0x00

/* Various */
#define FEAT_FLOOR              0x01
#define FEAT_INVIS              0x02
#define FEAT_GLYPH              0x03
#define FEAT_OPEN               0x04
#define FEAT_BROKEN             0x05
#define FEAT_LESS               0x06
#define FEAT_MORE               0x07

/* Quest features -KMW- */
#define FEAT_QUEST_ENTER		0x08
#define FEAT_QUEST_EXIT			0x09
#define FEAT_QUEST_DOWN			0x0A
#define FEAT_QUEST_UP			0x0B

#define FEAT_LESS_LESS          0x0D
#define FEAT_MORE_MORE          0x0E

/* Feature 0x0C - 0x0F unused */

/* Traps */
#define FEAT_TRAP_TRAPDOOR      0x10
#define FEAT_TRAP_PIT           0x11
#define FEAT_TRAP_SPIKED_PIT    0x12
#define FEAT_TRAP_POISON_PIT    0x13
#define FEAT_TRAP_TY_CURSE      0x14
#define FEAT_TRAP_TELEPORT      0x15
#define FEAT_TRAP_FIRE          0x16
#define FEAT_TRAP_ACID          0x17
#define FEAT_TRAP_SLOW          0x18
#define FEAT_TRAP_LOSE_STR      0x19
#define FEAT_TRAP_LOSE_DEX      0x1A
#define FEAT_TRAP_LOSE_CON      0x1B
#define FEAT_TRAP_BLIND         0x1C
#define FEAT_TRAP_CONFUSE       0x1D
#define FEAT_TRAP_POISON        0x1E
#define FEAT_TRAP_SLEEP         0x1F

/* Doors */
#define FEAT_DOOR_HEAD          0x20
#define FEAT_DOOR_TAIL          0x2F

/* Extra */
#define FEAT_SECRET             0x30
#define FEAT_RUBBLE             0x31

/* Seams */
#define FEAT_MAGMA              0x32
#define FEAT_QUARTZ             0x33
#define FEAT_MAGMA_H            0x34
#define FEAT_QUARTZ_H           0x35
#define FEAT_MAGMA_K            0x36
#define FEAT_QUARTZ_K           0x37

/* Walls */
#define FEAT_WALL_EXTRA         0x38
#define FEAT_WALL_INNER         0x39
#define FEAT_WALL_OUTER         0x3A
#define FEAT_WALL_SOLID         0x3B
#define FEAT_PERM_EXTRA         0x3C
#define FEAT_PERM_INNER         0x3D
#define FEAT_PERM_OUTER         0x3E
#define FEAT_PERM_SOLID         0x3F

/* Glyph */
#define FEAT_MINOR_GLYPH        0x40

/* Pattern */
#define FEAT_PATTERN_START      0x41
#define FEAT_PATTERN_1          0x42
#define FEAT_PATTERN_2          0x43
#define FEAT_PATTERN_3          0x44
#define FEAT_PATTERN_4          0x45
#define FEAT_PATTERN_END        0x46
#define FEAT_PATTERN_OLD        0x47
#define FEAT_PATTERN_XTRA1      0x48
#define FEAT_PATTERN_XTRA2      0x49

/* Shops */
#define FEAT_SHOP_HEAD          0x4A
#define FEAT_SHOP_TAIL          0x52

/* Terrains */
#define FEAT_DEEP_WATER         0x53
#define FEAT_SHAL_WATER         0x54
#define FEAT_DEEP_LAVA          0x55
#define FEAT_SHAL_LAVA          0x56
#define FEAT_DARK_PIT           0x57
#define FEAT_DIRT               0x58
#define FEAT_GRASS              0x59

#define FEAT_TRAP_TRAPS         0x5A

#define FEAT_WALL_INVIS         0x5B

#define FEAT_UNDETECTED         0x5C

/* Feature 0x5A - 0x5F unused */

/* Terrain */
#define FEAT_TREES              0x60
#define FEAT_MOUNTAIN           0x61

/* Feature 0x62 - 0x7F unused */

/* Buildings */
#define FEAT_BLDG_HEAD          0x80
#define FEAT_BLDG_TAIL          0x9F



/*
 * Wilderness terrains
 */
#define TERRAIN_EDGE             0 /* Edge of the World */
#define TERRAIN_TOWN             1 /* Town */
#define TERRAIN_DEEP_WATER       2 /* Deep water */
#define TERRAIN_SHALLOW_WATER    3 /* Shallow water */
#define TERRAIN_SWAMP            4 /* Swamp */
#define TERRAIN_DIRT             5 /* Dirt */
#define TERRAIN_GRASS            6 /* Grass */
#define TERRAIN_TREES            7 /* Trees */
#define TERRAIN_DESERT           8 /* Desert */
#define TERRAIN_SHALLOW_LAVA     9 /* Shallow lava */
#define TERRAIN_DEEP_LAVA       10 /* Deep lava */
#define TERRAIN_MOUNTAIN        11 /* Mountain */

#define MAX_WILDERNESS          12 /* Maximum wilderness index */


/* Lighting levels of features' attr and char */

#define F_LIT_STANDARD 0 /* Standard */
#define F_LIT_LITE     1 /* Brightly lit */
#define F_LIT_DARK     2 /* Darkened */

#define F_LIT_NS_BEGIN 1 /* Nonstandard */
#define F_LIT_MAX      3


/*** Artifact indexes (see "lib/edit/a_info.txt") ***/

/* Lites */
#define ART_ELENDIL             2
#define ART_JUDGE               3
#define ART_PALANTIR            4

/* Amulets */
/* Nothing for Macros */

/* Rings */
#define ART_POWER               16

/* Dragon Scale */
/* Now dragon scales are not exist. */

/* Hard Armour */
#define ART_CELEBORN            19

/* Soft Armour */
#define ART_INCANUS             22

/* Shields */
#define ART_GIL_GALAD           27

/* Helms and Crowns */
#define ART_CHAOS               28
#define ART_NUMENOR             31

/* Cloaks */
#define ART_HOLCOLLETH          40

/* Gloves */
#define ART_FINGOLFIN           50

/* Boots */
/* Nothing for macro */

/* Swords */
/* Nothing for macro */

/* Polearms */
#define ART_HURIN               81

/* Hafted */
#define ART_GROND               86
#define ART_GOTHMOG             87

/* Mattocks */
#define ART_NAIN                95

/* Bows */
#define ART_BARD                98
#define ART_BRAND               99

/* Arrows */
#define ART_BARD_ARROW          100


/*** Ego-Item indexes (see "lib/edit/e_info.txt") ***/

/* Nothing */
#define EGO_SHATTERED           1
#define EGO_BLASTED             2

/* Body Armor */
#define EGO_RESISTANCE          7
#define EGO_PERMANENCE          9

/* Shields */
#define EGO_ENDURANCE           14

/* Crowns and Helms */
#define EGO_MAGI                17
#define EGO_MIGHT               18
#define EGO_LORDLINESS          19
#define EGO_TELEPATHY           20
#define EGO_ANCIENT_CURSE       21
#define EGO_INTELLIGENCE        22
#define EGO_WISDOM              23
#define EGO_BEAUTY              24
#define EGO_SEEING              25
#define EGO_PROTECT_HELM        26
#define EGO_TELEPORTATION       27
#define EGO_FOOL                28
#define EGO_SICKLINESS          29

/* Cloaks */
/* Nothing for macro */

/* Gloves */
/* Nothing for macro */

/* Boots */
#define EGO_LEVITATION          45

/* Diggings */
#define EGO_DIGGING             52
#define EGO_DISRUPTION          53

/* Weapons */
#define EGO_HA                  54
#define EGO_DF                  55
#define EGO_WEST                57
#define EGO_ATTACKS             58
#define EGO_SLAYING_WEAPON      59
#define EGO_BRAND_ACID          60
#define EGO_BRAND_ELEC          61
#define EGO_BRAND_FIRE          62
#define EGO_BRAND_COLD          63
#define EGO_BRAND_POIS          64
#define EGO_SHARPNESS           65
#define EGO_EARTHQUAKES         66
#define EGO_SLAY_DRAGON         74
#define EGO_WEAP_LITE           78
#define EGO_PATTERN             82

/* Cursed weapons */
#define EGO_MORGUL              83
#define EGO_WEIRD               84

/* Bows */
#define EGO_ACCURACY            85
#define EGO_VELOCITY            86

/* Ammo */
#define EGO_FLAME               93
#define EGO_BACKBITING          95

/* Activation effects for random artifacts */
#define ACT_SUNLIGHT            1
#define ACT_BO_MISS_1           2
#define ACT_BA_POIS_1           3
#define ACT_BO_ELEC_1           4
#define ACT_BO_ACID_1           5
#define ACT_BO_COLD_1           6
#define ACT_BO_FIRE_1           7
#define ACT_BA_COLD_1           8
#define ACT_BA_FIRE_1           9
#define ACT_DRAIN_1             10
#define ACT_BA_COLD_2           11
#define ACT_BA_ELEC_2           12
#define ACT_DRAIN_2             13
#define ACT_VAMPIRE_1           14
#define ACT_BO_MISS_2           15
#define ACT_BA_FIRE_2           16
#define ACT_BA_COLD_3           17
#define ACT_BA_ELEC_3           18
#define ACT_WHIRLWIND           19
#define ACT_VAMPIRE_2           20
#define ACT_CALL_CHAOS          21
#define ACT_ROCKET              22
#define ACT_DISP_EVIL           23
#define ACT_BA_MISS_3           24
#define ACT_DISP_GOOD           25
#define ACT_PESTICIDE           26
/* 27 - 49 unused */
#define ACT_FEAR                50
#define ACT_CONFUSE             51
#define ACT_SLEEP               52
#define ACT_QUAKE               53
#define ACT_TERROR              54
#define ACT_TELE_AWAY           55
#define ACT_BANISH_EVIL         56
#define ACT_GENOCIDE            57
#define ACT_MASS_GENO           58
/* 59 - 64 unused */
#define ACT_CHARM_ANIMAL        65
#define ACT_CHARM_UNDEAD        66
#define ACT_CHARM_OTHER         67
#define ACT_CHARM_ANIMALS       68
#define ACT_CHARM_OTHERS        69
#define ACT_SUMMON_ANIMAL       70
#define ACT_SUMMON_PHANTOM      71
#define ACT_SUMMON_ELEMENTAL    72
#define ACT_SUMMON_DEMON        73
#define ACT_SUMMON_UNDEAD       74
/* 75 - 80 unused */
#define ACT_CURE_LW             81
#define ACT_CURE_MW             82
#define ACT_CURE_POISON         83
#define ACT_REST_LIFE           84
#define ACT_REST_ALL            85
#define ACT_CURE_700            86
#define ACT_CURE_1000           87
#define ACT_CURING              88
/* 89 - 90 unused */
#define ACT_ESP                 91
#define ACT_BERSERK             92
#define ACT_PROT_EVIL           93
#define ACT_RESIST_ALL          94
#define ACT_SPEED               95
#define ACT_XTRA_SPEED          96
#define ACT_WRAITH              97
#define ACT_INVULN              98
/* 99 - 110 unused */
#define ACT_LIGHT               111
#define ACT_MAP_LIGHT           112
#define ACT_DETECT_ALL          113
#define ACT_DETECT_XTRA         114
#define ACT_ID_FULL             115
#define ACT_ID_PLAIN            116
#define ACT_RUNE_EXPLO          117
#define ACT_RUNE_PROT           118
#define ACT_SATIATE             119
#define ACT_DEST_DOOR           120
#define ACT_STONE_MUD           121
#define ACT_RECHARGE            122
#define ACT_ALCHEMY             123
#define ACT_DIM_DOOR            124
#define ACT_TELEPORT            125
#define ACT_RECALL              126
/* 127 -> unused */

/*** Object "tval" and "sval" codes ***/


/*
 * The values for the "tval" field of various objects.
 *
 * This value is the primary means by which items are sorted in the
 * player inventory, followed by "sval" and "cost".
 *
 * Note that a "BOW" with tval = 19 and sval S = 10*N+P takes a missile
 * weapon with tval = 16+N, and does (xP) damage when so combined.  This
 * fact is not actually used in the source, but it kind of interesting.
 *
 * Note that as of 2.7.8, the "item flags" apply to all items, though
 * only armor and weapons and a few other items use any of these flags.
 */

#define TV_SKELETON      1      /* Skeletons ('s'), not specified */
#define TV_BOTTLE        2      /* Empty bottles ('!') */
#define TV_JUNK          3      /* Sticks, Pottery, etc ('~') */
#define TV_SPIKE         5      /* Spikes ('~') */
#define TV_CHEST         7      /* Chests ('~') */
#define TV_FIGURINE      8      /* Magical figurines */
#define TV_STATUE        9      /* Statue, what a silly object... */
#define TV_CORPSE       10      /* Corpses and Skeletons, specific */
#define TV_SHOT         16      /* Ammo for slings */
#define TV_ARROW        17      /* Ammo for bows */
#define TV_BOLT         18      /* Ammo for x-bows */
#define TV_BOW          19      /* Slings/Bows/Xbows */
#define TV_DIGGING      20      /* Shovels/Picks */
#define TV_HAFTED       21      /* Priest Weapons */
#define TV_POLEARM      22      /* Axes and Pikes */
#define TV_SWORD        23      /* Edged Weapons */
#define TV_BOOTS        30      /* Boots */
#define TV_GLOVES       31      /* Gloves */
#define TV_HELM         32      /* Helms */
#define TV_CROWN        33      /* Crowns */
#define TV_SHIELD       34      /* Shields */
#define TV_CLOAK        35      /* Cloaks */
#define TV_SOFT_ARMOR   36      /* Soft Armor */
#define TV_HARD_ARMOR   37      /* Hard Armor */
#define TV_DRAG_ARMOR   38      /* Dragon Scale Mail */
#define TV_LITE         39      /* Lites (including Specials) */
#define TV_AMULET       40      /* Amulets (including Specials) */
#define TV_RING         45      /* Rings (including Specials) */
#define TV_STAFF        55
#define TV_WAND         65
#define TV_ROD          66
#define TV_SCROLL       70
#define TV_POTION       75
#define TV_FLASK        77
#define TV_FOOD         80
#define TV_LIFE_BOOK    90
#define TV_SORCERY_BOOK 91
#define TV_GOLD         100     /* Gold can only be picked up by players */

/* Any subvalue */
#define SV_ANY 					255

/* The "sval" codes for TV_FIGURINE */
#define SV_FIGURINE_NORMAL		0

/* The "sval" codes for TV_STATUE */
#define SV_WOODEN_STATUE		0
#define SV_CLAY_STATUE			1
#define SV_STONE_STATUE			2
#define SV_IRON_STATUE			3
#define SV_COPPER_STATUE		4
#define SV_SILVER_STATUE		5
#define SV_GOLDEN_STATUE		6
#define SV_IVORY_STATUE			7
#define SV_MITHRIL_STATUE		8
#define SV_ORNATE_STATUE		9

/* The "sval" codes for TV_CORPSE */
#define SV_SKELETON 				0
#define SV_CORPSE					1

/* The "sval" codes for TV_SHOT/TV_ARROW/TV_BOLT */
#define SV_AMMO_LIGHT                    0	/* pebbles, flight arrows */
#define SV_AMMO_NORMAL                   1	/* shots, arrows, bolts */
#define SV_AMMO_HEAVY                    2	/* sheaf + seeker arrows and bolts, mithril shots */

/* The "sval" codes for TV_BOW (note information in "sval") */
#define SV_SLING                         2	/* (x2) */
#define SV_SHORT_BOW                    12	/* (x2) */
#define SV_LONG_BOW                     13	/* (x3 or x2) */
#define SV_LIGHT_XBOW                   23	/* (x4) */
#define SV_HEAVY_XBOW                   24	/* (x5) */

/* The "sval" codes for TV_DIGGING */
#define SV_SHOVEL                        1
#define SV_PICK                          4
#define SV_MATTOCK                       7

/* The "sval" values for TV_HAFTED */
#define SV_CLUB                          1	/* 1d4  */
#define SV_WHIP                          2	/* 1d6  */
#define SV_QUARTERSTAFF                  3	/* 1d9  */
#define SV_MACE                          5	/* 2d4  */
#define SV_WAR_HAMMER                    8	/* 3d3  */
#define SV_MORNING_STAR                 12	/* 2d6  */
#define SV_FLAIL                        13	/* 2d6  */
#define SV_TWO_HANDED_FLAIL             18	/* 3d6  */
#define SV_MACE_OF_DISRUPTION           20	/* 5d8  */
#define SV_WIZSTAFF                     21	/* 1d2  */
#define SV_GROND                        50	/* 3d4  */

/* The "sval" values for TV_POLEARM */
#define SV_SPEAR                         2	/* 1d6 */
#define SV_TRIDENT                       5	/* 1d9 */
#define SV_PIKE                          8	/* 2d5 */
#define SV_BROAD_AXE                    11	/* 2d6 */
#define SV_GLAIVE                       13	/* 2d6 */
#define SV_HALBERD                      15	/* 3d4 */
#define SV_SCYTHE                       17	/* 5d3 */
#define SV_LANCE                        20	/* 2d8 */
#define SV_BATTLE_AXE                   22	/* 2d8 */
#define SV_GREAT_AXE                    25	/* 4d4 */
#define SV_HEAVY_LANCE                  29  /* 4d8 */
#define SV_SCYTHE_OF_SLICING            30	/* 8d4 */

/* The "sval" codes for TV_SWORD */
#define SV_BROKEN_DAGGER                 1  /* 1d1 */
#define SV_BROKEN_SWORD                  2  /* 1d2 */
#define SV_DAGGER                        4  /* 1d4 */
#define SV_MAIN_GAUCHE                   5  /* 1d5 */
#define SV_RAPIER                        7  /* 1d6 */
#define SV_SMALL_SWORD                   8  /* 1d6 */
#define SV_SHORT_SWORD                  10  /* 1d7 */
#define SV_LONG_SWORD                   17  /* 2d5 */
#define SV_BASTARD_SWORD                21  /* 3d4 */
#define SV_TWO_HANDED_SWORD             25  /* 3d6 */
#define SV_EXECUTIONERS_SWORD           28  /* 4d5 */
#define SV_BLADE_OF_CHAOS               30  /* 6d5 */

/* The "sval" codes for TV_SHIELD */
#define SV_SMALL_LEATHER_SHIELD          2
#define SV_SMALL_METAL_SHIELD            3
#define SV_LARGE_LEATHER_SHIELD          4
#define SV_LARGE_METAL_SHIELD            5
#define SV_DRAGON_SHIELD                 6
#define SV_SHIELD_OF_DEFLECTION         10

/* The "sval" codes for TV_HELM */
#define SV_HARD_LEATHER_CAP              2
#define SV_METAL_CAP                     3
#define SV_IRON_HELM                     5
#define SV_STEEL_HELM                    6
#define SV_DRAGON_HELM                   7
#define SV_KABUTO                        8  /* 7 */
#define SV_IRON_CROWN                   10
#define SV_GOLDEN_CROWN                 11
#define SV_JEWELED_CROWN                12
#define SV_MORGOTH                      50

/* The "sval" codes for TV_BOOTS */
#define SV_PAIR_OF_SOFT_LEATHER_BOOTS    2
#define SV_PAIR_OF_HARD_LEATHER_BOOTS    3
#define SV_PAIR_OF_METAL_SHOD_BOOTS      6
#define SV_PAIR_OF_DRAGON_BOOTS          4

/* The "sval" codes for TV_CLOAK */
#define SV_CLOAK                         1
#define SV_ELVEN_CLOAK                   2
#define SV_FUR_CLOAK                     3
#define SV_SHADOW_CLOAK                  6

/* The "sval" codes for TV_GLOVES */
#define SV_SET_OF_LEATHER_GLOVES         1
#define SV_SET_OF_GAUNTLETS              2
#define SV_SET_OF_CESTI                  5
#define SV_SET_OF_DRAGON_GLOVES          3

/* The "sval" codes for TV_SOFT_ARMOR */
#define SV_ROBE                          2
#define SV_SOFT_LEATHER_ARMOR            4
#define SV_HARD_LEATHER_ARMOR            6
#define SV_LEATHER_SCALE_MAIL           11

/* The "sval" codes for TV_HARD_ARMOR */
#define SV_METAL_SCALE_MAIL              3  /* 13  */
#define SV_CHAIN_MAIL                    4  /* 14  */
#define SV_METAL_BRIGANDINE_ARMOUR       9  /* 19  */
#define SV_FULL_PLATE_ARMOUR            15  /* 25  */
#define SV_MITHRIL_CHAIN_MAIL           20  /* 28+ */
#define SV_DRAGON_ARMOR                 35

/* The "sval" codes for TV_DRAG_ARMOR */
/* Nothing in TinyAngband */

/* The sval codes for TV_LITE */
#define SV_LITE_TORCH                    0
#define SV_LITE_LANTERN                  1
#define SV_LITE_FEANOR                   2
#define SV_LITE_GALADRIEL                4
#define SV_LITE_ELENDIL                  5
#define SV_LITE_THRAIN                   6

/* The "sval" codes for TV_AMULET */
#define SV_AMULET_ADORNMENT              2
#define SV_AMULET_SLOW_DIGEST            3
#define SV_AMULET_RESIST_ACID            4
#define SV_AMULET_SEARCHING              5
#define SV_AMULET_WISDOM                 6
#define SV_AMULET_CHARISMA               7
#define SV_AMULET_THE_MAGI               8
#define SV_AMULET_REFLECTION             9
#define SV_AMULET_CARLAMMAS             10
#define SV_AMULET_INGWE                 11
#define SV_AMULET_DWARVES               12
#define SV_AMULET_NO_MAGIC              13
#define SV_AMULET_NO_TELE               14
#define SV_AMULET_RESISTANCE            15
#define SV_AMULET_SUSTENANCE            16
#define SV_AMULET_ESP                   17
#define SV_AMULET_HEALTH                20
#define SV_AMULET_THE_HERO              22
#define SV_AMULET_MAGIC_MASTERY         23

/* The sval codes for TV_RING */
#define SV_RING_FEATHER_FALL             7
#define SV_RING_RESIST_FIRE              8
#define SV_RING_RESIST_COLD              9
#define SV_RING_SUSTAIN_STR             10
#define SV_RING_PROTECTION              16
#define SV_RING_ACID                    17
#define SV_RING_FLAMES                  18
#define SV_RING_ICE                     19
#define SV_RING_SEARCHING               23
#define SV_RING_STR                     24
#define SV_RING_ELEC                    25
#define SV_RING_DEX                     26
#define SV_RING_CON                     27
#define SV_RING_ACCURACY                28
#define SV_RING_DAMAGE                  29
#define SV_RING_SLAYING                 30
#define SV_RING_SPEED                   31
#define SV_RING_RES_FEAR                38
#define SV_RING_LORDLY                  48
#define SV_RING_ATTACKS                 49
#define SV_RING_MUSCLE                  50
#define SV_RING_DEC_MANA                51
#define SV_RING_SHOTS                   52
#define SV_RING_WRAITH                  53

/* The "sval" codes for TV_STAFF */
#define SV_STAFF_TELEPORTATION           4
#define SV_STAFF_IDENTIFY                5
#define SV_STAFF_REMOVE_CURSE            6
#define SV_STAFF_STARLITE                7
#define SV_STAFF_LITE                    8
#define SV_STAFF_MAPPING                 9
#define SV_STAFF_DETECT_GOLD            10
#define SV_STAFF_DETECT_ITEM            11
#define SV_STAFF_DETECT_TRAP            12
#define SV_STAFF_DETECT_DOOR            13
#define SV_STAFF_DETECT_INVIS           14
#define SV_STAFF_DETECT_EVIL            15
#define SV_STAFF_CURE_LIGHT             16
#define SV_STAFF_CURING                 17
#define SV_STAFF_HEALING                18
#define SV_STAFF_SLEEP_MONSTERS         20
#define SV_STAFF_SLOW_MONSTERS          21
#define SV_STAFF_SPEED                  22
#define SV_STAFF_DISPEL_EVIL            24
#define SV_STAFF_GENOCIDE               27
#define SV_STAFF_EARTHQUAKES            28
#define SV_STAFF_DESTRUCTION            29
#define SV_STAFF_WISHING                30


/* The "sval" codes for TV_WAND */
#define SV_WAND_HEAL_MONSTER             0
#define SV_WAND_HASTE_MONSTER            1
#define SV_WAND_CLONE_MONSTER            2
#define SV_WAND_TELEPORT_AWAY            3
#define SV_WAND_DISARMING                4
#define SV_WAND_ANNIHILATION             5
#define SV_WAND_STONE_TO_MUD             6
#define SV_WAND_LITE                     7
#define SV_WAND_SLEEP_MONSTER            8
#define SV_WAND_SLOW_MONSTER             9
#define SV_WAND_CONFUSE_MONSTER         10
#define SV_WAND_DRAIN_LIFE              12
#define SV_WAND_STINKING_CLOUD          14
#define SV_WAND_MAGIC_MISSILE           15
#define SV_WAND_ACID_BALL               20
#define SV_WAND_ELEC_BALL               21
#define SV_WAND_FIRE_BALL               22
#define SV_WAND_COLD_BALL               23
#define SV_WAND_WONDER                  24
#define SV_WAND_DRAGON_FIRE             26
#define SV_WAND_DRAGON_COLD             27
#define SV_WAND_DRAGON_BREATH           28


/* The "sval" codes for TV_ROD */
#define SV_ROD_DETECT_TRAP               0
#define SV_ROD_DETECT_DOOR               1
#define SV_ROD_IDENTIFY                  2
#define SV_ROD_RECALL                    3
#define SV_ROD_ILLUMINATION              4
#define SV_ROD_MAPPING                   5
#define SV_ROD_DETECTION                 6
#define SV_ROD_PROBING                   7
#define SV_ROD_CURING                    8
#define SV_ROD_HEALING                   9
#define SV_ROD_RESTORATION              10
#define SV_ROD_SPEED                    11
#define SV_ROD_PESTICIDE                12
#define SV_ROD_TELEPORT_AWAY            13
#define SV_ROD_DISARMING                14
#define SV_ROD_SLEEP_MONSTER            16
#define SV_ROD_SLOW_MONSTER             17
#define SV_ROD_POLYMORPH                19
#define SV_ROD_ACID_BALL                24
#define SV_ROD_ELEC_BALL                25
#define SV_ROD_FIRE_BALL                26
#define SV_ROD_COLD_BALL                27
#define SV_ROD_HAVOC                    28
#define SV_ROD_STONE_TO_MUD             29


/* The "sval" codes for TV_SCROLL */

/* xxx (summon?) */
#define SV_SCROLL_TRAP_CREATION          7
#define SV_SCROLL_PHASE_DOOR             8
#define SV_SCROLL_TELEPORT               9
#define SV_SCROLL_TELEPORT_LEVEL        10
#define SV_SCROLL_WORD_OF_RECALL        11
#define SV_SCROLL_IDENTIFY              12
#define SV_SCROLL_STAR_IDENTIFY         13
#define SV_SCROLL_REMOVE_CURSE          14
#define SV_SCROLL_STAR_REMOVE_CURSE     15
#define SV_SCROLL_ENCHANT_ARMOR         16
#define SV_SCROLL_ENCHANT_WEAPON_TO_HIT 17
#define SV_SCROLL_ENCHANT_WEAPON_TO_DAM 18
/* xxx enchant missile? */
#define SV_SCROLL_STAR_ENCHANT_ARMOR    20
#define SV_SCROLL_STAR_ENCHANT_WEAPON   21
#define SV_SCROLL_RECHARGING            22
#define SV_SCROLL_MUNDANITY             23
#define SV_SCROLL_LIGHT                 24
#define SV_SCROLL_MAPPING               25
#define SV_SCROLL_DETECT_GOLD           26
#define SV_SCROLL_DETECT_ITEM           27
#define SV_SCROLL_DETECT_TRAP           28
#define SV_SCROLL_DETECT_DOOR           29
#define SV_SCROLL_DETECT_INVIS          30
/* xxx (detect evil?) */
#define SV_SCROLL_SATISFY_HUNGER        32
#define SV_SCROLL_BLESSING              33
#define SV_SCROLL_HOLY_CHANT            34
#define SV_SCROLL_HOLY_PRAYER           35
#define SV_SCROLL_MONSTER_CONFUSION     36
#define SV_SCROLL_PROTECTION_FROM_EVIL  37
#define SV_SCROLL_RUNE_OF_PROTECTION    38
#define SV_SCROLL_TRAP_DOOR_DESTRUCTION 39
/* xxx */
#define SV_SCROLL_STAR_DESTRUCTION      41
#define SV_SCROLL_DISPEL_UNDEAD         42
/* xxx */
#define SV_SCROLL_GENOCIDE              44
#define SV_SCROLL_MASS_GENOCIDE         45
#define SV_SCROLL_ACQUIREMENT           46
#define SV_SCROLL_STAR_ACQUIREMENT      47
#define SV_SCROLL_FIRE                  48
#define SV_SCROLL_ICE                   49
#define SV_SCROLL_CHAOS                 50
#define SV_SCROLL_RUMOR                 51
#define SV_SCROLL_ARTIFACT              52

/* The "sval" codes for TV_POTION */
#define SV_POTION_WATER                  0
/* xxx (fixed color) */
/* xxx */
/* xxx */
/* xxx */
/* xxx */
#define SV_POTION_DETONATIONS           22
#define SV_POTION_INFRAVISION           24
#define SV_POTION_DETECT_INVIS          25
#define SV_POTION_CURE_POISON           27
#define SV_POTION_SPEED                 29
#define SV_POTION_RESIST_HEAT           30
#define SV_POTION_RESIST_COLD           31
#define SV_POTION_HEROISM               32
#define SV_POTION_BESERK_STRENGTH       33
#define SV_POTION_CURE_LIGHT            34
#define SV_POTION_CURE_SERIOUS          35
#define SV_POTION_CURE_CRITICAL         36
#define SV_POTION_HEALING               37
#define SV_POTION_STAR_HEALING          38
#define SV_POTION_RESTORE_MANA          40
#define SV_POTION_RESTORE_EXP           41
#define SV_POTION_RES_STR               42
#define SV_POTION_RES_INT               43
#define SV_POTION_RES_WIS               44
#define SV_POTION_RES_DEX               45
#define SV_POTION_RES_CON               46
#define SV_POTION_RES_CHR               47
/* xxx */
#define SV_POTION_ENLIGHTENMENT         56
#define SV_POTION_SELF_KNOWLEDGE        58
#define SV_POTION_EXPERIENCE            59
#define SV_POTION_RESISTANCE            60
#define SV_POTION_CURING                61
#define SV_POTION_INVULNERABILITY       62
#define SV_POTION_RESTORING             64

/* The "sval" codes for TV_FOOD */
/* Mushrooms don't exist any longer */
/* #define SV_FOOD_RESTORING               19 */
/* many missing mushrooms */
#define SV_FOOD_RATION                  35
#define SV_FOOD_SLIME_MOLD              36
#define SV_FOOD_WAYBREAD                37


/*
 * Special "sval" limit -- first "normal" food
 */
#define SV_FOOD_MIN_FOOD                32

/*
 * Special "sval" limit -- first "aimed" rod
 */
#define SV_ROD_MIN_DIRECTION    13

/*
 * Special "sval" limit -- first "large" chest
 */
#define SV_CHEST_MIN_LARGE      4

/*
 * Special "sval" limit -- first "good" magic/prayer book
 */
#ifdef TINYANGBAND
#define SV_BOOK_MIN_GOOD    1
#else
#define SV_BOOK_MIN_GOOD    2
#endif


#define OBJ_GOLD_LIST   3       /* First "gold" entry */
#define MAX_GOLD        18      /* Number of "gold" entries */


/*** General flag values ***/


/*
 * Special cave grid flags
 */
#define CAVE_MARK       0x0001    /* memorized feature */
#define CAVE_GLOW       0x0002    /* self-illuminating */
#define CAVE_ICKY       0x0004    /* part of a vault */
#define CAVE_ROOM       0x0008    /* part of a room */
#define CAVE_LITE       0x0010    /* lite flag  */
#define CAVE_VIEW       0x0020    /* view flag */
#define CAVE_TEMP       0x0040    /* temp flag */
#define CAVE_XTRA       0x0080    /* misc flag */

#define CAVE_MNLT       0x0100    /* Illuminated by monster */
#define CAVE_UNSAFE     0x2000    /* Might have trap */
#define CAVE_IN_DETECT  0x4000    /* trap detected area (inner circle only) */
#define CAVE_TRAP       0x8000



/*
 * Bit flags for the "project()" function
 *
 *   JUMP: Jump directly to the target location (this is a hack)
 *   BEAM: Work as a beam weapon (affect every grid passed through)
 *   THRU: Continue "through" the target (used for "bolts"/"beams")
 *   STOP: Stop as soon as we hit a monster (used for "bolts")
 *   GRID: Affect each grid in the "blast area" in some way
 *   ITEM: Affect each object in the "blast area" in some way
 *   KILL: Affect each monster in the "blast area" in some way
 *   HIDE: Hack -- disable "visual" feedback from projection
 *   FRND: Stop if hit a friendly monster / player.
 */
#define PROJECT_JUMP    0x0001
#define PROJECT_BEAM    0x0002
#define PROJECT_THRU    0x0004
#define PROJECT_STOP    0x0008
#define PROJECT_GRID    0x0010
#define PROJECT_ITEM    0x0020
#define PROJECT_KILL    0x0040
#define PROJECT_HIDE    0x0080
#define PROJECT_FRND	0x0100
#define PROJECT_REFLECTABLE 0x800
#define PROJECT_NO_COUNTER 0x1000
#define PROJECT_PATH	0x2000

/*
 * Bit flags for the "enchant()" function
 */
#define ENCH_TOHIT      0x01 /* Enchant to hit */
#define ENCH_TODAM      0x02 /* Enchant to damage */
#define ENCH_TOAC       0x04 /* Enchant to AC */
#define ENCH_FORCE      0x08 /* Force enchantment */

/*
 * Bit flags for the "target_set" function XXX XXX XXX
 *
 *	KILL: Target monsters
 *	LOOK: Describe grid fully
 *  XTRA: Currently unused flag
 *  GRID: Select from all grids
 *	HOST: Select hostile creatures only.
 */
#define TARGET_KILL		0x01
#define TARGET_LOOK		0x02
#define TARGET_XTRA		0x04
#define TARGET_GRID		0x08
#define TARGET_HOST		0x10

/*
 * Some bit-flags for the "smart" field
 */
#define SM_RES_ACID             0x00000001
#define SM_RES_ELEC             0x00000002
#define SM_RES_FIRE             0x00000004
#define SM_RES_COLD             0x00000008
#define SM_RES_POIS             0x00000010
#define SM_RES_NETH             0x00000020
#define SM_RES_LITE             0x00000040
#define SM_RES_DARK             0x00000080
#define SM_RES_FEAR             0x00000100
#define SM_RES_CONF             0x00000200
#define SM_RES_CHAOS            0x00000400
#define SM_RES_DISEN            0x00000800
#define SM_RES_BLIND            0x00001000
#define SM_RES_NEXUS            0x00002000
#define SM_RES_SOUND            0x00004000
#define SM_RES_SHARD            0x00008000
#define SM_OPP_ACID             0x00010000
#define SM_OPP_ELEC             0x00020000
#define SM_OPP_FIRE             0x00040000
#define SM_OPP_COLD             0x00080000
#define SM_OPP_POIS             0x00100000
#define SM_WAS_FRIENDLY         0x00200000 /* was friendly */
#define SM_CLONED               0x00400000 /* XXX Cloned */
#define SM_PET                  0x00800000 /* XXX Pet */
#define SM_IMM_ACID             0x01000000
#define SM_IMM_ELEC             0x02000000
#define SM_IMM_FIRE             0x04000000
#define SM_IMM_COLD             0x08000000
#define SM_FRIENDLY             0x10000000 /* XXX Friendly */
#define SM_IMM_REFLECT          0x20000000
#define SM_IMM_FREE             0x40000000
#define SM_IMM_MANA             0x80000000


/*
 * Bit flags for the "get_item" function
 */
#define USE_EQUIP	0x01	/* Allow equip items */
#define USE_INVEN	0x02	/* Allow inven items */
#define USE_FLOOR	0x04	/* Allow floor items */


/*
 * Bit flags for the "p_ptr->notice" variable
 */
#define PN_COMBINE      0x00000001L     /* Combine the pack */
#define PN_REORDER      0x00000002L     /* Reorder the pack */
#define PN_AUTODESTROY  0x00000004L     /* Auto-destroy marked item */
/* xxx (many) */


/*
 * Bit flags for the "p_ptr->update" variable
 */
#define PU_BONUS        0x00000001L     /* Calculate bonuses */
#define PU_TORCH        0x00000002L     /* Calculate torch radius */
/* xxx (many) */
#define PU_HP           0x00000010L     /* Calculate chp and mhp */
#define PU_MANA         0x00000020L     /* Calculate csp and msp */
#define PU_SPELLS       0x00000040L     /* Calculate spells */
/* xxx (many) */
/* xxx (many) */
#define PU_UN_VIEW      0x00010000L     /* Forget view */
#define PU_UN_LITE      0x00020000L     /* Forget lite */
/* xxx (many) */
#define PU_VIEW         0x00100000L     /* Update view */
#define PU_LITE         0x00200000L     /* Update lite */
#define PU_MON_LITE     0x00400000L     /* Monster illumination */
/* xxx */
#define PU_MONSTERS     0x01000000L     /* Update monsters */
#define PU_DISTANCE     0x02000000L     /* Update distances */
/* xxx */
#define PU_FLOW         0x10000000L     /* Update flow */
/* xxx (many) */


/*
 * Bit flags for the "p_ptr->redraw" variable
 */
#define PR_MISC         0x00000001L     /* Display Race/Class */
#define PR_TITLE        0x00000002L     /* Display Title */
#define PR_LEV          0x00000004L     /* Display Level */
#define PR_EXP          0x00000008L     /* Display Experience */
#define PR_STATS        0x00000010L     /* Display Stats */
#define PR_ARMOR        0x00000020L     /* Display Armor */
#define PR_HP           0x00000040L     /* Display Hitpoints */
#define PR_MANA         0x00000080L     /* Display Mana */
#define PR_GOLD         0x00000100L     /* Display Gold */
#define PR_DEPTH        0x00000200L     /* Display Depth */
#define PR_EQUIPPY      0x00000400L     /* Display equippy chars */
#define PR_HEALTH       0x00000800L     /* Display Health Bar */
#define PR_CUT          0x00001000L     /* Display Extra (Cut) */
#define PR_STUN         0x00002000L     /* Display Extra (Stun) */
#define PR_HUNGER       0x00004000L     /* Display Extra (Hunger) */
#define PR_STATUS       0x00008000L     /* Display Status Bar */
#define PR_XXX1         0x00010000L
#define PR_XXX2         0x00020000L
#define PR_XXX3         0x00040000L
#define PR_XXX4         0x00080000L
#define PR_STATE        0x00100000L     /* Display Extra (State) */
#define PR_SPEED        0x00200000L     /* Display Extra (Speed) */
#define PR_STUDY        0x00400000L     /* Display Extra (Study) */
/* xxx */
#define PR_EXTRA        0x01000000L     /* Display Extra Info */
#define PR_BASIC        0x02000000L     /* Display Basic Info */
#define PR_MAP          0x04000000L     /* Display Map */
#define PR_WIPE         0x08000000L     /* Hack -- Total Redraw */
/* xxx */
/* xxx */
/* xxx */
/* xxx */

/*
 * Bit flags for the "p_ptr->window" variable (etc)
 */
#define PW_INVEN        0x00000001L     /* Display inven/equip */
#define PW_EQUIP        0x00000002L     /* Display equip/inven */
#define PW_SPELL        0x00000004L     /* Display spell list */
#define PW_PLAYER       0x00000008L     /* Display character */
#define PW_STATS        0x00000010L     /* Display stats, resistances */
/* xxx */
#define PW_MESSAGE      0x00000040L     /* Display messages */
#define PW_OVERHEAD     0x00000080L     /* Display overhead view */
#define PW_MONSTER      0x00000100L     /* Display monster recall */
#define PW_OBJECT       0x00000200L     /* Display object recall */
#define PW_DUNGEON      0x00000400L     /* Display dungeon view */
#define PW_SNAPSHOT     0x00000800L     /* Display snap-shot */
#define PW_FLOOR        0x00001000L     /* Display objects on floor */
/* xxx */
#define PW_BORG_1       0x00004000L     /* Display borg messages */
#define PW_BORG_2       0x00008000L     /* Display borg status */


/* Bit flags for monster_desc() */
#define MD_OBJECTIVE      0x00000001 /* Objective (or Reflexive) */
#define MD_POSSESSIVE     0x00000002 /* Possessive (or Reflexive) */
#define MD_INDEF_HIDDEN   0x00000004 /* Use indefinites for hidden monsters ("something") */
#define MD_INDEF_VISIBLE  0x00000008 /* Use indefinites for visible monsters ("a kobold") */
#define MD_PRON_HIDDEN    0x00000010 /* Pronominalize hidden monsters */
#define MD_PRON_VISIBLE   0x00000020 /* Pronominalize visible monsters */
#define MD_ASSUME_HIDDEN  0x00000040 /* Assume the monster is hidden */
#define MD_ASSUME_VISIBLE 0x00000080 /* Assume the monster is visible */
#define MD_TRUE_NAME      0x00000100 /* Chameleon's true name */
#define MD_IGNORE_HALLU   0x00000200 /* Ignore hallucination, and penetrate shape change */


/*
 * Bit flags for object_desc()
 */
#define OD_NAME_ONLY        0x00000001  /* Omit values, pval, inscription */
#define OD_NAME_AND_ENCHANT 0x00000002  /* Omit pval, inscription */
#define OD_OMIT_INSCRIPTION 0x00000004  /* Omit inscription */
#define OD_OMIT_PREFIX      0x00000008  /* Omit numeric prefix */
#define OD_NO_PLURAL        0x00000010  /* Don't use plural */
#define OD_STORE            0x00000020  /* Assume to be aware and known */
#define OD_NO_FLAVOR        0x00000040  /* Allow to hidden flavor */
#define OD_FORCE_FLAVOR     0x00000080  /* Get un-shuffled flavor name */



/*** General index values ***/


/*
 * Legal restrictions for "summon_specific()"
 */
#define SUMMON_ANT                  11
#define SUMMON_SPIDER               12
#define SUMMON_HOUND                13
#define SUMMON_HYDRA                14
#define SUMMON_ANGEL                15
#define SUMMON_DEMON                16
#define SUMMON_UNDEAD               17
#define SUMMON_DRAGON               18
#define SUMMON_HI_UNDEAD            21
#define SUMMON_HI_DRAGON            22
#define SUMMON_HI_DEMON             31
#define SUMMON_UNIQUE               32
#define SUMMON_BIZARRE1             33
#define SUMMON_BIZARRE2             34
#define SUMMON_BIZARRE3             35
#define SUMMON_BIZARRE4             36
#define SUMMON_BIZARRE5             37
#define SUMMON_BIZARRE6             38
#define SUMMON_CYBER                39
#define SUMMON_KIN                  40
#define SUMMON_DAWN                 41
#define SUMMON_ANIMAL               42
#define SUMMON_ANIMAL_RANGER        43
#define SUMMON_HI_UNDEAD_NO_UNIQUES 44
#define SUMMON_HI_DRAGON_NO_UNIQUES 45
#define SUMMON_NO_UNIQUES           46
#define SUMMON_PHANTOM              47
#define SUMMON_ELEMENTAL            48
#define SUMMON_BLUE_HORROR          49



/*
 * Spell types used by project(), and related functions.
 */
#define GF_ELEC         1
#define GF_POIS         2
#define GF_ACID         3
#define GF_COLD         4
#define GF_FIRE         5
#define GF_PSY_SPEAR    9
#define GF_MISSILE      10
#define GF_ARROW        11
#define GF_PLASMA       12
/* Replaced with GF_HOLY_FIRE and GF_HELL_FIRE */
/* #define GF_HOLY_ORB     13 */
#define GF_WATER        14
#define GF_LITE         15
#define GF_DARK         16
#define GF_LITE_WEAK    17
#define GF_DARK_WEAK    18
#define GF_SHARDS       20
#define GF_SOUND        21
#define GF_CONFUSION    22
#define GF_FORCE        23
#define GF_INERTIA      24
#define GF_MANA         26
#define GF_METEOR       27
#define GF_ICE          28
#define GF_CHAOS        30
#define GF_NETHER       31
#define GF_DISENCHANT   32
#define GF_NEXUS        33
#define GF_TIME         34
#define GF_GRAVITY      35
#define GF_KILL_WALL    40
#define GF_KILL_DOOR    41
#define GF_KILL_TRAP    42
#define GF_MAKE_WALL    45
#define GF_MAKE_DOOR    46
#define GF_MAKE_TRAP    47
#define GF_OLD_CLONE    51
#define GF_OLD_POLY             52
#define GF_OLD_HEAL             53
#define GF_OLD_SPEED    54
#define GF_OLD_SLOW             55
#define GF_OLD_CONF             56
#define GF_OLD_SLEEP    57
#define GF_OLD_DRAIN    58
#define GF_AWAY_UNDEAD  61
#define GF_AWAY_EVIL    62
#define GF_AWAY_ALL     63
#define GF_TURN_UNDEAD  64
#define GF_TURN_EVIL    65
#define GF_TURN_ALL     66
#define GF_DISP_UNDEAD  67
#define GF_DISP_EVIL    68
#define GF_DISP_ALL 69
#define GF_DISP_DEMON   70      /* New types for Zangband begin here... */
#define GF_DISP_LIVING  71
#define GF_ROCKET       72
#define GF_NUKE         73
#define GF_MAKE_GLYPH   74
#define GF_STASIS       75
#define GF_STONE_WALL   76
#define GF_DEATH_RAY    77
#define GF_STUN         78
#define GF_HOLY_FIRE    79
#define GF_HELL_FIRE    80
#define GF_DISINTEGRATE 81
#define GF_CHARM        82
#define GF_CONTROL_UNDEAD   83
#define GF_CONTROL_ANIMAL   84
#define GF_PSI         85
#define GF_PSI_DRAIN   86
#define GF_TELEKINESIS  87
#define GF_JAM_DOOR     88
#define GF_DOMINATION   89
#define GF_DISP_GOOD    90
#define GF_JUMP         91
#define GF_JUMP_ATTACK  92
#define GF_GENOCIDE     93
#define GF_SOFTEN       94
#define GF_DIST_ATTACK  95

#define MAX_GF				96


/*
 * Some things which induce learning
 */
#define DRS_ACID         1
#define DRS_ELEC         2
#define DRS_FIRE         3
#define DRS_COLD         4
#define DRS_POIS         5
#define DRS_NETH         6
#define DRS_LITE         7
#define DRS_DARK         8
#define DRS_FEAR         9
#define DRS_CONF        10
#define DRS_CHAOS       11
#define DRS_DISEN       12
#define DRS_BLIND       13
#define DRS_NEXUS       14
#define DRS_SOUND       15
#define DRS_SHARD       16
#define DRS_FREE        30
#define DRS_MANA        31
#define DRS_REFLECT     32



/*
 * Hack -- first "normal" artifact in the artifact list.  All of
 * the artifacts with indexes from 1 to 15 are "special" (lights,
 * rings, amulets), and the ones from 16 to 127 are "normal".
 */
#define ART_MIN_NORMAL          16

/*
 * Game generated inscription indices. These are stored in the object,
 * and are used to index the string array from tables.c.
 */

#define FEEL_NONE              0
#define FEEL_BROKEN            1
#define FEEL_TERRIBLE          2
#define FEEL_WORTHLESS         3
#define FEEL_CURSED            4
#define FEEL_UNCURSED          5
#define FEEL_AVERAGE           6
#define FEEL_GOOD              7
#define FEEL_EXCELLENT         8
#define FEEL_SPECIAL           9

#define FEEL_MAX               9

/*
 * Hack -- special "xtra" object powers
 */

/* Sustain one stat */
#define EGO_XTRA_SUSTAIN        1

/* High resist */
#define EGO_XTRA_POWER          2

/* Special ability */
#define EGO_XTRA_ABILITY        3

/*** Object flag values ***/


/*
 * Chest trap flags (see "tables.c")
 */
#define CHEST_LOSE_STR          0x01
#define CHEST_LOSE_CON          0x02
#define CHEST_POISON            0x04
#define CHEST_PARALYZE          0x08
#define CHEST_EXPLODE           0x10
#define CHEST_SUMMON            0x20



/*
 * Special Object Flags
 */
#define IDENT_SENSE     0x01    /* Item has been "sensed" */
#define IDENT_FIXED     0x02    /* Item has been "haggled" */
#define IDENT_EMPTY     0x04    /* Item charges are known */
#define IDENT_KNOWN     0x08    /* Item abilities are known */
#define IDENT_STORE     0x10    /* Item is storebought !!!! */
#define IDENT_MENTAL    0x20    /* Item information is known */
#define IDENT_CURSED    0x40    /* Item is temporarily cursed */
#define IDENT_BROKEN    0x80    /* Item is permanently worthless */


/* 
 * How object is marked (flags in object_type.mark)
 * OM_FOUND --- original boolean flag
 * OM_NOMSG --- temporary flag to suppress messages which were
 *              already printed in autopick_pickup_items().
 */
#define OM_FOUND        0x01    /* original boolean flag */
#define OM_NOMSG        0x02    /* temporary flag to suppress messages */
#define OM_NO_QUERY     0x04    /* Query for auto-pick was already answered as 'No' */
#define OM_AUTODESTROY  0x08    /* Destroy later to avoid illegal inventry shift */
#define OM_TOUCHED      0x10    /* Object was touched by player */


/*
 * Special Monster Flags (all temporary)
 */
#define MFLAG_VIEW      0x01    /* Monster is in line of sight */
#define MFLAG_TEMP      0x02    /* Monster is marked for project_hack() */
#define MFLAG_XXX2      0x04    /* (unused) */
#define MFLAG_XXX3      0x08    /* (unused) */
#define MFLAG_BORN      0x10    /* Monster is still being born */
#define MFLAG_NICE      0x20    /* Monster is still being nice */
#define MFLAG_SHOW      0x40    /* Monster is recently memorized */
#define MFLAG_MARK      0x80    /* Monster is currently memorized */

/*
 * Special Monster Flags2 (saved)
 */
#define MF_NO_GENO     0x00000001L    /* Cannot genocide */


/*
 * As of 2.7.8, the "object flags" are valid for all objects, and as
 * of 2.7.9, these flags are not actually stored with the object.
 *
 * Note that "flags1" contains all flags dependant on "pval" (including
 * stat bonuses, but NOT stat sustainers), plus all "extra attack damage"
 * flags (SLAY_XXX and BRAND_XXX).
 *
 * Note that "flags2" contains all "resistances" (including "Stat Sustainers",
 * actual immunities, and resistances).  Note that "Hold Life" is really an
 * "immunity" to ExpLoss, and "Free Action" is "immunity to paralysis".
 *
 * Note that "flags3" contains everything else -- including the three "CURSED"
 * flags, and the "BLESSED" flag, several "item display" parameters, some new
 * flags for powerful Bows, and flags which affect the player in a "general"
 * way (LITE, TELEPATHY, SEE_INVIS, SLOW_DIGEST, REGEN, FEATHER), including
 * all the "general" curses (TELEPORT, AGGRAVATE, EXP_DRAIN).  It also has
 * four new flags called "ITEM_IGNORE_XXX" which lets an item specify that
 * it can not be affected by various forms of destruction.  This is NOT as
 * powerful as actually granting resistance/immunity to the wearer.
 */

#define TR1_STR                 0x00000001L     /* STR += "pval" */
#define TR1_INT                 0x00000002L     /* INT += "pval" */
#define TR1_WIS                 0x00000004L     /* WIS += "pval" */
#define TR1_DEX                 0x00000008L     /* DEX += "pval" */
#define TR1_CON                 0x00000010L     /* CON += "pval" */
#define TR1_CHR                 0x00000020L     /* CHR += "pval" */
#define TR1_MAGIC_MASTERY       0x00000040L     /* Later */
#define TR1_STEALTH             0x00000080L     /* Stealth += "pval" */
#define TR1_SEARCH              0x00000100L     /* Search += "pval" */
#define TR1_INFRA               0x00000200L     /* Infra += "pval" */
#define TR1_TUNNEL              0x00000400L     /* Tunnel += "pval" */
#define TR1_SPEED               0x00000800L     /* Speed += "pval" */
#define TR1_BLOWS               0x00001000L     /* Blows += "pval" */
#define TR1_CHAOTIC             0x00002000L
#define TR1_VAMPIRIC            0x00004000L
#define TR1_SLAY_HUMAN          0x00008000L     /* Later */
#define TR1_SLAY_ANIMAL         0x00010000L
#define TR1_SLAY_EVIL           0x00020000L
#define TR1_SLAY_UNDEAD         0x00040000L
#define TR1_SLAY_DEMON          0x00080000L
#define TR1_SLAY_ORC            0x00100000L
#define TR1_SLAY_TROLL          0x00200000L
#define TR1_SLAY_GIANT          0x00400000L
#define TR1_SLAY_DRAGON         0x00800000L
#define TR1_KILL_DRAGON         0x01000000L     /* Execute Dragon */
#define TR1_VORPAL              0x02000000L     /* Later */
#define TR1_IMPACT              0x04000000L     /* Cause Earthquakes */
#define TR1_BRAND_POIS          0x08000000L
#define TR1_BRAND_ACID          0x10000000L
#define TR1_BRAND_ELEC          0x20000000L
#define TR1_BRAND_FIRE          0x40000000L
#define TR1_BRAND_COLD          0x80000000L

#define TR2_SUST_STR            0x00000001L
#define TR2_SUST_INT            0x00000002L
#define TR2_SUST_WIS            0x00000004L
#define TR2_SUST_DEX            0x00000008L
#define TR2_SUST_CON            0x00000010L
#define TR2_SUST_CHR            0x00000020L
#define TR2_XXX1                0x00000040L     /* Later */
#define TR2_XXX2                0x00000080L     /* Later */
#define TR2_IM_ACID             0x00000100L
#define TR2_IM_ELEC             0x00000200L
#define TR2_IM_FIRE             0x00000400L
#define TR2_IM_COLD             0x00000800L
#define TR2_THROW               0x00001000L     /* Throwing items */
#define TR2_REFLECT             0x00002000L     /* Reflect 'bolts' */
#define TR2_FREE_ACT            0x00004000L     /* Free Action */
#define TR2_HOLD_LIFE           0x00008000L     /* Hold Life */
#define TR2_RES_ACID            0x00010000L
#define TR2_RES_ELEC            0x00020000L
#define TR2_RES_FIRE            0x00040000L
#define TR2_RES_COLD            0x00080000L
#define TR2_RES_POIS            0x00100000L
#define TR2_RES_FEAR            0x00200000L     /* Added for Zangband */
#define TR2_RES_LITE            0x00400000L
#define TR2_RES_DARK            0x00800000L
#define TR2_RES_BLIND           0x01000000L
#define TR2_RES_CONF            0x02000000L
#define TR2_RES_SOUND           0x04000000L
#define TR2_RES_SHARDS          0x08000000L
#define TR2_RES_NETHER          0x10000000L
#define TR2_RES_NEXUS           0x20000000L
#define TR2_RES_CHAOS           0x40000000L
#define TR2_RES_DISEN           0x80000000L


#define TR3_SH_FIRE             0x00000001L     /* Immolation (Fire) */
#define TR3_SH_ELEC             0x00000002L     /* Electric Sheath */
#define TR3_XXX1                0x00000004L
#define TR3_SH_COLD             0x00000008L     /* Cold Aura */
#define TR3_NO_TELE             0x00000010L     /* Anti-teleportation */
#define TR3_NO_MAGIC            0x00000020L     /* Anti-magic */
#define TR3_WRAITH              0x00000040L     /* Wraithform */
#define TR3_TY_CURSE            0x00000080L     /* The Ancient Curse */
#define TR3_WARNING             0x00000100L		/* Warning */
#define TR3_HIDE_TYPE           0x00000200L     /* Hide "pval" description */
#define TR3_SHOW_MODS           0x00000400L     /* Always show Tohit/Todam */
#define TR3_DEC_MANA            0x00000800L     /* ??? */
#define TR3_FEATHER             0x00001000L     /* Feather Falling */
#define TR3_LITE                0x00002000L     /* Permanent Light */
#define TR3_SEE_INVIS           0x00004000L     /* See Invisible */
#define TR3_TELEPATHY           0x00008000L     /* Telepathy */
#define TR3_SLOW_DIGEST         0x00010000L     /* Item slows down digestion */
#define TR3_REGEN               0x00020000L     /* Item induces regeneration */
#define TR3_XTRA_MIGHT          0x00040000L     /* Bows get extra multiplier */
#define TR3_XTRA_SHOTS          0x00080000L     /* Bows get extra shots */
#define TR3_IGNORE_ACID         0x00100000L     /* Item ignores Acid Damage */
#define TR3_IGNORE_ELEC         0x00200000L     /* Item ignores Elec Damage */
#define TR3_IGNORE_FIRE         0x00400000L     /* Item ignores Fire Damage */
#define TR3_IGNORE_COLD         0x00800000L     /* Item ignores Cold Damage */
#define TR3_ACTIVATE            0x01000000L     /* Item can be activated */
#define TR3_DRAIN_EXP           0x02000000L     /* Item drains Experience */
#define TR3_TELEPORT            0x04000000L     /* Item teleports player */
#define TR3_AGGRAVATE           0x08000000L     /* Item aggravates monsters */
#define TR3_BLESSED             0x10000000L     /* Item is Blessed */
#define TR3_CURSED              0x20000000L     /* Item is Cursed */
#define TR3_HEAVY_CURSE         0x40000000L     /* Item is Heavily Cursed */
#define TR3_PERMA_CURSE         0x80000000L     /* Item is Perma Cursed */


#define TRG_INSTA_ART           0x00000001L     /* Item must be an artifact */
#define TRG_QUESTITEM           0x00000002L     /* quest level item -KMW- */
#define TRG_XTRA_POWER          0x00000004L     /* Extra power */
#define TRG_ONE_SUSTAIN         0x00000008L     /* One sustain */
#define TRG_XTRA_RES_OR_POWER   0x00000010L     /* Extra resistance or power */
#define TRG_XTRA_H_RES          0x00000020L     /* Extra high resistance */
#define TRG_XTRA_E_RES          0x00000040L     /* Extra element resistance */
#define TRG_XTRA_L_RES          0x00000080L     /* Extra lordly resistance */
#define TRG_XTRA_D_RES          0x00000100L     /* Extra dragon resistance */
#define TRG_XTRA_RES            0x00000200L     /* Extra resistance */
#define TRG_FIXED_FLAVOR        0x00000400L
#define TRG_XTRA_PLUS           0x00000800L     /* Extra status plus */
#define TRG_XTRA_BRAND          0x00001000L     /* Extra brand */
#define TRG_XTRA_SLAY           0x00002000L     /* Extra sray */
#define TRG_XTRA_ACT            0x00004000L     /* Extra activation */


/*
 * Hack -- flag set 1 -- mask for "pval-dependant" flags.
 * Note that all "pval" dependant flags must be in "flags1".
 */
#define TR1_PVAL_MASK   \
	(TR1_STR | TR1_INT | TR1_WIS | TR1_DEX | \
     TR1_CON | TR1_CHR | TR1_MAGIC_MASTERY | \
	 TR1_STEALTH | TR1_SEARCH | TR1_INFRA | TR1_TUNNEL | \
     TR1_SPEED | TR1_BLOWS)



/*** Monster blow constants ***/


/*
 * New monster blow methods
 */
#define RBM_HIT          1
#define RBM_TOUCH        2
#define RBM_PUNCH        3
#define RBM_KICK         4
#define RBM_CLAW         5
#define RBM_BITE         6
#define RBM_STING        7
#define RBM_SLASH         8
#define RBM_BUTT         9
#define RBM_CRUSH       10
#define RBM_ENGULF      11
#define RBM_CHARGE      12
#define RBM_CRAWL       13
#define RBM_DROOL       14
#define RBM_SPIT        15
#define RBM_EXPLODE     16
#define RBM_GAZE        17
#define RBM_WAIL        18
#define RBM_SPORE       19
#define RBM_XXX4        20
#define RBM_BEG         21
#define RBM_INSULT      22
#define RBM_MOAN        23
#define RBM_SHOW        24


/*
 * New monster blow effects
 */
#define RBE_HURT         1
#define RBE_POISON       2
#define RBE_UN_BONUS     3
#define RBE_UN_POWER     4
#define RBE_EAT_GOLD     5
#define RBE_EAT_ITEM     6
#define RBE_EAT_FOOD     7
#define RBE_EAT_LITE     8
#define RBE_ACID         9
#define RBE_ELEC        10
#define RBE_FIRE        11
#define RBE_COLD        12
#define RBE_BLIND       13
#define RBE_CONFUSE     14
#define RBE_TERRIFY     15
#define RBE_PARALYZE    16
#define RBE_LOSE_STR    17
#define RBE_LOSE_INT    18
#define RBE_LOSE_WIS    19
#define RBE_LOSE_DEX    20
#define RBE_LOSE_CON    21
#define RBE_LOSE_CHR    22
#define RBE_LOSE_ALL    23
#define RBE_SHATTER     24
#define RBE_EXP_10      25
#define RBE_EXP_20      26
#define RBE_EXP_40      27
#define RBE_EXP_80      28
#define RBE_DISEASE     29
#define RBE_TIME        30
#define RBE_EXP_VAMP    31


/*** Monster flag values (hard-coded) ***/


/*
 * New monster race bit flags
 */
#define RF1_UNIQUE              0x00000001  /* Unique Monster */
#define RF1_QUESTOR             0x00000002  /* Quest Monster */
#define RF1_MALE                0x00000004  /* Male gender */
#define RF1_FEMALE              0x00000008  /* Female gender */
#define RF1_CHAR_CLEAR          0x00000010  /* Absorbs symbol */
#define RF1_CHAR_MULTI          0x00000020  /* Changes symbol */
#define RF1_ATTR_CLEAR          0x00000040  /* Absorbs color */
#define RF1_ATTR_MULTI          0x00000080  /* Changes color */
#define RF1_FORCE_DEPTH         0x00000100  /* Start at "correct" depth */
#define RF1_FORCE_MAXHP         0x00000200  /* Start with max hitpoints */
#define RF1_FORCE_SLEEP         0x00000400  /* Start out sleeping */
#define RF1_FORCE_EXTRA         0x00000800  /* Start out something */
#define RF1_FRIEND              0x00001000  /* Arrive with a friend */
#define RF1_FRIENDS             0x00002000  /* Arrive with some friends */
#define RF1_ESCORT              0x00004000  /* Arrive with an escort */
#define RF1_ESCORTS             0x00008000  /* Arrive with some escorts */
#define RF1_NEVER_BLOW          0x00010000  /* Never make physical blow */
#define RF1_NEVER_MOVE          0x00020000  /* Never make physical move */
#define RF1_RAND_25             0x00040000  /* Moves randomly (25%) */
#define RF1_RAND_50             0x00080000  /* Moves randomly (50%) */
#define RF1_ONLY_GOLD           0x00100000  /* Drop only gold */
#define RF1_ONLY_ITEM           0x00200000  /* Drop only items */
#define RF1_DROP_60             0x00400000  /* Drop an item/gold (60%) */
#define RF1_DROP_90             0x00800000  /* Drop an item/gold (90%) */
#define RF1_DROP_1D2            0x01000000  /* Drop 1d2 items/gold */
#define RF1_DROP_2D2            0x02000000  /* Drop 2d2 items/gold */
#define RF1_DROP_3D2            0x04000000  /* Drop 3d2 items/gold */
#define RF1_DROP_4D2            0x08000000  /* Drop 4d2 items/gold */
#define RF1_DROP_GOOD           0x10000000  /* Drop good items */
#define RF1_DROP_GREAT          0x20000000  /* Drop great items */
#define RF1_DROP_USEFUL         0x40000000  /* Drop "useful" items */
#define RF1_DROP_CHOSEN         0x80000000  /* Drop "chosen" items */

/*
 * New monster race bit flags
 */
#define RF2_STUPID          0x00000001  /* Monster is stupid */
#define RF2_SMART           0x00000002  /* Monster is smart */
#define RF2_CAN_SPEAK       0x00000004  /* TY: can speak */
#define RF2_REFLECTING      0x00000008  /* Reflects bolts */
#define RF2_INVISIBLE       0x00000010  /* Monster avoids vision */
#define RF2_COLD_BLOOD      0x00000020  /* Monster avoids infra */
#define RF2_EMPTY_MIND      0x00000040  /* Monster avoids telepathy */
#define RF2_WEIRD_MIND      0x00000080  /* Monster avoids telepathy? */
#define RF2_MULTIPLY        0x00000100  /* Monster reproduces */
#define RF2_REGENERATE      0x00000200  /* Monster regenerates */
#define RF2_SHAPECHANGER    0x00000400  /* TY: shapechanger */
#define RF2_ATTR_ANY        0x00000800  /* TY: Attr_any */
#define RF2_POWERFUL        0x00001000  /* Monster has strong breath */
#define RF2_ELDRITCH_HORROR 0x00002000  /* Sanity-blasting horror    */
#define RF2_AURA_FIRE       0x00004000  /* Burns in melee */
#define RF2_AURA_ELEC       0x00008000  /* Shocks in melee */
#define RF2_OPEN_DOOR       0x00010000  /* Monster can open doors */
#define RF2_BASH_DOOR       0x00020000  /* Monster can bash doors */
#define RF2_PASS_WALL       0x00040000  /* Monster can pass walls */
#define RF2_KILL_WALL       0x00080000  /* Monster can destroy walls */
#define RF2_MOVE_BODY       0x00100000  /* Monster can move monsters */
#define RF2_KILL_BODY       0x00200000  /* Monster can kill monsters */
#define RF2_TAKE_ITEM       0x00400000  /* Monster can pick up items */
#define RF2_KILL_ITEM       0x00800000  /* Monster can crush items */
#define RF2_BRAIN_1         0x01000000
#define RF2_BRAIN_2         0x02000000
#define RF2_BRAIN_3         0x04000000
#define RF2_BRAIN_4         0x08000000
#define RF2_BRAIN_5         0x10000000
#define RF2_BRAIN_6         0x20000000
#define RF2_BRAIN_7         0x40000000
#define RF2_QUANTUM         0x80000000  /* Monster has quantum behavior */

/*
 * New monster race bit flags
 */
#define RF3_ORC             0x00000001  /* Orc */
#define RF3_TROLL           0x00000002  /* Troll */
#define RF3_GIANT           0x00000004  /* Giant */
#define RF3_DRAGON          0x00000008  /* Dragon */
#define RF3_DEMON           0x00000010  /* Demon */
#define RF3_UNDEAD          0x00000020  /* Undead */
#define RF3_EVIL            0x00000040  /* Evil */
#define RF3_ANIMAL          0x00000080  /* Animal */
#define RF3_HUMAN           0x00000100  /* Human */
#define RF3_GOOD            0x00000200  /* Good */
#define RF3_AURA_COLD       0x00000400  /* Freezes in melee */
#define RF3_NONLIVING       0x00000800  /* TY: Non-Living (?) */
#define RF3_HURT_LITE       0x00001000  /* Hurt by lite */
#define RF3_HURT_ROCK       0x00002000  /* Hurt by rock remover */
#define RF3_HURT_FIRE       0x00004000  /* Hurt badly by fire */
#define RF3_HURT_COLD       0x00008000  /* Hurt badly by cold */
#define RF3_IM_ACID         0x00010000  /* Resist acid a lot */
#define RF3_IM_ELEC         0x00020000  /* Resist elec a lot */
#define RF3_IM_FIRE         0x00040000  /* Resist fire a lot */
#define RF3_IM_COLD         0x00080000  /* Resist cold a lot */
#define RF3_IM_POIS         0x00100000  /* Resist poison a lot */
#define RF3_RES_TELE        0x00200000  /* Resist teleportation */
#define RF3_RES_NETH        0x00400000  /* Resist nether a lot */
#define RF3_RES_WATE        0x00800000  /* Resist water */
#define RF3_RES_PLAS        0x01000000  /* Resist plasma */
#define RF3_RES_NEXU        0x02000000  /* Resist nexus */
#define RF3_RES_DISE        0x04000000  /* Resist disenchantment */
#define RF3_UNIQUE_7        0x08000000  /* Is a "Nazgul" unique */
#define RF3_NO_FEAR         0x10000000  /* Cannot be scared */
#define RF3_NO_STUN         0x20000000  /* Cannot be stunned */
#define RF3_NO_CONF         0x40000000  /* Cannot be confused */
#define RF3_NO_SLEEP        0x80000000  /* Cannot be slept */

/*
 * New monster race bit flags
 */
#define RF4_SHRIEK          0x00000001  /* Shriek for help */
#define RF4_THROW           0x00000002  /* Throw Rock */
#define RF4_BA_LITE         0x00000004  /* Star Burst */
#define RF4_ROCKET          0x00000008  /* TY: Rocket */
#define RF4_ARROW_1         0x00000010  /* Fire an arrow (light) */
#define RF4_ARROW_2         0x00000020  /* Fire an arrow (heavy) */
#define RF4_ARROW_3         0x00000040  /* Fire missiles (light) */
#define RF4_ARROW_4         0x00000080  /* Fire missiles (heavy) */
#define RF4_BR_ACID         0x00000100  /* Breathe Acid */
#define RF4_BR_ELEC         0x00000200  /* Breathe Elec */
#define RF4_BR_FIRE         0x00000400  /* Breathe Fire */
#define RF4_BR_COLD         0x00000800  /* Breathe Cold */
#define RF4_BR_POIS         0x00001000  /* Breathe Poison */
#define RF4_BR_NETH         0x00002000  /* Breathe Nether */
#define RF4_BR_LITE         0x00004000  /* Breathe Lite */
#define RF4_BR_DARK         0x00008000  /* Breathe Dark */
#define RF4_BR_CONF         0x00010000  /* Breathe Confusion */
#define RF4_BR_SOUN         0x00020000  /* Breathe Sound */
#define RF4_BR_CHAO         0x00040000  /* Breathe Chaos */
#define RF4_BR_DISE         0x00080000  /* Breathe Disenchant */
#define RF4_BR_NEXU         0x00100000  /* Breathe Nexus */
#define RF4_BR_TIME         0x00200000  /* Breathe Time */
#define RF4_BR_INER         0x00400000  /* Breathe Inertia */
#define RF4_BR_GRAV         0x00800000  /* Breathe Gravity */
#define RF4_BR_SHAR         0x01000000  /* Breathe Shards */
#define RF4_BR_PLAS         0x02000000  /* Breathe Plasma */
#define RF4_BR_WALL         0x04000000  /* Breathe Force */
#define RF4_BR_MANA         0x08000000  /* Breathe Mana */
#define RF4_BA_NUKE         0x10000000  /* TY: Nuke Ball */
#define RF4_BR_NUKE         0x20000000  /* TY: Toxic Breath */
#define RF4_BA_CHAO         0x40000000  /* TY: Logrus Ball */
#define RF4_BR_DISI         0x80000000  /* Breathe Disintegration */

/*
 * New monster race bit flags
 */
#define RF5_BA_ACID         0x00000001  /* Acid Ball */
#define RF5_BA_ELEC         0x00000002  /* Elec Ball */
#define RF5_BA_FIRE         0x00000004  /* Fire Ball */
#define RF5_BA_COLD         0x00000008  /* Cold Ball */
#define RF5_BA_POIS         0x00000010  /* Poison Ball */
#define RF5_BA_NETH         0x00000020  /* Nether Ball */
#define RF5_BA_WATE         0x00000040  /* Water Ball */
#define RF5_BA_MANA         0x00000080  /* Mana Storm */
#define RF5_BA_DARK         0x00000100  /* Darkness Storm */
#define RF5_DRAIN_MANA      0x00000200  /* Drain Mana */
#define RF5_MIND_BLAST      0x00000400  /* Blast Mind */
#define RF5_BRAIN_SMASH     0x00000800  /* Smash Brain */
#define RF5_CAUSE_1         0x00001000  /* Cause Light Wound */
#define RF5_CAUSE_2         0x00002000  /* Cause Serious Wound */
#define RF5_CAUSE_3         0x00004000  /* Cause Critical Wound */
#define RF5_CAUSE_4         0x00008000  /* Cause Mortal Wound */
#define RF5_BO_ACID         0x00010000  /* Acid Bolt */
#define RF5_BO_ELEC         0x00020000  /* Elec Bolt (unused) */
#define RF5_BO_FIRE         0x00040000  /* Fire Bolt */
#define RF5_BO_COLD         0x00080000  /* Cold Bolt */
#define RF5_BO_POIS         0x00100000  /* Poison Bolt (unused) */
#define RF5_BO_NETH         0x00200000  /* Nether Bolt */
#define RF5_BO_WATE         0x00400000  /* Water Bolt */
#define RF5_BO_MANA         0x00800000  /* Mana Bolt */
#define RF5_BO_PLAS         0x01000000  /* Plasma Bolt */
#define RF5_BO_ICEE         0x02000000  /* Ice Bolt */
#define RF5_MISSILE         0x04000000  /* Magic Missile */
#define RF5_SCARE           0x08000000  /* Frighten Player */
#define RF5_BLIND           0x10000000  /* Blind Player */
#define RF5_CONF            0x20000000  /* Confuse Player */
#define RF5_SLOW            0x40000000  /* Slow Player */
#define RF5_HOLD            0x80000000  /* Paralyze Player */

/*
 * New monster race bit flags
 */
#define RF6_HASTE           0x00000001  /* Speed self */
#define RF6_HAND_DOOM       0x00000002  /* Hand of Doom */
#define RF6_HEAL            0x00000004  /* Heal self */
#define RF6_INVULNER        0x00000008  /* INVULNERABILITY! */
#define RF6_BLINK           0x00000010  /* Teleport Short */
#define RF6_TPORT           0x00000020  /* Teleport Long */
#define RF6_XXX3            0x00000040  /* Move to Player (?) */
#define RF6_XXX4            0x00000080  /* Move to Monster (?) */
#define RF6_TELE_TO         0x00000100  /* Move player to monster */
#define RF6_TELE_AWAY       0x00000200  /* Move player far away */
#define RF6_TELE_LEVEL      0x00000400  /* Move player vertically */
#define RF6_XXX5            0x00000800  /* Move player (?) */
#define RF6_DARKNESS        0x00001000  /* Create Darkness */
#define RF6_TRAPS           0x00002000  /* Create Traps */
#define RF6_FORGET          0x00004000  /* Cause amnesia */
#define RF6_RAISE_DEAD      0x00008000  /* Raise Dead */
#define RF6_S_KIN           0x00010000  /* Summon "kin" */
#define RF6_S_CYBER         0x00020000  /* Summon Cyberdemons! */
#define RF6_S_MONSTER       0x00040000  /* Summon Monster */
#define RF6_S_MONSTERS      0x00080000  /* Summon Monsters */
#define RF6_S_ANT           0x00100000  /* Summon Ants */
#define RF6_S_SPIDER        0x00200000  /* Summon Spiders */
#define RF6_S_HOUND         0x00400000  /* Summon Hounds */
#define RF6_S_HYDRA         0x00800000  /* Summon Hydras */
#define RF6_S_ANGEL         0x01000000  /* Summon Angel */
#define RF6_S_DEMON         0x02000000  /* Summon Demon */
#define RF6_S_UNDEAD        0x04000000  /* Summon Undead */
#define RF6_S_DRAGON        0x08000000  /* Summon Dragon */
#define RF6_S_HI_UNDEAD     0x10000000  /* Summon Greater Undead */
#define RF6_S_HI_DRAGON     0x20000000  /* Summon Ancient Dragon */
#define RF6_S_HI_DEMON      0x40000000  /* Summon Greater Demon */
#define RF6_S_UNIQUE        0x80000000  /* Summon Unique Monster */

/*
 * New monster race bit flags
 */
#define RF7_AQUATIC             0x00000001  /* Aquatic monster */
#define RF7_CAN_SWIM            0x00000002  /* Monster can swim */
#define RF7_CAN_FLY             0x00000004  /* Monster can fly */
#define RF7_FRIENDLY            0x00000008  /* Monster is friendly */
#define RF7_HAS_LITE_1          0x00000100  /* Monster carries light */
#define RF7_SELF_LITE_1         0x00000200  /* Monster lights itself */
#define RF7_HAS_LITE_2          0x00000400  /* Monster carries light */
#define RF7_SELF_LITE_2         0x00000800  /* Monster lights itself */


/*
 * Monster race flags
 */
#define RF8_WILD_ONLY           0x00000001
#define RF8_WILD_TOWN           0x00000002
#define RF8_XXX8X02             0x00000004
#define RF8_WILD_SHORE          0x00000008
#define RF8_WILD_OCEAN          0x00000010
#define RF8_WILD_WASTE          0x00000020
#define RF8_WILD_WOOD           0x00000040
#define RF8_WILD_VOLCANO        0x00000080
#define RF8_XXX8X08             0x00000100
#define RF8_WILD_MOUNTAIN       0x00000200
#define RF8_WILD_GRASS          0x00000400
#define RF8_WILD_TOO            0x80000000

/*
 * Monster drop info
 */

#define RF9_DROP_CORPSE         0x00000001
#define RF9_DROP_SKELETON       0x00000002

/*
 * Hack -- choose "intelligent" spells when desperate
 */

#define RF4_INT_MASK \
   0L

#define RF5_INT_MASK \
  (RF5_HOLD | RF5_SLOW | RF5_CONF | RF5_BLIND | RF5_SCARE)

#define RF6_INT_MASK \
   (RF6_BLINK | RF6_TPORT | RF6_TELE_LEVEL | RF6_TELE_AWAY | \
    RF6_HEAL | RF6_INVULNER | RF6_HASTE | RF6_TRAPS | \
    RF6_S_KIN | RF6_S_CYBER | RF6_S_MONSTER | RF6_S_MONSTERS | \
    RF6_S_ANT | RF6_S_SPIDER | RF6_S_HOUND | RF6_S_HYDRA | \
    RF6_S_ANGEL | RF6_S_DRAGON | RF6_S_UNDEAD | RF6_S_DEMON | \
    RF6_S_HI_DRAGON | RF6_S_HI_UNDEAD | RF6_S_HI_DEMON | RF6_S_UNIQUE)


/*
 * Hack -- "bolt" spells that may hurt fellow monsters
 */
#define RF4_BOLT_MASK \
  (RF4_ROCKET | RF4_ARROW_1 | RF4_ARROW_2 | RF4_ARROW_3 | RF4_ARROW_4)

#define RF5_BOLT_MASK \
   (RF5_BO_ACID | RF5_BO_ELEC | RF5_BO_FIRE | RF5_BO_COLD | \
    RF5_BO_POIS | RF5_BO_NETH | RF5_BO_WATE | RF5_BO_MANA | \
    RF5_BO_PLAS | RF5_BO_ICEE | RF5_MISSILE)

#define RF6_BOLT_MASK \
   0L

/*
 * Spells that hurt the player directly
 */
#define RF4_ATTACK_MASK \
	(RF4_ROCKET | RF4_ARROW_1 | RF4_ARROW_2 | RF4_ARROW_3 | RF4_ARROW_4 | \
	 RF4_BR_ACID | RF4_BR_ELEC | RF4_BR_FIRE | RF4_BR_COLD | RF4_BR_POIS | \
	 RF4_BR_NETH | RF4_BR_LITE | RF4_BR_DARK | RF4_BR_CONF | RF4_BR_SOUN | \
	 RF4_BR_CHAO | RF4_BR_DISE | RF4_BR_NEXU | RF4_BR_TIME | RF4_BR_INER | \
	 RF4_BR_GRAV | RF4_BR_SHAR | RF4_BR_PLAS | RF4_BR_WALL | RF4_BR_MANA | \
	 RF4_BA_NUKE | RF4_BR_NUKE | RF4_BA_CHAO | RF4_BR_DISI | RF4_BA_LITE | \
	 RF4_THROW)

#define RF5_ATTACK_MASK \
	(RF5_BA_ACID | RF5_BA_ELEC | RF5_BA_FIRE | RF5_BA_COLD | RF5_BA_POIS | \
	 RF5_BA_NETH | RF5_BA_WATE | RF5_BA_MANA | RF5_BA_DARK | \
	 RF5_MIND_BLAST | RF5_BRAIN_SMASH | RF5_CAUSE_1 | RF5_CAUSE_2 | \
	 RF5_CAUSE_3 | RF5_CAUSE_4 | RF5_BO_ACID | RF5_BO_ELEC | RF5_BO_FIRE | \
	 RF5_BO_COLD | RF5_BO_POIS | RF5_BO_NETH | RF5_BO_WATE | RF5_BO_MANA | \
	 RF5_BO_PLAS | RF5_BO_ICEE | RF5_MISSILE)

#define RF6_ATTACK_MASK \
	(RF6_HAND_DOOM)

/*
 * Hack -- "indirect" spells
 */
#define RF4_INDIRECT_MASK \
  (RF4_SHRIEK)

#define RF5_INDIRECT_MASK \
  0L

#define RF6_INDIRECT_MASK \
  (RF6_HASTE | RF6_HEAL | RF6_INVULNER | RF6_BLINK | \
   RF6_TPORT | RF6_TELE_TO | RF6_TRAPS |  RF6_RAISE_DEAD | \
   RF6_S_KIN | RF6_S_CYBER | RF6_S_MONSTER | RF6_S_MONSTERS | \
   RF6_S_ANT | RF6_S_SPIDER | RF6_S_HOUND | RF6_S_HYDRA | \
   RF6_S_ANGEL | RF6_S_DEMON | RF6_S_UNDEAD | RF6_S_DRAGON | \
   RF6_S_HI_UNDEAD | RF6_S_HI_DRAGON | RF6_S_HI_DEMON | RF6_S_UNIQUE)

/*
 * Spells that allow the caster to escape
 */
#define RF4_ESCAPE_MASK \
	(0L)

#define RF5_ESCAPE_MASK \
	(0L)

#define RF6_ESCAPE_MASK \
	(RF6_BLINK | RF6_TPORT | RF6_TELE_AWAY | RF6_TELE_LEVEL)



/*
 * Hack -- 'ball' spells that may hurt friends
 */
#define RF4_BALL_MASK \
	(RF4_ROCKET | RF4_BR_ACID | RF4_BR_ELEC | RF4_BR_FIRE | \
	RF4_BR_COLD | RF4_BR_POIS | RF4_BR_NETH | RF4_BR_LITE | \
	RF4_BR_DARK | RF4_BR_CONF | RF4_BR_SOUN | RF4_BR_CHAO | \
	RF4_BR_DISE | RF4_BR_NEXU | RF4_BR_SHAR | \
	RF4_BR_SOUN | RF4_BR_TIME | RF4_BR_INER | RF4_BR_GRAV | \
	RF4_BR_PLAS | RF4_BR_WALL | RF4_BR_MANA | RF4_BA_NUKE | \
	RF4_BR_NUKE | RF4_BA_CHAO | RF4_BR_DISI | RF4_BA_LITE)

#define RF5_BALL_MASK \
	(RF5_BA_ACID | RF5_BA_ELEC | RF5_BA_FIRE | RF5_BA_COLD | \
	RF5_BA_NETH | RF5_BA_DARK | RF5_BA_WATE | RF5_BA_MANA)

#define RF6_BALL_MASK \
	0L


/* Hack -- summon spells */

#define RF4_SUMMON_MASK \
    0L

#define RF5_SUMMON_MASK \
    0L

#define RF6_SUMMON_MASK \
    (RF6_S_KIN | RF6_S_CYBER | RF6_S_MONSTER | RF6_S_MONSTERS | RF6_S_ANT | \
     RF6_S_SPIDER | RF6_S_HOUND | RF6_S_HYDRA | RF6_S_ANGEL | RF6_S_DEMON | \
     RF6_S_UNDEAD | RF6_S_DRAGON | RF6_S_HI_UNDEAD | RF6_S_HI_DRAGON | \
     RF6_S_HI_DEMON | RF6_S_UNIQUE)


/*
 * Spells that improve the caster's tactical position
 */
#define RF4_TACTIC_MASK \
	(0L)

#define RF5_TACTIC_MASK \
	(0L)

#define RF6_TACTIC_MASK \
	(RF6_BLINK)


/*
 * Annoying spells
 */
#define RF4_ANNOY_MASK \
	(RF4_SHRIEK)

#define RF5_ANNOY_MASK \
	(RF5_DRAIN_MANA | RF5_MIND_BLAST | RF5_BRAIN_SMASH | \
	RF5_CAUSE_1 | RF5_CAUSE_2 | RF5_CAUSE_3 | RF5_CAUSE_4 | \
	RF5_SCARE | RF5_BLIND | RF5_CONF | RF5_SLOW | RF5_HOLD)

#define RF6_ANNOY_MASK \
	(RF6_TELE_TO | RF6_DARKNESS | RF6_TRAPS | RF6_FORGET)


/*
 * Spells that increase the caster's relative speed
 */
#define RF4_HASTE_MASK \
	(0L)

#define RF5_HASTE_MASK \
	(RF5_SLOW | RF5_HOLD)

#define RF6_HASTE_MASK \
	(RF6_HASTE)

/*
 * Spells that give invulnerability
 */
#define RF4_INVULN_MASK \
	(0L)

#define RF5_INVULN_MASK \
	(0L)

#define RF6_INVULN_MASK \
	(RF6_INVULNER)

/*
 * Healing spells
 */
#define RF4_HEAL_MASK \
	(0L)

#define RF5_HEAL_MASK \
	(0L)

#define RF6_HEAL_MASK \
	(RF6_HEAL)


/*
 * Innate spell-like effects
 */
#define RF4_INNATE_MASK \
	(RF4_SHRIEK | RF4_ARROW_1 | RF4_ARROW_2 | RF4_ARROW_3 | RF4_ARROW_4 | \
	 RF4_BR_ACID | RF4_BR_ELEC | RF4_BR_FIRE | RF4_BR_COLD | RF4_BR_POIS | \
	 RF4_BR_NETH | RF4_BR_LITE | RF4_BR_DARK | RF4_BR_CONF | RF4_BR_SOUN | \
	 RF4_BR_CHAO | RF4_BR_DISE | RF4_BR_NEXU | RF4_BR_TIME | RF4_BR_INER | \
	 RF4_BR_GRAV | RF4_BR_SHAR | RF4_BR_PLAS | RF4_BR_WALL | RF4_BR_MANA | \
	 RF4_BR_NUKE | RF4_BR_DISI |  RF4_THROW)

#define RF5_INNATE_MASK \
	(0L)

#define RF6_INNATE_MASK \
	(0L)


/*** Macro Definitions ***/


/*
 * Hack -- The main "screen"
 */
#define term_screen     (angband_term[0])


/*
 * Determine if a given inventory item is "aware"
 */
#define object_aware_p(T) \
    (k_info[(T)->k_idx].aware)

/*
 * Determine if a given inventory item is "tried"
 */
#define object_tried_p(T) \
    (k_info[(T)->k_idx].tried)


/*
 * Determine if a given inventory item is "known"
 * Test One -- Check for special "known" tag
 * Test Two -- Check for "Easy Know" + "Aware" +
 *             "not Random Artifact ( for amulet and ring )"
 */
#define object_known_p(T) \
    (((T)->ident & (IDENT_KNOWN)) || \
     (k_info[(T)->k_idx].easy_know && k_info[(T)->k_idx].aware))


/*
 * Return the "attr" for a given item.
 * Use "flavor" if available.
 * Default to user definitions.
 */
#define object_attr(T) \
	((k_info[(T)->k_idx].flavor) ? \
	 (k_info[k_info[(T)->k_idx].flavor].x_attr) : \
	 (k_info[(T)->k_idx].x_attr))

/*
 * Return the "char" for a given item.
 * Use "flavor" if available.
 * Default to user definitions.
 */
#define object_char(T) \
	((k_info[(T)->k_idx].flavor) ? \
	 (k_info[k_info[(T)->k_idx].flavor].x_char) : \
	 (k_info[(T)->k_idx].x_char))

/*
 * Artifacts use the "name1" field
 */
#define artifact_p(T) \
	((T)->name1 ? TRUE : FALSE)

/*
 * Ego-Items use the "name2" field
 */
#define ego_item_p(T) \
	((T)->name2 ? TRUE : FALSE)


/*
 * Broken items.
 */
#define broken_p(T) \
	((T)->ident & (IDENT_BROKEN))

/*
 * Cursed items.
 */
#define cursed_p(T) \
	((T)->ident & (IDENT_CURSED))


/*
 * Convert an "attr"/"char" pair into a "pict" (P)
 */
#define PICT(A,C) \
	((((u16b)(A)) << 8) | ((byte)(C)))

/*
 * Convert a "pict" (P) into an "attr" (A)
 */
#define PICT_A(P) \
	((byte)((P) >> 8))

/*
 * Convert a "pict" (P) into an "char" (C)
 */
#define PICT_C(P) \
	((char)((byte)(P)))


/*
 * Convert a "location" (Y,X) into a "grid" (G)
 */
#define GRID(Y,X) \
	(256 * (Y) + (X))

/*
 * Convert a "grid" (G) into a "location" (Y)
 */
#define GRID_Y(G) \
	((int)((G) / 256U))

/*
 * Convert a "grid" (G) into a "location" (X)
 */
#define GRID_X(G) \
	((int)((G) % 256U))


/*
 * Determines if a map location is fully inside the outer walls
 */
#define in_bounds(Y,X) \
   (((Y) > 0) && ((X) > 0) && ((Y) < cur_hgt-1) && ((X) < cur_wid-1))

/*
 * Determines if a map location is on or inside the outer walls
 */
#define in_bounds2(Y,X) \
   (((Y) >= 0) && ((X) >= 0) && ((Y) < cur_hgt) && ((X) < cur_wid))

/*
 * Determines if a map location is on or inside the outer walls
 * (unsigned version)
 */
#define in_bounds2u(Y,X) \
   (((Y) < cur_hgt) && ((X) < cur_wid))

/*
 * Determines if a map location is currently "on screen" -RAK-
 * Note that "panel_contains(Y,X)" always implies "in_bounds2(Y,X)".
 */
#define panel_contains(Y,X) \
  (((Y) >= panel_row_min) && ((Y) <= panel_row_max) && \
   ((X) >= panel_col_min) && ((X) <= panel_col_max))



/*
 * Determine if a "legal" grid is a "floor" grid
 *
 * Line 1 -- forbid doors, rubble, seams, walls
 *
 * Note that the terrain features are split by a one bit test
 * into those features which block line of sight and those that
 * do not, allowing an extremely fast single bit check below.
 *
 * Add in the fact that some new terrain (water & lava) do NOT block sight
 * -KMW-
 */
#define cave_floor_bold(Y,X) \
	(!(cave[Y][X].feat & 0x20))


/*
 * Used to see if square is transparent.
 * Trees now block sight only half the time.
 */
#define cave_half_bold(Y,X) \
	((cave[Y][X].feat == FEAT_TREES) && (quick_rand()))

/*
 * Determine if a "legal" grid is a "clean" floor grid
 *
 * Line 1 -- forbid non-floors
 * Line 2 -- forbid deep water -KMW-
 * Line 3 -- forbid deep lava -KMW-
 * Line 4 -- forbid normal objects
 */
#define cave_clean_bold(Y,X) \
	(((cave[Y][X].feat == FEAT_FLOOR) || \
	  (cave[Y][X].feat == FEAT_SHAL_WATER) || \
	  (cave[Y][X].feat == FEAT_SHAL_LAVA) || \
	  (cave[Y][X].feat == FEAT_GRASS) || \
	  (cave[Y][X].feat == FEAT_DIRT)) && \
	  (cave[Y][X].o_idx == 0))

/*
 * Determine if a "legal" grid is a "gen" floor grid
 *
 * Line 1 -- forbid non-floors
 * Line 2 -- forbid water -KMW-
 * Line 3 -- forbid lava -KMW-
 * Line 4 -- forbid normal objects
 *  This function describes grids that can hold any object.
 *  Note: The *_SHAL_* possibilities are removed.
 */
#define cave_gen_bold(Y,X) \
	(((cave[Y][X].feat == FEAT_FLOOR) || \
	  (cave[Y][X].feat == FEAT_GRASS) || \
	  (cave[Y][X].feat == FEAT_DIRT)) && \
	  (cave[Y][X].o_idx == 0))


/*
 * Determine if a "legal" grid is an "empty" floor grid
 *
 * Line 1 -- forbid doors, rubble, seams, walls
 * Line 2 -- forbid normal monsters
 * Line 3 -- forbid the player
 */
#define cave_empty_bold(Y,X) \
    (cave_floor_bold(Y,X) && \
     !(cave[Y][X].m_idx) && \
     !(((Y) == py) && ((X) == px)))

/*
 * Determine if a "legal" grid is an "empty" floor grid
 * allow trees.
 * Line 1 -- forbid doors, rubble, seams, walls but allow trees.
 * Line 2 -- forbid normal monsters
 * Line 3 -- forbid the player
 */
#define cave_empty_bold2(Y,X) \
    (((cave_floor_bold(Y,X) && (cave[Y][X].feat != FEAT_DARK_PIT)) || (cave[Y][X].feat == FEAT_TREES)) && \
     !(cave[Y][X].m_idx) && \
     !(((Y) == py) && ((X) == px)))

/*
 * Determine if a "legal" grid is an "naked" floor grid
 *
 * Line 1 -- forbid non-floors, non-shallow water & lava -KMW-
 * Line 4 -- forbid normal objects
 * Line 5 -- forbid player/monsters
 */
#define cave_naked_bold(Y,X) \
	(((cave[Y][X].feat == FEAT_FLOOR) || \
	  (cave[Y][X].feat == FEAT_SHAL_WATER) || \
	  (cave[Y][X].feat == FEAT_SHAL_LAVA) || \
	  (cave[Y][X].feat == FEAT_GRASS) || \
	  (cave[Y][X].feat == FEAT_DIRT)) && \
	  (cave[Y][X].o_idx == 0) && \
	  (cave[Y][X].m_idx == 0))



/*
 * Determine if a "legal" grid is "permanent"
 *
 * Line 1   -- perma-walls
 * Line 2-3 -- stairs
 * Line 4-5 -- building doors -KMW-
 * Line 6-7 -- shop doors
 */
#define cave_perma_bold(Y,X) \
	(((cave[Y][X].feat >= FEAT_PERM_EXTRA) && \
	  (cave[Y][X].feat <= FEAT_PERM_SOLID))	|| \
	((cave[Y][X].feat == FEAT_LESS) || \
	 (cave[Y][X].feat == FEAT_MORE)) || \
	((cave[Y][X].feat == FEAT_LESS_LESS) || \
	 (cave[Y][X].feat == FEAT_MORE_MORE)) || \
	((cave[Y][X].feat >= FEAT_BLDG_HEAD) && \
	 (cave[Y][X].feat <= FEAT_BLDG_TAIL)) || \
	((cave[Y][X].feat >= FEAT_SHOP_HEAD) && \
	 (cave[Y][X].feat <= FEAT_SHOP_TAIL)) || \
	((cave[Y][X].feat >= FEAT_PATTERN_START) && \
	 (cave[Y][X].feat <= FEAT_PATTERN_XTRA2)))


/*
 * Grid based version of "cave_floor_bold()"
 */
#define cave_floor_grid(C) \
    (!((C)->feat & 0x20))

/*
 * True half the time for trees. (Block line of sight half the time.)
 */
#define cave_half_grid(C) \
    (((C)->feat == FEAT_TREES) && (quick_rand()))


/*
 * Grid based version of "cave_clean_bold()"
 */
#define cave_clean_grid(C) \
    (((C)->feat == FEAT_FLOOR) && \
     (!(C)->o_idx))

/*
 * Grid based version of "cave_empty_bold()"
 */
#define cave_empty_grid(C) \
    (cave_floor_grid(C) && \
     !((C)->m_idx) && \
     !((C) == &cave[py][px]))

/*
 * Grid based version of "cave_empty_bold()"
 */
#define cave_naked_grid(C) \
    (((C)->feat == FEAT_FLOOR) && \
     !((C)->o_idx) && \
     !((C)->m_idx) && \
     !((C) == &cave[py][px]))


/*
 * Grid based version of "cave_perma_bold()"
 */
#define cave_perma_grid(C) \
	((((C)->feat >= FEAT_PERM_EXTRA) && \
	  ((C)->feat <= FEAT_PERM_SOLID)) || \
	  ((C)->feat == FEAT_LESS) || \
	  ((C)->feat == FEAT_MORE) || \
	  ((C)->feat == FEAT_LESS_LESS) || \
	  ((C)->feat == FEAT_MORE_MORE) || \
	  ((C)->feat == FEAT_MOUNTAIN) || \
	 (((C)->feat >= FEAT_QUEST_ENTER) && \
	  ((C)->feat <= FEAT_QUEST_UP)) || \
	 (((C)->feat >= FEAT_PATTERN_START) && \
	  ((C)->feat <= FEAT_PATTERN_XTRA2)) || \
	 (((C)->feat >= FEAT_SHOP_HEAD) && \
	  ((C)->feat <= FEAT_SHOP_TAIL)) || \
	 (((C)->feat >= FEAT_BLDG_HEAD) && \
	  ((C)->feat <= FEAT_BLDG_TAIL)))


/*
 * Determine if a "legal" grid is within "los" of the player
 *
 * Note the use of comparison to zero to force a "boolean" result
 */
#define player_has_los_grid(C) \
    (((C)->info & (CAVE_VIEW)) != 0)

/*
 * Determine if a "legal" grid is within "los" of the player
 *
 * Note the use of comparison to zero to force a "boolean" result
 */
#define player_has_los_bold(Y,X) \
    ((cave[Y][X].info & (CAVE_VIEW)) != 0)


/*
 * Is the monster a pet of the player?
 */
#define is_pet(T) \
	 ((bool)(((T)->smart & SM_PET) != 0))

/*
 * Is the monster friendly toward the player?
 */
#define is_friendly(T) \
	 ((bool)(((T)->smart & SM_FRIENDLY) != 0))


/*
 * Is the monster hostile toward the player?
 */
#define is_hostile(T) \
	 ((bool)(!(is_pet(T) || is_friendly(T))))



/*
 * Is the monster seen by the player?
 */
#define is_seen(T) \
	((bool) ((T)->ml && (!ignore_unview || player_can_see_bold((T)->fy, (T)->fx))))

 
 
/*
 * Update playtime and reset start time
 */
#define update_playtime() \
{\
	u32b tmp;\
	tmp = time(NULL);\
	if (tmp > start_time) playtime += (tmp - start_time);\
	start_time = tmp;\
}

/*
 * Hack -- Prepare to use the "Secure" routines
 */
#if defined(SET_UID) && defined(SECURE)
extern int PlayerUID;
# define getuid() PlayerUID
# define geteuid() PlayerUID
#endif

/*
 * Two handed combatimg now?
 */
#define is_two_handed() \
	((inventory[INVEN_ARM].tval == TV_DIGGING) || \
	 (inventory[INVEN_ARM].tval == TV_HAFTED) || \
	 (inventory[INVEN_ARM].tval == TV_POLEARM) || \
	 (inventory[INVEN_ARM].tval == TV_SWORD))


/*** Color constants ***/


/*
 * Angband "attributes" (with symbols, and base (R,G,B) codes)
 *
 * The "(R,G,B)" codes are given in "fourths" of the "maximal" value,
 * and should "gamma corrected" on most (non-Macintosh) machines.
 */
#define TERM_DARK                0  /* 'd' */   /* 0,0,0 */
#define TERM_WHITE               1  /* 'w' */   /* 4,4,4 */
#define TERM_SLATE               2  /* 's' */   /* 2,2,2 */
#define TERM_ORANGE              3  /* 'o' */   /* 4,2,0 */
#define TERM_RED                 4  /* 'r' */   /* 3,0,0 */
#define TERM_GREEN               5  /* 'g' */   /* 0,2,1 */
#define TERM_BLUE                6  /* 'b' */   /* 0,0,4 */
#define TERM_UMBER               7  /* 'u' */   /* 2,1,0 */
#define TERM_L_DARK              8  /* 'D' */   /* 1,1,1 */
#define TERM_L_WHITE             9  /* 'W' */   /* 3,3,3 */
#define TERM_VIOLET             10  /* 'v' */   /* 4,0,4 */
#define TERM_YELLOW             11  /* 'y' */   /* 4,4,0 */
#define TERM_L_RED              12  /* 'R' */   /* 4,0,0 */
#define TERM_L_GREEN            13  /* 'G' */   /* 0,4,0 */
#define TERM_L_BLUE             14  /* 'B' */   /* 0,4,4 */
#define TERM_L_UMBER            15  /* 'U' */   /* 3,2,1 */


/*** Sound constants ***/


/*
 * Mega-Hack -- some primitive sound support (see "main-win.c")
 *
 * Some "sound" constants for "Term_xtra(TERM_XTRA_SOUND, val)"
 */
#define SOUND_HIT            1
#define SOUND_MISS           2
#define SOUND_FLEE           3
#define SOUND_DROP           4
#define SOUND_KILL           5
#define SOUND_LEVEL          6
#define SOUND_DEATH          7
#define SOUND_STUDY          8
#define SOUND_TELEPORT       9
#define SOUND_SHOOT          10
#define SOUND_QUAFF          11
#define SOUND_ZAP_ROD        12
#define SOUND_WALK           13
#define SOUND_TPOTHER        14
#define SOUND_HITWALL        15
#define SOUND_EAT            16
#define SOUND_STORE1         17
#define SOUND_STORE2         18
#define SOUND_STORE3         19
#define SOUND_STORE4         20
#define SOUND_DIG            21
#define SOUND_OPENDOOR       22
#define SOUND_SHUTDOOR       23
#define SOUND_TPLEVEL        24
#define SOUND_BELL           25
#define SOUND_NOTHING_TO_OPEN  26
#define SOUND_LOCKPICK_FAIL  27
#define SOUND_STAIRS_DOWN    28
#define SOUND_HITPOINT_WARN  29
#define SOUND_ACT_ARTIFACT   30
#define SOUND_USE_STAFF      31
#define SOUND_DESTROY        32
#define SOUND_MON_HIT        33
#define SOUND_MON_TOUCH      34
#define SOUND_MON_PUNCH      35
#define SOUND_MON_KICK       36
#define SOUND_MON_CLAW       37
#define SOUND_MON_BITE       38
#define SOUND_MON_STING      39
#define SOUND_MON_BUTT       40
#define SOUND_MON_CRUSH      41
#define SOUND_MON_ENGULF     42
#define SOUND_MON_CRAWL      43
#define SOUND_MON_DROOL      44
#define SOUND_MON_SPIT       45
#define SOUND_MON_GAZE       46
#define SOUND_MON_WAIL       47
#define SOUND_MON_SPORE      48
#define SOUND_MON_BEG        49
#define SOUND_MON_INSULT     50
#define SOUND_MON_MOAN       51
#define SOUND_RECOVER        52
#define SOUND_BLIND          53
#define SOUND_CONFUSED       54
#define SOUND_POISONED       55
#define SOUND_AFRAID         56
#define SOUND_PARALYZED      57
#define SOUND_DRUGGED        58
#define SOUND_SPEED          59
#define SOUND_SLOW           60
#define SOUND_SHIELD         61
#define SOUND_BLESSED        62
#define SOUND_HERO           63
#define SOUND_BERSERK        64
#define SOUND_PROT_EVIL      65
#define SOUND_INVULN         66
#define SOUND_SEE_INVIS      67
#define SOUND_INFRARED       68
#define SOUND_RES_ACID       69
#define SOUND_RES_ELEC       70
#define SOUND_RES_FIRE       71
#define SOUND_RES_COLD       72
#define SOUND_RES_POIS       73
#define SOUND_STUN           74
#define SOUND_CUT            75
#define SOUND_STAIRS_UP      76
#define SOUND_STORE_ENTER    77
#define SOUND_STORE_LEAVE    78
#define SOUND_STORE_HOME     79
#define SOUND_MONEY1         80
#define SOUND_MONEY2         81
#define SOUND_MONEY3         82
#define SOUND_SHOOT_HIT      83
#define SOUND_STORE5         84
#define SOUND_LOCKPICK       85
#define SOUND_DISARM         86
#define SOUND_IDENT_BAD      87
#define SOUND_IDENT_EGO      88
#define SOUND_IDENT_ART      89
#define SOUND_BR_ELEMENTS    90
#define SOUND_BR_FROST       91
#define SOUND_BR_ELEC        92
#define SOUND_BR_ACID        93
#define SOUND_BR_GAS         94
#define SOUND_BR_FIRE        95
#define SOUND_BR_CONF        96
#define SOUND_BR_DISENCHANT  97
#define SOUND_BR_CHAOS       98
#define SOUND_BR_SHARDS      99
#define SOUND_BR_SOUND       100
#define SOUND_BR_LIGHT       101
#define SOUND_BR_DARK        102
#define SOUND_BR_NETHER      103
#define SOUND_BR_NEXUS       104
#define SOUND_BR_TIME        105
#define SOUND_BR_INERTIA     106
#define SOUND_BR_GRAVITY     107
#define SOUND_BR_PLASMA      108
#define SOUND_BR_FORCE       109
#define SOUND_SUM_MONSTER    110
#define SOUND_SUM_ANGEL      111
#define SOUND_SUM_UNDEAD     112
#define SOUND_SUM_ANIMAL     113
#define SOUND_SUM_SPIDER     114
#define SOUND_SUM_HOUND      115
#define SOUND_SUM_HYDRA      116
#define SOUND_SUM_DEMON      117
#define SOUND_SUM_DRAGON     118
#define SOUND_SUM_HI_UNDEAD  119
#define SOUND_SUM_HI_DRAGON  120
#define SOUND_SUM_HI_DEMON   121
#define SOUND_SUM_WRAITH     122
#define SOUND_SUM_UNIQUE     123
#define SOUND_WIELD          124
#define SOUND_CURSED         125
#define SOUND_PSEUDOID       126
#define SOUND_HUNGRY         127
#define SOUND_NOTICE         128
#define SOUND_AMBIENT_DAY    129
#define SOUND_AMBIENT_NITE   130
#define SOUND_AMBIENT_DNG1   131
#define SOUND_AMBIENT_DNG2   132
#define SOUND_AMBIENT_DNG3   133
#define SOUND_AMBIENT_DNG4   134
#define SOUND_AMBIENT_DNG5   135
#define SOUND_CREATE_TRAP    136
#define SOUND_SHRIEK         137
#define SOUND_CAST_FEAR      138
#define SOUND_HIT_GOOD       139
#define SOUND_HIT_GREAT      140
#define SOUND_HIT_SUPERB     141
#define SOUND_HIT_HI_GREAT   142
#define SOUND_HIT_HI_SUPERB  143
#define SOUND_SPELL          144
#define SOUND_PRAYER         145
#define SOUND_KILL_UNIQUE    146
#define SOUND_KILL_KING      147
#define SOUND_DRAIN_STAT     148
#define SOUND_MULTIPLY       149


/*
 * Mega-Hack -- maximum known sounds
 */
#define SOUND_MAX 150

/*
 * Hack -- attempt to reduce various values
 */
#ifdef ANGBAND_LITE
# undef MACRO_MAX
# define MACRO_MAX      128
# undef QUARK_MAX
# define QUARK_MAX      128
# undef MESSAGE_MAX
# define MESSAGE_MAX    128
# undef MESSAGE_BUF
# define MESSAGE_BUF    4096
#endif


/*
 * Road flags
 */
#define ROAD_NORTH	1
#define ROAD_SOUTH	2
#define ROAD_EAST	4
#define ROAD_WEST	8


/*
 * Buildings actions
 */
#define BACT_NOTHING                 0
#define BACT_RESEARCH_ITEM		     1
#define BACT_TOWN_HISTORY            2
#define BACT_RACE_LEGENDS            3
#define BACT_GREET_KING              4
#define BACT_KING_LEGENDS            5
#define BACT_QUEST                   6
#define BACT_GOLD                    7
#define BACT_POSTER                  8
#define BACT_ARENA_RULES             9
#define BACT_ARENA                  10
#define BACT_ARENA_LEGENDS          11
#define BACT_IN_BETWEEN             12
#define BACT_GAMBLE_RULES           13
#define BACT_CRAPS                  14
#define BACT_SPIN_WHEEL             15
#define BACT_DICE_SLOTS             16
#define BACT_REST                   17
#define BACT_FOOD                   18
#define BACT_RUMORS                 19
#define BACT_RESEARCH_MONSTER       20
#define BACT_COMPARE_WEAPONS        21
#define BACT_LEGENDS                22
#define BACT_ENCHANT_WEAPON         23
#define BACT_ENCHANT_ARMOR          24
#define BACT_RECHARGE               25
#define BACT_IDENTS                 26
#define BACT_LEARN                  27
#define BACT_HEALING                28
#define BACT_RESTORE                29
#define BACT_ENCHANT_ARROWS         30
#define BACT_ENCHANT_BOW            31
#define BACT_GREET                  32
#define BACT_RECALL                 33
#define BACT_TELEPORT_LEVEL         34
#define BACT_LOSE_MUTATION          35
#define BACT_RECHARGE_ALL           36
#define BACT_FORGE_EGO              37
#define BACT_REPAIR_BROKEN          38
#define MAX_BACT                    39

/*
 * Quest status
 */
#define QUEST_STATUS_UNTAKEN         0
#define QUEST_STATUS_TAKEN           1
#define QUEST_STATUS_COMPLETED       2
#define QUEST_STATUS_REWARDED        3
#define QUEST_STATUS_FINISHED        4
#define QUEST_STATUS_FAILED          5
#define QUEST_STATUS_FAILED_DONE     6

/*
 * Quest type
 */
#define QUEST_TYPE_KILL_LEVEL                1
#define QUEST_TYPE_KILL_ANY_LEVEL            2
#define QUEST_TYPE_FIND_ARTIFACT             3
#define QUEST_TYPE_FIND_EXIT                 4
#define QUEST_TYPE_KILL_NUMBER               5
#define QUEST_TYPE_KILL_ALL                  6
#define QUEST_TYPE_RANDOM                    7

/*
 * Initialization flags
 */
#define INIT_SHOW_TEXT          0x01
#define INIT_ASSIGN             0x02
#define INIT_CREATE_DUNGEON     0x04
#define INIT_ONLY_FEATURES      0x08
#define INIT_ONLY_BUILDINGS     0x10

/*
 * Quest flags
 */
#define QUEST_FLAG_SILENT  0x01 /* no messages fro completion */
#define QUEST_FLAG_PRESET  0x02 /* quest is outside the main dungeon */
#define QUEST_FLAG_ONCE    0x04 /* quest is marked finished after leaving */

/*
 * Available graphic modes
 */
#define GRAPHICS_NONE       0
#define GRAPHICS_ORIGINAL   1
#define GRAPHICS_ADAM_BOLT  2
#define GRAPHICS_24X24      3

/*
 * Modes for the random name generator
 */
#define NAME_DWARF  1
#define NAME_ELF    2
#define NAME_GNOME  3
#define NAME_HOBBIT 4
#define NAME_HUMAN  5
#define NAME_ORC    6

#ifdef JP
#define JVERB_AND 1
#define JVERB_TO  2
#define JVERB_OR  3
#endif

/* Monster ID */
#define MON_MORGOTH			1
#define MON_SAURON			2
#define MON_AR_PHARAZON		125
#define MON_NAZGUL			126
#define MON_SARUMAN			132
#define MON_KHAMUL			133
#define MON_SMAUG			137
#define MON_ANGMAR			148
#define MON_GOTHMOG			154

/* XTRA HACK AUTOPICK */
#define MAX_AUTOPICK   1009
#define DO_AUTOPICK    0x01
#define DO_AUTODESTROY 0x02
#define DO_DISPLAY     0x04
#define DONT_AUTOPICK  0x08
#define ITEM_DISPLAY   0x10
#define DO_QUERY_AUTOPICK 0x20

#ifdef JP

#if 0
#define lbtokg(x) ((int)(((x)*4536)/1000))
#else
#define lbtokg(x) ((int)(((x)*5000)/1000))
#endif

#define lbtokg1(x) ((lbtokg(x)+5)/100)
#define lbtokg2(x) (((lbtokg(x)+5)%100)/10) 
#endif

/*
 * Modes for the tokenizer
 */
#define TOKENIZE_CHECKQUOTE 0x01  /* Special handling of single quotes */

/*
 * Parse errors
 */
#define PARSE_ERROR_GENERIC                  1
#define PARSE_ERROR_ABSOLETE_FILE            2
#define PARSE_ERROR_MISSING_RECORD_HEADER    3
#define PARSE_ERROR_NON_SEQUENTIAL_RECORDS   4
#define PARSE_ERROR_INVALID_FLAG             5
#define PARSE_ERROR_UNDEFINED_DIRECTIVE      6
#define PARSE_ERROR_OUT_OF_MEMORY            7
#define PARSE_ERROR_OUT_OF_BOUNDS            8
#define PARSE_ERROR_TOO_FEW_ARGUMENTS        9
#define PARSE_ERROR_MAX                     10


/*
 * Automatic note taking types
 */
#define NOTE_BIRTH          1
#define NOTE_WINNER         2
#define NOTE_SAVE_GAME      3
#define NOTE_ENTER_DUNGEON  4
#define NOTE_ABORT_GAME     5

/*
 * Player displays
 */
#define DISPLAY_PLAYER_STANDARD		0	/* standard display */
#define DISPLAY_PLAYER_HISTORY		1	/* standard display with history */
#define DISPLAY_PLAYER_SUMMARY		2	/* summary of various things */

#define DISPLAY_PLAYER_MAX		3


/*
 * Special Attacks
 */
#define ATTACK_NORMAL 0
#define ATTACK_VORPAL 1
#define ATTACK_BAKUSIN 2
#define ATTACK_TOUKI 3

/*
 * Macro trigger
 */
#define MAX_MACRO_MOD 12
#define MAX_MACRO_TRIG 200


/*
 * Special key code used for inkey_special()
 */
#define SKEY_MOD_MASK     0x0f00
#define SKEY_MOD_SHIFT    0x0100
#define SKEY_MOD_CONTROL  0x0200

#define SKEY_MASK         0xf000
#define SKEY_DOWN   	  0xf001
#define SKEY_LEFT   	  0xf002
#define SKEY_RIGHT  	  0xf003
#define SKEY_UP     	  0xf004
#define SKEY_PGUP   	  0xf005
#define SKEY_PGDOWN 	  0xf006
#define SKEY_TOP    	  0xf007
#define SKEY_BOTTOM 	  0xf008


/*
 * Range of Detections
 */
#define DETECT_RAD_DEFAULT 30
#define DETECT_RAD_MAP     30
#define DETECT_RAD_ALL     255

/*
 * Ѷ⡼ɤǤĤΥץϾONȹͤ뤿Υޥ
 */

#define X_stupid_monsters (stupid_monsters && !ironman_hengband)
#define X_flow_by_sound (flow_by_sound || ironman_hengband)
#define X_flow_by_smell (flow_by_smell || ironman_hengband)
#define X_smart_learn (smart_learn || ironman_hengband)

/*
 * Sense inventory and magic
 */
#define SENSE_CANT        0x0001
#define SENSE_POOR        0x0002
#define SENSE_BAD         0x0004
#define SENSE_SLOW        0x0008
#define SENSE_NORM        0x0010
#define SENSE_GOOD        0x0020
#define SENSE_FAST        0x0040
#define SENSE_VFST        0x0080

/* travel command */
#define TRAVEL 1

/* Patron */
#define MAX_PATRON 14
#define MAX_REWARDS     5

#define VAR_MANWE		0
#define VAR_ULMO		1
#define VAR_AULE		2
#define VAR_OROME		3
#define VAR_MANDOS		4
#define VAR_IRMO		5
#define VAR_TULKAS		6
#define VAR_VARDA		7
#define VAR_YAVANNA		8
#define VAR_NIENNA		9
#define VAR_ESTE		10
#define VAR_VAIRE		11
#define VAR_VANA		12
#define VAR_NESSA		13

/* Rewards */
#define REW_IGNORE      0
#define REW_BLESS       1
#define REW_HERO        2
#define REW_SPEED       3
#define REW_RESTORE     4
#define REW_ENLIGHT     5
#define REW_GREA_OBJ    6
#define REW_GREA_OBS    7
#define REW_GAIN_ABL    8
#define REW_AUGM_ABL    9
#define REW_POTION      10
#define REW_RE_CURSE    11
#define REW_RES_POTION  12
#define REW_MASS_GEN    13
#define REW_HEAL        14
#define REW_DISPEL_C    15
#define REW_WISHING     16
#define REW_PROTEVIL    17
#define REW_AMULET      18

/*
  Language selection macro
*/
#ifdef JP
#define _(JAPANESE,ENGLISH) (JAPANESE)
#else
#define _(JAPANESE,ENGLISH) (ENGLISH)
#endif
