/* File: tables.c */

/* Purpose: Angband Tables */

/*
 * Copyright (c) 1989 James E. Wilson, Robert A. Koeneke
 *
 * This software may be copied and distributed for educational, research, and
 * not for profit purposes provided that this copyright and statement are
 * included in all such copies.
 */

#include "angband.h"




/*
 * Global array for looping through the "keypad directions"
 */
s16b ddd[9] =
{ 2, 8, 6, 4, 3, 1, 9, 7, 5 };

/*
 * Global arrays for converting "keypad direction" into offsets
 */
s16b ddx[10] =
{ 0, -1, 0, 1, -1, 0, 1, -1, 0, 1 };

s16b ddy[10] =
{ 0, 1, 1, 1, 0, 0, 0, -1, -1, -1 };

/*
 * Global arrays for optimizing "ddx[ddd[i]]" and "ddy[ddd[i]]"
 */
s16b ddx_ddd[9] =
{ 0, 0, 1, -1, 1, -1, 1, -1, 0 };

s16b ddy_ddd[9] =
{ 1, -1, 0, 0, 1, 1, -1, -1, 0 };


/*
 * Circular keypad direction array
 */
s16b cdd[8] =
{ 2, 3, 6, 9, 8, 7, 4, 1 };

/*
 * Global arrays for optimizing "ddx[cdd[i]]" and "ddy[cdd[i]]"
 */
s16b ddx_cdd[8] =
{ 0, 1, 1, 1, 0, -1, -1, -1 };

s16b ddy_cdd[8] =
{ 1, 1, 0, -1, -1, -1, 0, 1 };



/*
 * Global array for converting numbers to uppercase hecidecimal digit
 * This array can also be used to convert a number to an octal digit
 */
char hexsym[16] =
{
	'0', '1', '2', '3', '4', '5', '6', '7',
	'8', '9', 'A', 'B', 'C', 'D', 'E', 'F'
};


/*
 * Global array for converting numbers to a logical list symbol
 */
char listsym[] =
{
	'0', '1', '2', '3', '4', '5', '6', '7', '8', '9',
	'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm',
	'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z',
	'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M',
	'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z',
	'\0'
};


/*
 * Encode the screen colors
 */
cptr color_char = "dwsorgbuDWvyRGBU";


/*
 * Stat Table (INT/WIS) -- Number of half-spells per level
 */
byte adj_mag_study[] =
{
	0	/* 3 */,
	0	/* 4 */,
	0	/* 5 */,
	0	/* 6 */,
	0	/* 7 */,
	1	/* 8 */,
	1	/* 9 */,
	1	/* 10 */,
	1	/* 11 */,
	2	/* 12 */,
	2	/* 13 */,
	2	/* 14 */,
	2	/* 15 */,
	2	/* 16 */,
	2	/* 17 */,
	2	/* 18/00-18/09 */,
	2	/* 18/10-18/19 */,
	2	/* 18/20-18/29 */,
	2	/* 18/30-18/39 */,
	2	/* 18/40-18/49 */,
	3	/* 18/50-18/59 */,
	3	/* 18/60-18/69 */,
	3	/* 18/70-18/79 */,
	3	/* 18/80-18/89 */,
	4	/* 18/90-18/99 */,
	4	/* 18/100-18/109 */,
	4	/* 18/110-18/119 */,
	5	/* 18/120-18/129 */,
	5	/* 18/130-18/139 */,
	5	/* 18/140-18/149 */,
	5	/* 18/150-18/159 */,
	5	/* 18/160-18/169 */,
	5	/* 18/170-18/179 */,
	5	/* 18/180-18/189 */,
	5	/* 18/190-18/199 */,
	5	/* 18/200-18/209 */,
	6	/* 18/210-18/219 */,
	6	/* 18/220+ */
};


/*
 * Stat Table (INT/WIS) -- extra half-mana-points per level
 */
byte adj_mag_mana[] =
{
	0       /* 3 */,
	0       /* 4 */,
	0       /* 5 */,
	0       /* 6 */,
	0       /* 7 */,
	1       /* 8 */,
	1       /* 9 */,
	2       /* 10 */,
	3       /* 11 */,
	4       /* 12 */,
	5       /* 13 */,
	6       /* 14 */,
	7       /* 15 */,
	8       /* 16 */,
	9       /* 17 */,
	10     /* 18/00-18/09 */,
	10      /* 18/10-18/19 */,
	11      /* 18/20-18/29 */,
	11     /* 18/30-18/39 */,
	12     /* 18/40-18/49 */,
	12      /* 18/50-18/59 */,
	13      /* 18/60-18/69 */,
	13      /* 18/70-18/79 */,
	14      /* 18/80-18/89 */,
	14      /* 18/90-18/99 */,
	15      /* 18/100-18/109 */,
	16      /* 18/110-18/119 */,
	17      /* 18/120-18/129 */,
	18      /* 18/130-18/139 */,
	19      /* 18/140-18/149 */,
	20      /* 18/150-18/159 */,
	21      /* 18/160-18/169 */,
	22      /* 18/170-18/179 */,
	23      /* 18/180-18/189 */,
	24      /* 18/190-18/199 */,
	25      /* 18/200-18/209 */,
	26      /* 18/210-18/219 */,
	27      /* 18/220+ */
};


/*
 * Stat Table (INT/WIS) -- Minimum failure rate (percentage)
 */
byte adj_mag_fail[] =
{
	99      /* 3 */,
	99      /* 4 */,
	99      /* 5 */,
	99      /* 6 */,
	99      /* 7 */,
	50      /* 8 */,
	30      /* 9 */,
	20      /* 10 */,
	15      /* 11 */,
	12      /* 12 */,
	11      /* 13 */,
	10      /* 14 */,
	9       /* 15 */,
	8       /* 16 */,
	7       /* 17 */,
	6       /* 18/00-18/09 */,
	6       /* 18/10-18/19 */,
	5       /* 18/20-18/29 */,
	5       /* 18/30-18/39 */,
	5       /* 18/40-18/49 */,
	4       /* 18/50-18/59 */,
	4       /* 18/60-18/69 */,
	4       /* 18/70-18/79 */,
	4       /* 18/80-18/89 */,
	3       /* 18/90-18/99 */,
	3       /* 18/100-18/109 */,
	2       /* 18/110-18/119 */,
	2       /* 18/120-18/129 */,
	2       /* 18/130-18/139 */,
	2       /* 18/140-18/149 */,
	1       /* 18/150-18/159 */,
	1       /* 18/160-18/169 */,
	1       /* 18/170-18/179 */,
	1       /* 18/180-18/189 */,
	1       /* 18/190-18/199 */,
	0       /* 18/200-18/209 */,
	0       /* 18/210-18/219 */,
	0       /* 18/220+ */
};


/*
 * Stat Table (INT/WIS) -- Various things
 */
byte adj_mag_stat[] =
{
	0       /* 3 */,
	0       /* 4 */,
	0       /* 5 */,
	0       /* 6 */,
	0       /* 7 */,
	1       /* 8 */,
	1       /* 9 */,
	1       /* 10 */,
	1       /* 11 */,
	1       /* 12 */,
	1       /* 13 */,
	1       /* 14 */,
	2       /* 15 */,
	2       /* 16 */,
	2       /* 17 */,
	3       /* 18/00-18/09 */,
	3       /* 18/10-18/19 */,
	3       /* 18/20-18/29 */,
	3       /* 18/30-18/39 */,
	3       /* 18/40-18/49 */,
	4       /* 18/50-18/59 */,
	4       /* 18/60-18/69 */,
	5       /* 18/70-18/79 */,
	6       /* 18/80-18/89 */,
	7       /* 18/90-18/99 */,
	8       /* 18/100-18/109 */,
	9       /* 18/110-18/119 */,
	10      /* 18/120-18/129 */,
	11      /* 18/130-18/139 */,
	12      /* 18/140-18/149 */,
	13      /* 18/150-18/159 */,
	14      /* 18/160-18/169 */,
	15      /* 18/170-18/179 */,
	16      /* 18/180-18/189 */,
	17      /* 18/190-18/199 */,
	18      /* 18/200-18/209 */,
	19      /* 18/210-18/219 */,
	20      /* 18/220+ */
};


/*
 * Stat Table (CHR) -- payment percentages
 */
byte adj_chr_gold[] =
{
	130     /* 3 */,
	125     /* 4 */,
	122     /* 5 */,
	120     /* 6 */,
	118     /* 7 */,
	116     /* 8 */,
	114     /* 9 */,
	112     /* 10 */,
	110     /* 11 */,
	108     /* 12 */,
	106     /* 13 */,
	104     /* 14 */,
	103     /* 15 */,
	102     /* 16 */,
	101     /* 17 */,
	100     /* 18/00-18/09 */,
	99      /* 18/10-18/19 */,
	98      /* 18/20-18/29 */,
	97      /* 18/30-18/39 */,
	96      /* 18/40-18/49 */,
	95      /* 18/50-18/59 */,
	94      /* 18/60-18/69 */,
	93      /* 18/70-18/79 */,
	92      /* 18/80-18/89 */,
	91      /* 18/90-18/99 */,
	90      /* 18/100-18/109 */,
	89      /* 18/110-18/119 */,
	88      /* 18/120-18/129 */,
	87      /* 18/130-18/139 */,
	86      /* 18/140-18/149 */,
	85      /* 18/150-18/159 */,
	84      /* 18/160-18/169 */,
	83      /* 18/170-18/179 */,
	82      /* 18/180-18/189 */,
	81      /* 18/190-18/199 */,
	80      /* 18/200-18/209 */,
	79      /* 18/210-18/219 */,
	78      /* 18/220+ */
};


/*
 * Stat Table (INT) -- Magic devices
 */
byte adj_int_dev[] =
{
	0       /* 3 */,
	0       /* 4 */,
	0       /* 5 */,
	0       /* 6 */,
	0       /* 7 */,
	1       /* 8 */,
	1       /* 9 */,
	1       /* 10 */,
	1       /* 11 */,
	1       /* 12 */,
	1       /* 13 */,
	1       /* 14 */,
	2       /* 15 */,
	2       /* 16 */,
	2       /* 17 */,
	3       /* 18/00-18/09 */,
	3       /* 18/10-18/19 */,
	4       /* 18/20-18/29 */,
	4       /* 18/30-18/39 */,
	5       /* 18/40-18/49 */,
	5       /* 18/50-18/59 */,
	6       /* 18/60-18/69 */,
	6       /* 18/70-18/79 */,
	7       /* 18/80-18/89 */,
	7       /* 18/90-18/99 */,
	8       /* 18/100-18/109 */,
	9       /* 18/110-18/119 */,
	10      /* 18/120-18/129 */,
	11      /* 18/130-18/139 */,
	12      /* 18/140-18/149 */,
	13      /* 18/150-18/159 */,
	14      /* 18/160-18/169 */,
	15      /* 18/170-18/179 */,
	16      /* 18/180-18/189 */,
	17      /* 18/190-18/199 */,
	18      /* 18/200-18/209 */,
	19      /* 18/210-18/219 */,
	20      /* 18/220+ */
};


/*
 * Stat Table (WIS) -- Saving throw
 */
byte adj_wis_sav[] =
{
	0       /* 3 */,
	0       /* 4 */,
	0       /* 5 */,
	0       /* 6 */,
	0       /* 7 */,
	1       /* 8 */,
	1       /* 9 */,
	1       /* 10 */,
	1       /* 11 */,
	1       /* 12 */,
	1       /* 13 */,
	1       /* 14 */,
	2       /* 15 */,
	2       /* 16 */,
	2       /* 17 */,
	3       /* 18/00-18/09 */,
	3       /* 18/10-18/19 */,
	3       /* 18/20-18/29 */,
	3       /* 18/30-18/39 */,
	3       /* 18/40-18/49 */,
	4       /* 18/50-18/59 */,
	4       /* 18/60-18/69 */,
	5       /* 18/70-18/79 */,
	5       /* 18/80-18/89 */,
	6       /* 18/90-18/99 */,
	7       /* 18/100-18/109 */,
	8       /* 18/110-18/119 */,
	9       /* 18/120-18/129 */,
	10      /* 18/130-18/139 */,
	11      /* 18/140-18/149 */,
	12      /* 18/150-18/159 */,
	13      /* 18/160-18/169 */,
	14      /* 18/170-18/179 */,
	15      /* 18/180-18/189 */,
	16      /* 18/190-18/199 */,
	17      /* 18/200-18/209 */,
	18      /* 18/210-18/219 */,
	19      /* 18/220+ */
};


/*
 * Stat Table (DEX) -- disarming
 */
byte adj_dex_dis[] =
{
	0       /* 3 */,
	0       /* 4 */,
	0       /* 5 */,
	0       /* 6 */,
	0       /* 7 */,
	0       /* 8 */,
	0       /* 9 */,
	0       /* 10 */,
	0       /* 11 */,
	0       /* 12 */,
	1       /* 13 */,
	1       /* 14 */,
	1       /* 15 */,
	2       /* 16 */,
	2       /* 17 */,
	4       /* 18/00-18/09 */,
	4       /* 18/10-18/19 */,
	4       /* 18/20-18/29 */,
	4       /* 18/30-18/39 */,
	5       /* 18/40-18/49 */,
	5       /* 18/50-18/59 */,
	5       /* 18/60-18/69 */,
	6       /* 18/70-18/79 */,
	6       /* 18/80-18/89 */,
	7       /* 18/90-18/99 */,
	8       /* 18/100-18/109 */,
	8       /* 18/110-18/119 */,
	8       /* 18/120-18/129 */,
	8       /* 18/130-18/139 */,
	8       /* 18/140-18/149 */,
	9       /* 18/150-18/159 */,
	9       /* 18/160-18/169 */,
	9       /* 18/170-18/179 */,
	9       /* 18/180-18/189 */,
	9       /* 18/190-18/199 */,
	10      /* 18/200-18/209 */,
	10      /* 18/210-18/219 */,
	10      /* 18/220+ */
};


/*
 * Stat Table (INT) -- disarming
 */
byte adj_int_dis[] =
{
	0       /* 3 */,
	0       /* 4 */,
	0       /* 5 */,
	0       /* 6 */,
	0       /* 7 */,
	1       /* 8 */,
	1       /* 9 */,
	1       /* 10 */,
	1       /* 11 */,
	1       /* 12 */,
	1       /* 13 */,
	1       /* 14 */,
	2       /* 15 */,
	2       /* 16 */,
	2       /* 17 */,
	3       /* 18/00-18/09 */,
	3       /* 18/10-18/19 */,
	3       /* 18/20-18/29 */,
	4       /* 18/30-18/39 */,
	4       /* 18/40-18/49 */,
	5       /* 18/50-18/59 */,
	6       /* 18/60-18/69 */,
	7       /* 18/70-18/79 */,
	8       /* 18/80-18/89 */,
	9       /* 18/90-18/99 */,
	10      /* 18/100-18/109 */,
	10      /* 18/110-18/119 */,
	11      /* 18/120-18/129 */,
	12      /* 18/130-18/139 */,
	13      /* 18/140-18/149 */,
	14      /* 18/150-18/159 */,
	15      /* 18/160-18/169 */,
	16      /* 18/170-18/179 */,
	17      /* 18/180-18/189 */,
	18      /* 18/190-18/199 */,
	19      /* 18/200-18/209 */,
	19      /* 18/210-18/219 */,
	20      /* 18/220+ */
};


/*
 * Stat Table (DEX) -- bonus to ac (plus 128)
 */
byte adj_dex_ta[] =
{
	128 + -4    /*  3 */,
	128 + -3    /*  4 */,
	128 + -2    /*  5 */,
	128 + -1    /*  6 */,
	128 + 0     /*  7 */,
	128 + 0     /*  8 */,
	128 + 0     /*  9 */,
	128 + 0     /* 10 */,
	128 + 0     /* 11 */,
	128 + 0     /* 12 */,
	128 + 0     /* 13 */,
	128 + 0     /* 14 */,
	128 + 1     /* 15 */,
	128 + 1     /* 16 */,
	128 + 1     /* 17 */,
	128 + 2     /* 18/00-18/09 */,
	128 + 2     /* 18/10-18/19 */,
	128 + 2     /* 18/20-18/29 */,
	128 + 2     /* 18/30-18/39 */,
	128 + 2     /* 18/40-18/49 */,
	128 + 3     /* 18/50-18/59 */,
	128 + 3     /* 18/60-18/69 */,
	128 + 3     /* 18/70-18/79 */,
	128 + 4     /* 18/80-18/89 */,
	128 + 5     /* 18/90-18/99 */,
	128 + 6     /* 18/100-18/109 */,
	128 + 7     /* 18/110-18/119 */,
	128 + 8     /* 18/120-18/129 */,
	128 + 9     /* 18/130-18/139 */,
	128 + 9     /* 18/140-18/149 */,
	128 + 10    /* 18/150-18/159 */,
	128 + 11    /* 18/160-18/169 */,
	128 + 12    /* 18/170-18/179 */,
	128 + 13    /* 18/180-18/189 */,
	128 + 14    /* 18/190-18/199 */,
	128 + 15    /* 18/200-18/209 */,
	128 + 15    /* 18/210-18/219 */,
	128 + 16    /* 18/220+ */
};


/*
 * Stat Table (STR) -- bonus to Deadliness (plus 128).  To compensate
 * for changes elsewhere, STR now has a larger effect. -LM-
 */
byte adj_str_td[] =
{
	128 + -2	/* 3 */,
	128 + -2	/* 4 */,
	128 + -1	/* 5 */,
	128 + -1	/* 6 */,
	128 + 0	/* 7 */,
	128 + 0	/* 8 */,
	128 + 0	/* 9 */,
	128 + 0	/* 10 */,
	128 + 0	/* 11 */,
	128 + 0	/* 12 */,
	128 + 0	/* 13 */,
	128 + 0	/* 14 */,
	128 + 0	/* 15 */,
	128 + 1	/* 16 */,
	128 + 2	/* 17 */,
	128 + 3	/* 18/00-18/09 */,
	128 + 4	/* 18/10-18/19 */,
	128 + 4	/* 18/20-18/29 */,
	128 + 5	/* 18/30-18/39 */,
	128 + 6	/* 18/40-18/49 */,
	128 + 7	/* 18/50-18/59 */,
	128 + 8	/* 18/60-18/69 */,
	128 + 9	/* 18/70-18/79 */,
	128 + 10	/* 18/80-18/89 */,
	128 + 11	/* 18/90-18/99 */,
	128 + 12	/* 18/100-18/109 */,
	128 + 13	/* 18/110-18/119 */,
	128 + 14	/* 18/120-18/129 */,
	128 + 15	/* 18/130-18/139 */,
	128 + 16	/* 18/140-18/149 */,
	128 + 17	/* 18/150-18/159 */,
	128 + 18	/* 18/160-18/169 */,
	128 + 19	/* 18/170-18/179 */,
	128 + 20	/* 18/180-18/189 */,
	128 + 21	/* 18/190-18/199 */,
	128 + 22	/* 18/200-18/209 */,
	128 + 23	/* 18/210-18/219 */,
	128 + 25	/* 18/220+ */
};


/*
 * Stat Table (DEX) -- bonus to Skill (plus 128.  To compensate for
 * changes elsewhere, DEX now has a larger effect. -LM-
 */
byte adj_dex_th[] =
{
	128 + -4	/* 3 */,
	128 + -3	/* 4 */,
	128 + -2	/* 5 */,
	128 + -1	/* 6 */,
	128 + -1	/* 7 */,
	128 + 0	/* 8 */,
	128 + 0	/* 9 */,
	128 + 0	/* 10 */,
	128 + 0	/* 11 */,
	128 + 0	/* 12 */,
	128 + 0	/* 13 */,
	128 + 0	/* 14 */,
	128 + 1	/* 15 */,
	128 + 2	/* 16 */,
	128 + 3	/* 17 */,
	128 + 3	/* 18/00-18/09 */,
	128 + 3	/* 18/10-18/19 */,
	128 + 4	/* 18/20-18/29 */,
	128 + 4	/* 18/30-18/39 */,
	128 + 4	/* 18/40-18/49 */,
	128 + 5	/* 18/50-18/59 */,
	128 + 5	/* 18/60-18/69 */,
	128 + 6	/* 18/70-18/79 */,
	128 + 6	/* 18/80-18/89 */,
	128 + 7	/* 18/90-18/99 */,
	128 + 8	/* 18/100-18/109 */,
	128 + 9	/* 18/110-18/119 */,
	128 + 10	/* 18/120-18/129 */,
	128 + 11	/* 18/130-18/139 */,
	128 + 12	/* 18/140-18/149 */,
	128 + 13	/* 18/150-18/159 */,
	128 + 14	/* 18/160-18/169 */,
	128 + 15	/* 18/170-18/179 */,
	128 + 16	/* 18/180-18/189 */,
	128 + 17	/* 18/190-18/199 */,
	128 + 18	/* 18/200-18/209 */,
	128 + 19	/* 18/210-18/219 */,
	128 + 20	/* 18/220+ */
};



/*
 * Stat Table (STR) -- weight limit in deca-pounds
 */
byte adj_str_wgt[] =
{
	5       /* 3 */,
	6       /* 4 */,
	7       /* 5 */,
	8       /* 6 */,
	9       /* 7 */,
	10      /* 8 */,
	11      /* 9 */,
	12      /* 10 */,
	13      /* 11 */,
	14      /* 12 */,
	15      /* 13 */,
	16      /* 14 */,
	17      /* 15 */,
	18      /* 16 */,
	19      /* 17 */,
	20      /* 18/00-18/09 */,
	22      /* 18/10-18/19 */,
	24      /* 18/20-18/29 */,
	26      /* 18/30-18/39 */,
	28      /* 18/40-18/49 */,
	30      /* 18/50-18/59 */,
	31      /* 18/60-18/69 */,
	31      /* 18/70-18/79 */,
	32      /* 18/80-18/89 */,
	32      /* 18/90-18/99 */,
	33      /* 18/100-18/109 */,
	33      /* 18/110-18/119 */,
	34      /* 18/120-18/129 */,
	34      /* 18/130-18/139 */,
	35      /* 18/140-18/149 */,
	35      /* 18/150-18/159 */,
	36      /* 18/160-18/169 */,
	36      /* 18/170-18/179 */,
	37      /* 18/180-18/189 */,
	37      /* 18/190-18/199 */,
	38      /* 18/200-18/209 */,
	38      /* 18/210-18/219 */,
	39      /* 18/220+ */
};


/*
 * Stat Table (STR) -- weapon weight limit in pounds
 */
byte adj_str_hold[] =
{
	4       /* 3 */,
	5       /* 4 */,
	6       /* 5 */,
	7       /* 6 */,
	8       /* 7 */,
	10      /* 8 */,
	12      /* 9 */,
	14      /* 10 */,
	16      /* 11 */,
	18      /* 12 */,
	20      /* 13 */,
	22      /* 14 */,
	24      /* 15 */,
	26      /* 16 */,
	28      /* 17 */,
	30      /* 18/00-18/09 */,
	30      /* 18/10-18/19 */,
	35      /* 18/20-18/29 */,
	40      /* 18/30-18/39 */,
	45      /* 18/40-18/49 */,
	50      /* 18/50-18/59 */,
	55      /* 18/60-18/69 */,
	60      /* 18/70-18/79 */,
	65      /* 18/80-18/89 */,
	70      /* 18/90-18/99 */,
	80      /* 18/100-18/109 */,
	80      /* 18/110-18/119 */,
	80      /* 18/120-18/129 */,
	80      /* 18/130-18/139 */,
	80      /* 18/140-18/149 */,
	90      /* 18/150-18/159 */,
	90      /* 18/160-18/169 */,
	90      /* 18/170-18/179 */,
	90      /* 18/180-18/189 */,
	90      /* 18/190-18/199 */,
	100     /* 18/200-18/209 */,
	100     /* 18/210-18/219 */,
	100     /* 18/220+ */
};


/*
 * Stat Table (STR) -- digging value
 */
byte adj_str_dig[] =
{
	0       /* 3 */,
	0       /* 4 */,
	1       /* 5 */,
	2       /* 6 */,
	3       /* 7 */,
	4       /* 8 */,
	4       /* 9 */,
	5       /* 10 */,
	5       /* 11 */,
	6       /* 12 */,
	6       /* 13 */,
	7       /* 14 */,
	7       /* 15 */,
	8       /* 16 */,
	8       /* 17 */,
	9       /* 18/00-18/09 */,
	10      /* 18/10-18/19 */,
	12      /* 18/20-18/29 */,
	15      /* 18/30-18/39 */,
	20      /* 18/40-18/49 */,
	25      /* 18/50-18/59 */,
	30      /* 18/60-18/69 */,
	35      /* 18/70-18/79 */,
	40      /* 18/80-18/89 */,
	45      /* 18/90-18/99 */,
	50      /* 18/100-18/109 */,
	55      /* 18/110-18/119 */,
	60      /* 18/120-18/129 */,
	65      /* 18/130-18/139 */,
	70      /* 18/140-18/149 */,
	75      /* 18/150-18/159 */,
	80      /* 18/160-18/169 */,
	85      /* 18/170-18/179 */,
	90      /* 18/180-18/189 */,
	95      /* 18/190-18/199 */,
	100     /* 18/200-18/209 */,
	100     /* 18/210-18/219 */,
	100     /* 18/220+ */
};


/*
 * Stat Table (STR) -- help index into the "blow" table
 */
byte adj_str_blow[] =
{
	3       /* 3 */,
	4       /* 4 */,
	5       /* 5 */,
	6       /* 6 */,
	7       /* 7 */,
	8       /* 8 */,
	9       /* 9 */,
	10      /* 10 */,
	11      /* 11 */,
	12      /* 12 */,
	13      /* 13 */,
	14      /* 14 */,
	15      /* 15 */,
	16      /* 16 */,
	17      /* 17 */,
	20 /* 18/00-18/09 */,
	30 /* 18/10-18/19 */,
	40 /* 18/20-18/29 */,
	50 /* 18/30-18/39 */,
	60 /* 18/40-18/49 */,
	70 /* 18/50-18/59 */,
	80 /* 18/60-18/69 */,
	90 /* 18/70-18/79 */,
	100 /* 18/80-18/89 */,
	110 /* 18/90-18/99 */,
	120 /* 18/100-18/109 */,
	130 /* 18/110-18/119 */,
	140 /* 18/120-18/129 */,
	150 /* 18/130-18/139 */,
	160 /* 18/140-18/149 */,
	170 /* 18/150-18/159 */,
	180 /* 18/160-18/169 */,
	190 /* 18/170-18/179 */,
	200 /* 18/180-18/189 */,
	210 /* 18/190-18/199 */,
	220 /* 18/200-18/209 */,
	230 /* 18/210-18/219 */,
	240 /* 18/220+ */
};


/*
 * Stat Table (DEX) -- index into the "blow" table
 */
byte adj_dex_blow[] =
{
	0       /* 3 */,
	0       /* 4 */,
	0       /* 5 */,
	0       /* 6 */,
	0       /* 7 */,
	0       /* 8 */,
	0       /* 9 */,
	1       /* 10 */,
	1       /* 11 */,
	1       /* 12 */,
	1       /* 13 */,
	1       /* 14 */,
	2       /* 15 */,
	2       /* 16 */,
	2       /* 17 */,
	2       /* 18/00-18/09 */,
	3       /* 18/10-18/19 */,
	3       /* 18/20-18/29 */,
	3       /* 18/30-18/39 */,
	4       /* 18/40-18/49 */,
	4       /* 18/50-18/59 */,
	5       /* 18/60-18/69 */,
	5       /* 18/70-18/79 */,
	6       /* 18/80-18/89 */,
	6       /* 18/90-18/99 */,
	7       /* 18/100-18/109 */,
	7       /* 18/110-18/119 */,
	8       /* 18/120-18/129 */,
	8       /* 18/130-18/139 */,
	9      /* 18/140-18/149 */,
	9      /* 18/150-18/159 */,
	10      /* 18/160-18/169 */,
	10      /* 18/170-18/179 */,
	11      /* 18/180-18/189 */,
	11      /* 18/190-18/199 */,
	12      /* 18/200-18/209 */,
	12      /* 18/210-18/219 */,
	13      /* 18/220+ */
};


/*
 * Stat Table (DEX) -- chance of avoiding "theft" and "falling"
 */
byte adj_dex_safe[] =
{
	0       /* 3 */,
	1       /* 4 */,
	2       /* 5 */,
	3       /* 6 */,
	4       /* 7 */,
	5       /* 8 */,
	5       /* 9 */,
	6       /* 10 */,
	6       /* 11 */,
	7       /* 12 */,
	7       /* 13 */,
	8       /* 14 */,
	8       /* 15 */,
	9       /* 16 */,
	9       /* 17 */,
	10      /* 18/00-18/09 */,
	10      /* 18/10-18/19 */,
	15      /* 18/20-18/29 */,
	15      /* 18/30-18/39 */,
	20      /* 18/40-18/49 */,
	25      /* 18/50-18/59 */,
	30      /* 18/60-18/69 */,
	35      /* 18/70-18/79 */,
	40      /* 18/80-18/89 */,
	45      /* 18/90-18/99 */,
	50      /* 18/100-18/109 */,
	60      /* 18/110-18/119 */,
	70      /* 18/120-18/129 */,
	80      /* 18/130-18/139 */,
	90      /* 18/140-18/149 */,
	100     /* 18/150-18/159 */,
	100     /* 18/160-18/169 */,
	100     /* 18/170-18/179 */,
	100     /* 18/180-18/189 */,
	100     /* 18/190-18/199 */,
	100     /* 18/200-18/209 */,
	100     /* 18/210-18/219 */,
	100     /* 18/220+ */
};


/*
 * Stat Table (CON) -- base regeneration rate
 */
byte adj_con_fix[] =
{
	0       /* 3 */,
	0       /* 4 */,
	0       /* 5 */,
	0       /* 6 */,
	0       /* 7 */,
	0       /* 8 */,
	0       /* 9 */,
	0       /* 10 */,
	0       /* 11 */,
	0       /* 12 */,
	0       /* 13 */,
	1       /* 14 */,
	1       /* 15 */,
	1       /* 16 */,
	1       /* 17 */,
	2       /* 18/00-18/09 */,
	2       /* 18/10-18/19 */,
	2       /* 18/20-18/29 */,
	2       /* 18/30-18/39 */,
	2       /* 18/40-18/49 */,
	3       /* 18/50-18/59 */,
	3       /* 18/60-18/69 */,
	3       /* 18/70-18/79 */,
	3       /* 18/80-18/89 */,
	3       /* 18/90-18/99 */,
	4       /* 18/100-18/109 */,
	4       /* 18/110-18/119 */,
	5       /* 18/120-18/129 */,
	6       /* 18/130-18/139 */,
	6       /* 18/140-18/149 */,
	7       /* 18/150-18/159 */,
	7       /* 18/160-18/169 */,
	8       /* 18/170-18/179 */,
	8       /* 18/180-18/189 */,
	8       /* 18/190-18/199 */,
	9       /* 18/200-18/209 */,
	9       /* 18/210-18/219 */,
	9       /* 18/220+ */
};


/*
 * Stat Table (CON) -- extra half-hitpoints per level (plus 128).
 * Because monsters don't breath as powerfully now, I have reduced the
 * effect of this stat. -LM-
 */
byte adj_con_mhp[] =
{
	128 + -5 /* 3 */,
	128 + -3 /* 4 */,
	128 + -2 /* 5 */,
	128 + -1 /* 6 */,
	128 + 0  /* 7 */,
	128 + 0  /* 8 */,
	128 + 0  /* 9 */,
	128 + 0  /* 10 */,
	128 + 0  /* 11 */,
	128 + 0  /* 12 */,
	128 + 0  /* 13 */,
	128 + 1  /* 14 */,
	128 + 1  /* 15 */,
	128 + 2  /* 16 */,
	128 + 3  /* 17 */,
	128 + 4  /* 18/00-18/09 */,
	128 + 5  /* 18/10-18/19 */,
	128 + 6  /* 18/20-18/29 */,
	128 + 7  /* 18/30-18/39 */,
	128 + 8  /* 18/40-18/49 */,
	128 + 9  /* 18/50-18/59 */,
	128 + 10 /* 18/60-18/69 */,
	128 + 11 /* 18/70-18/79 */,
	128 + 12 /* 18/80-18/89 */,
	128 + 14 /* 18/90-18/99 */,
	128 + 17 /* 18/100-18/109 */,
	128 + 20 /* 18/110-18/119 */,
	128 + 23 /* 18/120-18/129 */,
	128 + 26 /* 18/130-18/139 */,
	128 + 29 /* 18/140-18/149 */,
	128 + 32 /* 18/150-18/159 */,
	128 + 35 /* 18/160-18/169 */,
	128 + 38 /* 18/170-18/179 */,
	128 + 40 /* 18/180-18/189 */,
	128 + 42 /* 18/190-18/199 */,
	128 + 44 /* 18/200-18/209 */,
	128 + 46 /* 18/210-18/219 */,
	128 + 48 /* 18/220+ */
};


/*
 * This table is used to help calculate the number of blows the player can
 * make in a single round of attacks (one player turn) with a normal weapon.
 *
 * This number ranges from a single blow/round for weak players to up to six
 * blows/round for powerful warriors.
 *
 * Note that certain artifacts and ego-items give "bonus" blows/round.
 *
 * First, from the player class, we extract some values:
 *
 * Warrior      --> num = 5; mul =   5; div = MAX(30, weapon_weight);
 * Mage         --> num = 2; mul =   2; div = MAX(40, weapon_weight);
 * Priest       --> num = 4; mul =   3; div = MAX(35, weapon_weight);
 * Ranger       --> num = 4; mul = 3.5; div = MAX(35, weapon_weight);
 * Paladin      --> num = 4; mul = 4.5; div = MAX(30, weapon_weight);
 * Warrior-Mage --> num = 4; mul =   4; div = MAX(30, weapon_weight);
 * Mindcrafter  --> num = 4; mul =   3; div = MAX(30, weapon_weight);
 * Archer       --> num = 3; mul =   3; div = MAX(30, weapon_weight);
 *
 * To get "P", we look up the relevant "adj_str_blow[]" (see above),
 * multiply it by "mul", and then divide it by "div", rounding down.
 *
 * To get "D", we look up the relevant "adj_dex_blow[]" (see above),
 * note especially column 6 (DEX 18/101) and 11 (DEX 18/150).
 *
 * The player gets "blows_table[P][D]" blows/round, as shown below,
 * up to a maximum of "num" blows/round, plus any "bonus" blows/round.
 */
byte blows_table[12][12] =
{
	/* P/D */
	/*      0,   1,   2,   3,   4,   5,   6,   7,   8,   9,  10,  11+ */
	/*      3   10   15  /10  /40  /60  /80 /100 /120 /140 /160 /180  */
/* 0 */{	1,   1,   1,   2,   2,   2,   2,   2,   3,   3,   3,   4 },
/* 1 */{	1,   1,   2,   2,   2,   3,   3,   3,   3,   4,   4,   4 },
/* 2 */{	1,   2,   2,   2,   3,   3,   4,   4,   4,   5,   5,   5 },
/* 3 */{	1,   2,   2,   3,   3,   4,   4,   4,   5,   5,   5,   5 },
/* 4 */{	1,   2,   2,   3,   3,   4,   4,   5,   5,   5,   5,   5 },
/* 5 */{	1,   2,   3,   3,   4,   4,   4,   5,   5,   5,   5,   6 },
/* 6 */{	2,   2,   3,   3,   4,   4,   4,   5,   5,   5,   5,   6 },
/* 7 */{	2,   2,   3,   3,   4,   4,   4,   5,   5,   5,   5,   6 },
/* 8 */{	2,   2,   3,   3,   4,   4,   4,   5,   5,   5,   6,   6 },
/* 9 */{	2,   3,   3,   4,   4,   4,   5,   5,   5,   5,   6,   6 },
/* 10*/{	2,   3,   3,   4,   4,   4,   5,   5,   5,   6,   6,   6 },
/*11+*/{	2,   3,   3,   4,   4,   4,   5,   5,   6,   6,   6,   6 },
};


s16b arena_monsters[MAX_ARENA_MONS] =
{
	 30,	 43,	102,	118,	126,	149,	173,
	183,	188,	191,	216,	230,	238,	244,
	255,	262,	293,	297,	321,	349,	372,
	401,	415,	454,	464,	485,	538,	631,
	641
};



/*
 * Store owners (exactly four "possible" owners per store, chosen randomly)
 * { name, purse, max greed, min greed, haggle_per, tolerance, race, unused }
 *
 * Lifted extra shopkeepers from CthAngband (don't you just love open source
 * development? ;-)). Since this gave less than 32 unique names for some
 * shops, those have their first x names copied to reach 32.
 *
 * For the weapon and armour shops, several owners have a limit of 5k.
 *
 * I want to do 50k owners, but the purse is currently s16b. Perhaps
 * we should just store 1/10th of the purse?
 */
owner_type owners[MAX_STORES][MAX_OWNERS] =
{
	{
		/* General store - 32 unique names */
		{ 200, 108, _("եɥ꡼ʥӥ", "Bilbo the Friendly") },
		{ 200, 108, _("¼ԥ饹ȥ", "Raistlin the Chicken") },
		{ 300, 107, _("ؤ㤤륿", "Sultan the Midget") },
		{ 300, 107, _("ϥ󥵥ʥ饤=", "Lyar-el the Comely") },
		{ 250, 108, _("ڤʥեޥ", "Falilmawen the Friendly") },
		{ 500, 108, _("¼ԥ", "Voirin the Cowardly") },
		{ 750, 107, _("ӤΥ饷ʥ", "Erashnak the Midget") },
		{ 1000, 107, _("ϥ󥵥ʥå", "Grug the Comely") },
		{ 250, 108, _("ʥեӥ", "Forovir the Cheap") },
		{ 500, 108, _("ϼΥꥹ", "Ellis the Fool") },
		{ 750, 107, _("ʢڥΥեС", "Filbert the Hungry") },
		{ 1000, 107, _("ʡ롦", "Fthnargl Psathiggua") },
		{ 250, 108, _("Ĺभ", "Eloise Long-Dead") },
		{ 500, 108, _("ΥޤΥեǥ", "Fundi the Slow") },
		{ 750, 107, _("󥵥", "Granthus") },
		{ 1000, 107, _("ǫʥå", "Lorax the Suave") },
		{ 250, 108, _("֥å", "Butch") },
		{ 500, 108, _("٥쥹", "Elbereth the Beautiful") },
		{ 750, 107, _("쥹", "Sarleth the Sneaky") },
		{ 1000, 107, _("ʡå", "Narlock") },
		{ 250, 108, _("ӤΥإͥå", "Haneka the Small") },
		{ 500, 108, _("", "Loirin the Mad") },
		{ 750, 107, _("©Υ", "Wuto Poisonbreath") },
		{ 1000, 107, _("Ǥ֤ä祢饡", "Araaka the Rotund") },
		{ 250, 108, _("ǽʥס", "Poogor the Dumb") },
		{ 500, 108, _("եեꥢ", "Felorfiliand") },
		{ 750, 107, _("ǯޥ", "Maroka the Aged") },
		{ 1000, 107, _(" ͦʥ", "Sasin the Bold") },
		{ 250, 108, _("ļ˼ԥӥޡ", "Abiemar the Peasant") },
		{ 500, 108, _("˳ʥϡ", "Hurk the Poor") },
		{ 750, 107, _("ߤʥ", "Soalin the Wretched") },
		{ 1000, 107, _("Ǥʥ", "Merulla the Humble") },
	},
	{
		/* Armoury - 28 unique names */
		{ 10000, 115, _("=", "Kon-Dar the Ugly") },
		{ 10000, 111, _("Ǽԥ=", "Darg-Low the Grim") },
		{ 25000, 112, _("ԥǥ", "Decado the Handsome") },
		{ 30000, 112, _("결Υ", "Wieland the Smith") },
		{ 10000, 115, _("=", "Kon-Dar the Ugly") },
		{ 15000, 111, _("Ǽԥ=", "Darg-Low the Grim") },
		{ 25000, 112, _("ϥ󥵥ʥǥ", "Decado the Handsome") },
		{ 30000, 112, _("ɥ饴󥹥", "Elo Dragonscale") },
		{ 10000, 115, _("ǥꥫȥ", "Delicatus") },
		{ 15000, 111, _("ʥ롼", "Gruce the Huge") },
		{ 25000, 112, _("˥ॹ", "Animus") },
		{ 30000, 112, _("ޥ", "Malvus") },
		{ 10000, 115, _("饯", "Selaxis") },
		{ 10000, 111, _("ǥ", "Deathchill") },
		{ 25000, 112, _("ʥɥꥪ", "Drios the Faint") },
		{ 30000, 112, _("䤿Хå", "Bathric the Cold") },
		{ 10000, 115, _("󥸥", "Vengella the Cruel") },
		{ 15000, 111, _("ԥ", "Wyrana the Mighty") },
		{ 25000, 112, _("襸", "Yojo II") },
		{ 30000, 112, _("ͥʥ顼", "Ranalar the Sweet") },
		{ 5000, 115, _("ԾΥۥХ", "Horbag the Unclean") },
		{ 15000, 111, _("ƥѥΥ", "Elelen the Telepath") },
		{ 25000, 112, _("ɥꥢ", "Isedrelias") },
		{ 10000, 112, _("ܥʡ", "Vegnar One-eye") },
		{ 10000, 115, _("٤Υǥå", "Rodish the Chaotic") },
		{ 15000, 111, _("إ", "Hesin Swordmaster") },
		{ 10000, 112, _("벰Υ٥ꥹ", "Elvererith the Cheat") },
		{ 30000, 112, _("פΥ", "Zzathath the Imp") },
		{ 10000, 115, _("=", "Kon-Dar the Ugly") },
		{ 10000, 111, _("Ǽԥ=", "Darg-Low the Grim") },
		{ 25000, 112, _("ϥ󥵥ʥǥ", "Decado the Handsome") },
		{ 30000, 112, _("결Υ", "Wieland the Smith") },
	},
	{
		/* Weapon Smith - 28 unique names */
		{ 10000, 115, _("Ǧʤ륢Υ", "Arnold the Beastly") },
		{ 10000, 110, _("ûΥ", "Arndal Beast-Slayer") },
		{ 25000, 115, _("åޥΥǥ", "Eddie Beast-Master") },
		{ 30000, 112, _("εΥ饤", "Oglign Dragon-Slayer") },
		{ 10000, 115, _("ԥɥ塼", "Drew the Skilled") },
		{ 15000, 110, _("ζλҥå", "Orrax Dragonson") },
		{ 25000, 115, _("µΥ󥹥å", "Anthrax Disease-Carrier") },
		{ 30000, 112, _("ԥ륳", "Arkhoth the Stout") },
		{ 10000, 115, _("ԤΥꥢ", "Sarlyas the Rotten") },
		{ 15000, 110, _("Υȥ", "Tuethic Bare-Bones") },
		{ 25000, 115, _("ӥꥪ", "Bilious") },
		{ 30000, 112, _("ե", "Fasgul") },
		{ 10000, 115, _("ѥǥΥեꥹ", "Ellefris the Paladin") },
		{ 15000, 110, _("'ȥ'", "K'trrik'k") },
		{ 25000, 115, _("ͧɥ", "Drocus Spiderfriend") },
		{ 30000, 112, _("ͻΥե󥰥", "Fungus Giant-Slayer") },
		{ 10000, 115, _("ǥ", "Delantha") },
		{ 15000, 110, _("󥸥㡼Υӥ", "Solvistani the Ranger") },
		{ 25000, 115, _("ΥޤΥ", "Xoril the Slow") },
		{ 20000, 112, _("󡦥եå", "Aeon Flux") },
		{ 10000, 115, _("ԥʥɥå", "Nadoc the Strong") },
		{ 15000, 110, _("⥰", "Eramog the Weak") },
		{ 25000, 115, _("ʥꥹ", "Eowilith the Fair") },
		{ 30000, 112, _("ХΥҥ奤⥰", "Huimog Balrog-Slayer") },
		{ 10000, 115, _("ԡ", "Peadus the Cruel") },
		{ 15000, 110, _("⥰ 쥤䡼", "Vamog Slayer") },
		{ 25000, 115, _("աʥ", "Hooshnak the Vicious") },
		{ 30000, 112, _("ƮХ", "Balenn War-Dancer") },
		{ 10000, 115, _(" Ǧʤ륢Υ", "Arnold the Beastly") },
		{ 10000, 110, _("ûΥ", "Arndal Beast-Slayer") },
		{ 25000, 115, _("ӡȥޥǥ", "Eddie Beast-Master") },
		{ 30000, 112, _("εΥ饤", "Oglign Dragon-Slayer") },
	},
	{
		/* Temple - 22 unique names */
		{ 10000, 109, _("Ǥʥ롼ɥ", "Ludwig the Humble") },
		{ 10000, 110, _("ѥǥΥʡ", "Gunnar the Paladin") },
		{ 25000, 107, _("Ф줷ȥ", "Torin the Chosen") },
		{ 30000, 109, _("ʤ륵饹ȥ", "Sarastro the Wise") },
		{ 25000, 107, _("ѡ붪", "Sir Parsival the Pure") },
		{ 30000, 109, _("ʤ륢ʥ", "Asenath the Holy") },
		{ 10000, 109, _("ޥåΥ", "McKinnon") },
		{ 15000, 110, _("ؿ", "Mistress Chastity") },
		{ 25000, 107, _("ɥ륤ɤΥϥ˥å", "Hashnik the Druid") },
		{ 30000, 109, _("եʥ", "Finak") },
		{ 10000, 109, _("ꥭå", "Krikkik") },
		{ 15000, 110, _("Ӥԥ", "Morival the Wild") },
		{ 25000, 107, _("Ťۥå", "Hoshak the Dark") },
		{ 30000, 109, _("ԥ", "Atal the Wise") },
		{ 10000, 109, _("٥˥å", "Ibenidd the Chaste") },
		{ 15000, 110, _("ǥ", "Eridish") },
		{ 25000, 107, _("ѻեɥ", "Vrudush the Shaman") },
		{ 30000, 109, _("Υϥ", "Haob the Berserker") },
		{ 10000, 109, _("㤭ץ롼ǥ", "Proogdish the Youthfull") },
		{ 15000, 110, _("磻", "Lumwise the Mad") },
		{ 25000, 107, _("ͭԥ", "Muirt the Virtuous") },
		{ 30000, 109, _("ɥС", "Dardobard the Weak") },
		{ 5000, 109, _("Ǥʥ롼ɥ", "Ludwig the Humble") },
		{ 10000, 110, _("ѥǥΥʡ", "Gunnar the Paladin") },
		{ 25000, 107, _("Ф줷ȥ", "Torin the Chosen") },
		{ 30000, 109, _("ʤ륵饹ȥ", "Sarastro the Wise") },
		{ 25000, 107, _("ѡ붪", "Sir Parsival the Pure") },
		{ 30000, 109, _("ʤ륢ʥ", "Asenath the Holy") },
		{ 10000, 109, _("ޥåΥ", "McKinnon") },
		{ 15000, 110, _("ؿ", "Mistress Chastity") },
		{ 25000, 107, _("ɥ륤 ϥ˥å", "Hashnik the Druid") },
		{ 15000, 110, _("եʥ", "Finak") },
	},
	{
		/* Alchemist - 26 unique names */
		{ 10000, 111, _("ؼԥޥ", "Mauser the Chemist") },
		{ 10000, 110, _("Υ", "Wizzle the Chaotic") },
		{ 15000, 116, _("ߥߥ", "Midas the Greedy") },
		{ 15000, 111, _("ϼ奸=ե", "Ja-Far the Alchemist") },/*FIRST*/
		{ 15000, 116, _("饫", "Kakalrakakal") },
		{ 15000, 111, _("ϣѻե=", "Jal-Eth the Alchemist") },
		{ 10000, 111, _("ѿեͥ饹", "Fanelath the Cautious") },
		{ 10000, 110, _("Υ󥷡", "Runcie the Insane") },
		{ 15000, 116, _("֥", "Grumbleworth") },
		{ 15000, 111, _("եå", "Flitter") },
		{ 10000, 111, _("륹", "Xarillus") },
		{ 10000, 110, _("ŤС", "Egbert the Old") },
		{ 15000, 116, _("ؤ⤭ɥ", "Valindra the Proud") },
		{ 15000, 111, _("ϣѻե", "Taen the Alchemist") },
		{ 10000, 111, _("", "Cayd the Sweet") },
		{ 10000, 110, _("Ťեꥢ", "Fulir the Dark") },
		{ 15000, 116, _("Ǥʥɥ", "Domli the Humble") },
		{ 15000, 111, _("λҥ䥡å", "Yaarjukka Demonspawn") },
		{ 10000, 111, _("եɡ", "Gelaraldor the Herbmaster") },
		{ 10000, 110, _("ԥ", "Olelaldan the Wise") },
		{ 15000, 116, _("ǥ˥ȤΥե", "Fthoglo the Demonicist") },
		{ 15000, 111, _("ϣѻեɥꥢ", "Dridash the Alchemist") },
		{ 10000, 111, _("ԥͥꥢ", "Nelir the Strong") },
		{ 10000, 110, _("ɸꥰʥ", "Lignus the Pungent") },
		{ 15000, 116, _("ƥ", "Tilba") },
		{ 15000, 111, _("ߥɥå", "Myrildric the Wealthy") },
		{ 10000, 111, _("ʳؼԥޥ", "Mauser the Chemist") },
		{ 10000, 110, _("Υ", "Wizzle the Chaotic") },
		{ 15000, 116, _("ߥߥ", "Midas the Greedy") },
		{ 15000, 111, _("ϣѻե=ե", "Ja-Far the Alchemist") },
		{ 15000, 116, _("饫", "Kakalrakakal") },
		{ 15000, 111, _("ϣѻե=", "Jal-Eth the Alchemist") },
	},
	{
		/* Magic Shop - 23 unique names */
		{ 20000, 110, _("顼Υ=ѥ", "Lo Pan the Sorcerer") },
		{ 20000, 113, _("ʤ֥ӥ", "Buggerby the Great") },
		{ 30000, 110, _("ˡȤ", "The Wizard of Yendor") },
		{ 30000, 110, _("Ȥå", "Rjak the Necromancer") },
		{ 15000, 110, _("ѻեɥˡ", "Skidney the Sorcerer") },
		{ 30000, 110, _("ѻեꥢ", "Kyria the Illusionist") },
		{ 30000, 110, _("ѻե˥å", "Nikki the Necromancer") },
		{ 15000, 110, _("ȥ", "Solostoran") },
		{ 20000, 113, _("±", "Achshe the Tentacled") },
		{ 30000, 110, _("²Υ", "Kaza the Noble") },
		{ 30000, 110, _("Ťե", "Fazzil the Dark") },
		{ 15000, 110, _("ʤ륱ɡ", "Keldorn the Grand") },
		{ 20000, 113, _("ե󥹥ץ", "Philanthropus") },
		{ 30000, 110, _("Υʡ", "Agnar the Enchantress") },
		{ 30000, 110, _("ѻեӥꥢ", "Buliance the Necromancer") },
		{ 15000, 110, _("ϥᥤΥ饯", "Vuirak the High-Mage") },
		{ 20000, 113, _("ηüԥޥǥå", "Madish the Smart") },
		{ 30000, 110, _("ե֥ܡ", "Falebrimbor") },
		{ 30000, 110, _("ե=", "Felil-Gand the Subtle") },
		{ 15000, 110, _("ѻե쥴", "Thalegord the Shaman") },
		{ 20000, 113, _("ȥȥ", "Cthoaloth the Mystic") },
		{ 30000, 110, _("ѻե٥", "Ibeli the Illusionist") },
		{ 30000, 110, _("ѻեإȡ", "Heto the Necromancer") },
		{ 20000, 110, _("ѻե=ѥ", "Lo Pan the Sorcerer") },
		{ 20000, 113, _("ʤ֥ӥ", "Buggerby the Great") },
		{ 30000, 110, _("ˡȤ", "The Wizard of Yendor") },
		{ 30000, 110, _("ѻե㥯", "Rjak the Necromancer") },
		{ 15000, 110, _("ѻեɥˡ", "Skidney the Sorcerer") },
		{ 30000, 110, _("ѻեꥢ", "Kyria the Illusionist") },
		{ 30000, 110, _("ѻե˥å", "Nikki the Necromancer") },
		{ 15000, 110, _("ȥ", "Solostoran") },
		{ 20000, 113, _("±", "Achshe the Tentacled") },
	},
	{
		/* Black Market - 32 unique names */
		{ 20000, 150, _("꡼=", "Gary Gygaz") },
		{ 20000, 150, _("֥Υҥȡ", "Histor the Goblin") },
		{ 30000, 150, _("ե󥮿ͥ", "Quark the Ferengi") },
		{ 30000, 150, _("ʤ(?)ȥå", "Topi the Fair(?)") },
		{ 20000, 150, _("ͥå", "Vhassa the Dead") },
		{ 20000, 150, _("΢ڤԥ", "Kyn the Treacherous") },
		{ 30000, 150, _("֥ܥ˥", "Bubonicus") },
		{ 30000, 150, _("ץ饤", "Corpselight") },
		{ 20000, 150, _("˵ѥå", "Parrish the Bloodthirsty") },
		{ 20000, 150, _("", "Vile") },
		{ 30000, 150, _("Υץƥ", "Prentice the Trusted") },
		{ 30000, 150, _("ʹֻΥꥨ", "Griella Humanslayer") },
		{ 20000, 150, _("󥸥", "Angel") },
		{ 20000, 150, _("Ĥեĥ", "Flotsam the Bloated") },
		{ 30000, 150, _("ˡ", "Nieval") },
		{ 30000, 150, _("뤤ʥ", "Anastasia the Luminous") },
		{ 20000, 150, _("ѻեƥ", "Charity the Necromancer") },
		{ 20000, 150, _("ܥΥץʥ", "Pugnacious the Pugilist") },
		{ 30000, 150, _("ʥեåȥ", "Footsore the Lucky") },
		{ 30000, 150, _("ؤΥɥꥢ", "Sidria Lighfingered") },
		{ 20000, 150, _("ʻեꥢ", "Riatho the Juggler") },
		{ 20000, 150, _("꤯Υʥå", "Janaaka the Shifty") },
		{ 30000, 150, _("ޥ", "Cina the Rogue") },
		{ 30000, 150, _("ޥ˥å", "Arunikki Greatclaw") },
		{ 20000, 150, _("˳㥨", "Chaeand the Poor") },
		{ 20000, 150, _("±եɡ", "Afardorf the Brigand") },
		{ 30000, 150, _("ߥ饶", "Lathaxl the Greedy") },
		{ 30000, 150, _("ե쥦", "Falarewyn") },
		{ 20000, 150, _("路", "Vosur the Wrinkled") },
		{ 20000, 150, _("ϥ󥵥ʥ饪", "Araord the Handsome") },
		{ 30000, 150, _("餱ɥե", "Theradfrid the Loser") },
		{ 30000, 150, _("­Υ롼", "One-Legged Eroolo") },
	},
	{
		/* Home */
		{ 0, 100, _("椬", "Your home") },
		{ 0, 100, _("椬", "Your home") },
		{ 0, 100, _("椬", "Your home") },
		{ 0, 100, _("椬", "Your home") },
		{ 0, 100, _("椬", "Your home") },
		{ 0, 100, _("椬", "Your home") },
		{ 0, 100, _("椬", "Your home") },
		{ 0, 100, _("椬", "Your home") },
		{ 0, 100, _("椬", "Your home") },
		{ 0, 100, _("椬", "Your home") },
		{ 0, 100, _("椬", "Your home") },
		{ 0, 100, _("椬", "Your home") },
		{ 0, 100, _("椬", "Your home") },
		{ 0, 100, _("椬", "Your home") },
		{ 0, 100, _("椬", "Your home") },
		{ 0, 100, _("椬", "Your home") },
		{ 0, 100, _("椬", "Your home") },
		{ 0, 100, _("椬", "Your home") },
		{ 0, 100, _("椬", "Your home") },
		{ 0, 100, _("椬", "Your home") },
		{ 0, 100, _("椬", "Your home") },
		{ 0, 100, _("椬", "Your home") },
		{ 0, 100, _("椬", "Your home") },
		{ 0, 100, _("椬", "Your home") },
		{ 0, 100, _("椬", "Your home") },
		{ 0, 100, _("椬", "Your home") },
		{ 0, 100, _("椬", "Your home") },
		{ 0, 100, _("椬", "Your home") },
		{ 0, 100, _("椬", "Your home") },
		{ 0, 100, _("椬", "Your home") },
		{ 0, 100, _("椬", "Your home") },
		{ 0, 100, _("椬", "Your home") },
	},
	{
		/* Bookstore - 21 unique names */
		{ 10000, 108, _("ߥɥ", "Dolaf the Greedy") },
		{ 15000, 105, _("ԥɥʡ", "Odnar the Sage") },
		{ 25000, 110, _("ΩΥ", "Gandar the Neutral") },
		{ 30000, 105, _("ǦѤοͥ=", "Ro-sha the Patient") },
		{ 15000, 108, _("ɥա", "Randolph Carter") },
		{ 15000, 108, _("ȻΥ饤", "Sarai the Swift") },
		{ 20000, 105, _("Τܥɥ", "Bodril the Seer") },
		{ 25000, 110, _("ۤΥ", "Veloin the Quiet") },
		{ 30000, 105, _("ؼԤΥ󥷥饹", "Vanthylas the Learned") },
		{ 15000, 108, _("ʪ񤭥", "Ossein the Literate") },
		{ 20000, 105, _("ܤ", "Olvar Bookworm") },
		{ 25000, 110, _("", "Shallowgrave") },
		{ 30000, 105, _("ǥޥ", "Death Mask") },
		{ 15000, 108, _("ؼԤΥ", "Asuunu the Learned") },
		{ 20000, 105, _("ͤΥץ", "Prirand the Dead") },
		{ 25000, 110, _("ŴΥʡ", "Ronar the Iron") },
		{ 30000, 105, _("=ߥ", "Galil-Gamir") },
		{ 15000, 108, _("ܿХ", "Rorbag Book-Eater") },
		{ 20000, 105, _("ꥢꥭ", "Kiriarikirk") },
		{ 25000, 110, _("Ťʤ", "Rilin the Quiet") },
		{ 30000, 105, _("ԥ", "Isung the Lord") },
		{ 10000, 108, _("ߥɥ", "Dolaf the Greedy") },
		{ 15000, 105, _("ԥɥʡ", "Odnar the Sage") },
		{ 25000, 110, _("ΩΥ", "Gandar the Neutral") },
		{ 30000, 105, _("ǦѤοͥ=", "Ro-sha the Patient") },
		{ 15000, 108, _("ɥա", "Randolph Carter") },
		{ 15000, 108, _("Ȼ饤", "Sarai the Swift") },
		{ 20000, 105, _("Τܥɥ", "Bodril the Seer") },
		{ 25000, 110, _("ۤΥ", "Veloin the Quiet") },
		{ 30000, 105, _("ؼԤΥ󥷥饹", "Vanthylas the Learned") },
		{ 15000, 108, _("ʪ񤭥", "Ossein the Literate") },
		{ 20000, 105, _("ܤ", "Olvar Bookworm") },
	}
};


/*
 * This table allows quick conversion from "speed" to "energy"
 * The basic function WAS ((S>=110) ? (S-110) : (100 / (120-S)))
 * Note that table access is *much* quicker than computation.
 *
 * Note that the table has been changed at high speeds.  From
 * "Slow (-40)" to "Fast (+30)" is pretty much unchanged, but
 * at speeds above "Fast (+30)", one approaches an asymptotic
 * effective limit of 50 energy per turn.  This means that it
 * is relatively easy to reach "Fast (+30)" and get about 40
 * energy per turn, but then speed becomes very "expensive",
 * and you must get all the way to "Fast (+50)" to reach the
 * point of getting 45 energy per turn.  After that point,
 * furthur increases in speed are more or less pointless,
 * except to balance out heavy inventory.
 *
 * Note that currently the fastest monster is "Fast (+30)".
 *
 * It should be possible to lower the energy threshhold from
 * 100 units to 50 units, though this may interact badly with
 * the (compiled out) small random energy boost code.  It may
 * also tend to cause more "clumping" at high speeds.
 */
byte extract_energy[200] =
{
	/* Slow */     1,  1,  1,  1,  1,  1,  1,  1,  1,  1,
	/* Slow */     1,  1,  1,  1,  1,  1,  1,  1,  1,  1,
	/* Slow */     1,  1,  1,  1,  1,  1,  1,  1,  1,  1,
	/* Slow */     1,  1,  1,  1,  1,  1,  1,  1,  1,  1,
	/* Slow */     1,  1,  1,  1,  1,  1,  1,  1,  1,  1,
	/* Slow */     1,  1,  1,  1,  1,  1,  1,  1,  1,  1,
	/* S-50 */     1,  1,  1,  1,  1,  1,  1,  1,  1,  1,
	/* S-40 */     2,  2,  2,  2,  2,  2,  2,  2,  2,  2,
	/* S-30 */     2,  2,  2,  2,  2,  2,  2,  3,  3,  3,
	/* S-20 */     3,  3,  3,  3,  3,  4,  4,  4,  4,  4,
	/* S-10 */     5,  5,  5,  5,  6,  6,  7,  7,  8,  9,
	/* Norm */    10, 11, 12, 13, 14, 15, 16, 17, 18, 19,
	/* F+10 */    20, 21, 22, 23, 24, 25, 26, 27, 28, 29,
	/* F+20 */    30, 31, 32, 33, 34, 35, 36, 36, 37, 37,
	/* F+30 */    38, 38, 39, 39, 40, 40, 40, 41, 41, 41,
	/* F+40 */    42, 42, 42, 43, 43, 43, 44, 44, 44, 44,
	/* F+50 */    45, 45, 45, 45, 45, 46, 46, 46, 46, 46,
	/* F+60 */    47, 47, 47, 47, 47, 48, 48, 48, 48, 48,
	/* F+70 */    49, 49, 49, 49, 49, 49, 49, 49, 49, 49,
	/* Fast */    49, 49, 49, 49, 49, 49, 49, 49, 49, 49,
};




/*
 * Base experience levels, may be adjusted up for race and/or class
 */
s32b player_exp[PY_MAX_LEVEL] =
{
	10,
	25,
	45,
	70,
	100,
	140,
	200,
	280,
	380,
	500,
	650,
	850,
	1100,
	1400,
	1800,
	2300,
	2900,
	3600,
	4400,
	5400,
	6800,
	8400,
	10200,
	12500,
	17500,
	25000,
	35000L,
	50000L,
	75000L,
	100000L,
	150000L,
	200000L,
	275000L,
	350000L,
	450000L,
	550000L,
	700000L,
	850000L,
	1000000L,
	1250000L,
	1500000L,
	1800000L,
	2100000L,
	2400000L,
	2700000L,
	3000000L,
	3500000L,
	4000000L,
	4500000L,
	5000000L
};


/*
 * Player Sexes
 *
 *      Title,
 *      Winner
 */
player_sex sex_info[MAX_SEXES] =
{
	{
#ifdef JP
		"",
		"Female",
		""
#else
		"Female",
		"Queen"
#endif
	},
	{
#ifdef JP
		"",
		"Male",
		""
#else
		"Male",
		"King"
#endif
	}
};


/*
 * Player Races
 *
 *      Title,
 *      {STR,INT,WIS,DEX,CON,CHR},
 *      r_dis, r_dev, r_sav, r_stl, r_srh, r_fos, r_thn, r_thb,
 *      hitdie, exp base,
 *      Age (Base, Mod),
 *      Male (Hgt, Wgt),
 *      Female (Hgt, Wgt)
 *      infra,
 *      class-choices,
 *      can-birth
 */
player_race race_info[MAX_RACES] =
{
	{
#ifdef JP
		"ʹ",
#endif
		"Human",
		{  0,  0,  0,  0,  0,  0 },
		0, 0, 0, 0, 0, 10, 0, 0,
		10, 100,
		16, 8,
		69, 6, 160, 25,
		64, 5, 135, 20,
		0,
		0x003F,
		TRUE,
	},
	{
#ifdef JP
		"ϡե",
#endif
		"Half-Elf",
		{ -1,  1,  1,  1, -1,  1 },
		2, 3, 3, 1, 6, 11, -1, 5,
		9, 110,
		24, 16,
		71, 5, 150, 20,
		65, 4, 130, 15,
		2,
		0x003F,
		TRUE,
	},
	{
#ifdef JP
		"",
#endif
		"Elf",
		{ -1,  2,  0,  2, -2,  2 },
		5, 6, 6, 2, 8, 12, -5, 15,
		9, 120,
		75, 75,
		73, 4, 150, 10,
		66, 4, 130, 10,
		3,
		0x003F,
		TRUE,
	},
	{
#ifdef JP
		"ۥӥå",
#endif
		"Hobbit",
		{ -2,  1,  1,  3,  2,  1 },
		15, 12, 10, 4, 12, 15, -10, 20,
		7, 110,
		21, 12,
		36, 3, 60, 3,
		33, 3, 50, 3,
		4,
		0x000A,
		TRUE,
	},
	{
#ifdef JP
		"ɥ",
#endif
		"Dwarf",
		{  2, -2,  2, -2,  2, -1 },
		2, 9, 10, -1, 7, 10, 15, 0,
		11, 125,
		35, 15,
		48, 3, 150, 10,
		46, 3, 120, 10,
		5,
		0x0015,
		TRUE,
	},
	{
#ifdef JP
		"ϡե",
#endif
		"Half-Orc",
		{  2, -1,  0,  0,  1, -2 },
		-3, -3, -3, -1, 3, 7, 12, -5,
		10, 110,
		11, 4,
		66, 1, 150, 5,
		62, 1, 120, 5,
		3,
		0x0031,
		TRUE,
	},
	{
#ifdef JP
		"ɥʥ",
#endif
		"Dunadan",
		{  1,  2,  2,  2,  3,  2 },
		4, 5, 5, 1, 8, 13, 15, 10,
		11, 180,
		50, 50,
		76, 5, 175, 25,
		70, 5, 150, 20,
		0,
		0x003F,
		TRUE,
	},
	{
#ifdef JP
		"ϥ",
#endif
		"High-Elf",
		{  1,  3,  0,  3,  1,  3 },
		4,  13, 12, 3, 10, 14, 10, 25,
		10, 200,
		100, 30,
		82, 10, 190, 20,
		76, 10, 170, 15,
		4,
		0x003F,
		TRUE,
	},
	{
#ifdef JP
		"ڿ",
#endif
		"Barbarian",
		{  3, -2, -1,  1,  2, -2 },
		-2, -8, 2, -1, 1, 7, 12, 10,
		12, 120,
		14, 12,
		72, 10, 150, 35,
		66, 10, 135, 30,
		0,
		0x0009,
		TRUE,
	},
};


/*
 * Player Classes
 *
 *      Title,
 *      {STR,INT,WIS,DEX,CON,CHR},
 *      c_dis, c_dev, c_sav, c_stl, c_srh, c_fos, c_thn, c_thb,
 *      x_dis, x_dev, x_sav, x_stl, x_srh, x_fos, x_thn, x_thb,
 *      HD, Exp, pet_upkeep_div,
 *      num, wgt, mul,
 *      sense_speed, sense_ego, sence_magic
 */
player_class class_info[MAX_CLASS] =
{
	{
#ifdef JP
		"",
#endif
		"Warrior",
		{ 4, -2, -2, 2, 2, -1},
		25, 18, 28, 1,  14, 2,  70,  55,
		12, 7,  10, 0,  0,  0, 150, 150,
		9,  0, 20,
		6, 70, 50,
		SENSE_FAST, TRUE, SENSE_CANT
	},

	{
#ifdef JP
		"ᥤ",
#endif
		"Mage",
		{-4, 3, 0, 1, -2, 1},
		30, 36, 38, 2,  16, 20, 34, 20,
		7,  13, 11,  0,  0,  0,  30, 35,
		0, 30, 15,
		2, 100, 20,
		SENSE_POOR, FALSE, SENSE_FAST
	},

	{
#ifdef JP
		"ץ꡼",
#endif
		"Priest",
		{-1, -3, 3, -1, 0, 2},
		25, 24, 40, 2,  16, 8, 48, 35,
		7,  10, 12, 0,  0,  0, 65, 55,
		2, 20, 20,
		5, 100, 30,
		SENSE_FAST, FALSE, SENSE_GOOD
	},

	{
#ifdef JP
		"㡼",
#endif
		"Archer",
		{ 1, -1, -1, 2, 1, 0},
		38, 20, 35, 4, 24, 16, 56,  82,
		12,  8, 10, 0,  0,  0, 90, 180,
		4, 10, 40,
		2, 70, 20,
		SENSE_GOOD, TRUE, SENSE_CANT
	},

	{
#ifdef JP
		"ѥǥ",
#endif
		"Paladin",
		{ 2, -2, 1, 0, 2, 2},
		20, 20, 34, 1,  12, 2,  68, 40,
		7,   8, 11, 0,  0,  0, 105, 90,
		6, 35, 20,
		5, 70, 45,
		SENSE_SLOW, TRUE, SENSE_POOR
	},

	{
#ifdef JP
		"ˡ",
#endif
		"Warrior-Mage",
		{ 1, 2, 0, 1, 0, 1},
		30, 30, 36, 2,  18, 16,  65,  45,
		7,  10, 10, 0,  0,  0,  100, 135,
		4, 40, 20,
		5, 70, 40,
		SENSE_SLOW, FALSE, SENSE_BAD
	},
};


/*
 * Zangband uses this array instead of the spell flags table, as there
 * are 5 realms of magic, each with 4 spellbooks and 8 spells per book -- TY
 */
u32b fake_spell_flags[4]=
{
	0x000000ff,
	0x0000ff00,
	0x00000000,
	0x00000000
};


byte realm_choices1[MAX_CLASS] =
{
	(CH_NONE),								/* Warrior */
	(CH_SORCERY),							/* Mage */
	(CH_LIFE),								/* Priest */
	(CH_NONE),								/* Archer */
	(CH_LIFE),								/* Paladin */
	(CH_SORCERY),							/* Warrior-Mage */
};


byte realm_choices2[MAX_CLASS] =
{
	/* No realm2 */
	(CH_NONE),
	(CH_NONE),
	(CH_NONE),
	(CH_NONE),
	(CH_NONE),
	(CH_NONE),
};


#ifdef JP
cptr realm_names[] =
{
	"ˡʤ",
	"̿",
	"",
	"̵",
	"",
	"",
};

cptr E_realm_names[] =
#else
cptr realm_names[] =
#endif
{
	"no magic",
	"Life",
	"Sorcery",
	"Combat",
	"Magic",
	"unknown"
};

/*
 * Names of the spells (mage spells then priest spells)
 */
cptr spell_names[MAX_REALM][MAX_SPELLS] =
{
	/*** Life Spells ***/
	{
		/* Common Life Spellbooks */
#ifdef JP
		"ٰ¸ߴ",
		"ڽμ",
		"ʡ",
		"ξ",
		" & ⴶ",
		"ʢ­",
		"ʤ",
		"ǮѴ",
#else
		"Detect Evil",
		"Cure Light Wounds",
		"Bless",
		"Call Light",
		"Detect Doors and Traps",
		"Satisfy Hunger",
		"Holy Orb",
		"Resistance Heat & Cold",
#endif

#ifdef JP
		"̿μ",
		"",
		"",
		"մ",
		"ٰ໶",
		"ϲ",
		"ʡ",
		"С",
#else
		"Cure Critical Wounds",
		"Remove Curse",
		"Restoration",
		"Sense Surrounding",
		"Dispel Evil",
		"Healing",
		"Bless Weapon",
		"Starburst",
#endif
	},

	/*** Sorcery Spells ***/
	{
		/* Common Sorcery Spellbooks */
#ifdef JP
		"ޥåߥ",
		"硼ȥƥݡ",
		"󥹥",
		"饤ȡꥢ",
		"ƥݡ",
		"",
		"ˡϿ",
		"ƥݡȡ",
#else
		"Magic Missile",
		"Phase Door",
		"Detect Monsters",
		"Light Area",
		"Teleport",
		"Mana Burst",
		"Magic Mapping",
		"Teleport Away",
#endif

#ifdef JP
		"ϲ",
		"",
		"",
		"",
		"",
		"ԡ",
		"",
		"Ϲι",
#else
		"Stone to Mud",
		"Word of Recall",
		"Identify",
		"Drain Bolt",
		"Sense Minds",
		"Haste Self",
		"Detect All",
		"Hell Fire",
#endif
	},
};


/*
 * Each chest has a certain set of traps, determined by pval
 * Each chest has a "pval" from 1 to the chest level (max 55)
 * If the "pval" is negative then the trap has been disarmed
 * The "pval" of a chest determines the quality of its treasure
 * Note that disarming a trap on a chest also removes the lock.
 */
byte chest_traps[64] =
{
	0,                                      /* 0 == empty */
	(CHEST_POISON),
	(CHEST_LOSE_STR),
	(CHEST_LOSE_CON),
	(CHEST_LOSE_STR),
	(CHEST_LOSE_CON),                       /* 5 == best small wooden */
	0,
	(CHEST_POISON),
	(CHEST_POISON),
	(CHEST_LOSE_STR),
	(CHEST_LOSE_CON),
	(CHEST_POISON),
	(CHEST_LOSE_STR | CHEST_LOSE_CON),
	(CHEST_LOSE_STR | CHEST_LOSE_CON),
	(CHEST_LOSE_STR | CHEST_LOSE_CON),
	(CHEST_SUMMON),                 /* 15 == best large wooden */
	0,
	(CHEST_LOSE_STR),
	(CHEST_LOSE_CON),
	(CHEST_PARALYZE),
	(CHEST_LOSE_STR | CHEST_LOSE_CON),
	(CHEST_SUMMON),
	(CHEST_PARALYZE),
	(CHEST_LOSE_STR),
	(CHEST_LOSE_CON),
	(CHEST_EXPLODE),                        /* 25 == best small iron */
	0,
	(CHEST_POISON | CHEST_LOSE_STR),
	(CHEST_POISON | CHEST_LOSE_CON),
	(CHEST_LOSE_STR | CHEST_LOSE_CON),
	(CHEST_EXPLODE | CHEST_SUMMON),
	(CHEST_PARALYZE),
	(CHEST_POISON | CHEST_SUMMON),
	(CHEST_SUMMON),
	(CHEST_EXPLODE),
	(CHEST_EXPLODE | CHEST_SUMMON), /* 35 == best large iron */
	0,
	(CHEST_SUMMON),
	(CHEST_EXPLODE),
	(CHEST_EXPLODE | CHEST_SUMMON),
	(CHEST_EXPLODE | CHEST_SUMMON),
	(CHEST_POISON | CHEST_PARALYZE),
	(CHEST_EXPLODE),
	(CHEST_EXPLODE | CHEST_SUMMON),
	(CHEST_EXPLODE | CHEST_SUMMON),
	(CHEST_POISON | CHEST_PARALYZE),        /* 45 == best small steel */
	0,
	(CHEST_LOSE_STR | CHEST_LOSE_CON),
	(CHEST_LOSE_STR | CHEST_LOSE_CON),
	(CHEST_POISON | CHEST_PARALYZE | CHEST_LOSE_STR),
	(CHEST_POISON | CHEST_PARALYZE | CHEST_LOSE_CON),
	(CHEST_POISON | CHEST_LOSE_STR | CHEST_LOSE_CON),
	(CHEST_POISON | CHEST_LOSE_STR | CHEST_LOSE_CON),
	(CHEST_POISON | CHEST_PARALYZE | CHEST_LOSE_STR | CHEST_LOSE_CON),
	(CHEST_POISON | CHEST_PARALYZE),
	(CHEST_POISON | CHEST_PARALYZE),        /* 55 == best large steel */
	(CHEST_EXPLODE | CHEST_SUMMON),
	(CHEST_EXPLODE | CHEST_SUMMON),
	(CHEST_EXPLODE | CHEST_SUMMON),
	(CHEST_EXPLODE | CHEST_SUMMON),
	(CHEST_EXPLODE | CHEST_SUMMON),
	(CHEST_EXPLODE | CHEST_SUMMON),
	(CHEST_EXPLODE | CHEST_SUMMON),
	(CHEST_EXPLODE | CHEST_SUMMON),
};


/*
 * Class titles for the player.
 *
 * The player gets a new title every five levels, so each class
 * needs only ten titles total.
 */
cptr player_title[MAX_CLASS][PY_MAX_LEVEL / 5] =
{
	/* Warrior */
	{
#ifdef JP
		"ʼ",
		"ʼ",
		"ʼ",
		"Żʼ",
		"",
		"Ʈ",
		"ͺ",
		"˼",
		"",
		"",
#else
		"Rookie",
		"Soldier",
		"Mercenary",
		"Veteran",
		"Swordsman",
		"Champion",
		"Hero",
		"Baron",
		"Duke",
		"Lord",
#endif
	},

	/* Mage */
	{
#ifdef JP
		"",
		"",                 /*ա*/
		"ѻ",               /*աڥƥ*/
		"ѻ",
		"ѻ",
		"",
		"",
		"ѻ",
		"ץޥ",
		"Ƴ",
#else
		"Apprentice",
		"Trickster",
		"Illusionist",
		"Spellbinder",
		"Evoker",
		"Conjurer",
		"Warlock",
		"Sorcerer",
		"Ipsissimus",
		"Archimage",
#endif
	},

	/* Priest */
	{
#ifdef JP
		"",                 /**/
		"",             /*żԡΡȼΡ*/
		"",
		"",                 /**/
		"һ",               /*ʺɾİƻ*/
		"ʶ",               /*޶*/
		"ʶ",               /*ʶ綵ʶ*/
		"",                 /*׻ʡʺ*/
		"綵",               /*׻ʡ׻Ĺ*/
		"綵",
#else
		"Believer",
		"Acolyte",
		"Adept",
		"Curate",
		"Canon",
		"Priest",
		"High Priest",
		"Cardinal",
		"Inquisitor",
		"Pope",
#endif
	},

	/* Archer */
	{
#ifdef JP
		"ʼ",
		"ʼ",
		"ʼ",
		"Żʼ",
		"",
		"Ʈ",
		"ͺ",
		"˼",
		"",
		"",
#else
		"Rookie",
		"Soldier",
		"Mercenary",
		"Veteran",
		"Swordsman",
		"Champion",
		"Hero",
		"Baron",
		"Duke",
		"Lord",
#endif
	},

	/* Paladins */
	{
#ifdef JP
		"ͦ",                 /*ˡ͡ԡͦʿ*/
		"һ",
		"ݸ",
		"ɱҼ",
		"Ҽ",
		"",
		"ŵ",
		"",
		"",
		"Ĺ",
#else
		"Gallant",
		"Keeper",
		"Protector",
		"Defender",
		"Warder",
		"Knight",
		"Guardian",
		"Low Paladin",
		"High Paladin",
		"Paladin Lord",
#endif
	},

	/* Warrior-Mage */
	{
#ifdef JP
		"",
		"",			/*ա*/
		"",
		"Żʼ",
		"ʼ",
		"Ʈ",
		"˼",
		"Ѹ",
		"Ʈѻ",
		"ѷ",
#else
		"Novice",
		"Apprentice",
		"Journeyman",
		"Veteran",
		"Enchanter",
		"Champion",
		"Mage-Hero",
		"Baron Mage",
		"Battlemage",
		"Wizard Lord",
#endif
	},
};


/*
 * Hack -- the "basic" color names (see "TERM_xxx")
 */
cptr color_names[16] =
{
#ifdef JP
	"",
	"",
	"ĳ",
	"",
	"",
	"",
	"",
	"ῧ",
	"",
	"ĳ",
	"",
	"",
	"뤤",
	"뤤",
	"뤤",
	"ῧ",
#else
	"Dark",
	"White",
	"Slate",
	"Orange",
	"Red",
	"Green",
	"Blue",
	"Umber",
	"Light Dark",
	"Light Slate",
	"Violet",
	"Yellow",
	"Light Red",
	"Light Green",
	"Light Blue",
	"Light Umber",
#endif
};


/*
 * Abbreviations of healthy stats
 */
cptr stat_names[6] =
{
#ifdef JP
	" :", "ǽ :", " :", " :", "ѵ :", "̥ :"
#else
	"STR: ", "INT: ", "WIS: ", "DEX: ", "CON: ", "CHR: "
#endif
};

/*
 * Abbreviations of damaged stats
 */
cptr stat_names_reduced[6] =
{
#ifdef JP
	"x:", "ǽx:", "x:", "x:", "ѵx:", "̥x:"
#else
	"Str: ", "Int: ", "Wis: ", "Dex: ", "Con: ", "Chr: "
#endif
};


/*
 * Certain "screens" always use the main screen, including News, Birth,
 * Dungeon, Tomb-stone, High-scores, Macros, Colors, Visuals, Options.
 *
 * Later, special flags may allow sub-windows to "steal" stuff from the
 * main window, including File dump (help), File dump (artifacts, uniques),
 * Character screen, Small scale map, Previous Messages, Store screen, etc.
 *
 * The "ctrl-i" (tab) command flips the "Display inven/equip" and "Display
 * equip/inven" flags for all windows.
 *
 * The "ctrl-g" command (or pseudo-command) should perhaps grab a snapshot
 * of the main screen into any interested windows.
 */
cptr window_flag_desc[32] =
{
#ifdef JP
	"ʪ/",
	"/ʪ",
	"ʸ",
	"饯",
	"ǽ/",
#else
	"Display inven/equip",
	"Display equip/inven",
	"Display spell list",
	"Display character",
	"Display stats/res",
#endif
	NULL,
#ifdef JP
	"å",
	"󥸥ο",
	"󥹥λפ",
	"ƥξܺ",
	"ʬμϤɽ", 
	"ǰ",
	"Υƥ",
#else
	"Display messages",
	"Display overhead view",
	"Display monster recall",
	"Display object recall",
	"Display dungeon view",
	"Display snap-shot",
	"Display objs on floor",
#endif
	NULL,
#ifdef JP
	"ܡå",
	"ܡơ",
#else
	"Display borg messages",
	"Display borg status",
#endif
	NULL,
	NULL,
	NULL,
	NULL,
	NULL,
	NULL,
	NULL,
	NULL,
	NULL,
	NULL,
	NULL,
	NULL,
	NULL,
	NULL,
	NULL,
	NULL
};


/*
 * Available Options
 *
 * Option Screen Sets:
 *
 *      Set 1: User Interface
 *      Set 2: Disturbance
 *      Set 3: Inventory
 *      Set 4: Game Play
 *
 * Note that bits 28-31 of set 0 are currently unused.
 */
option_type option_info[] =
{
	/*** User-Interface ***/
	
#ifdef JP
	{ &rogue_like_commands,         TRUE, 1, 0, 0,
	"rogue_like_commands",          "֤Ѥ" },
#else
	{ &rogue_like_commands,         FALSE, 1, 0, 0,
	"rogue_like_commands",          "Rogue-like commands" },
#endif

#ifdef JP
	{ &quick_messages,              TRUE, 1, 0, 1,
	"quick_messages",               "ååѤ" },
#else
	{ &quick_messages,              TRUE, 1, 0, 1,
	"quick_messages",               "Activate quick messages" },
#endif

#ifdef JP
	{ &auto_more,                   FALSE, 1, 2, 4,
	"auto_more",                    "ԤʤϢ³ǥåɽ" },
#else
	{ &auto_more,                   FALSE, 1, 2, 4,
	"auto_more",                    "Automatically clear '-more-' prompts" },
#endif

#ifdef JP
	{ &confirm_store,               TRUE,  1, 1, 0,
	"confirm_store",                "ŹǤ˳ǧ򤹤" },
#else
	{ &confirm_store,               TRUE,  1, 1, 0,
	"confirm_store",                "Confirm buying or selling in stores" },
#endif

#ifdef JP
	{ &command_menu,                TRUE, 1, 2, 5,
	"command_menu",                 "˥塼ˤ륳ޥͭˤ" },
#else
	{ &command_menu,                TRUE, 1, 2, 5,
	"command_menu",                 "Enable command selection menu" },
#endif

#ifdef JP
	{ &always_pickup,               FALSE, 1, 0, 5,
	"always_pickup",                "˥ƥ򽦤" },
#else
	{ &always_pickup,               FALSE, 1, 0, 5,
	"always_pickup",                "Pick things up by default" },
#endif

#ifdef JP
	{ &carry_query_flag,            FALSE, 1, 0, 3,
	"carry_query_flag",             "ƥ򽦤˳ǧ" },
#else
	{ &carry_query_flag,            FALSE, 1, 0, 3,
	"carry_query_flag",             "Prompt before picking things up" },
#endif

#ifdef JP
	{ &use_old_target,              FALSE, 1, 0, 4,
	"use_old_target",               "˰ΥåȤꤹ" },
#else
	{ &use_old_target,              FALSE, 1, 0, 4,
	"use_old_target",               "Use old target by default" },
#endif

#ifdef JP
	{ &auto_destroy,                TRUE, 1, 5, 3,
	"auto_destroy",                 "̵͡פʥƥ˲ǧʤ" },
#else
	{ &auto_destroy,                TRUE, 1, 5, 3,
	"auto_destroy",                 "No query to destroy known worthless items" },
#endif

#ifdef JP
	{ &confirm_stairs,              TRUE, 1, 5, 5,
	"confirm_stairs",               "̤γ˹Ԥǧ" },
#else
	{ &confirm_stairs,              TRUE, 1, 5, 5,
	"confirm_stairs",               "Prompt before exiting a dungeon level" },
#endif

#ifdef ALLOW_EASY_OPEN
#ifdef JP
	{ &easy_open,                   TRUE, 1, 5, 7,
	"easy_open",                    "ưŪ˥ɥ򳫤" },
#else
	{ &easy_open,                   TRUE, 1, 5, 7,
	"easy_open",                    "Automatically open doors" },
#endif
#endif /* ALLOW_EASY_OPEN */

#ifdef ALLOW_EASY_FLOOR /* TNB */
#ifdef JP
	{ &easy_floor,                  TRUE, 1, 5, 9,
	"easy_floor",                   "ʣƥˤ" },
#else
	{ &easy_floor,                  TRUE, 1, 5, 9,
	"easy_floor",                   "Display floor stacks in a list" },
#endif
#endif /* ALLOW_EASY_FLOOR -- TNB */

#ifdef JP
	{ &use_command,                 FALSE, 1, 5, 10,
	"use_command",                  "ֻȤ(a)ץޥɤͭˤ" },
#else
	{ &use_command,                 FALSE, 1, 5, 10,
	"use_command",                  "Allow unified use command" },
#endif

#ifdef JP
	{ &allow_debug_opts,            FALSE, 1, 2, 13,
	"allow_debug_opts",             "ǥХå/ץĤ" },
#else
	{ &allow_debug_opts,            FALSE, 1, 2, 13,
	"allow_debug_opts",             "Allow use of debug/cheat options" },
#endif

#ifdef JP
	{ &over_exert,                  FALSE, 1, 2, 6,
	"over_exert",                   "MP­ʤƤˡĩ魯" },
#else
	{ &over_exert,                  FALSE, 1, 2, 6,
	"over_exert",                   "Allow casting spells when short of mana" },
#endif

#ifdef JP
	{ &numpad_as_cursorkey,         TRUE, 1, 2, 31,
	"numpad_as_cursorkey",          "ǥǥƥ󥭡򥫡륭ȤƻȤ" },
#else
	{ &numpad_as_cursorkey,         TRUE, 1, 2, 31,
	"numpad_as_cursorkey",          "Use numpad keys as cursor keys in editor mode" },
#endif

	/*** Display ***/
	
#ifdef JP
	{ &depth_in_feet,               FALSE, 2, 0, 7,
	"depth_in_feet",                "󥸥οեȤɽ" },
#else
	{ &depth_in_feet,               FALSE, 2, 0, 7,
	"depth_in_feet",                "Show dungeon level in feet" },
#endif

#ifdef JP
	{ &show_choices,                TRUE, 2, 0, 12,
	"show_choices",                 "ʪ/ɥ򥢥ƥɽ" },
#else
	{ &show_choices,                TRUE, 2, 0, 12,
	"show_choices",                 "Show choices in certain sub-windows" },
#endif

#ifdef JP
	{ &player_symbols,              FALSE, 2, 1, 13,
	"player_symbols",               "ץ쥤䡼̤ʵɽ"},
#else
	{ &player_symbols,              FALSE, 2, 1, 13,
	"player_symbols",               "Use special symbols for the player char"},
#endif

#ifdef JP
	{ &skip_mutations,              FALSE, 2, 5, 0,
	"skip_mutations",               "'C'ޥɤѰۤɽʤ" },
#else
	{ &skip_mutations,              FALSE, 2, 5, 0,
	"skip_mutations",               "Skip mutations in 'C'haracter Display" },
#endif

#ifdef JP
	{ &plain_descriptions,          TRUE, 2, 5, 1,  /*ܸѹ*/
	"plain_descriptions",           "ƥεҤάˤ" },
#else
	{ &plain_descriptions,          TRUE, 2, 5, 1,
	"plain_descriptions",           "Plain object descriptions" },
#endif

#ifdef JP
	{ &center_player,               FALSE, 2, 5, 11,
	"center_player",                "˥ץ쥤䡼濴֤(*٤*)" },
#else
	{ &center_player,               FALSE, 2, 5, 11,
	"center_player",                "Always center on the player (*slow*)" },
#endif

#ifdef JP
	{ &view_yellow_lite,            TRUE, 2, 1, 28,
	"view_yellow_lite",             "ϰϤ̤ʿɽ" },
#else
	{ &view_yellow_lite,            TRUE, 2, 1, 28,
	"view_yellow_lite",             "Use special colors for torch-lit grids" },
#endif

#ifdef JP
	{ &view_bright_lite,            TRUE, 2, 1, 29,
	"view_bright_lite",             "볦ϰϤ̤ʿɽ" },
#else
	{ &view_bright_lite,            TRUE, 2, 1, 29,
	"view_bright_lite",             "Use special colors for 'viewable' grids" },
#endif

#ifdef JP
	{ &view_granite_lite,           TRUE, 2, 1, 30,
	"view_granite_lite",            "ɤ̤ʿɽ(Ť)" },
#else
	{ &view_granite_lite,           TRUE, 2, 1, 30,
	"view_granite_lite",            "Use special colors for wall grids (slow)" },
#endif

#ifdef JP
	{ &view_special_lite,           TRUE, 2, 1, 31,
	"view_special_lite",            "̤ʿɽ(Ť)" },
#else
	{ &view_special_lite,           TRUE, 2, 1, 31,
	"view_special_lite",            "Use special colors for floor grids (slow)" },
#endif

#ifdef JP
	{ &new_ascii_graphics,          TRUE, 2, 2, 8,
	"new_ascii_graphics",           "ϷŤϤäɽ" },
#else
	{ &new_ascii_graphics,          TRUE, 2, 2, 8,
	"new_ascii_graphics",           "Show a clear contrast between light and dark" },
#endif

#ifdef JP
	{ &display_path,                TRUE, 2, 2, 7,
	"display_path",                 "ˡεƻɽ" },
#else
	{ &display_path,                TRUE, 2, 2, 7,
	"display_path",                 "Display actual path before shooting" },
#endif

#ifdef JP
	{ &always_show_list,            TRUE, 2, 2, 9,
	"always_show_list",             "ˤϾ˰ɽ" },
#else
	{ &always_show_list,            TRUE, 2, 2, 9,
	"always_show_list",             "Always show list" },
#endif

#ifdef JP
	{ &abbrev_extra,                TRUE, 2, 5, 14,
	"abbrev_extra",                 "ƥɲ/ǽϤάΤ" },
#else
	{ &abbrev_extra,                TRUE, 2, 5, 14,
	"abbrev_extra",                 "Describe obj's extra resistances by abbreviation" },
#endif

#ifdef JP
	{ &abbrev_all,                  FALSE, 2, 5, 15,
	"abbrev_all",                   "ƥƤ/ǽϤάΤ" },
#else
	{ &abbrev_all,                  FALSE, 2, 5, 15,
	"abbrev_all",                   "Describe obj's all resistances by abbreviation" },
#endif

#ifdef JP
	{ &exp_need,                    FALSE, 2, 5, 13,
	"exp_need",                     "Υ٥ɬפʷиͤɽ" },
#else
	{ &exp_need,                    FALSE, 2, 5, 13,
	"exp_need",                     "Show the experience needed for next level" },
#endif

	/*** Game-Play ***/
#ifdef JP
	{ &auto_scum,                   FALSE, 3, 1, 1,
	"auto_scum",                    "ʷϵư깥" },
#else
	{ &auto_scum,                   FALSE, 3, 1, 1,
	"auto_scum",                    "Auto-scum for good levels" },
#endif

#ifdef JP
	{ &stack_force_notes,           TRUE, 3, 0, 8,
	"stack_force_notes",            "ۤʤäΥƥޤȤ" },
#else
	{ &stack_force_notes,           TRUE, 3, 0, 8,
	"stack_force_notes",            "Merge inscriptions when stacking" },
#endif

#ifdef JP
	{ &stack_force_costs,           TRUE, 3, 0, 9,
	"stack_force_costs",            "ۤʤɽΥƥޤȤ" },
#else
	{ &stack_force_costs,           TRUE, 3, 0, 9,
	"stack_force_costs",            "Merge discounts when stacking" },
#endif

#ifdef JP
	{ &expand_look,                 TRUE, 3, 1, 4,
	"expand_look",                  "ֲĴ٤ץޥɤĥ" },
#else
	{ &expand_look,                 TRUE, 3, 1, 4,
	"expand_look",                  "Expand the power of the look command" },
#endif

#ifdef JP
	{ &expand_list,                 TRUE, 3, 1, 5,
	"expand_list",                  "ְץޥɤĥ" },
#else
	{ &expand_list,                 TRUE, 3, 1, 5,
	"expand_list",                  "Expand the power of the list commands" },
#endif

#ifdef JP
	{ &view_perma_grids,            TRUE, 3, 1, 6,
	"view_perma_grids",             "뤤ϤΤޤޤˤ" },
#else
	{ &view_perma_grids,            TRUE, 3, 1, 6,
	"view_perma_grids",             "Map remembers all perma-lit grids" },
#endif

#ifdef JP
	{ &view_torch_grids,            FALSE, 3, 1, 7,
	"view_torch_grids",             "ǾȤ餷ϤΤޤޤˤ" },
#else
	{ &view_torch_grids,            FALSE, 3, 1, 7,
	"view_torch_grids",             "Map remembers all torch-lit grids" },
#endif

#ifdef JP
	{ &view_unsafe_grids,            TRUE, 3, 2, 10,
	"view_unsafe_grids",             "ȥå״κѤߤǤʤɽ" },
#else
	{ &view_unsafe_grids,            TRUE, 3, 2, 10,
	"view_unsafe_grids",             "Map marked by detect traps" },
#endif

#ifdef JP
	{ &dungeon_align,               TRUE, 3, 1, 8,
	"dungeon_align",                "󥸥򤽤" },
#else
	{ &dungeon_align,               TRUE, 3, 1, 8,
	"dungeon_align",                "Generate dungeons with aligned rooms" },
#endif

#ifdef JP
	{ &dungeon_stair,               TRUE, 3, 1, 9,
	"dungeon_stair",                "ʤĤʤƥ󥸥" },
#else
	{ &dungeon_stair,               TRUE, 3, 1, 9,
	"dungeon_stair",                "Generate dungeons with connected stairs" },
#endif

#ifdef JP
	{ &last_words,                  TRUE, 3, 0, 28,
	"last_words",                   "饯Τ" },
#else
	{ &last_words,                  TRUE, 3, 0, 28,
	"last_words",                   "Get last words when the character dies" },
#endif

#ifdef JP
	{ &speak_unique,                TRUE, 3, 0, 29,
	"speak_unique",                 "Źˡ󥹥٤" },
#else
	{ &speak_unique,                TRUE, 3, 0, 29,
	"speak_unique",                 "Allow shopkeepers and uniques to speak" },
#endif

#ifdef JP
	{ &ignore_unview,               FALSE, 3, 2, 16,
	"ignore_unview",                "볦Υ󥹥ιưɽʤ" },
#else
	{ &ignore_unview,               FALSE, 3, 2, 16,
	"ignore_unview",                "Ignore whatever monsters do when out of sight" },
#endif

	/*** Disturbance ***/
	
#ifdef JP
	{ &find_ignore_stairs,          FALSE, 4, 0, 16,
	"find_ignore_stairs",           "ʤ̲᤹" },
#else
	{ &find_ignore_stairs,          FALSE, 4, 0, 16,
	"find_ignore_stairs",           "Run past stairs" },
#endif

#ifdef JP
	{ &find_ignore_doors,           TRUE, 4, 0, 17,
	"find_ignore_doors",            "ɥ̲᤹" },
#else
	{ &find_ignore_doors,           TRUE, 4, 0, 17,
	"find_ignore_doors",            "Run through open doors" },
#endif

#ifdef JP
	{ &find_ignore_trees,           TRUE, 4, 2, 15,
	"find_ignore_trees",            "ڤ̲᤹" },
#else
	{ &find_ignore_trees,           TRUE, 4, 2, 15,
	"find_ignore_trees",            "Run through trees" },
#endif

#ifdef JP
	{ &find_cut,                    FALSE, 4, 0, 18,
	"find_cut",                     "ΤζʤѤ̲᤹" },
#else
	{ &find_cut,                    FALSE, 4, 0, 18,
	"find_cut",                     "Run past known corners" },
#endif

#ifdef JP
	{ &find_examine,                TRUE, 4, 0, 19,
	"find_examine",                 "ʤѤ⤷ʤ̲᤹" },
#else
	{ &find_examine,                TRUE, 4, 0, 19,
	"find_examine",                 "Run into potential corners" },
#endif

#ifdef JP
	{ &disturb_move,                FALSE, 4, 0, 20,
	"disturb_move",                 "ɤΥ󥹥ưƤưߤ" },
#else
	{ &disturb_move,                FALSE, 4, 0, 20,
	"disturb_move",                 "Disturb whenever any monster moves" },
#endif

#ifdef JP
	{ &disturb_near,                TRUE, 4, 0, 21,
	"disturb_near",                 "볦󥹥ưưߤ" },
#else
	{ &disturb_near,                TRUE, 4, 0, 21,
	"disturb_near",                 "Disturb whenever viewable monster moves" },
#endif

#ifdef JP
	{ &disturb_pets,                FALSE, 4, 5, 6,
	"disturb_pets",                 "볦ˤڥåȤưưߤ" },
#else
	{ &disturb_pets,                FALSE, 4, 5, 6,
	"disturb_pets",                 "Disturb when visible pets move" },
#endif

#ifdef JP
	{ &disturb_panel,               TRUE, 4, 0, 22,
	"disturb_panel",                "̥˹ưߤ" },
#else
	{ &disturb_panel,               TRUE, 4, 0, 22,
	"disturb_panel",                "Disturb whenever map panel changes" },
#endif

#ifdef JP
	{ &disturb_state,               TRUE, 4, 0, 23,
	"disturb_state",                "ʬΥơѲ˹ưߤ" },
#else
	{ &disturb_state,               TRUE, 4, 0, 23,
	"disturb_state",                "Disturb whenever player state changes" },
#endif

#ifdef JP
	{ &disturb_minor,               TRUE, 4, 0, 24,
	"disturb_minor",                "٤ʤȤƤưߤ" },
#else
	{ &disturb_minor,               TRUE, 4, 0, 24,
	"disturb_minor",                "Disturb whenever boring things happen" },
#endif

#ifdef JP
	{ &disturb_other,               TRUE, 4, 0, 25,
	"disturb_other",                "͡ʤȤưߤ" },
#else
	{ &disturb_other,               TRUE, 4, 0, 25,
	"disturb_other",                "Disturb whenever random things happen" },
#endif

#ifdef JP
	{ &ring_bell,                   FALSE, 4, 0, 14,
	"ring_bell",                    "ӡײĤ餹(顼ʤ)" },
#else
	{ &ring_bell,                   FALSE, 4, 0, 14,
	"ring_bell",                    "Audible bell (on errors, etc)" },
#endif

#ifdef JP
	{ &alert_hitpoint,              FALSE, 4, 0, 26,
	"alert_hitpoint",               "ҥåȥݥȤηٹ˥ӡפĤ餹" },
#else
	{ &alert_hitpoint,              FALSE, 4, 0, 26,
	"alert_hitpoint",               "Alert user to critical hitpoints" },
#endif

#ifdef JP
	{ &disturb_trap_detect,         TRUE, 4, 2, 11,
	"disturb_trap_detect",          "ȥå״ϰϳ˽Фľ˹ưߤ" },
#else
	{ &disturb_trap_detect,         TRUE, 4, 2, 11,
	"disturb_trap_detect",          "Disturb when leaving trap detected area"},
#endif

#ifdef JP
	{ &alert_trap_detect,           TRUE, 4, 2, 12,
	"alert_trap_detect",            "ȥå״ϰϳ˽Фľ˷ٹ𤹤" },
#else
	{ &alert_trap_detect,           TRUE, 4, 2, 12,
	"alert_trap_detect",            "Alert when leaving trap detected area"},
#endif

	/*** Efficiency ***/

#ifdef JP
	{ &use_color,                   TRUE, 5, 0, 15,
	"use_color",                    "ǽʤ饫顼ɽ٤" },
#else
	{ &use_color,                   TRUE, 5, 0, 15,
	"use_color",                    "Use color if possible (slow)" },
#endif

#ifdef JP
	{ &view_reduce_lite,            FALSE, 5, 1, 16,
	"view_reduce_lite",             "äƤȤȾ¤򸺾" },
#else
	{ &view_reduce_lite,            FALSE, 5, 1, 16,
	"view_reduce_lite",             "Reduce lite-radius when running" },
#endif

#ifdef JP
	{ &view_reduce_view,            FALSE, 5, 1, 17,
	"view_reduce_view",             "Ǥϻ򶹤" },
#else
	{ &view_reduce_view,            FALSE, 5, 1, 17,
	"view_reduce_view",             "Reduce view-radius in town" },
#endif

#ifdef JP
	{ &avoid_abort,                 FALSE, 5, 1, 18,
	"avoid_abort",                  "Ϣ³ޥɤϥϤǤʤ" },
#else
	{ &avoid_abort,                 FALSE, 5, 1, 18,
	"avoid_abort",                  "Avoid checking for user abort" },
#endif

#ifdef JP
	{ &flush_failure,               TRUE, 5, 1, 20,
	"flush_failure",                "͡ʥߥȯϤ򥯥ꥢ" },
#else
	{ &flush_failure,               TRUE, 5, 1, 20,
	"flush_failure",                "Flush input on various failures" },
#endif

#ifdef JP
	{ &flush_disturb,               FALSE, 5, 1, 21,
	"flush_disturb",               "㳲ȯϤ򥯥ꥢ" },
#else
	{ &flush_disturb,               FALSE, 5, 1, 21,
	"flush_disturb",                "Flush input whenever disturbed" },
#endif

#ifdef JP
	{ &fresh_before,                TRUE, 5, 1, 23,
	"fresh_before",                 "ޥ˲̤褹" },
#else
	{ &fresh_before,                TRUE, 5, 1, 23,
	"fresh_before",                 "Flush output before every command" },
#endif

#ifdef JP
	{ &fresh_after,                 FALSE, 5, 1, 24,
	"fresh_after",                  "ޥɸ˲̤褹" },
#else
	{ &fresh_after,                 FALSE, 5, 1, 24,
	"fresh_after",                  "Flush output after every command" },
#endif

#ifdef JP
	{ &fresh_message,               FALSE, 5, 1, 25,
	"fresh_message",                "åθ˲̤褹" },
#else
	{ &fresh_message,               FALSE, 5, 1, 25,
	"fresh_message",                "Flush output after every message" },
#endif

#ifdef JP
	{ &compress_savefile,           TRUE, 5, 1, 26,
	"compress_savefile",            "֡եΥå򰵽̤" },
#else
	{ &compress_savefile,           TRUE, 5, 1, 26,
	"compress_savefile",            "Compress messages in savefiles" },
#endif

#ifdef JP
	{ &hilite_player,               TRUE, 5, 1, 27,
	"hilite_player",                "ץ쥤䡼˥碌" },
#else
	{ &hilite_player,               TRUE, 5, 1, 27,
	"hilite_player",                "Hilite the player with the cursor" },
#endif

	/*** Initialize ***/

#ifdef JP
	{ &ironman_shops,               FALSE, 6, 6, 2,
	"ironman_shops",                "ŴѡŹѤʤ" },
#else
	{ &ironman_shops,               FALSE, 6, 6, 2,
	"ironman_shops",                "Stores are permanently closed" },
#endif

#ifdef JP
	{ &ironman_downward,            FALSE, 6, 6, 4,
	"ironman_downward",             "Ŵѡ˵ԤȾ곬ʤʤ" },
#else
	{ &ironman_downward,            FALSE, 6, 6, 4,
	"ironman_downward",             "Don't allow climbing upwards/recalling" },
#endif

#ifdef JP
	{ &ironman_autoscum,            FALSE, 6, 6, 5,
	"ironman_autoscum",             "Ŵѡ˾˳ʷϵư깥ߤ" },
#else
	{ &ironman_autoscum,            FALSE, 6, 6, 5,
	"ironman_autoscum",             "Permanently enable the autoscummer" },
#endif

#if 0
#ifdef JP
	{ &munchkin_rings,              FALSE, 6, 6, 17,
	"munchkin_rings",               "ʤ˻ؤ" },
#else
	{ &munchkin_rings,              FALSE, 6, 6, 17,
	"munchkin_rings",               "Allow multiple rings" },
#endif
#endif

#ifdef JP
	{ &ironman_nightmare,           FALSE, 6, 6, 18,
	"ironman_nightmare",            "Ŵѡ˰̴⡼(ԾǤ)" },
#else
	{ &ironman_nightmare,           FALSE, 6, 6, 18,
	"ironman_nightmare",            "Nightmare mode (this isn't even remotely fair!)" },
#endif

#ifdef JP
	{ &terrain_streams,             TRUE, 6, 6, 9,
	"terrain_streams",              "俹ʤɤ󥸥" },
#else
	{ &terrain_streams,             TRUE, 6, 6, 9,
	"terrain_streams",              "Create terrain 'streamers' in the dungeon" },
#endif

#ifdef JP
	{ &preserve_mode,               TRUE, 6, 6, 14,
	"preserve_mode",                "¸⡼ɻ" },
#else
	{ &preserve_mode,               TRUE, 6, 6, 14,
	"preserve_mode",                "Preserve artifacts" },
#endif

#ifdef JP
	{ &autoroller,                  TRUE, 6, 6, 15,
	"autoroller",                   "ȥ顼" },
#else
	{ &autoroller,                  TRUE, 6, 6, 15,
	"autoroller",                   "Specify 'minimal' stats (use auto-roller)" },
#endif

#ifdef JP
	{ &delay_autoroll,              FALSE, 6, 6, 17,
	"delay_autoroll",               "ȥ顼˥Ȥ" },
#else
	{ &delay_autoroll,              FALSE, 6, 6, 17,
	"delay_autoroll",               "Run auto-roller slowly" },
#endif

	/*** Object auto-destruction ***/

#ifdef JP
	{ &destroy_items,               TRUE, 7, 7, 0,
	"destroy_items",                "ʰ׼ư˲Ѥ" },
#else
	{ &destroy_items,               TRUE, 7, 7, 0,
	"destroy_items",                "Auto-destroy known worthless items" },
#endif

#ifdef JP
	{ &destroy_feeling,             FALSE, 7, 7, 4,
	"destroy_feeling",              "ʰ״ꤷȤʰ׼ư˲ŬѤ" },
#else
	{ &destroy_feeling,             FALSE, 7, 7, 4,
	"destroy_feeling",              "Apply auto-destroy as sense feeling" },
#endif

#ifdef JP
	{ &destroy_identify,            FALSE, 7, 7, 5,
	"destroy_identify",             "ꤷȤʰ׼ư˲ŬѤ" },
#else
	{ &destroy_identify,            FALSE, 7, 7, 5,
	"destroy_identify",             "Apply auto-destroy as identify an item" },
#endif

#ifdef JP
	{ &leave_worth,                 TRUE, 7, 7, 1,
	"leave_worth",                  "ͤΤ륢ƥϲʤ" },
#else
	{ &leave_worth,                 TRUE, 7, 7, 1,
	"leave_worth",                  "Auto-destroyer leaves known worthy items" },
#endif

#ifdef JP
	{ &leave_equip,                 FALSE, 7, 7, 2,
	"leave_equip",                  "/ɶϲʤ" },
#else
	{ &leave_equip,                 FALSE, 7, 7, 2,
	"leave_equip",                  "Auto-destroyer leaves weapons and armour" },
#endif

#ifdef JP
	{ &leave_chest,                 TRUE, 7, 7, 3,
	"leave_chest",                  "ƤʤȢϲʤ" },
#else
	{ &leave_chest,                 TRUE, 7, 7, 3,
	"leave_chest",                  "Auto-destroyer leaves closed chests" },
#endif

	/*** Difficulty ***/

#ifdef JP
	{ &flow_by_sound,               TRUE, 8, 1, 10,
	"flow_by_sound",                "󥹥ϸߤΰ֤פ(ĶŤ)" },
#else
	{ &flow_by_sound,               TRUE, 8, 1, 10,
	"flow_by_sound",                "Monsters chase current location (v.slow)" },
#endif

#ifdef JP
	{ &flow_by_smell,               TRUE, 8, 1, 11,
	"flow_by_smell",                "󥹥ϺǶΰ֤פ(ĶŤ)" },
#else
	{ &flow_by_smell,               TRUE, 8, 1, 11,
	"flow_by_smell",                "Monsters chase recent locations (v.slow)" },
#endif

#ifdef JP
	{ &smart_learn,                 FALSE, 8, 1, 14,
	"smart_learn",                  "󥹥ϼԤؽ" },
#else
	{ &smart_learn,                 FALSE, 8, 1, 14,
	"smart_learn",                  "Monsters learn from their mistakes" },
#endif

#ifdef JP
	{ &smart_cheat,                 FALSE, 8, 1, 15,
	"smart_cheat",                  "󥹥ϥץ쥤䡼μߤͤ" },
#else
	{ &smart_cheat,                 FALSE, 8, 1, 15,
	"smart_cheat",                  "Monsters exploit players weaknesses" },
#endif

#ifdef JP
	{ &stupid_monsters,             FALSE, 8, 5, 2,
	"stupid_monsters",              "󥹥ȴʹưȤ" },
#else
	{ &stupid_monsters,             FALSE, 8, 5, 2,
	"stupid_monsters",              "Monsters behave stupidly" },
#endif

	/*** Auto-record ***/

#ifdef JP
	{ &dump_abilities,              TRUE, 9, 7, 30,
	"dump_abilities",               "äΤ륢ƥǽϤפ˽Ϥ" },
#else
	{ &dump_abilities,              TRUE, 9, 7, 30,
	"dump_abilities",               "Dump full information for all named items" },
#endif

#ifdef JP
	{ &dump_messages,              FALSE, 9, 7, 31,
	"dump_messages",               "åפ˽Ϥ" },
#else
	{ &dump_messages,              FALSE, 9, 7, 31,
	"dump_messages",               "Record message logs to a character dump" },
#endif

#ifdef JP
	{ &take_notes,                  FALSE, 9, 7, 28,
	"take_notes",                   "ץ쥤ե˵Ͽ" },
#else
	{ &take_notes,                  FALSE, 9, 7, 28,
	"take_notes",                   "Allow notes to be appended to a file" },
#endif

#ifdef JP
	{ &auto_notes,                  TRUE, 9, 7, 27,
	"auto_notes",                   "פʽϿ" },
#else
	{ &auto_notes,                  TRUE, 9, 7, 27,
	"auto_notes",                   "Automatically note important events" },
#endif

#ifdef JP
	{ &record_artifact,             TRUE, 9, 7, 26,
	"record_artifact",              "ƥեȤϿ" },
#else
	{ &record_artifact,             TRUE, 9, 7, 26,
	"record_artifact",              "Record artifacts found" },
#endif

#ifdef JP
	{ &record_randart,              TRUE, 9, 7, 25,
	"record_randart",               "ॢƥեȤϿ" },
#else
	{ &record_randart,              TRUE, 9, 7, 25,
	"record_randart",               "Record random artifacts found" },
#endif

#ifdef JP
	{ &record_unique,               TRUE, 9, 7, 24,
	"record_unique",                "ˡ󥹥ݤȤϿ" },
#else
	{ &record_unique,               TRUE, 9, 7, 24,
	"record_unique",                "Record defeated unique monsters" },
#endif

#ifdef JP
	{ &record_quest,                TRUE, 9, 7, 23,
	"record_quest",                 "ȤãȤϿ" },
#else
	{ &record_quest,                TRUE, 9, 7, 23,
	"record_quest",                 "Record completed quests" },
#endif

	/* Hitpoint waring */

	{ &prompt_hitpoint,             TRUE, 10, 2, 17,
#ifdef JP
	"prompt_hitpoint",               "ҥåȥݥȻ˥åå̵뤹" },
#else
	"prompt_hitpoint",               "Ignore quick message when hitpoint warning" },
#endif

#ifdef JP
	{ &stop_more,                   FALSE, 10, 2, 14,
	"stop_more",                    "᡼˥Ԥ" },
#else
	{ &stop_more,                   FALSE, 10, 2, 14,
	"stop_more",                    "Prompt -more- if you'll be damaged" },
#endif

	/*** Dead options ***/

#ifdef JP
	{ &show_inven_graph,            TRUE, 0, 2, 0,  /*ܸѹ*/
	"show_inven_graph",             "ʪ򥰥եɽ" },
#else
	{ &show_inven_graph,            TRUE, 0, 2, 0,
	"show_inven_graph",             "Show graphics in inventory list" },
#endif

#ifdef JP
	{ &show_equip_graph,            TRUE, 0, 2, 1,  /*ܸѹ*/
	"show_equip_graph",             "򥰥եɽ" },
#else
	{ &show_equip_graph,            TRUE, 0, 2, 1,
	"show_equip_graph",             "Show graphics in equipment list" },
#endif

#ifdef JP
	{ &show_store_graph,            TRUE, 0, 2, 2,  /*ܸѹ*/
	"show_store_graph",             "Źʪ򥰥եɽ" },
#else
	{ &show_store_graph,            TRUE, 0, 2, 2,
	"show_store_graph",             "Show graphics in stores" },
#endif

#ifdef JP
	{ &show_details,                TRUE, 0, 0, 13,
	"show_details",                 "󥹥λפФܤɽ" },
#else
	{ &show_details,                TRUE, 0, 0, 13,
	"show_details",                 "Show details in certain sub-windows" },
#endif

#ifdef JP
	{ &small_levels,                TRUE, 0, 0, 30,
	"small_levels",                 "˾եǽˤ" },
#else
	{ &small_levels,                TRUE, 0, 0, 30,
	"small_levels",                 "Allow unusually small dungeon levels" },
#endif

#ifdef JP
	{ &always_small_levels,         TRUE, 0, 2, 3,
	"always_small_levels",          "˾ե" },
#else
	{ &always_small_levels,         TRUE, 0, 2, 3,
	"always_small_levels",          "Always create unusually small dungeon levels" },
#endif

#ifdef JP
	{ &empty_levels,                FALSE, 0, 0, 31,
	"empty_levels",                 "äݤΡ֥꡼ʡץ٥ǽˤ" },
#else
	{ &empty_levels,                FALSE, 0, 0, 31,
	"empty_levels",                 "Allow empty 'arena' levels" },
#endif

#ifdef JP
	{ &ironman_small_levels,        FALSE, 0, 6, 3,
	"ironman_small_levels",         "Ŵѡ˾˾ե" },
#else
	{ &ironman_small_levels,        FALSE, 0, 6, 3,
	"ironman_small_levels",         "Always create unusually small dungeon levels" },
#endif

#ifdef JP
	{ &ironman_empty_levels,        FALSE, 0, 6, 8,
	"ironman_empty_levels",         "Ŵѡ˾˶äݤΥ꡼ʥ٥" },
#else
	{ &ironman_empty_levels,        FALSE, 0, 6, 8,
	"ironman_empty_levels",         "Always create empty 'arena' levels" },
#endif

#ifdef JP
	{ &munchkin_death,              FALSE, 0, 6, 11,
	"munchkin_death",               "ʤ˻֤뤫ǧ" },
#else
	{ &munchkin_death,              FALSE, 0, 6, 11,
	"munchkin_death",               "Ask for saving death" },
#endif

#ifdef JP
	{ &ironman_rooms,               FALSE, 0, 6, 12,
	"ironman_rooms",                "Ŵѡ˾̤Ǥʤ" },
#else
	{ &ironman_rooms,               FALSE, 0, 6, 12,
	"ironman_rooms",                "Always generate very unusual rooms" },
#endif

#ifdef JP
	{ &ironman_hengband,            TRUE, 0, 6, 19,
	"ironman_hengband",             "Ŵѡ͡ʥӥ塼Ȥʤ(̤)" },
#else
	{ &ironman_hengband,            TRUE, 0, 6, 19,
	"ironman_hengband",               "Set monsters against some abuses." },
#endif


	/*** End of Table ***/

	{ NULL,                         0, 0, 0, 0,
	NULL,                           NULL }
};


/*
 * Table of game-generated inscriptions (indexed by the defines in
 * defines.h). -- RG
 */
cptr game_inscriptions[] =
{
	NULL,            /* FEEL_NONE */
#ifdef JP
	"Ƥ",    /* FEEL_BROKEN */
	"",      /* FEEL_TERRIBLE */
	"̵",        /* FEEL_WORTHLESS */
	"Ƥ",  /* FEEL_CURSED */
	"ʾ",      /* FEEL_UNCURSED */
	"",            /* FEEL_AVERAGE */
	"",          /* FEEL_GOOD */
	"",        /* FEEL_EXCELLENT */
	"",        /* FEEL_SPECIAL */
#else
	"broken",        /* FEEL_BROKEN */
	"terrible",      /* FEEL_TERRIBLE */
	"worthless",     /* FEEL_WORTHLESS */
	"cursed",        /* FEEL_CURSED */
	"uncursed",      /* FEEL_UNCURSED */
	"average",       /* FEEL_AVERAGE */
	"good",          /* FEEL_GOOD */
	"excellent",     /* FEEL_EXCELLENT */
	"special",       /* FEEL_SPECIAL */
#endif
};


#ifndef JP
/* Weird melee attack types when hallucinating */
cptr silly_attacks[MAX_SILLY_ATTACK] =
{
	"smothers",
	"hugs",
	"humiliates",
	"whips",
	"kisses",

	"disgusts",
	"pees all over",
	"passes the gas on",
	"makes obscene gestures at",
	"licks",

	"stomps on",
	"swallows",
	"drools on",
	"misses",
	"shrinks",

	"emasculates",
	"evaporates",
	"solidifies",
	"digitizes",
	"insta-kills",

	"massacres",
	"slaughters",
	"drugs",
	"psychoanalyzes",
	"deconstructs",

	"falsifies",
	"disbelieves",
	"molests"
};
#endif


/*
 * The table of monsters' blow effects
 */
mbe_info_type mbe_info[] =
{
	{  0, 0,             }, /* None      */
	{ 60, GF_MISSILE,    }, /* HURT      */
	{  5, GF_POIS,       }, /* POISON    */
	{ 20, GF_DISENCHANT, }, /* UN_BONUS  */
	{ 15, GF_MISSILE,    }, /* UN_POWER  */ /* ToDo: Apply the correct effects */
	{  5, GF_MISSILE,    }, /* EAT_GOLD  */
	{  5, GF_MISSILE,    }, /* EAT_ITEM  */
	{  5, GF_MISSILE,    }, /* EAT_FOOD  */
	{  5, GF_MISSILE,    }, /* EAT_LITE  */
	{  0, GF_ACID,       }, /* ACID      */
	{ 10, GF_ELEC,       }, /* ELEC      */
	{ 10, GF_FIRE,       }, /* FIRE      */
	{ 10, GF_COLD,       }, /* COLD      */
	{  2, GF_MISSILE,    }, /* BLIND     */
	{ 10, GF_CONFUSION,  }, /* CONFUSE   */
	{ 10, GF_MISSILE,    }, /* TERRIFY   */
	{  2, GF_MISSILE,    }, /* PARALYZE  */
	{  0, GF_MISSILE,    }, /* LOSE_STR  */
	{  0, GF_MISSILE,    }, /* LOSE_INT  */
	{  0, GF_MISSILE,    }, /* LOSE_WIS  */
	{  0, GF_MISSILE,    }, /* LOSE_DEX  */
	{  0, GF_MISSILE,    }, /* LOSE_CON  */
	{  0, GF_MISSILE,    }, /* LOSE_CHR  */
	{  2, GF_MISSILE,    }, /* LOSE_ALL  */
	{ 60, GF_ROCKET,     }, /* SHATTER   */
	{  5, GF_MISSILE,    }, /* EXP_10    */
	{  5, GF_MISSILE,    }, /* EXP_20    */
	{  5, GF_MISSILE,    }, /* EXP_40    */
	{  5, GF_MISSILE,    }, /* EXP_80    */
	{  5, GF_POIS,       }, /* DISEASE   */
	{  5, GF_TIME,       }, /* TIME      */
	{  5, GF_MISSILE,    }, /* EXP_VAMP  */
};


cptr valar_patrons[MAX_PATRON] =
{
#ifdef JP
	"ޥ󥦥",	/*  */
	"",	/*  */
	"",	/*  */
	"",	/*  */
	"ޥɥ",	/* ̿ */
	"",	/* ̴ */
	"ȥ륫",	/*  */
	"",	/* (٥쥹) */
	"",	/*  */
	"˥",	/* ò */
	"",	/*  */
	"",	/* ɱ */
	"",	/*  */
	"ͥ",	/* ٤ */
#else
	"Manwe",
	"Ulmo",
	"Aule",
	"Orome",
	"Mandos",
	"Irmo",
	"Tulkas",
	"Varda",
	"Yavanna",
	"Nienna",
	"Este",
	"Vaire",
	"Vana",
	"Nessa",
#endif
};


int valar_stats[MAX_PATRON] =
{
	A_WIS,  /* Manwe */
	A_STR,	/* Ulmo */
	A_STR,	/* Aure */
	A_DEX,	/* Orome */
	A_CON,	/* Mandos */
	A_INT,	/* Irmo */
	A_STR,	/* Tulkas */
	A_INT,	/* Varda */
	A_WIS,	/* Yavanna */
	A_INT,	/* Nienna */
	A_CON,	/* Este */
	A_CHR,	/* Vaire */
	A_CON,	/* Vana */
	A_DEX,	/* Nessa */
};


int valar_rewards[MAX_PATRON][MAX_REWARDS] =
{
	{ REW_SPEED, REW_GAIN_ABL, REW_GAIN_ABL, REW_GAIN_ABL, REW_AUGM_ABL },	/* Manwe */
	{ REW_HERO, REW_RE_CURSE, REW_GAIN_ABL, REW_GAIN_ABL, REW_GREA_OBS },	/* Ulmo */
	{ REW_HERO, REW_GREA_OBJ, REW_GREA_OBJ, REW_GREA_OBJ, REW_GREA_OBJ },	/* Aule */
	{ REW_SPEED, REW_SPEED, REW_ENLIGHT, REW_GREA_OBS, REW_AUGM_ABL },	/* Orome */
	{ REW_RESTORE, REW_MASS_GEN, REW_GAIN_ABL, REW_AUGM_ABL, REW_GREA_OBJ },	/* Mandos */
	{ REW_BLESS, REW_BLESS, REW_BLESS, REW_BLESS, REW_WISHING },	/* Irmo */
	{ REW_HERO, REW_DISPEL_C, REW_GAIN_ABL, REW_GAIN_ABL, REW_AUGM_ABL },	/* Tulkas */

	{ REW_ENLIGHT, REW_PROTEVIL, REW_PROTEVIL, REW_GREA_OBS, REW_AUGM_ABL },	/* Varda */
	{ REW_RE_CURSE, REW_GAIN_ABL, REW_GAIN_ABL, REW_POTION, REW_GREA_OBJ },	/* Yavanna */
	{ REW_RE_CURSE, REW_RES_POTION, REW_GAIN_ABL, REW_GAIN_ABL, REW_GREA_OBS },	/* Nienna */
	{ REW_RESTORE, REW_POTION, REW_POTION, REW_GAIN_ABL, REW_GREA_OBJ },	/* Este */
	{ REW_BLESS, REW_GAIN_ABL, REW_POTION, REW_CLOTH, REW_AMULET },	/* Vaire */
	{ REW_RESTORE, REW_GAIN_ABL, REW_GAIN_ABL, REW_GAIN_ABL, REW_POTION },	/* Vana */
	{ REW_SPEED, REW_SPEED, REW_POTION, REW_AUGM_ABL, REW_AMULET },	/* Nessa */
};
