/* File: mind.c */

/* Purpose: Mindcrafter code */

/*
 * Copyright (c) 1989 James E. Wilson, Robert A. Koeneke
 *
 * This software may be copied and distributed for educational, research, and
 * not for profit purposes provided that this copyright and statement are
 * included in all such copies.
 */

#include "angband.h"

static const char *mind_tips[MAX_MIND_TYPES][MAX_MIND_POWERS] =
{
	{
#ifdef JP
		"ŷεġ",
		"᤯Ƥθ󥹥Τ롣٥5/⡢15Ʃʥ󥹥30ǺȥƥΤǤ褦ˤʤ롣٥20ǼդϷΤ45ǤγΤʵפ˾Ȥ餷󥸥Τ٤ƤΥƥΤ롣٥25ǰ֥ƥѥ롣",
		"ΥΥƥݡȤ򤹤롣٥40ʾûΥλꤷ˥ƥݡȤ롣",
		"ΥΥƥݡȤ򤹤롣",
		"٥30̤ǡ󥹥ۯ۰𤫶ݤġ٥30ʾǻ볦ƤΥ󥹥̥λ롣񹳤̵",
		"첻εġ",
		"֡AC徺롣٥뤬夬ȡꡢ䵤ŷ⡢Ǥ롣",
		"٥25̤ǡƥʷϵΤ롣٥25ʾǡƥꤹ롣",
		"٥25̤ǡʬ濴Ȥεȯ롣٥25ʾǡ볦ƤΥ󥹥ФԤ",
		"ݤۯ۰ҡʬǤⶸβ֤Ǥ®֤ǤʤHP롣ˡ٥35̤ʤа֥ҡʬˡ٥35ʾǶβ®롣",
		"εġ󥹥̿椹ȡ01.5񤹤롣񹳤ʤСMP롣",
		"̵ڤʥͥ륮Υӡġ",
		"yet.",
		"yet.",
		"yet.",
		"yet.",
		"yet.",
		"yet.",
		"yet.",
		"yet.",
		"yet.",
#else
		"yet.",
		"yet.",
		"yet.",
		"yet.",
		"yet.",
		"yet.",
		"yet.",
		"yet.",
		"yet.",
		"yet.",
		"yet.",
		"yet.",
		"yet.",
		"yet.",
		"yet.",
		"yet.",
		"yet.",
		"yet.",
		"yet.",
		"yet.",
		"yet.",
#endif
	},

	{
		"yet.", "yet.", "yet.", "yet.", "yet.", "yet.", "yet.",  
		"yet.", "yet.", "yet.", "yet.", "yet.", "yet.", "yet.", 
		"yet.", "yet.", "yet.", "yet.", "yet.", "yet.", "yet.", 
	}
};

mindcraft_power mindcraft_powers[MAX_MIND_TYPES][MAX_MIND_POWERS] =
{
	{
		/* Level gained,  cost,  %fail,  name */
#ifdef JP
		{ 1,   1,  15, "å" 	, "Shock"},
		{ 2,   1,  20, "ƥѥ" 	, "Precognition"},
		{ 3,   2,  25, "֥" 	, "Minor Displacement"},
		{ 7,   6,  35, "ƥݡ" 	, "Major Displacement"},
		{ 9,   7,  50, "" 	, "Domination"},
		{ 11,  7,  30, "ͥ륮ܡ" 	, "Pulverise"},
		{ 13, 12,  50, "åХꥢ"	, "Character Armour"},
		{ 15, 12,  60, "ȥ꡼", "Psychometry" },
		{ 18, 10,  45, "ե쥢", "Mind Wave" },
		{ 23, 15,  50, "ɥʥ󡦥ɡԥ" , "Adrenaline Channeling"},
		{ 28, 10,  40, "åɥ쥤" ,"Psychic Drain"},
		{ 35, 35,  75, "η", "Psycho-spear"},
		{ 99, 0, 0, "", ""},
		{ 99, 0, 0, "", ""},
		{ 99, 0, 0, "", ""},
		{ 99, 0, 0, "", ""},
		{ 99, 0, 0, "", ""},
		{ 99, 0, 0, "", ""},
		{ 99, 0, 0, "", ""},
		{ 99, 0, 0, "", ""},
		{ 99, 0, 0, "", ""},
#else
		{ 1,   1,  15, "Precognition" },          /* Det. monsters/traps */
		{ 2,   1,  20, "Neural Blast" },          /* ~MM */
		{ 3,   2,  25, "Minor Displacement" },    /* Phase door */
		{ 7,   6,  35, "Major Displacement" },    /* Tele. Self / All */
		{ 9,   7,  50, "Domination" },
		{ 11,  7,  30, "Pulverise" },             /* Telekinetic "bolt" */
		{ 13, 12,  50, "Character Armour" },      /* Psychic/physical defenses */
		{ 15, 12,  60, "Psychometry" },
		{ 18, 10,  45, "Mind Wave" },             /* Ball -> LOS */
		{ 23, 15,  50, "Adrenaline Channeling" },
		{ 25, 10,  40, "Psychic Drain" },         /* Convert enemy HP to mana */
		{ 28, 20,  45, "Telekinetic Wave" },      /* Ball -> LOS */
		{ 99, 0, 0, "", ""},
		{ 99, 0, 0, "", ""},
		{ 99, 0, 0, "", ""},
		{ 99, 0, 0, "", ""},
		{ 99, 0, 0, "", ""},
		{ 99, 0, 0, "", ""},
		{ 99, 0, 0, "", ""},
		{ 99, 0, 0, "", ""},
		{ 99, 0, 0, "", ""},
#endif
	},

	{
		/* Level gained,  cost,  %fail,  name */
#ifdef JP
		{ 1,   1,  20, "󥹥", "Detect Monster"},
		{ 1,   3,  25, "󥹥", "Capture Monster"},
		{ 1,   3,  25, "󥹥", "Release Monster"},
		{ 3,   3,  25, "⾤", "Summon Spiders"},
		{ 10,  8,  30, "ྤ", "Summon Golem"},
		{ 14, 10,  30, "ƥݡȡ󥹥", "Teleport Monster"},
		{ 20, 20,  35, "", "Summom Spectre"},
		{ 24, 22,  35, "ҥɥ龤", "Summon Hydra"},
		{ 25, 25,  40, "ԡɡ󥹥", "Hast Monster"},
		{ 28, 25,  40, "ϥɾ", "Summon Hounds" },
		{ 32, 30,  45, "󾤴", "Summon Titan" },
		{ 32, 35,  50, "󥹥", "Heal Monster"},
		{ 35, 40,  50, "󥹥", "Blast Monsters"},
		{ 38, 70,  40, "ǡ󾤴", "Summon Daemon"},
		{ 40, 75,  45, "륹","Release Logrus"},
		{ 40, 40,  40, "󥹥", "Dispel Monster"},
		{ 42, 80,  40, "磻ྤ", "Summon Wyrm"},
		{ 44, 80,  40, "饢ǥåɾ", "Summon High-Undeads"},
		{ 45, 90,  40, "Сǡ󾤴", "Summon Wyrm"},
		{ 48, 90,  60, "ѥή", "Release Pattern Voltex"},
		{ 50, 100, 65, "", "Wall of Caaws"},
#else
		{ 1,   1,  15, "Precognition" },          /* Det. monsters/traps */
		{ 2,   1,  20, "Neural Blast" },          /* ~MM */
		{ 3,   2,  25, "Minor Displacement" },    /* Phase door */
		{ 7,   6,  35, "Major Displacement" },    /* Tele. Self / All */
		{ 9,   7,  50, "Domination" },
		{ 11,  7,  30, "Pulverise" },             /* Telekinetic "bolt" */
		{ 13, 12,  50, "Character Armour" },      /* Psychic/physical defenses */
		{ 15, 12,  60, "Psychometry" },
		{ 18, 10,  45, "Mind Wave" },             /* Ball -> LOS */
		{ 23, 15,  50, "Adrenaline Channeling" },
		{ 25, 10,  40, "Psychic Drain" },         /* Convert enemy HP to mana */
		{ 28, 20,  45, "Telekinetic Wave" },      /* Ball -> LOS */
		{ 99, 0, 0, "", ""},
		{ 99, 0, 0, "", ""},
		{ 99, 0, 0, "", ""},
		{ 99, 0, 0, "", ""},
		{ 99, 0, 0, "", ""},
		{ 99, 0, 0, "", ""},
		{ 99, 0, 0, "", ""},
		{ 99, 0, 0, "", ""},
		{ 99, 0, 0, "", ""},
#endif
	}
};


void mindcraft_info(char *p, int power, int type)
{
	int plev = p_ptr->lev;

	strcpy(p, "");

	switch (type)
	{
	case MIND_MINDCRAFT:
		switch (power)
		{
		case 0:  sprintf(p, " »:%dd%d", 3 + ((plev - 1) / 5), 4); break;
		case 1:  break;
		case 2:  sprintf(p, " ϰ:%d", (plev < 25 ? 10 : plev + 2)); break;
		case 3:  sprintf(p, " ϰ:%d", plev * 5);  break;
		case 4:  break;
		case 5:  sprintf(p, " »:%dd8", 8 + ((plev - 5) / 4));  break;
		case 6:  sprintf(p, " :%d", plev);  break;
		case 7:  break;
		case 8:
			if (plev < 25)
			{
				sprintf(p, " »:%d", plev * 3 / 2);
			}
			else
			{
				sprintf(p, " »:d%d", plev * ((plev - 5) / 10 + 1));
			}
			break;
		case 9: sprintf(p, " :10+d%d", (plev * 3) / 2); break;
		case 10: sprintf(p, " »:%dd6", plev / 2);  break;
		case 11: sprintf(p, " »:%d", (plev / 10) * 50); break;
		}
	}
}


/*
 * Allow user to choose a mindcrafter power.
 *
 * If a valid spell is chosen, saves it in '*sn' and returns TRUE
 * If the user hits escape, returns FALSE, and set '*sn' to -1
 * If there are no legal choices, returns FALSE, and sets '*sn' to -2
 *
 * The "prompt" should be "cast", "recite", or "study"
 * The "known" should be TRUE for cast/pray, FALSE for study
 *
 * nb: This function has a (trivial) display bug which will be obvious
 * when you run it. It's probably easy to fix but I haven't tried,
 * sorry.
 */
static int get_mindcraft_power(int *sn, bool only_browse, int type)
{
	int i;
	int num = 0;
	int y = 1;
	int x = 20;
	int minfail = 0;
	int plev = p_ptr->lev;
	int chance = 0;
	int ask;
	int smax;
	cptr p;
	char choice;
	char out_val[160];
	char comment[80];
	bool flag, redraw;
	mindcraft_power spell;

	switch (type)
	{
	case MIND_MINDCRAFT:
#ifdef JP
		p = "Ķǽ";
#else
		p = "power";
#endif
		smax = MAX_MINDCRAFT_POWERS;
		break;
	default:
#ifdef JP
		p = "ʸ";
#else
		p = "spell";
#endif
		smax = MAX_SUMMON_POWERS;
		break;
	}

	/* Assume cancelled */
	*sn = (-1);

#ifdef ALLOW_REPEAT /* TNB */
	/* Get the spell, if available */
	if (repeat_pull(sn))
	{
		/* Verify the spell */
		if (mindcraft_powers[type][*sn].min_lev <= plev)
		{
			/* Success */
			return (TRUE);
		}
	}
#endif /* ALLOW_REPEAT -- TNB */

	/* Nothing chosen yet */
	flag = FALSE;

	/* No redraw yet */
	redraw = FALSE;

	for (i = 0; i < smax; i++)
	{
		if (mindcraft_powers[type][i].min_lev <= plev)
		{
			num++;
		}
	}

	/* Build a prompt (accept all spells) */
	if (only_browse)
	{
#ifdef JP
		(void)strnfmt(out_val, 78, "(%^s %c-%c, '*'ǰ, ESC) ɤ%sˤĤΤޤ",
#else
		(void)strnfmt(out_val, 78, "(%^ss %c-%c, *=List, ESC=exit) Use which %s? ",
#endif
		              p, I2A(0), I2A(num - 1), p);
	}
	else
	{
#ifdef JP
		(void)strnfmt(out_val, 78, "(%^s %c-%c, '*'ǰ, ESC) ɤ%sȤޤ",
#else
		(void)strnfmt(out_val, 78, "(%^ss %c-%c, *=List, ESC=exit) Use which %s? ",
#endif
	                  p, I2A(0), I2A(num - 1), p);
	}

	/* Get a spell from the user */
#ifdef JP
	choice = always_show_list ? ESCAPE : 1;
	while (!flag)
	{
		if(choice == ESCAPE) choice = ' ';
		else if( !get_com(out_val, &choice) )break; 
#else
	while (!flag && get_com(out_val, &choice))
	{
#endif

		/* Request redraw */
		if ((choice == ' ') || (choice == '*') || (choice == '?'))
		{
			/* Show the list */
			if (!redraw)
			{
				char psi_desc[80];

				/* Show list */
				redraw = TRUE;

				/* Save the screen */
				screen_save();

				/* Display a list of spells */
				prt("", y, x);
#ifdef JP
				put_str("̾", y, x + 5);
				put_str("Lv   MP Ψ ", y, x + 35);
#else
				put_str("Name", y, x + 5);
				put_str("Lv Mana Fail Info", y, x + 35);
#endif

				/* Dump the spells */
				for (i = 0; i < smax; i++)
				{
					/* Access the spell */
					spell = mindcraft_powers[type][i];
					if (spell.min_lev > plev)   break;

					chance = spell.fail;

					/* Reduce failure rate by "effective" level adjustment */
					chance -= 3 * (plev - spell.min_lev);

					/* Reduce failure rate by INT/WIS adjustment */
					chance -= 3 * (adj_mag_stat[p_ptr->stat_ind[mp_ptr->spell_stat]] - 1);

					/* Not enough mana to cast */
					if (spell.mana_cost > p_ptr->csp)
					{
						chance += 5 * (spell.mana_cost - p_ptr->csp);
					}

					/* Extract the minimum failure rate */
					minfail = adj_mag_fail[p_ptr->stat_ind[mp_ptr->spell_stat]];

					/* Minimum failure rate */
					if (chance < minfail) chance = minfail;

					/* Stunning makes spells harder */
					if (p_ptr->stun > 50) chance += 25;
					else if (p_ptr->stun) chance += 15;

					/* Always a 5 percent chance of working */
					if (chance > 95) chance = 95;

					/* Get info */
					mindcraft_info(comment, i, type);

					/* Dump the spell --(-- */
					sprintf(psi_desc, "  %c) %-30s%2d %4d %3d%%%s",
					        I2A(i), spell.name,
					        spell.min_lev, spell.mana_cost, chance, comment);
					prt(psi_desc, y + i + 1, x);
				}

				/* Clear the bottom line */
				prt("", y + i + 1, x);
			}

			/* Hide the list */
			else
			{
				/* Hide list */
				redraw = FALSE;

				/* Restore the screen */
				screen_load();
			}

			/* Redo asking */
			continue;
		}

		/* Note verify */
		ask = isupper(choice);

		/* Lowercase */
		if (ask) choice = tolower(choice);

		/* Extract request */
		i = (islower(choice) ? A2I(choice) : -1);

		/* Totally Illegal */
		if ((i < 0) || (i >= num))
		{
			bell();
			continue;
		}

		/* Save the spell index */
		spell = mindcraft_powers[type][i];

		/* Verify it */
		if (ask)
		{
			char tmp_val[160];

			/* Prompt */
#ifdef JP
			(void) strnfmt(tmp_val, 78, "%sȤޤ", mindcraft_powers[0][i].name);
#else
			(void)strnfmt(tmp_val, 78, "Use %s? ", mindcraft_powers[0][i].name);
#endif


			/* Belay that order */
			if (!get_check(tmp_val)) continue;
		}

		/* Stop the loop */
		flag = TRUE;
	}

	/* Restore the screen */
	if (redraw) screen_load();

	/* Show choices */
	if (show_choices)
	{
		/* Update */
		p_ptr->window |= (PW_SPELL);

		/* Window stuff */
		window_stuff();
	}

	/* Abort if needed */
	if (!flag) return (FALSE);

	/* Save the choice */
	(*sn) = i;

#ifdef ALLOW_REPEAT /* TNB */

	repeat_push(*sn);

#endif /* ALLOW_REPEAT -- TNB */

	/* Success */
	return (TRUE);
}


/*
 * do_cmd_cast calls this function if the player's class
 * is 'mindcrafter'.
 */
static bool cast_mindcrafter_spell(int spell)
{
	int b = 0;
	int dir;
	int plev = p_ptr->lev;


	/* spell code */
	switch (spell)
	{
	case 0:   /* Shock */
		if (!get_aim_dir(&dir)) return FALSE;

		fire_ball(GF_ELEC, dir,
			  damroll(3 + ((plev - 1) / 5), 4), 0);  
		break;
	case 1:   /* Precog */
		if (plev > 44)
			wiz_lite();
		else if (plev > 19)
			map_area(DETECT_RAD_MAP);

		if (plev < 30)
		{
			b = detect_monsters_normal(DETECT_RAD_DEFAULT);
			if (plev > 14) b |= detect_monsters_invis(DETECT_RAD_DEFAULT);
			if (plev > 4)
			{
				b |= detect_traps(DETECT_RAD_DEFAULT);
				b |= detect_doors(DETECT_RAD_DEFAULT);
			}
		}
		else
		{
			b = detect_all(DETECT_RAD_DEFAULT);
		}

		if ((plev > 24) && (plev < 40))
			set_tim_esp(p_ptr->tim_esp + plev);

#ifdef JP
		if (!b) msg_print("ʵ롣");
#else
		if (!b) msg_print("You feel safe.");
#endif
		break;
	case 2:
		/* Minor displace */
		if (plev < 40)
		{
			teleport_player(10);
		}
		else
		{
#ifdef JP
			msg_print("⤬ŪϤǲ");
#else
			msg_print("You open a dimensional gate. Choose a destination.");
#endif
			return dimension_door();
		}
		break;
	case 3:
		/* Major displace */
		teleport_player(plev * 5);
		break;
	case 4:
		/* Domination */
		if (plev < 30)
		{
			if (!get_aim_dir(&dir)) return FALSE;

			fire_ball(GF_DOMINATION, dir, plev, 0);
		}
		else
		{
			charm_monsters(plev * 2);
		}
		break;
	case 5:
		/* Fist of Force  ---  not 'true' TK  */
		if (!get_aim_dir(&dir)) return FALSE;

		fire_ball(GF_SOUND, dir, damroll(8 + ((plev - 5) / 4), 8),
			(plev > 20 ? (plev - 20) / 8 + 1 : 0));
		break;
	case 6:
		/* Character Armour */
		set_shield(p_ptr->shield + plev);
		if (plev > 14) set_oppose_acid(p_ptr->oppose_acid + plev);
		if (plev > 19) set_oppose_fire(p_ptr->oppose_fire + plev);
		if (plev > 24) set_oppose_cold(p_ptr->oppose_cold + plev);
		if (plev > 29) set_oppose_elec(p_ptr->oppose_elec + plev);
		if (plev > 34) set_oppose_pois(p_ptr->oppose_pois + plev);
		break;
	case 7:
		/* Psychometry */
		if (plev < 25)
			return psychometry();
		else
			return ident_spell(FALSE);
		break;
	case 8:
		/* Mindwave */
#ifdef JP
		msg_print("Ǳʤưȯ");
#else
		msg_print("Mind-warping forces emanate from your brain!");
#endif
		if (plev < 25)
			project(0, 2 + plev / 10, py, px,
			(plev * 3) / 2, GF_PSI, PROJECT_KILL);
		else
			(void)mindblast_monsters(randint(plev * ((plev - 5) / 10 + 1)));
		break;
	case 9:
		/* Adrenaline */
		set_afraid(0);
		set_stun(0);

		/*
		 * Only heal when Adrenalin Channeling is not active. We check
		 * that by checking if the player isn't fast and 'heroed' atm.
		 */
		if (!p_ptr->fast || !(p_ptr->hero || p_ptr->shero))
		{
			hp_player(plev);
		}

		b = 10 + randint((plev * 3) / 2);
		if (plev < 35)
			set_hero(p_ptr->hero + b);
		else
			set_shero(p_ptr->shero + b);

		if (!p_ptr->fast)
		{
			/* Haste */
			(void)set_fast(b);
		}
		else
		{
			(void)set_fast(p_ptr->fast + randint(5));
		}
		break;
	case 10:
		/* Psychic Drain */
		if (!get_aim_dir(&dir)) return FALSE;

		b = damroll(plev / 2, 6);

		/* This is always a radius-0 ball now */
		if (fire_ball(GF_PSI_DRAIN, dir, b, 0))
			p_ptr->energy -= randint(150);
		break;
	case 11:
		/* Psycho spear */
		if (!get_aim_dir(&dir)) return FALSE;

		fire_beam(GF_PSY_SPEAR, dir, (plev / 10) * 50);
		break;
	default:
#ifdef JP
		msg_print("ʤˡ");
#else
		msg_print("Zap?");
#endif
	}

	return TRUE;
}


/*
 * do_cmd_cast calls this function if the player's class
 * is 'summoner'.
 */
static bool cast_summoner_spell(int spell)
{
	int b = 0;
	int dir;
	int plev = p_ptr->lev;
	bool no_summon = FALSE;

	/* spell code */
	switch (spell)
	{
	case 0:   /* Detect Monster */
		(void)detect_monsters_normal(DETECT_RAD_DEFAULT);
		break;
	case 1:   /* Caputure Monster */
		if (hold_monster_num >= ((p_ptr->lev - 1) / 7 + 3))
		{
			msg_print("ʾ󥹥ͤǤʤ");
			return (FALSE);
		}

		if (!get_aim_dir(&dir)) return FALSE;

		if(fire_ball(GF_CAPTURE, dir, 0, 0))
		{
			hold_monster_num ++;
#if 0
				o_ptr->pval = capt.r_idx;
				o_ptr->xtra3 = capt.mspeed;
				o_ptr->xtra4 = capt.hp;
				o_ptr->xtra5 = capt.maxhp;
				if (cap_nickname)
				{
					cptr t;
					char *s;
					char buf[80] = "";

					if (o_ptr->inscription)
						strcpy(buf, quark_str(o_ptr->inscription));
					s = buf;
					for (s = buf;*s && (*s != '#'); s++)
					{
#ifdef JP
						if (iskanji(*s)) s++;
#endif
					}
					*s = '#';
					s++;
#ifndef JP
					*s++ = '\'';
#endif
					t = quark_str(cap_nickname);
					while (*t)
					{
						*s = *t;
						s++;
						t++;
					}
#ifndef JP
					*s++ = '\'';
#endif
					*s = '\0';
					o_ptr->inscription = quark_add(buf);
				}
			}
#endif
		}
		break;

	case 2:   /* Release Monster */
	{
		int i;
		char choice;
		bool success = FALSE;
		
		/* No holded monster */
		if (hold_monster_num == 0)
		{
			msg_print("ͤƤ󥹥ޤ");
			return (FALSE);
		}

		screen_save();

		/* Display holded monsters */
		for (i = 0; i < hold_monster_num; i++)
		{
			monster_race *r_ptr = &r_info[holded_monster[i].r_idx];
			cptr name = (r_name + r_ptr->name);

			prt(format("  %c) %s", I2A(i), name), i + 1, 20);
		}

		while (get_com("ɤΥ󥹥ޤ", &choice))
		{
			/* Extract request */
			i = (islower(choice) ? A2I(choice) : -1);

			/* Totally Illegal */
			if ((i < 0) || (i >= hold_monster_num))
			{
				bell();
				continue;
			}

			if (!get_rep_dir(&dir)) return FALSE;

			if (cave_floor_bold(py+ddy[dir],px+ddx[dir]))
			{
				hold_mon_type *h_ptr = &holded_monster[i];

				if (place_monster_one(py + ddy[dir], px + ddx[dir], h_ptr->r_idx, FALSE, TRUE, TRUE))
				{
					monster_type *m_ptr = &m_list[hack_m_idx_ii];

					m_ptr->mspeed = h_ptr->mspeed;
					m_ptr->hp = h_ptr->hp;
					m_ptr->maxhp = h_ptr->maxhp;
					success = TRUE;
				}
			}

			if (success)
			{
				int j;

				/* Pack */
				for (j = i; j < hold_monster_num; j++)
				{
					holded_monster[j] = holded_monster[j+1];
				}
				hold_monster_num--;
			}
			else
			{
#ifdef JP
				msg_print("äȡ˼Ԥ");
#else
				msg_print("Oops.  You failed to release your pet.");
#endif
			}
			break;
		}

		screen_load();

		break;
	}
	case 3:   /* Summon Spider */
		{
			bool pet = 1;
			bool group = TRUE;

			if (summon_specific((pet ? -1 : 0), py, px, plev, SUMMON_SPIDER, group, FALSE, pet))
			{
				if (!pet)
#ifdef JP
					msg_print("줿ܤäƤ롪");
#else
					msg_print("The summoned spiders get angry!");
#endif
			}
			else
			{
				no_summon = TRUE;
			}
			break;
		}
	case 4:   /* Summon Golem */
		{
			bool pet = 1;
			bool group = FALSE;

			if (summon_specific((pet ? -1 : 0), py, px, plev, SUMMON_GOLEM, group, FALSE, pet))
			{
				if (!pet)
#ifdef JP
					msg_print("˼Ԥ");
#else
					msg_print("Your fail to control your golem!");
#endif
			}
			else
			{
				no_summon = TRUE;
			}
			break;
		}
	case 5:   /* Teleport Other */
		if (!get_aim_dir(&dir)) return FALSE;

		(void)fire_beam(GF_AWAY_ALL, dir, plev);
		break;
	case 6:   /* Summon Spectre */
		{
			bool pet = 1;
			bool group = TRUE;

			if (summon_specific((pet ? -1 : 0), py, px, plev, SUMMON_PHANTOM, group, FALSE, pet))
			{
				if (!pet)
#ifdef JP
					msg_print("줿ܤäƤ롪");
#else
					msg_print("The summoned spectre get angry!");
#endif
			}
			else
			{
				no_summon = TRUE;
			}
			break;
		}
	case 7:   /* Summon Hydra */
		{
			bool pet = 1;
			bool group = FALSE;

			if (summon_specific((pet ? -1 : 0), py, px, plev, SUMMON_HYDRA, group, FALSE, pet))
			{
				if (!pet)
#ifdef JP
					msg_print("줿ҥɥܤäƤ롪");
#else
					msg_print("The summoned hydra get angry!");
#endif
			}
			else
			{
				no_summon = TRUE;
			}
			break;
		}
	case 8:   /* Haste Monster */
		if (!get_aim_dir(&dir)) return FALSE;

		(void)speed_monster(dir);
		break;
	case 9:
		/* Adrenaline */
		set_afraid(0);
		set_stun(0);

		/*
		 * Only heal when Adrenalin Channeling is not active. We check
		 * that by checking if the player isn't fast and 'heroed' atm.
		 */
		if (!p_ptr->fast || !(p_ptr->hero || p_ptr->shero))
		{
			hp_player(plev);
		}

		b = 10 + randint((plev * 3) / 2);
		if (plev < 35)
			set_hero(p_ptr->hero + b);
		else
			set_shero(p_ptr->shero + b);

		if (!p_ptr->fast)
		{
			/* Haste */
			(void)set_fast(b);
		}
		else
		{
			(void)set_fast(p_ptr->fast + randint(5));
		}
		break;
	case 10:
		/* Psychic Drain */
		if (!get_aim_dir(&dir)) return FALSE;

		b = damroll(plev / 2, 6);

		/* This is always a radius-0 ball now */
		if (fire_ball(GF_PSI_DRAIN, dir, b, 0))
			p_ptr->energy -= randint(150);
		break;
	case 11:
		/* Psycho spear */
		if (!get_aim_dir(&dir)) return FALSE;

		fire_beam(GF_PSY_SPEAR, dir, (plev / 10) * 50);
		break;
	default:
#ifdef JP
		msg_print("ʤˡ");
#else
		msg_print("Zap?");
#endif
	}

	if (no_summon)
	{
#ifdef JP
		msg_print("ï⤢ʤθƤʤ");
#else
		msg_print("Nobody answers to your call.");
#endif

	}

	return TRUE;
}


/*
 * do_cmd_cast calls this function if the player's class
 * is 'mindcrafter'.
 */
void do_cmd_mindcraft(void)
{
	int n = 0;
	int chance;
	int minfail = 0;
	int plev = p_ptr->lev;
	int old_csp = p_ptr->csp;
	int type;
	bool cast;
	mindcraft_power spell;

	switch (p_ptr->pclass)
	{
	case CLASS_MINDCRAFTER: type = MIND_MINDCRAFT; break;
	case CLASS_SUMMONER: type = MIND_SUMMONER; break;
	default: type = MIND_MINDCRAFT; break;
	}

	/* not if confused */
	if (p_ptr->confused)
	{
#ifdef JP
		msg_print("𤷤ƤƽǤʤ");
#else
		msg_print("You are too confused!");
#endif
		return;
	}

	/* get power */
	if (!get_mindcraft_power(&n, FALSE, type)) return;

	spell = mindcraft_powers[type][n];

	/* Verify "dangerous" spells */
	if (spell.mana_cost > p_ptr->csp)
	{
		/* Warning */
#ifdef JP
		msg_print("ͣФ­ޤ");
#else
		msg_print("You do not have enough mana to use this power.");
#endif

		if (!over_exert) return;

		/* Verify */
#ifdef JP
		if (!get_check("Ǥĩ路ޤ? ")) return;
#else
		if (!get_check("Attempt it anyway? ")) return;
#endif
	}

	/* Spell failure chance */
	chance = spell.fail;

	/* Reduce failure rate by "effective" level adjustment */
	chance -= 3 * (plev - spell.min_lev);

	/* Reduce failure rate by INT/WIS adjustment */
	chance -= 3 * (adj_mag_stat[p_ptr->stat_ind[mp_ptr->spell_stat]] - 1);

	/* Not enough mana to cast */
	if (spell.mana_cost > p_ptr->csp)
	{
		chance += 5 * (spell.mana_cost - p_ptr->csp);
	}

	/* Extract the minimum failure rate */
	minfail = adj_mag_fail[p_ptr->stat_ind[mp_ptr->spell_stat]];

	/* Minimum failure rate */
	if (chance < minfail) chance = minfail;

	/* Stunning makes spells harder */
	if (p_ptr->stun > 50) chance += 25;
	else if (p_ptr->stun) chance += 15;

	/* Always a 5 percent chance of working */
	if (chance > 95) chance = 95;

	/* Failed spell */
	if (rand_int(100) < chance)
	{
		if (flush_failure) flush();
#ifdef JP
		msg_format("ν˼Ԥ");
#else
		msg_format("You failed to concentrate hard enough!");
#endif
		sound(SOUND_FAIL);

		if (type == MIND_MINDCRAFT && (randint(100) < (chance / 2)))
		{
			/* Backfire */
			int b = randint(100);
			if (b < 5)
			{
#ifdef JP
				msg_print("ʤƤäƬ椬ˤʤä");
#else
				msg_print("Oh, no! Your mind has gone blank!");
#endif
				lose_all_info();
			}
			else if (b < 15)
			{
#ifdef JP
				msg_print("̯ʸʤܤ٤äƤ...");
#else
				msg_print("Weird visions seem to dance before your eyes...");
#endif
				set_image(p_ptr->image + 5 + randint(10));
			}
			else if (b < 45)
			{
#ifdef JP
				msg_print("ʤƬϺ𤷤");
#else
				msg_print("Your brain is addled!");
#endif
				set_confused(p_ptr->confused + randint(8));
			}
			else if (b < 90)
			{
				set_stun(p_ptr->stun + randint(8));
			}
			else
			{
				/* Mana storm */
#ifdef JP
				msg_print("ϤǤʤήȤʤäƲ줿");
#else
				msg_print("Your mind unleashes its power in an uncontrollable storm!");
#endif
				project(1, 2 + plev / 10, py, px, plev * 2,
					GF_MANA, PROJECT_JUMP | PROJECT_KILL | PROJECT_GRID | PROJECT_ITEM);
				p_ptr->csp = MAX(0, p_ptr->csp - plev * MAX(1, plev / 10));
			}
		}
	}
	else
	{
		sound(SOUND_ZAP);

		/* Cast the spell */
		switch (type)
		{
			case MIND_MINDCRAFT:
				cast = cast_mindcrafter_spell(n);
				break;
			case MIND_SUMMONER:
				cast = cast_summoner_spell(n);
				break;
			default:
				cast = 0;
				break;
		}

		if (!cast) return;
	}

	/* Take a turn */
	energy_use = 100;

	/* Sufficient mana */
	if (spell.mana_cost <= old_csp)
	{
		/* Use some mana */
		p_ptr->csp -= spell.mana_cost;

		/* Limit */
		if (p_ptr->csp < 0) p_ptr->csp = 0;
	}

	/* Over-exert the player */
	else
	{
		int oops = spell.mana_cost - old_csp;

		/* No mana left */
		p_ptr->csp = 0;
		p_ptr->csp_frac = 0;

		/* Message */
#ifdef JP
		msg_print("椷Ƶ򼺤äƤޤä");
#else
		msg_print("You faint from the effort!");
#endif

		/* Hack -- Bypass free action */
		(void)set_paralyzed(p_ptr->paralyzed + randint(5 * oops + 1));

		/* Damage WIS (possibly permanently) */
		if (rand_int(100) < 50)
		{
			bool perm = (rand_int(100) < 25);

			/* Message */
#ifdef JP
			msg_print("ʬ򹶷⤷Ƥޤä");
#else
			msg_print("You have damaged your mind!");
#endif

			/* Reduce constitution */
			(void)dec_stat(A_WIS, 15 + randint(10), perm);
		}
	}

	/* Redraw mana */
	p_ptr->redraw |= (PR_MANA);

	/* Window stuff */
	p_ptr->window |= (PW_PLAYER);
	p_ptr->window |= (PW_SPELL);
}

/*
 * do_cmd_cast calls this function if the player's class
 * is 'mindcrafter'.
 */
void do_cmd_mind_browse(void)
{
	int n = 0;
	int j, line, type;
	char temp[62 * 5];

	switch (p_ptr->pclass)
	{
	case CLASS_MINDCRAFTER: type = MIND_MINDCRAFT; break;
	case CLASS_SUMMONER: type = MIND_SUMMONER; break;
	default: type = MIND_MINDCRAFT; break;
	}

	screen_save();

	while(1)
	{
		/* get power */
		if (!get_mindcraft_power(&n, TRUE, type))
		{
			screen_load();
			return;
		}

		/* Clear lines, position cursor  (really should use strlen here) */
		Term_erase(12, 21, 255);
		Term_erase(12, 20, 255);
		Term_erase(12, 19, 255);
		Term_erase(12, 18, 255);
		Term_erase(12, 17, 255);
		Term_erase(12, 16, 255);

		roff_to_buf(mind_tips[type][n], 62, temp);
		for(j = 0, line = 17; temp[j]; j += (1 + strlen(&temp[j])))
		{
			prt(&temp[j], line, 15);
			line++;
		}
	}

	screen_load();
}
