/* CVS: Last edit by $Author: habu $ on $Date: 2001-05-11 07:35:58 +0900 (Fri, 11 May 2001) $ */
/* File: tables.c */

/* Purpose: Angband Tables */

/*
 * Copyright (c) 1989 James E. Wilson, Robert A. Koeneke
 *
 * This software may be copied and distributed for educational, research, and
 * not for profit purposes provided that this copyright and statement are
 * included in all such copies.
 */

#include "angband.h"




/*
 * Global array for looping through the "keypad directions"
 */
s16b ddd[9] =
{ 2, 8, 6, 4, 3, 1, 9, 7, 5 };

/*
 * Global arrays for converting "keypad direction" into offsets
 */
s16b ddx[10] =
{ 0, -1, 0, 1, -1, 0, 1, -1, 0, 1 };

s16b ddy[10] =
{ 0, 1, 1, 1, 0, 0, 0, -1, -1, -1 };

/*
 * Global arrays for optimizing "ddx[ddd[i]]" and "ddy[ddd[i]]"
 */
s16b ddx_ddd[9] =
{ 0, 0, 1, -1, 1, -1, 1, -1, 0 };

s16b ddy_ddd[9] =
{ 1, -1, 0, 0, 1, 1, -1, -1, 0 };


/*
 * Circular keypad direction array
 */
s16b cdd[8] =
{ 2, 3, 6, 9, 8, 7, 4, 1 };

/*
 * Global arrays for optimizing "ddx[cdd[i]]" and "ddy[cdd[i]]"
 */
s16b ddx_cdd[8] =
{ 0, 1, 1, 1, 0, -1, -1, -1 };

s16b ddy_cdd[8] =
{ 1, 1, 0, -1, -1, -1, 0, 1 };



/*
 * Global array for converting numbers to uppercase hecidecimal digit
 * This array can also be used to convert a number to an octal digit
 */
char hexsym[16] =
{
	'0', '1', '2', '3', '4', '5', '6', '7',
	'8', '9', 'A', 'B', 'C', 'D', 'E', 'F'
};


/*
 * Global array for converting numbers to a logical list symbol
 */
char listsym[] =
{
	'0', '1', '2', '3', '4', '5', '6', '7', '8', '9',
	'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm',
	'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z',
	'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M',
	'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z',
	'\0'
};


/*
 * Encode the screen colors
 */
cptr color_char = "dwsorgbuDWvyRGBU";


/*
 * Stat Table (INT/WIS) -- Number of half-spells per level
 */
byte adj_mag_study[] =
{
	0	/* 3 */,
	0	/* 4 */,
	0	/* 5 */,
	0	/* 6 */,
	0	/* 7 */,
	1	/* 8 */,
	1	/* 9 */,
	1	/* 10 */,
	1	/* 11 */,
	2	/* 12 */,
	2	/* 13 */,
	2	/* 14 */,
	2	/* 15 */,
	2	/* 16 */,
	2	/* 17 */,
	2	/* 18/00-18/09 */,
	2	/* 18/10-18/19 */,
	2	/* 18/20-18/29 */,
	2	/* 18/30-18/39 */,
	2	/* 18/40-18/49 */,
	3	/* 18/50-18/59 */,
	3	/* 18/60-18/69 */,
	3	/* 18/70-18/79 */,
	3	/* 18/80-18/89 */,
	4	/* 18/90-18/99 */,
	4	/* 18/100-18/109 */,
	4	/* 18/110-18/119 */,
	5	/* 18/120-18/129 */,
	5	/* 18/130-18/139 */,
	5	/* 18/140-18/149 */,
	5	/* 18/150-18/159 */,
	5	/* 18/160-18/169 */,
	5	/* 18/170-18/179 */,
	5	/* 18/180-18/189 */,
	5	/* 18/190-18/199 */,
	5	/* 18/200-18/209 */,
	6	/* 18/210-18/219 */,
	6	/* 18/220+ */
};


/*
 * Stat Table (INT/WIS) -- extra half-mana-points per level
 */
byte adj_mag_mana[] =
{
	0       /* 3 */,
	0       /* 4 */,
	0       /* 5 */,
	0       /* 6 */,
	0       /* 7 */,
	1       /* 8 */,
	2       /* 9 */,
	2       /* 10 */,
	2       /* 11 */,
	2       /* 12 */,
	2       /* 13 */,
	2       /* 14 */,
	2       /* 15 */,
	2       /* 16 */,
	2       /* 17 */,
	3       /* 18/00-18/09 */,
	3       /* 18/10-18/19 */,
	3       /* 18/20-18/29 */,
	3       /* 18/30-18/39 */,
	3       /* 18/40-18/49 */,
	4       /* 18/50-18/59 */,
	4       /* 18/60-18/69 */,
	5       /* 18/70-18/79 */,
	6       /* 18/80-18/89 */,
	7       /* 18/90-18/99 */,
	8       /* 18/100-18/109 */,
	9       /* 18/110-18/119 */,
	10      /* 18/120-18/129 */,
	11      /* 18/130-18/139 */,
	12      /* 18/140-18/149 */,
	13      /* 18/150-18/159 */,
	14      /* 18/160-18/169 */,
	15      /* 18/170-18/179 */,
	16      /* 18/180-18/189 */,
	16      /* 18/190-18/199 */,
	17      /* 18/200-18/209 */,
	17      /* 18/210-18/219 */,
	18      /* 18/220+ */
};


/*
 * Stat Table (INT/WIS) -- Minimum failure rate (percentage)
 */
byte adj_mag_fail[] =
{
	99      /* 3 */,
	99      /* 4 */,
	99      /* 5 */,
	99      /* 6 */,
	99      /* 7 */,
	50      /* 8 */,
	30      /* 9 */,
	20      /* 10 */,
	15      /* 11 */,
	12      /* 12 */,
	11      /* 13 */,
	10      /* 14 */,
	9       /* 15 */,
	8       /* 16 */,
	7       /* 17 */,
	6       /* 18/00-18/09 */,
	6       /* 18/10-18/19 */,
	5       /* 18/20-18/29 */,
	5       /* 18/30-18/39 */,
	5       /* 18/40-18/49 */,
	4       /* 18/50-18/59 */,
	4       /* 18/60-18/69 */,
	4       /* 18/70-18/79 */,
	4       /* 18/80-18/89 */,
	3       /* 18/90-18/99 */,
	3       /* 18/100-18/109 */,
	2       /* 18/110-18/119 */,
	2       /* 18/120-18/129 */,
	2       /* 18/130-18/139 */,
	2       /* 18/140-18/149 */,
	1       /* 18/150-18/159 */,
	1       /* 18/160-18/169 */,
	1       /* 18/170-18/179 */,
	1       /* 18/180-18/189 */,
	1       /* 18/190-18/199 */,
	0       /* 18/200-18/209 */,
	0       /* 18/210-18/219 */,
	0       /* 18/220+ */
};


/*
 * Stat Table (INT/WIS) -- Various things
 */
byte adj_mag_stat[] =
{
	0       /* 3 */,
	0       /* 4 */,
	0       /* 5 */,
	0       /* 6 */,
	0       /* 7 */,
	1       /* 8 */,
	1       /* 9 */,
	1       /* 10 */,
	1       /* 11 */,
	1       /* 12 */,
	1       /* 13 */,
	1       /* 14 */,
	2       /* 15 */,
	2       /* 16 */,
	2       /* 17 */,
	3       /* 18/00-18/09 */,
	3       /* 18/10-18/19 */,
	3       /* 18/20-18/29 */,
	3       /* 18/30-18/39 */,
	3       /* 18/40-18/49 */,
	4       /* 18/50-18/59 */,
	4       /* 18/60-18/69 */,
	5       /* 18/70-18/79 */,
	6       /* 18/80-18/89 */,
	7       /* 18/90-18/99 */,
	8       /* 18/100-18/109 */,
	9       /* 18/110-18/119 */,
	10      /* 18/120-18/129 */,
	11      /* 18/130-18/139 */,
	12      /* 18/140-18/149 */,
	13      /* 18/150-18/159 */,
	14      /* 18/160-18/169 */,
	15      /* 18/170-18/179 */,
	16      /* 18/180-18/189 */,
	17      /* 18/190-18/199 */,
	18      /* 18/200-18/209 */,
	19      /* 18/210-18/219 */,
	20      /* 18/220+ */
};


/*
 * Stat Table (CHR) -- payment percentages
 */
byte adj_chr_gold[] =
{
	130     /* 3 */,
	125     /* 4 */,
	122     /* 5 */,
	120     /* 6 */,
	118     /* 7 */,
	116     /* 8 */,
	114     /* 9 */,
	112     /* 10 */,
	110     /* 11 */,
	108     /* 12 */,
	106     /* 13 */,
	104     /* 14 */,
	103     /* 15 */,
	102     /* 16 */,
	101     /* 17 */,
	100     /* 18/00-18/09 */,
	99      /* 18/10-18/19 */,
	98      /* 18/20-18/29 */,
	97      /* 18/30-18/39 */,
	96      /* 18/40-18/49 */,
	95      /* 18/50-18/59 */,
	94      /* 18/60-18/69 */,
	93      /* 18/70-18/79 */,
	92      /* 18/80-18/89 */,
	91      /* 18/90-18/99 */,
	90      /* 18/100-18/109 */,
	89      /* 18/110-18/119 */,
	88      /* 18/120-18/129 */,
	87      /* 18/130-18/139 */,
	86      /* 18/140-18/149 */,
	85      /* 18/150-18/159 */,
	84      /* 18/160-18/169 */,
	83      /* 18/170-18/179 */,
	82      /* 18/180-18/189 */,
	81      /* 18/190-18/199 */,
	80      /* 18/200-18/209 */,
	79      /* 18/210-18/219 */,
	78      /* 18/220+ */
};


/*
 * Stat Table (INT) -- Magic devices
 */
byte adj_int_dev[] =
{
	0       /* 3 */,
	0       /* 4 */,
	0       /* 5 */,
	0       /* 6 */,
	0       /* 7 */,
	1       /* 8 */,
	1       /* 9 */,
	1       /* 10 */,
	1       /* 11 */,
	1       /* 12 */,
	1       /* 13 */,
	1       /* 14 */,
	2       /* 15 */,
	2       /* 16 */,
	2       /* 17 */,
	3       /* 18/00-18/09 */,
	3       /* 18/10-18/19 */,
	4       /* 18/20-18/29 */,
	4       /* 18/30-18/39 */,
	5       /* 18/40-18/49 */,
	5       /* 18/50-18/59 */,
	6       /* 18/60-18/69 */,
	6       /* 18/70-18/79 */,
	7       /* 18/80-18/89 */,
	7       /* 18/90-18/99 */,
	8       /* 18/100-18/109 */,
	9       /* 18/110-18/119 */,
	10      /* 18/120-18/129 */,
	11      /* 18/130-18/139 */,
	12      /* 18/140-18/149 */,
	13      /* 18/150-18/159 */,
	14      /* 18/160-18/169 */,
	15      /* 18/170-18/179 */,
	16      /* 18/180-18/189 */,
	17      /* 18/190-18/199 */,
	18      /* 18/200-18/209 */,
	19      /* 18/210-18/219 */,
	20      /* 18/220+ */
};


/*
 * Stat Table (WIS) -- Saving throw
 */
byte adj_wis_sav[] =
{
	0       /* 3 */,
	0       /* 4 */,
	0       /* 5 */,
	0       /* 6 */,
	0       /* 7 */,
	1       /* 8 */,
	1       /* 9 */,
	1       /* 10 */,
	1       /* 11 */,
	1       /* 12 */,
	1       /* 13 */,
	1       /* 14 */,
	2       /* 15 */,
	2       /* 16 */,
	2       /* 17 */,
	3       /* 18/00-18/09 */,
	3       /* 18/10-18/19 */,
	3       /* 18/20-18/29 */,
	3       /* 18/30-18/39 */,
	3       /* 18/40-18/49 */,
	4       /* 18/50-18/59 */,
	4       /* 18/60-18/69 */,
	5       /* 18/70-18/79 */,
	5       /* 18/80-18/89 */,
	6       /* 18/90-18/99 */,
	7       /* 18/100-18/109 */,
	8       /* 18/110-18/119 */,
	9       /* 18/120-18/129 */,
	10      /* 18/130-18/139 */,
	11      /* 18/140-18/149 */,
	12      /* 18/150-18/159 */,
	13      /* 18/160-18/169 */,
	14      /* 18/170-18/179 */,
	15      /* 18/180-18/189 */,
	16      /* 18/190-18/199 */,
	17      /* 18/200-18/209 */,
	18      /* 18/210-18/219 */,
	19      /* 18/220+ */
};


/*
 * Stat Table (DEX) -- disarming
 */
byte adj_dex_dis[] =
{
	0       /* 3 */,
	0       /* 4 */,
	0       /* 5 */,
	0       /* 6 */,
	0       /* 7 */,
	0       /* 8 */,
	0       /* 9 */,
	0       /* 10 */,
	0       /* 11 */,
	0       /* 12 */,
	1       /* 13 */,
	1       /* 14 */,
	1       /* 15 */,
	2       /* 16 */,
	2       /* 17 */,
	4       /* 18/00-18/09 */,
	4       /* 18/10-18/19 */,
	4       /* 18/20-18/29 */,
	4       /* 18/30-18/39 */,
	5       /* 18/40-18/49 */,
	5       /* 18/50-18/59 */,
	5       /* 18/60-18/69 */,
	6       /* 18/70-18/79 */,
	6       /* 18/80-18/89 */,
	7       /* 18/90-18/99 */,
	8       /* 18/100-18/109 */,
	8       /* 18/110-18/119 */,
	8       /* 18/120-18/129 */,
	8       /* 18/130-18/139 */,
	8       /* 18/140-18/149 */,
	9       /* 18/150-18/159 */,
	9       /* 18/160-18/169 */,
	9       /* 18/170-18/179 */,
	9       /* 18/180-18/189 */,
	9       /* 18/190-18/199 */,
	10      /* 18/200-18/209 */,
	10      /* 18/210-18/219 */,
	10      /* 18/220+ */
};


/*
 * Stat Table (INT) -- disarming
 */
byte adj_int_dis[] =
{
	0       /* 3 */,
	0       /* 4 */,
	0       /* 5 */,
	0       /* 6 */,
	0       /* 7 */,
	1       /* 8 */,
	1       /* 9 */,
	1       /* 10 */,
	1       /* 11 */,
	1       /* 12 */,
	1       /* 13 */,
	1       /* 14 */,
	2       /* 15 */,
	2       /* 16 */,
	2       /* 17 */,
	3       /* 18/00-18/09 */,
	3       /* 18/10-18/19 */,
	3       /* 18/20-18/29 */,
	4       /* 18/30-18/39 */,
	4       /* 18/40-18/49 */,
	5       /* 18/50-18/59 */,
	6       /* 18/60-18/69 */,
	7       /* 18/70-18/79 */,
	8       /* 18/80-18/89 */,
	9       /* 18/90-18/99 */,
	10      /* 18/100-18/109 */,
	10      /* 18/110-18/119 */,
	11      /* 18/120-18/129 */,
	12      /* 18/130-18/139 */,
	13      /* 18/140-18/149 */,
	14      /* 18/150-18/159 */,
	15      /* 18/160-18/169 */,
	16      /* 18/170-18/179 */,
	17      /* 18/180-18/189 */,
	18      /* 18/190-18/199 */,
	19      /* 18/200-18/209 */,
	19      /* 18/210-18/219 */,
	20      /* 18/220+ */
};


/*
 * Stat Table (DEX) -- bonus to ac (plus 128)
 */
byte adj_dex_ta[] =
{
	128 + -4    /*  3 */,
	128 + -3    /*  4 */,
	128 + -2    /*  5 */,
	128 + -1    /*  6 */,
	128 + 0     /*  7 */,
	128 + 0     /*  8 */,
	128 + 0     /*  9 */,
	128 + 0     /* 10 */,
	128 + 0     /* 11 */,
	128 + 0     /* 12 */,
	128 + 0     /* 13 */,
	128 + 0     /* 14 */,
	128 + 1     /* 15 */,
	128 + 1     /* 16 */,
	128 + 1     /* 17 */,
	128 + 2     /* 18/00-18/09 */,
	128 + 2     /* 18/10-18/19 */,
	128 + 2     /* 18/20-18/29 */,
	128 + 2     /* 18/30-18/39 */,
	128 + 2     /* 18/40-18/49 */,
	128 + 3     /* 18/50-18/59 */,
	128 + 3     /* 18/60-18/69 */,
	128 + 3     /* 18/70-18/79 */,
	128 + 4     /* 18/80-18/89 */,
	128 + 5     /* 18/90-18/99 */,
	128 + 6     /* 18/100-18/109 */,
	128 + 7     /* 18/110-18/119 */,
	128 + 8     /* 18/120-18/129 */,
	128 + 9     /* 18/130-18/139 */,
	128 + 9     /* 18/140-18/149 */,
	128 + 10    /* 18/150-18/159 */,
	128 + 11    /* 18/160-18/169 */,
	128 + 12    /* 18/170-18/179 */,
	128 + 13    /* 18/180-18/189 */,
	128 + 14    /* 18/190-18/199 */,
	128 + 15    /* 18/200-18/209 */,
	128 + 15    /* 18/210-18/219 */,
	128 + 16    /* 18/220+ */
};


/*
 * Stat Table (STR) -- bonus to Deadliness (plus 128).  To compensate
 * for changes elsewhere, STR now has a larger effect. -LM-
 */
byte adj_str_td[] =
{
	128 + -2	/* 3 */,
	128 + -2	/* 4 */,
	128 + -1	/* 5 */,
	128 + -1	/* 6 */,
	128 + 0	/* 7 */,
	128 + 0	/* 8 */,
	128 + 0	/* 9 */,
	128 + 0	/* 10 */,
	128 + 0	/* 11 */,
	128 + 0	/* 12 */,
	128 + 0	/* 13 */,
	128 + 0	/* 14 */,
	128 + 0	/* 15 */,
	128 + 1	/* 16 */,
	128 + 2	/* 17 */,
	128 + 3	/* 18/00-18/09 */,
	128 + 4	/* 18/10-18/19 */,
	128 + 4	/* 18/20-18/29 */,
	128 + 5	/* 18/30-18/39 */,
	128 + 6	/* 18/40-18/49 */,
	128 + 7	/* 18/50-18/59 */,
	128 + 8	/* 18/60-18/69 */,
	128 + 9	/* 18/70-18/79 */,
	128 + 10	/* 18/80-18/89 */,
	128 + 11	/* 18/90-18/99 */,
	128 + 12	/* 18/100-18/109 */,
	128 + 13	/* 18/110-18/119 */,
	128 + 14	/* 18/120-18/129 */,
	128 + 15	/* 18/130-18/139 */,
	128 + 16	/* 18/140-18/149 */,
	128 + 17	/* 18/150-18/159 */,
	128 + 18	/* 18/160-18/169 */,
	128 + 19	/* 18/170-18/179 */,
	128 + 20	/* 18/180-18/189 */,
	128 + 21	/* 18/190-18/199 */,
	128 + 22	/* 18/200-18/209 */,
	128 + 23	/* 18/210-18/219 */,
	128 + 25	/* 18/220+ */
};


/*
 * Stat Table (DEX) -- bonus to Skill (plus 128.  To compensate for
 * changes elsewhere, DEX now has a larger effect. -LM-
 */
byte adj_dex_th[] =
{
	128 + -4	/* 3 */,
	128 + -3	/* 4 */,
	128 + -2	/* 5 */,
	128 + -1	/* 6 */,
	128 + -1	/* 7 */,
	128 + 0	/* 8 */,
	128 + 0	/* 9 */,
	128 + 0	/* 10 */,
	128 + 0	/* 11 */,
	128 + 0	/* 12 */,
	128 + 0	/* 13 */,
	128 + 0	/* 14 */,
	128 + 1	/* 15 */,
	128 + 2	/* 16 */,
	128 + 3	/* 17 */,
	128 + 3	/* 18/00-18/09 */,
	128 + 3	/* 18/10-18/19 */,
	128 + 4	/* 18/20-18/29 */,
	128 + 4	/* 18/30-18/39 */,
	128 + 4	/* 18/40-18/49 */,
	128 + 5	/* 18/50-18/59 */,
	128 + 5	/* 18/60-18/69 */,
	128 + 6	/* 18/70-18/79 */,
	128 + 6	/* 18/80-18/89 */,
	128 + 7	/* 18/90-18/99 */,
	128 + 8	/* 18/100-18/109 */,
	128 + 9	/* 18/110-18/119 */,
	128 + 10	/* 18/120-18/129 */,
	128 + 11	/* 18/130-18/139 */,
	128 + 12	/* 18/140-18/149 */,
	128 + 13	/* 18/150-18/159 */,
	128 + 14	/* 18/160-18/169 */,
	128 + 15	/* 18/170-18/179 */,
	128 + 16	/* 18/180-18/189 */,
	128 + 17	/* 18/190-18/199 */,
	128 + 18	/* 18/200-18/209 */,
	128 + 19	/* 18/210-18/219 */,
	128 + 20	/* 18/220+ */
};



/*
 * Stat Table (STR) -- weight limit in deca-pounds
 */
byte adj_str_wgt[] =
{
	5       /* 3 */,
	6       /* 4 */,
	7       /* 5 */,
	8       /* 6 */,
	9       /* 7 */,
	10      /* 8 */,
	11      /* 9 */,
	12      /* 10 */,
	13      /* 11 */,
	14      /* 12 */,
	15      /* 13 */,
	16      /* 14 */,
	17      /* 15 */,
	18      /* 16 */,
	19      /* 17 */,
	20      /* 18/00-18/09 */,
	22      /* 18/10-18/19 */,
	24      /* 18/20-18/29 */,
	26      /* 18/30-18/39 */,
	28      /* 18/40-18/49 */,
	30      /* 18/50-18/59 */,
	31      /* 18/60-18/69 */,
	31      /* 18/70-18/79 */,
	32      /* 18/80-18/89 */,
	32      /* 18/90-18/99 */,
	33      /* 18/100-18/109 */,
	33      /* 18/110-18/119 */,
	34      /* 18/120-18/129 */,
	34      /* 18/130-18/139 */,
	35      /* 18/140-18/149 */,
	35      /* 18/150-18/159 */,
	36      /* 18/160-18/169 */,
	36      /* 18/170-18/179 */,
	37      /* 18/180-18/189 */,
	37      /* 18/190-18/199 */,
	38      /* 18/200-18/209 */,
	38      /* 18/210-18/219 */,
	39      /* 18/220+ */
};


/*
 * Stat Table (STR) -- weapon weight limit in pounds
 */
byte adj_str_hold[] =
{
	4       /* 3 */,
	5       /* 4 */,
	6       /* 5 */,
	7       /* 6 */,
	8       /* 7 */,
	10      /* 8 */,
	12      /* 9 */,
	14      /* 10 */,
	16      /* 11 */,
	18      /* 12 */,
	20      /* 13 */,
	22      /* 14 */,
	24      /* 15 */,
	26      /* 16 */,
	28      /* 17 */,
	30      /* 18/00-18/09 */,
	30      /* 18/10-18/19 */,
	35      /* 18/20-18/29 */,
	40      /* 18/30-18/39 */,
	45      /* 18/40-18/49 */,
	50      /* 18/50-18/59 */,
	55      /* 18/60-18/69 */,
	60      /* 18/70-18/79 */,
	65      /* 18/80-18/89 */,
	70      /* 18/90-18/99 */,
	80      /* 18/100-18/109 */,
	80      /* 18/110-18/119 */,
	80      /* 18/120-18/129 */,
	80      /* 18/130-18/139 */,
	80      /* 18/140-18/149 */,
	90      /* 18/150-18/159 */,
	90      /* 18/160-18/169 */,
	90      /* 18/170-18/179 */,
	90      /* 18/180-18/189 */,
	90      /* 18/190-18/199 */,
	100     /* 18/200-18/209 */,
	100     /* 18/210-18/219 */,
	100     /* 18/220+ */
};


/*
 * Stat Table (STR) -- digging value
 */
byte adj_str_dig[] =
{
	0       /* 3 */,
	0       /* 4 */,
	1       /* 5 */,
	2       /* 6 */,
	3       /* 7 */,
	4       /* 8 */,
	4       /* 9 */,
	5       /* 10 */,
	5       /* 11 */,
	6       /* 12 */,
	6       /* 13 */,
	7       /* 14 */,
	7       /* 15 */,
	8       /* 16 */,
	8       /* 17 */,
	9       /* 18/00-18/09 */,
	10      /* 18/10-18/19 */,
	12      /* 18/20-18/29 */,
	15      /* 18/30-18/39 */,
	20      /* 18/40-18/49 */,
	25      /* 18/50-18/59 */,
	30      /* 18/60-18/69 */,
	35      /* 18/70-18/79 */,
	40      /* 18/80-18/89 */,
	45      /* 18/90-18/99 */,
	50      /* 18/100-18/109 */,
	55      /* 18/110-18/119 */,
	60      /* 18/120-18/129 */,
	65      /* 18/130-18/139 */,
	70      /* 18/140-18/149 */,
	75      /* 18/150-18/159 */,
	80      /* 18/160-18/169 */,
	85      /* 18/170-18/179 */,
	90      /* 18/180-18/189 */,
	95      /* 18/190-18/199 */,
	100     /* 18/200-18/209 */,
	100     /* 18/210-18/219 */,
	100     /* 18/220+ */
};


/*
 * Stat Table (STR) -- help index into the "blow" table
 */
byte adj_str_blow[] =
{
	3       /* 3 */,
	4       /* 4 */,
	5       /* 5 */,
	6       /* 6 */,
	7       /* 7 */,
	8       /* 8 */,
	9       /* 9 */,
	10      /* 10 */,
	11      /* 11 */,
	12      /* 12 */,
	13      /* 13 */,
	14      /* 14 */,
	15      /* 15 */,
	16      /* 16 */,
	17      /* 17 */,
	20 /* 18/00-18/09 */,
	30 /* 18/10-18/19 */,
	40 /* 18/20-18/29 */,
	50 /* 18/30-18/39 */,
	60 /* 18/40-18/49 */,
	70 /* 18/50-18/59 */,
	80 /* 18/60-18/69 */,
	90 /* 18/70-18/79 */,
	100 /* 18/80-18/89 */,
	110 /* 18/90-18/99 */,
	120 /* 18/100-18/109 */,
	130 /* 18/110-18/119 */,
	140 /* 18/120-18/129 */,
	150 /* 18/130-18/139 */,
	160 /* 18/140-18/149 */,
	170 /* 18/150-18/159 */,
	180 /* 18/160-18/169 */,
	190 /* 18/170-18/179 */,
	200 /* 18/180-18/189 */,
	210 /* 18/190-18/199 */,
	220 /* 18/200-18/209 */,
	230 /* 18/210-18/219 */,
	240 /* 18/220+ */
};


/*
 * Stat Table (DEX) -- index into the "blow" table
 */
byte adj_dex_blow[] =
{
	0       /* 3 */,
	0       /* 4 */,
	0       /* 5 */,
	0       /* 6 */,
	0       /* 7 */,
	0       /* 8 */,
	0       /* 9 */,
	1       /* 10 */,
	1       /* 11 */,
	1       /* 12 */,
	1       /* 13 */,
	1       /* 14 */,
	1       /* 15 */,
	1       /* 16 */,
	1       /* 17 */,
	1       /* 18/00-18/09 */,
	2       /* 18/10-18/19 */,
	2       /* 18/20-18/29 */,
	2       /* 18/30-18/39 */,
	2       /* 18/40-18/49 */,
	3       /* 18/50-18/59 */,
	3       /* 18/60-18/69 */,
	4       /* 18/70-18/79 */,
	4       /* 18/80-18/89 */,
	5       /* 18/90-18/99 */,
	6       /* 18/100-18/109 */,
	7       /* 18/110-18/119 */,
	8       /* 18/120-18/129 */,
	9       /* 18/130-18/139 */,
	10      /* 18/140-18/149 */,
	11      /* 18/150-18/159 */,
	11	/* 18/160-18/169 */,
	11	/* 18/170-18/179 */,
	11	/* 18/180-18/189 */,
	11	/* 18/190-18/199 */,
	11	/* 18/200-18/209 */,
	11	/* 18/210-18/219 */,
	11	/* 18/220+ */
};


/*
 * Stat Table (DEX) -- chance of avoiding "theft" and "falling"
 */
byte adj_dex_safe[] =
{
	0       /* 3 */,
	1       /* 4 */,
	2       /* 5 */,
	3       /* 6 */,
	4       /* 7 */,
	5       /* 8 */,
	5       /* 9 */,
	6       /* 10 */,
	6       /* 11 */,
	7       /* 12 */,
	7       /* 13 */,
	8       /* 14 */,
	8       /* 15 */,
	9       /* 16 */,
	9       /* 17 */,
	10      /* 18/00-18/09 */,
	10      /* 18/10-18/19 */,
	15      /* 18/20-18/29 */,
	15      /* 18/30-18/39 */,
	20      /* 18/40-18/49 */,
	25      /* 18/50-18/59 */,
	30      /* 18/60-18/69 */,
	35      /* 18/70-18/79 */,
	40      /* 18/80-18/89 */,
	45      /* 18/90-18/99 */,
	50      /* 18/100-18/109 */,
	60      /* 18/110-18/119 */,
	70      /* 18/120-18/129 */,
	80      /* 18/130-18/139 */,
	90      /* 18/140-18/149 */,
	100     /* 18/150-18/159 */,
	100     /* 18/160-18/169 */,
	100     /* 18/170-18/179 */,
	100     /* 18/180-18/189 */,
	100     /* 18/190-18/199 */,
	100     /* 18/200-18/209 */,
	100     /* 18/210-18/219 */,
	100     /* 18/220+ */
};


/*
 * Stat Table (CON) -- base regeneration rate
 */
byte adj_con_fix[] =
{
	0       /* 3 */,
	0       /* 4 */,
	0       /* 5 */,
	0       /* 6 */,
	0       /* 7 */,
	0       /* 8 */,
	0       /* 9 */,
	0       /* 10 */,
	0       /* 11 */,
	0       /* 12 */,
	0       /* 13 */,
	1       /* 14 */,
	1       /* 15 */,
	1       /* 16 */,
	1       /* 17 */,
	2       /* 18/00-18/09 */,
	2       /* 18/10-18/19 */,
	2       /* 18/20-18/29 */,
	2       /* 18/30-18/39 */,
	2       /* 18/40-18/49 */,
	3       /* 18/50-18/59 */,
	3       /* 18/60-18/69 */,
	3       /* 18/70-18/79 */,
	3       /* 18/80-18/89 */,
	3       /* 18/90-18/99 */,
	4       /* 18/100-18/109 */,
	4       /* 18/110-18/119 */,
	5       /* 18/120-18/129 */,
	6       /* 18/130-18/139 */,
	6       /* 18/140-18/149 */,
	7       /* 18/150-18/159 */,
	7       /* 18/160-18/169 */,
	8       /* 18/170-18/179 */,
	8       /* 18/180-18/189 */,
	8       /* 18/190-18/199 */,
	9       /* 18/200-18/209 */,
	9       /* 18/210-18/219 */,
	9       /* 18/220+ */
};


/*
 * Stat Table (CON) -- extra half-hitpoints per level (plus 128).
 * Because monsters don't breath as powerfully now, I have reduced the
 * effect of this stat. -LM-
 */
byte adj_con_mhp[] =
{
	128 + -5	/* 3 */,
	128 + -3	/* 4 */,
	128 + -2	/* 5 */,
	128 + -1	/* 6 */,
	128 + 0	/* 7 */,
	128 + 0	/* 8 */,
	128 + 0	/* 9 */,
	128 + 0	/* 10 */,
	128 + 0	/* 11 */,
	128 + 0	/* 12 */,
	128 + 0	/* 13 */,
	128 + 0	/* 14 */,
	128 + 1	/* 15 */,
	128 + 1	/* 16 */,
	128 + 2	/* 17 */,
	128 + 3	/* 18/00-18/09 */,
	128 + 4	/* 18/10-18/19 */,
	128 + 4	/* 18/20-18/29 */,
	128 + 4	/* 18/30-18/39 */,
	128 + 4	/* 18/40-18/49 */,
	128 + 5	/* 18/50-18/59 */,
	128 + 5	/* 18/60-18/69 */,
	128 + 6	/* 18/70-18/79 */,
	128 + 6	/* 18/80-18/89 */,
	128 + 7	/* 18/90-18/99 */,
	128 + 8	/* 18/100-18/109 */,
	128 + 9	/* 18/110-18/119 */,
	128 + 9	/* 18/120-18/129 */,
	128 + 10	/* 18/130-18/139 */,
	128 + 11	/* 18/140-18/149 */,
	128 + 12	/* 18/150-18/159 */,
	128 + 12	/* 18/160-18/169 */,
	128 + 13	/* 18/170-18/179 */,
	128 + 14	/* 18/180-18/189 */,
	128 + 15	/* 18/190-18/199 */,
	128 + 17	/* 18/200-18/209 */,
	128 + 18	/* 18/210-18/219 */,
	128 + 20	/* 18/220+ */
};


/*
 * This table is used to help calculate the number of blows the player can
 * make in a single round of attacks (one player turn) with a normal weapon.
 *
 * This number ranges from a single blow/round for weak players to up to six
 * blows/round for powerful warriors.
 *
 * Note that certain artifacts and ego-items give "bonus" blows/round.
 *
 * First, from the player class, we extract some values:
 *
 *    Warrior --> num = 6; mul = 5; div = MAX(30, weapon_weight);
 *    Mage    --> num = 4; mul = 2; div = MAX(40, weapon_weight);
 *    Priest  --> num = 5; mul = 3; div = MAX(35, weapon_weight);
 *    Rogue   --> num = 5; mul = 3; div = MAX(30, weapon_weight);
 *    Ranger  --> num = 5; mul = 4; div = MAX(35, weapon_weight);
 *    Paladin --> num = 5; mul = 4; div = MAX(30, weapon_weight);
 *
 * To get "P", we look up the relevant "adj_str_blow[]" (see above),
 * multiply it by "mul", and then divide it by "div", rounding down.
 *
 * To get "D", we look up the relevant "adj_dex_blow[]" (see above),
 * note especially column 6 (DEX 18/101) and 11 (DEX 18/150).
 *
 * The player gets "blows_table[P][D]" blows/round, as shown below,
 * up to a maximum of "num" blows/round, plus any "bonus" blows/round.
 */
byte blows_table[12][12] =
{
	/* P/D */
	/* 0,   1,   2,   3,   4,   5,   6,   7,   8,   9,  10,  11+ */

	/* 0  */
	{  2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2},

	/* 1  */
	{  2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   3,   3},

	/* 2  */
	{  2,   2,   2,   2,   2,   2,   2,   2,   3,   3,   3,   3},

	/* 3  */
	{  2,   2,   2,   2,   2,   2,   2,   3,   3,   3,   3,   3},

	/* 4  */
	{  2,   2,   2,   2,   2,   3,   3,   3,   3,   3,   3,   4},

	/* 5  */
	{  2,   2,   2,   2,   3,   3,   3,   3,   3,   4,   4,   4},

	/* 6  */
	{  2,   2,   2,   2,   3,   3,   3,   3,   4,   4,   4,   4},

	/* 7  */
	{  2,   2,   2,   3,   3,   3,   3,   4,   4,   4,   4,   4},

	/* 8  */
	{  2,   2,   3,   3,   3,   3,   4,   4,   4,   4,   4,   4},

	/* 9  */
	{  2,   2,   3,   3,   3,   4,   4,   4,   4,   4,   4,   5},

	/* 10 */
	{  2,   3,   3,   3,   3,   4,   4,   4,   4,   4,   5,   5},

	/* 11+ */
	{  2,   3,   3,   3,   4,   4,   4,   4,   4,   4,   5,   5}
};


s16b arena_monsters[MAX_ARENA_MONS] =
{
	 30,	 43,	102,	118,	126,	149,	173,
	183,	188,	191,	216,	230,	238,	244,
	255,	262,	293,	297,	321,	349,	372,
	401,	415,	454,	464,	485,	538,	631,
	641
};



/*
 * Store owners (exactly four "possible" owners per store, chosen randomly)
 * { name, purse, max greed, min greed, haggle_per, tolerance, race, unused }
 *
 * Lifted extra shopkeepers from CthAngband (don't you just love open source
 * development? ;-)). Since this gave less than 32 unique names for some
 * shops, those have their first x names copied to reach 32.
 *
 * For the weapon and armour shops, several owners have a limit of 5k.
 *
 * I want to do 50k owners, but the purse is currently s16b. Perhaps
 * we should just store 1/10th of the purse?
 */
owner_type owners[MAX_STORES][MAX_OWNERS] =
{
	{
		/* General store - 32 unique names */
#ifdef JP
                { "եɥ꡼ʥӥ",       200,    170,  108,   5,  15,  RACE_HOBBIT},
		{ "¼ԥ饹ȥ",       200,    175,  108,   4,  12,  RACE_HUMAN},
		{ "ؤ㤤륿",             300,    170,  107,   5,  15,  RACE_GNOME},
                { "ϥ󥵥ʥ饤=",      300,    165,  107,   6,  18,  RACE_ELF},
#else
		{ "Bilbo the Friendly",         200,    170, 108,  5, 15, RACE_HOBBIT},
		{ "Raistlin the Chicken",       200,    175, 108,  4, 12, RACE_HUMAN},
		{ "Sultan the Midget",          300,    170, 107,  5, 15, RACE_GNOME},
		{ "Lyar-el the Comely",         300,    165, 107,  6, 18, RACE_ELF},
#endif

#ifdef JP
{ "ڤʥեޥ",         250,    170, 108,  5, 15, RACE_HOBBIT},
#else
		{ "Falilmawen the Friendly",         250,    170, 108,  5, 15, RACE_HOBBIT},
#endif

#ifdef JP
{ "¼ԥ",       500,    175, 108,  4, 12, RACE_HUMAN},
#else
		{ "Voirin the Cowardly",       500,    175, 108,  4, 12, RACE_HUMAN},
#endif

#ifdef JP
{ "ӤΥ饷ʥ",          750,    170, 107,  5, 15, RACE_BEASTMAN},
#else
		{ "Erashnak the Midget",          750,    170, 107,  5, 15, RACE_BEASTMAN},
#endif

#ifdef JP
{ "ϥ󥵥ʥå",        1000,    165, 107,  6, 18, RACE_HALF_TITAN},
#else
		{ "Grug the Comely",        1000,    165, 107,  6, 18, RACE_HALF_TITAN},
#endif

#ifdef JP
{ "ʥեӥ",         250,    170, 108,  5, 15, RACE_HUMAN},
#else
		{ "Forovir the Cheap",         250,    170, 108,  5, 15, RACE_HUMAN},
#endif

#ifdef JP
{ "ϼΥꥹ",       500,    175, 108,  4, 12, RACE_HUMAN},
#else
		{ "Ellis the Fool",       500,    175, 108,  4, 12, RACE_HUMAN},
#endif

#ifdef JP
{ "ʢڥΥեС",          750,    170, 107,  5, 15, RACE_VAMPIRE},
#else
		{ "Filbert the Hungry",          750,    170, 107,  5, 15, RACE_VAMPIRE},
#endif

#ifdef JP
{ "ʡ롦",        1000,    165, 107,  6, 18, RACE_MIND_FLAYER},
#else
		{ "Fthnargl Psathiggua",        1000,    165, 107,  6, 18, RACE_MIND_FLAYER},
#endif

#ifdef JP
{ "Ĺभ",         250,    170, 108,  5, 15, RACE_SPECTRE},
#else
		{ "Eloise Long-Dead",         250,    170, 108,  5, 15, RACE_SPECTRE},
#endif

#ifdef JP
{ "ΥޤΥեǥ",       500,    175, 108,  4, 12, RACE_ZOMBIE},
#else
		{ "Fundi the Slow",       500,    175, 108,  4, 12, RACE_ZOMBIE},
#endif

#ifdef JP
{ "󥵥",          750,    170, 107,  5, 15, RACE_SKELETON},
#else
		{ "Granthus",          750,    170, 107,  5, 15, RACE_SKELETON},
#endif

#ifdef JP
{ "ǫʥå",        1000,    165, 107,  6, 18, RACE_VAMPIRE},
#else
		{ "Lorax the Suave",        1000,    165, 107,  6, 18, RACE_VAMPIRE},
#endif

#ifdef JP
{ "֥å",         250,    170, 108,  5, 15, RACE_HALF_ORC},
#else
		{ "Butch",         250,    170, 108,  5, 15, RACE_HALF_ORC},
#endif

#ifdef JP
{ "٥쥹",       500,    175, 108,  4, 12, RACE_HIGH_ELF},
#else
		{ "Elbereth the Beautiful",       500,    175, 108,  4, 12, RACE_HIGH_ELF},
#endif

#ifdef JP
{ "쥹",          750,    170, 107,  5, 15, RACE_GNOME},
#else
		{ "Sarleth the Sneaky",          750,    170, 107,  5, 15, RACE_GNOME},
#endif

#ifdef JP
{ "ʡå",        1000,    165, 107,  6, 18, RACE_DWARF},
#else
		{ "Narlock",        1000,    165, 107,  6, 18, RACE_DWARF},
#endif

#ifdef JP
{ "ӤΥإͥå",         250,    170, 108,  5, 15, RACE_GNOME},
#else
		{ "Haneka the Small",         250,    170, 108,  5, 15, RACE_GNOME},
#endif

#ifdef JP
{ "",       500,    175, 108,  4, 12, RACE_HALF_GIANT},
#else
		{ "Loirin the Mad",       500,    175, 108,  4, 12, RACE_HALF_GIANT},
#endif

#ifdef JP
{ "©Υ",          750,    170, 107,  5, 15, RACE_DRACONIAN},
#else
		{ "Wuto Poisonbreath",          750,    170, 107,  5, 15, RACE_DRACONIAN},
#endif

#ifdef JP
{ "Ǥ֤ä祢饡",        1000,    165, 107,  6, 18, RACE_DRACONIAN},
#else
		{ "Araaka the Rotund",        1000,    165, 107,  6, 18, RACE_DRACONIAN},
#endif

#ifdef JP
{ "ǽʥס",         250,    170, 108,  5, 15, RACE_BEASTMAN},
#else
		{ "Poogor the Dumb",         250,    170, 108,  5, 15, RACE_BEASTMAN},
#endif

#ifdef JP
{ "եեꥢ",       500,    175, 108,  4, 12, RACE_ELF},
#else
		{ "Felorfiliand",       500,    175, 108,  4, 12, RACE_ELF},
#endif

#ifdef JP
{ "ǯޥ",          750,    170, 107,  5, 15, RACE_GNOME},
#else
		{ "Maroka the Aged",          750,    170, 107,  5, 15, RACE_GNOME},
#endif

#ifdef JP
{ " ͦʥ",        1000,    165, 107,  6, 18, RACE_HALF_GIANT},
#else
		{ "Sasin the Bold",        1000,    165, 107,  6, 18, RACE_HALF_GIANT},
#endif

#ifdef JP
{ "ļ˼ԥӥޡ",         250,    170, 108,  5, 15, RACE_HUMAN},
#else
		{ "Abiemar the Peasant",         250,    170, 108,  5, 15, RACE_HUMAN},
#endif

#ifdef JP
{ "˳ʥϡ",       500,    175, 108,  4, 12, RACE_HALF_ORC},
#else
		{ "Hurk the Poor",       500,    175, 108,  4, 12, RACE_HALF_ORC},
#endif

#ifdef JP
{ "ߤʥ",          750,    170, 107,  5, 15, RACE_ZOMBIE},
#else
		{ "Soalin the Wretched",          750,    170, 107,  5, 15, RACE_ZOMBIE},
#endif

#ifdef JP
{ "Ǥʥ",        1000,    165, 107,  6, 18, RACE_ELF},
#else
		{ "Merulla the Humble",        1000,    165, 107,  6, 18, RACE_ELF},
#endif

	},
	{
		/* Armoury - 28 unique names */
#ifdef JP
                { "=",      5000,   210,  115,   5,   7,  RACE_HALF_ORC},
                { "Ǽԥ=",  10000,  190,  111,   4,   9,  RACE_HUMAN},
                { "ԥǥ",                 25000,  200,  112,   4,  10,  RACE_AMBERITE},
		{ "결Υ",   30000,  200,  112,   4,   5,  RACE_DWARF},
#else
		{ "Kon-Dar the Ugly",           5000,   210, 115,  5,  7, RACE_HALF_ORC},
		{ "Darg-Low the Grim",          10000,  190, 111,  4,  9, RACE_HUMAN},
		{ "Decado the Handsome",            25000,  200, 112,  4, 10, RACE_AMBERITE},
		{ "Wieland the Smith",          30000,  200, 112,  4,  5, RACE_DWARF},
#endif

#ifdef JP
{ "=",           10000,   210, 115,  5,  7, RACE_HALF_ORC},
#else
		{ "Kon-Dar the Ugly",           10000,   210, 115,  5,  7, RACE_HALF_ORC},
#endif

#ifdef JP
{ "Ǽԥ=",          15000,  190, 111,  4,  9, RACE_HUMAN},
#else
		{ "Darg-Low the Grim",          15000,  190, 111,  4,  9, RACE_HUMAN},
#endif

#ifdef JP
{ "ϥ󥵥ʥǥ",            25000,  200, 112,  4, 10, RACE_AMBERITE},
#else
		{ "Decado the Handsome",            25000,  200, 112,  4, 10, RACE_AMBERITE},
#endif

#ifdef JP
        { "ɥ饴󥹥",          30000,  200, 112,  4,  5, RACE_ELF},
#else
		{ "Elo Dragonscale",          30000,  200, 112,  4,  5, RACE_ELF},
#endif

#ifdef JP
{ "ǥꥫȥ",           10000,   210, 115,  5,  7, RACE_SPRITE},
#else
		{ "Delicatus",           10000,   210, 115,  5,  7, RACE_SPRITE},
#endif

#ifdef JP
{ "ʥ롼",          15000,  190, 111,  4,  9, RACE_HALF_GIANT},
#else
		{ "Gruce the Huge",          15000,  190, 111,  4,  9, RACE_HALF_GIANT},
#endif

#ifdef JP
{ "˥ॹ",            25000,  200, 112,  4, 10, RACE_GOLEM},
#else
		{ "Animus",            25000,  200, 112,  4, 10, RACE_GOLEM},
#endif

#ifdef JP
        { "ޥ",          30000,  200, 112,  4,  5, RACE_HALF_TITAN},
#else
		{ "Malvus",          30000,  200, 112,  4,  5, RACE_HALF_TITAN},
#endif

#ifdef JP
{ "饯",           10000,   210, 115,  5,  7, RACE_ZOMBIE},
#else
		{ "Selaxis",           10000,   210, 115,  5,  7, RACE_ZOMBIE},
#endif

#ifdef JP
{ "ǥ",          5000,  190, 111,  4,  9, RACE_SPECTRE},
#else
		{ "Deathchill",          5000,  190, 111,  4,  9, RACE_SPECTRE},
#endif

#ifdef JP
{ "ʥɥꥪ",            25000,  200, 112,  4, 10, RACE_SPECTRE},
#else
		{ "Drios the Faint",            25000,  200, 112,  4, 10, RACE_SPECTRE},
#endif

#ifdef JP
        { "䤿Хå",          30000,  200, 112,  4,  5, RACE_VAMPIRE},
#else
		{ "Bathric the Cold",          30000,  200, 112,  4,  5, RACE_VAMPIRE},
#endif

#ifdef JP
{ "󥸥",           10000,   210, 115,  5,  7, RACE_HALF_TROLL},
#else
		{ "Vengella the Cruel",           10000,   210, 115,  5,  7, RACE_HALF_TROLL},
#endif

#ifdef JP
{ "ԥ",          15000,  190, 111,  4,  9, RACE_HUMAN},
#else
		{ "Wyrana the Mighty",          15000,  190, 111,  4,  9, RACE_HUMAN},
#endif

#ifdef JP
{ "襸",            25000,  200, 112,  4, 10, RACE_DWARF},
#else
		{ "Yojo II",            25000,  200, 112,  4, 10, RACE_DWARF},
#endif

#ifdef JP
        { "ͥʥ顼",          30000,  200, 112,  4,  5, RACE_AMBERITE},
#else
		{ "Ranalar the Sweet",          30000,  200, 112,  4,  5, RACE_AMBERITE},
#endif

#ifdef JP
{ "ԾΥۥХ",           5000,   210, 115,  5,  7, RACE_HALF_ORC},
#else
		{ "Horbag the Unclean",           5000,   210, 115,  5,  7, RACE_HALF_ORC},
#endif

#ifdef JP
{ "ƥѥΥ",          15000,  190, 111,  4,  9, RACE_DARK_ELF},
#else
		{ "Elelen the Telepath",          15000,  190, 111,  4,  9, RACE_DARK_ELF},
#endif

#ifdef JP
{ "ɥꥢ",            25000,  200, 112,  4, 10, RACE_SPRITE},
#else
		{ "Isedrelias",            25000,  200, 112,  4, 10, RACE_SPRITE},
#endif

#ifdef JP
        { "ܥʡ",          5000,  200, 112,  4,  5, RACE_CYCLOPS},
#else
		{ "Vegnar One-eye",          5000,  200, 112,  4,  5, RACE_CYCLOPS},
#endif

#ifdef JP
{ "٤Υǥå",           10000,   210, 115,  5,  7, RACE_BEASTMAN},
#else
		{ "Rodish the Chaotic",           10000,   210, 115,  5,  7, RACE_BEASTMAN},
#endif

#ifdef JP
{ "إ",          15000,  190, 111,  4,  9, RACE_NIBELUNG},
#else
		{ "Hesin Swordmaster",          15000,  190, 111,  4,  9, RACE_NIBELUNG},
#endif

#ifdef JP
{ "벰Υ٥ꥹ",           10000,  200, 112,  4, 10, RACE_DARK_ELF},
#else
		{ "Elvererith the Cheat",           10000,  200, 112,  4, 10, RACE_DARK_ELF},
#endif

#ifdef JP
        { "פΥ",          30000,  200, 112,  4,  5, RACE_IMP},
#else
		{ "Zzathath the Imp",          30000,  200, 112,  4,  5, RACE_IMP},
#endif

#ifdef JP
{ "=",           5000,   210, 115,  5,  7, RACE_HALF_ORC},
#else
		{ "Kon-Dar the Ugly",           5000,   210, 115,  5,  7, RACE_HALF_ORC},
#endif

#ifdef JP
{ "Ǽԥ=",          10000,  190, 111,  4,  9, RACE_HUMAN},
#else
		{ "Darg-Low the Grim",          10000,  190, 111,  4,  9, RACE_HUMAN},
#endif

#ifdef JP
{ "ϥ󥵥ʥǥ",            25000,  200, 112,  4, 10, RACE_AMBERITE},
#else
		{ "Decado the Handsome",            25000,  200, 112,  4, 10, RACE_AMBERITE},
#endif

#ifdef JP
{ "결Υ",          30000,  200, 112,  4,  5, RACE_DWARF},
#else
		{ "Wieland the Smith",          30000,  200, 112,  4,  5, RACE_DWARF},
#endif

	},
	{
		/* Weapon Smith - 28 unique names */
#ifdef JP
                { "Ǧʤ륢Υ",        5000,   210,  115,   6,   6,  RACE_HALF_TROLL},
                { "ûΥ", 10000,  185,  110,   5,   9,  RACE_HALF_ELF},
                { "åޥΥǥ", 25000,  190,  115,   5,   7,  RACE_HOBBIT},
                { "εΥ饤", 30000,  195,  112,   4,   8,  RACE_DWARF},
#else
		{ "Arnold the Beastly",      5000,   210, 115,  6,  6, RACE_BARBARIAN},
		{ "Arndal Beast-Slayer",        10000,  185, 110,  5,  9, RACE_HALF_ELF},
		{ "Eddie Beast-Master",         25000,  190, 115,  5,  7, RACE_HALF_ORC},
		{ "Oglign Dragon-Slayer",       30000,  195, 112,  4,  8, RACE_DWARF},
#endif

#ifdef JP
{ "ԥɥ塼",      10000,   210, 115,  6,  6, RACE_HUMAN},
#else
		{ "Drew the Skilled",      10000,   210, 115,  6,  6, RACE_HUMAN},
#endif

#ifdef JP
{"ζλҥå",        15000,  185, 110,  5,  9, RACE_DRACONIAN},
#else
		{ "Orrax Dragonson",        15000,  185, 110,  5,  9, RACE_DRACONIAN},
#endif

#ifdef JP
{ "µΥ󥹥å",         25000,  190, 115,  5,  7, RACE_BEASTMAN},
#else
		{ "Anthrax Disease-Carrier",         25000,  190, 115,  5,  7, RACE_BEASTMAN},
#endif

#ifdef JP
{ "ԥ륳",       30000,  195, 112,  4,  8, RACE_DWARF},
#else
		{ "Arkhoth the Stout",       30000,  195, 112,  4,  8, RACE_DWARF},
#endif

#ifdef JP
{ "ԤΥꥢ",      5000,   210, 115,  6,  6, RACE_ZOMBIE},
#else
		{ "Sarlyas the Rotten",      5000,   210, 115,  6,  6, RACE_ZOMBIE},
#endif

#ifdef JP
{"Υȥ",        15000,  185, 110,  5,  9, RACE_SKELETON},
#else
		{ "Tuethic Bare-Bones",        15000,  185, 110,  5,  9, RACE_SKELETON},
#endif

#ifdef JP
{ "ӥꥪ",         25000,  190, 115,  5,  7, RACE_BEASTMAN},
#else
		{ "Bilious",         25000,  190, 115,  5,  7, RACE_BEASTMAN},
#endif

#ifdef JP
{ "ե",       30000,  195, 112,  4,  8, RACE_ZOMBIE},
#else
		{ "Fasgul",       30000,  195, 112,  4,  8, RACE_ZOMBIE},
#endif

#ifdef JP
{ "ѥǥΥեꥹ",      10000,   210, 115,  6,  6, RACE_BARBARIAN},
#else
		{ "Ellefris the Paladin",      10000,   210, 115,  6,  6, RACE_BARBARIAN},
#endif

#ifdef JP
{"'ȥ'",        15000,  185, 110,  5,  9, RACE_KLACKON},
#else
		{ "K'trrik'k",        15000,  185, 110,  5,  9, RACE_KLACKON},
#endif

#ifdef JP
{ "ͧɥ",         25000,  190, 115,  5,  7, RACE_DARK_ELF},
#else
		{ "Drocus Spiderfriend",         25000,  190, 115,  5,  7, RACE_DARK_ELF},
#endif

#ifdef JP
{ "ͻΥե󥰥",       30000,  195, 112,  4,  8, RACE_DWARF},
#else
		{ "Fungus Giant-Slayer",       30000,  195, 112,  4,  8, RACE_DWARF},
#endif

#ifdef JP
{ "ǥ",      10000,   210, 115,  6,  6, RACE_ELF},
#else
		{ "Delantha",      10000,   210, 115,  6,  6, RACE_ELF},
#endif

#ifdef JP
{"󥸥㡼Υӥ",        15000,  185, 110,  5,  9, RACE_HALF_ELF},
#else
		{ "Solvistani the Ranger",        15000,  185, 110,  5,  9, RACE_HALF_ELF},
#endif

#ifdef JP
{ "ΥޤΥ",         25000,  190, 115,  5,  7, RACE_GOLEM},
#else
		{ "Xoril the Slow",         25000,  190, 115,  5,  7, RACE_GOLEM},
#endif

#ifdef JP
{ "󡦥եå",       20000,  195, 112,  4,  8, RACE_HALF_ELF},
#else
		{ "Aeon Flux",       20000,  195, 112,  4,  8, RACE_HALF_ELF},
#endif

#ifdef JP
{ "ԥʥɥå",      10000,   210, 115,  6,  6, RACE_HOBBIT},
#else
		{ "Nadoc the Strong",      10000,   210, 115,  6,  6, RACE_HOBBIT},
#endif

#ifdef JP
{"⥰",        15000,  185, 110,  5,  9, RACE_KOBOLD},
#else
		{ "Eramog the Weak",        15000,  185, 110,  5,  9, RACE_KOBOLD},
#endif

#ifdef JP
{ "ʥꥹ",         25000,  190, 115,  5,  7, RACE_VAMPIRE},
#else
		{ "Eowilith the Fair",         25000,  190, 115,  5,  7, RACE_VAMPIRE},
#endif

#ifdef JP
{ "ХΥҥ奤⥰",       30000,  195, 112,  4,  8, RACE_HALF_ORC},
#else
		{ "Huimog Balrog-Slayer",       30000,  195, 112,  4,  8, RACE_HALF_ORC},
#endif

#ifdef JP
{ "ԡ",      5000,   210, 115,  6,  6, RACE_HUMAN},
#else
		{ "Peadus the Cruel",      5000,   210, 115,  6,  6, RACE_HUMAN},
#endif

#ifdef JP
{ "⥰ 쥤䡼",        15000,  185, 110,  5,  9, RACE_HALF_OGRE},
#else
		{ "Vamog Slayer",        15000,  185, 110,  5,  9, RACE_HALF_OGRE},
#endif

#ifdef JP
{ "աʥ",         25000,  190, 115,  5,  7, RACE_BEASTMAN},
#else
		{ "Hooshnak the Vicious",         25000,  190, 115,  5,  7, RACE_BEASTMAN},
#endif

#ifdef JP
{ "ƮХ",       30000,  195, 112,  4,  8, RACE_BARBARIAN},
#else
		{ "Balenn War-Dancer",       30000,  195, 112,  4,  8, RACE_BARBARIAN},
#endif

#ifdef JP
{ " Ǧʤ륢Υ",      5000,   210, 115,  6,  6, RACE_BARBARIAN},
#else
		{ "Arnold the Beastly",      5000,   210, 115,  6,  6, RACE_BARBARIAN},
#endif

#ifdef JP
{ "ûΥ",        10000,  185, 110,  5,  9, RACE_HALF_ELF},
#else
		{ "Arndal Beast-Slayer",        10000,  185, 110,  5,  9, RACE_HALF_ELF},
#endif

#ifdef JP
{ "ӡȥޥǥ",         25000,  190, 115,  5,  7, RACE_HALF_ORC},
#else
		{ "Eddie Beast-Master",         25000,  190, 115,  5,  7, RACE_HALF_ORC},
#endif

#ifdef JP
{ "εΥ饤",       30000,  195, 112,  4,  8, RACE_DWARF},
#else
		{ "Oglign Dragon-Slayer",       30000,  195, 112,  4,  8, RACE_DWARF},
#endif

	},
	{
		/* Temple - 22 unique names */
#ifdef JP
                { "Ǥʥ롼ɥ",         5000,   175,  109,   6,  15,  RACE_HUMAN},
                { "ѥǥΥʡ",       10000,  185,  110,   5,  23,  RACE_HUMAN},
                { "Ф줷ȥ",                     25000,  180,  107,   6,  20,  RACE_ELF},
                { "ʤ륵饹ȥ",                     30000,  185,  109,   5,  15,  RACE_DWARF},
#else
		{ "Ludwig the Humble",          5000,   175, 109,  6, 15, RACE_DWARF},
		{ "Gunnar the Paladin",         10000,  185, 110,  5, 23, RACE_HALF_TROLL},
		{ "Torin the Chosen",           25000,  180, 107,  6, 20, RACE_HIGH_ELF},
		{ "Sarastro the Wise",          30000,  185, 109,  5, 15, RACE_HUMAN},
#endif

#ifdef JP
{ "ѡ붪",           25000,  180, 107,  6, 20, RACE_HIGH_ELF},
#else
		{ "Sir Parsival the Pure",           25000,  180, 107,  6, 20, RACE_HIGH_ELF},
#endif

#ifdef JP
{ "ʤ륢ʥ",          30000,  185, 109,  5, 15, RACE_HUMAN},
#else
		{ "Asenath the Holy",          30000,  185, 109,  5, 15, RACE_HUMAN},
#endif

#ifdef JP
{ "ޥåΥ",         10000,   175, 109,  6, 15, RACE_HUMAN},
#else
		{ "McKinnon",         10000,   175, 109,  6, 15, RACE_HUMAN},
#endif

#ifdef JP
{ "ؿ",         15000,  185, 110,  5, 23, RACE_HIGH_ELF},
#else
		{ "Mistress Chastity",         15000,  185, 110,  5, 23, RACE_HIGH_ELF},
#endif

#ifdef JP
{ "ɥ륤ɤΥϥ˥å",           25000,  180, 107,  6, 20, RACE_HOBBIT},
#else
		{ "Hashnik the Druid",           25000,  180, 107,  6, 20, RACE_HOBBIT},
#endif

#ifdef JP
{ "եʥ",          30000,  185, 109,  5, 15, RACE_YEEK},
#else
		{ "Finak",          30000,  185, 109,  5, 15, RACE_YEEK},
#endif

#ifdef JP
{ "ꥭå",         10000,   175, 109,  6, 15, RACE_KLACKON},
#else
		{ "Krikkik",         10000,   175, 109,  6, 15, RACE_KLACKON},
#endif

#ifdef JP
{ "Ӥԥ",         15000,  185, 110,  5, 23, RACE_ELF},
#else
		{ "Morival the Wild",         15000,  185, 110,  5, 23, RACE_ELF},
#endif

#ifdef JP
{ "Ťۥå",           25000,  180, 107,  6, 20, RACE_IMP},
#else
		{ "Hoshak the Dark",           25000,  180, 107,  6, 20, RACE_IMP},
#endif

#ifdef JP
{ "ԥ",          30000,  185, 109,  5, 15, RACE_HUMAN},
#else
		{ "Atal the Wise",          30000,  185, 109,  5, 15, RACE_HUMAN},
#endif

#ifdef JP
{ "٥˥å",         10000,   175, 109,  6, 15, RACE_HUMAN},
#else
		{ "Ibenidd the Chaste",         10000,   175, 109,  6, 15, RACE_HUMAN},
#endif

#ifdef JP
{ "ǥ",         15000,  185, 110,  5, 23, RACE_HALF_TROLL},
#else
		{ "Eridish",         15000,  185, 110,  5, 23, RACE_HALF_TROLL},
#endif

#ifdef JP
{ "ѻեɥ",           25000,  180, 107,  6, 20, RACE_HALF_OGRE},
#else
		{ "Vrudush the Shaman",           25000,  180, 107,  6, 20, RACE_HALF_OGRE},
#endif

#ifdef JP
{ "Υϥ",          30000,  185, 109,  5, 15, RACE_BARBARIAN},
#else
		{ "Haob the Berserker",          30000,  185, 109,  5, 15, RACE_BARBARIAN},
#endif

#ifdef JP
{ "㤭ץ롼ǥ",         10000,   175, 109,  6, 15, RACE_HALF_OGRE},
#else
		{ "Proogdish the Youthfull",         10000,   175, 109,  6, 15, RACE_HALF_OGRE},
#endif

#ifdef JP
{ "磻",         15000,  185, 110,  5, 23, RACE_YEEK},
#else
		{ "Lumwise the Mad",         15000,  185, 110,  5, 23, RACE_YEEK},
#endif

#ifdef JP
{ "ͭԥ",           25000,  180, 107,  6, 20, RACE_KOBOLD},
#else
		{ "Muirt the Virtuous",           25000,  180, 107,  6, 20, RACE_KOBOLD},
#endif

#ifdef JP
{ "ɥС",          30000,  185, 109,  5, 15, RACE_SPECTRE},
#else
		{ "Dardobard the Weak",          30000,  185, 109,  5, 15, RACE_SPECTRE},
#endif

#ifdef JP
{ "Ǥʥ롼ɥ",          5000,   175, 109,  6, 15, RACE_DWARF},
#else
		{ "Ludwig the Humble",          5000,   175, 109,  6, 15, RACE_DWARF},
#endif

#ifdef JP
{ "ѥǥΥʡ",         10000,  185, 110,  5, 23, RACE_HALF_TROLL},
#else
		{ "Gunnar the Paladin",         10000,  185, 110,  5, 23, RACE_HALF_TROLL},
#endif

#ifdef JP
{ "Ф줷ȥ",           25000,  180, 107,  6, 20, RACE_HIGH_ELF},
#else
		{ "Torin the Chosen",           25000,  180, 107,  6, 20, RACE_HIGH_ELF},
#endif

#ifdef JP
{ "ʤ륵饹ȥ",          30000,  185, 109,  5, 15, RACE_HUMAN},
#else
		{ "Sarastro the Wise",          30000,  185, 109,  5, 15, RACE_HUMAN},
#endif

#ifdef JP
{ "ѡ붪",           25000,  180, 107,  6, 20, RACE_HIGH_ELF},
#else
		{ "Sir Parsival the Pure",           25000,  180, 107,  6, 20, RACE_HIGH_ELF},
#endif

#ifdef JP
{ "ʤ륢ʥ",          30000,  185, 109,  5, 15, RACE_HUMAN},
#else
		{ "Asenath the Holy",          30000,  185, 109,  5, 15, RACE_HUMAN},
#endif

#ifdef JP
{ "ޥåΥ",         10000,   175, 109,  6, 15, RACE_HUMAN},
#else
		{ "McKinnon",         10000,   175, 109,  6, 15, RACE_HUMAN},
#endif

#ifdef JP
{ "ؿ",         15000,  185, 110,  5, 23, RACE_HIGH_ELF},
#else
		{ "Mistress Chastity",         15000,  185, 110,  5, 23, RACE_HIGH_ELF},
#endif

#ifdef JP
{ "ɥ륤 ϥ˥å",           25000,  180, 107,  6, 20, RACE_HOBBIT},
#else
		{ "Hashnik the Druid",           25000,  180, 107,  6, 20, RACE_HOBBIT},
#endif

#ifdef JP
{ "եʥ",        15000,  200, 110,  7,  8, RACE_BARBARIAN},
#else
		{ "Finak",          30000,  185, 109,  5, 15, RACE_YEEK},
#endif

	},
	{
		/* Alchemist - 26 unique names */
#ifdef JP
                { "ؼԥޥ",             10000,  190,  111,   5,   8,  RACE_HALF_ELF},
                { "Υ",   10000,  190,  110,   6,   8,  RACE_HOBBIT},
                { "ߥߥ",              15000,  200,  116,   6,   9,  RACE_GNOME},
                { "ϼ奸=ե",                   15000,  220,  111,   4,   9,  RACE_ELF},/*FIRST*/
#else
		{ "Mauser the Chemist",         10000,  190, 111,  5,  8, RACE_HALF_ELF},
		{ "Wizzle the Chaotic",         10000,  190, 110,  6,  8, RACE_HOBBIT},
		{ "Midas the Greedy",           15000,  200, 116,  6,  9, RACE_GNOME},
		{ "Ja-Far the Alchemist",       15000,  220, 111,  4,  9, RACE_ELF},
#endif

#ifdef JP
        { "饫",           15000,  200, 116,  6,  9, RACE_KLACKON},
#else
		{ "Kakalrakakal",           15000,  200, 116,  6,  9, RACE_KLACKON},
#endif

#ifdef JP
        { "ϣѻե=",       15000,  220, 111,  4,  9, RACE_ELF},
#else
		{ "Jal-Eth the Alchemist",       15000,  220, 111,  4,  9, RACE_ELF},
#endif

#ifdef JP
{ "ѿեͥ饹",         10000,  190, 111,  5,  8, RACE_DWARF},
#else
		{ "Fanelath the Cautious",         10000,  190, 111,  5,  8, RACE_DWARF},
#endif

#ifdef JP
{ "Υ󥷡",         10000,  190, 110,  6,  8, RACE_HUMAN},
#else
		{ "Runcie the Insane",         10000,  190, 110,  6,  8, RACE_HUMAN},
#endif

#ifdef JP
        { "֥",           15000,  200, 116,  6,  9, RACE_GNOME},
#else
		{ "Grumbleworth",           15000,  200, 116,  6,  9, RACE_GNOME},
#endif

#ifdef JP
        { "եå",       15000,  220, 111,  4,  9, RACE_SPRITE},
#else
		{ "Flitter",       15000,  220, 111,  4,  9, RACE_SPRITE},
#endif

#ifdef JP
{ "륹",         10000,  190, 111,  5,  8, RACE_HUMAN},
#else
		{ "Xarillus",         10000,  190, 111,  5,  8, RACE_HUMAN},
#endif

#ifdef JP
{ "ŤС",         10000,  190, 110,  6,  8, RACE_DWARF},
#else
		{ "Egbert the Old",         10000,  190, 110,  6,  8, RACE_DWARF},
#endif

#ifdef JP
        { "ؤ⤭ɥ",           15000,  200, 116,  6,  9, RACE_HIGH_ELF},
#else
		{ "Valindra the Proud",           15000,  200, 116,  6,  9, RACE_HIGH_ELF},
#endif

#ifdef JP
        { "ϣѻե",       15000,  220, 111,  4,  9, RACE_HUMAN},
#else
		{ "Taen the Alchemist",       15000,  220, 111,  4,  9, RACE_HUMAN},
#endif

#ifdef JP
{ "",         10000,  190, 111,  5,  8, RACE_VAMPIRE},
#else
		{ "Cayd the Sweet",         10000,  190, 111,  5,  8, RACE_VAMPIRE},
#endif

#ifdef JP
{ "Ťեꥢ",         10000,  190, 110,  6,  8, RACE_NIBELUNG},
#else
		{ "Fulir the Dark",         10000,  190, 110,  6,  8, RACE_NIBELUNG},
#endif

#ifdef JP
        { "Ǥʥɥ",           15000,  200, 116,  6,  9, RACE_DWARF},
#else
		{ "Domli the Humble",           15000,  200, 116,  6,  9, RACE_DWARF},
#endif

#ifdef JP
        { "λҥ䥡å",       15000,  220, 111,  4,  9, RACE_IMP},
#else
		{ "Yaarjukka Demonspawn",       15000,  220, 111,  4,  9, RACE_IMP},
#endif

#ifdef JP
{ "եɡ",         10000,  190, 111,  5,  8, RACE_HIGH_ELF},
#else
		{ "Gelaraldor the Herbmaster",         10000,  190, 111,  5,  8, RACE_HIGH_ELF},
#endif

#ifdef JP
{ "ԥ",         10000,  190, 110,  6,  8, RACE_BARBARIAN},
#else
		{ "Olelaldan the Wise",         10000,  190, 110,  6,  8, RACE_BARBARIAN},
#endif

#ifdef JP
        { "ǥ˥ȤΥե",           15000,  200, 116,  6,  9, RACE_IMP},
#else
		{ "Fthoglo the Demonicist",           15000,  200, 116,  6,  9, RACE_IMP},
#endif

#ifdef JP
        { "ϣѻեɥꥢ",       15000,  220, 111,  4,  9, RACE_HALF_ORC},
#else
		{ "Dridash the Alchemist",       15000,  220, 111,  4,  9, RACE_HALF_ORC},
#endif

#ifdef JP
{ "ԥͥꥢ",         10000,  190, 111,  5,  8, RACE_CYCLOPS},
#else
		{ "Nelir the Strong",         10000,  190, 111,  5,  8, RACE_CYCLOPS},
#endif

#ifdef JP
{ "ɸꥰʥ",         10000,  190, 110,  6,  8, RACE_HALF_ORC},
#else
		{ "Lignus the Pungent",         10000,  190, 110,  6,  8, RACE_HALF_ORC},
#endif

#ifdef JP
        { "ƥ",           15000,  200, 116,  6,  9, RACE_HOBBIT},
#else
		{ "Tilba",           15000,  200, 116,  6,  9, RACE_HOBBIT},
#endif

#ifdef JP
        { "ߥɥå",       15000,  220, 111,  4,  9, RACE_HUMAN},
#else
		{ "Myrildric the Wealthy",       15000,  220, 111,  4,  9, RACE_HUMAN},
#endif

#ifdef JP
{ "ʳؼԥޥ",         10000,  190, 111,  5,  8, RACE_HALF_ELF},
#else
		{ "Mauser the Chemist",         10000,  190, 111,  5,  8, RACE_HALF_ELF},
#endif

#ifdef JP
{ "Υ",         10000,  190, 110,  6,  8, RACE_HOBBIT},
#else
		{ "Wizzle the Chaotic",         10000,  190, 110,  6,  8, RACE_HOBBIT},
#endif

#ifdef JP
{ "ߥߥ",           15000,  200, 116,  6,  9, RACE_GNOME},
#else
		{ "Midas the Greedy",           15000,  200, 116,  6,  9, RACE_GNOME},
#endif

#ifdef JP
{ "ϣѻե=ե",       15000,  220, 111,  4,  9, RACE_ELF},
#else
		{ "Ja-Far the Alchemist",       15000,  220, 111,  4,  9, RACE_ELF},
#endif

#ifdef JP
        { "饫",           15000,  200, 116,  6,  9, RACE_KLACKON},
#else
		{ "Kakalrakakal",           15000,  200, 116,  6,  9, RACE_KLACKON},
#endif

#ifdef JP
        { "ϣѻե=",       15000,  220, 111,  4,  9, RACE_ELF},
#else
		{ "Jal-Eth the Alchemist",       15000,  220, 111,  4,  9, RACE_ELF},
#endif

	},
	{
		/* Magic Shop - 23 unique names */
#ifdef JP
                { "顼Υ=ѥ",       20000,  200,  110,   7,   8,  RACE_HALF_ELF},
                { "ʤ֥ӥ",         20000,  215,  113,   6,  10,  RACE_GNOME},
                { "ˡȤ",     30000,  200,  110,   7,  10,  RACE_HUMAN},
		{ "Ȥå",30000,      175,  110,   5,  11,  RACE_HIGH_ELF},
#else
		{ "Lo Pan the Sorcerer",        20000,  200, 110,  7,  8, RACE_HALF_ELF},
		{ "Buggerby the Great",         20000,  215, 113,  6, 10, RACE_GNOME},
		{ "The Wizard of Yendor",       30000,  200, 110,  7, 10, RACE_HUMAN},
		{ "Rjak the Necromancer",       30000,  175, 110,  5, 11, RACE_DARK_ELF},
#endif

#ifdef JP
        { "ѻեɥˡ",        15000,  200, 110,  7,  8, RACE_HALF_ELF},
#else
		{ "Skidney the Sorcerer",        15000,  200, 110,  7,  8, RACE_HALF_ELF},
#endif

#ifdef JP
        { "ѻեꥢ",       30000,  200, 110,  7, 10, RACE_HUMAN},
#else
		{ "Kyria the Illusionist",       30000,  200, 110,  7, 10, RACE_HUMAN},
#endif

#ifdef JP
        { "ѻե˥å",       30000,  175, 110,  5, 11, RACE_DARK_ELF},
#else
		{ "Nikki the Necromancer",       30000,  175, 110,  5, 11, RACE_DARK_ELF},
#endif

#ifdef JP
        { "ȥ",        15000,  200, 110,  7,  8, RACE_SPRITE},
#else
		{ "Solostoran",        15000,  200, 110,  7,  8, RACE_SPRITE},
#endif

#ifdef JP
{ "±",         20000,  215, 113,  6, 10, RACE_MIND_FLAYER},
#else
		{ "Achshe the Tentacled",         20000,  215, 113,  6, 10, RACE_MIND_FLAYER},
#endif

#ifdef JP
        { "²Υ",       30000,  200, 110,  7, 10, RACE_HIGH_ELF},
#else
		{ "Kaza the Noble",       30000,  200, 110,  7, 10, RACE_HIGH_ELF},
#endif

#ifdef JP
        { "Ťե",       30000,  175, 110,  5, 11, RACE_DARK_ELF},
#else
		{ "Fazzil the Dark",       30000,  175, 110,  5, 11, RACE_DARK_ELF},
#endif

#ifdef JP
        { "ʤ륱ɡ",        15000,  200, 110,  7,  8, RACE_DWARF},
#else
		{ "Keldorn the Grand",        15000,  200, 110,  7,  8, RACE_DWARF},
#endif

#ifdef JP
{ "ե󥹥ץ",         20000,  215, 113,  6, 10, RACE_HOBBIT},
#else
		{ "Philanthropus",         20000,  215, 113,  6, 10, RACE_HOBBIT},
#endif

#ifdef JP
        { "Υʡ",       30000,  200, 110,  7, 10, RACE_HUMAN},
#else
		{ "Agnar the Enchantress",       30000,  200, 110,  7, 10, RACE_HUMAN},
#endif

#ifdef JP
        { "ѻեӥꥢ",       30000,  175, 110,  5, 11, RACE_BEASTMAN},
#else
		{ "Buliance the Necromancer",       30000,  175, 110,  5, 11, RACE_BEASTMAN},
#endif

#ifdef JP
        { "ϥᥤΥ饯",        15000,  200, 110,  7,  8, RACE_BEASTMAN},
#else
		{ "Vuirak the High-Mage",        15000,  200, 110,  7,  8, RACE_BEASTMAN},
#endif

#ifdef JP
{ "ηüԥޥǥå",         20000,  215, 113,  6, 10, RACE_BEASTMAN},
#else
		{ "Madish the Smart",         20000,  215, 113,  6, 10, RACE_BEASTMAN},
#endif

#ifdef JP
        { "ե֥ܡ",       30000,  200, 110,  7, 10, RACE_HIGH_ELF},
#else
		{ "Falebrimbor",       30000,  200, 110,  7, 10, RACE_HIGH_ELF},
#endif

#ifdef JP
        { "ե=",       30000,  175, 110,  5, 11, RACE_DARK_ELF},
#else
		{ "Felil-Gand the Subtle",       30000,  175, 110,  5, 11, RACE_DARK_ELF},
#endif

#ifdef JP
        { "ѻե쥴",        15000,  200, 110,  7,  8, RACE_BARBARIAN},
#else
		{ "Thalegord the Shaman",        15000,  200, 110,  7,  8, RACE_BARBARIAN},
#endif

#ifdef JP
{ "ȥȥ",         20000,  215, 113,  6, 10, RACE_MIND_FLAYER},
#else
		{ "Cthoaloth the Mystic",         20000,  215, 113,  6, 10, RACE_MIND_FLAYER},
#endif

#ifdef JP
        { "ѻե٥",       30000,  200, 110,  7, 10, RACE_SKELETON},
#else
		{ "Ibeli the Illusionist",       30000,  200, 110,  7, 10, RACE_SKELETON},
#endif

#ifdef JP
        { "ѻեإȡ",       30000,  175, 110,  5, 11, RACE_YEEK},
#else
		{ "Heto the Necromancer",       30000,  175, 110,  5, 11, RACE_YEEK},
#endif

#ifdef JP
{ "ѻե=ѥ",        20000,  200, 110,  7,  8, RACE_HALF_ELF},
#else
		{ "Lo Pan the Sorcerer",        20000,  200, 110,  7,  8, RACE_HALF_ELF},
#endif

#ifdef JP
{ "ʤ֥ӥ",         20000,  215, 113,  6, 10, RACE_GNOME},
#else
		{ "Buggerby the Great",         20000,  215, 113,  6, 10, RACE_GNOME},
#endif

#ifdef JP
{ "ˡȤ",       30000,  200, 110,  7, 10, RACE_HUMAN},
#else
		{ "The Wizard of Yendor",       30000,  200, 110,  7, 10, RACE_HUMAN},
#endif

#ifdef JP
{ "ѻե㥯",       30000,  175, 110,  5, 11, RACE_DARK_ELF},
#else
		{ "Rjak the Necromancer",       30000,  175, 110,  5, 11, RACE_DARK_ELF},
#endif

#ifdef JP
        { "ѻեɥˡ",        15000,  200, 110,  7,  8, RACE_HALF_ELF},
#else
		{ "Skidney the Sorcerer",        15000,  200, 110,  7,  8, RACE_HALF_ELF},
#endif

#ifdef JP
        { "ѻեꥢ",       30000,  200, 110,  7, 10, RACE_HUMAN},
#else
		{ "Kyria the Illusionist",       30000,  200, 110,  7, 10, RACE_HUMAN},
#endif

#ifdef JP
        { "ѻե˥å",       30000,  175, 110,  5, 11, RACE_DARK_ELF},
#else
		{ "Nikki the Necromancer",       30000,  175, 110,  5, 11, RACE_DARK_ELF},
#endif

#ifdef JP
        { "ȥ",        15000,  200, 110,  7,  8, RACE_SPRITE},
#else
		{ "Solostoran",        15000,  200, 110,  7,  8, RACE_SPRITE},
#endif

#ifdef JP
{ "±",         20000,  215, 113,  6, 10, RACE_MIND_FLAYER},
#else
		{ "Achshe the Tentacled",         20000,  215, 113,  6, 10, RACE_MIND_FLAYER},
#endif

	},
	{
		/* Black Market - 32 unique names */
#ifdef JP
                { "꡼=",            20000,  250,  150,  10,   5,  RACE_HALF_TROLL},
                { "֥Υҥȡ",       20000,  250,  150,  10,   5,  RACE_HALF_ORC},
                { "ե󥮿ͥ",           30000,  250,  150,  10,   5,  RACE_HUMAN},
                { "ʤ(?)ȥå",                     30000,  250,  150,  10,   5,  RACE_ELF},
#else
		{ "Gary Gygaz",                 20000,  250, 150, 10,  5, RACE_HALF_TROLL},
		{ "Histor the Goblin",          20000,  250, 150, 10,  5, RACE_HALF_ORC},
		{ "Quark the Ferengi",          30000,  250, 150, 10,  5, RACE_DWARF},
		{ "Topi the Fair(?)",           30000,  250, 150, 10,  5, RACE_HUMAN},
#endif

#ifdef JP
{ "ͥå",             20000,  250, 150, 10,  5, RACE_ZOMBIE},
#else
		{ "Vhassa the Dead",             20000,  250, 150, 10,  5, RACE_ZOMBIE},
#endif

#ifdef JP
{ "΢ڤԥ",          20000,  250, 150, 10,  5, RACE_VAMPIRE},
#else
		{ "Kyn the Treacherous",          20000,  250, 150, 10,  5, RACE_VAMPIRE},
#endif

#ifdef JP
{ "֥ܥ˥",          30000,  250, 150, 10,  5, RACE_BEASTMAN},
#else
		{ "Bubonicus",          30000,  250, 150, 10,  5, RACE_BEASTMAN},
#endif

#ifdef JP
{ "ץ饤",           30000,  250, 150, 10,  5, RACE_SPECTRE},
#else
		{ "Corpselight",           30000,  250, 150, 10,  5, RACE_SPECTRE},
#endif

#ifdef JP
{ "˵ѥå",                 20000,  250, 150, 10,  5, RACE_VAMPIRE},
#else
		{ "Parrish the Bloodthirsty",                 20000,  250, 150, 10,  5, RACE_VAMPIRE},
#endif

#ifdef JP
{ "",          20000,  250, 150, 10,  5, RACE_SKELETON},
#else
		{ "Vile",          20000,  250, 150, 10,  5, RACE_SKELETON},
#endif

#ifdef JP
{ "Υץƥ",          30000,  250, 150, 10,  5, RACE_SKELETON},
#else
		{ "Prentice the Trusted",          30000,  250, 150, 10,  5, RACE_SKELETON},
#endif

#ifdef JP
{ "ʹֻΥꥨ",           30000,  250, 150, 10,  5, RACE_IMP},
#else
		{ "Griella Humanslayer",           30000,  250, 150, 10,  5, RACE_IMP},
#endif

#ifdef JP
{ "󥸥",                 20000,  250, 150, 10,  5, RACE_VAMPIRE},
#else
		{ "Angel",                 20000,  250, 150, 10,  5, RACE_VAMPIRE},
#endif

#ifdef JP
{ "Ĥեĥ",          20000,  250, 150, 10,  5, RACE_ZOMBIE},
#else
		{ "Flotsam the Bloated",          20000,  250, 150, 10,  5, RACE_ZOMBIE},
#endif

#ifdef JP
{ "ˡ",          30000,  250, 150, 10,  5, RACE_VAMPIRE},
#else
		{ "Nieval",          30000,  250, 150, 10,  5, RACE_VAMPIRE},
#endif

#ifdef JP
{ "뤤ʥ",           30000,  250, 150, 10,  5, RACE_SPECTRE},
#else
		{ "Anastasia the Luminous",           30000,  250, 150, 10,  5, RACE_SPECTRE},
#endif

#ifdef JP
{ "ѻեƥ", 20000,  250, 150, 10,  5, RACE_DARK_ELF},
#else
		{ "Charity the Necromancer", 20000,  250, 150, 10,  5, RACE_DARK_ELF},
#endif

#ifdef JP
{ "ܥΥץʥ",          20000,  250, 150, 10,  5, RACE_HALF_ORC},
#else
		{ "Pugnacious the Pugilist",          20000,  250, 150, 10,  5, RACE_HALF_ORC},
#endif

#ifdef JP
{ "ʥեåȥ",          30000,  250, 150, 10,  5, RACE_BEASTMAN},
#else
		{ "Footsore the Lucky",          30000,  250, 150, 10,  5, RACE_BEASTMAN},
#endif

#ifdef JP
{ "ؤΥɥꥢ",           30000,  250, 150, 10,  5, RACE_HUMAN},
#else
		{ "Sidria Lighfingered",           30000,  250, 150, 10,  5, RACE_HUMAN},
#endif

#ifdef JP
{ "ʻեꥢ",                 20000,  250, 150, 10,  5, RACE_HOBBIT},
#else
		{ "Riatho the Juggler",                 20000,  250, 150, 10,  5, RACE_HOBBIT},
#endif

#ifdef JP
{ "꤯Υʥå",          20000,  250, 150, 10,  5, RACE_GNOME},
#else
		{ "Janaaka the Shifty",          20000,  250, 150, 10,  5, RACE_GNOME},
#endif

#ifdef JP
{ "ޥ",          30000,  250, 150, 10,  5, RACE_GNOME},
#else
		{ "Cina the Rogue",          30000,  250, 150, 10,  5, RACE_GNOME},
#endif

#ifdef JP
{ "ޥ˥å",           30000,  250, 150, 10,  5, RACE_DRACONIAN},
#else
		{ "Arunikki Greatclaw",           30000,  250, 150, 10,  5, RACE_DRACONIAN},
#endif

#ifdef JP
{ "˳㥨",                 20000,  250, 150, 10,  5, RACE_HUMAN},
#else
		{ "Chaeand the Poor",                 20000,  250, 150, 10,  5, RACE_HUMAN},
#endif

#ifdef JP
{ "±եɡ",          20000,  250, 150, 10,  5, RACE_BARBARIAN},
#else
		{ "Afardorf the Brigand",          20000,  250, 150, 10,  5, RACE_BARBARIAN},
#endif

#ifdef JP
{ "ߥ饶",          30000,  250, 150, 10,  5, RACE_MIND_FLAYER},
#else
		{ "Lathaxl the Greedy",          30000,  250, 150, 10,  5, RACE_MIND_FLAYER},
#endif

#ifdef JP
{ "ե쥦",           30000,  250, 150, 10,  5, RACE_SPRITE},
#else
		{ "Falarewyn",           30000,  250, 150, 10,  5, RACE_SPRITE},
#endif

#ifdef JP
{ "路",                 20000,  250, 150, 10,  5, RACE_NIBELUNG},
#else
		{ "Vosur the Wrinkled",                 20000,  250, 150, 10,  5, RACE_NIBELUNG},
#endif

#ifdef JP
{ "ϥ󥵥ʥ饪",          20000,  250, 150, 10,  5, RACE_AMBERITE},
#else
		{ "Araord the Handsome",          20000,  250, 150, 10,  5, RACE_AMBERITE},
#endif

#ifdef JP
{ "餱ɥե",          30000,  250, 150, 10,  5, RACE_HUMAN},
#else
		{ "Theradfrid the Loser",          30000,  250, 150, 10,  5, RACE_HUMAN},
#endif

#ifdef JP
{ "­Υ롼",           30000,  250, 150, 10,  5, RACE_HALF_OGRE},
#else
		{ "One-Legged Eroolo",           30000,  250, 150, 10,  5, RACE_HALF_OGRE},
#endif

	},
	{
		/* Home */
#ifdef JP
		{ "椬",                          0,      100, 100,  0, 99, 99},
		{ "椬",                          0,      100, 100,  0, 99, 99},
		{ "椬",                          0,      100, 100,  0, 99, 99},
		{ "椬",                          0,      100, 100,  0, 99, 99},
		{ "椬",                          0,      100, 100,  0, 99, 99},
		{ "椬",                          0,      100, 100,  0, 99, 99},
		{ "椬",                          0,      100, 100,  0, 99, 99},
		{ "椬",                          0,      100, 100,  0, 99, 99},
		{ "椬",                          0,      100, 100,  0, 99, 99},
		{ "椬",                          0,      100, 100,  0, 99, 99},
		{ "椬",                          0,      100, 100,  0, 99, 99},
		{ "椬",                          0,      100, 100,  0, 99, 99},
		{ "椬",                          0,      100, 100,  0, 99, 99},
		{ "椬",                          0,      100, 100,  0, 99, 99},
		{ "椬",                          0,      100, 100,  0, 99, 99},
		{ "椬",                          0,      100, 100,  0, 99, 99},
		{ "椬",                          0,      100, 100,  0, 99, 99},
		{ "椬",                          0,      100, 100,  0, 99, 99},
		{ "椬",                          0,      100, 100,  0, 99, 99},
		{ "椬",                          0,      100, 100,  0, 99, 99},
		{ "椬",                          0,      100, 100,  0, 99, 99},
		{ "椬",                          0,      100, 100,  0, 99, 99},
		{ "椬",                          0,      100, 100,  0, 99, 99},
		{ "椬",                          0,      100, 100,  0, 99, 99},
		{ "椬",                          0,      100, 100,  0, 99, 99},
		{ "椬",                          0,      100, 100,  0, 99, 99},
		{ "椬",                          0,      100, 100,  0, 99, 99},
		{ "椬",                          0,      100, 100,  0, 99, 99},
		{ "椬",                          0,      100, 100,  0, 99, 99},
		{ "椬",                          0,      100, 100,  0, 99, 99},
		{ "椬",                          0,      100, 100,  0, 99, 99},
		{ "椬",                          0,      100, 100,  0, 99, 99},
#else
		{ "Your home",                          0,      100, 100,  0, 99, 99},
		{ "Your home",                          0,      100, 100,  0, 99, 99},
		{ "Your home",                          0,      100, 100,  0, 99, 99},
		{ "Your home",                          0,      100, 100,  0, 99, 99},
		{ "Your home",                          0,      100, 100,  0, 99, 99},
		{ "Your home",                          0,      100, 100,  0, 99, 99},
		{ "Your home",                          0,      100, 100,  0, 99, 99},
		{ "Your home",                          0,      100, 100,  0, 99, 99},
		{ "Your home",                          0,      100, 100,  0, 99, 99},
		{ "Your home",                          0,      100, 100,  0, 99, 99},
		{ "Your home",                          0,      100, 100,  0, 99, 99},
		{ "Your home",                          0,      100, 100,  0, 99, 99},
		{ "Your home",                          0,      100, 100,  0, 99, 99},
		{ "Your home",                          0,      100, 100,  0, 99, 99},
		{ "Your home",                          0,      100, 100,  0, 99, 99},
		{ "Your home",                          0,      100, 100,  0, 99, 99},
		{ "Your home",                          0,      100, 100,  0, 99, 99},
		{ "Your home",                          0,      100, 100,  0, 99, 99},
		{ "Your home",                          0,      100, 100,  0, 99, 99},
		{ "Your home",                          0,      100, 100,  0, 99, 99},
		{ "Your home",                          0,      100, 100,  0, 99, 99},
		{ "Your home",                          0,      100, 100,  0, 99, 99},
		{ "Your home",                          0,      100, 100,  0, 99, 99},
		{ "Your home",                          0,      100, 100,  0, 99, 99},
		{ "Your home",                          0,      100, 100,  0, 99, 99},
		{ "Your home",                          0,      100, 100,  0, 99, 99},
		{ "Your home",                          0,      100, 100,  0, 99, 99},
		{ "Your home",                          0,      100, 100,  0, 99, 99},
		{ "Your home",                          0,      100, 100,  0, 99, 99},
		{ "Your home",                          0,      100, 100,  0, 99, 99},
		{ "Your home",                          0,      100, 100,  0, 99, 99},
		{ "Your home",                          0,      100, 100,  0, 99, 99},
#endif

	},
	{
		/* Bookstore - 21 unique names */
#ifdef JP
		{ "ߥɥ", 10000, 175, 108, 4, 12, RACE_HUMAN},
		{ "ԥɥʡ", 15000, 120, 105, 6, 16, RACE_HIGH_ELF},
		{ "ΩΥ", 25000, 120, 110, 7, 19, RACE_DARK_ELF},
		{ "ǦѤοͥ=", 30000, 140, 105, 6, 12, RACE_ELF},
#else
		{ "Dolaf the Greedy", 10000, 175, 108, 4, 12, RACE_HUMAN},
		{ "Odnar the Sage", 15000, 120, 105, 6, 16, RACE_HIGH_ELF},
		{ "Gandar the Neutral", 25000, 120, 110, 7, 19, RACE_DARK_ELF},
		{ "Ro-sha the Patient", 30000, 140, 105, 6, 12, RACE_ELF},
#endif

#ifdef JP
{ "ɥա", 15000, 175, 108, 4, 12, RACE_HUMAN},
#else
		{ "Randolph Carter", 15000, 175, 108, 4, 12, RACE_HUMAN},
#endif

#ifdef JP
{ "ȻΥ饤", 15000, 175, 108, 4, 12, RACE_HUMAN},
#else
		{ "Sarai the Swift", 15000, 175, 108, 4, 12, RACE_HUMAN},
#endif

#ifdef JP
{ "Τܥɥ", 20000, 120, 105, 6, 16, RACE_HIGH_ELF},
#else
		{ "Bodril the Seer", 20000, 120, 105, 6, 16, RACE_HIGH_ELF},
#endif

#ifdef JP
{ "ۤΥ", 25000, 120, 110, 7, 19, RACE_ZOMBIE},
#else
		{ "Veloin the Quiet", 25000, 120, 110, 7, 19, RACE_ZOMBIE},
#endif

#ifdef JP
{ "ؼԤΥ󥷥饹", 30000, 140, 105, 6, 12, RACE_MIND_FLAYER},
#else
		{ "Vanthylas the Learned", 30000, 140, 105, 6, 12, RACE_MIND_FLAYER},
#endif

#ifdef JP
{ "ʪ񤭥", 15000, 175, 108, 4, 12, RACE_SKELETON},
#else
		{ "Ossein the Literate", 15000, 175, 108, 4, 12, RACE_SKELETON},
#endif

#ifdef JP
{ "ܤ", 20000, 120, 105, 6, 16, RACE_VAMPIRE},
#else
		{ "Olvar Bookworm", 20000, 120, 105, 6, 16, RACE_VAMPIRE},
#endif

#ifdef JP
{ "", 25000, 120, 110, 7, 19, RACE_ZOMBIE},
#else
		{ "Shallowgrave", 25000, 120, 110, 7, 19, RACE_ZOMBIE},
#endif

#ifdef JP
{ "ǥޥ", 30000, 140, 105, 6, 12, RACE_ZOMBIE},
#else
		{ "Death Mask", 30000, 140, 105, 6, 12, RACE_ZOMBIE},
#endif

#ifdef JP
{ "ؼԤΥ", 15000, 175, 108, 4, 12, RACE_MIND_FLAYER},
#else
		{ "Asuunu the Learned", 15000, 175, 108, 4, 12, RACE_MIND_FLAYER},
#endif

#ifdef JP
{ "ͤΥץ", 20000, 120, 105, 6, 16, RACE_ZOMBIE},
#else
		{ "Prirand the Dead", 20000, 120, 105, 6, 16, RACE_ZOMBIE},
#endif

#ifdef JP
{ "ŴΥʡ", 25000, 120, 110, 7, 19, RACE_GOLEM},
#else
		{ "Ronar the Iron", 25000, 120, 110, 7, 19, RACE_GOLEM},
#endif

#ifdef JP
{ "=ߥ", 30000, 140, 105, 6, 12, RACE_ELF},
#else
		{ "Galil-Gamir", 30000, 140, 105, 6, 12, RACE_ELF},
#endif

#ifdef JP
{ "ܿХ", 15000, 175, 108, 4, 12, RACE_KOBOLD},
#else
		{ "Rorbag Book-Eater", 15000, 175, 108, 4, 12, RACE_KOBOLD},
#endif

#ifdef JP
{ "ꥢꥭ", 20000, 120, 105, 6, 16, RACE_KLACKON},
#else
		{ "Kiriarikirk", 20000, 120, 105, 6, 16, RACE_KLACKON},
#endif

#ifdef JP
{ "Ťʤ", 25000, 120, 110, 7, 19, RACE_DWARF},
#else
		{ "Rilin the Quiet", 25000, 120, 110, 7, 19, RACE_DWARF},
#endif

#ifdef JP
{ "ԥ", 30000, 140, 105, 6, 12, RACE_HIGH_ELF},
#else
		{ "Isung the Lord", 30000, 140, 105, 6, 12, RACE_HIGH_ELF},
#endif

#ifdef JP
{ "ߥɥ", 10000, 175, 108, 4, 12, RACE_HUMAN},
#else
		{ "Dolaf the Greedy", 10000, 175, 108, 4, 12, RACE_HUMAN},
#endif

#ifdef JP
{ "ԥɥʡ", 15000, 120, 105, 6, 16, RACE_HIGH_ELF},
#else
		{ "Odnar the Sage", 15000, 120, 105, 6, 16, RACE_HIGH_ELF},
#endif

#ifdef JP
{ "ΩΥ", 25000, 120, 110, 7, 19, RACE_DARK_ELF},
#else
		{ "Gandar the Neutral", 25000, 120, 110, 7, 19, RACE_DARK_ELF},
#endif

#ifdef JP
{ "ǦѤοͥ=", 30000, 140, 105, 6, 12, RACE_ELF},
#else
		{ "Ro-sha the Patient", 30000, 140, 105, 6, 12, RACE_ELF},
#endif

#ifdef JP
{ "ɥա", 15000, 175, 108, 4, 12, RACE_HUMAN},
#else
		{ "Randolph Carter", 15000, 175, 108, 4, 12, RACE_HUMAN},
#endif

#ifdef JP
{ "Ȼ饤", 15000, 175, 108, 4, 12, RACE_HUMAN},
#else
		{ "Sarai the Swift", 15000, 175, 108, 4, 12, RACE_HUMAN},
#endif

#ifdef JP
{ "Τܥɥ", 20000, 120, 105, 6, 16, RACE_HIGH_ELF},
#else
		{ "Bodril the Seer", 20000, 120, 105, 6, 16, RACE_HIGH_ELF},
#endif

#ifdef JP
{ "ۤΥ", 25000, 120, 110, 7, 19, RACE_ZOMBIE},
#else
		{ "Veloin the Quiet", 25000, 120, 110, 7, 19, RACE_ZOMBIE},
#endif

#ifdef JP
{ "ؼԤΥ󥷥饹", 30000, 140, 105, 6, 12, RACE_MIND_FLAYER},
#else
		{ "Vanthylas the Learned", 30000, 140, 105, 6, 12, RACE_MIND_FLAYER},
#endif

#ifdef JP
{ "ʪ񤭥", 15000, 175, 108, 4, 12, RACE_SKELETON},
#else
		{ "Ossein the Literate", 15000, 175, 108, 4, 12, RACE_SKELETON},
#endif

#ifdef JP
{ "ܤ", 20000, 120, 105, 6, 16, RACE_VAMPIRE},
#else
		{ "Olvar Bookworm", 20000, 120, 105, 6, 16, RACE_VAMPIRE},
#endif

	}
};




/*
 * This table allows quick conversion from "speed" to "energy"
 * The basic function WAS ((S>=110) ? (S-110) : (100 / (120-S)))
 * Note that table access is *much* quicker than computation.
 *
 * Note that the table has been changed at high speeds.  From
 * "Slow (-40)" to "Fast (+30)" is pretty much unchanged, but
 * at speeds above "Fast (+30)", one approaches an asymptotic
 * effective limit of 50 energy per turn.  This means that it
 * is relatively easy to reach "Fast (+30)" and get about 40
 * energy per turn, but then speed becomes very "expensive",
 * and you must get all the way to "Fast (+50)" to reach the
 * point of getting 45 energy per turn.  After that point,
 * furthur increases in speed are more or less pointless,
 * except to balance out heavy inventory.
 *
 * Note that currently the fastest monster is "Fast (+30)".
 *
 * It should be possible to lower the energy threshhold from
 * 100 units to 50 units, though this may interact badly with
 * the (compiled out) small random energy boost code.  It may
 * also tend to cause more "clumping" at high speeds.
 */
byte extract_energy[200] =
{
	/* Slow */     1,  1,  1,  1,  1,  1,  1,  1,  1,  1,
	/* Slow */     1,  1,  1,  1,  1,  1,  1,  1,  1,  1,
	/* Slow */     1,  1,  1,  1,  1,  1,  1,  1,  1,  1,
	/* Slow */     1,  1,  1,  1,  1,  1,  1,  1,  1,  1,
	/* Slow */     1,  1,  1,  1,  1,  1,  1,  1,  1,  1,
	/* Slow */     1,  1,  1,  1,  1,  1,  1,  1,  1,  1,
	/* S-50 */     1,  1,  1,  1,  1,  1,  1,  1,  1,  1,
	/* S-40 */     2,  2,  2,  2,  2,  2,  2,  2,  2,  2,
	/* S-30 */     2,  2,  2,  2,  2,  2,  2,  3,  3,  3,
	/* S-20 */     3,  3,  3,  3,  3,  4,  4,  4,  4,  4,
	/* S-10 */     5,  5,  5,  5,  6,  6,  7,  7,  8,  9,
	/* Norm */    10, 11, 12, 13, 14, 15, 16, 17, 18, 19,
	/* F+10 */    20, 21, 22, 23, 24, 25, 26, 27, 28, 29,
	/* F+20 */    30, 31, 32, 33, 34, 35, 36, 36, 37, 37,
	/* F+30 */    38, 38, 39, 39, 40, 40, 40, 41, 41, 41,
	/* F+40 */    42, 42, 42, 43, 43, 43, 44, 44, 44, 44,
	/* F+50 */    45, 45, 45, 45, 45, 46, 46, 46, 46, 46,
	/* F+60 */    47, 47, 47, 47, 47, 48, 48, 48, 48, 48,
	/* F+70 */    49, 49, 49, 49, 49, 49, 49, 49, 49, 49,
	/* Fast */    49, 49, 49, 49, 49, 49, 49, 49, 49, 49,
};




/*
 * Base experience levels, may be adjusted up for race and/or class
 */
s32b player_exp[PY_MAX_LEVEL] =
{
	10,
	25,
	45,
	70,
	100,
	140,
	200,
	280,
	380,
	500,
	650,
	850,
	1100,
	1400,
	1800,
	2300,
	2900,
	3600,
	4400,
	5400,
	6800,
	8400,
	10200,
	12500,
	17500,
	25000,
	35000L,
	50000L,
	75000L,
	100000L,
	150000L,
	200000L,
	275000L,
	350000L,
	450000L,
	550000L,
	700000L,
	850000L,
	1000000L,
	1250000L,
	1500000L,
	1800000L,
	2100000L,
	2400000L,
	2700000L,
	3000000L,
	3500000L,
	4000000L,
	4500000L,
	5000000L
};


/*
 * Player Sexes
 *
 *      Title,
 *      Winner
 */
player_sex sex_info[MAX_SEXES] =
{
	{
#ifdef JP
                "",
                "Female",
                ""
#else
		"Female",
		"Queen"
#endif

	},
	{
#ifdef JP
                "",
                "Male",
                ""
#else
		"Male",
		"King"
#endif

	}
};


/*
 * Player Races
 *
 *      Title,
 *      {STR,INT,WIS,DEX,CON,CHR},
 *      r_dis, r_dev, r_sav, r_stl, r_srh, r_fos, r_thn, r_thb,
 *      hitdie, exp base,
 *      Age (Base, Mod),
 *      Male (Hgt, Wgt),
 *      Female (Hgt, Wgt)
 *      infra,
 *      class-choices
 */
player_race race_info[MAX_RACES] =
{
	{
#ifdef JP
		"ʹ",
		"Human",
#else
		"Human",
#endif

		{  0,  0,  0,  0,  0,  0 },
		0,  0,  0,  0,  0,  10,  0,  0,
		10,  100,
		14,  6,
		72,  6, 180, 25,
		66,  4, 150, 20,
		0,
		0x7FF,
	},
	{
#ifdef JP
	        "ϡե",
		"Half-Elf",
#else
		"Half-Elf",
#endif

		{ -1,  1,  1,  1, -1,  1 },
		2,  3,  3,  1, 6,  11, -2,  3,
		9,  110,
		24, 16,
		66,  6, 130, 15,
		62,  6, 100, 10,
		2,
		0x7FF,
	},
	{
#ifdef JP
	        "",
		"Elf",
#else
		"Elf",
#endif

		{ -1,  2,  2,  1, -2,  2 },
		5,  6,  6,  2, 8,  12, -6, 6,
		8,  120,
		75, 75,
		60,  4, 100,  6,
		54,  4, 80,  6,
		3,
		0x75F,
	},
	{
#ifdef JP
		"ۥӥå",
		"Hobbit",
#else
		"Hobbit",
#endif

		{ -2,  2,  1,  3,  2,  1 },
		15, 18, 18, 5, 12,  15, -11, 6,
		7,  110,
		21, 12,
		36,  3, 60,  3,
		33,  3, 50,  3,
		4,
		0x40B,
	},
	{
#ifdef JP
		"Ρ",
		"Gnome",
#else
		"Gnome",
#endif

		{ -1,  2,  0,  2,  1, -2 },
		10, 12, 12,  3, 6,  13, -8, 0,
		8,  135,
		50, 40,
		42,  3, 90,  6,
		39,  3, 75,  3,
		4,
		0x60F,
	},
	{
#ifdef JP
		"ɥ",
		"Dwarf",
#else
		"Dwarf",
#endif

		{  2, -2,  2, -2,  2, -3 },
		2,  9,  10,  -1,  7,  10, 7,  0,
		11,  125,
		35, 15,
		48,  3, 150, 10,
		46,  3, 120, 10,
		5,
		0x005,
	},
	{
#ifdef JP
		"ϡե",
		"Half-Orc",
#else
		"Half-Orc",
#endif

		{  2, -1,  0,  0,  1, -4 },
		-3, -3, -3,  -1,  0, 7, 3, -3,
		10,  110,
		11,  4,
		66,  1, 150,  5,
		62,  1, 120,  5,
		3,
		0x18D,
	},
	{
#ifdef JP
		"ϡեȥ",
		"Half-Troll",
#else
		"Half-Troll",
#endif

		{ 4, -4, -2, -4,  3, -6 },
		-5, -8, -8, -2,  -1, 5, 10, -5,
		12,  137,
		20, 10,
		96, 10, 250, 50,
		84,  8, 225, 40,
		3,
		0x005,
	},
	{
#ifdef JP
                "Х饤",
		"Amberite",
#else
		"Amberite",
#endif

		{  1,  2,  2,  2,  3,  2 },
		4,  5,  5,  2, 3, 13, 6, 0,
		10,  225,
		50, 50,
		82, 5, 190, 20,
		78,  6, 180, 15,
		0,
		0x7FF,
	},
	{
#ifdef JP
                "Υ",
		"High-Elf",
#else
		"High-Elf",
#endif

		{  1,  3,  2,  3,  1,  5 },
		4,  20, 20,  4,  3, 14, 0, 10,
		10,  200,
		100, 30,
		90, 10, 190, 20,
		82, 10, 180, 15,
		4,
		0x75F,
	},
	{
#ifdef JP
		"ڿ",
		"Barbarian",
#else
		"Barbarian",
#endif

		{ 3, -2,  -1,  1,  2, -2 },
		-2, -10, 2,  -1,  1, 7, 10, 0,
		11, 120,
		14, 8,
		82, 5, 200, 20,
		78,  6, 190, 15,
		0,
		0x09D,
	},
	{
#ifdef JP
		"ϡե",
		"Half-Ogre",
#else
		"Half-Ogre",
#endif

		{ 3, -1, -1, -1, 3, -3 },
		-3, -5, -5, -2, -1, 5, 12, 0,
		12,  130,
		40, 10,
		92, 10, 255, 60,
		80,  8, 235, 60,
		3,
		0x407,
	},
	{
#ifdef JP
		"Ⱦ",
		"Half-Giant",
#else
		"Half-Giant",
#endif

		{ 4, -2, -2, -2, 3, -3 },
		-6, -8, -6, -2, -1, 5, 13, 2,
		13, 150,
		40, 10,
		100,10, 255, 65,
		80, 10, 240, 64,
		3,
		0x011,
	},
	{
#ifdef JP
		"Ⱦ",
		"Half-Titan",
#else
		"Half-Titan",
#endif

		{ 5, 1, 1, -2, 3, 1 },
		-5, 5, 2, -2, 1, 8, 13, 0,
		14, 255,
		100,30,
		111, 11, 255, 86,
		99, 11, 250, 86,
		0,
		0x727,
	},
	{
#ifdef JP
		"ץ",
		"Cyclops",
#else
		"Cyclops",
#endif

		{ 4, -3, -3, -3, 4, -6 },
		-4, -5, -5, -2, -2, 5, 10, 6,
		13, 130,
		50, 24,
		92, 10, 255, 60,
		80,  8, 235, 60,
		1,
		0x005,
	},
	{
#ifdef JP
		"",
		"Yeek",
#else
		"Yeek",
#endif

		{ -2, 1, 1, 1, -2, -7 },
		2, 4, 10, 3, 5, 15, -5, -5,
		7, 100,
		14, 3,
		50,  3, 90,  6,
		50,  3, 75,  3,
		2,
		0x60F,
	},
	{
#ifdef JP
		"å",
		"Klackon",
#else
		"Klackon",
#endif

		{ 2, -1, -1, 1, 2, -2 },
		10, 5, 5, 0, -1, 10, 5, 5,
		12, 135,
		20, 3,
		60,  3, 80,  4,
		54,  3, 70,  4,
		2,
		0x011,
	},
	{
#ifdef JP
		"ܥ",
		"Kobold",
#else
		"Kobold",
#endif

		{ 1, -1, 0, 1, 0, -4 },
		-2, -3, -2, -1, 1, 8, 8, -8,
		9, 125,
		11,  3,
		60,  1, 130,  5,
		55,  1, 100,  5,
		3,
		0x009,
	},
	{
#ifdef JP
		"ˡ٥",
		"Nibelung",
#else
		"Nibelung",
#endif

		{ 1, -1, 2, 0, 2, -4 },
		3, 5, 10, 1, 5, 10, 5, 0,
		11, 135,
		40, 12,
		43,  3, 92,  6,
		40,  3, 78,  3,
		5,
		0x40F,
	},
	{
#ifdef JP
		"",
		"Dark-Elf",
#else
		"Dark-Elf",
#endif

		{ -1, 3, 2, 2, -2, 1 },
		5, 15, 20, 3, 8, 12, -5, 7,
		9, 150,
		75, 75,
		60,  4, 100,  6,
		54,  4, 80,  6,
		5,
		0x7DF,
	},
	{
#ifdef JP
		"ɥ饳˥",
		"Draconian",
#else
		"Draconian",
#endif

		{ 2, 1, 1, 1, 2, -3 },
		-2, 5, 3, 0, 1, 10, 5, 5,
		11, 250,
		75, 33,
		76,  1, 160,  5,
		72,  1, 130,  5,
		2,
		0x757,
	},
	{
#ifdef JP
		"ޥɥե쥢",
		"Mindflayer",
#else
		"Mindflayer",
#endif

		{ -3, 4, 4, 0, -2, -5 },
		10, 25, 15, 2, 5, 12, -8, -5,
		9, 140,
		100, 25,
		68,  6, 142, 15,
		63,  6, 112, 10,
		4,
		0x746,
	},
	{
#ifdef JP
		"",
		"Imp",
#else
		"Imp",
#endif

		{ -1, -1, -1, 1, 2, -3 },
		-3, 2, -1, 1, -1, 10, 5, -5,
		10, 110,
		13,  4,
		68,  1, 150,  5,
		64,  1, 120,  5,
		3,
		0x7CB,
	},
	{
#ifdef JP
		"",
		"Golem",
#else
		"Golem",
#endif

		{ 4, -5, -5, -2, 4, -4 },
		-5, -5, 10, -1, -1, 8, 10, 0,
		12, 200,
		1, 100,
		66,  1, 200,  6,
		62,  1, 180,  6,
		4,
		0x001,
	},
	{
#ifdef JP
		"",
		"Skeleton",
#else
		"Skeleton",
#endif

		{ 0, -2, -2, 0, 1, -4 },
		-5, -5, 5, -1, -1, 8, 8, 0,
		10, 145,
		100, 35,
		72,  6, 50, 5,
		66,  4, 50, 5,
		2,
		0x70F,
	},
	{
#ifdef JP
		"",
		"Zombie",
#else
		"Zombie",
#endif

		{ 2, -6, -6, 1, 4, -5 },
		-5, -5, 8, -1, -1, 5, 10, 0,
		13, 135,
		100, 30,
		72, 6, 100, 25,
		66, 4, 100, 20,
		2,
		0x001,
	},
	{
#ifdef JP
		"۷쵴",
		"Vampire",
#else
		"Vampire",
#endif

		{ 3, 3, -1, -1, 1, 2 },
		4, 10, 10, 4, 1, 8, 5, 0,
		11, 200,
		100, 30,
		72,  6, 180, 25,
		66,  4, 150, 20,
		5,
		0x7FF,
	},
	{
#ifdef JP
		"ͩ",
		"Spectre",
#else
		"Spectre",
#endif

		{ -5, 4, 4, 2, -3, -6 },
		10, 25, 20, 5, 5, 14, -10, -5,
		7, 180,
		100, 30,
		72, 6, 100, 25,
		66, 4, 100, 20,
		5,
		0x74E,    /* Mage, Priest, Rogue, Warrior-Mage, Monk */
	},
	{
#ifdef JP
		"",
		"Sprite",
#else
		"Sprite",
#endif

		{ -4, 3, 3, 3, -2, 2 },
		10, 10, 10, 4, 10, 10, -8, 0,
		7, 175,
		50, 25,
		32,  2, 75,  2,
		29,  2, 65,  2,
		4,
		0x65E,
	},
	{
#ifdef JP
		"ÿ",  
		"Beastman",
#else
		"Beastman",
#endif

		{ 2, -2, -1, -1, 2, -4 },
		-5, -2, -1, -1, -1, 5, 9, 5,
		11, 140,
		14, 6,
		65,  6, 150, 20,
		61,  6, 120, 15,
		0,
		0x7CF,
	}
};


/*
 * Player Classes
 *
 *      Title,
 *      {STR,INT,WIS,DEX,CON,CHR},
 *      c_dis, c_dev, c_sav, c_stl, c_srh, c_fos, c_thn, c_thb,
 *      x_dis, x_dev, x_sav, x_stl, x_srh, x_fos, x_thn, x_thb,
 *      HD, Exp, pet_upkeep_div
 */
player_class class_info[MAX_CLASS] =
{
	{
#ifdef JP
		"",
		"Warrior",
#else
		"Warrior",
#endif

		{ 5, -2, -2, 2, 2, -1},
		25, 18, 18, 1,  14, 2, 25, 17,
		12, 7,  10, 0,  0,  0,  100, 55,
		9,  0, 20
	},

	{
#ifdef JP
		"ᥤ",
		"Mage",
#else
		"Mage",
#endif

		{-5, 3, 0, 1, -2, 1},
		30, 36, 30, 2,  16, 20, 10, 10,
		7,  13, 9,  0,  0,  0,  25, 14,
		0, 30, 15
	},

	{
#ifdef JP
		"ץ꡼",
		"Priest",
#else
		"Priest",
#endif

		{-1, -3, 3, -1, 0, 2},
		25, 30, 32, 2,  16, 8, 16, 7,
		7,  10, 12, 0,  0,  0, 50, 18,
		2, 20, 20
	},

	{
#ifdef JP
		"󥸥㡼",
		"Ranger",
#else
		"Ranger",
#endif

		{ 2, 2, 0, 1, 1, 1},
		30, 32, 28, 3,  24, 16, 15, 20,
		8,  10, 10, 0,  0,  0,  65, 63,
		4, 30, 20
	},

	{
#ifdef JP
		"ѥǥ",
		"Paladin",
#else
		"Paladin",
#endif

		{ 3, -3, 1, 0, 2, 2},
		20, 24, 26, 1,  12, 2, 19, 10,
		7,  10, 11, 0,  0,  0,  76, 14,
		6, 35, 20
	},

	{
#ifdef JP
		"ˡ",
		"Warrior-Mage",
#else
		"Warrior-Mage",
#endif

		{ 2, 2, 0, 1, 0, 1},
		30, 30, 28, 2,  18, 16, 20, 20,
		7,  10,  9, 0,  0,  0,  75, 50,
		4, 50, 20
	},

	{
#ifdef JP
		"Ķǽϼ",
		"Mindcrafter",
#else
		"Mindcrafter",
#endif

		{-1, 0, 3, -1, -1, 2},   /* note: spell stat is Wis */
		30, 30, 30, 3,  22, 16, 15, 15,
		10, 10, 10, 0,   0,  0, 30, 20,
		2, 25, 20
	},

};




/*
 * Hack -- the spell information table.
 *
 *   Class Name
 *
 *   Spell Book
 *   Spell Xtra
 *
 *   Spell Stat,
 *   Spell Type,
 *
 *   Spell Level,
 *   Spell Encumbrance,
 *
 *   Array of { Lev, Mana, Fail, Exp/Lev }
 */
player_magic magic_info[MAX_CLASS] =
{
	{
		/*** Warrior ***/

		0,
		0,

		A_STR,
		0,

		99,
		0,
		{
			{
				{ 99,  0,  0,   0},
				{ 99,  0,  0,   0},
				{ 99,  0,  0,   0},
				{ 99,  0,  0,   0},
				{ 99,  0,  0,   0},
				{ 99,  0,  0,   0},
				{ 99,  0,  0,   0},
				{ 99,  0,  0,   0},
				{ 99,  0,  0,   0},
				{ 99,  0,  0,   0},

				{ 99,  0,  0,   0},
				{ 99,  0,  0,   0},
				{ 99,  0,  0,   0},
				{ 99,  0,  0,   0},
				{ 99,  0,  0,   0},
				{ 99,  0,  0,   0},
				{ 99,  0,  0,   0},
				{ 99,  0,  0,   0},
				{ 99,  0,  0,   0},
				{ 99,  0,  0,   0},

				{ 99,  0,  0,   0},
				{ 99,  0,  0,   0},
				{ 99,  0,  0,   0},
				{ 99,  0,  0,   0},
				{ 99,  0,  0,   0},
				{ 99,  0,  0,   0},
				{ 99,  0,  0,   0},
				{ 99,  0,  0,   0},
				{ 99,  0,  0,   0},
				{ 99,  0,  0,   0}
			},
			{
				{ 99,  0,  0,   0},
				{ 99,  0,  0,   0},
				{ 99,  0,  0,   0},
				{ 99,  0,  0,   0},
				{ 99,  0,  0,   0},
				{ 99,  0,  0,   0},
				{ 99,  0,  0,   0},
				{ 99,  0,  0,   0},
				{ 99,  0,  0,   0},
				{ 99,  0,  0,   0},

				{ 99,  0,  0,   0},
				{ 99,  0,  0,   0},
				{ 99,  0,  0,   0},
				{ 99,  0,  0,   0},
				{ 99,  0,  0,   0},
				{ 99,  0,  0,   0},
				{ 99,  0,  0,   0},
				{ 99,  0,  0,   0},
				{ 99,  0,  0,   0},
				{ 99,  0,  0,   0},

				{ 99,  0,  0,   0},
				{ 99,  0,  0,   0},
				{ 99,  0,  0,   0},
				{ 99,  0,  0,   0},
				{ 99,  0,  0,   0},
				{ 99,  0,  0,   0},
				{ 99,  0,  0,   0},
				{ 99,  0,  0,   0},
				{ 99,  0,  0,   0},
				{ 99,  0,  0,   0}
			},
			{
				{ 99,  0,  0,   0},
				{ 99,  0,  0,   0},
				{ 99,  0,  0,   0},
				{ 99,  0,  0,   0},
				{ 99,  0,  0,   0},
				{ 99,  0,  0,   0},
				{ 99,  0,  0,   0},
				{ 99,  0,  0,   0},
				{ 99,  0,  0,   0},
				{ 99,  0,  0,   0},

				{ 99,  0,  0,   0},
				{ 99,  0,  0,   0},
				{ 99,  0,  0,   0},
				{ 99,  0,  0,   0},
				{ 99,  0,  0,   0},
				{ 99,  0,  0,   0},
				{ 99,  0,  0,   0},
				{ 99,  0,  0,   0},
				{ 99,  0,  0,   0},
				{ 99,  0,  0,   0},

				{ 99,  0,  0,   0},
				{ 99,  0,  0,   0},
				{ 99,  0,  0,   0},
				{ 99,  0,  0,   0},
				{ 99,  0,  0,   0},
				{ 99,  0,  0,   0},
				{ 99,  0,  0,   0},
				{ 99,  0,  0,   0},
				{ 99,  0,  0,   0},
				{ 99,  0,  0,   0}
			}
		}
	},

	{
		/*** Mage ***/

		TV_SORCERY_BOOK,
		0,

		A_INT,
		0,

		1,
		300,

		{
			/* Mage: Life magic */
			{
				{ 1, 1, 30, 4 },
				{ 3, 2, 35, 4 },
				{ 4, 3, 35, 4 },
				{ 5, 5, 35, 4 },
				{ 7, 7, 35, 4 },
				{ 9, 8, 40, 4 },
				{ 12, 12, 40, 3 },
				{ 15, 14, 45, 3 },
				{ 12, 12, 40, 3 },
				{ 15, 14, 45, 3 },

				{ 16, 16, 45, 4},
				{ 17, 17, 50, 4},
				{ 18, 18, 50, 4},
				{ 19, 19, 50, 4},
				{ 20, 20, 50, 4},
				{ 23, 23, 50, 4},
				{ 30, 30, 55, 5},
				{ 35, 70, 75, 5},
				{ 12, 12, 40, 3 },
				{ 15, 14, 45, 3 },

				{ 26, 30, 50, 75 },
				{ 28, 25, 70, 150 },
				{ 33, 33, 60, 75 },
				{ 35, 35, 60, 75 },
				{ 35, 35, 70, 75 },
				{ 35, 55, 80, 115 },
				{ 39, 40, 80, 125 },
				{ 46, 70, 80, 150 },
				{ 12, 12, 40, 3 },
				{ 15, 14, 45, 3 }
			},

			/* Mage: Sorcery */

			{
				{ 1, 1, 23, 4 },
				{ 1, 2, 24, 4 },
				{ 3, 3, 25, 1 },
				{ 3, 3, 30, 1 },
				{ 4, 4, 30, 1 },
				{ 5, 5, 35, 5 },
				{ 6, 5, 30, 4 },
				{ 7, 7, 75, 9 },
				{ 6, 5, 30, 4 },
				{ 7, 7, 75, 9 },

				{ 9, 7, 75, 8 },
				{ 10, 7, 75, 8 },
				{ 11, 7, 75, 7 },
				{ 13, 7, 50, 6 },
				{ 18, 12, 60, 8 },
				{ 22, 12, 60, 8 },
				{ 28, 20, 70, 15 },
				{ 33, 30, 75, 20 },
				{ 6, 5, 30, 4 },
				{ 7, 7, 75, 9 },

				{ 3, 3, 25, 15 },
				{ 10, 10, 70, 40 },
				{ 10, 10, 80, 40 },
				{ 12, 12, 80, 40 },
				{ 14, 10, 60, 25 },
				{ 20, 18, 85, 50 },
				{ 20, 18, 60, 25 },
				{ 25, 25, 75, 19 },
				{ 6, 5, 30, 4 },
				{ 7, 7, 75, 9 }
			},

				/* Mage: Musou Magic */

			{
				{ 1, 1, 23, 4 },
				{ 3, 3, 25, 3 },
				{ 3, 3, 25, 1 },
				{ 4, 4, 35, 4 },
				{ 4, 4, 50, 5 },
				{ 4, 5, 50, 5 },
				{ 5, 5, 50, 5 },
				{ 5, 5, 35, 4 },
				{ 5, 5, 50, 5 },
				{ 5, 5, 35, 4 },

				{ 5, 5, 40, 6 },
				{ 5, 5, 30, 6 },
				{ 7, 6, 45, 6 },
				{ 7, 6, 40, 6 },
				{ 9, 6, 30, 5 },
				{ 19, 12, 55, 8 },
				{ 25, 25, 90, 50 },
				{ 40, 100, 95, 50 },
				{ 5, 5, 50, 5 },
				{ 5, 5, 35, 4 },

				{ 7, 7, 20, 28 },
				{ 9, 12, 40, 44 },
				{ 10, 12, 75, 120 },
				{ 15, 20, 85, 60 },
				{ 30, 30, 90, 100 },
				{ 37, 40, 90, 200 },
				{ 38, 45, 75, 200},
				{ 40, 90, 90, 250 },
				{ 5, 5, 50, 5 },
				{ 5, 5, 35, 4 }
			}
		}
	},

	{
		/*** Priest ***/

		TV_LIFE_BOOK,
		0,

		A_WIS,
		1,

		1,
		350,
		{
			/* Priest: Life Magic */
			{
				{ 1, 1, 10, 4 },
				{ 1, 2, 15, 4 },
				{ 1, 2, 20, 4 },
				{ 3, 2, 25, 1 },
				{ 3, 3, 27, 2 },
				{ 4, 4, 28, 2 },
				{ 5, 4, 32, 4 },
				{ 7, 5, 38, 4 },
				{ 5, 4, 32, 4 },
				{ 7, 5, 38, 4 },

				{ 7, 6, 38, 5 },
				{ 9, 6, 38, 4 },
				{ 9, 7, 40, 4 },
				{ 10, 8, 38, 4 },
				{ 10, 8, 40, 4 },
				{ 11, 8, 42, 4 },
				{ 20, 16, 60, 7 },
				{ 33, 55, 90, 15 },
				{ 5, 4, 32, 4 },
				{ 7, 5, 38, 4 },

				{ 15, 14, 50, 50 },
				{ 16, 14, 80, 60 },
				{ 17, 14, 55, 70 },
				{ 24, 20, 55, 70 },
				{ 25, 20, 70, 120 },
				{ 25, 25, 80, 250 },
				{ 39, 32, 95, 200 },
				{ 44, 44, 80, 250 },
				{ 5, 4, 32, 4 },
				{ 7, 5, 38, 4 }
			},

			/* Priest: Sorcery */
			{
				{ 2, 1, 23, 4 },
				{ 3, 2, 24, 4 },
				{ 4, 3, 25, 1 },
				{ 5, 4, 30, 1 },
				{ 6, 5, 30, 1 },
				{ 7, 6, 35, 5 },
				{ 9, 7, 30, 4 },
				{ 11, 10, 75, 9 },
				{ 9, 7, 30, 4 },
				{ 11, 10, 75, 9 },

				{ 13, 11, 75, 8 },
				{ 14, 12, 75, 6 },
				{ 15, 13, 75, 7 },
				{ 16, 14, 50, 6 },
				{ 22, 15, 60, 8 },
				{ 27, 17, 65, 10 },
				{ 30, 22, 70, 15 },
				{ 36, 33, 75, 20 },
				{ 9, 7, 30, 4 },
				{ 11, 10, 75, 9 },

				{ 7, 7, 25, 15 },
				{ 12, 12, 70, 40 },
				{ 14, 14, 80, 40 },
				{ 15, 15, 80, 40 },
				{ 18, 18, 60, 25 },
				{ 20, 20, 85, 50 },
				{ 22, 22, 60, 25 },
				{ 27, 27, 75, 19 },
				{ 9, 7, 30, 4 },
				{ 11, 10, 75, 9 }
			},

			/* Priest: Musou Magic */
			{
				{ 2, 1, 25, 4 },
				{ 5, 3, 25, 4 },
				{ 5, 4, 25, 1 },
				{ 6, 5, 35, 4 },
				{ 6, 5, 50, 5 },
				{ 6, 6, 50, 5 },
				{ 7, 7, 50, 5 },
				{ 7, 7, 35, 4 },
				{ 7, 7, 50, 5 },
				{ 7, 7, 35, 4 },

				{ 7, 7, 40, 6 },
				{ 8, 7, 30, 6 },
				{ 9, 10, 40, 6 },
				{ 10, 10, 40, 6 },
				{ 11, 11, 30, 5 },
				{ 20, 20, 65, 7 },
				{ 30, 30, 55, 8 },
				{ 42, 100, 95, 50 },
				{ 7, 7, 50, 5 },
				{ 7, 7, 35, 4 },

				{ 9, 9, 20, 28 },
				{ 11, 12, 40, 44 },
				{ 12, 13, 75, 120 },
				{ 18, 20, 85, 60 },
				{ 35, 35, 80, 50 },
				{ 39, 40, 90, 200 },
				{ 40, 50, 85, 250 },
				{ 42, 90, 90, 250 },
				{ 7, 7, 50, 5 },
				{ 7, 7, 35, 4 }
			}
		}
	},

	{
		/*** Ranger ***/

		TV_SORCERY_BOOK,
		0,

		A_INT,
		0,

		3,
		400,

		{
			{
				{ 99, 0, 0, 0},
				{ 99, 0, 0, 0},
				{ 99, 0, 0, 0},
				{ 99, 0, 0, 0},
				{ 99, 0, 0, 0},
				{ 99, 0, 0, 0},
				{ 99, 0, 0, 0},
				{ 99, 0, 0, 0},
				{ 99, 0, 0, 0},
				{ 99, 0, 0, 0},

				{ 99, 0, 0, 0},
				{ 99, 0, 0, 0},
				{ 99, 0, 0, 0},
				{ 99, 0, 0, 0},
				{ 99, 0, 0, 0},
				{ 99, 0, 0, 0},
				{ 99, 0, 0, 0},
				{ 99, 0, 0, 0},
				{ 99, 0, 0, 0},
				{ 99, 0, 0, 0},

				{ 99, 0, 0, 0},
				{ 99, 0, 0, 0},
				{ 99, 0, 0, 0},
				{ 99, 0, 0, 0},
				{ 99, 0, 0, 0},
				{ 99, 0, 0, 0},
				{ 99, 0, 0, 0},
				{ 99, 0, 0, 0},
				{ 99, 0, 0, 0},
				{ 99, 0, 0, 0}
			},

			/* Ranger: Sorcery */
			{
				{ 3, 2, 35, 2 },
				{ 3, 3, 35, 2 },
				{ 5, 4, 40, 2 },
				{ 7, 4, 40, 2 },
				{ 9, 6, 40, 2 },
				{ 11, 8, 45, 2 },
				{ 13, 8, 40, 3 },
				{ 17, 17, 90, 4 },
				{ 13, 8, 40, 3 },
				{ 17, 17, 90, 4 },

				{ 20, 19, 85, 4 },
				{ 23, 25, 90, 3 },
				{ 25, 25, 60, 3 },
				{ 27, 25, 85, 3 },
				{ 31, 27, 70, 3 },
				{ 34, 35, 70, 4 },
				{ 38, 37, 70, 8 },
				{ 42, 40, 90, 10 },
				{ 13, 8, 40, 3 },
				{ 17, 17, 90, 4 },

				{ 15, 7, 75, 20 },
				{ 15, 20, 70, 25 },
				{ 17, 17, 70, 25 },
				{ 18, 18, 80, 25 },
				{ 19, 25, 65, 20 },
				{ 23, 25, 60, 20 },
				{ 27, 27, 60, 15 },
				{ 35, 35, 75, 13 },
				{ 13, 8, 40, 3 },
				{ 17, 17, 90, 4 }
			},

			/* Ranger: Musou Magic */
			{
				{ 3, 1, 35, 2 },
				{ 4, 3, 40, 2 },
				{ 4, 4, 40, 3 },
				{ 5, 7, 55, 2 },
				{ 6, 7, 50, 3 },
				{ 7, 7, 50, 3 },
				{ 8, 7, 50, 3 },
				{ 9, 7, 45, 3 },
				{ 8, 7, 50, 3 },
				{ 9, 7, 45, 3 },

				{ 9, 7, 80, 4 },
				{ 10, 7, 40, 3 },
				{ 11, 9, 40, 4 },
				{ 12, 9, 55, 4 },
				{ 14, 9, 55, 4 },
				{ 18, 20, 65, 8 },
				{ 23, 23, 65, 10 },
				{ 40, 100, 95, 50 },
				{ 8, 7, 50, 3 },
				{ 9, 7, 45, 3 },

				{ 10, 10, 50, 25 },
				{ 12, 12, 50, 25 },
				{ 14, 15, 70, 60 },
				{ 20, 30, 85, 70 },
				{ 35, 30, 80, 75 },
				{ 38, 40, 90, 200 },
				{ 40, 55, 90, 250 },
				{ 42, 80, 90, 250 },
				{ 8, 7, 50, 3 },
				{ 9, 7, 45, 3 }
			}
		}
	},

	{
		/*** Paladin ***/

		TV_LIFE_BOOK,
		0,

		A_WIS,
		1,

		1,
		400,
		{
			/* Paladin: Life Magic */
			{
				{ 1, 1, 30, 4 },
				{ 2, 2, 35, 4 },
				{ 3, 3, 35, 4 },
				{ 4, 3, 35, 4 },
				{ 5, 4, 35, 4 },
				{ 8, 5, 40, 4 },
				{ 11, 9, 40, 3 },
				{ 13, 10, 45, 3 },
				{ 11, 9, 40, 3 },
				{ 13, 10, 45, 3 },

				{ 14, 11, 45, 4},
				{ 15, 15, 50, 4},
				{ 17, 15, 50, 4},
				{ 18, 15, 50, 4},
				{ 18, 15, 50, 4},
				{ 19, 15, 50, 4},
				{ 30, 25, 55, 5},
				{ 35, 70, 75, 5},
				{ 30, 25, 55, 5},
				{ 35, 70, 75, 5},

				{ 25, 22, 50, 75 },
				{ 28, 24, 70, 150 },
				{ 30, 25, 60, 75 },
				{ 33, 30, 60, 75 },
				{ 35, 32, 70, 75 },
				{ 35, 55, 80, 115 },
				{ 39, 38, 80, 125 },
				{ 46, 60, 80, 150 },
				{ 39, 38, 80, 125 },
				{ 46, 60, 80, 150 }
			},

			{

				{ 99,  0,  0,   0},
				{ 99,  0,  0,   0},
				{ 99,  0,  0,   0},
				{ 99,  0,  0,   0},
				{ 99,  0,  0,   0},
				{ 99,  0,  0,   0},
				{ 99,  0,  0,   0},
				{ 99,  0,  0,   0},
				{ 99,  0,  0,   0},
				{ 99,  0,  0,   0},

				{ 99,  0,  0,   0},
				{ 99,  0,  0,   0},
				{ 99,  0,  0,   0},
				{ 99,  0,  0,   0},
				{ 99,  0,  0,   0},
				{ 99,  0,  0,   0},
				{ 99,  0,  0,   0},
				{ 99,  0,  0,   0},
				{ 99,  0,  0,   0},
				{ 99,  0,  0,   0},

				{ 99,  0,  0,   0},
				{ 99,  0,  0,   0},
				{ 99,  0,  0,   0},
				{ 99,  0,  0,   0},
				{ 99,  0,  0,   0},
				{ 99,  0,  0,   0},
				{ 99,  0,  0,   0},
				{ 99,  0,  0,   0},
				{ 99,  0,  0,   0},
				{ 99,  0,  0,   0}
			},
			{
				{ 99,  0,  0,   0},
				{ 99,  0,  0,   0},
				{ 99,  0,  0,   0},
				{ 99,  0,  0,   0},
				{ 99,  0,  0,   0},
				{ 99,  0,  0,   0},
				{ 99,  0,  0,   0},
				{ 99,  0,  0,   0},
				{ 99,  0,  0,   0},
				{ 99,  0,  0,   0},

				{ 99,  0,  0,   0},
				{ 99,  0,  0,   0},
				{ 99,  0,  0,   0},
				{ 99,  0,  0,   0},
				{ 99,  0,  0,   0},
				{ 99,  0,  0,   0},
				{ 99,  0,  0,   0},
				{ 99,  0,  0,   0},
				{ 99,  0,  0,   0},
				{ 99,  0,  0,   0},

				{ 99,  0,  0,   0},
				{ 99,  0,  0,   0},
				{ 99,  0,  0,   0},
				{ 99,  0,  0,   0},
				{ 99,  0,  0,   0},
				{ 99,  0,  0,   0},
				{ 99,  0,  0,   0},
				{ 99,  0,  0,   0},
				{ 99,  0,  0,   0},
				{ 99,  0,  0,   0}
			}
		}
	},

	{
		/*** Warrior-Mage ***/

		TV_SORCERY_BOOK,
		0,

		A_INT,
		0,

		1,
		350,

		{
			{
				{ 2, 2, 30, 4 },
				{ 4, 4, 35, 4 },
				{ 5, 5, 35, 4 },
				{ 6, 6, 35, 4 },
				{ 8, 8, 35, 4 },
				{ 9, 9, 40, 4 },
				{ 14, 14, 40, 3 },
				{ 16, 16, 45, 3 },
				{ 14, 14, 40, 3 },
				{ 16, 16, 45, 3 },

				{ 18, 18, 45, 4},
				{ 20, 20, 50, 4},
				{ 22, 22, 50, 4},
				{ 24, 24, 50, 4},
				{ 26, 26, 50, 4},
				{ 28, 28, 50, 4},
				{ 33, 33, 55, 5},
				{ 40, 70, 75, 5},
				{ 14, 14, 40, 3 },
				{ 16, 16, 45, 3 },

				{ 28, 28, 50, 75 },
				{ 30, 30, 70, 150 },
				{ 34, 34, 60, 75 },
				{ 36, 36, 60, 75 },
				{ 38, 38, 70, 75 },
				{ 42, 55, 80, 115 },
				{ 45, 45, 80, 125 },
				{ 50, 70, 80, 150 },
				{ 14, 14, 40, 3 },
				{ 16, 16, 45, 3 }
			},

			/* Warrior-Mage: Sorcery */
			{
				{ 1, 1, 23, 4 },
				{ 2, 2, 24, 4 },
				{ 3, 3, 25, 1 },
				{ 4, 4, 30, 1 },
				{ 5, 5, 30, 1 },
				{ 6, 6, 35, 5 },
				{ 7, 7, 30, 4 },
				{ 8, 8, 75, 9 },
				{ 7, 7, 30, 4 },
				{ 8, 8, 75, 9 },

				{ 10, 9, 75, 8 },
				{ 11, 10, 75, 8 },
				{ 12, 11, 75, 7 },
				{ 13, 12, 50, 6 },
				{ 20, 15, 60, 8 },
				{ 27, 18, 60, 8 },
				{ 33, 25, 70, 15 },
				{ 7, 7, 30, 4 },
				{ 8, 8, 75, 9 },
				{ 40, 40, 75, 20 },

				{ 4, 4, 25, 15 },
				{ 12, 12, 70, 40 },
				{ 14, 12, 80, 40 },
				{ 15, 12, 70, 30 },
				{ 16, 14, 60, 25 },
				{ 19, 19, 85, 50 },
				{ 24, 22, 60, 25 },
				{ 28, 28, 75, 19 },
				{ 7, 7, 30, 4 },
				{ 8, 8, 75, 9 }
			},

			/* Warrior-Mage: Musou Magic */
			{
				{ 2, 2, 23, 4 },
				{ 3, 3, 25, 3 },
				{ 4, 4, 25, 1 },
				{ 5, 5, 35, 4 },
				{ 6, 6, 50, 5 },
				{ 7, 7, 50, 5 },
				{ 8, 8, 50, 5 },
				{ 9, 9, 35, 4 },
				{ 8, 8, 50, 5 },
				{ 9, 9, 35, 4 },

				{ 10, 10, 40, 6 },
				{ 11, 11, 30, 6 },
				{ 12, 12, 45, 6 },
				{ 13, 13, 40, 6 },
				{ 14, 14, 30, 5 },
				{ 19, 15, 65, 7 },
				{ 31, 31, 65, 10 },
				{ 45, 100, 95, 50 },
				{ 8, 8, 50, 5 },
				{ 9, 9, 35, 4 },

				{ 9, 9, 20, 28 },
				{ 12, 12, 40, 44 },
				{ 15, 15, 75, 120 },
				{ 20, 22, 85, 60 },
				{ 38, 38, 85, 80 },
				{ 40, 42, 90, 200 },
				{ 45, 48, 75, 200},
				{ 49, 95, 90, 250 },
				{ 8, 8, 50, 5 },
				{ 9, 9, 35, 4 }
			}
		}
	},

	{
		/*** Mindcrafter ***/

		TV_LIFE_BOOK,
		0,

		A_WIS,
		0,

		99,
		300,
		{
			{
				{ 99,  0,  0,   0},
				{ 99,  0,  0,   0},
				{ 99,  0,  0,   0},
				{ 99,  0,  0,   0},
				{ 99,  0,  0,   0},
				{ 99,  0,  0,   0},
				{ 99,  0,  0,   0},
				{ 99,  0,  0,   0},
				{ 99,  0,  0,   0},
				{ 99,  0,  0,   0},

				{ 99,  0,  0,   0},
				{ 99,  0,  0,   0},
				{ 99,  0,  0,   0},
				{ 99,  0,  0,   0},
				{ 99,  0,  0,   0},
				{ 99,  0,  0,   0},
				{ 99,  0,  0,   0},
				{ 99,  0,  0,   0},
				{ 99,  0,  0,   0},
				{ 99,  0,  0,   0},

				{ 99,  0,  0,   0},
				{ 99,  0,  0,   0},
				{ 99,  0,  0,   0},
				{ 99,  0,  0,   0},
				{ 99,  0,  0,   0},
				{ 99,  0,  0,   0},
				{ 99,  0,  0,   0},
				{ 99,  0,  0,   0},
				{ 99,  0,  0,   0},
				{ 99,  0,  0,   0}
			},

			{
				{ 99,  0,  0,   0},
				{ 99,  0,  0,   0},
				{ 99,  0,  0,   0},
				{ 99,  0,  0,   0},
				{ 99,  0,  0,   0},
				{ 99,  0,  0,   0},
				{ 99,  0,  0,   0},
				{ 99,  0,  0,   0},
				{ 99,  0,  0,   0},
				{ 99,  0,  0,   0},

				{ 99,  0,  0,   0},
				{ 99,  0,  0,   0},
				{ 99,  0,  0,   0},
				{ 99,  0,  0,   0},
				{ 99,  0,  0,   0},
				{ 99,  0,  0,   0},
				{ 99,  0,  0,   0},
				{ 99,  0,  0,   0},
				{ 99,  0,  0,   0},
				{ 99,  0,  0,   0},

				{ 99,  0,  0,   0},
				{ 99,  0,  0,   0},
				{ 99,  0,  0,   0},
				{ 99,  0,  0,   0},
				{ 99,  0,  0,   0},
				{ 99,  0,  0,   0},
				{ 99,  0,  0,   0},
				{ 99,  0,  0,   0},
				{ 99,  0,  0,   0},
				{ 99,  0,  0,   0}
			},
			{
				{ 99,  0,  0,   0},
				{ 99,  0,  0,   0},
				{ 99,  0,  0,   0},
				{ 99,  0,  0,   0},
				{ 99,  0,  0,   0},
				{ 99,  0,  0,   0},
				{ 99,  0,  0,   0},
				{ 99,  0,  0,   0},
				{ 99,  0,  0,   0},
				{ 99,  0,  0,   0},

				{ 99,  0,  0,   0},
				{ 99,  0,  0,   0},
				{ 99,  0,  0,   0},
				{ 99,  0,  0,   0},
				{ 99,  0,  0,   0},
				{ 99,  0,  0,   0},
				{ 99,  0,  0,   0},
				{ 99,  0,  0,   0},
				{ 99,  0,  0,   0},
				{ 99,  0,  0,   0},

				{ 99,  0,  0,   0},
				{ 99,  0,  0,   0},
				{ 99,  0,  0,   0},
				{ 99,  0,  0,   0},
				{ 99,  0,  0,   0},
				{ 99,  0,  0,   0},
				{ 99,  0,  0,   0},
				{ 99,  0,  0,   0},
				{ 99,  0,  0,   0},
				{ 99,  0,  0,   0}
			}
		}
	}
};


/*
 * Zangband uses this array instead of the spell flags table, as there
 * are 5 realms of magic, each with 4 spellbooks and 8 spells per book -- TY
 */
u32b fake_spell_flags[4]=
{
	0x000003ff,
	0x000ffc00,
	0x3ff00000,
	0x00000000
};


byte realm_choices1[] =
{
	(CH_NONE),					            /* Warrior */
	(CH_SORCERY),                           /* Mage */
	(CH_LIFE),                              /* Priest */
	(CH_SORCERY | CH_MUSOU),                /* Ranger */
	(CH_LIFE),                              /* Paladin */
	(CH_SORCERY | CH_MUSOU),                /* Warrior-Mage */
	(CH_NONE),                              /* Mindcrafter */
};


byte realm_choices2[] =
{
	/* No realm2 */
	(CH_NONE),
	(CH_NONE),
	(CH_NONE),
	(CH_NONE),
	(CH_NONE),
	(CH_NONE),
	(CH_NONE),
};


cptr realm_names[] =
{
#ifdef JP
	"ˡʤ",
	"̿",
	"",
	"̵",
	"",
#else
	"no magic",
	"Life",
	"Sorcery",
	"Musou",
	"unknown"
#endif

};


#ifdef JP
cptr E_realm_names[] =
{
	"no magic",
	"Life",
	"Sorcery",
	"Nature",
	"Chaos",
	"Death",
	"Trump",
	"Arcane",
	"unknown"
};
#endif
/*
 * Names of the spells (mage spells then priest spells)
 */
cptr spell_names[MAX_REALM][32] =
{
	/*** Life Spells ***/
	{
		/* Common Life Spellbooks */
#ifdef JP
"ٰ¸ߴ",
"ڽμ",
"ʡ",
"ݽ",
"ξ",
" & ⴶ",
"Žμ",
"ʢ­",
"",
"",
#else
		"Detect Evil",
		"Cure Light Wounds",
		"Bless",
		"Remove Fear",
		"Call Light",
		"Detect Traps and Secret Doors",
		"Cure Medium Wounds",
		"Satisfy Hunger",
		"Cure Poison",
		"Holy Lite",
#endif


#ifdef JP
"",
"̿μ",
"ͽ",
"ʤ",
"мٰ볦",
"ε",
"λμ",
"ٰ໶",
"ٰ",
"볦",
#else
		"Remove Curse",
		"Cure Critical Wounds",
		"Nanka",
		"Holy Orb",
		"Protection from Evil",
		"Heroism",
		"Healing",
		"Dispel Evil",
		"Banish",
		"Glyph of Warding",
#endif


		/* Rare Life Spellbooks */
#ifdef JP
"**",
"ʤ",
"",
"ʡο",
"ŷȾ",
"",
"",
"ʤӥ",
"ʤ",
"",
#else
		"Dispel Curse",
		"Holy Word",
		"Resistance True",
		"Bless Weapon",
		"Summon Angel",
		"Restoration",
		"Healing True",
		"Dispel Evil",
		"Holy Vision",
		"Nanka",
		"Nanka",
#endif

	},

	/*** Sorcery Spells ***/

	{
		/* Common Sorcery Spellbooks */
#ifdef JP
"ޥåߥ",
"󥹥",
"硼ȥƥݡ",
"櫤ⴶ",
"饤ȡꥢ",
"ƥݡ",
"",
"ʢ­",
"Ԥμʸ",
"ϽŶ",
#else
		"Detect Monsters",
		"Phase Door",
		"Detect Doors and Traps",
		"Light Area",
		"Confuse Monster",
		"Teleport",
		"Sleep Monster",
		"Recharging",
#endif


#ifdef JP
"ϲ",
"ˡϿ",
"",
"",
"Ϥ",
"ԡ",
"ƥݡȡ",
"ˡå",
"",
"",
#else
		"Magic Mapping",
		"Identify",
		"Slow Monster",
		"Mass Sleep",
		"Teleport Away",
		"Haste Self",
		"Detection True",
		"Identify True",
#endif


		/* Rare Sorcery Spellbooks */
#ifdef JP
"ƥݡȡ٥",
"Ĵ",
"θ",
"*˲*",
"⾤",
"Τ",
"",
"Ϥ",
"",
"ͩβ",
#else
		"Detect Objects and Treasure",
		"Detect Enchantment",
		"Charm Monster",
		"Dimension Door",
		"Sense Minds",
		"Self Knowledge",
		"Teleport Level",
		"Word of Recall",
#endif


	},

	/*** Musou Spellbooks ***/

	{
		/* Common Musou Spellbooks */
#ifdef JP
"϶",
"ε",
"¤",
"䵤",
"Ѳб",
"ŷ",
"ѻ",
"ȩв",
"Ʃǧ",
"ͷ",
#else
		"Stasis",
		"Telekinesis",
		"Explosive Rune",
		"Clairvoyance",
		"Enchant Weapon",
		"Enchant Armour",
		"Alchemy",
		"Globe of Invulnerability"
#endif


#ifdef JP
"β",
"",
"",
"ԡ",
"ﶯ",
"ɶ񶯲",
"",
"",
"ˡγ",
"ʳ",
#else
		"Detect Creatures",
		"First Aid",
		"Detect Doors and Traps",
		"Foraging",
		"Daylight",
		"Animal Taming",
		"Resist Environment",
		"Cure Wounds & Poison",
#endif


		/* Rare Musou Spellbooks */
#ifdef JP
"",
"",
"̵ϲ",
"忩ɻ",
"Ʈγ",
"Ʈη",
"Ǽ٤ο",
"Ȼ¤",
"ε",
"̵",
#else
		"Stone to Mud",
		"Lightning Bolt",
		"Nature Awareness",
		"Frost Bolt",
		"Ray of Sunlight",
		"Entangle",
		"Summon Animal",
		"Herbal Healing",
#endif

	}
};


/*
 * Conversion of plusses to Deadliness to a percentage added to damage.
 * Much of this table is not intended ever to be used, and is included
 * only to handle possible inflation elsewhere. -LM-
 */
byte deadliness_conversion[151] =
{
	  0,
	  5,  10,  14,  18,  22,  26,  30,  33,  36,  39,
	 42,  45,  48,  51,  54,  57,  60,  63,  66,  69,
	 72,  75,  78,  81,  84,  87,  90,  93,  96,  99,
	102, 104, 107, 109, 112, 114, 117, 119, 122, 124,
	127, 129, 132, 134, 137, 139, 142, 144, 147, 149,
	152, 154, 157, 159, 162, 164, 167, 169, 172, 174,
	176, 178, 180, 182, 184, 186, 188, 190, 192, 194,
	196, 198, 200, 202, 204, 206, 208, 210, 212, 214,
	216, 218, 220, 222, 224, 226, 228, 230, 232, 234,
	236, 238, 240, 242, 244, 246, 248, 250, 251, 253,

	255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
	255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
	255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
	255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
	255, 255, 255, 255, 255, 255, 255, 255, 255, 255
};




#ifdef JP
/* ڤؤб */
cptr E_spell_names[MAX_REALM][32] =
{
	/*** Life Spells ***/
	{
		/* Common Life Spellbooks */
		"Detect Evil",
		"Cure Light Wounds",
		"Bless",
		"Remove Fear",
		"Call Light",
		"Detect Traps and Secret Doors",
		"Cure Medium Wounds",
		"Satisfy Hunger",
		"Cure Medium Wounds",
		"Satisfy Hunger",

		"Remove Curse",
		"Cure Poison",   
		"Cure Critical Wounds",
		"Sense Unseen",
		"Holy Orb",
		"Protection from Evil",
		"Healing",
		"Glyph of Warding",
		"Cure Medium Wounds",
		"Satisfy Hunger",

		/* Rare Life Spellbooks */
		"Exorcism",
		"Dispel Curse",
		"Dispel Undead & Demons",
		"Day of the Dove",
		"Dispel Evil",
		"Banish",      
		"Holy Word",
		"Warding True",
		"Cure Medium Wounds",
		"Satisfy Hunger",
	},

	/*** Sorcery Spells ***/

	{
		/* Common Sorcery Spellbooks */
		"Detect Monsters",
		"Phase Door",
		"Detect Doors and Traps",
		"Light Area",
		"Confuse Monster",
		"Teleport",
		"Sleep Monster",
		"Recharging",
		"Sleep Monster",
		"Recharging",

		"Magic Mapping",
		"Identify",
		"Slow Monster",
		"Mass Sleep",
		"Teleport Away",
		"Haste Self",
		"Detection True",
		"Identify True",
		"Detection True",
		"Identify True",

		/* Rare Sorcery Spellbooks */
		"Detect Objects and Treasure",
		"Detect Enchantment",
		"Charm Monster",
		"Dimension Door",
		"Sense Minds",
		"Self Knowledge",
		"Teleport Level",
		"Word of Recall",
		"Teleport Level",
		"Word of Recall",
	},

	/*** Musou Spellbooks ***/

	{
		/* Common Musou Spellbooks */
		"Detect Creatures",
		"First Aid",
		"Detect Doors and Traps",
		"Foraging",
		"Daylight",
		"Animal Taming",
		"Resist Environment",
		"Cure Wounds & Poison",
		"Resist Environment",
		"Cure Wounds & Poison",

		"Stone to Mud",
		"Lightning Bolt",
		"Nature Awareness",
		"Frost Bolt",
		"Ray of Sunlight",
		"Entangle",
		"Summon Animal",
		"Herbal Healing",
		"Resist Environment",
		"Cure Wounds & Poison",

		/* Rare Musou Spellbooks */
		"Door Building",
		"Stair Building",
		"Stone Skin",
		"Resistance True",
		"Animal Friendship",
		"Stone Tell",
		"Wall of Stone",
		"Protect from Corrosion",
		"Resist Environment",
		"Cure Wounds & Poison",
	},
};
#endif
/*
 * Each chest has a certain set of traps, determined by pval
 * Each chest has a "pval" from 1 to the chest level (max 55)
 * If the "pval" is negative then the trap has been disarmed
 * The "pval" of a chest determines the quality of its treasure
 * Note that disarming a trap on a chest also removes the lock.
 */
byte chest_traps[64] =
{
	0,                                      /* 0 == empty */
	(CHEST_POISON),
	(CHEST_LOSE_STR),
	(CHEST_LOSE_CON),
	(CHEST_LOSE_STR),
	(CHEST_LOSE_CON),                       /* 5 == best small wooden */
	0,
	(CHEST_POISON),
	(CHEST_POISON),
	(CHEST_LOSE_STR),
	(CHEST_LOSE_CON),
	(CHEST_POISON),
	(CHEST_LOSE_STR | CHEST_LOSE_CON),
	(CHEST_LOSE_STR | CHEST_LOSE_CON),
	(CHEST_LOSE_STR | CHEST_LOSE_CON),
	(CHEST_SUMMON),                 /* 15 == best large wooden */
	0,
	(CHEST_LOSE_STR),
	(CHEST_LOSE_CON),
	(CHEST_PARALYZE),
	(CHEST_LOSE_STR | CHEST_LOSE_CON),
	(CHEST_SUMMON),
	(CHEST_PARALYZE),
	(CHEST_LOSE_STR),
	(CHEST_LOSE_CON),
	(CHEST_EXPLODE),                        /* 25 == best small iron */
	0,
	(CHEST_POISON | CHEST_LOSE_STR),
	(CHEST_POISON | CHEST_LOSE_CON),
	(CHEST_LOSE_STR | CHEST_LOSE_CON),
	(CHEST_EXPLODE | CHEST_SUMMON),
	(CHEST_PARALYZE),
	(CHEST_POISON | CHEST_SUMMON),
	(CHEST_SUMMON),
	(CHEST_EXPLODE),
	(CHEST_EXPLODE | CHEST_SUMMON), /* 35 == best large iron */
	0,
	(CHEST_SUMMON),
	(CHEST_EXPLODE),
	(CHEST_EXPLODE | CHEST_SUMMON),
	(CHEST_EXPLODE | CHEST_SUMMON),
	(CHEST_POISON | CHEST_PARALYZE),
	(CHEST_EXPLODE),
	(CHEST_EXPLODE | CHEST_SUMMON),
	(CHEST_EXPLODE | CHEST_SUMMON),
	(CHEST_POISON | CHEST_PARALYZE),        /* 45 == best small steel */
	0,
	(CHEST_LOSE_STR | CHEST_LOSE_CON),
	(CHEST_LOSE_STR | CHEST_LOSE_CON),
	(CHEST_POISON | CHEST_PARALYZE | CHEST_LOSE_STR),
	(CHEST_POISON | CHEST_PARALYZE | CHEST_LOSE_CON),
	(CHEST_POISON | CHEST_LOSE_STR | CHEST_LOSE_CON),
	(CHEST_POISON | CHEST_LOSE_STR | CHEST_LOSE_CON),
	(CHEST_POISON | CHEST_PARALYZE | CHEST_LOSE_STR | CHEST_LOSE_CON),
	(CHEST_POISON | CHEST_PARALYZE),
	(CHEST_POISON | CHEST_PARALYZE),        /* 55 == best large steel */
	(CHEST_EXPLODE | CHEST_SUMMON),
	(CHEST_EXPLODE | CHEST_SUMMON),
	(CHEST_EXPLODE | CHEST_SUMMON),
	(CHEST_EXPLODE | CHEST_SUMMON),
	(CHEST_EXPLODE | CHEST_SUMMON),
	(CHEST_EXPLODE | CHEST_SUMMON),
	(CHEST_EXPLODE | CHEST_SUMMON),
	(CHEST_EXPLODE | CHEST_SUMMON),
};


/*
 * Class titles for the player.
 *
 * The player gets a new title every five levels, so each class
 * needs only ten titles total.
 */
cptr player_title[MAX_CLASS][PY_MAX_LEVEL / 5] =
{
	/* Warrior */
	{
#ifdef JP
                "ʼ",
                "ʼ",
                "ʼ",
                "Żʼ",
                "",
                "Ʈ",
                "ͺ",
                "˼",
                "",
                "",
#else
		"Rookie",
		"Soldier",
		"Mercenary",
		"Veteran",
		"Swordsman",
		"Champion",
		"Hero",
		"Baron",
		"Duke",
		"Lord",
#endif

	},

	/* Mage */
	{
#ifdef JP
                "",
                "",                 /*ա*/
                "ѻ",               /*աڥƥ*/
                "ѻ",
                "ѻ",
                "",
                "",
                "ѻ",
                "ץޥ",
                "Ƴ",
#else
		"Apprentice",
		"Trickster",
		"Illusionist",
		"Spellbinder",
		"Evoker",
		"Conjurer",
		"Warlock",
		"Sorcerer",
		"Ipsissimus",
		"Archimage",
#endif

	},

	/* Priest */
	{
#ifdef JP
                "",                 /**/
                "",             /*żԡΡȼΡ*/
                "",
                "",                 /**/
                "һ",               /*ʺɾİƻ*/
                "ʶ",               /*޶*/
                "ʶ",               /*ʶ綵ʶ*/
                "",                 /*׻ʡʺ*/
                "綵",               /*׻ʡ׻Ĺ*/
                "綵",
#else
		"Believer",
		"Acolyte",
		"Adept",
		"Curate",
		"Canon",
		"Priest",
		"High Priest",
		"Cardinal",
		"Inquisitor",
		"Pope",
#endif

	},

	/* Rangers */
	{
#ifdef JP
                "Ȥ",
                "",
                "͸",                         /*͸ĥꡢ廡ʼ*/
                "",
                "׼",
                "Ƴ",
                "õ",                       /*ԡõ*/
                "",
                "Ƭ",
                "",
#else
		"Runner",
		"Strider",
		"Scout",
		"Courser",
		"Tracker",
		"Guide",
		"Pathfinder",
		"Low Ranger",
		"High Ranger",
		"Ranger Lord",
#endif

	},

	/* Paladins */
	{
#ifdef JP
                "ͦ",                 /*ˡ͡ԡͦʿ*/
                "һ",
                "ݸ",
                "ɱҼ",
                "Ҽ",
                "",
                "ŵ",
                "",
                "",
                "Ĺ",
#else
		"Gallant",
		"Keeper",
		"Protector",
		"Defender",
		"Warder",
		"Knight",
		"Guardian",
		"Low Paladin",
		"High Paladin",
		"Paladin Lord",
#endif

	},

	/* Warrior-Mage */
	{
#ifdef JP
		"",
		"",			/*ա*/
		"",
		"Żʼ",
		"ʼ",
		"Ʈ",
		"˼",
		"Ѹ",
		"Ʈѻ",
		"ѷ",
#else
		"Novice",
		"Apprentice",
		"Journeyman",
		"Veteran",
		"Enchanter",
		"Champion",
		"Mage-Hero",
		"Baron Mage",
		"Battlemage",
		"Wizard Lord",
#endif

	},

	/* Mindcrafter */
	{
#ifdef JP
		"",
		"",
		"",
		"ã",
		"ۻ",
		"ѻ",
		"å",
		"˥å",
		"ѡ",
		"Ƴ",
#else
		"Trainee",
		"Acolyte",
		"Adept",
		"Immaculate",
		"Contemplator",
		"Mentalist",
		"Psychic",
		"Psionicist",
		"Esper",
		"Mindmaster",
#endif

	},

};



#ifdef JP
cptr E_player_title[MAX_CLASS][PY_MAX_LEVEL / 5] =
{
	/* Warrior */
	{
		"Rookie",
		"Soldier",
		"Mercenary",
		"Veteran",
		"Swordsman",
		"Champion",
		"Hero",
		"Baron",
		"Duke",
		"Lord",
	},

	/* Mage */
	{
		"Apprentice",
		"Trickster",
		"Illusionist",
		"Spellbinder",
		"Evoker",
		"Conjurer",
		"Warlock",
		"Sorcerer",
		"Ipsissimus",
		"Archimage",
	},

	/* Priest */
	{
		"Believer",
		"Acolyte",
		"Adept",
		"Curate",
		"Canon",
		"Priest",
		"High Priest",
		"Cardinal",
		"Inquisitor",
		"Pope",
	},

	/* Rangers */
	{
		"Runner",
		"Strider",
		"Scout",
		"Courser",
		"Tracker",
		"Guide",
		"Pathfinder",
		"Low Ranger",
		"High Ranger",
		"Ranger Lord",
	},

	/* Paladins */
	{
		"Gallant",
		"Keeper",
		"Protector",
		"Defender",
		"Warder",
		"Knight",
		"Guardian",
		"Low Paladin",
		"High Paladin",
		"Paladin Lord",
	},

	/* Warrior-Mage */
	{
		"Novice",
		"Apprentice",
		"Journeyman",
		"Veteran",
		"Enchanter",
		"Champion",
		"Mage-Hero",
		"Baron Mage",
		"Battlemage",
		"Wizard Lord",
	},

	/* Mindcrafter */
	{
		"Trainee",
		"Acolyte",
		"Adept",
		"Immaculate",
		"Contemplator",
		"Mentalist",
		"Psychic",
		"Psionicist",
		"Esper",
		"Mindmaster",
	},

};
#endif
/*
 * Hack -- the "basic" color names (see "TERM_xxx")
 */
cptr color_names[16] =
{
#ifdef JP
        "",
        "",
        "ĳ",
        "",
        "",
        "",
        "",
        "ῧ",
        "",
        "ĳ",
        "",
        "",
        "뤤",
        "뤤",
        "뤤",
        "ῧ",
#else
	"Dark",
	"White",
	"Slate",
	"Orange",
	"Red",
	"Green",
	"Blue",
	"Umber",
	"Light Dark",
	"Light Slate",
	"Violet",
	"Yellow",
	"Light Red",
	"Light Green",
	"Light Blue",
	"Light Umber",
#endif

};


/*
 * Abbreviations of healthy stats
 */
cptr stat_names[6] =
{
#ifdef JP
        " :", "ǽ :", " :", " :", "ѵ :", "̥ :"
#else
	"STR: ", "INT: ", "WIS: ", "DEX: ", "CON: ", "CHR: "
#endif

};

/*
 * Abbreviations of damaged stats
 */
cptr stat_names_reduced[6] =
{
#ifdef JP
        "x:", "ǽx:", "x:", "x:", "ѵx:", "̥x:"
#else
	"Str: ", "Int: ", "Wis: ", "Dex: ", "Con: ", "Chr: "
#endif

};


/*
 * Certain "screens" always use the main screen, including News, Birth,
 * Dungeon, Tomb-stone, High-scores, Macros, Colors, Visuals, Options.
 *
 * Later, special flags may allow sub-windows to "steal" stuff from the
 * main window, including File dump (help), File dump (artifacts, uniques),
 * Character screen, Small scale map, Previous Messages, Store screen, etc.
 *
 * The "ctrl-i" (tab) command flips the "Display inven/equip" and "Display
 * equip/inven" flags for all windows.
 *
 * The "ctrl-g" command (or pseudo-command) should perhaps grab a snapshot
 * of the main screen into any interested windows.
 */
cptr window_flag_desc[32] =
{
#ifdef JP
        "ʪ/",
#else
	"Display inven/equip",
#endif

#ifdef JP
        "/ʪ",
#else
	"Display equip/inven",
#endif

#ifdef JP
        "ʸ",
#else
	"Display spell list",
#endif

#ifdef JP
        "饯",
#else
	"Display character",
#endif

	NULL,
	NULL,
#ifdef JP
        "å",
#else
	"Display messages",
#endif

#ifdef JP
        "󥸥ο",
#else
	"Display overhead view",
#endif

#ifdef JP
        "󥹥λפ",
#else
	"Display monster recall",
#endif

#ifdef JP
        "ƥξܺ",
#else
	"Display object recall",
#endif

#ifdef JP
        "ʬμϤɽ", 
#else
	"Display dungeon view",
#endif

#ifdef JP
        "ǰ",
#else
	"Display snap-shot",
#endif

	NULL,
	NULL,
#ifdef JP
        "ܡå",
#else
	"Display borg messages",
#endif

#ifdef JP
        "ܡơ",
#else
	"Display borg status",
#endif

	NULL,
	NULL,
	NULL,
	NULL,
	NULL,
	NULL,
	NULL,
	NULL,
	NULL,
	NULL,
	NULL,
	NULL,
	NULL,
	NULL,
	NULL,
	NULL
};


/*
 * Available Options
 *
 * Option Screen Sets:
 *
 *      Set 1: User Interface
 *      Set 2: Disturbance
 *      Set 3: Inventory
 *      Set 4: Game Play
 *
 * Note that bits 28-31 of set 0 are currently unused.
 */
option_type option_info[] =
{
	/*** User-Interface ***/

#ifdef JP
	{ &rogue_like_commands,         FALSE,  1,      0, 0,
     "rogue_like_commands",  "֤Ѥ" },
#else
	{ &rogue_like_commands,         FALSE, 1, 0, 0,
	"rogue_like_commands",          "Rogue-like commands" },
#endif


#ifdef JP
	{ &quick_messages,              TRUE,  1,      0, 1,
     "quick_messages",  "ååѤ" },
#else
	{ &quick_messages,              TRUE, 1, 0, 1,
	"quick_messages",               "Activate quick messages" },
#endif


#ifdef JP
	{ &other_query_flag,            FALSE,  1,      0, 2,
	"other_query_flag",             "͡ʻˤĤƻ˳ǧ" },
#else
	{ &other_query_flag,            FALSE, 1, 0, 2,
	"other_query_flag",             "Prompt for various information" },
#endif


#ifdef JP
	{ &carry_query_flag,            FALSE,  1,      0, 3,
	"carry_query_flag",  "ƥ򽦤˳ǧ" },
#else
	{ &carry_query_flag,            FALSE, 1, 0, 3,
	"carry_query_flag",             "Prompt before picking things up" },
#endif


#ifdef JP
	{ &use_old_target,              FALSE,  1,      0, 4,
     "use_old_target",  "˰ΥåȤꤹ" },
#else
	{ &use_old_target,              FALSE, 1, 0, 4,
	"use_old_target",               "Use old target by default" },
#endif


#ifdef JP
	{ &always_pickup,               FALSE,   1,      0, 5,
     "always_pickup",  "˥ƥ򽦤" },
#else
	{ &always_pickup,               TRUE, 1, 0, 5,
	"always_pickup",                "Pick things up by default" },
#endif


#ifdef JP
	{ &always_repeat,               TRUE,   1,      0, 6,
     "always_repeat",  "ޥɼư֤" },
#else
	{ &always_repeat,               TRUE, 1, 0, 6,
	"always_repeat",                "Repeat obvious commands" },
#endif


#ifdef JP
	{ &depth_in_feet,               FALSE,  1,      0, 7,
     "depth_in_feet",  "󥸥οեȤɽ" },
#else
	{ &depth_in_feet,               FALSE, 1, 0, 7,
	"depth_in_feet",                "Show dungeon level in feet" },
#endif


#ifdef JP
	{ &stack_force_notes,           TRUE,  1,      0, 8,
     "stack_force_notes",  "ۤʤäΥƥޤȤ" },
#else
	{ &stack_force_notes,           TRUE, 1, 0, 8,
	"stack_force_notes",            "Merge inscriptions when stacking" },
#endif


#ifdef JP
	{ &stack_force_costs,           TRUE,  1,      0, 9,
     "stack_force_costs",  "ۤʤɽΥƥޤȤ" },
#else
	{ &stack_force_costs,           FALSE, 1, 0, 9,
	"stack_force_costs",            "Merge discounts when stacking" },
#endif


#ifdef JP
	{ &show_labels,                 TRUE,   1,      0, 10,
     "show_labels",  "ɽ" },
#else
	{ &show_labels,                 TRUE, 1, 0, 10,
	"show_labels",                  "Show labels in object listings" },
#endif


#ifdef JP
	{ &show_weights,                TRUE,  1,      0, 11,
     "show_weights",  "ƥǽ̤ɽ" },
#else
	{ &show_weights,                TRUE, 1, 0, 11,
	"show_weights",                 "Show weights in object listings" },
#endif


#ifdef JP
	{ &show_inven_graph,            TRUE,  1,      2, 0,  /*ܸѹ*/
	"show_inven_graph",             "ʪ򥰥եɽ" },
#else
	{ &show_inven_graph,            FALSE, 1, 2, 0,
	"show_inven_graph",             "Show graphics in inventory list" },
#endif


#ifdef JP
	{ &show_equip_graph,            TRUE,  1,      2, 1,  /*ܸѹ*/
	"show_equip_graph",             "򥰥եɽ" },
#else
	{ &show_equip_graph,            FALSE, 1, 2, 1,
	"show_equip_graph",             "Show graphics in equipment list" },
#endif


#ifdef JP
	{ &show_store_graph,            TRUE,  1,      2, 2,  /*ܸѹ*/
	"show_store_graph",             "Źʪ򥰥եɽ" },
#else
	{ &show_store_graph,            FALSE, 1, 2, 2,
	"show_store_graph",             "Show graphics in stores" },
#endif


#ifdef JP
	{ &show_choices,                TRUE,  1,      0, 12,
     "show_choices",  "ʪ/ɥ򥢥ƥɽ" },
#else
	{ &show_choices,                TRUE, 1, 0, 12,
	"show_choices",                 "Show choices in certain sub-windows" },
#endif


#ifdef JP
	{ &show_details,                TRUE,  1,      0, 13,
     "show_details",  "󥹥λפФܤɽ" },
#else
	{ &show_details,                TRUE, 1, 0, 13,
	"show_details",                 "Show details in certain sub-windows" },
#endif


#ifdef JP
	{ &ring_bell,                   FALSE,   1,      0, 14,
     "ring_bell",  "ӡײĤ餹(顼ʤ)" },
#else
	{ &ring_bell,                   FALSE, 1, 0, 14,
	"ring_bell",                    "Audible bell (on errors, etc)" },
#endif


#ifdef JP
	{ &use_color,                   TRUE,   1,      0, 15,
	"use_color",                    "ǽʤ饫顼ɽ٤" },
#else
	{ &use_color,                   TRUE, 1, 0, 15,
	"use_color",                    "Use color if possible (slow)" },
#endif



	/*** Disturbance ***/

#ifdef JP
	{ &find_ignore_stairs,          FALSE,   2,      0, 16,
	"find_ignore_stairs",           "ʤ̲᤹" },
#else
	{ &find_ignore_stairs,          FALSE, 2, 0, 16,
	"find_ignore_stairs",           "Run past stairs" },
#endif


#ifdef JP
	{ &find_ignore_doors,           TRUE,   2,      0, 17,
	"find_ignore_doors",            "ɥ̲᤹" },
#else
	{ &find_ignore_doors,           TRUE, 2, 0, 17,
	"find_ignore_doors",            "Run through open doors" },
#endif


#ifdef JP
	{ &find_cut,                    FALSE,   2,      0, 18,
	"find_cut",                     "ΤζʤѤ̲᤹" },
#else
	{ &find_cut,                    FALSE, 2, 0, 18,
	"find_cut",                     "Run past known corners" },
#endif


#ifdef JP
	{ &find_examine,                TRUE,   2,      0, 19,
	"find_examine",                 "ʤѤ⤷ʤ̲᤹" },
#else
	{ &find_examine,                TRUE, 2, 0, 19,
	"find_examine",                 "Run into potential corners" },
#endif


#ifdef JP
	{ &disturb_move,                TRUE,   2,      0, 20,
     "disturb_move",  "ɤΥ󥹥ưƤưߤ" },
#else
	{ &disturb_move,                TRUE, 2, 0, 20,
	"disturb_move",                 "Disturb whenever any monster moves" },
#endif


#ifdef JP
	{ &disturb_near,                TRUE,   2,      0, 21,
     "disturb_near",  "볦󥹥ưưߤ" },
#else
	{ &disturb_near,                TRUE, 2, 0, 21,
	"disturb_near",                 "Disturb whenever viewable monster moves" },
#endif


#ifdef JP
	{ &disturb_panel,               TRUE,   2,      0, 22,
     "disturb_panel",  "̥˹ưߤ" },
#else
	{ &disturb_panel,               TRUE, 2, 0, 22,
	"disturb_panel",                "Disturb whenever map panel changes" },
#endif


#ifdef JP
	{ &disturb_state,               TRUE,   2,      0, 23,
     "disturb_state",  "ʬΥơѲ˹ưߤ" },
#else
	{ &disturb_state,               TRUE, 2, 0, 23,
	"disturb_state",                "Disturb whenever player state changes" },
#endif


#ifdef JP
	{ &disturb_minor,               TRUE,   2,      0, 24,
     "disturb_minor",  "٤ʤȤƤưߤ" },
#else
	{ &disturb_minor,               TRUE, 2, 0, 24,
	"disturb_minor",                "Disturb whenever boring things happen" },
#endif


#ifdef JP
	{ &alert_hitpoint,              FALSE,  2,      0, 26,
     "alert_hitpoint",  "ҥåȥݥȤηٹ˥ӡפĤ餹" },
#else
	{ &alert_hitpoint,              FALSE, 2, 0, 26,
	"alert_hitpoint",               "Alert user to critical hitpoints" },
#endif


#ifdef JP
	{ &alert_failure,               FALSE,  2,      0, 27,
     "alert_failure",  "͡ʥߥٹ𤹤Ȥ˥ӡפĤ餹" },
#else
	{ &alert_failure,               FALSE, 2, 0, 27,
	"alert_failure",                "Alert user to various failures" },
#endif



	/*** Game-Play ***/

#ifdef JP
	{ &auto_haggle,                 FALSE,  3,      1, 0,
     "auto_haggle",  "ŹڤĤ򤷤ʤ" },
#else
	{ &auto_haggle,                 FALSE, 3, 1, 0,
	"auto_haggle",                  "Auto-haggle in stores" },
#endif


#ifdef JP
	{ &auto_scum,                   FALSE,  3,      1, 1,
     "auto_scum",  "ʷϵư깥" },
#else
	{ &auto_scum,                   FALSE, 3, 1, 1,
	"auto_scum",                    "Auto-scum for good levels" },
#endif


#ifdef JP
	{ &stack_allow_items,           TRUE,   3,      1, 2,
	"stack_allow_items",            "ƱɶޤȤ" },
#else
	{ &stack_allow_items,           TRUE, 3, 1, 2,
	"stack_allow_items",            "Allow weapons and armor to stack" },
#endif


#ifdef JP
	{ &stack_allow_wands,           TRUE,   3,      1, 3,
	"stack_allow_wands",            "ƱΥ/å/åɤޤȤ" },
#else
	{ &stack_allow_wands,           TRUE, 3, 1, 3,
	"stack_allow_wands",            "Allow wands/staffs/rods to stack" },
#endif


#ifdef JP
	{ &expand_look,                 TRUE,  3,      1, 4,
     "expand_look",  "ֲĴ٤ץޥɤĥ" },
#else
	{ &expand_look,                 TRUE, 3, 1, 4,
	"expand_look",                  "Expand the power of the look command" },
#endif


#ifdef JP
	{ &expand_list,                 TRUE,  3,      1, 5,
     "expand_list",  "ְץޥɤĥ" },
#else
	{ &expand_list,                 TRUE, 3, 1, 5,
	"expand_list",                  "Expand the power of the list commands" },
#endif


#ifdef JP
	{ &view_perma_grids,            TRUE,   3,      1, 6,
     "view_perma_grids",  "뤤ϤΤޤޤˤ" },
#else
	{ &view_perma_grids,            TRUE, 3, 1, 6,
	"view_perma_grids",             "Map remembers all perma-lit grids" },
#endif


#ifdef JP
	{ &view_torch_grids,            FALSE,  3,      1, 7,
     "view_torch_grids",  "ǾȤ餷ϤΤޤޤˤ" },
#else
	{ &view_torch_grids,            FALSE, 3, 1, 7,
	"view_torch_grids",             "Map remembers all torch-lit grids" },
#endif


#ifdef JP
	{ &dungeon_align,               TRUE,   3,      1, 8,
     "dungeon_align",  "󥸥򤽤" },
#else
	{ &dungeon_align,               TRUE, 3, 1, 8,
	"dungeon_align",                "Generate dungeons with aligned rooms" },
#endif


#ifdef JP
	{ &dungeon_stair,               TRUE,   3,      1, 9,
     "dungeon_stair",  "ʤĤʤƥ󥸥" },
#else
	{ &dungeon_stair,               TRUE, 3, 1, 9,
	"dungeon_stair",                "Generate dungeons with connected stairs" },
#endif


#ifdef JP
	{ &flow_by_sound,               FALSE,  3,      1, 10,
     "flow_by_sound",  "󥹥ϸߤΰ֤פ(ĶŤ)" },
#else
	{ &flow_by_sound,               FALSE, 3, 1, 10,
	"flow_by_sound",                "Monsters chase current location (v.slow)" },
#endif


#ifdef JP
	{ &flow_by_smell,               FALSE,  3,      1, 11,
     "flow_by_smell",  "󥹥ϺǶΰ֤פ(ĶŤ)" },
#else
	{ &flow_by_smell,               FALSE, 3, 1, 11,
	"flow_by_smell",                "Monsters chase recent locations (v.slow)" },
#endif


#ifdef JP
	{ &smart_learn,                 FALSE,  3,      1, 14,
     "smart_learn",  "󥹥ϼԤؽ" },
#else
	{ &smart_learn,                 FALSE, 3, 1, 14,
	"smart_learn",                  "Monsters learn from their mistakes" },
#endif


#ifdef JP
	{ &smart_cheat,                 FALSE,  3,      1, 15,
     "smart_cheat",  "󥹥ϥץ쥤䡼μߤͤ" },
#else
	{ &smart_cheat,                 FALSE, 3, 1, 15,
	"smart_cheat",                  "Monsters exploit players weaknesses" },
#endif



	/*** Efficiency ***/

#ifdef JP
	{ &view_reduce_lite,            FALSE,  4,      1, 16,
     "view_reduce_lite",  "äƤȤȾ¤򸺾" },
#else
	{ &view_reduce_lite,            FALSE, 4, 1, 16,
	"view_reduce_lite",             "Reduce lite-radius when running" },
#endif


#ifdef JP
	{ &view_reduce_view,            FALSE,  4,      1, 17,
	"view_reduce_view",             "Ǥϻ򶹤" },
#else
	{ &view_reduce_view,            FALSE, 4, 1, 17,
	"view_reduce_view",             "Reduce view-radius in town" },
#endif


#ifdef JP
	{ &avoid_abort,                 FALSE,  4,      1, 18,
     "avoid_abort",  "Ϣ³ޥɤϥϤǤʤ" },
#else
	{ &avoid_abort,                 FALSE, 4, 1, 18,
	"avoid_abort",                  "Avoid checking for user abort" },
#endif


#ifdef JP
	{ &avoid_other,                 FALSE,  4,      1, 19,
     "avoid_other",  "󥹥̤ʿѤʤ" },
#else
	{ &avoid_other,                 FALSE, 4, 1, 19,
	"avoid_other",                  "Avoid processing special colors" },
#endif


#ifdef JP
	{ &flush_failure,               TRUE,   4,      1, 20,
     "flush_failure",  "͡ʥߥȯϤ򥯥ꥢ" },
#else
	{ &flush_failure,               TRUE, 4, 1, 20,
	"flush_failure",                "Flush input on various failures" },
#endif


#ifdef JP
	{ &flush_disturb,               FALSE,  4,      1, 21,
     "flush_disturb",  "㳲ȯϤ򥯥ꥢ" },
#else
	{ &flush_disturb,               FALSE, 4, 1, 21,
	"flush_disturb",                "Flush input whenever disturbed" },
#endif


#ifdef JP
	{ &flush_command,               FALSE,  4,      1, 22,
	"flush_command",                "ޥ˾Ϥ򥯥ꥢ" },
#else
	{ &flush_command,               FALSE, 4, 1, 22,
	"flush_command",                "Flush input before every command" },
#endif


#ifdef JP
	{ &fresh_before,                TRUE,   4,      1, 23,
     "fresh_before",  "ޥ˲̤褹" },
#else
	{ &fresh_before,                TRUE, 4, 1, 23,
	"fresh_before",                 "Flush output before every command" },
#endif


#ifdef JP
	{ &fresh_after,                 FALSE,  4,      1, 24,
     "fresh_after",  "ޥɸ˲̤褹" },
#else
	{ &fresh_after,                 FALSE, 4, 1, 24,
	"fresh_after",                  "Flush output after every command" },
#endif


#ifdef JP
	{ &fresh_message,               FALSE,  4,      1, 25,
	"fresh_message",                "åθ˲̤褹" },
#else
	{ &fresh_message,               FALSE, 4, 1, 25,
	"fresh_message",                "Flush output after every message" },
#endif


#ifdef JP
	{ &compress_savefile,           TRUE,   4,      1, 26,
     "compress_savefile",  "֡եΥå򰵽̤" },
#else
	{ &compress_savefile,           TRUE, 4, 1, 26,
	"compress_savefile",            "Compress messages in savefiles" },
#endif


#ifdef JP
	{ &hilite_player,               TRUE,  4,      1, 27,
     "hilite_player",  "ץ쥤䡼˥碌" },
#else
	{ &hilite_player,               TRUE, 4, 1, 27,
	"hilite_player",                "Hilite the player with the cursor" },
#endif


#ifdef JP
	{ &view_yellow_lite,            FALSE,  4,      1, 28,
     "view_yellow_lite",  "ϰϤ̤ʿɽ" },
#else
	{ &view_yellow_lite,            FALSE, 4, 1, 28,
	"view_yellow_lite",             "Use special colors for torch-lit grids" },
#endif


#ifdef JP
	{ &view_bright_lite,            FALSE,  4,      1, 29,
     "view_bright_lite",  "볦ϰϤ̤ʿɽ" },
#else
	{ &view_bright_lite,            FALSE, 4, 1, 29,
	"view_bright_lite",             "Use special colors for 'viewable' grids" },
#endif


#ifdef JP
	{ &view_granite_lite,           FALSE,  4,      1, 30,
     "view_granite_lite",  "ɤ̤ʿɽ(Ť)" },
#else
	{ &view_granite_lite,           FALSE, 4, 1, 30,
	"view_granite_lite",            "Use special colors for wall grids (slow)" },
#endif


#ifdef JP
	{ &view_special_lite,           FALSE,  4,      1, 31,
     "view_special_lite",  "̤ʿɽ(Ť)" },
#else
	{ &view_special_lite,           FALSE, 4, 1, 31,
	"view_special_lite",            "Use special colors for floor grids (slow)" },
#endif



	/*** ZAngband options ***/

#ifdef JP
	{ &disturb_other,               TRUE,   5,      0, 25,
     "disturb_other",  "͡ʤȤưߤ" },
#else
	{ &disturb_other,               TRUE, 5, 0, 25,
	"disturb_other",                "Disturb whenever random things happen" },
#endif


#ifdef JP
	{ &last_words,                  TRUE,   5,      0, 28,
	"last_words",                   "饯Τ" },
#else
	{ &last_words,                  TRUE, 5, 0, 28,
	"last_words",                   "Get last words when the character dies" },
#endif


#ifdef JP
	{ &speak_unique,                TRUE,   5,      0, 29,
	"speak_unique",                 "Źˡ󥹥٤" },
#else
	{ &speak_unique,                TRUE, 5, 0, 29,
	"speak_unique",                 "Allow shopkeepers and uniques to speak" },
#endif


#ifdef JP
	{ &small_levels,                TRUE,   5,      0, 30,
	"small_levels",                 "˾եǽˤ" },
#else
	{ &small_levels,                TRUE, 5, 0, 30,
	"small_levels",                 "Allow unusually small dungeon levels" },
#endif


#ifdef JP
	{ &always_small_levels,         FALSE,   5,      2, 3,
	"always_small_levels",          "˾ե" },
#else
	{ &always_small_levels,         FALSE, 5, 2, 3,
	"always_small_levels",          "Always create unusually small dungeon levels" },
#endif


#ifdef JP
	{ &empty_levels,                TRUE,   5,      0, 31,
       "empty_levels",                 "äݤΡ֥꡼ʡץ٥ǽˤ" },
#else
	{ &empty_levels,                TRUE, 5, 0, 31,
	"empty_levels",                 "Allow empty 'arena' levels" },
#endif


#ifdef JP
	{ &player_symbols,              FALSE,   5,      1, 13,
	"player_symbols",               "ץ쥤䡼̤ʵɽ"},
#else
	{ &player_symbols,              FALSE, 5, 1, 13,
	"player_symbols",               "Use special symbols for the player char"},
#endif


#ifdef JP
	{ &equippy_chars,               TRUE,  5,      1, 12,
	"equippy_chars",                "ơʸɽ" },
#else
	{ &equippy_chars,               TRUE, 5, 1, 12,
	"equippy_chars",                "Display 'equippy' chars" },
#endif


#ifdef JP
	{ &skip_mutations,              FALSE, 5, 5, 0,
	"skip_mutations",               "'C'ޥɤѰۤɽʤ" },
#else
	{ &skip_mutations,              FALSE, 5, 5, 0,
	"skip_mutations",               "Skip mutations in 'C'haracter Display" },
#endif


#ifdef JP
	{ &plain_descriptions,          TRUE , 5, 5, 1,  /*ܸѹ*/
	"plain_descriptions",           "ƥεҤάˤ" },
#else
	{ &plain_descriptions,          FALSE, 5, 5, 1,
	"plain_descriptions",           "Plain object descriptions" },
#endif


#ifdef JP
	{ &stupid_monsters,             FALSE, 5, 5, 2,
	"stupid_monsters",              "󥹥ȴʹưȤ" },
#else
	{ &stupid_monsters,             FALSE, 5, 5, 2,
	"stupid_monsters",              "Monsters behave stupidly" },
#endif


#ifdef JP
	{ &auto_destroy,                FALSE, 5, 5, 3,
	"auto_destroy",                 "̵͡פʥƥ˲ǧʤ" },
#else
	{ &auto_destroy,                FALSE, 5, 5, 3,
	"auto_destroy",                 "No query to destroy known worthless items" },
#endif


#ifdef JP
	{ &wear_confirm,                FALSE, 5,5, 4,
	"confirm_wear",                 "줿ʪǧ" },
#else
	{ &wear_confirm,                FALSE, 5, 5, 4,
	"confirm_wear",                 "Confirm to wear/wield known cursed items" },
#endif


#ifdef JP
	{ &confirm_stairs,              FALSE, 5, 5, 5,
	"confirm_stairs",               "̤γ˹Ԥǧ" },
#else
	{ &confirm_stairs,              FALSE, 5, 5, 5,
	"confirm_stairs",               "Prompt before exiting a dungeon level" },
#endif


#ifdef JP
	{ &disturb_pets,                FALSE, 5, 5, 6,
	"disturb_pets",                 "볦ˤڥåȤưưߤ" },
#else
	{ &disturb_pets,                FALSE, 5, 5, 6,
	"disturb_pets",                 "Disturb when visible pets move" },
#endif


#ifdef ALLOW_EASY_OPEN
#ifdef JP
	{ &easy_open,                   TRUE, 5,5,7,
	"easy_open",                    "ưŪ˥ɥ򳫤" },
#else
	{ &easy_open,                   FALSE, 5, 5, 7,
	"easy_open",                    "Automatically open doors" },
#endif

#endif /* ALLOW_EASY_OPEN */

#ifdef ALLOW_EASY_DISARM
#ifdef JP
	{ &easy_disarm,                   TRUE, 5,5,8,
	"easy_disarm",                    "ưŪ櫤" },
#else
	{ &easy_disarm,                 FALSE, 5, 5, 8,
	"easy_disarm",                  "Automatically disarm traps" },
#endif

#endif /* ALLOW_EASY_DISARM */

#ifdef ALLOW_EASY_FLOOR /* TNB */
	{ &easy_floor,                  FALSE, 5, 5, 9,
#ifdef JP
	"easy_floor",                   "ʣƥˤ" },
#else
	"easy_floor",                   "Display floor stacks in a list" },
#endif
#endif /* ALLOW_EASY_FLOOR -- TNB */

#ifdef JP
	{ &use_command,                 FALSE,  5, 5, 10,
	"use_command",                  "ֻȤ(a)ץޥɤͭˤ" },
#else
	{ &use_command,                 FALSE, 5, 5, 10,
	"use_command",                  "Allow unified use command" },
#endif


#ifdef JP
        { &center_player,               FALSE,  5, 5, 11,
      "center_player",                "˥ץ쥤䡼濴֤(*٤*)" },
#else
	{ &center_player,               FALSE, 5, 5, 11,
	"center_player",                "Always center on the player (*slow*)" },
#endif


#ifdef JP
       { &avoid_center,                FALSE,  5, 5, 12,
       "avoid_center",                 "äƤ濴֤ʤ" },
#else
	{ &avoid_center,                FALSE, 5, 5, 12,
	"avoid_center",                 "Avoid centering while running" },
#endif


	{ &pillar_tunnels,              FALSE, 5, 5, 13,
#ifdef JP
	"pillar_tunnels",               "Τϩ" },
#else
	"pillar_tunnels",               "Allow pillared tunnels in the dungeon" },
#endif


#ifdef JP
	{ &vanilla_town,                FALSE, 6,6,0,
	"vanilla_town",                 "Ĥγ/Ȥȹʤ" },
#else
	{ &vanilla_town,                FALSE, 6, 6, 0,
	"vanilla_town",                 "Use 'vanilla' town without quests and wilderness" },
#endif


#ifdef JP
	{ &lite_town,                   FALSE, 6,6,1,
	"lite_town",                    "Ϥʳ/ʤ" },
#else
	{ &lite_town,                   FALSE, 6, 6, 1,
	"lite_town",                    "Use 'lite' town without a wilderness" },
#endif


#ifdef JP
	{ &ironman_shops,               FALSE, 6,6,2,
	"ironman_shops",                "ŴѡŹѤʤ" },
#else
	{ &ironman_shops,               FALSE, 6, 6, 2,
	"ironman_shops",                "Stores are permanently closed" },
#endif


#ifdef JP
	{ &ironman_small_levels,        FALSE, 6,6,3,
	"ironman_small_levels",         "Ŵѡ˾˾ե" },
#else
	{ &ironman_small_levels,        FALSE, 6, 6, 3,
	"ironman_small_levels",         "Always create unusually small dungeon levels" },
#endif


#ifdef JP
	{ &ironman_downward,            FALSE, 6,6,4,
	"ironman_downward",             "Ŵѡ˵ԤȾ곬ʤʤ" },
#else
	{ &ironman_downward,            FALSE, 6, 6, 4,
	"ironman_downward",             "Don't allow climbing upwards/recalling" },
#endif


#ifdef JP
	{ &ironman_autoscum,            FALSE, 6,6,5,
	"ironman_autoscum",             "Ŵѡ˾˳ʷϵư깥ߤ" },
#else
	{ &ironman_autoscum,            FALSE, 6, 6, 5,
	"ironman_autoscum",             "Permanently enable the autoscummer" },
#endif


#ifdef JP
	{ &ironman_hard_quests,         FALSE, 6,6,6,
	"ironman_hard_quests",          "ŴѡɲåȤǥ󥹥褹" },
#else
	{ &ironman_hard_quests,         FALSE, 6, 6, 6,
	"ironman_hard_quests",          "Quest monsters get reinforcements" },
#endif


#ifdef JP
       { &ironman_empty_levels,        FALSE, 6,6,8,
       "ironman_empty_levels",         "Ŵѡ˾˶äݤΥ꡼ʥ٥" },
#else
	{ &ironman_empty_levels,        FALSE, 6, 6, 8,
	"ironman_empty_levels",         "Always create empty 'arena' levels" },
#endif


#ifdef JP
       { &terrain_streams,             TRUE, 6,6,9,
       "terrain_streams",              "俹ʤɤ󥸥" },
#else
	{ &terrain_streams,             TRUE, 6, 6, 9,
	"terrain_streams",              "Create terrain 'streamers' in the dungeon" },
#endif


#ifdef JP
       { &munchkin_death,              FALSE, 6,6,11,
       "munchkin_death",               "ʤ˻֤뤫ǧ" },
#else
	{ &munchkin_death,              FALSE, 6, 6, 11,
	"munchkin_death",               "Ask for saving death" },
#endif


#if 0
	{ &munchkin_rings,              FALSE, 6, 6, 17,
#ifdef JP
"munchkin_rings",						"ʤ˻ؤ" },
#else
	"munchkin_rings",               "Allow multiple rings" },
#endif

#endif

#ifdef JP
       { &ironman_rooms,               FALSE, 6,6,12,
       "ironman_rooms",                "Ŵѡ˾̤Ǥʤ" },
#else
	{ &ironman_rooms,               FALSE, 6, 6, 12,
	"ironman_rooms",                "Always generate very unusual rooms" },
#endif


	{ &ironman_nightmare,           FALSE, 6, 6, 18,
#ifdef JP
 "ironman_nightmare",			  "Ŵѡ˰̴⡼(ԾǤ)" },
#else
	 "ironman_nightmare",           "Nightmare mode (this isn't even remotely fair!)" },
#endif


#ifdef JP
       { &maximize_mode,               TRUE,  6,6,13,
       "maximize_mode",                "粽⡼ɻ" },
#else
	{ &maximize_mode,               TRUE, 6, 6, 13,
	"maximize_mode",                "Maximize stats" },
#endif


#ifdef JP
       { &preserve_mode,               TRUE,  6,6,14,
       "preserve_mode",                "¸⡼ɻ" },
#else
	{ &preserve_mode,               TRUE, 6, 6, 14,
	"preserve_mode",                "Preserve artifacts" },
#endif


#ifdef JP
       { &autoroller,                  TRUE,  6,6,15,
       "autoroller",                   "ȥ顼" },
#else
	{ &autoroller,                  TRUE, 6, 6, 15,
	"autoroller",                   "Specify 'minimal' stats" },
#endif


	{ &point_based,                 FALSE, 6, 6, 16,
#ifdef JP
	"point_based",                 "ݥȿʬǥ饯" },
#else
	"point_based",                 "Generate character using a point system" },
#endif



	/*** Object auto-destruction ***/

#ifdef JP
        { &destroy_worthless,           FALSE, 7, 7, 0,
        "destroy_worthless",            "̵ͤȽƤ륢ƥưŪ˲" },
#else
	{ &destroy_worthless,           FALSE, 7, 7, 0,
	"destroy_worthless",            "Auto-destroy known worthless items" },
#endif



	/*** Stacking ***/

#ifdef JP
	{ &testing_stack,               TRUE,  255, 7, 30,
     "testing_stack",  "ʣƥ֤" },
#else
	{ &testing_stack,               TRUE, 255, 7, 30,
	"testing_stack",                "Allow objects to stack on floor" },
#endif


#ifdef JP
	{ &testing_carry,               TRUE,  255, 7, 31,
     "testing_carry",  "󥹥ƥ򱿤" },
#else
	{ &testing_carry,               TRUE, 255, 7, 31,
	"testing_carry",                "Allow monsters to carry objects" },
#endif


	{ &take_notes,                  FALSE, 3, 7, 28,
#ifdef JP
	"take_notes",                   "ե˵Ͽ" },
#else
	"take_notes",                   "Allow notes to be appended to a file" },
#endif


	{ &auto_notes,                  FALSE, 3, 7, 27,
#ifdef JP
	"auto_notes",                   "ưŪ˽פʽΥϿ" },
#else
	"auto_notes",                   "Automatically note important events" },
#endif



#ifdef JP
	{ &always_show_list,               TRUE,  99, 4, 0,
     "always_show_list",  "ˤϾ˰ɽ" },

	{ &powerup_home,               FALSE,  99,4,3,
     "powerup_home",  "椬Ȥĥ" },

	{ &english_object,               FALSE, 99,4,1,
     "english_object",  "ƥ̾Ѹɽ" },

	{ &english_monster,               FALSE,  99,4,2,
     "english_monster",  "󥹥̾Ѹɽ" },

	{ &english_others,               FALSE,  99,4,4,
     "english_others",  "²//ιѸɽ" },

	{ &old_way_of_kaz,               FALSE,  99,4,5,
     "old_way_of_kaz",  "ʣƥɽηˤ" },

	{ &use_lb,                       FALSE,  99,4,7,
     "use_lb",  "̤ݥɤɽ" },

	{ &plain_savefile,               FALSE,  99,4,6,
     "plain_savefile",  "ѸǤȸߴʷǥ֤" },
#endif
	/*** End of Table ***/

	{ NULL,                         0, 0, 0, 0,
	NULL,                           NULL }
};


#ifdef JP
cptr chaos_patrons[MAX_PATRON] =
{
	"",
	"ޥ٥",
	"㡼ɥ",
	"ϥϡ",
	"С",

	"ԥ졼",
	"Х",
	"ꥪå",
	"",
	"ʡ",

	"Х",
	"",
	"顼ͥå",
	"ʡ",
	"ƥ",

	""
};

cptr E_chaos_patrons[MAX_PATRON] =
{
	"Slortar",
	"Mabelode",
	"Chardros",
	"Hionhurn",
	"Xiombarg",

	"Pyaray",
	"Balaan",
	"Arioch",
	"Eequor",
	"Narjhan",

	"Balo",
	"Khorne",
	"Slaanesh",
	"Nurgle",
	"Tzeentch",

	"Khaine"
};
#define X_chaos_patrons ( english_monster ? E_chaos_patrons : chaos_patrons )

#else
cptr chaos_patrons[MAX_PATRON] =
{
	"Slortar",
	"Mabelode",
	"Chardros",
	"Hionhurn",
	"Xiombarg",

	"Pyaray",
	"Balaan",
	"Arioch",
	"Eequor",
	"Narjhan",

	"Balo",
	"Khorne",
	"Slaanesh",
	"Nurgle",
	"Tzeentch",

	"Khaine"
};
#endif


int chaos_stats[MAX_PATRON] =
{
	A_CON,  /* Slortar */
	A_CON,  /* Mabelode */
	A_STR,  /* Chardros */
	A_STR,  /* Hionhurn */
	A_STR,  /* Xiombarg */

	A_INT,  /* Pyaray */
	A_STR,  /* Balaan */
	A_INT,  /* Arioch */
	A_CON,  /* Eequor */
	A_CHR,  /* Narjhan */

	-1,     /* Balo */
	A_STR,  /* Khorne */
	A_CHR,  /* Slaanesh */
	A_CON,  /* Nurgle */
	A_INT,  /* Tzeentch */

	A_STR,  /* Khaine */
};




int chaos_rewards[MAX_PATRON][20] =
{
	/* Slortar the Old: */
	{
		REW_WRATH, REW_CURSE_WP, REW_CURSE_AR, REW_RUIN_ABL, REW_LOSE_ABL,
		REW_IGNORE, REW_IGNORE, REW_IGNORE, REW_POLY_WND, REW_POLY_SLF,
		REW_POLY_SLF, REW_POLY_SLF, REW_GAIN_ABL, REW_GAIN_ABL, REW_GAIN_EXP,
		REW_GOOD_OBJ, REW_CHAOS_WP, REW_GREA_OBJ, REW_AUGM_ABL, REW_AUGM_ABL
	},

	/* Mabelode the Faceless: */
	{
		REW_WRATH, REW_CURSE_WP, REW_CURSE_AR, REW_H_SUMMON, REW_SUMMON_M,
		REW_SUMMON_M, REW_IGNORE, REW_IGNORE, REW_POLY_WND, REW_POLY_WND,
		REW_POLY_SLF, REW_HEAL_FUL, REW_HEAL_FUL, REW_GAIN_ABL, REW_SER_UNDE,
		REW_CHAOS_WP, REW_GOOD_OBJ, REW_GOOD_OBJ, REW_GOOD_OBS, REW_GOOD_OBS
	},

	/* Chardros the Reaper: */
	{
		REW_WRATH, REW_WRATH, REW_HURT_LOT, REW_PISS_OFF, REW_H_SUMMON,
		REW_SUMMON_M, REW_IGNORE, REW_IGNORE, REW_DESTRUCT, REW_SER_UNDE,
		REW_GENOCIDE, REW_MASS_GEN, REW_MASS_GEN, REW_DISPEL_C, REW_GOOD_OBJ,
		REW_CHAOS_WP, REW_GOOD_OBS, REW_GOOD_OBS, REW_AUGM_ABL, REW_AUGM_ABL
	},

	/* Hionhurn the Executioner: */
	{
		REW_WRATH, REW_WRATH, REW_CURSE_WP, REW_CURSE_AR, REW_RUIN_ABL,
		REW_IGNORE, REW_IGNORE, REW_SER_UNDE, REW_DESTRUCT, REW_GENOCIDE,
		REW_MASS_GEN, REW_MASS_GEN, REW_HEAL_FUL, REW_GAIN_ABL, REW_GAIN_ABL,
		REW_CHAOS_WP, REW_GOOD_OBS, REW_GOOD_OBS, REW_AUGM_ABL, REW_AUGM_ABL
	},

	/* Xiombarg the Sword-Queen: */
	{
		REW_TY_CURSE, REW_TY_CURSE, REW_PISS_OFF, REW_RUIN_ABL, REW_LOSE_ABL,
		REW_IGNORE, REW_POLY_SLF, REW_POLY_SLF, REW_POLY_WND, REW_POLY_WND,
		REW_GENOCIDE, REW_DISPEL_C, REW_GOOD_OBJ, REW_GOOD_OBJ, REW_SER_MONS,
		REW_GAIN_ABL, REW_CHAOS_WP, REW_GAIN_EXP, REW_AUGM_ABL, REW_GOOD_OBS
	},


	/* Pyaray the Tentacled Whisperer of Impossible Secretes: */
	{
		REW_WRATH, REW_TY_CURSE, REW_PISS_OFF, REW_H_SUMMON, REW_H_SUMMON,
		REW_IGNORE, REW_IGNORE, REW_IGNORE, REW_POLY_WND, REW_POLY_SLF,
		REW_POLY_SLF, REW_SER_DEMO, REW_HEAL_FUL, REW_GAIN_ABL, REW_GAIN_ABL,
		REW_CHAOS_WP, REW_DO_HAVOC, REW_GOOD_OBJ, REW_GREA_OBJ, REW_GREA_OBS
	},

	/* Balaan the Grim: */
	{
		REW_TY_CURSE, REW_HURT_LOT, REW_CURSE_WP, REW_CURSE_AR, REW_RUIN_ABL,
		REW_SUMMON_M, REW_LOSE_EXP, REW_POLY_SLF, REW_POLY_SLF, REW_POLY_WND,
		REW_SER_UNDE, REW_HEAL_FUL, REW_HEAL_FUL, REW_GAIN_EXP, REW_GAIN_EXP,
		REW_CHAOS_WP, REW_GOOD_OBJ, REW_GOOD_OBS, REW_GREA_OBS, REW_AUGM_ABL
	},

	/* Arioch, Duke of Hell: */
	{
		REW_WRATH, REW_PISS_OFF, REW_RUIN_ABL, REW_LOSE_EXP, REW_H_SUMMON,
		REW_IGNORE, REW_IGNORE, REW_IGNORE, REW_IGNORE, REW_POLY_SLF,
		REW_POLY_SLF, REW_MASS_GEN, REW_SER_DEMO, REW_HEAL_FUL, REW_CHAOS_WP,
		REW_CHAOS_WP, REW_GOOD_OBJ, REW_GAIN_EXP, REW_GREA_OBJ, REW_AUGM_ABL
	},

	/* Eequor, Blue Lady of Dismay: */
	{
		REW_WRATH, REW_TY_CURSE, REW_PISS_OFF, REW_CURSE_WP, REW_RUIN_ABL,
		REW_IGNORE, REW_IGNORE, REW_POLY_SLF, REW_POLY_SLF, REW_POLY_WND,
		REW_GOOD_OBJ, REW_GOOD_OBJ, REW_SER_MONS, REW_HEAL_FUL, REW_GAIN_EXP,
		REW_GAIN_ABL, REW_CHAOS_WP, REW_GOOD_OBS, REW_GREA_OBJ, REW_AUGM_ABL
	},

	/* Narjhan, Lord of Beggars: */
	{
		REW_WRATH, REW_CURSE_AR, REW_CURSE_WP, REW_CURSE_WP, REW_CURSE_AR,
		REW_IGNORE, REW_IGNORE, REW_IGNORE, REW_POLY_SLF, REW_POLY_SLF,
		REW_POLY_WND, REW_HEAL_FUL, REW_HEAL_FUL, REW_GAIN_EXP, REW_AUGM_ABL,
		REW_GOOD_OBJ, REW_GOOD_OBJ, REW_CHAOS_WP, REW_GREA_OBJ, REW_GREA_OBS
	},

	/* Balo the Jester: */
	{
		REW_WRATH, REW_SER_DEMO, REW_CURSE_WP, REW_CURSE_AR, REW_LOSE_EXP,
		REW_GAIN_ABL, REW_LOSE_ABL, REW_POLY_WND, REW_POLY_SLF, REW_IGNORE,
		REW_DESTRUCT, REW_MASS_GEN, REW_CHAOS_WP, REW_GREA_OBJ, REW_HURT_LOT,
		REW_AUGM_ABL, REW_RUIN_ABL, REW_H_SUMMON, REW_GREA_OBS, REW_AUGM_ABL
	},

	/* Khorne the Bloodgod: */
	{
		REW_WRATH, REW_HURT_LOT, REW_HURT_LOT, REW_H_SUMMON, REW_H_SUMMON,
		REW_IGNORE, REW_IGNORE, REW_IGNORE, REW_SER_MONS, REW_SER_DEMO,
		REW_POLY_SLF, REW_POLY_WND, REW_HEAL_FUL, REW_GOOD_OBJ, REW_GOOD_OBJ,
		REW_CHAOS_WP, REW_GOOD_OBS, REW_GOOD_OBS, REW_GREA_OBJ, REW_GREA_OBS
	},

	/* Slaanesh: */
	{
		REW_WRATH, REW_PISS_OFF, REW_PISS_OFF, REW_RUIN_ABL, REW_LOSE_ABL,
		REW_LOSE_EXP, REW_IGNORE, REW_IGNORE, REW_POLY_WND, REW_SER_DEMO,
		REW_POLY_SLF, REW_HEAL_FUL, REW_HEAL_FUL, REW_GOOD_OBJ, REW_GAIN_EXP,
		REW_GAIN_EXP, REW_CHAOS_WP, REW_GAIN_ABL, REW_GREA_OBJ, REW_AUGM_ABL
	},

	/* Nurgle: */
	{
		REW_WRATH, REW_PISS_OFF, REW_HURT_LOT, REW_RUIN_ABL, REW_LOSE_ABL,
		REW_LOSE_EXP, REW_IGNORE, REW_IGNORE, REW_IGNORE, REW_POLY_SLF,
		REW_POLY_SLF, REW_POLY_WND, REW_HEAL_FUL, REW_GOOD_OBJ, REW_GAIN_ABL,
		REW_GAIN_ABL, REW_SER_UNDE, REW_CHAOS_WP, REW_GREA_OBJ, REW_AUGM_ABL
	},

	/* Tzeentch: */
	{
		REW_WRATH, REW_CURSE_WP, REW_CURSE_AR, REW_RUIN_ABL, REW_LOSE_ABL,
		REW_LOSE_EXP, REW_IGNORE, REW_POLY_SLF, REW_POLY_SLF, REW_POLY_SLF,
		REW_POLY_SLF, REW_POLY_WND, REW_HEAL_FUL, REW_CHAOS_WP, REW_GREA_OBJ,
		REW_GAIN_ABL, REW_GAIN_ABL, REW_GAIN_EXP, REW_GAIN_EXP, REW_AUGM_ABL
	},

	/* Khaine: */
	{
		REW_WRATH, REW_HURT_LOT, REW_PISS_OFF, REW_LOSE_ABL, REW_LOSE_EXP,
		REW_IGNORE,   REW_IGNORE,   REW_DISPEL_C, REW_DO_HAVOC, REW_DO_HAVOC,
		REW_POLY_SLF, REW_POLY_SLF, REW_GAIN_EXP, REW_GAIN_ABL, REW_GAIN_ABL,
		REW_SER_MONS, REW_GOOD_OBJ, REW_CHAOS_WP, REW_GREA_OBJ, REW_GOOD_OBS
	}
};

martial_arts ma_blows[MAX_MA] =
{
#ifdef VERBOSE_MARTIAL_ARTS
#ifdef JP
	{ "%s򲥤ä",                          1, 0, 1, 4, 0 },
	{ "%s򽳤ä",                           2, 0, 1, 5, 0 },
	{ "%sͤ򤯤路",                         3, 0, 1, 6, 0 },
	{ "%sɨ򤯤路",             5, 5, 2, 3, MA_KNEE },
	{ "%sɪǤ򤯤路",            7, 5, 1, 7, 0 },
	{ "%sƬͤ򤯤路",                           9, 10, 2, 4, 0 },
	{ "%s򽳤ä",                           11, 10, 2, 5, MA_SLOW },
	{ "%s˥åѡ򤯤路",                       13, 12, 3, 5, 6 },
	{ "%sʽ򤯤路",                    16, 15, 6, 3, 8 },
	{ "%sǭ޷򤯤路",          20, 20, 4, 6, 0 },
	{ "%sķӤ򤯤路",           25, 25, 4, 7, 10 },
	{ "%s޽򤯤路",       29, 25, 5, 6, 0 },
	{ "%s˲󤷽򤯤路",         33, 30, 5, 8, 10 },
	{ "%sŴ򤯤路",          37, 35, 6, 8, 10 },
	{ "%sӤ򤯤路",         41, 35, 7, 8, 12 },
	{ "%s˾ζ򤯤路",         45, 35, 7, 10, 16 },
	{ "%sŷ÷򤯤路",       48, 35, 7, 12, 18 },
#else
	{ "You punch %s.",                          1, 0, 1, 4, 0 },
	{ "You kick %s.",                           2, 0, 1, 5, 0 },
	{ "You strike %s.",                         3, 0, 1, 6, 0 },
	{ "You hit %s with your knee.",             5, 5, 2, 3, MA_KNEE },
	{ "You hit %s with your elbow.",            7, 5, 1, 7, 0 },
	{ "You butt %s.",                           9, 10, 2, 4, 0 },
	{ "You kick %s.",                           11, 10, 2, 5, MA_SLOW },
	{ "You uppercut %s.",                       13, 12, 3, 5, 6 },
	{ "You double-kick %s.",                    16, 15, 6, 3, 8 },
	{ "You hit %s with a Cat's Claw.",          20, 20, 4, 6, 0 },
	{ "You hit %s with a jump kick.",           25, 25, 4, 7, 10 },
	{ "You hit %s with an Eagle's Claw.",       29, 25, 5, 6, 0 },
	{ "You hit %s with a circle kick.",         33, 30, 5, 8, 10 },
	{ "You hit %s with an Iron Fist.",          37, 35, 6, 8, 10 },
	{ "You hit %s with a flying kick.",         41, 35, 7, 8, 12 },
	{ "You hit %s with a Dragon Fist.",         45, 35, 7, 10, 16 },
	{ "You hit %s with a Crushing Blow.",       48, 35, 7, 12, 18 },
#endif

#else
#ifdef JP
	{ "%s򲥤ä",                          1, 0, 1, 4, 0 },
	{ "%s򽳤ä",                           2, 0, 1, 5, 0 },
	{ "%sͤ",                         3, 0, 1, 6, 0 },
	{ "%sɨǽä",                           5, 5, 2, 3, MA_KNEE },
	{ "%s򹶷⤷",                            7, 5, 1, 7, 0 },
	{ "%sƬͤ",                           9, 10, 2, 4, 0 },
	{ "%s򽳤ä",                           11, 10, 2, 5, MA_SLOW },
	{ "%sͤ夲",                       13, 12, 3, 5, 6 },
	{ "%s򽳤ä",                    16, 15, 6, 3, 8 },
	{ "%s򹶷⤷",                            20, 20, 4, 6, 0 },
	{ "%s򽳤ä",                           25, 25, 4, 7, 10 },
	{ "%s򹶷⤷",                            29, 25, 5, 6, 0 },
	{ "%s򽳤ä",                           33, 30, 5, 8, 10 },
	{ "%s򲥤ä",                          37, 35, 6, 8, 10 },
	{ "%s򽳤ä",                           41, 35, 7, 8, 12 },
	{ "%s򲥤ä",                          45, 35, 7, 10, 16 },
	{ "%s򲥤ä",                          48, 35, 7, 12, 18 },
#else
	{ "You punch %s.",                          1, 0, 1, 4, 0 },
	{ "You kick %s.",                           2, 0, 1, 5, 0 },
	{ "You strike %s.",                         3, 0, 1, 6, 0 },
	{ "You knee %s.",                           5, 5, 2, 3, MA_KNEE },
	{ "You hit %s.",                            7, 5, 1, 7, 0 },
	{ "You butt %s.",                           9, 10, 2, 4, 0 },
	{ "You kick %s.",                           11, 10, 2, 5, MA_SLOW },
	{ "You uppercut %s.",                       13, 12, 3, 5, 6 },
	{ "You double-kick %s.",                    16, 15, 6, 3, 8 },
	{ "You hit %s.",                            20, 20, 4, 6, 0 },
	{ "You kick %s.",                           25, 25, 4, 7, 10 },
	{ "You hit %s.",                            29, 25, 5, 6, 0 },
	{ "You kick %s.",                           33, 30, 5, 8, 10 },
	{ "You punch %s.",                          37, 35, 6, 8, 10 },
	{ "You kick %s.",                           41, 35, 7, 8, 12 },
	{ "You punch %s.",                          45, 35, 7, 10, 16 },
	{ "You punch %s.",                          48, 35, 7, 12, 18 },
#endif

#endif
};

/*
 * Table of game-generated inscriptions (indexed by the defines in
 * defines.h). -- RG
 */
cptr game_inscriptions[] =
{
	NULL,            /* FEEL_NONE */
#ifdef JP
	"Ƥ",    /* FEEL_BROKEN */
	"",      /* FEEL_TERRIBLE */
	"̵",        /* FEEL_WORTHLESS */
	"Ƥ",  /* FEEL_CURSED */
	"ʤ",      /* FEEL_UNCURSED */
	"",            /* FEEL_AVERAGE */
	"",          /* FEEL_GOOD */
	"",        /* FEEL_EXCELLENT */
	"",        /* FEEL_SPECIAL */
#else
	"broken",        /* FEEL_BROKEN */
	"terrible",      /* FEEL_TERRIBLE */
	"worthless",     /* FEEL_WORTHLESS */
	"cursed",        /* FEEL_CURSED */
	"uncursed",      /* FEEL_UNCURSED */
	"average",       /* FEEL_AVERAGE */
	"good",          /* FEEL_GOOD */
	"excellent",     /* FEEL_EXCELLENT */
	"special",       /* FEEL_SPECIAL */
#endif

};


#ifndef JP
/* Weird melee attack types when hallucinating */
cptr silly_attacks[MAX_SILLY_ATTACK] =
{
	"smothers",
	"hugs",
	"humiliates",
	"whips",
	"kisses",

	"disgusts",
	"pees all over",
	"passes the gas on",
	"makes obscene gestures at",
	"licks",

	"stomps on",
	"swallows",
	"drools on",
	"misses",
	"shrinks",

	"emasculates",
	"evaporates",
	"solidifies",
	"digitizes",
	"insta-kills",

	"massacres",
	"slaughters",
	"drugs",
	"psychoanalyzes",
	"deconstructs",

	"falsifies",
	"disbelieves",
	"molests"
};
#endif
