/* snatch.c */

#include "angband.h"


/*
 * TABLE: which equipments can monsters weild/wear ?
 */
struct monster_wield_type
{
	char sym;
	bool flag[INVEN_TOTAL - INVEN_WIELD];
};

static struct monster_wield_type is_monster_wield[] =
{
	/*               */
	{ 'd', { 0, 0, 1, 1, 1, 1, 0, 0, 0, 0, 0 } },
	{ 'f', { 0, 0, 1, 1, 1, 1, 0, 0, 0, 0, 0 } },
	{ 'g', { 1, 1, 1, 1, 1, 1, 0, 0, 1, 1, 0 } },
	{ 'h', { 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1 } },
	{ 'k', { 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1 } },
	{ 'n', { 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0 } },
	{ 'o', { 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1 } },
	{ 'p', { 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1 } },
	{ 'q', { 0, 0, 1, 1, 0, 1, 0, 0, 0, 0, 0 } },
	{ 'r', { 0, 0, 1, 1, 0, 1, 0, 0, 0, 0, 0 } },
	{ 's', { 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1 } },
	{ 't', { 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1 } },
	{ 'u', { 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1 } },
	{ 'y', { 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1 } },
	{ 'z', { 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1 } },

	{ 'A', { 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1 } },
	{ 'C', { 0, 0, 1, 1, 0, 1, 0, 0, 0, 0, 0 } },
	{ 'D', { 0, 0, 1, 1, 1, 1, 0, 0, 0, 0, 0 } },
	{ 'H', { 1, 1, 1, 1, 1, 1, 0, 0, 1, 1, 0 } },
	{ 'L', { 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1 } },
	{ 'M', { 0, 0, 0, 0, 1, 1, 0, 0, 0, 0, 0 } },
	{ 'O', { 1, 1, 1, 1, 1, 1, 0, 0, 1, 1, 0 } },
	{ 'P', { 1, 1, 1, 1, 1, 1, 0, 0, 1, 1, 0 } },
	{ 'T', { 1, 1, 1, 1, 1, 1, 0, 0, 1, 1, 0 } },
	{ 'U', { 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1 } },
	{ 'V', { 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1 } },
	{ 'W', { 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1 } },
	{ 'X', { 1, 1, 1, 1, 1, 1, 0, 0, 1, 1, 0 } },
	{ 'Y', { 1, 1, 1, 1, 1, 1, 0, 0, 1, 1, 0 } },
	{ 'Z', { 0, 0, 1, 1, 0, 1, 0, 0, 0, 0, 0 } },

	{   0, { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0 } },
};


/*
 * TABLE: Status bonuses that player gains.
 */
struct monster_bonus_type
{
	char sym;
	s16b r_adj[A_MAX];	/* Racial stat bonuses */
	s16b dis;			/* disarming */
	s16b dev;			/* magic devices */
	s16b sav;			/* saving throw */
	s16b stl;			/* stealth */
	s16b srh;			/* search ability */
	s16b fos;			/* search frequency */
	s16b thn;			/* combat (normal) */
	s16b thb;			/* combat (shooting) */
	byte infra;			/* Infra-vision	range */
};

struct monster_bonus_type monster_bonus[] =
{
	/*               ̥      ƻ      õ         */
	{ 'd', {  4, -2, -3,  4,  4, -1 },  0,  0,  0, -1,  0,  0,  0,  0,  5 },
	{ 'f', {  1, -2, -2,  3,  2,  2 },  0,  0,  0,  4,  0,  0,  0,  0,  7 },
	{ 'g', {  0,  0,  0,  0,  0,  0 },  0,  0,  0, -3,  0,  0,  0,  0,  0 },
	{ 'h', { -1,  1,  1,  1, -1,  2 },  0,  0,  0,  1,  0,  0,  0,  0,  2 },
	{ 'k', { -1, -1, -1,  2,  1, -1 },  0,  0,  0,  1,  0,  0,  0,  0,  1 },
	{ 'n', {  2,  0,  1,  2,  3, -1 },  0,  0,  0,  0,  0,  0,  0,  0,  2 },
	{ 'o', {  2, -2, -1,  1,  2, -2 },  0,  0,  0, -1,  0,  0,  0,  0,  3 },
	{ 'p', {  0,  0,  0,  0,  0,  0 },  0,  0,  0,  0,  0,  0,  0,  0,  0 },
	{ 'q', {  4, -3, -3,  4,  4, -1 },  0,  0,  0,  0,  0,  0,  0,  0,  2 },
	{ 'r', { -2, -1, -1,  2, -2, -2 },  0,  0,  0,  0,  0,  0,  0,  0,  5 },
	{ 's', {  0,  0,  0,  0,  0, -5 },  0,  0,  0,  0,  0,  0,  0,  0,  0 },
	{ 't', { -1, -1, -1, -1, -1, -1 },  0,  0,  0,  0,  0,  0,  0,  0,  0 },
	{ 'u', {  0,  2, -1,  2,  1, -2 },  0,  0,  0,  0,  0,  0,  0,  0,  3 },
	{ 'y', { -4,  1,  1,  2, -2, -4 },  0,  0,  0,  0,  0,  0,  0,  0,  3 },
	{ 'z', {  0,  0,  0,  0,  0, -5 },  0,  0,  0,  0,  0,  0,  0,  0,  0 },

	{ 'A', {  2,  2,  4,  2,  2,  4 },  0,  0,  0,  2,  0,  0,  0,  0,  5 },
	{ 'C', {  2, -2, -2,  4,  4,  0 },  0,  0,  0,  3,  0,  0,  0,  0,  7 },
	{ 'D', {  8, -1, -2,  8,  8, -2 },  0,  0,  0, -2,  0,  0,  0,  0,  5 },
	{ 'H', {  4, -2, -1, -2,  4, -3 },  0,  0,  0,  0,  0,  0,  0,  0,  3 },
	{ 'L', {  0,  0,  0,  0,  0,  0 },  0,  0,  0,  0,  0,  0,  0,  0,  0 },
	{ 'M', {  6, -4, -3, -2,  6, -5 },  0,  0,  0, -2,  0,  0,  0,  0,  3 },
	{ 'O', {  3, -2, -1, -1,  2, -2 },  0,  0,  0, -2,  0,  0,  0,  0,  3 },
	{ 'P', {  4, -2, -2, -2,  3, -3 },  0,  0,  0, -3,  0,  0,  0,  0,  3 },
	{ 'T', {  5, -4, -2, -3,  4, -5 },  0,  0,  0, -5,  0,  0,  0,  0,  3 },
	{ 'U', {  2,  2, -5,  2,  4, -5 },  0,  0,  0, -2,  0,  0,  0,  0,  3 },
	{ 'V', {  2,  4, -2, -1,  1,  2 },  0,  0,  0,  0,  0,  0,  0,  0,  5 },
	{ 'W', { -1,  3,  0,  1,  2,  0 },  0,  0,  0,  0,  0,  0,  0,  0,  5 },
	{ 'X', {  4, -2, -2, -2,  4, -2 },  0,  0,  0,  0,  0,  0,  0,  0,  3 },
	{ 'Y', {  3, -1, -1,  0,  2, -1 },  0,  0,  0, -1,  0,  0,  0,  0,  3 },
	{ 'Z', {  0,  0,  0,  0,  0,  0 },  0,  0,  0,  3,  0,  0,  0,  0,  7 },

	{   0, {  0,  0,  0,  0,  0,  0 },  0,  0,  0,  0,  0,  0,  0,  0,  0 },
};


/*
 * Checking which a monster can wield/wear it.
 */
bool check_monster_wield(int slot)
{
	int i;
	int item = (slot - INVEN_WIELD);
	monster_race *r_ptr = &r_info[p_ptr->m_idx];
	char sym = r_ptr->d_char;

	if (slot == INVEN_LITE) return (TRUE);

	for (i = 0; is_monster_wield[i].sym != 0; i++)
	{
		if (sym == is_monster_wield[i].sym)
		{
			return is_monster_wield[i].flag[item];
		}
	}

	return (FALSE);
}


s16b monster_blows(int r_idx)
{
	int i, cnt = 0;
	monster_race *r_ptr = &r_info[r_idx];

	/* Paranoia */
	if (inventory[INVEN_WIELD].k_idx) return (0);

	for (i = 0; i < 4; i++)
	{
		if (r_ptr->blow[i].method) cnt++;
	}

	return (cnt);
}


int monster_avgdam(int r_idx)
{
	int i, tdam = 0;
	int cnt = monster_blows(r_idx);
	monster_race *r_ptr = &r_info[r_idx];

	/* Paranoia */
	if (inventory[INVEN_WIELD].k_idx) return (0);

	for (i = 0; i < cnt; i++)
	{
		tdam += (r_ptr->blow[i].d_dice * (r_ptr->blow[i].d_side + 1) / 2);
	}

	return (tdam);
}


int add_monster_melee_skill(void)
{
	monster_race *r_ptr = &r_info[p_ptr->m_idx];

	if (inventory[INVEN_WIELD].k_idx) return (p_ptr->lev);

	return (p_ptr->lev * 2);
}


/*
 * Checking flags for a character dump.
 */
void monster_flags(u32b *g1, u32b *g2, u32b *g3)
{
	monster_race *r_ptr = &r_info[p_ptr->m_idx];

	u32b f1 = r_ptr->flags1;
	u32b f2 = r_ptr->flags2;
	u32b f3 = r_ptr->flags3;
	u32b f4 = r_ptr->flags4;
	u32b f5 = r_ptr->flags5;
	u32b f6 = r_ptr->flags6;
	u32b f7 = r_ptr->flags7;

	/* Resistances */
	if (f3 & RF3_IM_ACID) (*g2) |= TR2_RES_ACID;
	if (f3 & RF3_IM_ELEC) (*g2) |= TR2_RES_ELEC;
	if (f3 & RF3_IM_FIRE) (*g2) |= TR2_RES_FIRE;
	if (f3 & RF3_IM_COLD) (*g2) |= TR2_RES_COLD;
	if (f3 & RF3_IM_POIS) (*g2) |= TR2_RES_POIS;
	if (f3 & RF3_NO_FEAR) (*g2) |= TR2_RES_FEAR;

	if (f4 & RF4_BR_LITE) (*g2) |= TR2_RES_LITE;
	if (f4 & RF4_BR_DARK) (*g2) |= TR2_RES_DARK;
	if (f4 & RF4_BR_SHAR) (*g2) |= TR2_RES_SHARDS;
	if (f3 & RF3_NO_CONF) (*g2) |= TR2_RES_CONF;
	if (f4 & RF4_BR_SOUN) (*g2) |= TR2_RES_SOUND;
	if (f3 & RF3_RES_NETH) (*g2) |= TR2_RES_NETHER;
	if (f3 & RF3_RES_NEXU) (*g2) |= TR2_RES_NEXUS;
	if (f4 & RF4_BR_CHAO) (*g2) |= TR2_RES_CHAOS;
	if (f3 & RF3_RES_DISE) (*g2) |= TR2_RES_DISEN;
#if 0
	if (f3 & RF3_RES_WATE) (*g2) |= TR2_RES_SOUND;
#endif
	if (f3 & RF3_RES_PLAS) { (*g2) |= TR2_RES_FIRE; (*g2) |= TR2_RES_SOUND; }
	if (f3 & RF3_NO_STUN) (*g2) |= TR2_RES_SOUND;
	if (f3 & RF3_NO_SLEEP) (*g2) |= TR2_FREE_ACT;
	if (f4 & RF4_BR_TIME) (*g2) |= TR2_HOLD_LIFE;
#if 0
	if (f4 & RF4_BR_INER)
	if (f4 & RF4_BR_GRAV)
	if (f4 & RF4_BR_WALL)
	if (f4 & RF4_BR_DISI)
	if (f3 & RF3_RES_TELE) 
#endif

	/* Abilities */
	if (f2 & RF2_REFLECTING) (*g2) |= TR2_REFLECT;
	if (f2 & RF2_REGENERATE) (*g3) |= TR3_REGEN;
	if (f2 & RF2_AURA_FIRE) (*g3) |= TR3_SH_FIRE;
	if (f2 & RF2_AURA_ELEC) (*g3) |= TR3_SH_ELEC;
	if (f3 & RF3_AURA_COLD) (*g3) |= TR3_SH_COLD;
	if (f7 & RF7_CAN_FLY) (*g3) |= TR3_FEATHER;
	if (f7 & RF7_HAS_LITE_1) (*g3) |= TR3_LITE;
	if (f7 & RF7_SELF_LITE_1) (*g3) |= TR3_LITE;
	if (f7 & RF7_HAS_LITE_2) (*g3) |= TR3_LITE;
	if (f7 & RF7_SELF_LITE_2) (*g3) |= TR3_LITE;

	/* Race bonuses */
	if (f3 & RF3_ORC) (*g2) |= TR2_RES_DARK;
	if (f3 & RF3_UNDEAD) (*g2) |= TR2_RES_NETHER;
#if 0
	if (f3 & RF3_DEMON) (*g2) |= TR2_RES_CHAOS;
#endif

	return;
}


int add_monster_stat(int n)
{
	int i = 0;
	monster_race *r_ptr = &r_info[p_ptr->m_idx];

	while(1)
	{
		struct monster_bonus_type *mb_ptr = &monster_bonus[i];

		if (!mb_ptr->sym) return (0);
		if (mb_ptr->sym == r_ptr->d_char) return (int)(mb_ptr->r_adj[n]);
		i++;
	}
}


/*
 * Culcurates all bonuses that are gaind by a monster race.
 */
void monster_bonuses(void)
{
	int i, j;

	monster_race *r_ptr = &r_info[p_ptr->m_idx];

	u32b f1 = r_ptr->flags1;
	u32b f2 = r_ptr->flags2;
	u32b f3 = r_ptr->flags3;
	u32b f4 = r_ptr->flags4;
	u32b f5 = r_ptr->flags5;
	u32b f6 = r_ptr->flags6;
	u32b f7 = r_ptr->flags7;

	/* Resistances */
	if (f3 & RF3_IM_ACID) p_ptr->resist_acid = TRUE;
	if (f3 & RF3_IM_ELEC) p_ptr->resist_elec = TRUE;
	if (f3 & RF3_IM_FIRE) p_ptr->resist_fire = TRUE;
	if (f3 & RF3_IM_COLD) p_ptr->resist_cold = TRUE;
	if (f3 & RF3_IM_POIS) p_ptr->resist_pois = TRUE;
	if (f3 & RF3_NO_FEAR) p_ptr->resist_fear = TRUE;

	if (f4 & RF4_BR_LITE) p_ptr->resist_lite = TRUE;
	if (f4 & RF4_BR_DARK) p_ptr->resist_dark = TRUE;
	if (f4 & RF4_BR_SHAR) p_ptr->resist_shard = TRUE;
	if (f3 & RF3_NO_CONF) p_ptr->resist_conf = TRUE;
	if (f4 & RF4_BR_SOUN) p_ptr->resist_sound = TRUE;
	if (f3 & RF3_RES_NETH) p_ptr->resist_neth = TRUE;
	if (f3 & RF3_RES_NEXU) p_ptr->resist_nexus = TRUE;
	if (f4 & RF4_BR_CHAO) p_ptr->resist_chaos = TRUE;
	if (f3 & RF3_RES_DISE) p_ptr->resist_disen = TRUE;
#if 0
	if (f3 & RF3_RES_WATE) p_ptr->resist_sound = TRUE; 
#endif
	if (f3 & RF3_RES_PLAS) { p_ptr->resist_fire = TRUE; p_ptr->resist_sound = TRUE; }
	if (f3 & RF3_NO_STUN) p_ptr->resist_sound = TRUE;
	if (f3 & RF3_NO_SLEEP) p_ptr->free_act = TRUE;
	if (f4 & RF4_BR_TIME) p_ptr->hold_life = TRUE;
#if 0
	if (f4 & RF4_BR_INER)
	if (f4 & RF4_BR_GRAV)
	if (f4 & RF4_BR_WALL)
	if (f4 & RF4_BR_DISI)
	if (f3 & RF3_RES_TELE) p_ptr->anti_tele = TRUE;
#endif

	/* Abilities */
	if (f2 & RF2_PASS_WALL) p_ptr->pass_wall = TRUE;
	if (f2 & RF2_KILL_WALL) p_ptr->kill_wall = TRUE;
	if (f2 & RF2_REFLECTING) p_ptr->reflect= TRUE;
	if (f2 & RF2_REGENERATE) p_ptr->regenerate = TRUE;
	if (f2 & RF2_AURA_FIRE) p_ptr->sh_fire = TRUE;
	if (f2 & RF2_AURA_ELEC) p_ptr->sh_elec = TRUE;
	if (f3 & RF3_AURA_COLD) p_ptr->sh_cold = TRUE;
	if (f7 & RF7_CAN_FLY) p_ptr->ffall = TRUE;
	if (f7 & RF7_HAS_LITE_1) p_ptr->lite = TRUE;
	if (f7 & RF7_SELF_LITE_1) p_ptr->lite = TRUE;
	if (f7 & RF7_HAS_LITE_2) p_ptr->lite = TRUE;
	if (f7 & RF7_SELF_LITE_2) p_ptr->lite = TRUE;

	/* Race bonus */
	if (f3 & RF3_ORC) p_ptr->resist_dark = TRUE;
	if (f3 & RF3_UNDEAD) p_ptr->resist_neth = TRUE;
#if 0
	if (f3 & RF3_DEMON) p_ptr->resist_chaos = TRUE;
#endif

	/* Status */
	if (f2 & RF2_STUPID) { p_ptr->stat_add[A_INT] -= 4; p_ptr->stat_add[A_WIS] -= 4; }
	if (f2 & RF2_SMART) { p_ptr->stat_add[A_INT] += 4; p_ptr->stat_add[A_WIS] += 4; }
	if (f2 & RF2_POWERFUL) { p_ptr->stat_add[A_INT] += 2; p_ptr->stat_add[A_WIS] += 2; }
	if (f2 & RF2_ELDRITCH_HORROR) p_ptr->stat_add[A_CHR] -= 10;
	if (f2 & RF2_OPEN_DOOR) p_ptr->stat_add[A_DEX] += 1;
	if (f2 & RF2_BASH_DOOR) p_ptr->stat_add[A_STR] += 1;
	if (f2 & RF2_MOVE_BODY) p_ptr->stat_add[A_DEX] += 2;
	if (f2 & RF2_KILL_BODY) p_ptr->stat_add[A_STR] += 2;

	/* Gains a half of speeds */
	if (r_ptr->speed) p_ptr->pspeed += (r_ptr->speed - 110) / 2;

	/* Gains a half of AC */
	if (r_ptr->ac) {
		p_ptr->ac += (r_ptr->ac / 2);
		p_ptr->dis_ac += p_ptr->ac;
	}

	/* Race bonus */
	i = 0;

	while(1)
	{
		struct monster_bonus_type *mb_ptr = &monster_bonus[i];

		if (!mb_ptr->sym) break;

		if (mb_ptr->sym == r_ptr->d_char)
		{
			for (j = 0; j < A_MAX; j++)
			{
				p_ptr->stat_add[j] += mb_ptr->r_adj[j];
			}
			p_ptr->skill_stl += mb_ptr->stl;
			p_ptr->see_infra += mb_ptr->infra;
		}

		i++;
	}

	return;
}


/*
 * Drops all items when successful body snatching.
 */
static void body_snatch_drop(int x, int y)
{
	int i;
	object_type forge;
	object_type *q_ptr;

	object_type *o_ptr;

	for (i = INVEN_TOTAL - 1; i >= 0; i--)
	{
		/* Access original object */
		o_ptr = &inventory[i];

		/* Skip nothing */
		if (!o_ptr->k_idx) continue;

		/* Get local object */
		q_ptr = &forge;

		/* Obtain local object */
		object_copy(q_ptr, o_ptr);

		/* Modify quantity (Paranoia) */
		if (q_ptr->number != o_ptr->number) q_ptr->number = o_ptr->number;

		/* Drop it near the player */
		(void)drop_near(q_ptr, 0, y, x);

		/* Modify, Describe, Optimize */
		inven_item_increase(i, (0 - q_ptr->number));
		inven_item_optimize(i);
	}

	p_ptr->redraw |= (PR_EQUIPPY);
}


int monster_hitdie(int r_idx)
{
	int hd;
	monster_race *r_ptr = &r_info[r_idx];

	hd = 9 + (r_ptr->hdice * (r_ptr->hside + 1) / 2) / (r_ptr->level + 2);

	return (hd);
}

void culc_monster_hitpoints()
{
	p_ptr->hitdie = monster_hitdie(p_ptr->m_idx);
	do_cmd_rerate(TRUE);
}


/*
 * Effects of body snatching.
 */
bool body_snatch(u16b m_idx)
{
	int ox = px, oy = py;
	bool fail = FALSE;

	monster_type *m_ptr = &m_list[m_idx];
	monster_race *r_ptr = &r_info[m_ptr->r_idx];

	u32b f1 = r_ptr->flags1;
	u32b f2 = r_ptr->flags2;
	u32b f3 = r_ptr->flags3;

	/* Some monsters resist snatching */
	if (f1 & RF1_UNIQUE) fail = TRUE;
	if (f1 & RF1_QUESTOR) fail = TRUE;
	if (f2 & RF2_EMPTY_MIND) fail = TRUE;
	if (f2 & RF2_WEIRD_MIND) fail = TRUE;
	if (f2 & RF2_QUANTUM) fail = TRUE;
	if (f3 & RF3_UNDEAD) fail = TRUE;
	if (!(f3 & RF3_DEMON) && (f3 & RF3_NONLIVING)) fail = TRUE;

	if (fail)
	{
		char m_name[80];
		monster_desc(m_name, m_ptr, 0);

		if (is_seen(m_ptr))
#ifdef JP
			msg_format("%^sˤϸ̤ʤä", m_name);
#else
			msg_format("%^s is unaffected. ", m_name);
#endif
		else
#ifdef JP
			msg_print("Ԥˤϸ̤ʤä");
#else
			msg_print("It is unaffected. ");
#endif

		return (FALSE);
	}


	if ((!m_ptr->monfear) && (!m_ptr->confused))
	{
		char m_name[80];
		monster_desc(m_name, m_ptr, 0);

		if (is_seen(m_ptr))
#ifdef JP
			msg_format("%sʤλۤķ֤", m_name);
#else
			msg_format("%^s resists your control.", m_name);
#endif
		else
#ifdef JP
			msg_print("Ԥˤϸ̤ʤä");
#else
			msg_print("It is unaffected. ");
#endif

		return (FALSE);
	}

	if (m_ptr->hp > m_ptr->maxhp / 5)
	{
		if (is_seen(m_ptr))
#ifdef JP
			msg_format("äȼ餻ʤȡ");
#else
		{
			char m_name[80];
			monster_desc(m_name, m_ptr, 0);
			msg_format("You need to weaken %s more.", m_name);
		}
#endif
		else
#ifdef JP
			msg_print("Ԥˤϸ̤ʤä");
#else
			msg_print("It is unaffected. ");
#endif

		return (FALSE);
	}


	p_ptr->m_idx = m_ptr->r_idx;
	px = m_ptr->fx;
	py = m_ptr->fy;
	lite_spot(py, px);

	delete_monster_idx(m_idx);

	body_snatch_drop(ox, oy);
	culc_monster_hitpoints();
	check_experience();

#ifdef JP
	msg_print("ʿΤ줿");
#else
	msg_print("Gained new body!!");
#endif
	msg_print(NULL);

	p_ptr->update |= (PU_VIEW | PU_LITE | PU_FLOW | PU_MON_LITE);
	p_ptr->redraw |= (PR_MAP);
	handle_stuff();

#ifdef JP
	msg_print("οΤϵ̤ƤƤޤä");
#else
	msg_print(" Previous body rotted away...");
#endif

	return (TRUE);
}
