/* File: japanese.c */


/*
* Copyright (c) 1997 Ben Harrison
*
* This software may be copied and distributed for educational, research,
* and not for profit purposes provided that this copyright and statement
* are included in all such copies.  Other copyrights may also apply.
*/

#include "angband.h"

#ifdef JP

/*
* θ strstr
*/
cptr strstr_j(const char* s, const char* t)
{
	int i, l1, l2;
	
	l1 = strlen(s);
	l2 = strlen(t);
	if (l1 >= l2) {
		for(i = 0; i <= l1 - l2; i++) {
			if(!strncmp(s + i, t, l2))
				return s + i;
			if (iskanji(*(s + i)))
				i++;
		}
	}
	return NULL;
}

/*
* Find valid breakpoint in a Japanese string
*/
int null_pos_j(const char* s, int maxpos)
{
    int i = 0;
	
    while (s[i] != 0 && i < ((iskanji(s[i])) ? maxpos-1 : maxpos))
		i+= iskanji(s[i]) ? 2 : 1;
	
    return(i);
}

typedef struct convert_key convert_key;

struct convert_key
{
	cptr key1;
	cptr key2;
};

static const convert_key s2j_table[] = {
	{"mb","nb"}, {"mp","np"}, {"mv","nv"}, {"mm","nm"},
	{"x","ks"},
	/* sindar:  parantir:ѥƥ  feanor:եΡ */
	{"ar$","a-ru$"}, {"ir$","ia$"}, {"or$","o-ru$"},
	{"ra",""}, {"ri",""}, {"ru",""}, {"re",""}, {"ro",""},
	{"ir","ia"}, {"ur","ua"}, {"er","ea"}, {"ar","a"},
	{"sha",""}, {"shi",""}, {"shu",""}, {"she",""}, {"sho",""},
	{"tha",""}, {"thi",""}, {"thu",""}, {"the",""}, {"tho",""},
	{"cha",""}, {"chi",""}, {"chu",""}, {"che",""}, {"cho",""},
	{"dha",""}, {"dhi",""}, {"dhu",""}, {"dhe",""}, {"dho",""},
	{"ba",""}, {"bi",""}, {"bu",""}, {"be",""}, {"bo",""},
	{"ca",""}, {"ci",""}, {"cu",""}, {"ce",""}, {"co",""},
	{"da",""}, {"di","ǥ"}, {"du","ɥ"}, {"de",""}, {"do",""},
	{"fa","ե"}, {"fi","ե"}, {"fu",""}, {"fe","ե"}, {"fo","ե"},
	{"ga",""}, {"gi",""}, {"gu",""}, {"ge",""}, {"go",""},
	{"ha",""}, {"hi",""}, {"hu",""}, {"he",""}, {"ho",""},
	{"ja",""}, {"ji",""}, {"ju",""}, {"je",""}, {"jo",""},
	{"ka",""}, {"ki",""}, {"ku",""}, {"ke",""}, {"ko",""},
	{"la",""}, {"li",""}, {"lu",""}, {"le",""}, {"lo",""},
	{"ma",""}, {"mi",""}, {"mu",""}, {"me",""}, {"mo",""},
	{"na",""}, {"ni",""}, {"nu",""}, {"ne",""}, {"no",""},
	{"pa",""}, {"pi",""}, {"pu",""}, {"pe",""}, {"po",""},
	{"qu",""},
	{"sa",""}, {"si",""}, {"su",""}, {"se",""}, {"so",""},
	{"ta",""}, {"ti","ƥ"}, {"tu","ȥ"}, {"te",""}, {"to",""},
	{"va",""}, {"vi",""}, {"vu",""}, {"ve",""}, {"vo",""},
	{"wa",""}, {"wi",""}, {"wu",""}, {"we",""}, {"wo",""},
	{"ya",""}, {"yu",""}, {"yo",""},
	{"za",""}, {"zi",""}, {"zu",""}, {"ze",""}, {"zo",""},
	{"dh",""}, {"ch",""}, {"th",""},
	{"b",""}, {"c",""}, {"d",""}, {"f",""}, {"g",""},
	{"h",""}, {"j",""}, {"k",""}, {"l",""}, {"m",""},
	{"n",""}, {"p",""}, {"q",""}, {"r",""}, {"s",""},
	{"t",""}, {"v",""}, {"w",""}, {"y",""},
	{"a",""}, {"i",""}, {"u",""}, {"e",""}, {"o",""},
	{"-",""},
	{NULL,NULL}
};

/* ѸǤδʪ̤Ƚܸ̾ɤߤѴ */
void sindarin_to_kana(char *kana, const char *sindarin)
{
	char buf[256];
	int idx;
	
	sprintf(kana, "%s$", sindarin);
	for (idx=0; kana[idx]; idx++)
		if (isupper(kana[idx])) kana[idx] = tolower(kana[idx]);
	
	for (idx = 0; s2j_table[idx].key1 != NULL; idx++)
	{
		cptr pat1 = s2j_table[idx].key1;
		cptr pat2 = s2j_table[idx].key2;
		int len = strlen(pat1);
		char *src = kana;
		char *dest = buf;
		
		while (*src) {
			if( strncmp(src, pat1, len) == 0 )
			{
				strcpy(dest, pat2);
				src += len;
				dest += strlen(pat2);
			}
			else
			{
				if( iskanji(*src) )
				{
					*dest = *src;
					src++;
					dest++;
				}
				*dest = *src;
				src++;
				dest++;
			}
		}

		*dest = 0;
		strcpy(kana, buf);
	}

	idx = 0;

	while( kana[idx] != '$' ) idx++;

	kana[idx] = '\0';
}


/* ܸư (ǤġǤä,Ǥ etc) */

#define CMPTAIL(y) strncmp(&in[l-strlen(y)], y, strlen(y))

/* , -> , */
static void jverb1( const char *in , char *out)
{
	int l = strlen(in);
	strcpy(out, in);

	/* ѳʳ */
	if( CMPTAIL("") == 0) sprintf(&out[l-4], ""); else

	/* ʳ */
	if( CMPTAIL("") == 0) sprintf(&out[l-4], ""); else

	/* ʳ */
	if( CMPTAIL("") == 0) sprintf(&out[l-4], ""); else
	if( CMPTAIL("") == 0) sprintf(&out[l-4], ""); else
	if( CMPTAIL("") == 0) sprintf(&out[l-4], ""); else
	if( CMPTAIL("") == 0) sprintf(&out[l-4], ""); else
	if( CMPTAIL("") == 0) sprintf(&out[l-4], ""); else
	if( CMPTAIL("Ƥ") == 0) sprintf(&out[l-4], ""); else
	if( CMPTAIL("Ǥ") == 0) sprintf(&out[l-4], ""); else
	if( CMPTAIL("ͤ") == 0) sprintf(&out[l-4], ""); else
	if( CMPTAIL("ؤ") == 0) sprintf(&out[l-4], ""); else
	if( CMPTAIL("٤") == 0) sprintf(&out[l-4], ""); else
	if( CMPTAIL("") == 0) sprintf(&out[l-4], ""); else
	if( CMPTAIL("") == 0) sprintf(&out[l-4], ""); else

	/* ʳ */
	if( CMPTAIL("") == 0) sprintf(&out[l-2], ""); else
	if( CMPTAIL("") == 0) sprintf(&out[l-2], ""); else
	if( CMPTAIL("") == 0) sprintf(&out[l-2], ""); else
	if( CMPTAIL("") == 0) sprintf(&out[l-2], ""); else
	if( CMPTAIL("") == 0) sprintf(&out[l-2], ""); else
	if( CMPTAIL("") == 0) sprintf(&out[l-2], ""); else
	if( CMPTAIL("") == 0) sprintf(&out[l-2], ""); else
	if( CMPTAIL("") == 0) sprintf(&out[l-2], ""); else
	if( CMPTAIL("") == 0) sprintf(&out[l-2], ""); else
	if( CMPTAIL("") == 0) sprintf(&out[l-2], ""); else
	if( CMPTAIL("") == 0) sprintf(&out[l-2], ""); else
	if( CMPTAIL("") == 0) sprintf(&out[l-2], ""); else

	sprintf(&out[l], "");
}

/* , -> äƽ */
static void jverb2( const char *in , char *out)
{
	int l = strlen(in);
	strcpy(out,in);

	/* ѳʳ */
	if( CMPTAIL("") == 0) sprintf(&out[l-4], ""); else

	/* ʳ */
	if( CMPTAIL("") == 0) sprintf(&out[l-4], ""); else

	/* ʳ */
	if( CMPTAIL("") == 0) sprintf(&out[l-4], ""); else
	if( CMPTAIL("") == 0) sprintf(&out[l-4], ""); else
	if( CMPTAIL("") == 0) sprintf(&out[l-4], ""); else
	if( CMPTAIL("") == 0) sprintf(&out[l-4], ""); else
	if( CMPTAIL("") == 0) sprintf(&out[l-4], ""); else
	if( CMPTAIL("Ƥ") == 0) sprintf(&out[l-4], "Ƥä"); else
	if( CMPTAIL("Ǥ") == 0) sprintf(&out[l-4], "Ǥ"); else
	if( CMPTAIL("ͤ") == 0) sprintf(&out[l-4], "ͤ"); else
	if( CMPTAIL("ؤ") == 0) sprintf(&out[l-4], "ؤ"); else
	if( CMPTAIL("٤") == 0) sprintf(&out[l-4], "٤"); else
	if( CMPTAIL("") == 0) sprintf(&out[l-4], ""); else
	if( CMPTAIL("") == 0) sprintf(&out[l-4], ""); else

	/* ʳ */
	if( CMPTAIL("") == 0) sprintf(&out[l-2], "ä"); else
	if( CMPTAIL("") == 0) sprintf(&out[l-2], ""); else
	if( CMPTAIL("") == 0) sprintf(&out[l-2], ""); else
	if( CMPTAIL("") == 0) sprintf(&out[l-2], ""); else
	if( CMPTAIL("") == 0) sprintf(&out[l-2], ""); else
	if( CMPTAIL("") == 0) sprintf(&out[l-2], "ä"); else
	if( CMPTAIL("") == 0) sprintf(&out[l-2], "ä"); else
	if( CMPTAIL("") == 0) sprintf(&out[l-2], "ͤ"); else
	if( CMPTAIL("") == 0) sprintf(&out[l-2], "ؤ"); else
	if( CMPTAIL("") == 0) sprintf(&out[l-2], ""); else
	if( CMPTAIL("") == 0) sprintf(&out[l-2], ""); else
	if( CMPTAIL("") == 0) sprintf(&out[l-2], "ä"); else

	sprintf(&out[l], "Ȥˤ");
}

/* , -> ä꽳ä */
static void jverb3( const char *in , char *out)
{
	int l = strlen(in);
	strcpy(out, in);

	/* ѳʳ */
	if( CMPTAIL("") == 0) sprintf(&out[l-4], ""); else

	/* ʳ */
	if( CMPTAIL("") == 0) sprintf(&out[l-4], ""); else

	/* ʳ */
	if( CMPTAIL("") == 0) sprintf(&out[l-4], ""); else
	if( CMPTAIL("") == 0) sprintf(&out[l-4], ""); else
	if( CMPTAIL("") == 0) sprintf(&out[l-4], ""); else
	if( CMPTAIL("") == 0) sprintf(&out[l-4], ""); else
	if( CMPTAIL("") == 0) sprintf(&out[l-4], ""); else
	if( CMPTAIL("Ƥ") == 0) sprintf(&out[l-4], "Ƥä"); else
	if( CMPTAIL("Ǥ") == 0) sprintf(&out[l-4], "Ǥ"); else
	if( CMPTAIL("ͤ") == 0) sprintf(&out[l-4], "ͤ"); else
	if( CMPTAIL("ؤ") == 0) sprintf(&out[l-4], "ؤ"); else
	if( CMPTAIL("٤") == 0) sprintf(&out[l-4], "٤"); else
	if( CMPTAIL("") == 0) sprintf(&out[l-4], "᤿"); else
	if( CMPTAIL("") == 0) sprintf(&out[l-4], "줿"); else

	/* ʳ */
	if( CMPTAIL("") == 0) sprintf(&out[l-2], "ä"); else
	if( CMPTAIL("") == 0) sprintf(&out[l-2], ""); else
	if( CMPTAIL("") == 0) sprintf(&out[l-2], ""); else
	if( CMPTAIL("") == 0) sprintf(&out[l-2], ""); else
	if( CMPTAIL("") == 0) sprintf(&out[l-2], ""); else
	if( CMPTAIL("") == 0) sprintf(&out[l-2], "ä"); else
	if( CMPTAIL("") == 0) sprintf(&out[l-2], "ä"); else
	if( CMPTAIL("") == 0) sprintf(&out[l-2], "ͤ"); else
	if( CMPTAIL("") == 0) sprintf(&out[l-2], "ؤ"); else
	if( CMPTAIL("") == 0) sprintf(&out[l-2], ""); else
	if( CMPTAIL("") == 0) sprintf(&out[l-2], ""); else
	if( CMPTAIL("") == 0) sprintf(&out[l-2], "ä"); else

	sprintf(&out[l], "Ȥ");
}


void jverb( const char *in , char *out , int flag)
{
  switch (flag)
  {
	  case JVERB_AND: jverb1(in , out); break;
	  case JVERB_TO : jverb2(in , out); break;
	  case JVERB_OR : jverb3(in , out); break;
  }
}

#if 0
static bool iskinsoku(cptr ch)
{
	cptr kinsoku[] =
	{
		"", "", "", "", "", "", "",
			"", "", "", "", "", "", "", 
			"", "", "", "", "", 
			"", "", "", "", "", "", "", "", "",
			"", "", "", "", "", "", "", "", "",
			NULL
	};

	int i;
	
	for (i = 0; kinsoku[i]; i++)
	{
		if (streq(ch, kinsoku[i]))
		{
			return TRUE;
		}
	}
	return FALSE;
}
#endif


/*
*   ܸޤĹʸŬʰ֤ǲԤƥ˽񤭹
*   : str = " abc dddd eeeeeeeee", wlen = 6
*   ΤȤ tbuf="\0\0abc\0dddd\0eeeeee\0eee\0\0"
*/
void roff_to_buf(cptr str, int maxlen, char *tbuf, size_t bufsize)
{
	int read_pt = 0;
	int write_pt = 0;
	int line_len = 0;
	int word_punct = 0;
	char ch[3];
	ch[2] = '\0';
	
	while (str[read_pt])
	{
#ifdef JP
		bool kinsoku = FALSE;
		bool kanji;
#endif
		int ch_len = 1;
		
		/* Prepare one character */
		ch[0] = str[read_pt];
		ch[1] = '\0';
#ifdef JP
		kanji  = iskanji(ch[0]);
		
		if (kanji)
		{
			ch[1] = str[read_pt+1];
			ch_len = 2;
			
			if (strcmp(ch, "") == 0 ||
				strcmp(ch, "") == 0 ||
				strcmp(ch, "") == 0 ||
				strcmp(ch, "") == 0)
				kinsoku = TRUE;
		}
		else if (!isprint(ch[0]))
			ch[0] = ' ';
#else
		if (!isprint(ch[0]))
			ch[0] = ' ';
#endif
		
		if (line_len + ch_len > maxlen - 1 || str[read_pt] == '\n')
		{
			int word_len;
			
			/* return to better wrapping point. */
			/* Space character at the end of the line need not to be printed. */
			word_len = read_pt - word_punct;
#ifdef JP
			if (kanji && !kinsoku)
				/* nothing */ ;
				else
#endif
				if (ch[0] == ' ' || word_len >= line_len/2)
					read_pt++;
				else
				{
					read_pt = word_punct;
					if (str[word_punct] == ' ')
						read_pt++;
					write_pt -= word_len;
				}
				
				tbuf[write_pt++] = '\0';
				line_len = 0;
				word_punct = read_pt;
				continue;
		}
		if (ch[0] == ' ')
			word_punct = read_pt;
#ifdef JP
		if (!kinsoku) word_punct = read_pt;
#endif

		/* Not enough buffer size */
		if ((size_t)(write_pt + 3) >= bufsize) break;

		tbuf[write_pt++] = ch[0];
		line_len++;
		read_pt++;
#ifdef JP
		if (kanji)
		{
			tbuf[write_pt++] = ch[1];
			line_len++;
			read_pt++;
		}
#endif
	}
	tbuf[write_pt] = '\0';
	tbuf[write_pt+1] = '\0';
	
	return;
}

/* Ϳ줿ʸ򤽤줾δĶ˹äɤˤ */
void codeconv(char *str)
{
	int i;
	int kanji = 0, iseuc = 1, issjis = 1;
	int len, len2;
	unsigned char c1, c2;
	unsigned char *tmp;
	
	/* ¸ߤδɤEUCɤĴ٤롣*/
	
	/* EUC ꤷ̷⤬̵Ĵ٤ */
	for (i = 0; str[i]; i++)
	{
		c1 = str[i];
		if (c1 & 0x80)
		{
			kanji = 1;
			i++;
			c2 = str[i];
			
			if ((c1 < 0xa1) || (c1 > 0xf4) || (c2 < 0xa1) || (c2 > 0xfe) ||
				((c1 == 0xf4) && (c2 > 0xa6)))
			{
				iseuc = 0;
				break;
			}
		}
	}
	len = i + 1;
	
	/* SJIS ꤷ̷⤬̵Ĵ٤ */
	for (i = 0; str[i]; i++)
	{
		c1 = str[i];
		if (c1 & 0x80)
		{
			kanji = 1;
			if ((c1 >= 0xa0) && (c1 <= 0xdf)) continue;
			
			i++;
			c2 = str[i];
			
			if ((c1 < 0x81) || (c1 > 0xea) || (c2 < 0x40) || (c2 > 0xfc) ||
				((c1 == 0xea) && (c2 > 0xa4))) 
			{
				issjis = 0;
				break;
			}
		}
	}
	len2 = i + 1;
	
	/* strĹ+1(tmp) */
	if (len2 > len) len = len2;
	
	/* Ѵ롣
	* ɤȤ,뤤ϲƤƤɤǤʤ
	* Ѵʤ
	*/
	
	/* if (kanji && !iseuc && !issjis) msg_print("codeconv:ٹ𡪲줿"); */
	
#ifdef EUC
	if (kanji && !iseuc && issjis) /* SJIS -> EUC */
	{
		C_MAKE(tmp, len, byte);
		
		for (i = 0; str[i]; i++)
		{
			c1 = str[i];
			if (c1 & 0x80)
			{
				if (c1 >= 0xa0 && c1 <= 0xdf)
				{
					tmp[i] = ' ';
				}
				else
				{
					i++;
					c2 = str[i];
					if (c2 >= 0x9f)
					{
						c1 = c1 * 2 - (c1 >= 0xe0 ? 0xe0 : 0x60);
						c2 += 2;
					}
					else
					{
						c1 = c1 * 2 - (c1 >= 0xe0 ? 0xe1 : 0x61);
						c2 += 0x60 + (c2 < 0x7f);
					}
					tmp[i - 1] = c1;
					tmp[i] = c2;
				}
			}
			else
				tmp[i] = c1;
		}
		tmp[i] = '\0';
		strcpy(str, (char *)tmp);
		
		C_KILL(tmp, len, byte);
	}
#endif
	
#ifdef SJIS
	if (kanji && iseuc && !issjis) /* EUC -> SJIS */
	{
		C_MAKE(tmp, len, byte);
		
		for (i = 0; str[i]; i++)
		{
			c1 = str[i];
			if (c1 & 0x80)
			{
				i++;
				c2 = str[i];
				if (c1 % 2)
				{
					c1 = (c1 >> 1) + (c1 < 0xdf ? 0x31 : 0x71);
					c2 -= 0x60 + (c2 < 0xe0);
				}
				else
				{
					c1 = (c1 >> 1) + (c1 < 0xdf ? 0x30 : 0x70);
					c2 -= 2;
				}
				tmp[i - 1] = c1;
				tmp[i] = c2;
			}
			else
				tmp[i] = c1;
		}
		tmp[i] = '\0';
		strcpy(str, tmp);
		
		C_KILL(tmp, len, byte);
	}
#endif
}

#endif
