/* File: tables.c */

/* Purpose: Angband Tables */

/*
 * Copyright (c) 1989 James E. Wilson, Robert A. Koeneke
 *
 * This software may be copied and distributed for educational, research, and
 * not for profit purposes provided that this copyright and statement are
 * included in all such copies.
 */

#include "angband.h"




/*
 * Global array for looping through the "keypad directions"
 */
s16b ddd[9] =
{ 2, 8, 6, 4, 3, 1, 9, 7, 5 };

/*
 * Global arrays for converting "keypad direction" into offsets
 */
s16b ddx[10] =
{ 0, -1, 0, 1, -1, 0, 1, -1, 0, 1 };

s16b ddy[10] =
{ 0, 1, 1, 1, 0, 0, 0, -1, -1, -1 };

/*
 * Global arrays for optimizing "ddx[ddd[i]]" and "ddy[ddd[i]]"
 */
s16b ddx_ddd[9] =
{ 0, 0, 1, -1, 1, -1, 1, -1, 0 };

s16b ddy_ddd[9] =
{ 1, -1, 0, 0, 1, 1, -1, -1, 0 };


/*
 * Circular keypad direction array
 */
s16b cdd[8] =
{ 2, 3, 6, 9, 8, 7, 4, 1 };

/*
 * Global arrays for optimizing "ddx[cdd[i]]" and "ddy[cdd[i]]"
 */
s16b ddx_cdd[8] =
{ 0, 1, 1, 1, 0, -1, -1, -1 };

s16b ddy_cdd[8] =
{ 1, 1, 0, -1, -1, -1, 0, 1 };



/*
 * Global array for converting numbers to uppercase hecidecimal digit
 * This array can also be used to convert a number to an octal digit
 */
char hexsym[16] =
{
	'0', '1', '2', '3', '4', '5', '6', '7',
	'8', '9', 'A', 'B', 'C', 'D', 'E', 'F'
};


/*
 * Global array for converting numbers to a logical list symbol
 */
char listsym[] =
{
	'0', '1', '2', '3', '4', '5', '6', '7', '8', '9',
	'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm',
	'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z',
	'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M',
	'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z',
	'\0'
};


/*
 * Encode the screen colors
 */
cptr color_char = "dwsorgbuDWvyRGBU";


/*
 * Stat Table (INT/WIS) -- Number of half-spells per level
 */
byte adj_mag_study[] =
{
	0	/* 3 */,
	0	/* 4 */,
	0	/* 5 */,
	0	/* 6 */,
	0	/* 7 */,
	1	/* 8 */,
	1	/* 9 */,
	1	/* 10 */,
	1	/* 11 */,
	2	/* 12 */,
	2	/* 13 */,
	2	/* 14 */,
	2	/* 15 */,
	2	/* 16 */,
	2	/* 17 */,
	2	/* 18/00-18/09 */,
	2	/* 18/10-18/19 */,
	2	/* 18/20-18/29 */,
	2	/* 18/30-18/39 */,
	2	/* 18/40-18/49 */,
	3	/* 18/50-18/59 */,
	3	/* 18/60-18/69 */,
	3	/* 18/70-18/79 */,
	3	/* 18/80-18/89 */,
	4	/* 18/90-18/99 */,
	4	/* 18/100-18/109 */,
	4	/* 18/110-18/119 */,
	5	/* 18/120-18/129 */,
	5	/* 18/130-18/139 */,
	5	/* 18/140-18/149 */,
	5	/* 18/150-18/159 */,
	5	/* 18/160-18/169 */,
	5	/* 18/170-18/179 */,
	5	/* 18/180-18/189 */,
	5	/* 18/190-18/199 */,
	5	/* 18/200-18/209 */,
	6	/* 18/210-18/219 */,
	6	/* 18/220+ */
};


/*
 * Stat Table (INT/WIS) -- extra half-mana-points per level
 */
byte adj_mag_mana[] =
{
	0       /* 3 */,
	0       /* 4 */,
	0       /* 5 */,
	0       /* 6 */,
	0       /* 7 */,
	1       /* 8 */,
	1       /* 9 */,
	2       /* 10 */,
	3       /* 11 */,
	4       /* 12 */,
	5       /* 13 */,
	6       /* 14 */,
	7       /* 15 */,
	8       /* 16 */,
	9       /* 17 */,
	10     /* 18/00-18/09 */,
	10      /* 18/10-18/19 */,
	11      /* 18/20-18/29 */,
	11     /* 18/30-18/39 */,
	12     /* 18/40-18/49 */,
	12      /* 18/50-18/59 */,
	13      /* 18/60-18/69 */,
	13      /* 18/70-18/79 */,
	14      /* 18/80-18/89 */,
	14      /* 18/90-18/99 */,
	15      /* 18/100-18/109 */,
	16      /* 18/110-18/119 */,
	17      /* 18/120-18/129 */,
	18      /* 18/130-18/139 */,
	19      /* 18/140-18/149 */,
	20      /* 18/150-18/159 */,
	21      /* 18/160-18/169 */,
	22      /* 18/170-18/179 */,
	23      /* 18/180-18/189 */,
	24      /* 18/190-18/199 */,
	25      /* 18/200-18/209 */,
	26      /* 18/210-18/219 */,
	27      /* 18/220+ */
};


/*
 * Stat Table (INT/WIS) -- Minimum failure rate (percentage)
 */
byte adj_mag_fail[] =
{
	99      /* 3 */,
	99      /* 4 */,
	99      /* 5 */,
	99      /* 6 */,
	99      /* 7 */,
	50      /* 8 */,
	30      /* 9 */,
	20      /* 10 */,
	15      /* 11 */,
	12      /* 12 */,
	11      /* 13 */,
	10      /* 14 */,
	9       /* 15 */,
	8       /* 16 */,
	7       /* 17 */,
	6       /* 18/00-18/09 */,
	6       /* 18/10-18/19 */,
	5       /* 18/20-18/29 */,
	5       /* 18/30-18/39 */,
	5       /* 18/40-18/49 */,
	4       /* 18/50-18/59 */,
	4       /* 18/60-18/69 */,
	4       /* 18/70-18/79 */,
	4       /* 18/80-18/89 */,
	3       /* 18/90-18/99 */,
	3       /* 18/100-18/109 */,
	2       /* 18/110-18/119 */,
	2       /* 18/120-18/129 */,
	2       /* 18/130-18/139 */,
	2       /* 18/140-18/149 */,
	1       /* 18/150-18/159 */,
	1       /* 18/160-18/169 */,
	1       /* 18/170-18/179 */,
	1       /* 18/180-18/189 */,
	1       /* 18/190-18/199 */,
	0       /* 18/200-18/209 */,
	0       /* 18/210-18/219 */,
	0       /* 18/220+ */
};


/*
 * Stat Table (INT/WIS) -- Various things
 */
byte adj_mag_stat[] =
{
	0       /* 3 */,
	0       /* 4 */,
	0       /* 5 */,
	0       /* 6 */,
	0       /* 7 */,
	1       /* 8 */,
	1       /* 9 */,
	1       /* 10 */,
	1       /* 11 */,
	1       /* 12 */,
	1       /* 13 */,
	1       /* 14 */,
	2       /* 15 */,
	2       /* 16 */,
	2       /* 17 */,
	3       /* 18/00-18/09 */,
	3       /* 18/10-18/19 */,
	3       /* 18/20-18/29 */,
	3       /* 18/30-18/39 */,
	3       /* 18/40-18/49 */,
	4       /* 18/50-18/59 */,
	4       /* 18/60-18/69 */,
	5       /* 18/70-18/79 */,
	6       /* 18/80-18/89 */,
	7       /* 18/90-18/99 */,
	8       /* 18/100-18/109 */,
	9       /* 18/110-18/119 */,
	10      /* 18/120-18/129 */,
	11      /* 18/130-18/139 */,
	12      /* 18/140-18/149 */,
	13      /* 18/150-18/159 */,
	14      /* 18/160-18/169 */,
	15      /* 18/170-18/179 */,
	16      /* 18/180-18/189 */,
	17      /* 18/190-18/199 */,
	18      /* 18/200-18/209 */,
	19      /* 18/210-18/219 */,
	20      /* 18/220+ */
};


/*
 * Stat Table (CHR) -- payment percentages
 */
byte adj_chr_gold[] =
{
	130     /* 3 */,
	125     /* 4 */,
	122     /* 5 */,
	120     /* 6 */,
	118     /* 7 */,
	116     /* 8 */,
	114     /* 9 */,
	112     /* 10 */,
	110     /* 11 */,
	108     /* 12 */,
	106     /* 13 */,
	104     /* 14 */,
	103     /* 15 */,
	102     /* 16 */,
	101     /* 17 */,
	100     /* 18/00-18/09 */,
	99      /* 18/10-18/19 */,
	98      /* 18/20-18/29 */,
	97      /* 18/30-18/39 */,
	96      /* 18/40-18/49 */,
	95      /* 18/50-18/59 */,
	94      /* 18/60-18/69 */,
	93      /* 18/70-18/79 */,
	92      /* 18/80-18/89 */,
	91      /* 18/90-18/99 */,
	90      /* 18/100-18/109 */,
	89      /* 18/110-18/119 */,
	88      /* 18/120-18/129 */,
	87      /* 18/130-18/139 */,
	86      /* 18/140-18/149 */,
	85      /* 18/150-18/159 */,
	84      /* 18/160-18/169 */,
	83      /* 18/170-18/179 */,
	82      /* 18/180-18/189 */,
	81      /* 18/190-18/199 */,
	80      /* 18/200-18/209 */,
	79      /* 18/210-18/219 */,
	78      /* 18/220+ */
};


/*
 * Stat Table (INT) -- Magic devices
 */
byte adj_int_dev[] =
{
	0       /* 3 */,
	0       /* 4 */,
	0       /* 5 */,
	0       /* 6 */,
	0       /* 7 */,
	1       /* 8 */,
	1       /* 9 */,
	1       /* 10 */,
	1       /* 11 */,
	1       /* 12 */,
	1       /* 13 */,
	1       /* 14 */,
	2       /* 15 */,
	2       /* 16 */,
	2       /* 17 */,
	3       /* 18/00-18/09 */,
	3       /* 18/10-18/19 */,
	4       /* 18/20-18/29 */,
	4       /* 18/30-18/39 */,
	5       /* 18/40-18/49 */,
	5       /* 18/50-18/59 */,
	6       /* 18/60-18/69 */,
	6       /* 18/70-18/79 */,
	7       /* 18/80-18/89 */,
	7       /* 18/90-18/99 */,
	8       /* 18/100-18/109 */,
	9       /* 18/110-18/119 */,
	10      /* 18/120-18/129 */,
	11      /* 18/130-18/139 */,
	12      /* 18/140-18/149 */,
	13      /* 18/150-18/159 */,
	14      /* 18/160-18/169 */,
	15      /* 18/170-18/179 */,
	16      /* 18/180-18/189 */,
	17      /* 18/190-18/199 */,
	18      /* 18/200-18/209 */,
	19      /* 18/210-18/219 */,
	20      /* 18/220+ */
};


/*
 * Stat Table (WIS) -- Saving throw
 */
byte adj_wis_sav[] =
{
	0       /* 3 */,
	0       /* 4 */,
	0       /* 5 */,
	0       /* 6 */,
	0       /* 7 */,
	1       /* 8 */,
	1       /* 9 */,
	1       /* 10 */,
	1       /* 11 */,
	1       /* 12 */,
	1       /* 13 */,
	1       /* 14 */,
	2       /* 15 */,
	2       /* 16 */,
	2       /* 17 */,
	3       /* 18/00-18/09 */,
	3       /* 18/10-18/19 */,
	3       /* 18/20-18/29 */,
	3       /* 18/30-18/39 */,
	3       /* 18/40-18/49 */,
	4       /* 18/50-18/59 */,
	4       /* 18/60-18/69 */,
	5       /* 18/70-18/79 */,
	5       /* 18/80-18/89 */,
	6       /* 18/90-18/99 */,
	7       /* 18/100-18/109 */,
	8       /* 18/110-18/119 */,
	9       /* 18/120-18/129 */,
	10      /* 18/130-18/139 */,
	11      /* 18/140-18/149 */,
	12      /* 18/150-18/159 */,
	13      /* 18/160-18/169 */,
	14      /* 18/170-18/179 */,
	15      /* 18/180-18/189 */,
	16      /* 18/190-18/199 */,
	17      /* 18/200-18/209 */,
	18      /* 18/210-18/219 */,
	19      /* 18/220+ */
};


/*
 * Stat Table (DEX) -- disarming
 */
byte adj_dex_dis[] =
{
	0       /* 3 */,
	0       /* 4 */,
	0       /* 5 */,
	0       /* 6 */,
	0       /* 7 */,
	0       /* 8 */,
	0       /* 9 */,
	0       /* 10 */,
	0       /* 11 */,
	0       /* 12 */,
	1       /* 13 */,
	1       /* 14 */,
	1       /* 15 */,
	2       /* 16 */,
	2       /* 17 */,
	4       /* 18/00-18/09 */,
	4       /* 18/10-18/19 */,
	4       /* 18/20-18/29 */,
	4       /* 18/30-18/39 */,
	5       /* 18/40-18/49 */,
	5       /* 18/50-18/59 */,
	5       /* 18/60-18/69 */,
	6       /* 18/70-18/79 */,
	6       /* 18/80-18/89 */,
	7       /* 18/90-18/99 */,
	8       /* 18/100-18/109 */,
	8       /* 18/110-18/119 */,
	8       /* 18/120-18/129 */,
	8       /* 18/130-18/139 */,
	8       /* 18/140-18/149 */,
	9       /* 18/150-18/159 */,
	9       /* 18/160-18/169 */,
	9       /* 18/170-18/179 */,
	9       /* 18/180-18/189 */,
	9       /* 18/190-18/199 */,
	10      /* 18/200-18/209 */,
	10      /* 18/210-18/219 */,
	10      /* 18/220+ */
};


/*
 * Stat Table (INT) -- disarming
 */
byte adj_int_dis[] =
{
	0       /* 3 */,
	0       /* 4 */,
	0       /* 5 */,
	0       /* 6 */,
	0       /* 7 */,
	1       /* 8 */,
	1       /* 9 */,
	1       /* 10 */,
	1       /* 11 */,
	1       /* 12 */,
	1       /* 13 */,
	1       /* 14 */,
	2       /* 15 */,
	2       /* 16 */,
	2       /* 17 */,
	3       /* 18/00-18/09 */,
	3       /* 18/10-18/19 */,
	3       /* 18/20-18/29 */,
	4       /* 18/30-18/39 */,
	4       /* 18/40-18/49 */,
	5       /* 18/50-18/59 */,
	6       /* 18/60-18/69 */,
	7       /* 18/70-18/79 */,
	8       /* 18/80-18/89 */,
	9       /* 18/90-18/99 */,
	10      /* 18/100-18/109 */,
	10      /* 18/110-18/119 */,
	11      /* 18/120-18/129 */,
	12      /* 18/130-18/139 */,
	13      /* 18/140-18/149 */,
	14      /* 18/150-18/159 */,
	15      /* 18/160-18/169 */,
	16      /* 18/170-18/179 */,
	17      /* 18/180-18/189 */,
	18      /* 18/190-18/199 */,
	19      /* 18/200-18/209 */,
	19      /* 18/210-18/219 */,
	20      /* 18/220+ */
};


/*
 * Stat Table (DEX) -- bonus to ac (plus 128)
 */
byte adj_dex_ta[] =
{
	128 + -4    /*  3 */,
	128 + -3    /*  4 */,
	128 + -2    /*  5 */,
	128 + -1    /*  6 */,
	128 + 0     /*  7 */,
	128 + 0     /*  8 */,
	128 + 0     /*  9 */,
	128 + 0     /* 10 */,
	128 + 0     /* 11 */,
	128 + 0     /* 12 */,
	128 + 0     /* 13 */,
	128 + 0     /* 14 */,
	128 + 1     /* 15 */,
	128 + 1     /* 16 */,
	128 + 1     /* 17 */,
	128 + 2     /* 18/00-18/09 */,
	128 + 2     /* 18/10-18/19 */,
	128 + 2     /* 18/20-18/29 */,
	128 + 2     /* 18/30-18/39 */,
	128 + 2     /* 18/40-18/49 */,
	128 + 3     /* 18/50-18/59 */,
	128 + 3     /* 18/60-18/69 */,
	128 + 3     /* 18/70-18/79 */,
	128 + 4     /* 18/80-18/89 */,
	128 + 5     /* 18/90-18/99 */,
	128 + 6     /* 18/100-18/109 */,
	128 + 7     /* 18/110-18/119 */,
	128 + 8     /* 18/120-18/129 */,
	128 + 9     /* 18/130-18/139 */,
	128 + 9     /* 18/140-18/149 */,
	128 + 10    /* 18/150-18/159 */,
	128 + 11    /* 18/160-18/169 */,
	128 + 12    /* 18/170-18/179 */,
	128 + 13    /* 18/180-18/189 */,
	128 + 14    /* 18/190-18/199 */,
	128 + 15    /* 18/200-18/209 */,
	128 + 15    /* 18/210-18/219 */,
	128 + 16    /* 18/220+ */
};


/*
 * Stat Table (STR) -- bonus to Deadliness (plus 128).  To compensate
 * for changes elsewhere, STR now has a larger effect. -LM-
 */
byte adj_str_td[] =
{
	128 + -2	/* 3 */,
	128 + -2	/* 4 */,
	128 + -1	/* 5 */,
	128 + -1	/* 6 */,
	128 + 0	/* 7 */,
	128 + 0	/* 8 */,
	128 + 0	/* 9 */,
	128 + 0	/* 10 */,
	128 + 0	/* 11 */,
	128 + 0	/* 12 */,
	128 + 0	/* 13 */,
	128 + 0	/* 14 */,
	128 + 0	/* 15 */,
	128 + 1	/* 16 */,
	128 + 2	/* 17 */,
	128 + 3	/* 18/00-18/09 */,
	128 + 4	/* 18/10-18/19 */,
	128 + 4	/* 18/20-18/29 */,
	128 + 5	/* 18/30-18/39 */,
	128 + 6	/* 18/40-18/49 */,
	128 + 7	/* 18/50-18/59 */,
	128 + 8	/* 18/60-18/69 */,
	128 + 9	/* 18/70-18/79 */,
	128 + 10	/* 18/80-18/89 */,
	128 + 11	/* 18/90-18/99 */,
	128 + 12	/* 18/100-18/109 */,
	128 + 13	/* 18/110-18/119 */,
	128 + 14	/* 18/120-18/129 */,
	128 + 15	/* 18/130-18/139 */,
	128 + 16	/* 18/140-18/149 */,
	128 + 17	/* 18/150-18/159 */,
	128 + 18	/* 18/160-18/169 */,
	128 + 19	/* 18/170-18/179 */,
	128 + 20	/* 18/180-18/189 */,
	128 + 21	/* 18/190-18/199 */,
	128 + 22	/* 18/200-18/209 */,
	128 + 23	/* 18/210-18/219 */,
	128 + 25	/* 18/220+ */
};


/*
 * Stat Table (DEX) -- bonus to Skill (plus 128.  To compensate for
 * changes elsewhere, DEX now has a larger effect. -LM-
 */
byte adj_dex_th[] =
{
	128 + -4	/* 3 */,
	128 + -3	/* 4 */,
	128 + -2	/* 5 */,
	128 + -1	/* 6 */,
	128 + -1	/* 7 */,
	128 + 0	/* 8 */,
	128 + 0	/* 9 */,
	128 + 0	/* 10 */,
	128 + 0	/* 11 */,
	128 + 0	/* 12 */,
	128 + 0	/* 13 */,
	128 + 0	/* 14 */,
	128 + 1	/* 15 */,
	128 + 2	/* 16 */,
	128 + 3	/* 17 */,
	128 + 3	/* 18/00-18/09 */,
	128 + 3	/* 18/10-18/19 */,
	128 + 4	/* 18/20-18/29 */,
	128 + 4	/* 18/30-18/39 */,
	128 + 4	/* 18/40-18/49 */,
	128 + 5	/* 18/50-18/59 */,
	128 + 5	/* 18/60-18/69 */,
	128 + 6	/* 18/70-18/79 */,
	128 + 6	/* 18/80-18/89 */,
	128 + 7	/* 18/90-18/99 */,
	128 + 8	/* 18/100-18/109 */,
	128 + 9	/* 18/110-18/119 */,
	128 + 10	/* 18/120-18/129 */,
	128 + 11	/* 18/130-18/139 */,
	128 + 12	/* 18/140-18/149 */,
	128 + 13	/* 18/150-18/159 */,
	128 + 14	/* 18/160-18/169 */,
	128 + 15	/* 18/170-18/179 */,
	128 + 16	/* 18/180-18/189 */,
	128 + 17	/* 18/190-18/199 */,
	128 + 18	/* 18/200-18/209 */,
	128 + 19	/* 18/210-18/219 */,
	128 + 20	/* 18/220+ */
};



/*
 * Stat Table (STR) -- weight limit in deca-pounds
 */
byte adj_str_wgt[] =
{
	5       /* 3 */,
	6       /* 4 */,
	7       /* 5 */,
	8       /* 6 */,
	9       /* 7 */,
	10      /* 8 */,
	11      /* 9 */,
	12      /* 10 */,
	13      /* 11 */,
	14      /* 12 */,
	15      /* 13 */,
	16      /* 14 */,
	17      /* 15 */,
	18      /* 16 */,
	19      /* 17 */,
	20      /* 18/00-18/09 */,
	22      /* 18/10-18/19 */,
	24      /* 18/20-18/29 */,
	26      /* 18/30-18/39 */,
	28      /* 18/40-18/49 */,
	30      /* 18/50-18/59 */,
	31      /* 18/60-18/69 */,
	31      /* 18/70-18/79 */,
	32      /* 18/80-18/89 */,
	32      /* 18/90-18/99 */,
	33      /* 18/100-18/109 */,
	33      /* 18/110-18/119 */,
	34      /* 18/120-18/129 */,
	34      /* 18/130-18/139 */,
	35      /* 18/140-18/149 */,
	35      /* 18/150-18/159 */,
	36      /* 18/160-18/169 */,
	36      /* 18/170-18/179 */,
	37      /* 18/180-18/189 */,
	37      /* 18/190-18/199 */,
	38      /* 18/200-18/209 */,
	38      /* 18/210-18/219 */,
	39      /* 18/220+ */
};


/*
 * Stat Table (STR) -- weapon weight limit in pounds
 */
byte adj_str_hold[] =
{
	4       /* 3 */,
	5       /* 4 */,
	6       /* 5 */,
	7       /* 6 */,
	8       /* 7 */,
	10      /* 8 */,
	12      /* 9 */,
	14      /* 10 */,
	16      /* 11 */,
	18      /* 12 */,
	20      /* 13 */,
	22      /* 14 */,
	24      /* 15 */,
	26      /* 16 */,
	28      /* 17 */,
	30      /* 18/00-18/09 */,
	30      /* 18/10-18/19 */,
	35      /* 18/20-18/29 */,
	40      /* 18/30-18/39 */,
	45      /* 18/40-18/49 */,
	50      /* 18/50-18/59 */,
	55      /* 18/60-18/69 */,
	60      /* 18/70-18/79 */,
	65      /* 18/80-18/89 */,
	70      /* 18/90-18/99 */,
	80      /* 18/100-18/109 */,
	80      /* 18/110-18/119 */,
	80      /* 18/120-18/129 */,
	80      /* 18/130-18/139 */,
	80      /* 18/140-18/149 */,
	90      /* 18/150-18/159 */,
	90      /* 18/160-18/169 */,
	90      /* 18/170-18/179 */,
	90      /* 18/180-18/189 */,
	90      /* 18/190-18/199 */,
	100     /* 18/200-18/209 */,
	100     /* 18/210-18/219 */,
	100     /* 18/220+ */
};


/*
 * Stat Table (STR) -- digging value
 */
byte adj_str_dig[] =
{
	0       /* 3 */,
	0       /* 4 */,
	1       /* 5 */,
	2       /* 6 */,
	3       /* 7 */,
	4       /* 8 */,
	4       /* 9 */,
	5       /* 10 */,
	5       /* 11 */,
	6       /* 12 */,
	6       /* 13 */,
	7       /* 14 */,
	7       /* 15 */,
	8       /* 16 */,
	8       /* 17 */,
	9       /* 18/00-18/09 */,
	10      /* 18/10-18/19 */,
	12      /* 18/20-18/29 */,
	15      /* 18/30-18/39 */,
	20      /* 18/40-18/49 */,
	25      /* 18/50-18/59 */,
	30      /* 18/60-18/69 */,
	35      /* 18/70-18/79 */,
	40      /* 18/80-18/89 */,
	45      /* 18/90-18/99 */,
	50      /* 18/100-18/109 */,
	55      /* 18/110-18/119 */,
	60      /* 18/120-18/129 */,
	65      /* 18/130-18/139 */,
	70      /* 18/140-18/149 */,
	75      /* 18/150-18/159 */,
	80      /* 18/160-18/169 */,
	85      /* 18/170-18/179 */,
	90      /* 18/180-18/189 */,
	95      /* 18/190-18/199 */,
	100     /* 18/200-18/209 */,
	100     /* 18/210-18/219 */,
	100     /* 18/220+ */
};


/*
 * Stat Table (STR) -- help index into the "blow" table
 */
byte adj_str_blow[] =
{
	3       /* 3 */,
	4       /* 4 */,
	5       /* 5 */,
	6       /* 6 */,
	7       /* 7 */,
	8       /* 8 */,
	9       /* 9 */,
	10      /* 10 */,
	11      /* 11 */,
	12      /* 12 */,
	13      /* 13 */,
	14      /* 14 */,
	15      /* 15 */,
	16      /* 16 */,
	17      /* 17 */,
	20 /* 18/00-18/09 */,
	30 /* 18/10-18/19 */,
	40 /* 18/20-18/29 */,
	50 /* 18/30-18/39 */,
	60 /* 18/40-18/49 */,
	70 /* 18/50-18/59 */,
	80 /* 18/60-18/69 */,
	90 /* 18/70-18/79 */,
	100 /* 18/80-18/89 */,
	110 /* 18/90-18/99 */,
	120 /* 18/100-18/109 */,
	130 /* 18/110-18/119 */,
	140 /* 18/120-18/129 */,
	150 /* 18/130-18/139 */,
	160 /* 18/140-18/149 */,
	170 /* 18/150-18/159 */,
	180 /* 18/160-18/169 */,
	190 /* 18/170-18/179 */,
	200 /* 18/180-18/189 */,
	210 /* 18/190-18/199 */,
	220 /* 18/200-18/209 */,
	230 /* 18/210-18/219 */,
	240 /* 18/220+ */
};


/*
 * Stat Table (DEX) -- index into the "blow" table
 */
byte adj_dex_blow[] =
{
	0       /* 3 */,
	0       /* 4 */,
	0       /* 5 */,
	0       /* 6 */,
	0       /* 7 */,
	0       /* 8 */,
	0       /* 9 */,
	1       /* 10 */,
	1       /* 11 */,
	1       /* 12 */,
	1       /* 13 */,
	1       /* 14 */,
	2       /* 15 */,
	2       /* 16 */,
	2       /* 17 */,
	2       /* 18/00-18/09 */,
	3       /* 18/10-18/19 */,
	3       /* 18/20-18/29 */,
	3       /* 18/30-18/39 */,
	4       /* 18/40-18/49 */,
	4       /* 18/50-18/59 */,
	5       /* 18/60-18/69 */,
	5       /* 18/70-18/79 */,
	6       /* 18/80-18/89 */,
	6       /* 18/90-18/99 */,
	7       /* 18/100-18/109 */,
	7       /* 18/110-18/119 */,
	8       /* 18/120-18/129 */,
	8       /* 18/130-18/139 */,
	9      /* 18/140-18/149 */,
	9      /* 18/150-18/159 */,
	10      /* 18/160-18/169 */,
	10      /* 18/170-18/179 */,
	11      /* 18/180-18/189 */,
	11      /* 18/190-18/199 */,
	12      /* 18/200-18/209 */,
	12      /* 18/210-18/219 */,
	13      /* 18/220+ */
};


/*
 * Stat Table (DEX) -- chance of avoiding "theft" and "falling"
 */
byte adj_dex_safe[] =
{
	0       /* 3 */,
	1       /* 4 */,
	2       /* 5 */,
	3       /* 6 */,
	4       /* 7 */,
	5       /* 8 */,
	5       /* 9 */,
	6       /* 10 */,
	6       /* 11 */,
	7       /* 12 */,
	7       /* 13 */,
	8       /* 14 */,
	8       /* 15 */,
	9       /* 16 */,
	9       /* 17 */,
	10      /* 18/00-18/09 */,
	10      /* 18/10-18/19 */,
	15      /* 18/20-18/29 */,
	15      /* 18/30-18/39 */,
	20      /* 18/40-18/49 */,
	25      /* 18/50-18/59 */,
	30      /* 18/60-18/69 */,
	35      /* 18/70-18/79 */,
	40      /* 18/80-18/89 */,
	45      /* 18/90-18/99 */,
	50      /* 18/100-18/109 */,
	60      /* 18/110-18/119 */,
	70      /* 18/120-18/129 */,
	80      /* 18/130-18/139 */,
	90      /* 18/140-18/149 */,
	100     /* 18/150-18/159 */,
	100     /* 18/160-18/169 */,
	100     /* 18/170-18/179 */,
	100     /* 18/180-18/189 */,
	100     /* 18/190-18/199 */,
	100     /* 18/200-18/209 */,
	100     /* 18/210-18/219 */,
	100     /* 18/220+ */
};


/*
 * Stat Table (CON) -- base regeneration rate
 */
byte adj_con_fix[] =
{
	0       /* 3 */,
	0       /* 4 */,
	0       /* 5 */,
	0       /* 6 */,
	0       /* 7 */,
	0       /* 8 */,
	0       /* 9 */,
	0       /* 10 */,
	0       /* 11 */,
	0       /* 12 */,
	0       /* 13 */,
	1       /* 14 */,
	1       /* 15 */,
	1       /* 16 */,
	1       /* 17 */,
	2       /* 18/00-18/09 */,
	2       /* 18/10-18/19 */,
	2       /* 18/20-18/29 */,
	2       /* 18/30-18/39 */,
	2       /* 18/40-18/49 */,
	3       /* 18/50-18/59 */,
	3       /* 18/60-18/69 */,
	3       /* 18/70-18/79 */,
	3       /* 18/80-18/89 */,
	3       /* 18/90-18/99 */,
	4       /* 18/100-18/109 */,
	4       /* 18/110-18/119 */,
	5       /* 18/120-18/129 */,
	6       /* 18/130-18/139 */,
	6       /* 18/140-18/149 */,
	7       /* 18/150-18/159 */,
	7       /* 18/160-18/169 */,
	8       /* 18/170-18/179 */,
	8       /* 18/180-18/189 */,
	8       /* 18/190-18/199 */,
	9       /* 18/200-18/209 */,
	9       /* 18/210-18/219 */,
	9       /* 18/220+ */
};


/*
 * Stat Table (CON) -- extra half-hitpoints per level (plus 128).
 * Because monsters don't breath as powerfully now, I have reduced the
 * effect of this stat. -LM-
 */
byte adj_con_mhp[] =
{
	128 + -5 /* 3 */,
	128 + -3 /* 4 */,
	128 + -2 /* 5 */,
	128 + -1 /* 6 */,
	128 + 0  /* 7 */,
	128 + 0  /* 8 */,
	128 + 0  /* 9 */,
	128 + 0  /* 10 */,
	128 + 0  /* 11 */,
	128 + 0  /* 12 */,
	128 + 0  /* 13 */,
	128 + 1  /* 14 */,
	128 + 1  /* 15 */,
	128 + 2  /* 16 */,
	128 + 3  /* 17 */,
	128 + 4  /* 18/00-18/09 */,
	128 + 5  /* 18/10-18/19 */,
	128 + 6  /* 18/20-18/29 */,
	128 + 7  /* 18/30-18/39 */,
	128 + 8  /* 18/40-18/49 */,
	128 + 9  /* 18/50-18/59 */,
	128 + 10 /* 18/60-18/69 */,
	128 + 11 /* 18/70-18/79 */,
	128 + 12 /* 18/80-18/89 */,
	128 + 14 /* 18/90-18/99 */,
	128 + 17 /* 18/100-18/109 */,
	128 + 20 /* 18/110-18/119 */,
	128 + 23 /* 18/120-18/129 */,
	128 + 26 /* 18/130-18/139 */,
	128 + 29 /* 18/140-18/149 */,
	128 + 32 /* 18/150-18/159 */,
	128 + 35 /* 18/160-18/169 */,
	128 + 38 /* 18/170-18/179 */,
	128 + 40 /* 18/180-18/189 */,
	128 + 42 /* 18/190-18/199 */,
	128 + 44 /* 18/200-18/209 */,
	128 + 46 /* 18/210-18/219 */,
	128 + 48 /* 18/220+ */
};


/*
 * This table is used to help calculate the number of blows the player can
 * make in a single round of attacks (one player turn) with a normal weapon.
 *
 * This number ranges from a single blow/round for weak players to up to six
 * blows/round for powerful warriors.
 *
 * Note that certain artifacts and ego-items give "bonus" blows/round.
 *
 * First, from the player class, we extract some values:
 *
 * Warrior      --> num = 5; mul =   5; div = MAX(30, weapon_weight);
 * Mage         --> num = 2; mul =   2; div = MAX(40, weapon_weight);
 * Priest       --> num = 4; mul =   3; div = MAX(35, weapon_weight);
 * Ranger       --> num = 4; mul = 3.5; div = MAX(35, weapon_weight);
 * Paladin      --> num = 4; mul = 4.5; div = MAX(30, weapon_weight);
 * Warrior-Mage --> num = 4; mul =   4; div = MAX(30, weapon_weight);
 * Mindcrafter  --> num = 4; mul =   3; div = MAX(30, weapon_weight);
 * Archer       --> num = 3; mul =   3; div = MAX(30, weapon_weight);
 *
 * To get "P", we look up the relevant "adj_str_blow[]" (see above),
 * multiply it by "mul", and then divide it by "div", rounding down.
 *
 * To get "D", we look up the relevant "adj_dex_blow[]" (see above),
 * note especially column 6 (DEX 18/101) and 11 (DEX 18/150).
 *
 * The player gets "blows_table[P][D]" blows/round, as shown below,
 * up to a maximum of "num" blows/round, plus any "bonus" blows/round.
 */
byte blows_table[12][12] =
{
	/* P/D */
	/*      0,   1,   2,   3,   4,   5,   6,   7,   8,   9,  10,  11+ */
	/*      3   10   15  /10  /40  /60  /80 /100 /120 /140 /160 /180  */
/* 0 */{	1,   1,   1,   2,   2,   2,   2,   2,   3,   3,   3,   4 },
/* 1 */{	1,   1,   2,   2,   2,   3,   3,   3,   3,   4,   4,   4 },
/* 2 */{	1,   2,   2,   2,   3,   3,   4,   4,   4,   5,   5,   5 },
/* 3 */{	1,   2,   2,   3,   3,   4,   4,   4,   5,   5,   5,   5 },
/* 4 */{	1,   2,   2,   3,   3,   4,   4,   5,   5,   5,   5,   5 },
/* 5 */{	1,   2,   3,   3,   4,   4,   4,   5,   5,   5,   5,   6 },
/* 6 */{	2,   2,   3,   3,   4,   4,   4,   5,   5,   5,   5,   6 },
/* 7 */{	2,   2,   3,   3,   4,   4,   4,   5,   5,   5,   5,   6 },
/* 8 */{	2,   2,   3,   3,   4,   4,   4,   5,   5,   5,   6,   6 },
/* 9 */{	2,   3,   3,   4,   4,   4,   5,   5,   5,   5,   6,   6 },
/* 10*/{	2,   3,   3,   4,   4,   4,   5,   5,   5,   6,   6,   6 },
/*11+*/{	2,   3,   3,   4,   4,   4,   5,   5,   6,   6,   6,   6 },
};


s16b arena_monsters[MAX_ARENA_MONS] =
{
	 30,	 43,	102,	118,	126,	149,	173,
	183,	188,	191,	216,	230,	238,	244,
	255,	262,	293,	297,	321,	349,	372,
	401,	415,	454,	464,	485,	538,	631,
	641
};



/*
 * Store owners (exactly four "possible" owners per store, chosen randomly)
 * { name, purse, max greed, min greed, haggle_per, tolerance, race, unused }
 *
 * Lifted extra shopkeepers from CthAngband (don't you just love open source
 * development? ;-)). Since this gave less than 32 unique names for some
 * shops, those have their first x names copied to reach 32.
 *
 * For the weapon and armour shops, several owners have a limit of 5k.
 *
 * I want to do 50k owners, but the purse is currently s16b. Perhaps
 * we should just store 1/10th of the purse?
 */
owner_type owners[MAX_STORES][MAX_OWNERS] =
{
	{
		/* General store - 32 unique names */
#ifdef JP
		{ "եɥ꡼ʥӥ",       200,    170,  108,   5,  15,  RACE_HOBBIT},
		{ "¼ԥ饹ȥ",       200,    175,  108,   4,  12,  RACE_HUMAN},
		{ "ؤ㤤륿",             300,    170,  107,   5,  15,  RACE_GNOME},
		{ "ϥ󥵥ʥ饤=",      300,    165,  107,   6,  18,  RACE_ELF},
		{ "ڤʥեޥ",         250,    170, 108,  5, 15, RACE_HOBBIT},
		{ "¼ԥ",       500,    175, 108,  4, 12, RACE_HUMAN},
		{ "ӤΥ饷ʥ",          750,    170, 107,  5, 15, RACE_BEASTMAN},
		{ "ϥ󥵥ʥå",        1000,    165, 107,  6, 18, RACE_HALF_TITAN},
		{ "ʥեӥ",         250,    170, 108,  5, 15, RACE_HUMAN},
		{ "ϼΥꥹ",       500,    175, 108,  4, 12, RACE_HUMAN},
		{ "ʢڥΥեС",          750,    170, 107,  5, 15, RACE_VAMPIRE},
		{ "ʡ롦",        1000,    165, 107,  6, 18, RACE_MIND_FLAYER},
		{ "Ĺभ",         250,    170, 108,  5, 15, RACE_SPECTRE},
		{ "ΥޤΥեǥ",       500,    175, 108,  4, 12, RACE_ZOMBIE},
		{ "󥵥",          750,    170, 107,  5, 15, RACE_SKELETON},
		{ "ǫʥå",        1000,    165, 107,  6, 18, RACE_VAMPIRE},
		{ "֥å",         250,    170, 108,  5, 15, RACE_HALF_ORC},
		{ "٥쥹",       500,    175, 108,  4, 12, RACE_HIGH_ELF},
		{ "쥹",          750,    170, 107,  5, 15, RACE_GNOME},
		{ "ʡå",        1000,    165, 107,  6, 18, RACE_DWARF},
		{ "ӤΥإͥå",         250,    170, 108,  5, 15, RACE_GNOME},
		{ "",       500,    175, 108,  4, 12, RACE_HALF_GIANT},
		{ "©Υ",          750,    170, 107,  5, 15, RACE_DRACONIAN},
		{ "Ǥ֤ä祢饡",        1000,    165, 107,  6, 18, RACE_DRACONIAN},
		{ "ǽʥס",         250,    170, 108,  5, 15, RACE_BEASTMAN},
		{ "եեꥢ",       500,    175, 108,  4, 12, RACE_ELF},
		{ "ǯޥ",          750,    170, 107,  5, 15, RACE_GNOME},
		{ " ͦʥ",        1000,    165, 107,  6, 18, RACE_HALF_GIANT},
		{ "ļ˼ԥӥޡ",         250,    170, 108,  5, 15, RACE_HUMAN},
		{ "˳ʥϡ",       500,    175, 108,  4, 12, RACE_HALF_ORC},
		{ "ߤʥ",          750,    170, 107,  5, 15, RACE_ZOMBIE},
		{ "Ǥʥ",        1000,    165, 107,  6, 18, RACE_ELF},
#else
		{ "Bilbo the Friendly",         200,    170, 108,  5, 15, RACE_HOBBIT},
		{ "Raistlin the Chicken",       200,    175, 108,  4, 12, RACE_HUMAN},
		{ "Sultan the Midget",          300,    170, 107,  5, 15, RACE_GNOME},
		{ "Lyar-el the Comely",         300,    165, 107,  6, 18, RACE_ELF},
		{ "Falilmawen the Friendly",         250,    170, 108,  5, 15, RACE_HOBBIT},
		{ "Voirin the Cowardly",       500,    175, 108,  4, 12, RACE_HUMAN},
		{ "Erashnak the Midget",          750,    170, 107,  5, 15, RACE_BEASTMAN},
		{ "Grug the Comely",        1000,    165, 107,  6, 18, RACE_HALF_TITAN},
		{ "Forovir the Cheap",         250,    170, 108,  5, 15, RACE_HUMAN},
		{ "Ellis the Fool",       500,    175, 108,  4, 12, RACE_HUMAN},
		{ "Filbert the Hungry",          750,    170, 107,  5, 15, RACE_VAMPIRE},
		{ "Fthnargl Psathiggua",        1000,    165, 107,  6, 18, RACE_MIND_FLAYER},
		{ "Eloise Long-Dead",         250,    170, 108,  5, 15, RACE_SPECTRE},
		{ "Fundi the Slow",       500,    175, 108,  4, 12, RACE_ZOMBIE},
		{ "Granthus",          750,    170, 107,  5, 15, RACE_SKELETON},
		{ "Lorax the Suave",        1000,    165, 107,  6, 18, RACE_VAMPIRE},
		{ "Butch",         250,    170, 108,  5, 15, RACE_HALF_ORC},
		{ "Elbereth the Beautiful",       500,    175, 108,  4, 12, RACE_HIGH_ELF},
		{ "Sarleth the Sneaky",          750,    170, 107,  5, 15, RACE_GNOME},
		{ "Narlock",        1000,    165, 107,  6, 18, RACE_DWARF},
		{ "Haneka the Small",         250,    170, 108,  5, 15, RACE_GNOME},
		{ "Loirin the Mad",       500,    175, 108,  4, 12, RACE_HALF_GIANT},
		{ "Wuto Poisonbreath",          750,    170, 107,  5, 15, RACE_DRACONIAN},
		{ "Araaka the Rotund",        1000,    165, 107,  6, 18, RACE_DRACONIAN},
		{ "Poogor the Dumb",         250,    170, 108,  5, 15, RACE_BEASTMAN},
		{ "Felorfiliand",       500,    175, 108,  4, 12, RACE_ELF},
		{ "Maroka the Aged",          750,    170, 107,  5, 15, RACE_GNOME},
		{ "Sasin the Bold",        1000,    165, 107,  6, 18, RACE_HALF_GIANT},
		{ "Abiemar the Peasant",         250,    170, 108,  5, 15, RACE_HUMAN},
		{ "Hurk the Poor",       500,    175, 108,  4, 12, RACE_HALF_ORC},
		{ "Soalin the Wretched",          750,    170, 107,  5, 15, RACE_ZOMBIE},
		{ "Merulla the Humble",        1000,    165, 107,  6, 18, RACE_ELF},
#endif
	},
	{
		/* Armoury - 28 unique names */
#ifdef JP
		{ "=",      5000,   210,  115,   5,   7,  RACE_HALF_ORC},
		{ "Ǽԥ=",  10000,  190,  111,   4,   9,  RACE_HUMAN},
		{ "ԥǥ",                 25000,  200,  112,   4,  10,  RACE_DUNADAN},
		{ "결Υ",   30000,  200,  112,   4,   5,  RACE_DWARF},
		{ "=",           10000,   210, 115,  5,  7, RACE_HALF_ORC},
		{ "Ǽԥ=",          15000,  190, 111,  4,  9, RACE_HUMAN},
		{ "ϥ󥵥ʥǥ",            25000,  200, 112,  4, 10, RACE_DUNADAN},
		{ "ɥ饴󥹥",          30000,  200, 112,  4,  5, RACE_ELF},
		{ "ǥꥫȥ",           10000,   210, 115,  5,  7, RACE_SPRITE},
		{ "ʥ롼",          15000,  190, 111,  4,  9, RACE_HALF_GIANT},
		{ "˥ॹ",            25000,  200, 112,  4, 10, RACE_GOLEM},
		{ "ޥ",          30000,  200, 112,  4,  5, RACE_HALF_TITAN},
		{ "饯",           10000,   210, 115,  5,  7, RACE_ZOMBIE},
		{ "ǥ",          5000,  190, 111,  4,  9, RACE_SPECTRE},
		{ "ʥɥꥪ",            25000,  200, 112,  4, 10, RACE_SPECTRE},
		{ "䤿Хå",          30000,  200, 112,  4,  5, RACE_VAMPIRE},
		{ "󥸥",           10000,   210, 115,  5,  7, RACE_HALF_TROLL},
		{ "ԥ",          15000,  190, 111,  4,  9, RACE_HUMAN},
		{ "襸",            25000,  200, 112,  4, 10, RACE_DWARF},
		{ "ͥʥ顼",          30000,  200, 112,  4,  5, RACE_DUNADAN},
		{ "ԾΥۥХ",           5000,   210, 115,  5,  7, RACE_HALF_ORC},
		{ "ƥѥΥ",          15000,  190, 111,  4,  9, RACE_DARK_ELF},
		{ "ɥꥢ",            25000,  200, 112,  4, 10, RACE_SPRITE},
		{ "ܥʡ",          5000,  200, 112,  4,  5, RACE_CYCLOPS},
		{ "٤Υǥå",           10000,   210, 115,  5,  7, RACE_BEASTMAN},
		{ "إ",          15000,  190, 111,  4,  9, RACE_NIBELUNG},
		{ "벰Υ٥ꥹ",           10000,  200, 112,  4, 10, RACE_DARK_ELF},
		{ "פΥ",          30000,  200, 112,  4,  5, RACE_IMP},
		{ "=",           5000,   210, 115,  5,  7, RACE_HALF_ORC},
		{ "Ǽԥ=",          10000,  190, 111,  4,  9, RACE_HUMAN},
		{ "ϥ󥵥ʥǥ",            25000,  200, 112,  4, 10, RACE_DUNADAN},
		{ "결Υ",          30000,  200, 112,  4,  5, RACE_DWARF},
#else
		{ "Kon-Dar the Ugly",           5000,   210, 115,  5,  7, RACE_HALF_ORC},
		{ "Darg-Low the Grim",          10000,  190, 111,  4,  9, RACE_HUMAN},
		{ "Decado the Handsome",            25000,  200, 112,  4, 10, RACE_DUNADAN},
		{ "Wieland the Smith",          30000,  200, 112,  4,  5, RACE_DWARF},
		{ "Kon-Dar the Ugly",           10000,   210, 115,  5,  7, RACE_HALF_ORC},
		{ "Darg-Low the Grim",          15000,  190, 111,  4,  9, RACE_HUMAN},
		{ "Decado the Handsome",            25000,  200, 112,  4, 10, RACE_DUNADAN},
		{ "Elo Dragonscale",          30000,  200, 112,  4,  5, RACE_ELF},
		{ "Delicatus",           10000,   210, 115,  5,  7, RACE_SPRITE},
		{ "Gruce the Huge",          15000,  190, 111,  4,  9, RACE_HALF_GIANT},
		{ "Animus",            25000,  200, 112,  4, 10, RACE_GOLEM},
		{ "Malvus",          30000,  200, 112,  4,  5, RACE_HALF_TITAN},
		{ "Selaxis",           10000,   210, 115,  5,  7, RACE_ZOMBIE},
		{ "Deathchill",          5000,  190, 111,  4,  9, RACE_SPECTRE},
		{ "Drios the Faint",            25000,  200, 112,  4, 10, RACE_SPECTRE},
		{ "Bathric the Cold",          30000,  200, 112,  4,  5, RACE_VAMPIRE},
		{ "Vengella the Cruel",           10000,   210, 115,  5,  7, RACE_HALF_TROLL},
		{ "Wyrana the Mighty",          15000,  190, 111,  4,  9, RACE_HUMAN},
		{ "Yojo II",            25000,  200, 112,  4, 10, RACE_DWARF},
		{ "Ranalar the Sweet",          30000,  200, 112,  4,  5, RACE_DUNADAN},
		{ "Horbag the Unclean",           5000,   210, 115,  5,  7, RACE_HALF_ORC},
		{ "Elelen the Telepath",          15000,  190, 111,  4,  9, RACE_DARK_ELF},
		{ "Isedrelias",            25000,  200, 112,  4, 10, RACE_SPRITE},
		{ "Vegnar One-eye",          5000,  200, 112,  4,  5, RACE_CYCLOPS},
		{ "Rodish the Chaotic",           10000,   210, 115,  5,  7, RACE_BEASTMAN},
		{ "Hesin Swordmaster",          15000,  190, 111,  4,  9, RACE_NIBELUNG},
		{ "Elvererith the Cheat",           10000,  200, 112,  4, 10, RACE_DARK_ELF},
		{ "Zzathath the Imp",          30000,  200, 112,  4,  5, RACE_IMP},
		{ "Kon-Dar the Ugly",           5000,   210, 115,  5,  7, RACE_HALF_ORC},
		{ "Darg-Low the Grim",          10000,  190, 111,  4,  9, RACE_HUMAN},
		{ "Decado the Handsome",            25000,  200, 112,  4, 10, RACE_DUNADAN},
		{ "Wieland the Smith",          30000,  200, 112,  4,  5, RACE_DWARF},
#endif
	},
	{
		/* Weapon Smith - 28 unique names */
#ifdef JP
		{ "Ǧʤ륢Υ",        5000,   210,  115,   6,   6,  RACE_HALF_TROLL},
		{ "ûΥ", 10000,  185,  110,   5,   9,  RACE_HALF_ELF},
		{ "åޥΥǥ", 25000,  190,  115,   5,   7,  RACE_HOBBIT},
		{ "εΥ饤", 30000,  195,  112,   4,   8,  RACE_DWARF},
		{ "ԥɥ塼",      10000,   210, 115,  6,  6, RACE_HUMAN},
		{"ζλҥå",        15000,  185, 110,  5,  9, RACE_DRACONIAN},
		{ "µΥ󥹥å",         25000,  190, 115,  5,  7, RACE_BEASTMAN},
		{ "ԥ륳",       30000,  195, 112,  4,  8, RACE_DWARF},
		{ "ԤΥꥢ",      5000,   210, 115,  6,  6, RACE_ZOMBIE},
		{"Υȥ",        15000,  185, 110,  5,  9, RACE_SKELETON},
		{ "ӥꥪ",         25000,  190, 115,  5,  7, RACE_BEASTMAN},
		{ "ե",       30000,  195, 112,  4,  8, RACE_ZOMBIE},
		{ "ѥǥΥեꥹ",      10000,   210, 115,  6,  6, RACE_BARBARIAN},
		{"'ȥ'",        15000,  185, 110,  5,  9, RACE_KLACKON},
		{ "ͧɥ",         25000,  190, 115,  5,  7, RACE_DARK_ELF},
		{ "ͻΥե󥰥",       30000,  195, 112,  4,  8, RACE_DWARF},
		{ "ǥ",      10000,   210, 115,  6,  6, RACE_ELF},
		{"󥸥㡼Υӥ",        15000,  185, 110,  5,  9, RACE_HALF_ELF},
		{ "ΥޤΥ",         25000,  190, 115,  5,  7, RACE_GOLEM},
		{ "󡦥եå",       20000,  195, 112,  4,  8, RACE_HALF_ELF},
		{ "ԥʥɥå",      10000,   210, 115,  6,  6, RACE_HOBBIT},
		{"⥰",        15000,  185, 110,  5,  9, RACE_KOBOLD},
		{ "ʥꥹ",         25000,  190, 115,  5,  7, RACE_VAMPIRE},
		{ "ХΥҥ奤⥰",       30000,  195, 112,  4,  8, RACE_HALF_ORC},
		{ "ԡ",      5000,   210, 115,  6,  6, RACE_HUMAN},
		{ "⥰ 쥤䡼",        15000,  185, 110,  5,  9, RACE_HALF_OGRE},
		{ "աʥ",         25000,  190, 115,  5,  7, RACE_BEASTMAN},
		{ "ƮХ",       30000,  195, 112,  4,  8, RACE_BARBARIAN},
		{ " Ǧʤ륢Υ",      5000,   210, 115,  6,  6, RACE_BARBARIAN},
		{ "ûΥ",        10000,  185, 110,  5,  9, RACE_HALF_ELF},
		{ "ӡȥޥǥ",         25000,  190, 115,  5,  7, RACE_HALF_ORC},
		{ "εΥ饤",       30000,  195, 112,  4,  8, RACE_DWARF},
#else
		{ "Arnold the Beastly",      5000,   210, 115,  6,  6, RACE_BARBARIAN},
		{ "Arndal Beast-Slayer",        10000,  185, 110,  5,  9, RACE_HALF_ELF},
		{ "Eddie Beast-Master",         25000,  190, 115,  5,  7, RACE_HALF_ORC},
		{ "Oglign Dragon-Slayer",       30000,  195, 112,  4,  8, RACE_DWARF},
		{ "Drew the Skilled",      10000,   210, 115,  6,  6, RACE_HUMAN},
		{ "Orrax Dragonson",        15000,  185, 110,  5,  9, RACE_DRACONIAN},
		{ "Anthrax Disease-Carrier",         25000,  190, 115,  5,  7, RACE_BEASTMAN},
		{ "Arkhoth the Stout",       30000,  195, 112,  4,  8, RACE_DWARF},
		{ "Sarlyas the Rotten",      5000,   210, 115,  6,  6, RACE_ZOMBIE},
		{ "Tuethic Bare-Bones",        15000,  185, 110,  5,  9, RACE_SKELETON},
		{ "Bilious",         25000,  190, 115,  5,  7, RACE_BEASTMAN},
		{ "Fasgul",       30000,  195, 112,  4,  8, RACE_ZOMBIE},
		{ "Ellefris the Paladin",      10000,   210, 115,  6,  6, RACE_BARBARIAN},
		{ "K'trrik'k",        15000,  185, 110,  5,  9, RACE_KLACKON},
		{ "Drocus Spiderfriend",         25000,  190, 115,  5,  7, RACE_DARK_ELF},
		{ "Fungus Giant-Slayer",       30000,  195, 112,  4,  8, RACE_DWARF},
		{ "Delantha",      10000,   210, 115,  6,  6, RACE_ELF},
		{ "Solvistani the Ranger",        15000,  185, 110,  5,  9, RACE_HALF_ELF},
		{ "Xoril the Slow",         25000,  190, 115,  5,  7, RACE_GOLEM},
		{ "Aeon Flux",       20000,  195, 112,  4,  8, RACE_HALF_ELF},
		{ "Nadoc the Strong",      10000,   210, 115,  6,  6, RACE_HOBBIT},
		{ "Eramog the Weak",        15000,  185, 110,  5,  9, RACE_KOBOLD},
		{ "Eowilith the Fair",         25000,  190, 115,  5,  7, RACE_VAMPIRE},
		{ "Huimog Balrog-Slayer",       30000,  195, 112,  4,  8, RACE_HALF_ORC},
		{ "Peadus the Cruel",      5000,   210, 115,  6,  6, RACE_HUMAN},
		{ "Vamog Slayer",        15000,  185, 110,  5,  9, RACE_HALF_OGRE},
		{ "Hooshnak the Vicious",         25000,  190, 115,  5,  7, RACE_BEASTMAN},
		{ "Balenn War-Dancer",       30000,  195, 112,  4,  8, RACE_BARBARIAN},
		{ "Arnold the Beastly",      5000,   210, 115,  6,  6, RACE_BARBARIAN},
		{ "Arndal Beast-Slayer",        10000,  185, 110,  5,  9, RACE_HALF_ELF},
		{ "Eddie Beast-Master",         25000,  190, 115,  5,  7, RACE_HALF_ORC},
		{ "Oglign Dragon-Slayer",       30000,  195, 112,  4,  8, RACE_DWARF},
#endif
	},
	{
		/* Temple - 22 unique names */
#ifdef JP
		{ "Ǥʥ롼ɥ",         5000,   175,  109,   6,  15,  RACE_HUMAN},
		{ "ѥǥΥʡ",       10000,  185,  110,   5,  23,  RACE_HUMAN},
		{ "Ф줷ȥ",                     25000,  180,  107,   6,  20,  RACE_ELF},
		{ "ʤ륵饹ȥ",                     30000,  185,  109,   5,  15,  RACE_DWARF},
		{ "ѡ붪",           25000,  180, 107,  6, 20, RACE_HIGH_ELF},
		{ "ʤ륢ʥ",          30000,  185, 109,  5, 15, RACE_HUMAN},
		{ "ޥåΥ",         10000,   175, 109,  6, 15, RACE_HUMAN},
		{ "ؿ",         15000,  185, 110,  5, 23, RACE_HIGH_ELF},
		{ "ɥ륤ɤΥϥ˥å",           25000,  180, 107,  6, 20, RACE_HOBBIT},
		{ "եʥ",          30000,  185, 109,  5, 15, RACE_YEEK},
		{ "ꥭå",         10000,   175, 109,  6, 15, RACE_KLACKON},
		{ "Ӥԥ",         15000,  185, 110,  5, 23, RACE_ELF},
		{ "Ťۥå",           25000,  180, 107,  6, 20, RACE_IMP},
		{ "ԥ",          30000,  185, 109,  5, 15, RACE_HUMAN},
		{ "٥˥å",         10000,   175, 109,  6, 15, RACE_HUMAN},
		{ "ǥ",         15000,  185, 110,  5, 23, RACE_HALF_TROLL},
		{ "ѻեɥ",           25000,  180, 107,  6, 20, RACE_HALF_OGRE},
		{ "Υϥ",          30000,  185, 109,  5, 15, RACE_BARBARIAN},
		{ "㤭ץ롼ǥ",         10000,   175, 109,  6, 15, RACE_HALF_OGRE},
		{ "磻",         15000,  185, 110,  5, 23, RACE_YEEK},
		{ "ͭԥ",           25000,  180, 107,  6, 20, RACE_KOBOLD},
		{ "ɥС",          30000,  185, 109,  5, 15, RACE_SPECTRE},
		{ "Ǥʥ롼ɥ",          5000,   175, 109,  6, 15, RACE_DWARF},
		{ "ѥǥΥʡ",         10000,  185, 110,  5, 23, RACE_HALF_TROLL},
		{ "Ф줷ȥ",           25000,  180, 107,  6, 20, RACE_HIGH_ELF},
		{ "ʤ륵饹ȥ",          30000,  185, 109,  5, 15, RACE_HUMAN},
		{ "ѡ붪",           25000,  180, 107,  6, 20, RACE_HIGH_ELF},
		{ "ʤ륢ʥ",          30000,  185, 109,  5, 15, RACE_HUMAN},
		{ "ޥåΥ",         10000,   175, 109,  6, 15, RACE_HUMAN},
		{ "ؿ",         15000,  185, 110,  5, 23, RACE_HIGH_ELF},
		{ "ɥ륤 ϥ˥å",           25000,  180, 107,  6, 20, RACE_HOBBIT},
		{ "եʥ",        15000,  200, 110,  7,  8, RACE_BARBARIAN},
#else
		{ "Ludwig the Humble",          5000,   175, 109,  6, 15, RACE_DWARF},
		{ "Gunnar the Paladin",         10000,  185, 110,  5, 23, RACE_HALF_TROLL},
		{ "Torin the Chosen",           25000,  180, 107,  6, 20, RACE_HIGH_ELF},
		{ "Sarastro the Wise",          30000,  185, 109,  5, 15, RACE_HUMAN},
		{ "Sir Parsival the Pure",           25000,  180, 107,  6, 20, RACE_HIGH_ELF},
		{ "Asenath the Holy",          30000,  185, 109,  5, 15, RACE_HUMAN},
		{ "McKinnon",         10000,   175, 109,  6, 15, RACE_HUMAN},
		{ "Mistress Chastity",         15000,  185, 110,  5, 23, RACE_HIGH_ELF},
		{ "Hashnik the Druid",           25000,  180, 107,  6, 20, RACE_HOBBIT},
		{ "Finak",          30000,  185, 109,  5, 15, RACE_YEEK},
		{ "Krikkik",         10000,   175, 109,  6, 15, RACE_KLACKON},
		{ "Morival the Wild",         15000,  185, 110,  5, 23, RACE_ELF},
		{ "Hoshak the Dark",           25000,  180, 107,  6, 20, RACE_IMP},
		{ "Atal the Wise",          30000,  185, 109,  5, 15, RACE_HUMAN},
		{ "Ibenidd the Chaste",         10000,   175, 109,  6, 15, RACE_HUMAN},
		{ "Eridish",         15000,  185, 110,  5, 23, RACE_HALF_TROLL},
		{ "Vrudush the Shaman",           25000,  180, 107,  6, 20, RACE_HALF_OGRE},
		{ "Haob the Berserker",          30000,  185, 109,  5, 15, RACE_BARBARIAN},
		{ "Proogdish the Youthfull",         10000,   175, 109,  6, 15, RACE_HALF_OGRE},
		{ "Lumwise the Mad",         15000,  185, 110,  5, 23, RACE_YEEK},
		{ "Muirt the Virtuous",           25000,  180, 107,  6, 20, RACE_KOBOLD},
		{ "Dardobard the Weak",          30000,  185, 109,  5, 15, RACE_SPECTRE},
		{ "Ludwig the Humble",          5000,   175, 109,  6, 15, RACE_DWARF},
		{ "Gunnar the Paladin",         10000,  185, 110,  5, 23, RACE_HALF_TROLL},
		{ "Torin the Chosen",           25000,  180, 107,  6, 20, RACE_HIGH_ELF},
		{ "Sarastro the Wise",          30000,  185, 109,  5, 15, RACE_HUMAN},
		{ "Sir Parsival the Pure",           25000,  180, 107,  6, 20, RACE_HIGH_ELF},
		{ "Asenath the Holy",          30000,  185, 109,  5, 15, RACE_HUMAN},
		{ "McKinnon",         10000,   175, 109,  6, 15, RACE_HUMAN},
		{ "Mistress Chastity",         15000,  185, 110,  5, 23, RACE_HIGH_ELF},
		{ "Hashnik the Druid",           25000,  180, 107,  6, 20, RACE_HOBBIT},
		{ "Finak",          30000,  185, 109,  5, 15, RACE_YEEK},
#endif
	},
	{
		/* Alchemist - 26 unique names */
#ifdef JP
		{ "ؼԥޥ",             10000,  190,  111,   5,   8,  RACE_HALF_ELF},
		{ "Υ",   10000,  190,  110,   6,   8,  RACE_HOBBIT},
		{ "ߥߥ",              15000,  200,  116,   6,   9,  RACE_GNOME},
		{ "ϼ奸=ե",                   15000,  220,  111,   4,   9,  RACE_ELF},/*FIRST*/
		{ "饫",           15000,  200, 116,  6,  9, RACE_KLACKON},
		{ "ϣѻե=",       15000,  220, 111,  4,  9, RACE_ELF},
		{ "ѿեͥ饹",         10000,  190, 111,  5,  8, RACE_DWARF},
		{ "Υ󥷡",         10000,  190, 110,  6,  8, RACE_HUMAN},
		{ "֥",           15000,  200, 116,  6,  9, RACE_GNOME},
		{ "եå",       15000,  220, 111,  4,  9, RACE_SPRITE},
		{ "륹",         10000,  190, 111,  5,  8, RACE_HUMAN},
		{ "ŤС",         10000,  190, 110,  6,  8, RACE_DWARF},
		{ "ؤ⤭ɥ",           15000,  200, 116,  6,  9, RACE_HIGH_ELF},
		{ "ϣѻե",       15000,  220, 111,  4,  9, RACE_HUMAN},
		{ "",         10000,  190, 111,  5,  8, RACE_VAMPIRE},
		{ "Ťեꥢ",         10000,  190, 110,  6,  8, RACE_NIBELUNG},
		{ "Ǥʥɥ",           15000,  200, 116,  6,  9, RACE_DWARF},
		{ "λҥ䥡å",       15000,  220, 111,  4,  9, RACE_IMP},
		{ "եɡ",         10000,  190, 111,  5,  8, RACE_HIGH_ELF},
		{ "ԥ",         10000,  190, 110,  6,  8, RACE_BARBARIAN},
		{ "ǥ˥ȤΥե",           15000,  200, 116,  6,  9, RACE_IMP},
		{ "ϣѻեɥꥢ",       15000,  220, 111,  4,  9, RACE_HALF_ORC},
		{ "ԥͥꥢ",         10000,  190, 111,  5,  8, RACE_CYCLOPS},
		{ "ɸꥰʥ",         10000,  190, 110,  6,  8, RACE_HALF_ORC},
		{ "ƥ",           15000,  200, 116,  6,  9, RACE_HOBBIT},
		{ "ߥɥå",       15000,  220, 111,  4,  9, RACE_HUMAN},
		{ "ʳؼԥޥ",         10000,  190, 111,  5,  8, RACE_HALF_ELF},
		{ "Υ",         10000,  190, 110,  6,  8, RACE_HOBBIT},
		{ "ߥߥ",           15000,  200, 116,  6,  9, RACE_GNOME},
		{ "ϣѻե=ե",       15000,  220, 111,  4,  9, RACE_ELF},
		{ "饫",           15000,  200, 116,  6,  9, RACE_KLACKON},
		{ "ϣѻե=",       15000,  220, 111,  4,  9, RACE_ELF},
#else
		{ "Mauser the Chemist",         10000,  190, 111,  5,  8, RACE_HALF_ELF},
		{ "Wizzle the Chaotic",         10000,  190, 110,  6,  8, RACE_HOBBIT},
		{ "Midas the Greedy",           15000,  200, 116,  6,  9, RACE_GNOME},
		{ "Ja-Far the Alchemist",       15000,  220, 111,  4,  9, RACE_ELF},
		{ "Kakalrakakal",           15000,  200, 116,  6,  9, RACE_KLACKON},
		{ "Jal-Eth the Alchemist",       15000,  220, 111,  4,  9, RACE_ELF},
		{ "Fanelath the Cautious",         10000,  190, 111,  5,  8, RACE_DWARF},
		{ "Runcie the Insane",         10000,  190, 110,  6,  8, RACE_HUMAN},
		{ "Grumbleworth",           15000,  200, 116,  6,  9, RACE_GNOME},
		{ "Flitter",       15000,  220, 111,  4,  9, RACE_SPRITE},
		{ "Xarillus",         10000,  190, 111,  5,  8, RACE_HUMAN},
		{ "Egbert the Old",         10000,  190, 110,  6,  8, RACE_DWARF},
		{ "Valindra the Proud",           15000,  200, 116,  6,  9, RACE_HIGH_ELF},
		{ "Taen the Alchemist",       15000,  220, 111,  4,  9, RACE_HUMAN},
		{ "Cayd the Sweet",         10000,  190, 111,  5,  8, RACE_VAMPIRE},
		{ "Fulir the Dark",         10000,  190, 110,  6,  8, RACE_NIBELUNG},
		{ "Domli the Humble",           15000,  200, 116,  6,  9, RACE_DWARF},
		{ "Yaarjukka Demonspawn",       15000,  220, 111,  4,  9, RACE_IMP},
		{ "Gelaraldor the Herbmaster",         10000,  190, 111,  5,  8, RACE_HIGH_ELF},
		{ "Olelaldan the Wise",         10000,  190, 110,  6,  8, RACE_BARBARIAN},
		{ "Fthoglo the Demonicist",           15000,  200, 116,  6,  9, RACE_IMP},
		{ "Dridash the Alchemist",       15000,  220, 111,  4,  9, RACE_HALF_ORC},
		{ "Nelir the Strong",         10000,  190, 111,  5,  8, RACE_CYCLOPS},
		{ "Lignus the Pungent",         10000,  190, 110,  6,  8, RACE_HALF_ORC},
		{ "Tilba",           15000,  200, 116,  6,  9, RACE_HOBBIT},
		{ "Myrildric the Wealthy",       15000,  220, 111,  4,  9, RACE_HUMAN},
		{ "Mauser the Chemist",         10000,  190, 111,  5,  8, RACE_HALF_ELF},
		{ "Wizzle the Chaotic",         10000,  190, 110,  6,  8, RACE_HOBBIT},
		{ "Midas the Greedy",           15000,  200, 116,  6,  9, RACE_GNOME},
		{ "Ja-Far the Alchemist",       15000,  220, 111,  4,  9, RACE_ELF},
		{ "Kakalrakakal",           15000,  200, 116,  6,  9, RACE_KLACKON},
		{ "Jal-Eth the Alchemist",       15000,  220, 111,  4,  9, RACE_ELF},
#endif
	},
	{
		/* Magic Shop - 23 unique names */
#ifdef JP
		{ "顼Υ=ѥ",       20000,  200,  110,   7,   8,  RACE_HALF_ELF},
		{ "ʤ֥ӥ",         20000,  215,  113,   6,  10,  RACE_GNOME},
		{ "ˡȤ",     30000,  200,  110,   7,  10,  RACE_HUMAN},
		{ "Ȥå",30000,      175,  110,   5,  11,  RACE_HIGH_ELF},
		{ "ѻեɥˡ",        15000,  200, 110,  7,  8, RACE_HALF_ELF},
		{ "ѻեꥢ",       30000,  200, 110,  7, 10, RACE_HUMAN},
		{ "ѻե˥å",       30000,  175, 110,  5, 11, RACE_DARK_ELF},
		{ "ȥ",        15000,  200, 110,  7,  8, RACE_SPRITE},
		{ "±",         20000,  215, 113,  6, 10, RACE_MIND_FLAYER},
		{ "²Υ",       30000,  200, 110,  7, 10, RACE_HIGH_ELF},
		{ "Ťե",       30000,  175, 110,  5, 11, RACE_DARK_ELF},
		{ "ʤ륱ɡ",        15000,  200, 110,  7,  8, RACE_DWARF},
		{ "ե󥹥ץ",         20000,  215, 113,  6, 10, RACE_HOBBIT},
		{ "Υʡ",       30000,  200, 110,  7, 10, RACE_HUMAN},
		{ "ѻեӥꥢ",       30000,  175, 110,  5, 11, RACE_BEASTMAN},
		{ "ϥᥤΥ饯",        15000,  200, 110,  7,  8, RACE_BEASTMAN},
		{ "ηüԥޥǥå",         20000,  215, 113,  6, 10, RACE_BEASTMAN},
		{ "ե֥ܡ",       30000,  200, 110,  7, 10, RACE_HIGH_ELF},
		{ "ե=",       30000,  175, 110,  5, 11, RACE_DARK_ELF},
		{ "ѻե쥴",        15000,  200, 110,  7,  8, RACE_BARBARIAN},
		{ "ȥȥ",         20000,  215, 113,  6, 10, RACE_MIND_FLAYER},
		{ "ѻե٥",       30000,  200, 110,  7, 10, RACE_SKELETON},
		{ "ѻեإȡ",       30000,  175, 110,  5, 11, RACE_YEEK},
		{ "ѻե=ѥ",        20000,  200, 110,  7,  8, RACE_HALF_ELF},
		{ "ʤ֥ӥ",         20000,  215, 113,  6, 10, RACE_GNOME},
		{ "ˡȤ",       30000,  200, 110,  7, 10, RACE_HUMAN},
		{ "ѻե㥯",       30000,  175, 110,  5, 11, RACE_DARK_ELF},
		{ "ѻեɥˡ",        15000,  200, 110,  7,  8, RACE_HALF_ELF},
		{ "ѻեꥢ",       30000,  200, 110,  7, 10, RACE_HUMAN},
		{ "ѻե˥å",       30000,  175, 110,  5, 11, RACE_DARK_ELF},
		{ "ȥ",        15000,  200, 110,  7,  8, RACE_SPRITE},
		{ "±",         20000,  215, 113,  6, 10, RACE_MIND_FLAYER},
#else
		{ "Lo Pan the Sorcerer",        20000,  200, 110,  7,  8, RACE_HALF_ELF},
		{ "Buggerby the Great",         20000,  215, 113,  6, 10, RACE_GNOME},
		{ "The Wizard of Yendor",       30000,  200, 110,  7, 10, RACE_HUMAN},
		{ "Rjak the Necromancer",       30000,  175, 110,  5, 11, RACE_DARK_ELF},
		{ "Skidney the Sorcerer",        15000,  200, 110,  7,  8, RACE_HALF_ELF},
		{ "Kyria the Illusionist",       30000,  200, 110,  7, 10, RACE_HUMAN},
		{ "Nikki the Necromancer",       30000,  175, 110,  5, 11, RACE_DARK_ELF},
		{ "Solostoran",        15000,  200, 110,  7,  8, RACE_SPRITE},
		{ "Achshe the Tentacled",         20000,  215, 113,  6, 10, RACE_MIND_FLAYER},
		{ "Kaza the Noble",       30000,  200, 110,  7, 10, RACE_HIGH_ELF},
		{ "Fazzil the Dark",       30000,  175, 110,  5, 11, RACE_DARK_ELF},
		{ "Keldorn the Grand",        15000,  200, 110,  7,  8, RACE_DWARF},
		{ "Philanthropus",         20000,  215, 113,  6, 10, RACE_HOBBIT},
		{ "Agnar the Enchantress",       30000,  200, 110,  7, 10, RACE_HUMAN},
		{ "Buliance the Necromancer",       30000,  175, 110,  5, 11, RACE_BEASTMAN},
		{ "Vuirak the High-Mage",        15000,  200, 110,  7,  8, RACE_BEASTMAN},
		{ "Madish the Smart",         20000,  215, 113,  6, 10, RACE_BEASTMAN},
		{ "Falebrimbor",       30000,  200, 110,  7, 10, RACE_HIGH_ELF},
		{ "Felil-Gand the Subtle",       30000,  175, 110,  5, 11, RACE_DARK_ELF},
		{ "Thalegord the Shaman",        15000,  200, 110,  7,  8, RACE_BARBARIAN},
		{ "Cthoaloth the Mystic",         20000,  215, 113,  6, 10, RACE_MIND_FLAYER},
		{ "Ibeli the Illusionist",       30000,  200, 110,  7, 10, RACE_SKELETON},
		{ "Heto the Necromancer",       30000,  175, 110,  5, 11, RACE_YEEK},
		{ "Lo Pan the Sorcerer",        20000,  200, 110,  7,  8, RACE_HALF_ELF},
		{ "Buggerby the Great",         20000,  215, 113,  6, 10, RACE_GNOME},
		{ "The Wizard of Yendor",       30000,  200, 110,  7, 10, RACE_HUMAN},
		{ "Rjak the Necromancer",       30000,  175, 110,  5, 11, RACE_DARK_ELF},
		{ "Skidney the Sorcerer",        15000,  200, 110,  7,  8, RACE_HALF_ELF},
		{ "Kyria the Illusionist",       30000,  200, 110,  7, 10, RACE_HUMAN},
		{ "Nikki the Necromancer",       30000,  175, 110,  5, 11, RACE_DARK_ELF},
		{ "Solostoran",        15000,  200, 110,  7,  8, RACE_SPRITE},
		{ "Achshe the Tentacled",         20000,  215, 113,  6, 10, RACE_MIND_FLAYER},
#endif
	},
	{
		/* Black Market - 32 unique names */
#ifdef JP
		{ "꡼=",            20000,  250,  150,  10,   5,  RACE_HALF_TROLL},
		{ "֥Υҥȡ",       20000,  250,  150,  10,   5,  RACE_HALF_ORC},
		{ "ե󥮿ͥ",           30000,  250,  150,  10,   5,  RACE_HUMAN},
		{ "ʤ(?)ȥå",                     30000,  250,  150,  10,   5,  RACE_ELF},
		{ "ͥå",             20000,  250, 150, 10,  5, RACE_ZOMBIE},
		{ "΢ڤԥ",          20000,  250, 150, 10,  5, RACE_VAMPIRE},
		{ "֥ܥ˥",          30000,  250, 150, 10,  5, RACE_BEASTMAN},
		{ "ץ饤",           30000,  250, 150, 10,  5, RACE_SPECTRE},
		{ "˵ѥå",                 20000,  250, 150, 10,  5, RACE_VAMPIRE},
		{ "",          20000,  250, 150, 10,  5, RACE_SKELETON},
		{ "Υץƥ",          30000,  250, 150, 10,  5, RACE_SKELETON},
		{ "ʹֻΥꥨ",           30000,  250, 150, 10,  5, RACE_IMP},
		{ "󥸥",                 20000,  250, 150, 10,  5, RACE_VAMPIRE},
		{ "Ĥեĥ",          20000,  250, 150, 10,  5, RACE_ZOMBIE},
		{ "ˡ",          30000,  250, 150, 10,  5, RACE_VAMPIRE},
		{ "뤤ʥ",           30000,  250, 150, 10,  5, RACE_SPECTRE},
		{ "ѻեƥ", 20000,  250, 150, 10,  5, RACE_DARK_ELF},
		{ "ܥΥץʥ",          20000,  250, 150, 10,  5, RACE_HALF_ORC},
		{ "ʥեåȥ",          30000,  250, 150, 10,  5, RACE_BEASTMAN},
		{ "ؤΥɥꥢ",           30000,  250, 150, 10,  5, RACE_HUMAN},
		{ "ʻեꥢ",                 20000,  250, 150, 10,  5, RACE_HOBBIT},
		{ "꤯Υʥå",          20000,  250, 150, 10,  5, RACE_GNOME},
		{ "ޥ",          30000,  250, 150, 10,  5, RACE_GNOME},
		{ "ޥ˥å",           30000,  250, 150, 10,  5, RACE_DRACONIAN},
		{ "˳㥨",                 20000,  250, 150, 10,  5, RACE_HUMAN},
		{ "±եɡ",          20000,  250, 150, 10,  5, RACE_BARBARIAN},
		{ "ߥ饶",          30000,  250, 150, 10,  5, RACE_MIND_FLAYER},
		{ "ե쥦",           30000,  250, 150, 10,  5, RACE_SPRITE},
		{ "路",                 20000,  250, 150, 10,  5, RACE_NIBELUNG},
		{ "ϥ󥵥ʥ饪",          20000,  250, 150, 10,  5, RACE_DUNADAN},
		{ "餱ɥե",          30000,  250, 150, 10,  5, RACE_HUMAN},
		{ "­Υ롼",           30000,  250, 150, 10,  5, RACE_HALF_OGRE},
#else
		{ "Gary Gygaz",                 20000,  250, 150, 10,  5, RACE_HALF_TROLL},
		{ "Histor the Goblin",          20000,  250, 150, 10,  5, RACE_HALF_ORC},
		{ "Quark the Ferengi",          30000,  250, 150, 10,  5, RACE_DWARF},
		{ "Topi the Fair(?)",           30000,  250, 150, 10,  5, RACE_HUMAN},
		{ "Vhassa the Dead",             20000,  250, 150, 10,  5, RACE_ZOMBIE},
		{ "Kyn the Treacherous",          20000,  250, 150, 10,  5, RACE_VAMPIRE},
		{ "Bubonicus",          30000,  250, 150, 10,  5, RACE_BEASTMAN},
		{ "Corpselight",           30000,  250, 150, 10,  5, RACE_SPECTRE},
		{ "Parrish the Bloodthirsty",                 20000,  250, 150, 10,  5, RACE_VAMPIRE},
		{ "Vile",          20000,  250, 150, 10,  5, RACE_SKELETON},
		{ "Prentice the Trusted",          30000,  250, 150, 10,  5, RACE_SKELETON},
		{ "Griella Humanslayer",           30000,  250, 150, 10,  5, RACE_IMP},
		{ "Angel",                 20000,  250, 150, 10,  5, RACE_VAMPIRE},
		{ "Flotsam the Bloated",          20000,  250, 150, 10,  5, RACE_ZOMBIE},
		{ "Nieval",          30000,  250, 150, 10,  5, RACE_VAMPIRE},
		{ "Anastasia the Luminous",           30000,  250, 150, 10,  5, RACE_SPECTRE},
		{ "Charity the Necromancer", 20000,  250, 150, 10,  5, RACE_DARK_ELF},
		{ "Pugnacious the Pugilist",          20000,  250, 150, 10,  5, RACE_HALF_ORC},
		{ "Footsore the Lucky",          30000,  250, 150, 10,  5, RACE_BEASTMAN},
		{ "Sidria Lighfingered",           30000,  250, 150, 10,  5, RACE_HUMAN},
		{ "Riatho the Juggler",                 20000,  250, 150, 10,  5, RACE_HOBBIT},
		{ "Janaaka the Shifty",          20000,  250, 150, 10,  5, RACE_GNOME},
		{ "Cina the Rogue",          30000,  250, 150, 10,  5, RACE_GNOME},
		{ "Arunikki Greatclaw",           30000,  250, 150, 10,  5, RACE_DRACONIAN},
		{ "Chaeand the Poor",                 20000,  250, 150, 10,  5, RACE_HUMAN},
		{ "Afardorf the Brigand",          20000,  250, 150, 10,  5, RACE_BARBARIAN},
		{ "Lathaxl the Greedy",          30000,  250, 150, 10,  5, RACE_MIND_FLAYER},
		{ "Falarewyn",           30000,  250, 150, 10,  5, RACE_SPRITE},
		{ "Vosur the Wrinkled",                 20000,  250, 150, 10,  5, RACE_NIBELUNG},
		{ "Araord the Handsome",          20000,  250, 150, 10,  5, RACE_DUNADAN},
		{ "Theradfrid the Loser",          30000,  250, 150, 10,  5, RACE_HUMAN},
		{ "One-Legged Eroolo",           30000,  250, 150, 10,  5, RACE_HALF_OGRE},
#endif
	},
	{
		/* Home */
#ifdef JP
		{ "椬",                          0,      100, 100,  0, 99, 99},
		{ "椬",                          0,      100, 100,  0, 99, 99},
		{ "椬",                          0,      100, 100,  0, 99, 99},
		{ "椬",                          0,      100, 100,  0, 99, 99},
		{ "椬",                          0,      100, 100,  0, 99, 99},
		{ "椬",                          0,      100, 100,  0, 99, 99},
		{ "椬",                          0,      100, 100,  0, 99, 99},
		{ "椬",                          0,      100, 100,  0, 99, 99},
		{ "椬",                          0,      100, 100,  0, 99, 99},
		{ "椬",                          0,      100, 100,  0, 99, 99},
		{ "椬",                          0,      100, 100,  0, 99, 99},
		{ "椬",                          0,      100, 100,  0, 99, 99},
		{ "椬",                          0,      100, 100,  0, 99, 99},
		{ "椬",                          0,      100, 100,  0, 99, 99},
		{ "椬",                          0,      100, 100,  0, 99, 99},
		{ "椬",                          0,      100, 100,  0, 99, 99},
		{ "椬",                          0,      100, 100,  0, 99, 99},
		{ "椬",                          0,      100, 100,  0, 99, 99},
		{ "椬",                          0,      100, 100,  0, 99, 99},
		{ "椬",                          0,      100, 100,  0, 99, 99},
		{ "椬",                          0,      100, 100,  0, 99, 99},
		{ "椬",                          0,      100, 100,  0, 99, 99},
		{ "椬",                          0,      100, 100,  0, 99, 99},
		{ "椬",                          0,      100, 100,  0, 99, 99},
		{ "椬",                          0,      100, 100,  0, 99, 99},
		{ "椬",                          0,      100, 100,  0, 99, 99},
		{ "椬",                          0,      100, 100,  0, 99, 99},
		{ "椬",                          0,      100, 100,  0, 99, 99},
		{ "椬",                          0,      100, 100,  0, 99, 99},
		{ "椬",                          0,      100, 100,  0, 99, 99},
		{ "椬",                          0,      100, 100,  0, 99, 99},
		{ "椬",                          0,      100, 100,  0, 99, 99},
#else
		{ "Your home",                          0,      100, 100,  0, 99, 99},
		{ "Your home",                          0,      100, 100,  0, 99, 99},
		{ "Your home",                          0,      100, 100,  0, 99, 99},
		{ "Your home",                          0,      100, 100,  0, 99, 99},
		{ "Your home",                          0,      100, 100,  0, 99, 99},
		{ "Your home",                          0,      100, 100,  0, 99, 99},
		{ "Your home",                          0,      100, 100,  0, 99, 99},
		{ "Your home",                          0,      100, 100,  0, 99, 99},
		{ "Your home",                          0,      100, 100,  0, 99, 99},
		{ "Your home",                          0,      100, 100,  0, 99, 99},
		{ "Your home",                          0,      100, 100,  0, 99, 99},
		{ "Your home",                          0,      100, 100,  0, 99, 99},
		{ "Your home",                          0,      100, 100,  0, 99, 99},
		{ "Your home",                          0,      100, 100,  0, 99, 99},
		{ "Your home",                          0,      100, 100,  0, 99, 99},
		{ "Your home",                          0,      100, 100,  0, 99, 99},
		{ "Your home",                          0,      100, 100,  0, 99, 99},
		{ "Your home",                          0,      100, 100,  0, 99, 99},
		{ "Your home",                          0,      100, 100,  0, 99, 99},
		{ "Your home",                          0,      100, 100,  0, 99, 99},
		{ "Your home",                          0,      100, 100,  0, 99, 99},
		{ "Your home",                          0,      100, 100,  0, 99, 99},
		{ "Your home",                          0,      100, 100,  0, 99, 99},
		{ "Your home",                          0,      100, 100,  0, 99, 99},
		{ "Your home",                          0,      100, 100,  0, 99, 99},
		{ "Your home",                          0,      100, 100,  0, 99, 99},
		{ "Your home",                          0,      100, 100,  0, 99, 99},
		{ "Your home",                          0,      100, 100,  0, 99, 99},
		{ "Your home",                          0,      100, 100,  0, 99, 99},
		{ "Your home",                          0,      100, 100,  0, 99, 99},
		{ "Your home",                          0,      100, 100,  0, 99, 99},
		{ "Your home",                          0,      100, 100,  0, 99, 99},
#endif
	},
	{
		/* Bookstore - 21 unique names */
#ifdef JP
		{ "ߥɥ", 10000, 175, 108, 4, 12, RACE_HUMAN},
		{ "ԥɥʡ", 15000, 120, 105, 6, 16, RACE_HIGH_ELF},
		{ "ΩΥ", 25000, 120, 110, 7, 19, RACE_DARK_ELF},
		{ "ǦѤοͥ=", 30000, 140, 105, 6, 12, RACE_ELF},
		{ "ɥա", 15000, 175, 108, 4, 12, RACE_HUMAN},
		{ "ȻΥ饤", 15000, 175, 108, 4, 12, RACE_HUMAN},
		{ "Τܥɥ", 20000, 120, 105, 6, 16, RACE_HIGH_ELF},
		{ "ۤΥ", 25000, 120, 110, 7, 19, RACE_ZOMBIE},
		{ "ؼԤΥ󥷥饹", 30000, 140, 105, 6, 12, RACE_MIND_FLAYER},
		{ "ʪ񤭥", 15000, 175, 108, 4, 12, RACE_SKELETON},
		{ "ܤ", 20000, 120, 105, 6, 16, RACE_VAMPIRE},
		{ "", 25000, 120, 110, 7, 19, RACE_ZOMBIE},
		{ "ǥޥ", 30000, 140, 105, 6, 12, RACE_ZOMBIE},
		{ "ؼԤΥ", 15000, 175, 108, 4, 12, RACE_MIND_FLAYER},
		{ "ͤΥץ", 20000, 120, 105, 6, 16, RACE_ZOMBIE},
		{ "ŴΥʡ", 25000, 120, 110, 7, 19, RACE_GOLEM},
		{ "=ߥ", 30000, 140, 105, 6, 12, RACE_ELF},
		{ "ܿХ", 15000, 175, 108, 4, 12, RACE_KOBOLD},
		{ "ꥢꥭ", 20000, 120, 105, 6, 16, RACE_KLACKON},
		{ "Ťʤ", 25000, 120, 110, 7, 19, RACE_DWARF},
		{ "ԥ", 30000, 140, 105, 6, 12, RACE_HIGH_ELF},
		{ "ߥɥ", 10000, 175, 108, 4, 12, RACE_HUMAN},
		{ "ԥɥʡ", 15000, 120, 105, 6, 16, RACE_HIGH_ELF},
		{ "ΩΥ", 25000, 120, 110, 7, 19, RACE_DARK_ELF},
		{ "ǦѤοͥ=", 30000, 140, 105, 6, 12, RACE_ELF},
		{ "ɥա", 15000, 175, 108, 4, 12, RACE_HUMAN},
		{ "Ȼ饤", 15000, 175, 108, 4, 12, RACE_HUMAN},
		{ "Τܥɥ", 20000, 120, 105, 6, 16, RACE_HIGH_ELF},
		{ "ۤΥ", 25000, 120, 110, 7, 19, RACE_ZOMBIE},
		{ "ؼԤΥ󥷥饹", 30000, 140, 105, 6, 12, RACE_MIND_FLAYER},
		{ "ʪ񤭥", 15000, 175, 108, 4, 12, RACE_SKELETON},
		{ "ܤ", 20000, 120, 105, 6, 16, RACE_VAMPIRE},
#else
		{ "Dolaf the Greedy", 10000, 175, 108, 4, 12, RACE_HUMAN},
		{ "Odnar the Sage", 15000, 120, 105, 6, 16, RACE_HIGH_ELF},
		{ "Gandar the Neutral", 25000, 120, 110, 7, 19, RACE_DARK_ELF},
		{ "Ro-sha the Patient", 30000, 140, 105, 6, 12, RACE_ELF},
		{ "Randolph Carter", 15000, 175, 108, 4, 12, RACE_HUMAN},
		{ "Sarai the Swift", 15000, 175, 108, 4, 12, RACE_HUMAN},
		{ "Bodril the Seer", 20000, 120, 105, 6, 16, RACE_HIGH_ELF},
		{ "Veloin the Quiet", 25000, 120, 110, 7, 19, RACE_ZOMBIE},
		{ "Vanthylas the Learned", 30000, 140, 105, 6, 12, RACE_MIND_FLAYER},
		{ "Ossein the Literate", 15000, 175, 108, 4, 12, RACE_SKELETON},
		{ "Olvar Bookworm", 20000, 120, 105, 6, 16, RACE_VAMPIRE},
		{ "Shallowgrave", 25000, 120, 110, 7, 19, RACE_ZOMBIE},
		{ "Death Mask", 30000, 140, 105, 6, 12, RACE_ZOMBIE},
		{ "Asuunu the Learned", 15000, 175, 108, 4, 12, RACE_MIND_FLAYER},
		{ "Prirand the Dead", 20000, 120, 105, 6, 16, RACE_ZOMBIE},
		{ "Ronar the Iron", 25000, 120, 110, 7, 19, RACE_GOLEM},
		{ "Galil-Gamir", 30000, 140, 105, 6, 12, RACE_ELF},
		{ "Rorbag Book-Eater", 15000, 175, 108, 4, 12, RACE_KOBOLD},
		{ "Kiriarikirk", 20000, 120, 105, 6, 16, RACE_KLACKON},
		{ "Rilin the Quiet", 25000, 120, 110, 7, 19, RACE_DWARF},
		{ "Isung the Lord", 30000, 140, 105, 6, 12, RACE_HIGH_ELF},
		{ "Dolaf the Greedy", 10000, 175, 108, 4, 12, RACE_HUMAN},
		{ "Odnar the Sage", 15000, 120, 105, 6, 16, RACE_HIGH_ELF},
		{ "Gandar the Neutral", 25000, 120, 110, 7, 19, RACE_DARK_ELF},
		{ "Ro-sha the Patient", 30000, 140, 105, 6, 12, RACE_ELF},
		{ "Randolph Carter", 15000, 175, 108, 4, 12, RACE_HUMAN},
		{ "Sarai the Swift", 15000, 175, 108, 4, 12, RACE_HUMAN},
		{ "Bodril the Seer", 20000, 120, 105, 6, 16, RACE_HIGH_ELF},
		{ "Veloin the Quiet", 25000, 120, 110, 7, 19, RACE_ZOMBIE},
		{ "Vanthylas the Learned", 30000, 140, 105, 6, 12, RACE_MIND_FLAYER},
		{ "Ossein the Literate", 15000, 175, 108, 4, 12, RACE_SKELETON},
		{ "Olvar Bookworm", 20000, 120, 105, 6, 16, RACE_VAMPIRE},
#endif
	}
};




/*
 * This table allows quick conversion from "speed" to "energy"
 * The basic function WAS ((S>=110) ? (S-110) : (100 / (120-S)))
 * Note that table access is *much* quicker than computation.
 *
 * Note that the table has been changed at high speeds.  From
 * "Slow (-40)" to "Fast (+30)" is pretty much unchanged, but
 * at speeds above "Fast (+30)", one approaches an asymptotic
 * effective limit of 50 energy per turn.  This means that it
 * is relatively easy to reach "Fast (+30)" and get about 40
 * energy per turn, but then speed becomes very "expensive",
 * and you must get all the way to "Fast (+50)" to reach the
 * point of getting 45 energy per turn.  After that point,
 * furthur increases in speed are more or less pointless,
 * except to balance out heavy inventory.
 *
 * Note that currently the fastest monster is "Fast (+30)".
 *
 * It should be possible to lower the energy threshhold from
 * 100 units to 50 units, though this may interact badly with
 * the (compiled out) small random energy boost code.  It may
 * also tend to cause more "clumping" at high speeds.
 */
byte extract_energy[200] =
{
	/* Slow */     1,  1,  1,  1,  1,  1,  1,  1,  1,  1,
	/* Slow */     1,  1,  1,  1,  1,  1,  1,  1,  1,  1,
	/* Slow */     1,  1,  1,  1,  1,  1,  1,  1,  1,  1,
	/* Slow */     1,  1,  1,  1,  1,  1,  1,  1,  1,  1,
	/* Slow */     1,  1,  1,  1,  1,  1,  1,  1,  1,  1,
	/* Slow */     1,  1,  1,  1,  1,  1,  1,  1,  1,  1,
	/* S-50 */     1,  1,  1,  1,  1,  1,  1,  1,  1,  1,
	/* S-40 */     2,  2,  2,  2,  2,  2,  2,  2,  2,  2,
	/* S-30 */     2,  2,  2,  2,  2,  2,  2,  3,  3,  3,
	/* S-20 */     3,  3,  3,  3,  3,  4,  4,  4,  4,  4,
	/* S-10 */     5,  5,  5,  5,  6,  6,  7,  7,  8,  9,
	/* Norm */    10, 11, 12, 13, 14, 15, 16, 17, 18, 19,
	/* F+10 */    20, 21, 22, 23, 24, 25, 26, 27, 28, 29,
	/* F+20 */    30, 31, 32, 33, 34, 35, 36, 36, 37, 37,
	/* F+30 */    38, 38, 39, 39, 40, 40, 40, 41, 41, 41,
	/* F+40 */    42, 42, 42, 43, 43, 43, 44, 44, 44, 44,
	/* F+50 */    45, 45, 45, 45, 45, 46, 46, 46, 46, 46,
	/* F+60 */    47, 47, 47, 47, 47, 48, 48, 48, 48, 48,
	/* F+70 */    49, 49, 49, 49, 49, 49, 49, 49, 49, 49,
	/* Fast */    49, 49, 49, 49, 49, 49, 49, 49, 49, 49,
};




/*
 * Base experience levels, may be adjusted up for race and/or class
 */
s32b player_exp[PY_MAX_LEVEL] =
{
	10,
	25,
	45,
	70,
	100,
	140,
	200,
	280,
	380,
	500,
	650,
	850,
	1100,
	1400,
	1800,
	2300,
	2900,
	3600,
	4400,
	5400,
	6800,
	8400,
	10200,
	12500,
	17500,
	25000,
	35000L,
	50000L,
	75000L,
	100000L,
	150000L,
	200000L,
	275000L,
	350000L,
	450000L,
	550000L,
	700000L,
	850000L,
	1000000L,
	1250000L,
	1500000L,
	1800000L,
	2100000L,
	2400000L,
	2700000L,
	3000000L,
	3500000L,
	4000000L,
	4500000L,
	5000000L
};


/*
 * Player Sexes
 *
 *      Title,
 *      Winner
 */
player_sex sex_info[MAX_SEXES] =
{
	{
#ifdef JP
		"",
		"Female",
		""
#else
		"Female",
		"Queen"
#endif
	},
	{
#ifdef JP
		"",
		"Male",
		""
#else
		"Male",
		"King"
#endif
	}
};


/*
 * Player Races
 *
 *      Title,
 *      {STR,INT,WIS,DEX,CON,CHR},
 *      r_dis, r_dev, r_sav, r_stl, r_srh, r_fos, r_thn, r_thb,
 *      hitdie, exp base,
 *      Age (Base, Mod),
 *      Male (Hgt, Wgt),
 *      Female (Hgt, Wgt)
 *      infra,
 *      class-choices,
 *      can-birth
 */
player_race race_info[MAX_RACES] =
{
	{
#ifdef JP
		"ʹ",
#endif
		"Human",
		{  0,  0,  0,  0,  0,  0 },
		0,  0,  0,  0,  0,  10,  0,  0,
		10,  100,
		14,  6,
		72,  6, 180, 25,
		66,  4, 150, 20,
		0,
		0x1FFF,
		TRUE,
	},
	{
#ifdef JP
		"ϡե",
#endif
		"Half-Elf",
		{ -1,  1,  1,  1, -1,  1 },
		2,  3,  3,  1, 6,  11, -1,  5,
		9,  110,
		24, 16,
		66,  6, 130, 15,
		62,  6, 100, 10,
		2,
		0x1FFF,
		TRUE,
	},
	{
#ifdef JP
		"",
#endif
		"Elf",
		{ -1,  2,  2,  1, -2,  3 },
		5,  6,  6,  2, 8,  12, -5, 15,
		8,  115,
		75, 75,
		60,  4, 100,  6,
		54,  4, 80,  6,
		3,
		0x16EF,
		TRUE,
	},
	{
#ifdef JP
		"ۥӥå",
#endif
		"Hobbit",
		{ -2,  1,  1,  3,  2,  1 },
		15, 18, 18, 5, 12,  15, -10, 20,
		7,  110,
		21, 12,
		36,  3, 60,  3,
		33,  3, 50,  3,
		4,
		0x168B,
		TRUE,
	},
	{
#ifdef JP
		"Ρ",
#endif
		"Gnome",
		{ -1,  2,  0,  2,  1, -1 },
		10, 12, 12,  3, 6,  13, -8, 12,
		8,  120,
		50, 40,
		42,  3, 90,  6,
		39,  3, 75,  3,
		4,
		0x17CF,
		TRUE,
	},
	{
#ifdef JP
		"ɥ",
#endif
		"Dwarf",
		{  2, -2,  2, -2,  2, -1 },
		2,  9,  10,  -1,  7,  10, 15,  0,
		11,  125,
		35, 15,
		48,  3, 150, 10,
		46,  3, 120, 10,
		5,
		0x1105,
		TRUE,
	},
	{
#ifdef JP
		"ϡե",
#endif
		"Half-Orc",
		{  2, -1,  0,  0,  1, -2 },
		-3, -3, -3,  -1,  0, 7, 12, -5,
		10,  110,
		11,  4,
		66,  1, 150,  5,
		62,  1, 120,  5,
		3,
		0x008D,
		TRUE,
	},
	{
#ifdef JP
		"ϡեȥ",
#endif
		"Half-Troll",
		{ 5, -4, -2, -3,  4, -3 },
		-5, -8, -8, -2,  -1, 5, 20, -10,
		12,  125,
		20, 10,
		96, 10, 250, 50,
		84,  8, 225, 40,
		3,
		0x0001,
		TRUE,
	},
	{
#ifdef JP
		"ɥʥ",
#endif
		"Dunadan",
		{  1,  2,  2,  2,  3,  2 },
		4,  5,  5,  2, 3, 13, 15, 10,
		10, 180,
		50, 50,
		82, 5, 190, 20,
		78,  6, 180, 15,
		0,
		0x17FF,
		TRUE,
	},
	{
#ifdef JP
		"Υ",
#endif
		"High-Elf",
		{  1,  3,  2,  3,  1,  5 },
		4,  20, 20,  4,  3, 14, 10, 25,
		10,  200,
		100, 30,
		90, 10, 190, 20,
		82, 10, 180, 15,
		4,
		0x17EF,
		TRUE,
	},
	{
#ifdef JP
		"ڿ",
#endif
		"Barbarian",
		{ 3, -2,  -1,  1,  2, -2 },
		-2, -10, 2,  -1,  1, 7, 12, 10,
		0, 120,
		14, 8,
		82, 5, 200, 20,
		78,  6, 190, 15,
		0,
		0x009D,
		FALSE,
	},
	{
#ifdef JP
		"ϡե",
#endif
		"Half-Ogre",
		{ 3, -1, -1, -1, 3, -3 },
		-3, -5, -5, -2, -1, 5, 20, 0,
		0,  130,
		40, 10,
		92, 10, 255, 60,
		80,  8, 235, 60,
		3,
		0x0407,
		FALSE,
	},
	{
#ifdef JP
		"Ⱦ",
#endif
		"Half-Giant",
		{ 4, -2, -2, -2, 3, -2 },
		-6, -8, -6, -2, -1, 5, 25, 5,
		13, 150,
		40, 10,
		100,10, 255, 65,
		80, 10, 240, 64,
		3,
		0x0089,
		TRUE,
	},
	{
#ifdef JP
		"Ⱦ",
#endif
		"Half-Titan",
		{ 5, 1, 1, -2, 3, 1 },
		-5, 5, 2, -2, 1, 8, 25, 0,
		0, 255,
		100,30,
		111, 11, 255, 86,
		99, 11, 250, 86,
		0,
		0x0727,
		FALSE,
	},
	{
#ifdef JP
		"ץ",
#endif
		"Cyclops",
		{ 4, -3, -3, -3, 4, -6 },
		-4, -5, -5, -2, -2, 5, 20, 12,
		0, 130,
		50, 24,
		92, 10, 255, 60,
		80,  8, 235, 60,
		1,
		0x0005,
		FALSE,
	},
	{
#ifdef JP
		"",
#endif
		"Yeek",
		{ -2, 1, 1, 1, -2, -7 },
		2, 4, 10, 3, 5, 15, -5, -5,
		0, 100,
		14, 3,
		50,  3, 90,  6,
		50,  3, 75,  3,
		2,
		0x060F,
		FALSE,
	},
	{
#ifdef JP
		"å",
#endif
		"Klackon",
		{ 2, -1, -1, 1, 2, -2 },
		10, 5, 5, 0, -1, 10, 5, 5,
		12, 135,
		20, 3,
		60,  3, 80,  4,
		54,  3, 70,  4,
		2,
		0x0089,
		TRUE,
	},
	{
#ifdef JP
		"ܥ",
#endif
		"Kobold",
		{ 1, -1, 0, 1, 0, -2 },
		-2, -3, -2, -1, 1, 8, 10, -5,
		9, 125,
		11,  3,
		60,  1, 130,  5,
		55,  1, 100,  5,
		3,
		0x0289,
		TRUE,
	},
	{
#ifdef JP
		"ˡ٥",
#endif
		"Nibelung",
		{ 1, -1, 2, 0, 2, -2 },
		3, 5, 10, 1, 5, 10, 9, 0,
		11, 135,
		40, 12,
		43,  3, 92,  6,
		40,  3, 78,  3,
		5,
		0x148F,
		TRUE,
	},
	{
#ifdef JP
		"",
#endif
		"Dark-Elf",
		{ -1, 3, 2, 2, -2, 1 },
		5, 15, 20, 3, 8, 12, -5, 10,
		0, 150,
		75, 75,
		60,  4, 100,  6,
		54,  4, 80,  6,
		5,
		0x07DF,
		FALSE,
	},
	{
#ifdef JP
		"ɥ饳˥",
#endif
		"Draconian",
		{ 2, 1, 1, 1, 2, -3 },
		-2, 5, 3, 0, 1, 10, 5, 5,
		0, 250,
		75, 33,
		76,  1, 160,  5,
		72,  1, 130,  5,
		2,
		0x0757,
		FALSE,
	},
	{
#ifdef JP
		"ޥɥե쥢",
#endif
		"Mindflayer",
		{ -3, 4, 4, 0, -2, -3 },
		10, 25, 15, 2, 5, 12, -10, -5,
		9, 140,
		100, 25,
		68,  6, 142, 15,
		63,  6, 112, 10,
		4,
		0x1246,
		TRUE,
	},
	{
#ifdef JP
		"",
#endif
		"Imp",
		{ -1, -1, -1, 1, 2, -3 },
		-3, 2, -1, 1, -1, 10, 5, -5,
		10, 110,
		13,  4,
		68,  1, 150,  5,
		64,  1, 120,  5,
		3,
		0x07CB,
		FALSE,
	},
	{
#ifdef JP
		"",
#endif
		"Golem",
		{ 4, -5, -5, -2, 4, -4 },
		-5, -5, 10, -1, -1, 8, 20, 0,
		0, 200,
		1, 100,
		66,  1, 200,  6,
		62,  1, 180,  6,
		4,
		0x0001,
		FALSE,
	},
	{
#ifdef JP
		"",
#endif
		"Skeleton",
		{ 0, -2, -2, 0, 1, -4 },
		-5, -5, 5, -1, -1, 8, 10, 0,
		10, 145,
		100, 35,
		72,  6, 50, 5,
		66,  4, 50, 5,
		2,
		0x070F,
		FALSE,
	},
	{
#ifdef JP
		"",
#endif
		"Zombie",
		{ 2, -6, -6, 1, 4, -5 },
		-5, -5, 8, -1, -1, 5, 15, 0,
		13, 135,
		100, 30,
		72, 6, 100, 25,
		66, 4, 100, 20,
		2,
		0x0001,
		FALSE,
	},
	{
#ifdef JP
		"۷쵴",
#endif
		"Vampire",
		{ 3, 3, -1, -1, 1, 2 },
		4, 10, 10, 4, 1, 8, 5, 0,
		11, 200,
		100, 30,
		72,  6, 180, 25,
		66,  4, 150, 20,
		5,
		0x17FF,
		FALSE,
	},
	{
#ifdef JP
		"ͩ",
#endif
		"Spectre",
		{ -5, 4, 4, 2, -3, -6 },
		10, 25, 20, 5, 5, 14, -15, -5,
		0, 180,
		100, 30,
		72, 6, 100, 25,
		66, 4, 100, 20,
		5,
		0x074E,    /* Mage, Priest, Rogue, Warrior-Mage, Monk */
		FALSE,
	},
	{
#ifdef JP
		"",
#endif
		"Sprite",
		{ -4, 3, 3, 3, -2, 2 },
		10, 10, 10, 4, 10, 10, -12, 0,
		0, 175,
		50, 25,
		32,  2, 75,  2,
		29,  2, 65,  2,
		4,
		0x065E,
		FALSE,
	},
	{
#ifdef JP
		"ÿ",  
#endif
		"Beastman",
		{ 2, -2, -1, -1, 2, -4 },
		-5, -2, -1, -1, -1, 5, 12, 5,
		0, 140,
		14, 6,
		65,  6, 150, 20,
		61,  6, 120, 15,
		0,
		0x07CF,
		FALSE,
	}
};


/*
 * Player Classes
 *
 *      Title,
 *      {STR,INT,WIS,DEX,CON,CHR},
 *      c_dis, c_dev, c_sav, c_stl, c_srh, c_fos, c_thn, c_thb,
 *      x_dis, x_dev, x_sav, x_stl, x_srh, x_fos, x_thn, x_thb,
 *      HD, Exp, pet_upkeep_div,
 *      num, wgt, mul
 */
player_class class_info[MAX_CLASS] =
{
	{
#ifdef JP
		"",
#endif
		"Warrior",
		{ 5, -2, -2, 2, 2, -1},
		25, 18, 18, 1,  14, 2,  70,  55,
		12, 7,  10, 0,  0,  0, 150, 150,
		9,  0, 20,
		6, 70, 50,
		SENSE_FAST, TRUE, SENSE_CANT
	},

	{
#ifdef JP
		"ᥤ",
#endif
		"Mage",
		{-4, 3, 0, 1, -2, 1},
		30, 36, 30, 2,  16, 20, 34, 20,
		7,  13, 9,  0,  0,  0,  30, 35,
		0, 30, 15,
		3, 100, 20,
		SENSE_POOR, FALSE, SENSE_FAST
	},

	{
#ifdef JP
		"ץ꡼",
#endif
		"Priest",
		{-1, -3, 3, -1, 0, 2},
		25, 30, 32, 2,  16, 8, 48, 35,
		7,  10, 12, 0,  0,  0, 65, 55,
		2, 20, 20,
		5, 100, 30,
		SENSE_FAST, FALSE, SENSE_GOOD
	},

	{
#ifdef JP
		"󥸥㡼",
#endif
		"Ranger",
		{ 2, 2, 0, 1, 1, 1},
		30, 32, 28, 5,  24, 16, 56,  72,
		8,  10, 10, 0,  0,  0,  90, 140,
		4, 30, 20,
		5, 70, 35,
		SENSE_BAD, TRUE, SENSE_BAD
	},

	{
#ifdef JP
		"ѥǥ",
#endif
		"Paladin",
		{ 3, -3, 1, 0, 2, 2},
		20, 24, 26, 1,  12, 2,  68, 40,
		7,  10, 11, 0,  0,  0, 105, 90,
		6, 35, 20,
		5, 70, 45,
		SENSE_SLOW, TRUE, SENSE_POOR
	},

	{
#ifdef JP
		"ˡ",
#endif
		"Warrior-Mage",
		{ 2, 2, 0, 1, 0, 1},
		30, 30, 28, 1,  18, 16,  65, 35,
		7,  10,  9, 0,  0,  0,  100, 55,
		4, 40, 20,
		5, 70, 40,
		SENSE_SLOW, FALSE, SENSE_BAD
	},

	{
#ifdef JP
		"Ķǽϼ",
#endif
		"Mindcrafter",
		{-1, 0, 3, -1, -1, 2},   /* note: spell stat is Wis */
		30, 30, 30, 3,  22, 16, 50, 40,
		10, 10, 10, 0,   0,  0, 70, 90,
		2, 25, 20,
		5, 100, 30,
		SENSE_NORM, FALSE, SENSE_GOOD
	},

	{
#ifdef JP
		"㡼",
#endif
		"Archer",
		{ 2, -1, -1, 2, 1, 0},
		38, 24, 35, 4, 24, 16, 56,  82,
		12, 10, 10, 0,  0,  0, 90, 180,
		4, 10, 40,
		4, 70, 20,
		SENSE_GOOD, TRUE, SENSE_CANT
	},

	{
#ifdef JP
		"͸ųؼ",
#endif
		"Archaeologist",
		{ 0, 1, 0, 0, 0, 1},
		40, 24, 40, 1, 32, 18, 35, 20,
		15, 10, 12, 0,  0,  0, 60, 45,
		0, 10, 40,
		3, 70, 30,
		SENSE_VFST, TRUE, SENSE_VFST
	},

	{
#ifdef JP
		"ǻȤ",
#endif
		"Elementalist",
		{-4, 3, 0, 1, -2, 1},
		30, 30, 32, 2,  16, 20, 34, 20,
		7,  10, 12,  0,  0,  0,  30, 35,
		2, 25, 20,
		3, 100, 20,
		SENSE_POOR, FALSE, SENSE_FAST
	},

	{
#ifdef JP
		"ʥѡ",
#endif
		"Sniper",
		{ 1, -1, -2, 2, 0, -1},
		25, 24, 28, 5, 32, 18, 35,  72,
		12, 10, 10, 0,  0,  0, 60, 140,
		2, 20, 40,
		3, 70, 20,
		SENSE_GOOD, TRUE, SENSE_POOR
	},

	{
#ifdef JP
		"ͽѻ",
#endif
		"Snatcher",
		{ 0, 0, 0, 0, 0, 0},
		25, 24, 28, 1, 22, 16, 42, 25,
		7,  10,  9, 0,  0,  0, 65, 40,
		2, 30, 25,
		5, 70, 40,
		SENSE_GOOD, FALSE, SENSE_NORM
	},

	{
#ifdef JP
		"ƻȤ",
#endif
		"Device-User",
		{-2, 2, 0, 1, -1, 0},
		30, 42, 30, 2, 16, 20, 45, 30,
		7,  15,  9, 0,  0,  0, 55, 45,
		0, 30, 15,
		4, 70, 30,
		SENSE_NORM, FALSE, SENSE_GOOD
	},
};


/*
 * Zangband uses this array instead of the spell flags table, as there
 * are 5 realms of magic, each with 4 spellbooks and 8 spells per book -- TY
 */
u32b fake_spell_flags[4]=
{
	0x000003ff,
	0x000ffc00,
	0xfff00000,
	0x00000000
};


byte realm_choices1[MAX_CLASS] =
{
	(CH_NONE),								/* Warrior */
	(CH_SORCERY | CH_MAGIC | CH_EARTH),		/* Mage */
	(CH_LIFE),								/* Priest */
	(CH_LIFE | CH_MUSOU),					/* Ranger */
	(CH_LIFE),								/* Paladin */
	(CH_SORCERY | CH_MUSOU),				/* Warrior-Mage */
	(CH_NONE),								/* Mindcrafter */
	(CH_NONE),								/* Archer */
	(CH_SORCERY),							/* Archaeologist */
	(CH_NONE),								/* Elementalist */
	(CH_NONE),								/* Sniper */
	(CH_NONE),								/* Snatcher */
	(CH_NONE),								/* Device-User */
};


byte realm_choices2[MAX_CLASS] =
{
	/* No realm2 */
	(CH_NONE),
	(CH_NONE),
	(CH_NONE),
	(CH_NONE),
	(CH_NONE),
	(CH_NONE),
	(CH_NONE),
	(CH_NONE),
	(CH_NONE),
	(CH_NONE),
	(CH_NONE),
	(CH_NONE),
	(CH_NONE),
};


#ifdef JP
cptr realm_names[] =
{
	"ˡʤ",
	"̿",
	"",
	"̵",
	"",
	"",
	"",
};

cptr E_realm_names[] =
#else
cptr realm_names[] =
#endif
{
	"no magic",
	"Life",
	"Sorcery",
	"Combat",
	"Magic",
	"Earth",
	"unknown"
};

/*
 * Names of the spells (mage spells then priest spells)
 */
cptr spell_names[MAX_REALM][32] =
{
	/*** Life Spells ***/
	{
		/* Common Life Spellbooks */
#ifdef JP
		"ٰ¸ߴ",
		"ڽμ",
		"ʡ",
		"ݽ",
		"ξ",
		" & ⴶ",
		"Žμ",
		"ʢ­",
		"",
		"",
#else
		"Detect Evil",
		"Cure Light Wounds",
		"Bless",
		"Remove Fear",
		"Call Light",
		"Detect Doors and Traps",
		"Cure Medium Wounds",
		"Satisfy Hunger",
		"Holy Light",
		"Remove Curse",
#endif

#ifdef JP
		"̿μ",
		"ʤ",
		"ͽ",
		"ǮѴ",
		"",
		"мٰ볦",
		"ϲ",
		"ٰ",
		"С",
		"볦",
#else
		"Cure Critical Wounds",
		"Holy Orb",
		"Foresight",
		"Resistance Heat & Cold",
		"Reforming",
		"Protection from Evil",
		"Healing",
		"Banish Evil",
		"Star Burst",
		"Glyph of Warding",
#endif

		/* Rare Life Spellbooks */
#ifdef JP
		"ε",
		"**",
		"",
		"ٰ໶",
		"۶θ",
		"ʤ",
		"ʡο",
		"",
		"ʤ",
		"ʤӥ",
		"*ϲ*",
		"",
#else
		"Heroism",
		"Dispel Curse",
		"Resistance True",
		"Dispel Evil",
		"Propaganda",
		"Holy Word",
		"Bless Weapon",      
		"Restoration",
		"Clairvoyance",
		"Holy Vision",
		"Healing True",
		"Divine Intervention",
#endif
	},

	/*** Sorcery Spells ***/
	{
		/* Common Sorcery Spellbooks */
#ifdef JP
		"ޥåߥ",
		"󥹥",
		"硼ȥƥݡ",
		"櫤ⴶ",
		"饤ȡꥢ",
		"櫡˲",
		"ƥݡ",
		"ʢ­",
		"",
		"Ԥμʸ",
#else
		"Magic Missile",
		"Detect Monsters",
		"Phase Door",
		"Detect Doors and Traps",
		"Light Area",
		"Trap & Door Destruction",
		"Teleport",
		"Satisfy Hunger",
		"Mana Burst",
		"Word of Recall",
#endif

#ifdef JP
		"ϲ",
		"ϽŶ",
		"ˡϿ",
		"",
		"",
		"Ϥ",
		"ԡ",
		"ƥݡȡ",
		"ˡå",
		"",
#else
		"Stone to Mud",
		"Recharging",
		"Magic Mapping",
		"Identify",
		"Sense Minds",
		"Mana Bolt",
		"Haste Self",
		"Teleport Away",
		"Magic Rocket",
		"Genocide",
#endif

		/* Rare Sorcery Spellbooks */
#ifdef JP
		"Ĵ",
		"ƥݡȡ٥",
		"ǰư",
		"",
		"*˲*",
		"Τ",
		"󥹥",
		"",
		"ϣ",
		"",
		"Ϥ",
		"ͩβ",
#else
		"Probing",
		"Teleport Level",
		"Telekinesis",
		"Detection True",
		"Word of Destruction",
		"Clairvoyance",
		"Banish Monsters",
		"Dimension Door",
		"Alchemy",
		"Mass Genocide",
		"Mana Storm",
		"Wraithform",
#endif
	},

	/*** Musou Spellbooks ***/
	{
		/* Common Musou Spellbooks */
#ifdef JP
		"϶",
		"¤",
		"ε",
		"ķ",
		"Ķؤ",
		"졼",
		"ͷ",
		"",
		"ȩв",
		"",
#else
		"Regeneration",
		"3way Attack",
		"Heroism",
		"Jumping",
		"Resist Environment",
		"Lader Eye",
		"Charging",
		"Froce Bolt",
		"Stone Skin",
		"Remove Curse",
#endif

#ifdef JP
		"β",
		"",
		"",
		"",
		"Ʈ",
		"ַ",
		"ԡ",
		"ʳ",
		"",
		"ˡγ",
#else
		"Berserk",
		"Earthquake",
		"Jump and Attack",
		"Resistance True",
		"Aura Arrow",
		"Fast Slicing",
		"Haste Self",
		"Whirlwind Attack",
		"Inertia Beam",
		"Magical Armour",
#endif

		/* Rare Musou Spellbooks */
#ifdef JP
		"̵ϲ",
		"мٰ볦",
		"",
		"忩ɻ",
		"",
		"ﶯ",
		"ɶ񶯲",
		"Ʈη",
		"Ȼ¤",
		"ε",
		"Ǽ٤ο",
		"̵",
#else
		"Normalize",
		"Protection from Evil",
		"Berserk Warrior",
		"Coating",
		"Bombing Attack",
		"Enchant Weapon",
		"Enchant Armor",
		"Aura Sword",
		"Falcon Attack",
		"Tempest",
		"Holy Blade",
		"Ultimate Resistance",
#endif
	},

	/*** Magic Spells ***/
	{	/* Magic */
		/* Common Magic Spellbooks */
#ifdef JP
		"ڽμ",
		"٤ʤʡ",
		"ߤθ",
		"Υ",
		"̸",
		"϶",
		"",
		"ٰ",
		"Źؤ",
		"ɹγ",
#else
		"Cure light wounds",
		"Evily blessing",
		"Word of inertia",
		"Demonic aura",
		"Stinking mist",
		"Extra might",
		"Curse weapon",
		"Evil detection",
		"Dark resistance",
		"Ice armor",
#endif

#ifdef JP
		"Žμ",
		"ƥݡȡХå",
		"ʵ",
		"۷̸",
		"",
		"Ϲؤ",
		"μ",
		"ζ",
		"󥹥",
		"ȿƥݡȷ볦",
#else
		"Cure serious wounds",
		"Call back monster",
		"Inhail potion",
		"Vampiric mist",
		"Swords to runeswords",
		"Nether resistance",
		"Touch of confusion",
		"Building up",
		"Vanish monsters",
		"Anti teleport barrier",
#endif

		/* Rare Magic Spellbooks */
#ifdef JP
		"ȿ볦",
		"̿μ",
		"β",
		"",
		"ϵۼ",
		"̿",
		"۷ο",
		"ۯ۰θ",
		"ưư",
		"ܤˤܤ",
		"ȿˡ볦",
		"",
#else
		"Anti multiply barrier",
		"Cure critical wounds",
		"Berserk",
		"Recharging",
		"Drain curse power",
		"Restore life",
		"Swords to vampires",
		"Word of stun",
		"Moving into shadow",
		"Eye for an eye",
		"Anti magic barrier",
		"Revenge Sentence",
#endif
	},
	{
#ifdef JP
		"ɡܥ",
		"̵ʪ",
		"ˡϿ",
		"ȥå˲",
		"",
		"",
		"",
		"ϲη",
		"",
		"ȩв",
#else
		"Sand bolt",
		"Detect nonliving",
		"Magic mapping",
		"Trap destruction",
		"Weathering ball",
		"Identify",
		"Stone to flesh",
		"Borling",
		"Rock brast",
		"Stone skin",
#endif

#ifdef JP
		"Ͽ",
		"ϴ",
		"",
		"ɻ",
		"",
		"**",
		"ϴή",
		"Ҥ",
		"*˲*",
		"Ф",
#else
		"Earthquake",
		"Lava bolt",
		"Flooding",
		"Passivate",
		"Create stair",
		"*Identify*",
		"Lava stream",
		"Photon bolt",
		"*Destruction*",
		"Generate wall",
#endif

#ifdef JP
		"ȩв",
		"",
		"д",
		"Ѳ",
		"Ų",
		"",
		"Ĭ",
		"̮Ĵ",
		"ȴ",
		"ϣ",
		"",
		"ʮ",
#else
		"Stone skin",
		"",
		"Tunnel wall",
		"Polymorph",
		"Flesh to stone",
		"Polishing",
		"Whirlpool",
		"Detect floor",
		"Through wall",
		"Alchemy",
		"Tidal wave",
		"Lava burst",
#endif

	}
};


/*
 * Each chest has a certain set of traps, determined by pval
 * Each chest has a "pval" from 1 to the chest level (max 55)
 * If the "pval" is negative then the trap has been disarmed
 * The "pval" of a chest determines the quality of its treasure
 * Note that disarming a trap on a chest also removes the lock.
 */
byte chest_traps[64] =
{
	0,                                      /* 0 == empty */
	(CHEST_POISON),
	(CHEST_LOSE_STR),
	(CHEST_LOSE_CON),
	(CHEST_LOSE_STR),
	(CHEST_LOSE_CON),                       /* 5 == best small wooden */
	0,
	(CHEST_POISON),
	(CHEST_POISON),
	(CHEST_LOSE_STR),
	(CHEST_LOSE_CON),
	(CHEST_POISON),
	(CHEST_LOSE_STR | CHEST_LOSE_CON),
	(CHEST_LOSE_STR | CHEST_LOSE_CON),
	(CHEST_LOSE_STR | CHEST_LOSE_CON),
	(CHEST_SUMMON),                 /* 15 == best large wooden */
	0,
	(CHEST_LOSE_STR),
	(CHEST_LOSE_CON),
	(CHEST_PARALYZE),
	(CHEST_LOSE_STR | CHEST_LOSE_CON),
	(CHEST_SUMMON),
	(CHEST_PARALYZE),
	(CHEST_LOSE_STR),
	(CHEST_LOSE_CON),
	(CHEST_EXPLODE),                        /* 25 == best small iron */
	0,
	(CHEST_POISON | CHEST_LOSE_STR),
	(CHEST_POISON | CHEST_LOSE_CON),
	(CHEST_LOSE_STR | CHEST_LOSE_CON),
	(CHEST_EXPLODE | CHEST_SUMMON),
	(CHEST_PARALYZE),
	(CHEST_POISON | CHEST_SUMMON),
	(CHEST_SUMMON),
	(CHEST_EXPLODE),
	(CHEST_EXPLODE | CHEST_SUMMON), /* 35 == best large iron */
	0,
	(CHEST_SUMMON),
	(CHEST_EXPLODE),
	(CHEST_EXPLODE | CHEST_SUMMON),
	(CHEST_EXPLODE | CHEST_SUMMON),
	(CHEST_POISON | CHEST_PARALYZE),
	(CHEST_EXPLODE),
	(CHEST_EXPLODE | CHEST_SUMMON),
	(CHEST_EXPLODE | CHEST_SUMMON),
	(CHEST_POISON | CHEST_PARALYZE),        /* 45 == best small steel */
	0,
	(CHEST_LOSE_STR | CHEST_LOSE_CON),
	(CHEST_LOSE_STR | CHEST_LOSE_CON),
	(CHEST_POISON | CHEST_PARALYZE | CHEST_LOSE_STR),
	(CHEST_POISON | CHEST_PARALYZE | CHEST_LOSE_CON),
	(CHEST_POISON | CHEST_LOSE_STR | CHEST_LOSE_CON),
	(CHEST_POISON | CHEST_LOSE_STR | CHEST_LOSE_CON),
	(CHEST_POISON | CHEST_PARALYZE | CHEST_LOSE_STR | CHEST_LOSE_CON),
	(CHEST_POISON | CHEST_PARALYZE),
	(CHEST_POISON | CHEST_PARALYZE),        /* 55 == best large steel */
	(CHEST_EXPLODE | CHEST_SUMMON),
	(CHEST_EXPLODE | CHEST_SUMMON),
	(CHEST_EXPLODE | CHEST_SUMMON),
	(CHEST_EXPLODE | CHEST_SUMMON),
	(CHEST_EXPLODE | CHEST_SUMMON),
	(CHEST_EXPLODE | CHEST_SUMMON),
	(CHEST_EXPLODE | CHEST_SUMMON),
	(CHEST_EXPLODE | CHEST_SUMMON),
};


/*
 * Class titles for the player.
 *
 * The player gets a new title every five levels, so each class
 * needs only ten titles total.
 */
cptr player_title[MAX_CLASS][PY_MAX_LEVEL / 5] =
{
	/* Warrior */
	{
#ifdef JP
		"ʼ",
		"ʼ",
		"ʼ",
		"Żʼ",
		"",
		"Ʈ",
		"ͺ",
		"˼",
		"",
		"",
#else
		"Rookie",
		"Soldier",
		"Mercenary",
		"Veteran",
		"Swordsman",
		"Champion",
		"Hero",
		"Baron",
		"Duke",
		"Lord",
#endif
	},

	/* Mage */
	{
#ifdef JP
		"",
		"",                 /*ա*/
		"ѻ",               /*աڥƥ*/
		"ѻ",
		"ѻ",
		"",
		"",
		"ѻ",
		"ץޥ",
		"Ƴ",
#else
		"Apprentice",
		"Trickster",
		"Illusionist",
		"Spellbinder",
		"Evoker",
		"Conjurer",
		"Warlock",
		"Sorcerer",
		"Ipsissimus",
		"Archimage",
#endif
	},

	/* Priest */
	{
#ifdef JP
		"",                 /**/
		"",             /*żԡΡȼΡ*/
		"",
		"",                 /**/
		"һ",               /*ʺɾİƻ*/
		"ʶ",               /*޶*/
		"ʶ",               /*ʶ綵ʶ*/
		"",                 /*׻ʡʺ*/
		"綵",               /*׻ʡ׻Ĺ*/
		"綵",
#else
		"Believer",
		"Acolyte",
		"Adept",
		"Curate",
		"Canon",
		"Priest",
		"High Priest",
		"Cardinal",
		"Inquisitor",
		"Pope",
#endif
	},

	/* Rangers */
	{
#ifdef JP
		"Ȥ",
		"",
		"͸",                         /*͸ĥꡢ廡ʼ*/
		"",
		"׼",
		"Ƴ",
		"õ",                       /*ԡõ*/
		"",
		"Ƭ",
		"",
#else
		"Runner",
		"Strider",
		"Scout",
		"Courser",
		"Tracker",
		"Guide",
		"Pathfinder",
		"Low Ranger",
		"High Ranger",
		"Ranger Lord",
#endif
	},

	/* Paladins */
	{
#ifdef JP
		"ͦ",                 /*ˡ͡ԡͦʿ*/
		"һ",
		"ݸ",
		"ɱҼ",
		"Ҽ",
		"",
		"ŵ",
		"",
		"",
		"Ĺ",
#else
		"Gallant",
		"Keeper",
		"Protector",
		"Defender",
		"Warder",
		"Knight",
		"Guardian",
		"Low Paladin",
		"High Paladin",
		"Paladin Lord",
#endif
	},

	/* Warrior-Mage */
	{
#ifdef JP
		"",
		"",			/*ա*/
		"",
		"Żʼ",
		"ʼ",
		"Ʈ",
		"˼",
		"Ѹ",
		"Ʈѻ",
		"ѷ",
#else
		"Novice",
		"Apprentice",
		"Journeyman",
		"Veteran",
		"Enchanter",
		"Champion",
		"Mage-Hero",
		"Baron Mage",
		"Battlemage",
		"Wizard Lord",
#endif
	},

	/* Mindcrafter */
	{
#ifdef JP
		"",
		"",
		"",
		"ã",
		"ۻ",
		"ѻ",
		"å",
		"˥å",
		"ѡ",
		"Ƴ",
#else
		"Trainee",
		"Acolyte",
		"Adept",
		"Immaculate",
		"Contemplator",
		"Mentalist",
		"Psychic",
		"Psionicist",
		"Esper",
		"Mindmaster",
#endif
	},

	/* Archer */
	{
#ifdef JP
		"ʼ",
		"ʼ",
		"ʼ",
		"Żʼ",
		"",
		"Ʈ",
		"ͺ",
		"˼",
		"",
		"",
#else
		"Rookie",
		"Soldier",
		"Mercenary",
		"Veteran",
		"Swordsman",
		"Champion",
		"Hero",
		"Baron",
		"Duke",
		"Lord",
#endif
	},

	/* Archaeologist */
	{
#ifdef JP
		"",
		"",
		"",
		"",
		"",
		"ֻ",
		"طݰ",
		"",
		"Ĺ",
		"ڥ󥫡",
#else
		"Apprentice",
		"Student",
		"Master",
		"Doctor",
		"Assistant",
		"Lecturer",
		"Curator",
		"Professor",
		"Chancellor",
		"Spelunker",
#endif
	},

	/* Elementalist */
	{
#ifdef JP
		"",
		"",                 /*ա*/
		"ѻ",               /*աڥƥ*/
		"ѻ",
		"ѻ",
		"",
		"",
		"ѻ",
		"ץޥ",
		"Ƴ",
#else
		"Apprentice",
		"Trickster",
		"Illusionist",
		"Spellbinder",
		"Evoker",
		"Conjurer",
		"Warlock",
		"Sorcerer",
		"Ipsissimus",
		"Archimage",
#endif
	},

	/* Archer */
	{
#ifdef JP
		"ʼ",
		"ʼ",
		"ʼ",
		"Żʼ",
		"",
		"Ʈ",
		"ͺ",
		"˼",
		"",
		"",
#else
		"Rookie",
		"Soldier",
		"Mercenary",
		"Veteran",
		"Swordsman",
		"Champion",
		"Hero",
		"Baron",
		"Duke",
		"Lord",
#endif
	},

	/* Snatcher */
	{
#ifdef JP
		"(ʤ)",
		"(ʤ)",
		"(ʤ)",
		"(ʤ)",
		"(ʤ)",
		"(ʤ)",
		"(ʤ)",
		"(ʤ)",
		"(ʤ)",
		"(ʤ)",
#else
		"(None)",
		"(None)",
		"(None)",
		"(None)",
		"(None)",
		"(None)",
		"(None)",
		"(None)",
		"(None)",
		"(None)",
#endif
	},

	/* Device-User */
	{
#ifdef JP
		"鿴",
		"鿴",
		"",
		"",
		"",
		"",
		"ޥ˥",
		"",
		"ޥ",
		"ͼ",
#else
		"Beginner",
		"Beginner",
		"Trained",
		"Trained",
		"Expert",
		"Expert",
		"Mania",
		"Master",
		"Specialist",
		"Professor",
#endif
	},
};


/*
 * Hack -- the "basic" color names (see "TERM_xxx")
 */
cptr color_names[16] =
{
#ifdef JP
	"",
	"",
	"ĳ",
	"",
	"",
	"",
	"",
	"ῧ",
	"",
	"ĳ",
	"",
	"",
	"뤤",
	"뤤",
	"뤤",
	"ῧ",
#else
	"Dark",
	"White",
	"Slate",
	"Orange",
	"Red",
	"Green",
	"Blue",
	"Umber",
	"Light Dark",
	"Light Slate",
	"Violet",
	"Yellow",
	"Light Red",
	"Light Green",
	"Light Blue",
	"Light Umber",
#endif
};


/*
 * Abbreviations of healthy stats
 */
cptr stat_names[6] =
{
#ifdef JP
	" :", "ǽ :", " :", " :", "ѵ :", "̥ :"
#else
	"STR: ", "INT: ", "WIS: ", "DEX: ", "CON: ", "CHR: "
#endif
};

/*
 * Abbreviations of damaged stats
 */
cptr stat_names_reduced[6] =
{
#ifdef JP
	"x:", "ǽx:", "x:", "x:", "ѵx:", "̥x:"
#else
	"Str: ", "Int: ", "Wis: ", "Dex: ", "Con: ", "Chr: "
#endif
};


/*
 * Certain "screens" always use the main screen, including News, Birth,
 * Dungeon, Tomb-stone, High-scores, Macros, Colors, Visuals, Options.
 *
 * Later, special flags may allow sub-windows to "steal" stuff from the
 * main window, including File dump (help), File dump (artifacts, uniques),
 * Character screen, Small scale map, Previous Messages, Store screen, etc.
 *
 * The "ctrl-i" (tab) command flips the "Display inven/equip" and "Display
 * equip/inven" flags for all windows.
 *
 * The "ctrl-g" command (or pseudo-command) should perhaps grab a snapshot
 * of the main screen into any interested windows.
 */
cptr window_flag_desc[32] =
{
#ifdef JP
	"ʪ/",
#else
	"Display inven/equip",
#endif

#ifdef JP
	"/ʪ",
#else
	"Display equip/inven",
#endif

#ifdef JP
	"ʸ",
#else
	"Display spell list",
#endif

#ifdef JP
	"饯",
#else
	"Display character",
#endif
	NULL,
	NULL,
#ifdef JP
	"å",
#else
	"Display messages",
#endif

#ifdef JP
	"󥸥ο",
#else
	"Display overhead view",
#endif

#ifdef JP
	"󥹥λפ",
#else
	"Display monster recall",
#endif

#ifdef JP
	"ƥξܺ",
#else
	"Display object recall",
#endif

#ifdef JP
	"ʬμϤɽ", 
#else
	"Display dungeon view",
#endif

#ifdef JP
	"ǰ",
#else
	"Display snap-shot",
#endif
	NULL,
	NULL,
#ifdef JP
	"ܡå",
#else
	"Display borg messages",
#endif

#ifdef JP
	"ܡơ",
#else
	"Display borg status",
#endif
	NULL,
	NULL,
	NULL,
	NULL,
	NULL,
	NULL,
	NULL,
	NULL,
	NULL,
	NULL,
	NULL,
	NULL,
	NULL,
	NULL,
	NULL,
	NULL
};


/*
 * Available Options
 *
 * Option Screen Sets:
 *
 *      Set 1: User Interface
 *      Set 2: Disturbance
 *      Set 3: Inventory
 *      Set 4: Game Play
 *
 * Note that bits 28-31 of set 0 are currently unused.
 */
option_type option_info[] =
{
	/*** User-Interface ***/
	
#ifdef JP
	{ &rogue_like_commands,         FALSE, 1, 0, 0,
	"rogue_like_commands",          "֤Ѥ" },
#else
	{ &rogue_like_commands,         FALSE, 1, 0, 0,
	"rogue_like_commands",          "Rogue-like commands" },
#endif

#ifdef JP
	{ &quick_messages,              TRUE, 1, 0, 1,
	"quick_messages",               "ååѤ" },
#else
	{ &quick_messages,              TRUE, 1, 0, 1,
	"quick_messages",               "Activate quick messages" },
#endif

#ifdef JP
	{ &auto_more,                   FALSE, 1, 2, 4,
	"auto_more",                    "ԤʤϢ³ǥåɽ" },
#else
	{ &auto_more,                   FALSE, 1, 2, 4,
	"auto_more",                    "Automatically clear '-more-' prompts" },
#endif

#ifdef JP
	{ &command_menu,                TRUE, 1, 2, 5,
	"command_menu",                 "˥塼ˤ륳ޥͭˤ" },
#else
	{ &command_menu,                TRUE, 1, 2, 5,
	"command_menu",                 "Enable command selection menu" },
#endif

#ifdef JP
	{ &other_query_flag,            FALSE, 1, 0, 2,
	"other_query_flag",             "ΥƥѤȤ˳ǧ" },
#else
	{ &other_query_flag,            FALSE, 1, 0, 2,
	"other_query_flag",             "Prompt for floor item selection" },
#endif

#ifdef JP
	{ &always_pickup,               FALSE, 1, 0, 5,
	"always_pickup",                "˥ƥ򽦤" },
#else
	{ &always_pickup,               FALSE, 1, 0, 5,
	"always_pickup",                "Pick things up by default" },
#endif

#ifdef JP
	{ &carry_query_flag,            FALSE, 1, 0, 3,
	"carry_query_flag",             "ƥ򽦤˳ǧ" },
#else
	{ &carry_query_flag,            FALSE, 1, 0, 3,
	"carry_query_flag",             "Prompt before picking things up" },
#endif

#ifdef JP
	{ &use_old_target,              FALSE, 1, 0, 4,
	"use_old_target",               "˰ΥåȤꤹ" },
#else
	{ &use_old_target,              FALSE, 1, 0, 4,
	"use_old_target",               "Use old target by default" },
#endif

#ifdef JP
	{ &always_repeat,               TRUE, 1, 0, 6,
	"always_repeat",                "ޥɼư֤" },
#else
	{ &always_repeat,               TRUE, 1, 0, 6,
	"always_repeat",                "Repeat obvious commands" },
#endif

#ifdef JP
	{ &auto_destroy,                TRUE, 1, 5, 3,
	"auto_destroy",                 "̵͡פʥƥ˲ǧʤ" },
#else
	{ &auto_destroy,                TRUE, 1, 5, 3,
	"auto_destroy",                 "No query to destroy known worthless items" },
#endif

#ifdef JP
	{ &wear_confirm,                TRUE, 1, 5, 4,
	"confirm_wear",                 "줿ʪǧ" },
#else
	{ &wear_confirm,                TRUE, 1, 5, 4,
	"confirm_wear",                 "Confirm to wear/wield known cursed items" },
#endif

#ifdef JP
	{ &confirm_stairs,              TRUE, 1, 5, 5,
	"confirm_stairs",               "̤γ˹Ԥǧ" },
#else
	{ &confirm_stairs,              TRUE, 1, 5, 5,
	"confirm_stairs",               "Prompt before exiting a dungeon level" },
#endif

#ifdef ALLOW_EASY_OPEN
#ifdef JP
	{ &easy_open,                   TRUE, 1, 5, 7,
	"easy_open",                    "ưŪ˥ɥ򳫤" },
#else
	{ &easy_open,                   TRUE, 1, 5, 7,
	"easy_open",                    "Automatically open doors" },
#endif
#endif /* ALLOW_EASY_OPEN */
	
#ifdef ALLOW_EASY_DISARM
#ifdef JP
	{ &easy_disarm,                 TRUE, 1, 5, 8,
	"easy_disarm",                  "ưŪ櫤" },
#else
	{ &easy_disarm,                 TRUE, 1, 5, 8,
	"easy_disarm",                  "Automatically disarm traps" },
#endif
#endif /* ALLOW_EASY_DISARM */

#ifdef ALLOW_EASY_FLOOR /* TNB */
#ifdef JP
	{ &easy_floor,                  TRUE, 1, 5, 9,
	"easy_floor",                   "ʣƥˤ" },
#else
	{ &easy_floor,                  TRUE, 1, 5, 9,
	"easy_floor",                   "Display floor stacks in a list" },
#endif
#endif /* ALLOW_EASY_FLOOR -- TNB */

#ifdef JP
	{ &use_command,                 FALSE, 1, 5, 10,
	"use_command",                  "ֻȤ(a)ץޥɤͭˤ" },
#else
	{ &use_command,                 FALSE, 1, 5, 10,
	"use_command",                  "Allow unified use command" },
#endif

#ifdef JP
	{ &allow_debug_opts,            FALSE, 1, 2, 13,
	"allow_debug_opts",             "ǥХå/ץĤ" },
#else
	{ &allow_debug_opts,            FALSE, 1, 2, 13,
	"allow_debug_opts",             "Allow use of debug/cheat options" },
#endif

#ifdef JP
	{ &over_exert,                  FALSE, 1, 2, 6,
	"over_exert",                   "MP­ʤƤˡĩ魯" },
#else
	{ &over_exert,                  FALSE, 1, 2, 6,
	"over_exert",                   "Allow casting spells when short of mana" },
#endif

#ifdef JP
	{ &numpad_as_cursorkey,         TRUE, 1, 2, 31,
	"numpad_as_cursorkey",          "ǥǥƥ󥭡򥫡륭ȤƻȤ" },
#else
	{ &numpad_as_cursorkey,         TRUE, 1, 2, 31,
	"numpad_as_cursorkey",          "Use numpad keys as cursor keys in editor mode" },
#endif

	/*** Display ***/
	
#ifdef JP
	{ &depth_in_feet,               FALSE, 2, 0, 7,
	"depth_in_feet",                "󥸥οեȤɽ" },
#else
	{ &depth_in_feet,               FALSE, 2, 0, 7,
	"depth_in_feet",                "Show dungeon level in feet" },
#endif

#ifdef JP
	{ &show_labels,                 TRUE, 2, 0, 10,
	"show_labels",                  "ɽ" },
#else
	{ &show_labels,                 TRUE, 2, 0, 10,
	"show_labels",                  "Show labels in object listings" },
#endif

#ifdef JP
	{ &show_weights,                TRUE, 2, 0, 11,
	"show_weights",                 "ƥǽ̤ɽ" },
#else
	{ &show_weights,                TRUE, 2, 0, 11,
	"show_weights",                 "Show weights in object listings" },
#endif

#ifdef JP
	{ &show_choices,                TRUE, 2, 0, 12,
	"show_choices",                 "ʪ/ɥ򥢥ƥɽ" },
#else
	{ &show_choices,                TRUE, 2, 0, 12,
	"show_choices",                 "Show choices in certain sub-windows" },
#endif

#ifdef JP
	{ &player_symbols,              FALSE, 2, 1, 13,
	"player_symbols",               "ץ쥤䡼̤ʵɽ"},
#else
	{ &player_symbols,              FALSE, 2, 1, 13,
	"player_symbols",               "Use special symbols for the player char"},
#endif

#ifdef JP
	{ &equippy_chars,               TRUE, 2, 1, 12,
	"equippy_chars",                "ơʸɽ" },
#else
	{ &equippy_chars,               TRUE, 2, 1, 12,
	"equippy_chars",                "Display 'equippy' chars" },
#endif

#ifdef JP
	{ &skip_mutations,              FALSE, 2, 5, 0,
	"skip_mutations",               "'C'ޥɤѰۤɽʤ" },
#else
	{ &skip_mutations,              FALSE, 2, 5, 0,
	"skip_mutations",               "Skip mutations in 'C'haracter Display" },
#endif

#ifdef JP
	{ &plain_descriptions,          TRUE, 2, 5, 1,  /*ܸѹ*/
	"plain_descriptions",           "ƥεҤάˤ" },
#else
	{ &plain_descriptions,          TRUE, 2, 5, 1,
	"plain_descriptions",           "Plain object descriptions" },
#endif

#ifdef JP
	{ &center_player,               FALSE, 2, 5, 11,
	"center_player",                "˥ץ쥤䡼濴֤(*٤*)" },
#else
	{ &center_player,               FALSE, 2, 5, 11,
	"center_player",                "Always center on the player (*slow*)" },
#endif

#ifdef JP
	{ &avoid_center,                FALSE, 2, 5, 12,
	"avoid_center",                 "äƤ濴֤ʤ" },
#else
	{ &avoid_center,                FALSE, 2, 5, 12,
	"avoid_center",                 "Avoid centering while running" },
#endif

#ifdef JP
	{ &view_yellow_lite,            TRUE, 2, 1, 28,
	"view_yellow_lite",             "ϰϤ̤ʿɽ" },
#else
	{ &view_yellow_lite,            TRUE, 2, 1, 28,
	"view_yellow_lite",             "Use special colors for torch-lit grids" },
#endif

#ifdef JP
	{ &view_bright_lite,            TRUE, 2, 1, 29,
	"view_bright_lite",             "볦ϰϤ̤ʿɽ" },
#else
	{ &view_bright_lite,            TRUE, 2, 1, 29,
	"view_bright_lite",             "Use special colors for 'viewable' grids" },
#endif

#ifdef JP
	{ &view_granite_lite,           TRUE, 2, 1, 30,
	"view_granite_lite",            "ɤ̤ʿɽ(Ť)" },
#else
	{ &view_granite_lite,           TRUE, 2, 1, 30,
	"view_granite_lite",            "Use special colors for wall grids (slow)" },
#endif

#ifdef JP
	{ &view_special_lite,           TRUE, 2, 1, 31,
	"view_special_lite",            "̤ʿɽ(Ť)" },
#else
	{ &view_special_lite,           TRUE, 2, 1, 31,
	"view_special_lite",            "Use special colors for floor grids (slow)" },
#endif

#ifdef JP
	{ &new_ascii_graphics,          TRUE, 2, 2, 8,
	"new_ascii_graphics",           "ϷŤϤäɽ" },
#else
	{ &new_ascii_graphics,          TRUE, 2, 2, 8,
	"new_ascii_graphics",           "Show a clear contrast between light and dark" },
#endif

#ifdef JP
	{ &display_path,                TRUE, 2, 2, 7,
	"display_path",                 "ˡεƻɽ" },
#else
	{ &display_path,                TRUE, 2, 2, 7,
	"display_path",                 "Display actual path before shooting" },
#endif

#ifdef JP
	{ &always_show_list,            TRUE, 2, 2, 9,
	"always_show_list",             "ˤϾ˰ɽ" },
#else
	{ &always_show_list,            TRUE, 2, 2, 9,
	"always_show_list",             "Always show list" },
#endif

#ifdef JP
	{ &abbrev_extra,                FALSE, 2, 5, 14,
	"abbrev_extra",                 "ƥɲ/ǽϤάΤ" },
#else
	{ &abbrev_extra,                FALSE, 2, 5, 14,
	"abbrev_extra",                 "Describe obj's extra resistances by abbreviation" },
#endif

#ifdef JP
	{ &abbrev_all,                  FALSE, 2, 5, 15,
	"abbrev_all",                   "ƥƤ/ǽϤάΤ" },
#else
	{ &abbrev_all,                  FALSE, 2, 5, 15,
	"abbrev_all",                   "Describe obj's all resistances by abbreviation" },
#endif

#ifdef JP
	{ &exp_need,                    FALSE, 2, 5, 13,
	"exp_need",                     "Υ٥ɬפʷиͤɽ" },
#else
	{ &exp_need,                    FALSE, 2, 5, 13,
	"exp_need",                     "Show the experience needed for next level" },
#endif

	/*** Game-Play ***/
	
#ifdef JP
	{ &auto_haggle,                 TRUE,  3, 1, 0,
	"auto_haggle",                  "ŹڤĤ򤷤ʤ" },
#else
	{ &auto_haggle,                 TRUE, 3, 1, 0,
	"auto_haggle",                  "Auto-haggle in stores" },
#endif

#ifdef JP
	{ &auto_scum,                   FALSE, 3, 1, 1,
	"auto_scum",                    "ʷϵư깥" },
#else
	{ &auto_scum,                   FALSE, 3, 1, 1,
	"auto_scum",                    "Auto-scum for good levels" },
#endif

#ifdef JP
	{ &small_levels,                TRUE, 3, 0, 30,
	"small_levels",                 "˾եǽˤ" },
#else
	{ &small_levels,                TRUE, 3, 0, 30,
	"small_levels",                 "Allow unusually small dungeon levels" },
#endif

#ifdef JP
	{ &always_small_levels,         FALSE, 3, 2, 3,
	"always_small_levels",          "˾ե" },
#else
	{ &always_small_levels,         FALSE, 3, 2, 3,
	"always_small_levels",          "Always create unusually small dungeon levels" },
#endif

#ifdef JP
	{ &empty_levels,                TRUE, 3, 0, 31,
	"empty_levels",                 "äݤΡ֥꡼ʡץ٥ǽˤ" },
#else
	{ &empty_levels,                TRUE, 3, 0, 31,
	"empty_levels",                 "Allow empty 'arena' levels" },
#endif

#ifdef JP
	{ &stack_force_notes,           TRUE, 3, 0, 8,
	"stack_force_notes",            "ۤʤäΥƥޤȤ" },
#else
	{ &stack_force_notes,           TRUE, 3, 0, 8,
	"stack_force_notes",            "Merge inscriptions when stacking" },
#endif

#ifdef JP
	{ &stack_force_costs,           TRUE, 3, 0, 9,
	"stack_force_costs",            "ۤʤɽΥƥޤȤ" },
#else
	{ &stack_force_costs,           TRUE, 3, 0, 9,
	"stack_force_costs",            "Merge discounts when stacking" },
#endif

#ifdef JP
	{ &stack_allow_items,           TRUE, 3, 1, 2,
	"stack_allow_items",            "ƱɶޤȤ" },
#else
	{ &stack_allow_items,           TRUE, 3, 1, 2,
	"stack_allow_items",            "Allow weapons and armor to stack" },
#endif

#ifdef JP
	{ &stack_allow_wands,           TRUE, 3, 1, 3,
	"stack_allow_wands",            "ƱΥ/å/åɤޤȤ" },
#else
	{ &stack_allow_wands,           TRUE, 3, 1, 3,
	"stack_allow_wands",            "Allow wands/staffs/rods to stack" },
#endif

#ifdef JP
	{ &expand_look,                 TRUE, 3, 1, 4,
	"expand_look",                  "ֲĴ٤ץޥɤĥ" },
#else
	{ &expand_look,                 TRUE, 3, 1, 4,
	"expand_look",                  "Expand the power of the look command" },
#endif

#ifdef JP
	{ &expand_list,                 TRUE, 3, 1, 5,
	"expand_list",                  "ְץޥɤĥ" },
#else
	{ &expand_list,                 TRUE, 3, 1, 5,
	"expand_list",                  "Expand the power of the list commands" },
#endif

#ifdef JP
	{ &view_perma_grids,            TRUE, 3, 1, 6,
	"view_perma_grids",             "뤤ϤΤޤޤˤ" },
#else
	{ &view_perma_grids,            TRUE, 3, 1, 6,
	"view_perma_grids",             "Map remembers all perma-lit grids" },
#endif

#ifdef JP
	{ &view_torch_grids,            FALSE, 3, 1, 7,
	"view_torch_grids",             "ǾȤ餷ϤΤޤޤˤ" },
#else
	{ &view_torch_grids,            FALSE, 3, 1, 7,
	"view_torch_grids",             "Map remembers all torch-lit grids" },
#endif

#ifdef JP
	{ &view_unsafe_grids,            TRUE, 3, 2, 10,
	"view_unsafe_grids",             "ȥå״κѤߤǤʤɽ" },
#else
	{ &view_unsafe_grids,            TRUE, 3, 2, 10,
	"view_unsafe_grids",             "Map marked by detect traps" },
#endif

#ifdef JP
	{ &dungeon_align,               TRUE, 3, 1, 8,
	"dungeon_align",                "󥸥򤽤" },
#else
	{ &dungeon_align,               TRUE, 3, 1, 8,
	"dungeon_align",                "Generate dungeons with aligned rooms" },
#endif

#ifdef JP
	{ &dungeon_stair,               TRUE, 3, 1, 9,
	"dungeon_stair",                "ʤĤʤƥ󥸥" },
#else
	{ &dungeon_stair,               TRUE, 3, 1, 9,
	"dungeon_stair",                "Generate dungeons with connected stairs" },
#endif

#ifdef JP
	{ &last_words,                  TRUE, 3, 0, 28,
	"last_words",                   "饯Τ" },
#else
	{ &last_words,                  TRUE, 3, 0, 28,
	"last_words",                   "Get last words when the character dies" },
#endif

#ifdef JP
	{ &speak_unique,                TRUE, 3, 0, 29,
	"speak_unique",                 "Źˡ󥹥٤" },
#else
	{ &speak_unique,                TRUE, 3, 0, 29,
	"speak_unique",                 "Allow shopkeepers and uniques to speak" },
#endif

#ifdef JP
	{ &ignore_unview,               FALSE, 3, 2, 16,
	"ignore_unview",                "볦Υ󥹥ιưɽʤ" },
#else
	{ &ignore_unview,               FALSE, 3, 2, 16,
	"ignore_unview",                "Ignore whenever any monster does" },
#endif

	/*** Disturbance ***/
	
#ifdef JP
	{ &find_ignore_stairs,          FALSE, 4, 0, 16,
	"find_ignore_stairs",           "ʤ̲᤹" },
#else
	{ &find_ignore_stairs,          FALSE, 4, 0, 16,
	"find_ignore_stairs",           "Run past stairs" },
#endif

#ifdef JP
	{ &find_ignore_doors,           TRUE, 4, 0, 17,
	"find_ignore_doors",            "ɥ̲᤹" },
#else
	{ &find_ignore_doors,           TRUE, 4, 0, 17,
	"find_ignore_doors",            "Run through open doors" },
#endif

#ifdef JP
	{ &find_ignore_trees,           TRUE, 4, 2, 15,
	"find_ignore_trees",            "ڤ̲᤹" },
#else
	{ &find_ignore_trees,           TRUE, 4, 2, 15,
	"find_ignore_trees",            "Run through trees" },
#endif

#ifdef JP
	{ &find_cut,                    FALSE, 4, 0, 18,
	"find_cut",                     "ΤζʤѤ̲᤹" },
#else
	{ &find_cut,                    FALSE, 4, 0, 18,
	"find_cut",                     "Run past known corners" },
#endif

#ifdef JP
	{ &find_examine,                TRUE, 4, 0, 19,
	"find_examine",                 "ʤѤ⤷ʤ̲᤹" },
#else
	{ &find_examine,                TRUE, 4, 0, 19,
	"find_examine",                 "Run into potential corners" },
#endif

#ifdef JP
	{ &disturb_move,                FALSE, 4, 0, 20,
	"disturb_move",                 "ɤΥ󥹥ưƤưߤ" },
#else
	{ &disturb_move,                FALSE, 4, 0, 20,
	"disturb_move",                 "Disturb whenever any monster moves" },
#endif

#ifdef JP
	{ &disturb_near,                TRUE, 4, 0, 21,
	"disturb_near",                 "볦󥹥ưưߤ" },
#else
	{ &disturb_near,                TRUE, 4, 0, 21,
	"disturb_near",                 "Disturb whenever viewable monster moves" },
#endif

#ifdef JP
	{ &disturb_pets,                FALSE, 4, 5, 6,
	"disturb_pets",                 "볦ˤڥåȤưưߤ" },
#else
	{ &disturb_pets,                FALSE, 4, 5, 6,
	"disturb_pets",                 "Disturb when visible pets move" },
#endif

#ifdef JP
	{ &disturb_panel,               TRUE, 4, 0, 22,
	"disturb_panel",                "̥˹ưߤ" },
#else
	{ &disturb_panel,               TRUE, 4, 0, 22,
	"disturb_panel",                "Disturb whenever map panel changes" },
#endif

#ifdef JP
	{ &disturb_state,               TRUE, 4, 0, 23,
	"disturb_state",                "ʬΥơѲ˹ưߤ" },
#else
	{ &disturb_state,               TRUE, 4, 0, 23,
	"disturb_state",                "Disturb whenever player state changes" },
#endif

#ifdef JP
	{ &disturb_minor,               TRUE, 4, 0, 24,
	"disturb_minor",                "٤ʤȤƤưߤ" },
#else
	{ &disturb_minor,               TRUE, 4, 0, 24,
	"disturb_minor",                "Disturb whenever boring things happen" },
#endif

#ifdef JP
	{ &disturb_other,               TRUE, 4, 0, 25,
	"disturb_other",                "͡ʤȤưߤ" },
#else
	{ &disturb_other,               TRUE, 4, 0, 25,
	"disturb_other",                "Disturb whenever random things happen" },
#endif

#ifdef JP
	{ &ring_bell,                   FALSE, 4, 0, 14,
	"ring_bell",                    "ӡײĤ餹(顼ʤ)" },
#else
	{ &ring_bell,                   FALSE, 4, 0, 14,
	"ring_bell",                    "Audible bell (on errors, etc)" },
#endif

#ifdef JP
	{ &alert_hitpoint,              FALSE, 4, 0, 26,
	"alert_hitpoint",               "ҥåȥݥȤηٹ˥ӡפĤ餹" },
#else
	{ &alert_hitpoint,              FALSE, 4, 0, 26,
	"alert_hitpoint",               "Alert user to critical hitpoints" },
#endif

#ifdef JP
	{ &alert_failure,               FALSE, 4, 0, 27,
	"alert_failure",                "͡ʥߥٹ𤹤Ȥ˥ӡפĤ餹" },
#else
	{ &alert_failure,               FALSE, 4, 0, 27,
	"alert_failure",                "Alert user to various failures" },
#endif

#ifdef JP
	{ &disturb_trap_detect,         TRUE, 4, 2, 11,
	"disturb_trap_detect",          "ȥå״ϰϳ˽Фľ˹ưߤ" },
#else
	{ &disturb_trap_detect,         TRUE, 4, 2, 11,
	"disturb_trap_detect",          "Disturb when leaving trap detected area"},
#endif

#ifdef JP
	{ &alert_trap_detect,           TRUE, 4, 2, 12,
	"alert_trap_detect",            "ȥå״ϰϳ˽Фľ˷ٹ𤹤" },
#else
	{ &alert_trap_detect,           TRUE, 4, 2, 12,
	"alert_trap_detect",            "Alert when leaving trap detected area"},
#endif

	/*** Efficiency ***/

#ifdef JP
	{ &use_color,                   TRUE, 5, 0, 15,
	"use_color",                    "ǽʤ饫顼ɽ٤" },
#else
	{ &use_color,                   TRUE, 5, 0, 15,
	"use_color",                    "Use color if possible (slow)" },
#endif

#ifdef JP
	{ &avoid_other,                 FALSE, 5, 1, 19,
	"avoid_other",                  "󥹥̤ʿѤʤ" },
#else
	{ &avoid_other,                 FALSE, 5, 1, 19,
	"avoid_other",                  "Avoid processing special colors" },
#endif

#ifdef JP
	{ &view_reduce_lite,            FALSE, 5, 1, 16,
	"view_reduce_lite",             "äƤȤȾ¤򸺾" },
#else
	{ &view_reduce_lite,            FALSE, 5, 1, 16,
	"view_reduce_lite",             "Reduce lite-radius when running" },
#endif

#ifdef JP
	{ &view_reduce_view,            FALSE, 5, 1, 17,
	"view_reduce_view",             "Ǥϻ򶹤" },
#else
	{ &view_reduce_view,            FALSE, 5, 1, 17,
	"view_reduce_view",             "Reduce view-radius in town" },
#endif

#ifdef JP
	{ &avoid_abort,                 FALSE, 5, 1, 18,
	"avoid_abort",                  "Ϣ³ޥɤϥϤǤʤ" },
#else
	{ &avoid_abort,                 FALSE, 5, 1, 18,
	"avoid_abort",                  "Avoid checking for user abort" },
#endif

#ifdef JP
	{ &flush_failure,               TRUE, 5, 1, 20,
	"flush_failure",                "͡ʥߥȯϤ򥯥ꥢ" },
#else
	{ &flush_failure,               TRUE, 5, 1, 20,
	"flush_failure",                "Flush input on various failures" },
#endif

#ifdef JP
	{ &flush_disturb,               FALSE, 5, 1, 21,
	"flush_disturb",               "㳲ȯϤ򥯥ꥢ" },
#else
	{ &flush_disturb,               FALSE, 5, 1, 21,
	"flush_disturb",                "Flush input whenever disturbed" },
#endif

#ifdef JP
	{ &flush_command,               FALSE, 5, 1, 22,
	"flush_command",                "ޥ˾Ϥ򥯥ꥢ" },
#else
	{ &flush_command,               FALSE, 5, 1, 22,
	"flush_command",                "Flush input before every command" },
#endif

#ifdef JP
	{ &fresh_before,                TRUE, 5, 1, 23,
	"fresh_before",                 "ޥ˲̤褹" },
#else
	{ &fresh_before,                TRUE, 5, 1, 23,
	"fresh_before",                 "Flush output before every command" },
#endif

#ifdef JP
	{ &fresh_after,                 FALSE, 5, 1, 24,
	"fresh_after",                  "ޥɸ˲̤褹" },
#else
	{ &fresh_after,                 FALSE, 5, 1, 24,
	"fresh_after",                  "Flush output after every command" },
#endif

#ifdef JP
	{ &fresh_message,               FALSE, 5, 1, 25,
	"fresh_message",                "åθ˲̤褹" },
#else
	{ &fresh_message,               FALSE, 5, 1, 25,
	"fresh_message",                "Flush output after every message" },
#endif

#ifdef JP
	{ &compress_savefile,           TRUE, 5, 1, 26,
	"compress_savefile",            "֡եΥå򰵽̤" },
#else
	{ &compress_savefile,           TRUE, 5, 1, 26,
	"compress_savefile",            "Compress messages in savefiles" },
#endif

#ifdef JP
	{ &hilite_player,               TRUE, 5, 1, 27,
	"hilite_player",                "ץ쥤䡼˥碌" },
#else
	{ &hilite_player,               TRUE, 5, 1, 27,
	"hilite_player",                "Hilite the player with the cursor" },
#endif

	/*** Initialize ***/

#ifdef JP
	{ &vanilla_town,                FALSE, 6, 6, 0,
	"vanilla_town",                 "Ĥγ/Ȥȹʤ" },
#else
	{ &vanilla_town,                FALSE, 6, 6, 0,
	"vanilla_town",                 "Use 'vanilla' town without quests and wilderness" },
#endif

#ifdef JP
	{ &lite_town,                   FALSE, 6, 6, 1,
	"lite_town",                    "Ϥʳ/ʤ" },
#else
	{ &lite_town,                   FALSE, 6, 6, 1,
	"lite_town",                    "Use 'lite' town without a wilderness" },
#endif

#ifdef JP
	{ &ironman_shops,               FALSE, 6, 6, 2,
	"ironman_shops",                "ŴѡŹѤʤ" },
#else
	{ &ironman_shops,               FALSE, 6, 6, 2,
	"ironman_shops",                "Stores are permanently closed" },
#endif

#ifdef JP
	{ &ironman_small_levels,        FALSE, 6, 6, 3,
	"ironman_small_levels",         "Ŵѡ˾˾ե" },
#else
	{ &ironman_small_levels,        FALSE, 6, 6, 3,
	"ironman_small_levels",         "Always create unusually small dungeon levels" },
#endif

#ifdef JP
	{ &ironman_downward,            FALSE, 6, 6, 4,
	"ironman_downward",             "Ŵѡ˵ԤȾ곬ʤʤ" },
#else
	{ &ironman_downward,            FALSE, 6, 6, 4,
	"ironman_downward",             "Don't allow climbing upwards/recalling" },
#endif

#ifdef JP
	{ &ironman_autoscum,            FALSE, 6, 6, 5,
	"ironman_autoscum",             "Ŵѡ˾˳ʷϵư깥ߤ" },
#else
	{ &ironman_autoscum,            FALSE, 6, 6, 5,
	"ironman_autoscum",             "Permanently enable the autoscummer" },
#endif

#ifdef JP
	{ &ironman_empty_levels,        FALSE, 6, 6, 8,
	"ironman_empty_levels",         "Ŵѡ˾˶äݤΥ꡼ʥ٥" },
#else
	{ &ironman_empty_levels,        FALSE, 6, 6, 8,
	"ironman_empty_levels",         "Always create empty 'arena' levels" },
#endif

#ifdef JP
	{ &terrain_streams,             TRUE, 6, 6, 9,
	"terrain_streams",              "俹ʤɤ󥸥" },
#else
	{ &terrain_streams,             TRUE, 6, 6, 9,
	"terrain_streams",              "Create terrain 'streamers' in the dungeon" },
#endif

#ifdef JP
	{ &munchkin_death,              FALSE, 6, 6, 11,
	"munchkin_death",               "ʤ˻֤뤫ǧ" },
#else
	{ &munchkin_death,              FALSE, 6, 6, 11,
	"munchkin_death",               "Ask for saving death" },
#endif

#if 0
#ifdef JP
	{ &munchkin_rings,              FALSE, 6, 6, 17,
	"munchkin_rings",               "ʤ˻ؤ" },
#else
	{ &munchkin_rings,              FALSE, 6, 6, 17,
	"munchkin_rings",               "Allow multiple rings" },
#endif
#endif
   
#ifdef JP
	{ &ironman_rooms,               FALSE, 6, 6, 12,
	"ironman_rooms",                "Ŵѡ˾̤Ǥʤ" },
#else
	{ &ironman_rooms,               FALSE, 6, 6, 12,
	"ironman_rooms",                "Always generate very unusual rooms" },
#endif

#ifdef JP
	{ &ironman_nightmare,           FALSE, 6, 6, 18,
	"ironman_nightmare",            "Ŵѡ˰̴⡼(ԾǤ)" },
#else
	{ &ironman_nightmare,           FALSE, 6, 6, 18,
	"ironman_nightmare",            "Nightmare mode (this isn't even remotely fair!)" },
#endif

#ifdef JP
	{ &maximize_mode,               TRUE, 6, 6, 13,
	"maximize_mode",                "粽⡼ɻ" },
#else
	{ &maximize_mode,               TRUE, 6, 6, 13,
	"maximize_mode",                "Maximize stats" },
#endif

#ifdef JP
	{ &preserve_mode,               TRUE, 6, 6, 14,
	"preserve_mode",                "¸⡼ɻ" },
#else
	{ &preserve_mode,               TRUE, 6, 6, 14,
	"preserve_mode",                "Preserve artifacts" },
#endif

#ifdef JP
	{ &autoroller,                  TRUE, 6, 6, 15,
	"autoroller",                   "ȥ顼" },
#else
	{ &autoroller,                  TRUE, 6, 6, 15,
	"autoroller",                   "Specify 'minimal' stats (use auto-roller)" },
#endif

#ifdef JP
	{ &point_based,                 FALSE, 6, 6, 16,
	"point_based",                  "ݥȿʬǥ饯" },
#else
	{ &point_based,                 FALSE, 6, 6, 16,
	"point_based",                  "Generate character using a point system" },
#endif

#ifdef JP
	{ &delay_autoroll,              FALSE, 6, 6, 17,
	"delay_autoroll",               "ȥ顼˥Ȥ" },
#else
	{ &delay_autoroll,              FALSE, 6, 6, 17,
	"delay_autoroll",               "Run auto-roller slowly" },
#endif

#ifdef JP
	{ &ironman_hengband,            FALSE, 6, 6, 19,
	"ironman_hengband",             "Ŵѡ͡ʥӥ塼Ȥʤ(̤)" },
#else
	{ &ironman_hengband,            FALSE, 6, 6, 19,
	"ironman_hengband",               "Set monsters against some abuses." },
#endif

	/*** Object auto-destruction ***/

#ifdef JP
	{ &destroy_items,               TRUE, 7, 7, 0,
	"destroy_items",                "ʰ׼ư˲Ѥ" },
#else
	{ &destroy_items,               TRUE, 7, 7, 0,
	"destroy_items",                "Auto-destroy known worthless items" },
#endif

#ifdef JP
	{ &destroy_feeling,               FALSE, 7, 7, 4,
	"destroy_feeling",                "ʰ״ꤷȤʰ׼ư˲ŬѤ" },
#else
	{ &destroy_feeling,               FALSE, 7, 7, 4,
	"destroy_feeling",                "Apply auto-destroy as sense feeling" },
#endif

#ifdef JP
	{ &destroy_identify,               FALSE, 7, 7, 5,
	"destroy_identify",                "ꤷȤʰ׼ư˲ŬѤ" },
#else
	{ &destroy_identify,               FALSE, 7, 7, 5,
	"destroy_identify",                "Apply auto-destroy as identify an item" },
#endif

#ifdef JP
	{ &leave_worth,                 TRUE, 7, 7, 1,
	"leave_worth",                  "ͤΤ륢ƥϲʤ" },
#else
	{ &leave_worth,                 TRUE, 7, 7, 1,
	"leave_worth",                  "Auto-destroyer leaves known worthy items" },
#endif

#ifdef JP
	{ &leave_equip,                 FALSE, 7, 7, 2,
	"leave_equip",                  "/ɶϲʤ" },
#else
	{ &leave_equip,                 FALSE, 7, 7, 2,
	"leave_equip",                  "Auto-destroyer leaves weapons and armour" },
#endif

#ifdef JP
	{ &leave_chest,                 TRUE, 7, 7, 3,
	"leave_chest",                  "ƤʤȢϲʤ" },
#else
	{ &leave_chest,                 TRUE, 7, 7, 3,
	"leave_chest",                  "Auto-destroyer leaves closed chests" },
#endif

	/*** Difficulty ***/

#ifdef JP
	{ &flow_by_sound,               TRUE, 8, 1, 10,
	"flow_by_sound",                "󥹥ϸߤΰ֤פ(ĶŤ)" },
#else
	{ &flow_by_sound,               TRUE, 8, 1, 10,
	"flow_by_sound",                "Monsters chase current location (v.slow)" },
#endif

#ifdef JP
	{ &flow_by_smell,               TRUE, 8, 1, 11,
	"flow_by_smell",                "󥹥ϺǶΰ֤פ(ĶŤ)" },
#else
	{ &flow_by_smell,               TRUE, 8, 1, 11,
	"flow_by_smell",                "Monsters chase recent locations (v.slow)" },
#endif

#ifdef JP
	{ &smart_learn,                 FALSE, 8, 1, 14,
	"smart_learn",                  "󥹥ϼԤؽ" },
#else
	{ &smart_learn,                 FALSE, 8, 1, 14,
	"smart_learn",                  "Monsters learn from their mistakes" },
#endif

#ifdef JP
	{ &smart_cheat,                 FALSE, 8, 1, 15,
	"smart_cheat",                  "󥹥ϥץ쥤䡼μߤͤ" },
#else
	{ &smart_cheat,                 FALSE, 8, 1, 15,
	"smart_cheat",                  "Monsters exploit players weaknesses" },
#endif

#ifdef JP
	{ &stupid_monsters,             FALSE, 8, 5, 2,
	"stupid_monsters",              "󥹥ȴʹưȤ" },
#else
	{ &stupid_monsters,             FALSE, 8, 5, 2,
	"stupid_monsters",              "Monsters behave stupidly" },
#endif

	/*** Auto-record ***/

#ifdef JP
	{ &dump_abilities,              TRUE, 9, 7, 30,
	"dump_abilities",               "äΤ륢ƥǽϤפ˽Ϥ" },
#else
	{ &dump_abilities,              TRUE, 9, 7, 30,
	"dump_abilities",               "Dump all abilities of items own names" },
#endif

#ifdef JP
	{ &dump_messages,              FALSE, 9, 7, 31,
	"dump_messages",               "åפ˽Ϥ" },
#else
	{ &dump_messages,              FALSE, 9, 7, 31,
	"dump_messages",               "Record message logs to a character dump" },
#endif

#ifdef JP
	{ &take_notes,                  FALSE, 9, 7, 28,
	"take_notes",                   "ץ쥤ե˵Ͽ" },
#else
	{ &take_notes,                  FALSE, 9, 7, 28,
	"take_notes",                   "Allow notes to be appended to a file" },
#endif

#ifdef JP
	{ &auto_notes,                  TRUE, 9, 7, 27,
	"auto_notes",                   "פʽϿ" },
#else
	{ &auto_notes,                  TRUE, 9, 7, 27,
	"auto_notes",                   "Automatically note important events" },
#endif

#ifdef JP
	{ &record_artifact,             TRUE, 9, 7, 26,
	"record_artifact",              "ƥեȤϿ" },
#else
	{ &record_artifact,             TRUE, 9, 7, 26,
	"record_artifact",              "Record founded artifacts" },
#endif

#ifdef JP
	{ &record_randart,              TRUE, 9, 7, 25,
	"record_randart",               "ॢƥեȤϿ" },
#else
	{ &record_randart,              TRUE, 9, 7, 25,
	"record_randart",               "Record founded random artifacts" },
#endif

#ifdef JP
	{ &record_unique,               TRUE, 9, 7, 24,
	"record_unique",                "ˡ󥹥ݤȤϿ" },
#else
	{ &record_unique,               TRUE, 9, 7, 24,
	"record_unique",                "Record defeated unique monsters" },
#endif

#ifdef JP
	{ &record_quest,                TRUE, 9, 7, 23,
	"record_quest",                 "ȤãȤϿ" },
#else
	{ &record_quest,                TRUE, 9, 7, 23,
	"record_quest",                 "Record completed quests" },
#endif

	/* Hitpoint waring */

	{ &prompt_hitpoint,             TRUE, 10, 2, 17,
#ifdef JP
	"prompt_hitpoint",               "ҥåȥݥȻ˥åå̵뤹" },
#else
	"prompt_hitpoint",               "Ignore quick message when hitpoint warning" },
#endif

#ifdef JP
	{ &stop_more,                   FALSE, 10, 2, 14,
	"stop_more",                    "᡼˥Ԥ" },
#else
	{ &stop_more,                   FALSE, 10, 2, 14,
	"stop_more",                    "Prompt -more- if you'll be damaged" },
#endif

	/*** Dead options ***/

#ifdef JP
	{ &show_inven_graph,            TRUE, 0, 2, 0,  /*ܸѹ*/
	"show_inven_graph",             "ʪ򥰥եɽ" },
#else
	{ &show_inven_graph,            TRUE, 0, 2, 0,
	"show_inven_graph",             "Show graphics in inventory list" },
#endif

#ifdef JP
	{ &show_equip_graph,            TRUE, 0, 2, 1,  /*ܸѹ*/
	"show_equip_graph",             "򥰥եɽ" },
#else
	{ &show_equip_graph,            TRUE, 0, 2, 1,
	"show_equip_graph",             "Show graphics in equipment list" },
#endif

#ifdef JP
	{ &show_store_graph,            TRUE, 0, 2, 2,  /*ܸѹ*/
	"show_store_graph",             "Źʪ򥰥եɽ" },
#else
	{ &show_store_graph,            TRUE, 0, 2, 2,
	"show_store_graph",             "Show graphics in stores" },
#endif

#ifdef JP
	{ &show_details,                TRUE, 0, 0, 13,
	"show_details",                 "󥹥λפФܤɽ" },
#else
	{ &show_details,                TRUE, 0, 0, 13,
	"show_details",                 "Show details in certain sub-windows" },
#endif

	/*** End of Table ***/

	{ NULL,                         0, 0, 0, 0,
	NULL,                           NULL }
};


martial_arts ma_blows[MAX_MA] =
{
#ifdef JP
	{ "%s򲥤ä",                           1, 0, 1, 4, 0 },
	{ "%s򽳤ä",                           2, 0, 1, 5, 0 },
	{ "%sͤ򤯤路",             3, 0, 1, 6, 0 },
	{ "%sɨ򤯤路",               5, 5, 2, 3, MA_KNEE },
	{ "%sɪǤ򤯤路",               7, 5, 1, 7, 0 },
	{ "%sƬͤ򤯤路",               9, 10, 2, 4, 0 },
	{ "%s򽳤ä",                           11, 10, 2, 5, MA_SLOW },
	{ "%s˥åѡ򤯤路",             13, 12, 3, 5, 6 },
	{ "%sʽ򤯤路",             16, 15, 6, 3, 8 },
	{ "%sǭ޷򤯤路",               20, 20, 4, 6, 0 },
	{ "%sķӤ򤯤路",               25, 25, 4, 7, 10 },
	{ "%s޽򤯤路",               29, 25, 5, 6, 0 },
	{ "%s˲󤷽򤯤路",             33, 30, 5, 8, 10 },
	{ "%sŴ򤯤路",               37, 35, 6, 8, 10 },
	{ "%sӤ򤯤路",               41, 35, 7, 8, 12 },
	{ "%s˾ζ򤯤路",               45, 35, 7, 10, 16 },
	{ "%sŷ÷򤯤路",           48, 35, 7, 12, 18 },
#else
	{ "You punch %s.",                          1, 0, 1, 4, 0 },
	{ "You kick %s.",                           2, 0, 1, 5, 0 },
	{ "You strike %s.",                         3, 0, 1, 6, 0 },
	{ "You hit %s with your knee.",             5, 5, 2, 3, MA_KNEE },
	{ "You hit %s with your elbow.",            7, 5, 1, 7, 0 },
	{ "You butt %s.",                           9, 10, 2, 4, 0 },
	{ "You kick %s.",                           11, 10, 2, 5, MA_SLOW },
	{ "You uppercut %s.",                       13, 12, 3, 5, 6 },
	{ "You double-kick %s.",                    16, 15, 6, 3, 8 },
	{ "You hit %s with a Cat's Claw.",          20, 20, 4, 6, 0 },
	{ "You hit %s with a jump kick.",           25, 25, 4, 7, 10 },
	{ "You hit %s with an Eagle's Claw.",       29, 25, 5, 6, 0 },
	{ "You hit %s with a circle kick.",         33, 30, 5, 8, 10 },
	{ "You hit %s with an Iron Fist.",          37, 35, 6, 8, 10 },
	{ "You hit %s with a flying kick.",         41, 35, 7, 8, 12 },
	{ "You hit %s with a Dragon Fist.",         45, 35, 7, 10, 16 },
	{ "You hit %s with a Crushing Blow.",       48, 35, 7, 12, 18 },
#endif
};

/*
 * Table of game-generated inscriptions (indexed by the defines in
 * defines.h). -- RG
 */
cptr game_inscriptions[] =
{
	NULL,            /* FEEL_NONE */
#ifdef JP
	"Ƥ",    /* FEEL_BROKEN */
	"",      /* FEEL_TERRIBLE */
	"̵",        /* FEEL_WORTHLESS */
	"Ƥ",  /* FEEL_CURSED */
	"ʾ",      /* FEEL_UNCURSED */
	"",            /* FEEL_AVERAGE */
	"",          /* FEEL_GOOD */
	"",        /* FEEL_EXCELLENT */
	"",        /* FEEL_SPECIAL */
#else
	"broken",        /* FEEL_BROKEN */
	"terrible",      /* FEEL_TERRIBLE */
	"worthless",     /* FEEL_WORTHLESS */
	"cursed",        /* FEEL_CURSED */
	"uncursed",      /* FEEL_UNCURSED */
	"average",       /* FEEL_AVERAGE */
	"good",          /* FEEL_GOOD */
	"excellent",     /* FEEL_EXCELLENT */
	"special",       /* FEEL_SPECIAL */
#endif
};


#ifndef JP
/* Weird melee attack types when hallucinating */
cptr silly_attacks[MAX_SILLY_ATTACK] =
{
	"smothers",
	"hugs",
	"humiliates",
	"whips",
	"kisses",

	"disgusts",
	"pees all over",
	"passes the gas on",
	"makes obscene gestures at",
	"licks",

	"stomps on",
	"swallows",
	"drools on",
	"misses",
	"shrinks",

	"emasculates",
	"evaporates",
	"solidifies",
	"digitizes",
	"insta-kills",

	"massacres",
	"slaughters",
	"drugs",
	"psychoanalyzes",
	"deconstructs",

	"falsifies",
	"disbelieves",
	"molests"
};
#endif


/*
 * The table of monsters' blow effects
 */
mbe_info_type mbe_info[] =
{
	{  0, 0,             }, /* None      */
	{ 60, GF_MISSILE,    }, /* HURT      */
	{  5, GF_POIS,       }, /* POISON    */
	{ 20, GF_DISENCHANT, }, /* UN_BONUS  */
	{ 15, GF_MISSILE,    }, /* UN_POWER  */ /* ToDo: Apply the correct effects */
	{  5, GF_MISSILE,    }, /* EAT_GOLD  */
	{  5, GF_MISSILE,    }, /* EAT_ITEM  */
	{  5, GF_MISSILE,    }, /* EAT_FOOD  */
	{  5, GF_MISSILE,    }, /* EAT_LITE  */
	{  0, GF_ACID,       }, /* ACID      */
	{ 10, GF_ELEC,       }, /* ELEC      */
	{ 10, GF_FIRE,       }, /* FIRE      */
	{ 10, GF_COLD,       }, /* COLD      */
	{  2, GF_MISSILE,    }, /* BLIND     */
	{ 10, GF_CONFUSION,  }, /* CONFUSE   */
	{ 10, GF_MISSILE,    }, /* TERRIFY   */
	{  2, GF_MISSILE,    }, /* PARALYZE  */
	{  0, GF_MISSILE,    }, /* LOSE_STR  */
	{  0, GF_MISSILE,    }, /* LOSE_INT  */
	{  0, GF_MISSILE,    }, /* LOSE_WIS  */
	{  0, GF_MISSILE,    }, /* LOSE_DEX  */
	{  0, GF_MISSILE,    }, /* LOSE_CON  */
	{  0, GF_MISSILE,    }, /* LOSE_CHR  */
	{  2, GF_MISSILE,    }, /* LOSE_ALL  */
	{ 60, GF_ROCKET,     }, /* SHATTER   */
	{  5, GF_MISSILE,    }, /* EXP_10    */
	{  5, GF_MISSILE,    }, /* EXP_20    */
	{  5, GF_MISSILE,    }, /* EXP_40    */
	{  5, GF_MISSILE,    }, /* EXP_80    */
	{  5, GF_POIS,       }, /* DISEASE   */
	{  5, GF_TIME,       }, /* TIME      */
	{  5, GF_MISSILE,    }, /* EXP_VAMP  */
};
