/***
*io.h - declarations for low-level file handling and I/O functions
*
*       Copyright (c) Microsoft Corporation. All rights reserved.
*
*Purpose:
*       This file contains the function declarations for the low-level
*       file handling and I/O functions.
*
*       [Public]
*
****/

#if     _MSC_VER > 1000
#pragma once
#endif

#ifndef _INC_IO
#define _INC_IO

#include <crtdefs.h>

#ifdef  _MSC_VER
/*
 * Currently, all MS C compilers for Win32 platforms default to 8 byte
 * alignment.
 */
#pragma pack(push,_CRT_PACKING)
#endif  /* _MSC_VER */

#ifndef _POSIX_

#ifdef  __cplusplus
extern "C" {
#endif

#ifndef _FSIZE_T_DEFINED
typedef unsigned long _fsize_t; /* Could be 64 bits for Win32 */
#define _FSIZE_T_DEFINED
#endif

#ifndef _FINDDATA_T_DEFINED

struct _finddata32_t {
        unsigned    attrib;
        __time32_t  time_create;    /* -1 for FAT file systems */
        __time32_t  time_access;    /* -1 for FAT file systems */
        __time32_t  time_write;
        _fsize_t    size;
        char        name[260];
};


#ifdef _USE_32BIT_TIME_T
#define _finddata_t     _finddata32_t
#define _finddatai64_t  _finddata32i64_t

#define _findfirst      _findfirst32
#define _findnext       _findnext32
#define _findfirsti64   _findfirst32i64
#define _findnexti64     _findnext32i64

#endif


#define _FINDDATA_T_DEFINED
#endif

#ifndef _WFINDDATA_T_DEFINED

struct _wfinddata32_t {
        unsigned    attrib;
        __time32_t  time_create;    /* -1 for FAT file systems */
        __time32_t  time_access;    /* -1 for FAT file systems */
        __time32_t  time_write;
        _fsize_t    size;
        wchar_t     name[260];
};


#ifdef _USE_32BIT_TIME_T
#define _wfinddata_t    _wfinddata32_t
#define _wfinddatai64_t _wfinddata32i64_t

#define _wfindfirst     _wfindfirst32
#define _wfindnext      _wfindnext32
#define _wfindfirsti64  _wfindfirst32i64
#define _wfindnexti64   _wfindnext32i64

#endif

#define _WFINDDATA_T_DEFINED
#endif

/* File attribute constants for _findfirst() */

#define _A_NORMAL       0x00    /* Normal file - No read/write restrictions */
#define _A_RDONLY       0x01    /* Read only file */
#define _A_HIDDEN       0x02    /* Hidden file */
#define _A_SYSTEM       0x04    /* System file */
#define _A_SUBDIR       0x10    /* Subdirectory */
#define _A_ARCH         0x20    /* Archive file */

/* function prototypes */

#ifndef _SIZE_T_DEFINED
#ifdef  _WIN64
typedef unsigned __int64    size_t;
#else
typedef _W64 unsigned int   size_t;
#endif
#define _SIZE_T_DEFINED
#endif

/* Non-ANSI names for compatibility */

#pragma warning(push)
#pragma warning(disable: 4141) /* Using deprecated twice */ 
int __cdecl open(const char *fn, int flag, ...);
int __cdecl read(int fd, void *bug, unsigned int count);
int __cdecl write(int fd, const void *buf, unsigned int count);
int __cdecl close(int fd);
long __cdecl lseek(int fd, long offset, int origin);

/* unused
int __cdecl access(const char * _Filename, int _AccessMode);
int __cdecl chmod(const char * _Filename, int _AccessMode);
int __cdecl chsize(int _FileHandle, long _Size);
int __cdecl creat(const char * _Filename, int _PermissionMode);
int __cdecl dup(int _FileHandle);
int __cdecl dup2(int _FileHandleSrc, int _FileHandleDst);
int __cdecl eof(int _FileHandle);
long __cdecl filelength(int _FileHandle);
int __cdecl isatty(int _FileHandle);
int __cdecl locking(int _FileHandle, int _LockMode, long _NumOfBytes);
long __cdecl lseek(int _FileHandle, long _Offset, int _Origin);
char* __cdecl mktemp(char * _TemplateName);
int __cdecl setmode(int _FileHandle, int _Mode);
int __cdecl sopen(const char * _Filename, int _OpenFlag, int _ShareFlag, ...);
long __cdecl tell(int _FileHandle);
int __cdecl umask(int _Mode);
*/
#pragma warning(pop)


#ifdef  __cplusplus
}
#endif

#endif  /* _POSIX_ */

#ifdef  _MSC_VER
#pragma pack(pop)
#endif  /* _MSC_VER */

#endif  /* _INC_IO */
