
#include "base.h"
#include "AngbandTerm-wm.h"

#include "MainWnd.h"


extern "C"{
	void hook_warn(const char* str);
	void hook_quit(const char* str);
}

#define PREF_WM_PORTRAIT  "pref-wm-p.prf"
#define PREF_WM_LANDSCAPE "pref-wm-l.prf"
#define PREF_WM _landscape?PREF_WM_LANDSCAPE:PREF_WM_PORTRAIT

#define BUF_SIZE 1024

const CWfcStr CMacroData::strNull( _T("") );

BOOL CMacroData::Load( LPCSTR username )
{
	if( !username ){ return FALSE; }

	_path  = acGetUserDir();
	_path += _T("\\");
	_path += username;
	_path += _T(".mcr");

	FILE* rf = _wfopen( _path.GetWStr(), L"rt" );
	if( !rf ){ return FALSE; }

	CWfcStr line( BUF_SIZE );

	for( int t = 0; t < MAX_MACRO; t++ )
	{
		if( !fgetws( line, BUF_SIZE, rf ) ){ break; }
		line.Trim();
		_macro[t] = line;
	}
	fclose( rf );

	return TRUE;
}

void CMacroData::Store()
{
	if( _path.Length() == 0 )
	{
		_path  = acGetUserDir();
		_path += _T("\\");
		_path += acGetSaveBase();
		_path += _T(".mcr");
	}

	FILE* wf = _wfopen( _path, L"wt" );
	if( !wf ){ return; }

	for( int t = 0; t < MAX_MACRO; t++ )
	{
		fputws( _macro[t].GetWStr(), wf );
		fputws( L"\n", wf );
	}
	fclose( wf );
}


CAngbandTermApp g_App;

CAngbandTermApp::CAngbandTermApp()
{
	_init = FALSE;
	_load = FALSE;

	_inputMode  = FALSE;
	_dirMode    = FALSE;

	_hMainWnd   = NULL;

	_uiHeight   = 0;
	_uiMargin   = 0;
}

BOOL CAngbandTermApp::InitInstance( HINSTANCE hInst )
{
	_hInst = hInst;

#ifdef WINCE
    SHInitExtraControls();
#endif

	_config.load();
	if( !_config.isLoaded() )
	{
		_config.setInt( CONF_COLS, 80, CONF_SECT_MT );
		_config.setInt( CONF_ROWS, 24, CONF_SECT_MT );
		_config.setInt( CONF_FSIZE, 8, CONF_SECT_MT );
		_config.setInt( CONF_FSIZE, 8, CONF_SECT_T1 );
		_config.setInt( CONF_FSIZE, 8, CONF_SECT_T2 );
		_config.setInt( CONF_FSIZE, 8, CONF_SECT_T3 );
		_config.setInt( CONF_FSIZE, 8, CONF_SECT_T4 );
		_config.setInt( CONF_FSIZE, 8, CONF_SECT_T5 );
		_config.setInt( CONF_FSIZE, 8, CONF_SECT_T6 );
		_config.setInt( CONF_FSIZE, 8, CONF_SECT_T7 );
		_config.setInt( CONF_KEY_DELAY   , 500 );
		_config.setInt( CONF_KEY_INTERVAL, 200 );
		_config.setInt( CONF_HEIGHT, 32, CONF_SECT_UI );
		_config.setInt( CONF_FSIZE,  10, CONF_SECT_UI );
		_config.store();
	}
	ApplyConfig();

	CMainWnd* mainWnd = new CMainWnd();
	_hMainWnd = mainWnd;

	if( !mainWnd->Create() )
	{
		return FALSE;
	}

	acSetSysHook( hook_warn, hook_quit );

	init_color();

	LPCTSTR libPath = _config.getStr( CONF_LIB_PATH );
	if( _tcslen( libPath ) > 0 )
	{
		acInitPath( libPath );
	}
	else
	{
		acInitPath( NULL );
	}

#ifdef WINCE
	/* Set the system suffix */
	acSetSysParam( "wm", "0" );
#else
	/* Set the system suffix */
	acSetSysParam( "w32", "0" );
#endif

	FlushMessage();

	/* Initialize */
	acInitAngband();

	mainWnd->SearchSaveFile( acGetSaveDir() );

	_init = TRUE;

	return TRUE;
}

void CAngbandTermApp::SetLandscape( BOOL ls )
{
#ifdef WINCE
	_landscape = ls;
	acProcessPrefFile( PREF_WM );
#endif
}

void CAngbandTermApp::ProcessMacro( int id )
{
	const CWfcStr& ms = GetMacro( id );
	const char* p = ms.GetStr();
	if( !*p ){ return; }
	if( *p == '#' )
	{
		p++;
	}
	else
	{
		acTermKeypress( ESCAPE_KEY );
		acTermKeypress( ESCAPE_KEY );
	}
	while( *p )
	{
		if( *p == '\\' )
		{
			p++;
			switch( *(p++) )
			{
			case '\\': acTermKeypress( '\\' );
			case 'e': acTermKeypress( ESCAPE_KEY );
			case 'r': acTermKeypress( ENTER_KEY );
			}
			continue;
		}
		acTermKeypress( *(p++) );
	}
}


void CAngbandTermApp::ApplyConfig(void)
{
	LPCTSTR face = _config.getStr( CONF_FNAME, CONF_SECT_UI );
	int  size  = _config.getInt( CONF_FSIZE, CONF_SECT_UI );
	BOOL ctype = _config.getInt( CONF_CTYPE, CONF_SECT_UI );
	BOOL bold  = _config.getInt( CONF_BOLD,  CONF_SECT_UI );
	int  lfp   = _config.getInt( CONF_LFP,   CONF_SECT_UI );

	if( size < FONT_SIZE_MIN ){ size = FONT_SIZE_MIN; }

	_font.Create( size, face, bold, ctype, FALSE, 0, lfp );

	int fh = _font.Height();
	_uiHeight = _config.getInt( CONF_HEIGHT, CONF_SECT_UI );
	if( _uiHeight < fh + 2 ){ _uiHeight = fh + 2; }
	_uiMargin = ( _uiHeight - fh ) / 2;
}

void CAngbandTermApp::CmdNewGame(void)
{
	if( _load ){ return; }

	_load = TRUE;
	FlushMessage();

	acPlayGame( NULL );
}

void CAngbandTermApp::CmdContinue()
{
	if( _load ){ return; }

	CWfcStr fname( _config.getStr( CONF_LASTFILE ) );
	CmdLoadGame( fname );
}

void CAngbandTermApp::CmdLoadGame( const CWfcStr& fname )
{
	if( _load ){ return; }

	CWfcStr path = acGetSaveDir();
	path += _T("\\");
	path += fname;

	DWORD attrib = GetFileAttributes( path );
	if ( (attrib == -1) || (attrib & FILE_ATTRIBUTE_DIRECTORY) )
	{
		MessageBox( NULL, path, _T("File not found"), MB_ICONEXCLAMATION );
		PostQuitMessage( 0 );
		return;
	}
	_macroData.Load( fname.GetStr() );

	_load = TRUE;
	FlushMessage();

	acPlayGame( path.GetStr() );
}

void CAngbandTermApp::Warn( LPCSTR mes )
{
	if( mes )
	{
		CWfcStr str( mes );
		MessageBox( *_hMainWnd, str, _T("Warning"), MB_ICONEXCLAMATION );
	}
}

void CAngbandTermApp::Quit( LPCSTR mes )
{
	if( mes )
	{
		CWfcStr str( mes );
		MessageBox( *_hMainWnd, str, _T("Fatal"), MB_ICONERROR );
	}

	CWfcStr savefile( acGetSaveBase() );
	if( savefile.Length() )
	{
		_config.setStr( CONF_LASTFILE, savefile );
		_config.store();
	}
	PostQuitMessage( 0 );
}


extern "C"{
	/*
	 * Display warning message (see "z-util.c")
	 */
	void hook_warn(cptr str)
	{
		g_App.Warn(str);
	}

	/*
	 * Display error message and quit (see "z-util.c")
	 */
	void hook_quit(cptr str)
	{
		g_App.Quit(str);
	}
}


#ifdef WINCE

int WINAPI WinMain(	HINSTANCE hInst, HINSTANCE hPrev, LPTSTR cmdLine, int cmdShow )
{
	g_App.InitInstance( hInst );

	MSG msg;
	while( GetMessage( &msg, NULL, 0, 0 ) )
	{
		TranslateMessage( &msg );
		DispatchMessage( &msg );
	}
	return 0;
}

#else

#include <locale.h>
int WINAPI _tWinMain( HINSTANCE hInst, HINSTANCE hPrev, LPTSTR cmdLine, int cmdShow )
{
	setlocale( LC_ALL, "jpn" );

	g_App.InitInstance( hInst );

	MSG msg;
	while( GetMessage( &msg, NULL, 0, 0 ) )
	{
		TranslateMessage( &msg );
		DispatchMessage( &msg );
	}
	return 0;
}

#endif
