// AngbandTerm-wm.h : hengband-wm AvP[ṼC wb_[ t@C
//
#pragma once

#include "resource.h"
#include "Config.h"

#define MAX_MACRO 12

class CMacroData
{
	static const CWfcStr strNull;
public:
	const CWfcStr& GetMacro( int id )
	{
		return ( id >= 0 && id < MAX_MACRO )?_macro[id]:strNull;
	}
	void SetMacro( int id, LPCTSTR macro )
	{
		if( id >= 0 && id < MAX_MACRO ){ _macro[id] = macro; }
	}

	BOOL Load( LPCSTR username );
	void Store();
private:
	CWfcStr _macro[MAX_MACRO];
	CWfcStr _path;
};

class CAngbandTermApp
{
public:
	CAngbandTermApp();

public:
	HINSTANCE GetAppInstance(){ return _hInst; }
	CConfig&  GetConfig(){ return _config; }
	CWfcFont& GetFont(){ return _font; }
	int       GetUIHeight(){ return _uiHeight; }
	int       GetUIMargin(){ return _uiMargin; }

	const CWfcStr& GetMacro( int id ){ return _macroData.GetMacro( id ); }
	void SetMacro( int id, LPCTSTR str ){ _macroData.SetMacro( id, str ); }
	void StoreMacro(){ _macroData.Store(); }
	void ProcessMacro( int id );

	void SetLandscape( BOOL ls );
	BOOL IsLandscape(){ return _landscape; }

	int GetFontWidth( LPCTSTR section )
	{
		return _config.getInt(CONF_FSIZE,section)+_config.getInt(CONF_CHP,section);
	}
	int GetFontHeight( LPCTSTR section )
	{
		return _config.getInt(CONF_FSIZE,section)*2+_config.getInt(CONF_LFP,section);
	}
	int GetTermWidth( LPCTSTR section )
	{
		return _config.getInt(CONF_COLS,section) * GetFontWidth(section) + MARGIN * 2;
	}
	int GetTermHeight( LPCTSTR section )
	{
		return _config.getInt(CONF_ROWS,section) * GetFontHeight(section) + MARGIN * 2;
	}

	BOOL InitInstance( HINSTANCE hInst );
	void ApplyConfig(void);

	void Warn( LPCSTR mes );
	void Quit( LPCSTR mes );

	void setInputMode( BOOL mode ){ _inputMode = mode; }
	BOOL isInputMode(){ return _inputMode; }

	void setDirMode( BOOL mode ){ _dirMode = mode; }
	BOOL isDirMode(){ return _dirMode; }

	BOOL isInit(){ return _init; }
	BOOL isLoaded(){ return _load; }

	void CmdNewGame(void);
	void CmdContinue(void);
	void CmdLoadGame( const CWfcStr& fname );

private:
	HINSTANCE _hInst;
	CWfcFont  _font;
	int       _uiHeight, _uiMargin;

	CWfcWnd*  _hMainWnd;

	CConfig    _config;
	CMacroData _macroData;

	BOOL _init, _load;

	BOOL _inputMode; // ͒
	BOOL _dirMode;   // ͎woĂ邩

	BOOL _landscape;
};

extern CAngbandTermApp g_App;
