#include "base.h"
#include "Config.h"

#include <stdlib.h>

#define BUF_SIZE 1024

LPCTSTR CConfig::NULL_STR = _T("");

CConfig::CConfig(LPCTSTR filename) : _filename( MAX_PATH )
{
	_isLoaded = FALSE;

	if( filename ){
		_filename = filename;
	}
	else
	{
		GetModuleFileName( NULL, _filename, MAX_PATH );

		_filename.TruncateTail( _T('.') );
		_filename += _T(".ini");
	}
}

CConfig::~CConfig(void)
{
}

BOOL CConfig::load(void)
{
//	FILE* rf = _wfopen( _filename, L"rt, ccs=UTF-8" );
	FILE* rf = _wfopen( _filename, L"rt" );
	if( !rf ){ return FALSE; }

	CWfcStr line( BUF_SIZE );
	CWfcStr curSect( _T("") );

	while( fgetws( line, BUF_SIZE, rf ) )
	{
		if( line[0] == _T('[') )
		{
			int pos = line.FindChar( _T(']'), 1 );
			curSect = line.Substr( 1, pos - 1 );
			continue;
		}
		else
		{
			line.Trim();
			int pos = line.FindChar( _T('=') );
			if( pos >= 0 && pos < (int)line.Length() - 1 )
			{
				CWfcStr key( curSect );
				key += _T(":");
				key += line.Left( pos );
				CWfcStr data = line.Substr(pos+1);
				_config.insert( std::pair<CWfcStr,CWfcStr>(key,data) );
			}
		}
	}
	fclose( rf );
	_isLoaded = TRUE;
	return TRUE;
}

void CConfig::store()
{
//	FILE* wf = _wfopen( _filename, L"wt, ccs=UTF-8" );
	FILE* wf = _wfopen( _filename, L"wt" );
	if( !wf ){ return; }

	std::map<CWfcStr,CWfcStr>::iterator it;

	for( it = _config.begin();it != _config.end(); it++ )
	{
		CWfcStr key = it->first;
		int pos = key.FindChar( _T(':') );
		if( pos != 0 ){ continue; }

		CWfcStr str = key.Substr( pos+1 );
		str += L"=";
		str += it->second;
		str += L"\n";
		fputws( str, wf );
	}

	CWfcStr curSect;

	for( it = _config.begin();it != _config.end(); it++ )
	{
		CWfcStr key = it->first;
		int pos = key.FindChar( _T(':') );
		if( pos <= 0 ){ continue; }

		if( !( curSect == key.Left(pos) ) )
		{
			curSect = key.Left(pos);
			CWfcStr str( _T("[") );
			str += curSect;
			str += _T("]\n");
			fputws( str, wf );
		}

		CWfcStr str = key.Substr(pos+1);
		str += L"=";
		str += it->second;
		str += L"\n";
		fputws( str, wf );
	}
	fclose( wf );
	_isLoaded = TRUE;
}

LPCTSTR CConfig::getStr(LPCTSTR key, LPCTSTR section)
{
	CWfcStr sectKey;
	if( section ){ sectKey += section; }
	sectKey += _T(":");
	sectKey += key;

	std::map<CWfcStr,CWfcStr>::iterator it;

	it = _config.find( sectKey );

	if( it != _config.end() ){
		return it->second;
	}
	return NULL_STR;
}

int CConfig::getInt(LPCTSTR key, LPCTSTR section)
{
	CWfcStr sectKey;
	if( section ){ sectKey += section; }
	sectKey += _T(":");
	sectKey += key;

	std::map<CWfcStr,CWfcStr>::iterator it;

	it = _config.find( sectKey );

	if( it != _config.end() ){
		return _ttoi(it->second);
	}
	return 0;
}

void CConfig::setStr(LPCTSTR key, LPCTSTR data, LPCTSTR section)
{
	CWfcStr sectKey;
	if( section ){ sectKey += section; }
	sectKey += _T(":");
	sectKey += key;

	_config.erase( sectKey );
	_config.insert( std::pair<CWfcStr,CWfcStr>( sectKey, data) );
}

void CConfig::setInt(LPCTSTR key, int data, LPCTSTR section)
{
	CWfcStr sectKey;
	if( section ){ sectKey += section; }
	sectKey += _T(":");
	sectKey += key;

	TCHAR str[BUF_SIZE];
	_itot( data, str, 10 );

	_config.erase( sectKey );
	_config.insert( std::pair<CWfcStr,CWfcStr>( sectKey, str) );
}
