#include "base.h"
#include "Dlg.h"

#include "AngbandTerm-wm.h"

#define BUF_SIZE 256

#define TERM_COL_MIN 80
#define TERM_COL_MAX 100
#define TERM_COL_STP 4
#define TERM_COL_DEF 80

#define TERM_ROW_MIN 24
#define TERM_ROW_MAX 30
#define TERM_ROW_STP 1
#define TERM_ROW_DEF 24

#define FONT_SIZE_MIN 4
#define FONT_SIZE_MAX 11
#define FONT_SIZE_DEFAULT 8

#ifdef JP
 #define VER_PDNAME _T("\\StringFileInfo\\041104b0\\ProductName")
 #define VER_PDVER  _T("\\StringFileInfo\\041104b0\\ProductVersion")
#else
 #define VER_PDNAME _T("\\StringFileInfo\\000004b0\\ProductName")
 #define VER_PDVER  _T("\\StringFileInfo\\000004b0\\ProductVersion")
#endif

#define DEC 10

#define TERM_NONE L"(none)"

const LPCTSTR COLOR_NAME[] ={
	_T("Black"),
	_T("DarkGray"),
	_T("Gray"),
	_T("LightGray"),
	_T("White"),
	_T("Red"),
	_T("Green"),
	_T("Blue"),
	_T("Yellow"),
	_T("Aqua"),
	_T("Purple"),
	NULL
};
const COLORREF COLOR_REF[] =
{
	RGB(  0,  0,  0), // Black
	RGB( 64, 64, 64), // DarkGray
	RGB(128,128,128), // Gray
	RGB(192,192,192), // LightGray
	RGB(255,255,255), // White
	RGB(255,  0,  0), // Red
	RGB(  0,255,  0), // Green
	RGB(  0,  0,255), // Blue
	RGB(255,255,  0), // Yellow
	RGB(  0,255,255), // Aqua
	RGB(255,  0,255)  // Purple
};


// CVersionDlg

BOOL CVersionDlg::onInitDialog()
{
	CWfcDialog::onInitDialog();

	CWfcStr str;

	LPTSTR vstr = NULL;
	UINT  vsz = 0;
	UINT tsz = 0;
	DWORD sz = 0;
	void* pd = NULL;

	CWfcStr dllpath( acGetDLLFilepath() );
	sz = GetFileVersionInfoSize( dllpath, 0 );
	pd = new TCHAR[sz];
	GetFileVersionInfo( dllpath, NULL, sz, pd );

	VerQueryValue( pd, VER_PDNAME, (void**)&vstr, &vsz );
	str = vstr;
	SetItemText( IDC_CORE, str );

	VerQueryValue( pd, VER_PDVER, (void**)&vstr, &vsz );
	GetItemText( IDC_COREVER, str );
	str += vstr;
	SetItemText( IDC_COREVER, str );
	delete pd;


	CWfcStr exepath( MAX_PATH );
	GetModuleFileName( NULL, exepath, MAX_PATH);

	sz = GetFileVersionInfoSize( exepath, 0 );
	pd = new TCHAR[sz];
	GetFileVersionInfo( exepath, NULL, sz, pd );

	VerQueryValue( pd, VER_PDVER, (void**)&vstr, &vsz );
	GetItemText( IDC_TERMVER, str );
	str += vstr;
	SetItemText( IDC_TERMVER, str );
	delete pd;

	return TRUE;
}

// COptionDlg

COptionDlg::COptionDlg() : CWfcDialog()
{
}

COptionDlg::~COptionDlg()
{
}


BOOL COptionDlg::onInitDialog()
{
	CWfcDialog::onInitDialog();

	TCHAR str[64]; // lϊp

	CConfig& config = g_App.GetConfig();

	setButtonText( IDC_FONT_MT, CONF_SECT_MT );
	setButtonText( IDC_FONT_T1, CONF_SECT_T1 );
	setButtonText( IDC_FONT_T2, CONF_SECT_T2 );
	setButtonText( IDC_FONT_T3, CONF_SECT_T3 );
	setButtonText( IDC_FONT_T4, CONF_SECT_T4 );

	// MainTerminalCols
	_mtCol = config.getInt( CONF_COLS, CONF_SECT_MT );
	if( !_mtCol ){ _mtCol = TERM_COL_DEF; }
	for( int t = TERM_COL_MIN; t <= TERM_COL_MAX; t += TERM_COL_STP )
	{
		_itot_s( t, str, 64, DEC );
		int idx = CB_AddStr( IDC_COL, str );
		if( _mtCol == t )
		{
			CB_SetCurSel( IDC_COL, idx );
		}
	}
	if( CB_GetCurSel( IDC_COL ) == CB_ERR )
	{
		SetItemInt( IDC_COL, _mtCol );
	}

	// MainTerminalRows
	_mtRow = config.getInt( CONF_ROWS, CONF_SECT_MT );
	if( !_mtRow ){ _mtRow = TERM_ROW_DEF; }
	for( int t = TERM_ROW_MIN; t <= TERM_ROW_MAX; t += TERM_ROW_STP )
	{
		_itow_s( t, str, 64, DEC );
		int idx = CB_AddStr( IDC_ROW, str );
		if( _mtRow == t )
		{
			CB_SetCurSel( IDC_ROW, idx );
		}
	}
	if( CB_GetCurSel( IDC_ROW ) == CB_ERR )
	{
		SetItemInt( IDC_ROW, _mtRow );
	}

	// SubTerminalLayout
	CB_AddStr( IDC_LAYOUT_B, _T("Non-split") );
	CB_AddStr( IDC_LAYOUT_B, _T("by 2:1") );
	CB_AddStr( IDC_LAYOUT_B, _T("by even") );
	CB_AddStr( IDC_LAYOUT_B, _T("by 1:2") );
	CB_SetCurSel( IDC_LAYOUT_B, config.getInt( CONF_BT_LAYOUT ) );

	CB_AddStr( IDC_LAYOUT_R, _T("Non-split") );
	CB_AddStr( IDC_LAYOUT_R, _T("by 2:1") );
	CB_AddStr( IDC_LAYOUT_R, _T("by even") );
	CB_AddStr( IDC_LAYOUT_R, _T("by 1:2") );
	CB_SetCurSel( IDC_LAYOUT_R, config.getInt( CONF_RT_LAYOUT ) );

	// BorderColor
	COLORREF cr = (COLORREF)( config.getInt( CONF_BORDER ) );
	for( int c = 0; COLOR_NAME[c]; c++ )
	{
		int idx = CB_AddStr( IDC_COLOR, COLOR_NAME[c] );
		if( COLOR_REF[c] == cr )
		{
			CB_SetCurSel( IDC_COLOR, idx );
		}
	}
	if( CB_GetCurSel( IDC_ROW ) == CB_ERR )
	{
		_stprintf ( str, _T("%02x%02x%02x"), GetRValue(cr), GetGValue(cr), GetBValue(cr) );
		SetItemText( IDC_ROW, str );
	}

	onLayoutChange();

	return TRUE;
}

void COptionDlg::onOK()
{
	CConfig& config = g_App.GetConfig();

	// MainTerm
	config.setInt( CONF_COLS, _mtCol, CONF_SECT_MT );
	config.setInt( CONF_ROWS, _mtRow, CONF_SECT_MT );

	// SubTerminalLayout
	config.setInt( CONF_BT_LAYOUT, CB_GetCurSel( IDC_LAYOUT_B ) );
	config.setInt( CONF_RT_LAYOUT, CB_GetCurSel( IDC_LAYOUT_R ) );

	// BorderColor
	if( CB_GetCurSel( IDC_COLOR ) == CB_ERR )
	{
		CWfcStr str;
		int r, g, b;
		GetItemText( IDC_COLOR, str );
		swscanf( str, L"%02x%02x%02x", &r, &g, &b );
		config.setInt( CONF_BORDER, (int)RGB(r,g,b) );
	}
	else
	{
		config.setInt( CONF_BORDER, (int)COLOR_REF[ CB_GetCurSel( IDC_COLOR ) ] );
	}

	config.store();

	CWfcDialog::onOK();
}


void COptionDlg::onCommand( DWORD notify, HWND hitem )
{
	if( HIWORD(notify) == BN_CLICKED )
	{
		if( LOWORD(notify) == IDC_FONT_MT )
		{
			openFontDlg( CONF_SECT_MT );
			setButtonText( IDC_FONT_MT, CONF_SECT_MT );
			onSizeChange();
		}
		else if( LOWORD(notify) == IDC_FONT_T1 )
		{
			openFontDlg( CONF_SECT_T1 );
			setButtonText( IDC_FONT_T1, CONF_SECT_T1 );
		}
		else if( LOWORD(notify) == IDC_FONT_T2 )
		{
			openFontDlg( CONF_SECT_T2 );
			setButtonText( IDC_FONT_T2, CONF_SECT_T2 );
		}
		else if( LOWORD(notify) == IDC_FONT_T3 )
		{
			openFontDlg( CONF_SECT_T3 );
			setButtonText( IDC_FONT_T3, CONF_SECT_T3 );
		}
		else if( LOWORD(notify) == IDC_FONT_T4 )
		{
			openFontDlg( CONF_SECT_T4 );
			setButtonText( IDC_FONT_T4, CONF_SECT_T4 );
		}
		return;
	}

	switch( notify )
	{
	case NOTIFY( IDC_COL, CBN_EDITCHANGE ):
	case NOTIFY( IDC_ROW, CBN_EDITCHANGE ):
	case NOTIFY( IDC_COL, CBN_SELCHANGE ):
	case NOTIFY( IDC_ROW, CBN_SELCHANGE ):
		onSizeChange();
		return;
	case NOTIFY( IDC_LAYOUT_B, CBN_SELCHANGE ):
	case NOTIFY( IDC_LAYOUT_R, CBN_SELCHANGE ):
		onLayoutChange();
		return;
	}
}

void COptionDlg::openFontDlg( LPCTSTR section )
{
	CFontDlg fd;
	fd._section = section;
	fd.DoModal( _hWnd );
}

void COptionDlg::onSizeChange()
{
	_mtCol = CB_GetInt( IDC_COL );
	_mtRow = CB_GetInt( IDC_ROW );

	int mw = _mtCol * g_App.GetFontWidth(CONF_SECT_MT) + MARGIN*2;
	int mh = _mtRow * g_App.GetFontHeight(CONF_SECT_MT) * 2+ MARGIN*2;

	setLabelFormat( IDC_STATIC_X, _T("x:%d"), mw );
	setLabelFormat( IDC_STATIC_Y, _T("y:%d"), mh );
}

void COptionDlg::onLayoutChange()
{
	int sel = CB_GetCurSel( IDC_LAYOUT_B );
	if( sel == 0 )
	{
		EnableItem( IDC_FONT_T2, FALSE );
	}
	else
	{
		EnableItem( IDC_FONT_T2, TRUE );
	}

	sel = CB_GetCurSel( IDC_LAYOUT_R );
	if( sel == 0 )
	{
		EnableItem( IDC_FONT_T4, FALSE );
	}
	else
	{
		EnableItem( IDC_FONT_T4, TRUE );
	}
}

void COptionDlg::setButtonText( int id, LPCTSTR section )
{
	CConfig& config = g_App.GetConfig();

	LPCTSTR face = config.getStr( CONF_FNAME, section );
	int size = config.getInt( CONF_FSIZE, section );
	int chPitch = config.getInt( CONF_CHP, section );
	int lfPitch = config.getInt( CONF_LFP, section );
	BOOL ctype =  config.getInt( CONF_CTYPE, section );
	BOOL bold  =  config.getInt( CONF_BOLD,  section );

	CWfcStr str( 64 );

	_stprintf( str, _T("%d"), size*2 );

	if( chPitch || lfPitch )
	{
		str += _T("+");
	}
	str += _T(":");

	if( face[0] )
	{
		str += face;
	}
	else
	{
		str += _T("(default)");
	}
	if( ctype )
	{
		str += _T("*");
	}

	SetItemText( id, str );
}

void COptionDlg::setLabelFormat( int id, LPCTSTR format, int num )
{
	TCHAR str[BUF_SIZE];
	_stprintf( str, format, num );
	SetItemText( id, str );
}

void COptionDlg::setLabelFormat( int id, LPCTSTR format, int n1, int n2 )
{
	TCHAR str[BUF_SIZE];
	_stprintf( str, format, n1, n2 );
	SetItemText( id, str );
}


// COptUIDlg

COptUIDlg::COptUIDlg() : CWfcDialog()
{

}

COptUIDlg::~COptUIDlg()
{

}


BOOL COptUIDlg::onInitDialog()
{
	CWfcDialog::onInitDialog();

	CConfig& config = g_App.GetConfig();

	SetItemInt( IDC_DELAY,    config.getInt( CONF_KEY_DELAY ) );
	SetItemInt( IDC_INTERVAL, config.getInt( CONF_KEY_INTERVAL ) );

	SetButtonState( IDC_SHARP, config.getInt( CONF_USE_MACRO ) );

	SetItemInt( IDC_HEIGHT, config.getInt( CONF_HEIGHT, CONF_SECT_UI ) );
	setButtonText( IDC_FONT_UI, CONF_SECT_UI );

	CB_AddStr( IDC_CLOCK, _T("(not use)") );
	CB_AddStr( IDC_CLOCK, _T("Auto") );
	CB_AddStr( IDC_CLOCK, _T("Right-top") );
	CB_AddStr( IDC_CLOCK, _T("Left-bottom") );

	CB_SetCurSel( IDC_CLOCK, config.getInt( CONF_SHOW_CLOCK ) );
	SetItemInt( IDC_CWIDTH,  config.getInt( CONF_CLOCK_WIDTH ) );

	return TRUE;
}

void COptUIDlg::onOK()
{
	CConfig& config = g_App.GetConfig();

	config.setInt( CONF_KEY_DELAY,   GetItemInt( IDC_DELAY ) );
	config.setInt( CONF_KEY_INTERVAL,GetItemInt( IDC_INTERVAL ) );
	config.setInt( CONF_USE_MACRO,   GetButtonState( IDC_SHARP ) );
	config.setInt( CONF_HEIGHT,      GetItemInt( IDC_HEIGHT ), CONF_SECT_UI );
	config.setInt( CONF_SHOW_CLOCK,  CB_GetCurSel( IDC_CLOCK ) );
	config.setInt( CONF_CLOCK_WIDTH, GetItemInt( IDC_CWIDTH ) );

	config.store();

	CWfcDialog::onOK();
}


void COptUIDlg::onCommand( DWORD notify, HWND hitem )
{
	if( HIWORD(notify) == BN_CLICKED )
	{
		if( LOWORD(notify) == IDC_FONT_UI )
		{
			openFontDlg( CONF_SECT_UI );
			setButtonText( IDC_FONT_UI, CONF_SECT_UI );
		}
		return;
	}
}

void COptUIDlg::openFontDlg( LPCTSTR section )
{
	CFontDlg fd;
	fd._section = section;
	fd._fixedPitch = false;
	fd.DoModal( _hWnd );
}

void COptUIDlg::setButtonText( int id, LPCTSTR section )
{
	CConfig& config = g_App.GetConfig();

	LPCTSTR face = config.getStr( CONF_FNAME, section );
	int size = config.getInt( CONF_FSIZE, section );
	int chPitch = config.getInt( CONF_CHP, section );
	int lfPitch = config.getInt( CONF_LFP, section );
	BOOL ctype =  config.getInt( CONF_CTYPE, section );
	BOOL bold  =  config.getInt( CONF_BOLD,  section );

	CWfcStr str( 64 );

	_stprintf( str, _T("%d"), size*2 );

	if( chPitch || lfPitch )
	{
		str += _T("+");
	}
	str += _T(":");

	if( face[0] )
	{
		str += face;
	}
	else
	{
		str += _T("(default)");
	}
	if( ctype )
	{
		str += _T("*");
	}

	SetItemText( id, str );
}


int CALLBACK CFontDlg::EnumFontProc
	(const LOGFONT* lf, const TEXTMETRIC* tm, DWORD type, LPARAM lParam)
{
	CFontDlg* cf = (CFontDlg*)lParam;
	if( cf )
	{
		if( lf->lfFaceName[0] == _T('@') ){ return 1; }
#ifdef JP
		if( lf->lfCharSet != SHIFTJIS_CHARSET ){ return 1; }
#endif

		CWfcStr face;
		if( !(lf->lfPitchAndFamily & FIXED_PITCH) )
		{
			face = _T("*");
		}
		face += lf->lfFaceName;

		int idx = cf->LB_AddStr( IDC_FONTLIST, face );
		if( cf->_fontFace == lf->lfFaceName )
		{
			cf->LB_SetCurSel( IDC_FONTLIST, idx );
		}

	}
	return 1;
}


CFontDlg::CFontDlg() : CWfcDialog(), _section( 1 ), _fontFace( 1 ) 
{
	_fixedPitch = TRUE;

	_fontSize = FONT_SIZE_DEFAULT;
	_chPitch = 0;
	_lfPitch = 0;
	_ctype = FALSE;
	_bold  = FALSE;
}

CFontDlg::~CFontDlg()
{

}


BOOL CFontDlg::onInitDialog()
{
	CWfcDialog::onInitDialog();

	CConfig& config = g_App.GetConfig();

	if( !_fixedPitch )
	{
		EnableWindow( GetItem( IDC_CHP ), FALSE );
	}

	_fontFace = config.getStr( CONF_FNAME, _section );
	_fontSize = config.getInt( CONF_FSIZE, _section );
	_chPitch = config.getInt( CONF_CHP, _section );
	_lfPitch = config.getInt( CONF_LFP, _section );

	_ctype = config.getInt( CONF_CTYPE, _section );
	_bold  = config.getInt( CONF_BOLD,  _section );

	_font.Create( _fontSize, _fontFace, _bold, _ctype, _fixedPitch, _chPitch, _lfPitch );

	SetItemInt( IDC_CHP, _chPitch );
	SetItemInt( IDC_LFP, _lfPitch );

	SetButtonState( IDC_CTYPE, _ctype?BST_CHECKED:BST_UNCHECKED );
	SetButtonState( IDC_BOLD, _bold?BST_CHECKED:BST_UNCHECKED );

	LB_SetCurSel( IDC_FONTLIST, LB_AddStr( IDC_FONTLIST, _T("(default)") ) );
	
	for( int s = FONT_SIZE_MIN; s <= FONT_SIZE_MAX; s ++ ){
		TCHAR str[16];
		_stprintf( str, _T("%d"), s*2 );
		int idx = LB_AddStr( IDC_SIZELIST, str );
		if( _fontSize == s )
		{
			LB_SetCurSel( IDC_SIZELIST, idx );
		}
	}


	HDC dc = ::GetDC( NULL );
	EnumFontFamilies( dc, NULL, EnumFontProc, (LPARAM)this );
	::ReleaseDC( NULL, dc );

#ifdef WINCE
	SendMessage( GetItem(IDC_SAMPLE), WM_SETREDRAW, FALSE, 0 );
#endif

	UpdateWindow();

	return TRUE;
}

void CFontDlg::onOK()
{
	CConfig& config = g_App.GetConfig();

	config.setStr( CONF_FNAME, _fontFace, _section );
	config.setInt( CONF_FSIZE, _fontSize, _section );
	config.setInt( CONF_CHP, _chPitch, _section );
	config.setInt( CONF_LFP, _lfPitch, _section );
	config.setInt( CONF_CTYPE, _ctype, _section );
	config.setInt( CONF_BOLD ,  _bold, _section );

	CWfcDialog::onOK();
}

void CFontDlg::onCommand( DWORD notify, HWND hitem )
{
	switch( notify )
	{
	case NOTIFY(IDC_CTYPE,BN_CLICKED):
	case NOTIFY(IDC_BOLD,BN_CLICKED):
	case NOTIFY(IDC_FONTLIST,LBN_SELCHANGE):
	case NOTIFY(IDC_SIZELIST,LBN_SELCHANGE):
	case NOTIFY(IDC_CHP,EN_CHANGE):
	case NOTIFY(IDC_LFP,EN_CHANGE):
		onSelchange();
	}
}

void CFontDlg::onSelchange()
{
	if( LB_GetCurSel(IDC_FONTLIST) >= 0 && LB_GetCurSel(IDC_SIZELIST) >= 0 ){
		_fontSize = LB_GetInt(IDC_SIZELIST) / 2;

		_chPitch = GetItemInt( IDC_CHP );
		_lfPitch = GetItemInt( IDC_LFP );
		_ctype = GetButtonState( IDC_CTYPE );
		_bold = GetButtonState( IDC_BOLD );

		if( LB_GetCurSel(IDC_FONTLIST) > 0 ){
			CWfcStr str(64);
			LB_GetText( IDC_FONTLIST, str );
			if( str[0] == '*' )
			{
				_fontFace = str.Substr( 1 );
			}
			else
			{
				_fontFace = str;
			}
		}
		else 
		{
			_fontFace.Truncate( 0 );
		}

		_font.Create( _fontSize, _fontFace, _bold, _ctype, _fixedPitch, _chPitch, _lfPitch );

		UpdateWindow();
	}
}

void CFontDlg::onDrawItem( DRAWITEMSTRUCT* di )
{
	if( di->CtlID != IDC_SAMPLE ){ return; }

	FillRect( di->hDC, &di->rcItem, (HBRUSH)GetStockObject( BLACK_BRUSH ) );
	SetBkColor( di->hDC, RGB( 0, 0, 0 ) );
	SetTextColor( di->hDC, RGB( 255, 255, 255 ) );

	CWfcStr s1( _T("0123456789") );
	CWfcStr s2( _T("Angband") );
	_font.Draw( di->hDC, 1,                  1, s1, ETO_CLIPPED, &di->rcItem );
	_font.Draw( di->hDC, 1, _font.Height()*1+1, s2, ETO_CLIPPED, &di->rcItem );
#ifdef JP
	CWfcStr s3( _T("Ëؓ{") );
	_font.Draw( di->hDC, 1, _font.Height()*2+1, s3, ETO_CLIPPED, &di->rcItem );
#endif

}

void CFontDlg::onPaint()
{
#ifdef WINCE
	HWND swnd = GetItem( IDC_SAMPLE );
	HDC sdc = GetDC( swnd );
	RECT rc;
	GetClientRect( swnd, &rc );
	FillRect( sdc, &rc, (HBRUSH)GetStockObject( BLACK_BRUSH ) );
	SetBkColor( sdc, RGB( 0, 0, 0 ) );
	SetTextColor( sdc, RGB( 255, 255, 255 ) );

	CWfcStr s1( _T("0123456789") );
	CWfcStr s2( _T("Angband") );
	_font.Draw( sdc, 1,                  1, s1 );
	_font.Draw( sdc, 1, _font.Height()*1+1, s2 );
#ifdef JP
	CWfcStr s3( _T("Ëؓ{") );
	_font.Draw( sdc, 1, _font.Height()*2+1, s3 );
#endif
	ReleaseDC( swnd, sdc );
#endif
}


// CMacroDlg

CMacroDlg::CMacroDlg() : CWfcDialog()
{

}

CMacroDlg::~CMacroDlg()
{

}


BOOL CMacroDlg::onInitDialog(void)
{
	CWfcDialog::onInitDialog();

	load( IDC_MACRO1, 0 );
	load( IDC_MACRO2, 1 );
	load( IDC_MACRO3, 2 );
	load( IDC_MACRO4, 3 );
	load( IDC_MACRO5, 4 );
	load( IDC_MACRO6, 5 );
	load( IDC_MACRO7, 6 );
	load( IDC_MACRO8, 7 );
	load( IDC_MACRO9, 8 );
	load( IDC_MACRO10, 9 );
	load( IDC_MACRO11, 10 );
	load( IDC_MACRO12, 11 );

	return TRUE;
}

void CMacroDlg::onOK(void)
{
	store( IDC_MACRO1, 0 );
	store( IDC_MACRO2, 1 );
	store( IDC_MACRO3, 2 );
	store( IDC_MACRO4, 3 );
	store( IDC_MACRO5, 4 );
	store( IDC_MACRO6, 5 );
	store( IDC_MACRO7, 6 );
	store( IDC_MACRO8, 7 );
	store( IDC_MACRO9, 8 );
	store( IDC_MACRO10, 9 );
	store( IDC_MACRO11, 10 );
	store( IDC_MACRO12, 11 );

	g_App.StoreMacro();

	CWfcDialog::onOK();
}

void CMacroDlg::load( UINT itemID, int mid )
{
	SetItemText( itemID, g_App.GetMacro( mid ) );
}

void CMacroDlg::store( UINT itemID, int mid )
{
	CWfcStr str;
	GetItemText( itemID, str );
	g_App.SetMacro( mid, str );
}

