#pragma once

#include "wfc.h"
#include "resource.h"


class CVersionDlg : public CWfcDialog
{
public:
	CVersionDlg() : CWfcDialog() {}

	int DoModal( HWND owner = NULL )
	{
		return CWfcDialog::DoModal( IDD_VERSION, owner );
	}
protected: // Override
	virtual BOOL onInitDialog();
};


class COptionDlg : public CWfcDialog
{
public:
	COptionDlg();
	~COptionDlg();

	int DoModal( HWND owner = NULL )
	{
		return CWfcDialog::DoModal( IDD_OPTION, owner );
	}

protected: // Override
	BOOL onInitDialog();
	void onOK();

	void onCommand( DWORD notify, HWND hitem );
private:
	int _mtCol, _mtRow;

	void openFontDlg( LPCTSTR section );

	void setButtonText( int id, LPCTSTR section );
	void setLabelFormat( int id, LPCTSTR format, int num );
	void setLabelFormat( int id, LPCTSTR format, int n1, int n2 );

	void onSizeChange();
	void onLayoutChange();
};

class COptUIDlg : public CWfcDialog
{
public:
	COptUIDlg();
	virtual ~COptUIDlg();

	int DoModal( HWND owner = NULL )
	{
		return CWfcDialog::DoModal( IDD_OPTUI, owner );
	}
protected: // Override
	BOOL onInitDialog();
	void onOK();

	void onCommand( DWORD notify, HWND hitem );
private:
	void openFontDlg( LPCTSTR section );
	void setButtonText( int id, LPCTSTR section );
};


class CFontDlg : public CWfcDialog
{	
	static int CALLBACK EnumFontProc
			(const LOGFONT*, const TEXTMETRIC*, DWORD, LPARAM );
public:
	CFontDlg();
	~CFontDlg();

	int DoModal( HWND owner = NULL )
	{
		return CWfcDialog::DoModal( IDD_FONT, owner );
	}
protected: // Override
	BOOL onInitDialog();
	void onOK();
	void onCommand( DWORD notify, HWND hitem );
	void onPaint();
	void onDrawItem( DRAWITEMSTRUCT* di );
public:
	CWfcStr _section;
	BOOL    _fixedPitch;
private:
	void onSelchange();
	CWfcStr _fontFace;
	int     _fontSize, _chPitch, _lfPitch;
	BOOL    _ctype, _bold;
	CWfcFont _font;
};

class CMacroDlg : public CWfcDialog
{
public:
	CMacroDlg();
	~CMacroDlg();

	int DoModal( HWND owner = NULL )
	{
		return CWfcDialog::DoModal( IDD_MACRO, owner );
	}

protected: // Override
	BOOL onInitDialog(void);
	void onOK(void);

private:
	void load( UINT itemID, int mid );
	void store( UINT itemID, int mid );
};
