#include "base.h"
#include "MainWnd.h"

#include "AngbandTerm-wm.h"

#include "Dlg.h"

#define MIN_TERM_SIZE 16
#define ROUNDUP(x,y) (((x)+(y)-1)/(y)*(y))

char hexsym[17] = "0123456789ABCDEF";

#ifdef JP
 #define VER_PDNAME _T("\\StringFileInfo\\041104b0\\ProductName")
#else
 #define VER_PDNAME _T("\\StringFileInfo\\000004b0\\ProductName")
#endif

#define WNDCLS_NAME _T("AngbandTermWndClass")

// CLineList

CLineList::CLineList( int ox, int oy, int tx, int ty )
{
	_ox = ox;
	_oy = oy;
	_tx = tx;
	_ty = ty;
	_next = NULL;
}

CLineList::~CLineList()
{
	SAFE_DELETE( _next );
}

void CLineList::Add( CLineList* line )
{
	if( _next ){ _next->Add( line ); }
	else{ _next = line; }
}

void CLineList::Draw( HDC dc )
{
	MoveToEx( dc, _ox, _oy, NULL );
	LineTo( dc, _tx, _ty );

	if( _next ){ _next->Draw( dc ); }
}




// CMainWnd

CMainWnd::CMainWnd() : CWfcWnd()
{
	_hWndMenu = NULL;
	_child    = NULL;

	_hMenu    = NULL;
	_hMenuOpt = NULL;

	_hideMenu   = false;
	_hideTask   = false;
	_menuHeight = 0;

	_landscape = FALSE;

	_hBorderPen = NULL;   // {[_[`p̃y

	_lineList = NULL;
}

CMainWnd::~CMainWnd()
{
	SAFE_DELETE( _child );
}

ATOM CMainWnd::getClassAtom(void)
{
	WNDCLASS wc = {0};
	wc.style         = CS_HREDRAW | CS_VREDRAW;
	wc.lpfnWndProc   = CWfcWnd::WfcWndProc;
	wc.hInstance     = _hInst;
	wc.hbrBackground = _hBkBrush;
	wc.lpszClassName = WNDCLS_NAME;
	wc.hCursor       = LoadCursor( NULL, IDC_ARROW );

#ifndef WINCE
	wc.hIcon         = LoadIcon( _hInst, MAKEINTRESOURCE(IDI_ICON) );
	wc.lpszMenuName  = MAKEINTRESOURCE( IDR_MENU );
#endif

	return RegisterClass(&wc);
}

BOOL CMainWnd::Create(void)
{
	CWfcStr title;

	LPTSTR vstr = NULL;
	UINT  vsz = 0;
	DWORD* pt = NULL;
	UINT tsz = 0;
	DWORD sz = 0;
	void* pd = NULL;

	CWfcStr dllpath( acGetDLLFilepath() );
	sz = GetFileVersionInfoSize( dllpath, 0 );
	pd = new TCHAR[sz];
	GetFileVersionInfo( dllpath, NULL, sz, pd );
	VerQueryValue( pd, VER_PDNAME, (void**)&vstr, &vsz );
	title = vstr;
	delete pd;

    // dNh~
	HWND hw = FindWindow( WNDCLS_NAME, title );	
    if( hw ) 
    {
		SetForegroundWindow( hw );
        return FALSE;
    }
#ifdef WINCE
	if( !CWfcWnd::Create( title, WS_VISIBLE | WS_CLIPCHILDREN ) )
	{
		return FALSE;
	}

	_landscape = GetSystemMetrics(SM_CXSCREEN) > GetSystemMetrics(SM_CYSCREEN);
	g_App.SetLandscape( _landscape );
#else
	if( !CWfcWnd::Create( title, WS_OVERLAPPEDWINDOW | WS_VISIBLE ) )
	{
		return FALSE;
	}

	_landscape = FALSE;
	g_App.SetLandscape( _landscape );
#endif
	setFullscreenMode( false, false );

	return TRUE;
}

LRESULT CMainWnd::onCreate()
{
	// qEBhE쐬
	_macroWnd.Create( this );
	_stylusWnd.Create( this );
	_clockWnd.Create( this );

//	for( int t = TERM_MAX-1; t >= 0; t-- )
	for( int t = 4; t >= 0; t-- )
	{
		_termWnd[t].Create( this );
		_termWnd[t].InitTerm( t, t?64:256 );
	}

	// IME؂ւ@\؂
	ImmSetConversionStatus( ImmGetContext( _hWnd ), 0, 0 );

#ifdef WINCE
	// j[o[쐬
    SHMENUBARINFO mbi;
    memset(&mbi, 0, sizeof(SHMENUBARINFO));
    mbi.cbSize     = sizeof(SHMENUBARINFO);
    mbi.hwndParent = _hWnd;
    mbi.nToolBarId = IDR_MENUBAR;
	mbi.hInstRes   = _hInst;

    if ( !SHCreateMenuBar(&mbi) )
	{
		return -1;
	}

    _hWndMenu = mbi.hwndMB;
	TBBUTTONINFO tbbi = {0};
	tbbi.cbSize = sizeof(tbbi);
	tbbi.dwMask = TBIF_LPARAM | TBIF_COMMAND;
	::SendMessage( _hWndMenu, TB_GETBUTTONINFO, IDM_FILE, (LPARAM)&tbbi);
	_hMenu = (HMENU)tbbi.lParam;

	::SendMessage( _hWndMenu, TB_GETBUTTONINFO, IDM_OPTION, (LPARAM)&tbbi);
	_hMenuOpt = (HMENU)tbbi.lParam;

	RECT mr;
	GetWindowRect( _hWndMenu, &mr );
	_menuHeight = mr.bottom - mr.top;
#else
	HMENU menu = GetMenu( _hWnd );
	_hMenu    = GetSubMenu( menu, 0 );
	_hMenuOpt = GetSubMenu( menu, 1 );
#endif
	SetFocus();

	applyConfig();

	return 0;
}

inline void CMainWnd::enableMenuItem(UINT itemID, BOOL enable)
{
	EnableMenuItem( _hMenu, itemID, enable?MF_ENABLED:MF_GRAYED);
}

void CMainWnd::disableLoadMenu(void)
{
	enableMenuItem( IDM_FILE_NEW, false );
	enableMenuItem( IDM_FILE_CONTINUE, false );
	enableMenuItem( IDM_FILE_SAVE, true );

	EnableMenuItem( _hMenu, 1, MF_GRAYED | MF_BYPOSITION );

	EnableMenuItem( _hMenuOpt, IDM_OPTION_MACRO, MF_ENABLED );
}

void CMainWnd::SearchSaveFile( LPCSTR dir )
{
	enableMenuItem( IDM_FILE_NEW, true );
	LPCWSTR lastfile = g_App.GetConfig().getStr( CONF_LASTFILE );

	HMENU submenu = submenu = GetSubMenu( _hMenu, 1 );
	if( !submenu ){ return; }

	CWfcStr path( dir );
	path += _T("\\*");

	UINT menuID = IDM_FILE_OPEN_BASE;

	HANDLE hSearch;
	WIN32_FIND_DATA fd;
	hSearch = FindFirstFile( path, &fd );
	if( hSearch == INVALID_HANDLE_VALUE ){ return; }

	while(1)
	{
		if( fd.nFileSizeLow > 0 )
		{
			AppendMenu( submenu, MF_STRING, ++menuID, fd.cFileName );
			EnableMenuItem( _hMenu, 1, MF_ENABLED | MF_BYPOSITION );

			// Continue\
			int cmp = wcscmp( fd.cFileName, lastfile );
			if( cmp == 0 )
			{
				enableMenuItem( IDM_FILE_CONTINUE, true );
			}
		}
		if( !FindNextFile( hSearch, &fd ) ){ break; }
	}
}


void CMainWnd::applyConfig(void)
{
	CConfig& config = g_App.GetConfig();

	_useMacro = config.getInt( CONF_USE_MACRO );

	_keyDelay    = config.getInt( CONF_KEY_DELAY );
	_keyInterval = config.getInt( CONF_KEY_INTERVAL );
	if( _keyDelay < 100 ){ _keyDelay = 500; }
	if( _keyInterval < 100 ){ _keyInterval = 100; }

	if( _hBorderPen ){
		DeleteObject( _hBorderPen );
	}
	_hBorderPen = CreatePen( PS_SOLID, 0, (COLORREF)( config.getInt( CONF_BORDER ) ) );

	_clockWnd.Show( config.getInt( CONF_SHOW_CLOCK )?SW_SHOW:SW_HIDE );

	updateChildFont();
	updateChildPos();
}

void CMainWnd::updateChildFont(void)
{
	CConfig& config = g_App.GetConfig();

	_termWnd[0].ChangeFont( CONF_SECT_MT );
	_termWnd[1].ChangeFont( CONF_SECT_T1 );
	_termWnd[2].ChangeFont( CONF_SECT_T2 );
	_termWnd[3].ChangeFont( CONF_SECT_T3 );
	_termWnd[4].ChangeFont( CONF_SECT_T4 );
	_termWnd[5].ChangeFont( CONF_SECT_T5 );
	_termWnd[6].ChangeFont( CONF_SECT_T6 );
	_termWnd[7].ChangeFont( CONF_SECT_T7 );

}

void CMainWnd::setFullscreenMode( BOOL task, BOOL menu )
{
#ifdef WINCE
	_hideTask = task;
	_hideMenu = menu;

	CheckMenuItem( _hMenuOpt, IDM_OPTION_HIDETASK,
		_hideTask?MF_CHECKED:MF_UNCHECKED | MF_BYCOMMAND );

	SHFullScreen( _hWnd, _hideTask?SHFS_HIDETASKBAR:SHFS_SHOWTASKBAR );
	ShowWindow( _hWndMenu, _hideMenu?SW_HIDE:SW_SHOW );

	RECT cr;
	GetWindowRect( GetDesktopWindow(), &cr );
	
	if( _hideTask ){ cr.top = 0; }
	if( !_hideMenu ){ cr.bottom -= _menuHeight; }

	MoveWindow( cr );

	SHFullScreen( _hWnd, _hideMenu?SHFS_HIDESIPBUTTON:SHFS_SHOWSIPBUTTON );

	updateChildPos();
#endif
}

void CMainWnd::toggleStylus(void)
{
	if( _stylusWnd.isVisible() )
	{
		_stylusWnd.Hide();
		CheckMenuItem( _hMenuOpt, IDM_OPTION_STYLUS, MF_UNCHECKED | MF_BYCOMMAND );
	}
	else
	{
		_stylusWnd.Show();
		CheckMenuItem( _hMenuOpt, IDM_OPTION_STYLUS, MF_CHECKED | MF_BYCOMMAND );
	}

	updateChildPos();
}

void CMainWnd::updateChildPos(void)
{
	const int ratio[] = { 6, 4, 3, 2 };

	RECT cr = { 0, 0, _width, _height };

	_stylusWnd.AdjustClientArea( cr );
	_macroWnd.AdjustClientArea( cr );


	CConfig& config = g_App.GetConfig();

	int clshow = config.getInt( CONF_SHOW_CLOCK );
	if( clshow == 2 )
	{
		_clockWnd.SetPosition( CWfcWndChild::CORNER_RT );
	}
	else
	{
		_clockWnd.SetPosition( CWfcWndChild::CORNER_LB );
	}
	_clockWnd.SetDefaultSize( config.getInt( CONF_CLOCK_WIDTH ), g_App.GetUIHeight() );

	SAFE_DELETE( _lineList );

	RECT mtr = {0};
	mtr.left   = cr.left;
	mtr.top    = cr.top;
	mtr.right  = cr.right;
	mtr.bottom = cr.bottom;

	int mtw = g_App.GetTermWidth( CONF_SECT_MT )  + MARGIN * 2;
	int mth = g_App.GetTermHeight( CONF_SECT_MT ) + MARGIN * 2;

	if( mtr.right  > mtr.left + mtw ){ mtr.right  = mtr.left + mtw; }
	if( mtr.bottom > mtr.top  + mth ){ mtr.bottom = mtr.top  + mth; }

	_termWnd[0].MoveWindow( mtr );

	RECT tr = {0};
	tr.left   = mtr.left;
	tr.right  = mtr.right;
	tr.top    = mtr.bottom + 2;
	tr.bottom = cr.bottom;

	if( tr.bottom - tr.top < MIN_TERM_SIZE )
	{
		_termWnd[1].Hide();
		_termWnd[2].Hide();
	}
	else
	{
		// ^[~i`
		addLine( new CLineList( cr.left, mtr.bottom + 1, mtr.right + 1, mtr.bottom + 1 ) );

		int bl = config.getInt( CONF_BT_LAYOUT );
		if( bl < 0 || bl > 3 ){ bl = 0; }
		int btw = ROUNDUP( mtr.right * ratio[bl] / 6, g_App.GetFontWidth( CONF_SECT_T1 ) ) + MARGIN*2;
		if( tr.right > tr.left + btw ){ tr.right = tr.left + btw; }
		_termWnd[1].Show();
		_termWnd[1].MoveWindow( tr );

		if( mtr.right - tr.right < MIN_TERM_SIZE )
		{
			_termWnd[2].Hide();
		}
		else
		{
			// ^[~i`
			addLine( new CLineList( tr.right + 1, tr.top - 1, tr.right + 1, tr.bottom + 1 ) );

			tr.left    = tr.right + 2;
			tr.right   = mtr.right;
			_termWnd[2].Show();
			_termWnd[2].MoveWindow( tr );
		}
	}

	tr.left   = mtr.right + 2;
	tr.top    = cr.top;
	tr.right  = cr.right;
	tr.bottom = cr.bottom;

	if( tr.right - tr.left < MIN_TERM_SIZE )
	{
		_termWnd[3].Hide();
		_termWnd[4].Hide();
	}
	else
	{
		if( clshow == 1 || clshow == 2 )
		{
			tr.top += g_App.GetUIHeight();
			_clockWnd.SetPosition( CWfcWndChild::CORNER_RT );
			int cpw = config.getInt( CONF_CLOCK_WIDTH );
			if( cpw < tr.right - tr.left ){ cpw = tr.right - tr.left; }
			_clockWnd.SetDefaultSize( cpw, g_App.GetUIHeight() );
		}

		// E^[~i`
		addLine( new CLineList( mtr.right + 1, cr.top, mtr.right + 1, cr.bottom ) );

		int rl = config.getInt( CONF_RT_LAYOUT );
		if( rl < 0 || rl > 3 ){ rl = 0; }
		int rth = ROUNDUP( _height * ratio[rl] / 6, g_App.GetFontHeight( CONF_SECT_T3 ) ) + MARGIN*2;
		if( tr.bottom > tr.top  + rth ){ tr.bottom = tr.top  + rth; }
		_termWnd[3].Show();
		_termWnd[3].MoveWindow( tr );

		if( _height - tr.bottom < MIN_TERM_SIZE )
		{
			_termWnd[4].Hide();
		}
		else
		{
			// E^[~i`
			addLine( new CLineList( tr.left - 1, tr.bottom + 1, cr.right, tr.bottom + 1 ) );

			tr.top    = tr.bottom + 2;
			tr.bottom = _height - 1;
			_termWnd[4].Show();
			_termWnd[4].MoveWindow( tr );
		}
	}

	_clockWnd.AdjustClientArea( cr );

	UpdateWindow();
}


LRESULT CMainWnd::onCommand( WORD cmd, WORD flag, HANDLE sender )
{
	if( cmd > IDM_FILE_OPEN_BASE )
	{
		disableLoadMenu();
		MENUITEMINFO mi = {0};
		mi.cbSize = sizeof(MENUITEMINFO);
		mi.fMask = MIIM_TYPE;
		GetMenuItemInfo( _hMenu, cmd, FALSE, &mi );
		CWfcStr fname( mi.cch + 1 );
		mi.dwTypeData = fname;
		mi.cch = mi.cch * 2;
		GetMenuItemInfo( _hMenu, cmd, FALSE, &mi );
		g_App.CmdLoadGame( fname );
	}

	switch( cmd )
	{
	case IDM_FILE_NEW:
		disableLoadMenu();
		g_App.CmdNewGame();
		break;
	case IDM_FILE_CONTINUE:
		disableLoadMenu();
		g_App.CmdContinue();
		break;
	case IDM_FILE_SAVE:
		if( g_App.isLoaded() )
		{
			acSaveData();
		}
		break;
	case IDM_FILE_QUIT:
		if( g_App.isLoaded() )
		{
			acSendQuitKey();
		}
		else
		{
			PostQuitMessage( 0 );
		}
		break;
	case IDM_OPTION_TERM:
		{
			setFullscreenMode( false, false );
			COptionDlg od;
			od.DoModal( _hWnd );

			g_App.ApplyConfig();
			applyConfig();
		}
		break;
	case IDM_OPTION_MACRO:
		{
			setFullscreenMode( false, false );
			CMacroDlg md;
			md.DoModal( _hWnd );
		}
		break;
	case IDM_OPTION_VERSION:
		{
			setFullscreenMode( false, false );
			CVersionDlg vd;
			vd.DoModal( _hWnd );
		}
		break;
	case IDM_OPTION_UI:
		{
			setFullscreenMode( false, false );
			COptUIDlg oud;
			oud.DoModal( _hWnd );

			g_App.ApplyConfig();
			applyConfig();
		}
		break;
	case IDM_OPTION_HIDEMENU:
		setFullscreenMode(  _hideTask, !_hideMenu );
		break;
	case IDM_OPTION_HIDETASK:
		setFullscreenMode( !_hideTask,  _hideMenu );
		break;
	case IDM_OPTION_STYLUS:
		toggleStylus();
		break;
	}
	return TRUE;
}

LRESULT CMainWnd::onPaint( HDC dc )
{
	RECT rt = {0};
	GetClientRect( _hWnd, &rt );

	FillRect( dc, &rt, _hBkBrush );
	SelectObject( dc, _hBorderPen );

	if( _lineList )
	{
		_lineList->Draw( dc );
	}

	return 0;
}

LRESULT CMainWnd::onKeyUp( WORD key, WORD rept, WORD flag )
{
#ifdef WINCE
	if( key == _reptKey )
	{
		// L[s[g^C}[𒆒f
		if( _timer ){ KillTimer( _hWnd, _timer ); }
		_timer = 0;
		return 0;
	}
	if( _hideMenu )
	{
		if( key == VK_F1 )
		{
			setFullscreenMode( !_hideTask, _hideMenu );
			return 0;
		}
		else if( key == VK_F2 )
		{
			setFullscreenMode( _hideTask, !_hideMenu );
			return 0;
		}
	}
#endif
	return CWfcWnd::onKeyUp( key, rept, flag );
}

LRESULT CMainWnd::onKeyDown( WORD key, WORD rept, WORD flag )
{
	if( key == VK_SHIFT || key == VK_CONTROL ){ return 0; }

	// ʏ핶
	if( key >= '0' )
	{
#ifdef WINCE
		if( key <= '9' && !GetKeyState( VK_SHIFT ) )
		{
			// lL[̃L[s[gvOŏ
			_reptKey = key;
			if( _timer ){ KillTimer( _hWnd, _timer ); }
			_timer = SetTimer( _hWnd, TIMER_KEYRPT_F, _keyDelay, NULL );
			return 0;
		}
#endif
		if( GetKeyState( VK_CONTROL ) & 0x8000 ){
			// CtrlƂ̑gݍ킹
			acTermKeypress( '^' );
			acTermKeypress( key );
			return 0;
		}

		// ʏ핶OnCharŏ
		return 0;
	}

#ifdef WINCE
	// Ctrl+EnterŃj[\؂ւ
	if( key == VK_RETURN && GetKeyState( VK_CONTROL ) )
	{
		if( _hideTask && _hideMenu )
		{
			setFullscreenMode( false, false );
		}
		else
		{
			setFullscreenMode( true, true );
		}
		return 0;
	}
#endif

	// ꕶ[^_xHH\r]ŏo
	// ATCL[pref-*.prfɂĒ`

	BYTE sc = (BYTE)flag;

	acTermKeypress( MACRO_BEGIN );
	if( GetKeyState( VK_SHIFT   ) & 0x8000 ){ acTermKeypress( 'S' ); }
	if( GetKeyState( VK_CONTROL ) & 0x8000 ){ acTermKeypress( 'C' ); }
	acTermKeypress( 'x' );
	acTermKeypress( hexsym[key/16] );
	acTermKeypress( hexsym[key%16] );
//	acTermKeypress( hexsym[sc/16] );
//	acTermKeypress( hexsym[sc%16] );
	acTermKeypress( MACRO_END );

	return 0;
}

LRESULT CMainWnd::onChar( WORD key, WORD rept, WORD flag )
{
	// L[{[h}N\
	if( _useMacro && key == '#' )
	{
		_macroWnd.Show();
		_macroWnd.SetFocus();
		return 0;
	}

	if( key < 0x20 )
	{
		// L[͏ς
		return 0;
	}

	if( g_App.isInit() && !g_App.isLoaded() )
	{
		if( key == 'N' || key == 'n' ){ onCommand( IDM_FILE_NEW ); }
		if( key == 'C' || key == 'c' ){ onCommand( IDM_FILE_CONTINUE ); }
		return 0;
	}

#ifdef WINCE
	// lL[[^_N\r]ŏo(J[\[h)
	if( key >= '0' && key <= '9' )
	{

		if( g_App.isInputMode() && !g_App.isDirMode() )
		{
			// ̓[h͕ϊɏói[hj
			acTermKeypress( key );
		}
		else{
			acTermKeypress( MACRO_BEGIN );
			acTermKeypress( key );
			acTermKeypress( MACRO_END );
		}
		return 0;
	}
#endif

#ifdef UNICODE
	if( key > 0x80 )
	{
		// 2oCg(WCHAR)
		WCHAR wstr[2] = { key, L'\0' };
		char str[4];
		wcstombs( str, wstr, 4 );
		acTermKeypress( str[0] );
		acTermKeypress( str[1] );
		return 0;
	}
#endif

	acTermKeypress(key);

	return 0;
}

LRESULT CMainWnd::onSize( WORD cx, WORD cy, DWORD type )
{
#ifdef WINCE
	if( _width != cx )
	{
		_landscape = GetSystemMetrics(SM_CXSCREEN) > GetSystemMetrics(SM_CYSCREEN);
		g_App.SetLandscape( _landscape );
	}
#endif
	_width  = cx;
	_height = cy;

	updateChildPos();

	return 0;
}

LRESULT CMainWnd::onTimer( DWORD id )
{
#ifdef WINCE
	if( id == TIMER_KEYRPT_F )
	{
		KillTimer( _hWnd, _timer );
		_timer = SetTimer( _hWnd, TIMER_KEYRPT_S, _keyInterval, NULL );
		return onChar( _reptKey, 0, 0 );
	}
	else if( id == TIMER_KEYRPT_S )
	{
		return onChar( _reptKey, 0, 0 );
	}
#endif
	return 0;
}

LRESULT CMainWnd::onClose(void)
{
	if( g_App.isLoaded() )
	{
		acSendQuitKey();
	}
	else
	{
		PostQuitMessage( 0 );
	}

	return 0;
}


LRESULT CMainWnd::onMessage( UINT msg, WPARAM wp, LPARAM lp )
{
#ifdef WINCE
	if( msg == WM_SETTINGCHANGE && wp == SPI_SETSIPINFO )
	{
		SHACTIVATEINFO sai;
		memset( &sai, 0, sizeof( SHACTIVATEINFO ) );
		SHHandleWMSettingChange( _hWnd, -1, 0, &sai );
	}
	if( msg == WM_SETTINGCHANGE && wp == SETTINGCHANGE_RESET )
	{
		RECT rc;
		GetClientRect( _hWnd, &rc );
		onSize( rc.right, rc.bottom, 0 );
	}
#endif
	return DefWindowProc( _hWnd, msg, wp, lp );
}
