#pragma once

#include "TermWnd.h"
#include "Panel.h"


#define TERM_MAX 8

class CLineList
{
public:
	CLineList( int ox, int oy, int tx, int ty );
	~CLineList();
	void Add( CLineList* line );
	void Draw( HDC dc );
private:
	int _ox, _oy, _tx, _ty;
	CLineList* _next;
};


class CMainWnd : public CWfcWnd
{
public:
	CMainWnd();
	~CMainWnd();

public:
	BOOL Create(void);
	void AddMenuItem( UINT menuID, LPCTSTR str );

	void SearchSaveFile( LPCSTR dir );

protected: // Override
	virtual ATOM getClassAtom(void);

	virtual LRESULT onCreate();
	virtual LRESULT onPaint( HDC dc );
	virtual LRESULT onKeyDown( WORD key, WORD rept, WORD flag );
	virtual LRESULT onKeyUp( WORD key, WORD rept, WORD flag );
	virtual LRESULT onChar( WORD key, WORD rept, WORD flag );
	virtual LRESULT onSize( WORD cx, WORD cy, DWORD type );
	virtual LRESULT onTimer( DWORD id );
	virtual LRESULT onCommand( WORD cmd, WORD flag = 0, HANDLE sender = NULL );
	virtual LRESULT onClose(void);
	virtual LRESULT onMessage( UINT msg, WPARAM wp, LPARAM lp );

private: // private functions
	void applyConfig(void);

	void setFullscreenMode( BOOL task, BOOL menu );
	void toggleStylus(void);

	void enableMenuItem(UINT itemID, BOOL enable);
	void disableLoadMenu(void);

	void updateChildFont(void);
	void updateChildPos(void);

	void addLine( CLineList* line )
	{
		if( _lineList ){ _lineList->Add(line); }
		else{ _lineList = line; }
	}
private:
	HWND  _hWndMenu;
	HMENU _hMenu, _hMenuOpt;

	CWfcWndChild* _child;

	HPEN _hBorderPen;   // {[_[`p̃y

	bool _landscape;
	bool _hideMenu, _hideTask;
	int  _menuHeight;

	UINT _timer;   // L[s[gp^C}[
	char _reptKey; // ̃L[
	int _keyDelay, _keyInterval; // L[s[gx

	bool  _useMacro;

	CTerminalWnd _termWnd[TERM_MAX];

	CMacroWnd  _macroWnd;
	CStylusWnd _stylusWnd;
	CClockWnd  _clockWnd;

	CLineList* _lineList;
};


