#include "base.h"
#include "Panel.h"

#include "AngbandTerm-wm.h"

extern char hexsym[16];

#define GRID_WIDTH  (GRID_HEIGHT*2)
#define GRID_HEIGHT (g_App.GetUIHeight())

#define MACRO_COLS (g_App.IsLandscape()?4:3)
#define MACRO_ROWS (g_App.IsLandscape()?3:4)
#define MACRO_WINDOW_WIDTH  (GRID_WIDTH*MACRO_COLS)
#define MACRO_WINDOW_HEIGHT (GRID_HEIGHT*MACRO_ROWS)

#define STYLUS_WINDOW_HEIGHT (GRID_HEIGHT*STYLUS_ROWS)

#define STYLUS_FILENAME _T("\\stylus.def")

#define BUF_SIZE 1024

const int MACRO_ID_TABLE[4][3] =
{
	{  0,  1,  2 },
	{  3,  4,  5 },
	{  6,  7,  8 },
	{  9, 10, 11 }
};

// CClockWnd

CClockWnd::CClockWnd() : CWfcWndChild()
{
	_hBkBrush = GetSysColorBrush( COLOR_3DFACE );
	_startTime = GetTickCount();
}

CClockWnd::~CClockWnd()
{
}

BOOL CClockWnd::Create( CWfcWnd* owner )
{
	return CWfcWndChild::Create( owner, _T(""), 0, WS_EX_NOACTIVATE );
}

LRESULT CClockWnd::onCreate()
{
	SetTimer( _hWnd, TIMER_CLOCK, TIMER_CLOCK_ITV, NULL );
	return 0;
}

LRESULT CClockWnd::onPaint( HDC dc )
{
	SYSTEMTIME curTime;

	GetLocalTime( &curTime );
	DWORD passage = GetTickCount() - _startTime;
	int pmin  = passage / 60000;
	int phour = pmin / 60;
	pmin %= 60;

	CWfcStr str( 64 );
	_stprintf( str, _T("(%0dh%02dmin) [%02d:%02d]"),
			phour, pmin, curTime.wHour, curTime.wMinute );

	SetTextAlign( dc, TA_CENTER );
	SetTextColor( dc, RGB(0,0,0) );
	SetBkColor( dc, GetSysColor( COLOR_3DFACE ) );

	RECT rt = {0};
	rt.right = _width;
	rt.bottom = _height;
	DrawEdge( dc, &rt, BDR_RAISEDINNER, BF_ADJUST | BF_RECT | BF_MIDDLE );
	int tx = _width / 2;
	int ty = rt.top + g_App.GetUIMargin();
	g_App.GetFont().Draw( dc, tx, ty, str, ETO_CLIPPED, &rt );

	return 0;
}

LRESULT CClockWnd::onTimer( DWORD id )
{
	UpdateWindow();
	return 0;
}


// CMacroWnd

CMacroWnd::CMacroWnd() : CWfcWndChild( CORNER_RB )
{
	_hBkBrush = GetSysColorBrush( COLOR_3DFACE );
}

CMacroWnd::~CMacroWnd(void)
{

}

BOOL CMacroWnd::Create( CWfcWnd* owner )
{
	if( !CWfcWndChild::Create( owner, _T(""), 0, 0 ) )
	{
		return FALSE;
	}

	// IME@\؂
	ImmSetConversionStatus( ImmGetContext( _hWnd ), 0, 0 );

	return TRUE;
}

void CMacroWnd::AdjustClientArea( RECT& ownerRect )
{
	_width  = MACRO_WINDOW_WIDTH;
	_height = MACRO_WINDOW_HEIGHT;

	CWfcWndChild::AdjustClientArea( ownerRect );
}

LRESULT CMacroWnd::onPaint( HDC dc )
{
	SetTextAlign( dc, TA_CENTER );
	SetTextColor( dc, RGB(0,0,0) );
	SetBkColor( dc, GetSysColor( COLOR_3DFACE ) );

	int gw = GRID_WIDTH;
	int gh = GRID_HEIGHT;

	RECT rt;
	if( g_App.IsLandscape() )
	{
		for( int y = 0; y < 3; y++ )
		{
			for( int x = 0; x < 4; x++ )
			{
				int id = MACRO_ID_TABLE[3-x][y];
				const CWfcStr& str = g_App.GetMacro( id );

				rt.left   = x * gw;
				rt.right  = rt.left + gw;
				rt.top    = y * gh;
				rt.bottom = rt.top + gh;
				int tx = rt.left + gw / 2;
				int ty = rt.top  + g_App.GetUIMargin();

				DrawEdge( dc, &rt, BDR_RAISEDINNER, BF_ADJUST | BF_RECT | BF_MIDDLE );
				g_App.GetFont().Draw( dc, tx, ty, str, ETO_CLIPPED, &rt );
			}
		}
	}
	else
	{
		for( int y = 0; y < 4; y++ )
		{
			for( int x = 0; x < 3; x++ )
			{
				int id = MACRO_ID_TABLE[y][x];
				const CWfcStr& str = g_App.GetMacro( id );

				rt.left   = x * gw;
				rt.right  = rt.left + gw;
				rt.top    = y * gh;
				rt.bottom = rt.top + gh;
				int tx = rt.left + gw / 2;
				int ty = rt.top  + g_App.GetUIMargin();

				DrawEdge( dc, &rt, BDR_RAISEDINNER, BF_ADJUST | BF_RECT | BF_MIDDLE );
				g_App.GetFont().Draw( dc, tx, ty, str, ETO_CLIPPED, &rt );
			}
		}
	}

	return 0;
}

LRESULT CMacroWnd::onChar( WORD key, WORD rept, WORD flag )
{
	if( key < 0x20 )
	{
		// L[͏ς
		return 0;
	}

	int id = -1;

	if( key == '#' ){ 
		id = 11;
	}
	else if( key == '0' ){ 
		id = 10;
	}
	else if( key == '*' ){
		id = 9;
	}
	else if( key >= '1' && key <= '9' )
	{
		id = key - '1';
	}
	
	if( id >= 0 )
	{
		g_App.ProcessMacro( id );
	}
	else
	{
		acTermKeypress( MACRO_BEGIN );
		acTermKeypress( (char)key );
		acTermKeypress( MACRO_END );
	}

	Hide();

	return 0;
}

LRESULT CMacroWnd::onKeyDown( WORD key, WORD rept, WORD flag )
{
	if( key == VK_BACK || key == VK_ESCAPE )
	{
		Hide();
		return 0;
	}

	// ʏ핶
	if( key >= '0' )
	{
		// ʏ핶OnCharŏ
		return 0;
	}

	BYTE sc = LOBYTE(flag);

	acTermKeypress( MACRO_BEGIN );
//	acTermKeypress( 'M' );
	acTermKeypress( 'x' );
	acTermKeypress( hexsym[key/16] );
	acTermKeypress( hexsym[key%16] );
//	acTermKeypress( hexsym[sc/16] );
//	acTermKeypress( hexsym[sc%16] );
	acTermKeypress( MACRO_END );
	return 0;
}

LRESULT CMacroWnd::onLButtonDown( WORD px, WORD py, DWORD flag )
{
	int gw = GRID_WIDTH;
	int gh = GRID_HEIGHT;

	RECT rt;
	rt.left   = ( px / gw ) * gw;
	rt.right  = rt.left + gw;
	rt.top    = ( py / gh ) * gh;
	rt.bottom = rt.top + gh;

	int id;
	int ix = px / gw;
	int iy = py / gh;

	if( g_App.IsLandscape() )
	{
		id = MACRO_ID_TABLE[3-ix][iy];
	}
	else
	{
		id = MACRO_ID_TABLE[iy][ix];
	}

	HDC dc = GetDC();
	InvertRect( dc, &rt );
	Sleep( 100 );
	InvertRect( dc, &rt );
	ReleaseDC();

	g_App.ProcessMacro( id );

	Hide();

	return 0;
}

LRESULT CMacroWnd::onMessage( UINT msg, WPARAM wp, LPARAM lp )
{
	if( msg == WM_KILLFOCUS )
	{
		Hide();
	}
	return 0;
}


// CStylusWnd

CWfcStr CStylusWnd::_spkey[STYLUS_ROWS] =
{
	CWfcStr( _T("Esc") ), CWfcStr( _T("Caps") ), CWfcStr( _T("Sign") )
};


CStylusWnd::CStylusWnd() : CWfcWndChild( BAR_BOTTOM )
{
	_hBkBrush = GetSysColorBrush( COLOR_3DFACE );
	_mode = 0;

	load();
}

CStylusWnd::~CStylusWnd(void)
{

}

void CStylusWnd::load(void)
{
	CWfcStr fn( MAX_PATH );
	GetModuleFileName( NULL, fn, MAX_PATH );
	fn.TruncateTail( _T('\\') );
	fn += STYLUS_FILENAME;

	FILE* rf = _wfopen( fn, L"rt" );
	if( !rf ){ return; }

	CWfcStr line( BUF_SIZE );

	for( int t = 0; t < STYLUS_MODE*STYLUS_ROWS; t++ )
	{
		if( !fgetws( line, BUF_SIZE, rf ) ){ break; }
		line.Trim();
		_key[t] = line;
	}
	fclose( rf );
}

BOOL CStylusWnd::Create( CWfcWnd* owner )
{
	return CWfcWndChild::Create( owner, _T(""), 0, WS_EX_NOACTIVATE );
}

void CStylusWnd::AdjustClientArea( RECT& ownerRect )
{
	_height = STYLUS_WINDOW_HEIGHT;

	CWfcWndChild::AdjustClientArea( ownerRect );
}

LRESULT CStylusWnd::onPaint( HDC dc )
{
	SetTextAlign( dc, TA_CENTER );
	SetTextColor( dc, RGB(0,0,0) );
	SetBkColor( dc, GetSysColor( COLOR_3DFACE ) );

	if( _mode < 0 || _mode >= STYLUS_MODE ){ _mode = 0; }

	RECT rt = {0};
	TCHAR str[2] = _T(" ");
	for( int y = 0; y < STYLUS_ROWS; y++ )
	{
		for( int x = 2; x < STYLUS_COLS; x++ )
		{
			rt.left   =     x * _width / STYLUS_COLS;
			rt.right  = (x+1) * _width / STYLUS_COLS;
			rt.top    =     y * GRID_HEIGHT;
			rt.bottom = (y+1) * GRID_HEIGHT;
			DrawEdge( dc, &rt, BDR_RAISEDINNER, BF_ADJUST | BF_RECT | BF_MIDDLE );
			int tx = ( rt.left + rt.right ) / 2;
			int ty = rt.top + g_App.GetUIMargin();
			str[0] = _key[_mode*STYLUS_ROWS+y][x-2];
			if( str[0] )
			{
				g_App.GetFont().Draw( dc, tx, ty, 1, str, ETO_CLIPPED, &rt );
			}
		}
		rt.left   = 0;
		rt.right  = 2 * _width / STYLUS_COLS;
		rt.top    =     y * GRID_HEIGHT;
		rt.bottom = (y+1) * GRID_HEIGHT;
		if( _mode > 0 && _mode == y )
		{
			DrawEdge( dc, &rt, BDR_SUNKENINNER, BF_ADJUST | BF_RECT | BF_MIDDLE );
		}
		else
		{
			DrawEdge( dc, &rt, BDR_RAISEDINNER, BF_ADJUST | BF_RECT | BF_MIDDLE );
		}
		int tx = ( rt.left + rt.right ) / 2;
		int ty = rt.top + g_App.GetUIMargin();
		g_App.GetFont().Draw( dc, tx, ty, _spkey[y], ETO_CLIPPED, &rt );
	}

	return 0;
}

LRESULT CStylusWnd::onLButtonDown( WORD px, WORD py, DWORD flag )
{
	_owner->SetFocus();

	char key = '\0';

	int ix = px * STYLUS_COLS / _width;
	int iy = py / GRID_HEIGHT;

	RECT rt = {0};

	if( ix < 2 )
	{
		if( iy == 0 )
		{
			// ESC
			key = ESCAPE_KEY;
			rt.left   = 0;
			rt.right  = 2 * _width / STYLUS_COLS;
			rt.top    = 0;
			rt.bottom = GRID_HEIGHT;
		}
		else
		{
			// Shift or Sign
			_mode = (_mode==iy)?0:iy;
			UpdateWindow();
			return 0;
		}
	}
	else
	{
		rt.left   =     ix * _width / STYLUS_COLS;
		rt.right  = (ix+1) * _width / STYLUS_COLS;
		rt.top    =     iy * GRID_HEIGHT;
		rt.bottom = (iy+1) * GRID_HEIGHT;
		key = (char)_key[_mode*STYLUS_ROWS+iy][ix-2];
	}

	if( key )
	{
		HDC dc = GetDC();
		InvertRect( dc, &rt );
		Sleep( 100 );
		InvertRect( dc, &rt );
		ReleaseDC();

		if( key == '#' )
		{
			// }NplĂяỏ\̂Őeɓ
			_owner->PostMessage( WM_CHAR, key, 0 );
		}
		else if( key >= '1' && key <= '9' )
		{
			if( _mode == 1 )
			{
				acTermKeypress( '.' );
			}
			else if( _mode == 2 )
			{
				acTermKeypress( '+' );
			}
			acTermKeypress( key );
		}
		else
		{
			acTermKeypress( key );
		}

		if( _mode )
		{
			_mode = 0;
			UpdateWindow();
		}
	}
	return 0;
}
