#include "base.h"
#include "TermWnd.h"

#include "AngbandTerm-wm.h"

#define COLOR_BLACK RGB(0,0,0)
#define COLOR_NUM 256
COLORREF g_colorref[COLOR_NUM];

/* ݒ莞̏E */
#define COL_MAX 120
#define COL_MIN 8
#define ROW_MAX 60
#define ROW_MIN 2

#define CHAR_WALL 127

#ifdef JP
 #define DIR_STR ""
 #define CMD_STR "R}h"
#else
 #define DIR_STR "Direction"
 #define CMD_STR "Command"
#endif

void init_color()
{
	for( int c = 0; c < COLOR_NUM; c++ )
	{
		g_colorref[c] = acGetColorValue( c );
	}
}

CTerminalWnd::CTerminalWnd() : CWfcWndChild()
{
	HBITMAP wallDIB = LoadBitmap( g_App.GetAppInstance(), MAKEINTRESOURCE(IDB_WALL) );
	_wallBrush = CreatePatternBrush( wallDIB );
	DeleteObject( wallDIB );

	_curPen = CreatePen( PS_SOLID, 1, RGB(255,255,0) );

	memset( (void*)&_term, 0, sizeof(term) );

	_cols = COL_MIN;
	_rows = ROW_MIN;

	_isMainTerm = FALSE;
}

CTerminalWnd::~CTerminalWnd()
{
}

BOOL CTerminalWnd::Create( CWfcWnd* owner )
{
	return CWfcWndChild::Create( owner, _T(""),
		0, WS_EX_NOACTIVATE );
}

void CTerminalWnd::Show( int cmd )
{
	if( cmd == SW_HIDE )
	{
		if( _termID > 0 && isVisible()  )
		{
			// C^[~i͖Ȃ
			acSetTerm( _termID, NULL );
		}
	}
	else
	{
		if( !isVisible() )
		{
			// ^[~iĂȂ΃|C^Zbg
			acSetTerm( _termID, (void*)(void*)&_term );
			acRedrawTerm( _termID );
		}
	}

	CWfcWnd::Show( cmd  );
}

LRESULT CTerminalWnd::onPaint( HDC dc )
{
	acRedrawTerm( _termID );

	return 0;
}

LRESULT CTerminalWnd::onSize( WORD cx, WORD cy, DWORD type )
{
	if( !cx || !cy ){ return 0; }

	_cols = ( cx - MARGIN*2 ) / _font.Width();
	_rows = ( cy - MARGIN*2 ) / _font.Height();

	if( _cols > COL_MAX ){ _cols = COL_MAX; }
	if( _rows > ROW_MAX ){ _rows = ROW_MAX; }

	if( _cols < COL_MIN ){ _cols = COL_MIN; Hide(); }
	if( _rows < ROW_MIN ){ _rows = ROW_MIN; Hide(); }

	else
	{
		Show();

		if( _term.wid && _term.hgt )
		{
			if( _term.wid != ( _cols + 1 ) || _term.hgt != _rows )
			{
				Clear(); // S~c\̂ŁAxS

				acResizeTerm( _termID, _cols + 1, _rows );
			}
		}
	}
	return 0;
}


LRESULT CTerminalWnd::onLButtonDown( WORD px, WORD py, DWORD flag )
{
	_owner->SetFocus();
	acTermKeypress( ' ' );
	return 0;
}

void CTerminalWnd::ChangeFont( LPCTSTR section )
{
	CConfig& config = g_App.GetConfig();
	LPCTSTR face = config.getStr( CONF_FNAME, section );
	int size = config.getInt( CONF_FSIZE, section );
	int chp  = config.getInt( CONF_CHP, section );
	int lfp  = config.getInt( CONF_LFP, section );
	BOOL ctype = config.getInt( CONF_CTYPE, section );
	BOOL bold  = config.getInt( CONF_BOLD,  section );

	if( size < FONT_SIZE_MIN ){ size = FONT_SIZE_MIN; }

	_font.Create( size, face, bold, ctype, TRUE, chp, lfp );

	UpdateWindow();
}


void CTerminalWnd::InitTerm( int termnum, int keysize )
{
	_termID = termnum;

	if( termnum >= 0 && termnum < 8 ){
		acInitTerm( (void*)&_term, _cols + 1, _rows, keysize );
		if( termnum == 0 ){
			_isMainTerm = TRUE;
		}

		_term.user_hook    = hook_user;
		_term.xtra_hook    = hook_xtra;
		_term.curs_hook    = hook_curs;
		_term.bigcurs_hook = hook_curs;
		_term.wipe_hook    = hook_wipe;
		_term.text_hook    = hook_text;

		_term.soft_cursor  = TRUE;
		_term.attr_blank   = 0;
		_term.char_blank   = ' ';
		_term.data         = (void*)this;

		acActivateTerm( termnum );
	}
}

void CTerminalWnd::DrawCurs( int x, int y )
{

	if( _isMainTerm && y==0 )
	{
		// OsڂɃJ[\\œ̓[h
		g_App.setInputMode( TRUE );
	}

	if( isVisible() && x < _cols )
	{
		RECT rc;
		rc.left   = x * _font.Width() + MARGIN;
		rc.right  = rc.left + _font.Width() - 1;
		rc.top    = y * _font.Height() + MARGIN;
		rc.bottom = rc.top + _font.Height() - 1;

		HDC dc = GetDC();

		SelectObject( dc, _curPen );
		MoveToEx( dc, rc.left, rc.top, NULL );
		LineTo( dc, rc.left , rc.bottom );
		LineTo( dc, rc.right, rc.bottom );
		LineTo( dc, rc.right, rc.top );
		LineTo( dc, rc.left , rc.top );
		ReleaseDC();
	}
}

void CTerminalWnd::Wipe( int x, int y, int n )
{
	if( _isMainTerm )
	{
		g_App.setInputMode( FALSE );
	}

	if( isVisible() )
	{
		if( n + x > _cols ){ n = _cols - x; }

		RECT rc;
		rc.left   = x * _font.Width() + MARGIN;
		rc.right  = rc.left + n * _font.Width();
		rc.top    = y * _font.Height() + MARGIN;
		rc.bottom = rc.top + _font.Height();

		HDC dc = GetDC();
		FillRect( dc, &rc, _hBkBrush );
		ReleaseDC();
	}
}

void CTerminalWnd::Clear()
{
	if( _isMainTerm )
	{
		g_App.setInputMode( FALSE );
		g_App.setDirMode( FALSE );
	}

	if( isVisible() )
	{
		RECT rt = {0};
		GetClientRect( _hWnd, &rt );

		HDC dc = GetDC();
		FillRect( dc, &rt, _hBkBrush );
		ReleaseDC();
	}
}

void CTerminalWnd::TextOut( int x, int y, int n, byte col, LPCSTR str )
{
	if( n + x > _cols ){ n = _cols - x; }

	// WCHARɕϊĂ
	// (=0x7f)͕̉\̂ŁAXy[Xɕϊ
	char *tmp = new char[n+1];
	for( int t = 0; t < n; t++ ){ tmp[t] = (str[t]!=CHAR_WALL)?str[t]:' '; }
	tmp[n] = '\0';

	CWfcStr wstr( tmp );

	if( _isMainTerm )
	{
		if( y == 0 && x == 0 )
		{
			g_App.setDirMode( strstr( tmp, DIR_STR )?TRUE:FALSE );
		}
		else if( y == 20 && x == 0 && strstr( tmp, CMD_STR ) )
		{
			g_App.setInputMode( TRUE );
		}
	}

	if( isVisible() )
	{
		int cx = x * _font.Width()  + MARGIN;
		int cy = y * _font.Height() + MARGIN;

		HDC dc = GetDC();

		SetBkColor( dc, COLOR_BLACK );
		SetTextColor( dc, g_colorref[col] );

		// Ƃ肠Aʏ͑̕Sďo
		_font.Draw( dc, cx, cy, wstr, ETO_OPAQUE | ETO_CLIPPED );

		// ToDo: ǂ𒲂ׂēh蒼
		// Shift-Jis0x7FgpȂ̂ŁA`FbN͕sv
		int i, t;
		for( i = 0; i < n; i++ )
		{
			if( str[i] == CHAR_WALL )
			{
				for( t = 1; i+t < n; t++ )
				{
					if( str[i+t] != CHAR_WALL ){ break; }
				}

				RECT rc;
				rc.left   = ( x + i ) * _font.Width() + MARGIN;
				rc.right  = rc.left + t * _font.Width();
				rc.top    = y * _font.Height() + MARGIN;
				rc.bottom = rc.top + _font.Height();
				FillRect( dc, &rc, _wallBrush );

				i += ( t - 1 );
			}
		}

		ReleaseDC();
	}
	delete tmp;
}

errr CheckMessage(BOOL block)
{
	MSG msg;

	if( block )
	{
		if( GetMessage(&msg, NULL, 0, 0) )
		{
			TranslateMessage(&msg);
			DispatchMessage(&msg);
		}
	}
	else
	{
		if( PeekMessage(&msg, NULL, 0, 0, PM_REMOVE) )
		{
			TranslateMessage(&msg);
			DispatchMessage(&msg);
		}
	}

	return 0;
}

errr FlushMessage(void)
{
	MSG msg;

	while( PeekMessage(&msg, NULL, 0, 0, PM_REMOVE) )
	{
		TranslateMessage(&msg);
		DispatchMessage(&msg);
	}

	return 0;
}

errr ChangeEnviroment(void)
{
	// Color
	init_color();

	return 0;
}


extern "C"{
	// Callback functions for HENGBAND

	errr hook_user(int n)
	{
		return 0;
	}

	errr hook_xtra(int n, int v)
	{
		/* Handle a subset of the legal requests */
		switch (n)
		{
		/* Process random events */
		case TERM_XTRA_BORED:
			return CheckMessage( FALSE );

		/* Process an event */
		case TERM_XTRA_EVENT:
			return CheckMessage( v );

		/* Flush all events */
		case TERM_XTRA_FLUSH:
			return FlushMessage();

		/* Clear the screen */
		case TERM_XTRA_CLEAR:
		{
			CTerminalWnd* ct = (CTerminalWnd*)acGetCurrentTerm();
			if( !ct ){ return -1; }
			ct->Clear();
			return 0;
		}

		/* React to global changes */
		case TERM_XTRA_REACT:
			return ChangeEnviroment();

		/* Delay for some milliseconds */
		case TERM_XTRA_DELAY:
			Sleep( v );
			return 0;
		}

		/* Unknown event */
		return 1;
	}

	errr hook_curs(int x, int y)
	{
		CTerminalWnd* ct = (CTerminalWnd*)acGetCurrentTerm();
		if( !ct ){ return -1; }

		ct->DrawCurs( x, y );

		return 0;
	}

	errr hook_bigcurs(int x, int y)
	{
		return hook_curs(x,y);
	}

	errr hook_wipe(int x, int y, int n)
	{
		CTerminalWnd* ct = (CTerminalWnd*)acGetCurrentTerm();
		if( !ct ){ return -1; }

		ct->Wipe( x, y, n );

		return 0;
	}

	errr hook_text(int x, int y, int n, byte a, cptr s)
	{
		CTerminalWnd* ct = (CTerminalWnd*)acGetCurrentTerm();
		if( !ct ){ return -1; }

		ct->TextOut( x, y, n, a, s );

		return 0;
	}

	void hook_resize(void)
	{
		return;
	}
}
