#pragma once

#include "wfc.h"

#include "../z-term.h"

class CTerminalWnd : public CWfcWndChild
{
public:
	CTerminalWnd();
	~CTerminalWnd();

	BOOL Create( CWfcWnd* owner );
	void ChangeFont( LPCTSTR section );
	void InitTerm( int termnum, int keysize );

	void DrawCurs( int x, int y );
	void Wipe( int x, int y, int n );
	void TextOut( int x, int y, int n, byte a, LPCSTR s );
	void Clear(void);

	virtual void Show( int cmd = SW_SHOW );

protected:
	LRESULT onPaint( HDC dc );
	LRESULT onSize( WORD cx, WORD cy, DWORD type );
	LRESULT onLButtonDown( WORD px, WORD py, DWORD flag );

private:
	int _cols;        // (by charctor)
	int _rows;        // s(by charctor)

	CWfcFont _font;
	HPEN   _curPen;
	HBRUSH _wallBrush; // Ǘpp^[uV

	term _term;        // hengband^[~if[^
	int  _termID;
	BOOL _isMainTerm; // C^[~iۂ
	BOOL _isDirection;
};

void init_color();
errr CheckMessage(BOOL block);
errr FlushMessage(void);
errr ChangeEnviroment(void);

extern "C"{
	// Callback functions for HENGBAND
	errr hook_user(int n);
	errr hook_xtra(int n, int v);
	errr hook_curs(int x, int y);
	errr hook_bigcurs(int x, int y);
	errr hook_wipe(int x, int y, int n);
	errr hook_text(int x, int y, int n, byte a, cptr s);
	void hook_resize(void);
}

