/*
	DLLGNX|[g֐
*/

#include <windows.h>
#include <Winbase.h>

#ifdef WINCE
#include <altcecrt.h>
#endif

#pragma comment(linker, "/nodefaultlib:libc.lib")
#pragma comment(linker, "/nodefaultlib:libcd.lib")


#include "interface.h"
#include "wfcstr.h"

extern "C" {
	#define friend _friend
	#include "../angband.h"
	#undef friend 
}

void check_dir(cptr path);
void check_file(cptr path);

extern void initFdHandle(void);
extern void initCurrentDir( LPCTSTR curDir );

static CWfcStr _moduleFilename(MAX_PATH);
static bool s_isInit = false;
static char s_holdedPref[256];

BOOL APIENTRY DllMain( HANDLE hModule, 
                       DWORD  ul_reason_for_call, 
                       LPVOID lpReserved
					 )
{
	switch (ul_reason_for_call)
	{
	case DLL_PROCESS_ATTACH:
		GetModuleFileName( (HMODULE)hModule, _moduleFilename, MAX_PATH );
		break;
	case DLL_THREAD_ATTACH:
	case DLL_THREAD_DETACH:
	case DLL_PROCESS_DETACH:
		break;
	}

    return TRUE;
}

DLL_API LPCTSTR acGetDLLFilepath()
{
	return _moduleFilename;
}

DLL_API void acPlayGame( const char* filepath )
{
	if( filepath )
	{
		strcpy_s( savefile, 1024, filepath );
		play_game( FALSE );
	}
	else
	{
		play_game(TRUE);
	}
	quit(NULL);
}

DLL_API void acSendQuitKey(void)
{
	Term_key_push( SPECIAL_KEY_QUIT );
}

DLL_API void acSaveData(void)
{
	do_cmd_save_game( FALSE );
}


DLL_API void acInitTerm( void* lpTerm, int cols, int rows, int keysize )
{
	term_init( (term*)lpTerm, cols, rows, keysize );
}

DLL_API void acSetTerm( int termID, void* lpTerm )
{
	angband_term[termID] = (term*)lpTerm;
}

DLL_API void acActivateTerm( int termID )
{
	Term_activate( angband_term[termID] );
}

DLL_API void acRedrawTerm( int termID )
{
	Term_activate( angband_term[termID] );
	Term_redraw();
	Term_activate( term_screen );
}

DLL_API void acResizeTerm( int termID, int cols, int rows )
{
	Term_activate( angband_term[termID] );
	Term_resize( cols, rows );
	Term_activate( term_screen );
}

DLL_API void* acGetCurrentTerm()
{
	return Term->data;
}

DLL_API void acTermKeypress( int key )
{
	Term_keypress( key );
}

DLL_API void acInitAngband(void)
{
	init_angband();
	if( s_holdedPref[0] )
	{
		process_pref_file( s_holdedPref );
		s_holdedPref[0] = '\0';
	}
	s_isInit = true;
}

DLL_API unsigned long acGetColorValue( int color )
{
	BYTE r = angband_color_table[color][1];
	BYTE g = angband_color_table[color][2];
	BYTE b = angband_color_table[color][3];
	return RGB(r,g,b);
}

DLL_API void acSetSysHook( hook_proc warn_hook, hook_proc quit_hook )
{
	plog_aux = warn_hook;
	quit_aux = quit_hook;
	core_aux = quit_hook;
}

DLL_API void acSetSysParam( const char* sys, const char* kbd )
{
	ANGBAND_SYS = sys;
	ANGBAND_KEYBOARD = kbd;
}

DLL_API void acProcessPrefFile( const char* filename )
{
	if( s_isInit )
	{
		process_pref_file( filename );
	}
	else
	{
		strcpy_s( s_holdedPref, 256, filename );
	}
}

DLL_API const char* acGetSaveDir(void)
{
	return ANGBAND_DIR_SAVE;
}

DLL_API const char* acGetSaveBase(void)
{
	return savefile_base;
}

DLL_API const char* acGetUserDir(void)
{
	return ANGBAND_DIR_USER;
}

DLL_API void acInitPath( LPCWSTR libPath )
{
#ifdef WINCE
	initFdHandle();
#endif

	CWfcStr path( MAX_PATH );

	if( libPath )
	{
		path = libPath;
	}
	else
	{
		GetModuleFileName( NULL, path, MAX_PATH );
		path.TruncateTail( _T('\\') );
		path += _T("\\lib");
	}

	check_dir( path.GetStr() );
#ifdef WINCE
	initCurrentDir( path );
#endif

	path += _T("\\");

	/* Init the file paths */
	init_file_paths( path.GetStr() );

	check_dir(ANGBAND_DIR_APEX);
	check_dir(ANGBAND_DIR_BONE);
	check_dir(ANGBAND_DIR_EDIT);
	check_dir(ANGBAND_DIR_DATA);
	check_dir(ANGBAND_DIR_FILE);
	check_dir(ANGBAND_DIR_HELP);
	check_dir(ANGBAND_DIR_INFO);
	check_dir(ANGBAND_DIR_PREF);
	check_dir(ANGBAND_DIR_SAVE);
	check_dir(ANGBAND_DIR_USER);
//	check_dir(ANGBAND_DIR_XTRA);
}


void check_dir(cptr path)
{
	CWfcStr wpath( path );
	DWORD attrib;

	attrib = GetFileAttributes( wpath );

	if ( (attrib == -1) || !(attrib & FILE_ATTRIBUTE_DIRECTORY) ){
#ifdef JP
		quit_fmt("KvȃfBNg[%s]܂B", path);
#else
		quit_fmt("Cannot find required directory:\n%s", path);
#endif
	}

	return;
}

void check_file(cptr path)
{
	CWfcStr wpath( path );
	DWORD attrib;

	attrib = GetFileAttributes( wpath );

	if ( (attrib == -1) || (attrib & FILE_ATTRIBUTE_DIRECTORY) ){
#ifdef JP
		quit_fmt("Kvȃt@C[%s]܂B", path);
#else
		quit_fmt("Cannot find required file:\n%s", path);
#endif
	}

	return;
}
