
#ifdef DLL_EXPORTS
#define DLL_API __declspec(dllexport)
#else
#define DLL_API __declspec(dllimport)
#endif

typedef void (*hook_proc)(const char*);

DLL_API LPCWSTR acGetDLLFilepath();

DLL_API void acInitAngband(void);
DLL_API void acInitPath( LPCWSTR libPath );
DLL_API void acSetSysParam( const char* sys, const char* kbd );
DLL_API void acSetSysHook( hook_proc wawn_hook, hook_proc quit_hook );
DLL_API void acProcessPrefFile( const char* filename );

DLL_API void acPlayGame( const char* filepath );

DLL_API void acInitTerm( void* lpTerm, int cols, int rows, int keysize );
DLL_API void acSetTerm( int termID, void* lpTerm );

DLL_API void acActivateTerm( int termID );
DLL_API void acRedrawTerm( int termID );
DLL_API void acResizeTerm( int termID, int cols, int rows );
DLL_API unsigned long acGetColorValue( int color );
DLL_API void* acGetCurrentTerm();

DLL_API void acTermKeypress( int key );

DLL_API void acSendQuitKey(void);
DLL_API void acSaveData(void);

DLL_API const char* acGetSaveDir(void);
DLL_API const char* acGetSaveBase(void);
DLL_API const char* acGetUserDir(void);
