/*
	WindowsMobileCRTɂč팸ꂽW֐Ȃ
*/
#include <windows.h>
#include <altcecrt.h>

#include <stdio.h>
#include <time.h>
#include <sys/stat.h>

#include "wfcstr.h"

#define MAX_OPEN_FILE 256

CWfcStr g_currentDir;
HANDLE g_fdHandle[MAX_OPEN_FILE];

/* NULLł͂ȂAINVALID_HANDLE_VALUEŏ */
void initFdHandle(void)
{
	for( int i = 0; i < MAX_OPEN_FILE; i++ )
	{
		g_fdHandle[i] = INVALID_HANDLE_VALUE;
	}
}

/* tmpnam()p̃fBNg */
void initCurrentDir( LPCTSTR curDir )
{
	g_currentDir = curDir;
}


/* for winmm */

DWORD WINAPI timeGetTime(VOID)
{
	return GetTickCount();
}

#define FTIME_SCALE 10000000
/*
	FILETIME^64bitunsigned^̐ŁA
	MSDNɂΒPʂ10^-7sec(100imb)ƂƂ炵if[^́j
*/

#define FTIME_DIFF  134774
/*
	FILETIME̊Jn(1601-Jan-1)UNIX EPOC(1970-Jan-1)̍
	369N([N89)134774
	̏ꍇA2106N(*)ɃI[o[t[邪A
	̑OWindowsCEtime_t^64bitɂȂ鎖҂
	(*:Windowsłtime_t^unsignedňĂ)
*/


extern "C"{
	#include <sys/stat.h>
	#include <io.h>
	#include <stdio.h>
	#include <fcntl.h>

/* for internal use */

	time_t toTimet( const FILETIME *ft )
	{
		unsigned __int64 t;
		t = ft->dwHighDateTime;
		t <<= 32;
		t |= ft->dwLowDateTime;
		t /= FTIME_SCALE;
		t -= FTIME_DIFF;
		return (time_t)t;
	}

	void toFtime( time_t time, FILETIME *ft )
	{
		unsigned __int64 t;
		t  = time;
		t += FTIME_DIFF;
		t *= FTIME_SCALE;

		ft->dwHighDateTime = (DWORD)( t >> 32 );
		ft->dwLowDateTime  = (DWORD)t;
	}


/* for 'stat.h' */

	int __cdecl fstat(int fd, struct stat * s)
	{
		FILETIME ct, at, mt;

		if( fd < 0 || fd >= MAX_OPEN_FILE ){ return -1; }
		if( !s ){ return -1; }

		/* ^CX^v̂ */
		if( GetFileTime( g_fdHandle[fd], &ct, &at, &mt ) )
		{
			s->st_atime = toTimet( &at );
			s->st_mtime = toTimet( &mt );
			s->st_ctime = toTimet( &ct );

			return 0;
		}
		return -1;
	}

	int __cdecl stat(const char * fn, struct stat * s)
	{
		FILETIME ct, at, mt;
		HANDLE fh;

		if( !fn || !s ){ return -1; }

		CWfcStr wpath( fn );

		fh = CreateFile( wpath, GENERIC_READ, 0, NULL, OPEN_EXISTING, FILE_ATTRIBUTE_NORMAL, NULL );

		/* ^CX^v̂ */
		if( ( fh != INVALID_HANDLE_VALUE ) && GetFileTime( fh, &ct, &at, &mt ) )
		{
			s->st_atime = toTimet( &at );
			s->st_mtime = toTimet( &mt );
			s->st_ctime = toTimet( &ct );

			CloseHandle( fh );
			return 0;
		}
		return -1;
	}

/* for 'stdio.h' */

/*
	fopen()̓T|[gĂ炵̂At@CpXɃ}`oCg
	(Shift-JIS)gƃI[vɎs悤Ȃ̂ŁA
	_wfopen()g悤ɏC
*/
	_CRTIMP FILE * __cdecl _wrp_fopen(const char *fn, const char *mode)
	{
		CWfcStr wfn( fn );
		CWfcStr wmode( mode );
#ifdef UNICODE
		FILE* fp = _wfopen( (LPCTSTR)wfn, (LPCTSTR)wmode );
#else
		FILE* fp = _wfopen( wfn.GetWStr(), wmode.GetWStr() );
#endif
		return fp;
	}

	char* __cdecl tmpnam(char *str)
	{
		static CWfcStr s_wpath( MAX_PATH );

		GetTempFileName( g_currentDir, _T("tmp"), 0, s_wpath );

		return s_wpath.GetStr();
	}

	void __cdecl rewind(FILE *fp)
	{
		fseek(fp, 0, SEEK_SET);
	}

	int __cdecl remove(const char *fn)
	{
		if( !fn ){ return -1; }

		CWfcStr wpath( fn );

		if( DeleteFile( wpath ) ){ return -1; }

		return 0;
	}

	int __cdecl rename(const char *ofn, const char *nfn)
	{
		if( !ofn || !nfn ){ return -1; }

		CWfcStr wofn( ofn );
		CWfcStr wnfn( nfn );

		if( !MoveFile( wofn, wnfn ) ){ return -1; }

		return 0;
	}

/* for 'io.h' */

	int __cdecl open(const char *fn, int flag, ...)
	{
		/* pmode͎gpȂ */

		if( !fn ){ return -1; }

		int fd = 1; /* fd̊Jn1 */

		DWORD dwAccess = 0;
		DWORD dwShare  = 0;
		DWORD dwCreate = 0;

		/* gpfď */
		while( fd < MAX_OPEN_FILE )
		{
			if( g_fdHandle[fd] == INVALID_HANDLE_VALUE ){ break; }
			fd++;
		}
		if( fd >= MAX_OPEN_FILE )
		{
			return -1;
		}

		/* check flag */
		if( flag & _O_CREAT )
		{
			dwAccess |= GENERIC_WRITE;

			if( flag & _O_EXCL )
			{
				dwCreate = CREATE_NEW;
			}
			else
			{
				dwCreate = OPEN_ALWAYS;
			}
		}
		else
		{
			/* CreatełȂꍇA݂t@Ĉ݂ΏۂƂ */
			dwCreate = OPEN_EXISTING;
		}

		if( flag & _O_RDWR )
		{
			dwAccess = GENERIC_READ | GENERIC_WRITE;
		}
		else if( flag & _O_WRONLY  )
		{
			dwAccess = GENERIC_WRITE;
		} 
		else
		{
			dwAccess = GENERIC_READ;
		} 

		CWfcStr wpath( fn );

		g_fdHandle[fd] = CreateFile( wpath, dwAccess, dwShare, NULL, dwCreate,
				FILE_ATTRIBUTE_NORMAL, NULL );


		if( g_fdHandle[fd] == INVALID_HANDLE_VALUE ){
			return -1; 
		}

		/* O_TRUNC̏ꍇAt@COɂ */
		if( flag & _O_TRUNC )
		{
			SetFilePointer( g_fdHandle[fd], 0, NULL, FILE_BEGIN );
			SetEndOfFile( g_fdHandle[fd] );
		}

		/* O_APPEND̏ꍇAt@CGhɃV[N */
		if( flag & _O_APPEND )
		{
			SetFilePointer( g_fdHandle[fd], 0, NULL, FILE_END );
		}

		return fd;
	}


	int __cdecl read(int fd, void *buf, unsigned int count)
	{
		DWORD rcount;

		if( fd < 0 || fd >= MAX_OPEN_FILE ){ return -1; }
		if( g_fdHandle[fd] == INVALID_HANDLE_VALUE ){ return -1; }

		if( !ReadFile( g_fdHandle[fd], buf, count, &rcount, NULL ) ){ return -1; }
		return (int)rcount;
	}

	int __cdecl write(int fd, const void *buf, unsigned int count)
	{
		DWORD wcount;

		if( fd < 0 || fd >= MAX_OPEN_FILE ){ return -1; }
		if( g_fdHandle[fd] == INVALID_HANDLE_VALUE ){ return -1; }

		if( !WriteFile( g_fdHandle[fd], buf, count, &wcount, NULL ) ){ return -1; }
		return (int)wcount;
	}


	int __cdecl close(int fd)
	{
		if( fd < 0 || fd >= MAX_OPEN_FILE ){ return -1; }
		if( g_fdHandle[fd] == INVALID_HANDLE_VALUE ){ return -1; }

		if( !CloseHandle( g_fdHandle[fd] ) ){ return -1; }
		g_fdHandle[fd] = INVALID_HANDLE_VALUE;
		return 0;
	}

	long __cdecl lseek(int fd, long offset, int origin)
	{
		DWORD method = FILE_BEGIN;
		int pt;

		if( fd < 0 || fd >= MAX_OPEN_FILE ){ return -1; }
		if( g_fdHandle[fd] == INVALID_HANDLE_VALUE ){ return -1; }

		if( origin == SEEK_SET ){ method = FILE_BEGIN; }
		if( origin == SEEK_CUR ){ method = FILE_CURRENT; }
		if( origin == SEEK_END ){ method = FILE_END; }

		pt = (int)SetFilePointer( g_fdHandle[fd], offset, NULL, method );

		if( pt == INVALID_SET_FILE_POINTER )
		{
			return -1;
		}
		return pt;
	}


	/* for 'time.h' */

	time_t __cdecl time(time_t *pt)
	{
		SYSTEMTIME st;
		FILETIME   ft;

		GetSystemTime( &st );
		SystemTimeToFileTime( &st, &ft );

		time_t ret = toTimet( &ft );

		if( pt ){ *pt = ret; }
		return ret;
	}

	/* GetTickCount()unsigned longԂ̂ŁAŏʃrbg͖ */
	clock_t __cdecl clock(void)
	{
		return (clock_t)( GetTickCount() & 0x7fffffff );
	}

	char * __cdecl ctime(const time_t* tm)
	{
		const char* dname[] = { "Sun", "Mon", "Tue", "Wed", "Thu", "Fri", "Sat" };
		const char* mname[] = { "", "Jan", "Feb", "Mar", "Apr", "May", 
				"Jun", "Jul", "Aug", "Sep", "Oct", "Nov", "Dec" };

		static char s_str[64];

		FILETIME   ft; /* UTC */
		FILETIME   lt; /* LocalFileTime */
		SYSTEMTIME st; /* Local SystemTime */

		if( !tm ){ return NULL; }

		toFtime( *tm, &ft );
		FileTimeToLocalFileTime( &ft, &lt );
		FileTimeToSystemTime( &lt, &st );

		sprintf( s_str, "%3s %3s %2d %02d:%02d:%02d %4d",
				dname[st.wDayOfWeek], mname[st.wMonth],
				st.wHour, st.wMinute, st.wSecond, st.wYear );

		return s_str;
	}

	struct tm * __cdecl localtime(const time_t *tm)
	{
		static struct tm s_tm;

		FILETIME   ft; /* UTC */
		FILETIME   lt; /* LocalFileTime */
		SYSTEMTIME st; /* Local SystemTime */

		if( !tm ){ return NULL; }

		toFtime( *tm, &ft );
		FileTimeToLocalFileTime( &ft, &lt );
		FileTimeToSystemTime( &lt, &st );

		s_tm.tm_sec   = st.wSecond;
		s_tm.tm_min   = st.wMinute;
		s_tm.tm_hour  = st.wHour;
		s_tm.tm_mday  = st.wDay;
		s_tm.tm_mon   = st.wMonth;
		s_tm.tm_year  = st.wYear - 1900;
		s_tm.tm_wday  = st.wDayOfWeek;
		s_tm.tm_yday  = 0; // not use
		s_tm.tm_isdst = 0; // not use

		return &s_tm;
	}

	size_t __cdecl strftime(char* buf, size_t bsize,
			const char* fstr, const struct tm* lt )
	{
		const char* dname[] = { "Sun", "Mon", "Tue", "Wed", "Thu", "Fri", "Sat" };
		const char* mname[] = { "", "Jan", "Feb", "Mar", "Apr", "May", 
				"Jun", "Jul", "Aug", "Sep", "Oct", "Nov", "Dec" };

		if( !buf || !fstr || !lt ){ return 0; }

		CWfcStr str;
		CWfcStr fs( fstr );
		wchar_t* pfs = fs.GetWStr();
		wchar_t tmp[128];

		while( *pfs )
		{
			if( *pfs == L'%' )
			{
				pfs++;
				switch( *pfs )
				{
				case L'a':
				case L'A': // %AZkŏo
					str += dname[ lt->tm_wday ];
					break;
				case L'b':
				case L'B': // %BZkŏo
				case L'h':
					str += mname[ lt->tm_mon ];
					break;
				case L'c':
				case L'x':
					swprintf( tmp, L"%4d/%02d/%02d", lt->tm_year+1900, lt->tm_mon, lt->tm_mday );
					str += tmp;
					break;
				case L'C':
					swprintf( tmp, L"%d", (lt->tm_year+1900)/100 );
					str += tmp;
					break;
				case L'd':
					swprintf( tmp, L"%02d", lt->tm_mday );
					str += tmp;
					break;
				case L'e':
					swprintf( tmp, L"%2d", lt->tm_mday );
					str += tmp;
					break;
				case L'F':
					swprintf( tmp, L"%4d-%02d-%02d", lt->tm_year+1900, lt->tm_mon, lt->tm_mday );
					str += tmp;
					break;
				case L'g':
					swprintf( tmp, L"%02d", lt->tm_year / 100 );
					str += tmp;
					break;
				case L'H':
					swprintf( tmp, L"%02d", lt->tm_hour );
					str += tmp;
					break;
				case L'I':
					swprintf( tmp, L"%02d", ( lt->tm_hour + 11 ) % 12 + 1 );
					str += tmp;
					break;
				case L'k':
					swprintf( tmp, L"%2d", lt->tm_hour );
					str += tmp;
					break;
				case L'l':
					swprintf( tmp, L"%2d", ( lt->tm_hour + 11 ) % 12 + 1 );
					str += tmp;
					break;
				case L'm':
					swprintf( tmp, L"%02d", lt->tm_mon );
					str += tmp;
					break;
				case L'M':
					swprintf( tmp, L"%02d", lt->tm_min );
					str += tmp;
					break;
				case L'n':
					str += L"\n";
					break;
				case 'P': // P[͎QƂȂ
					str += (lt->tm_hour<12)?L"AM":L"PM";
					break;
				case 'p': // P[͎QƂȂ
					str += (lt->tm_hour<12)?L"am":L"pm";
					break;
				case L'R':
				case L'X':
					swprintf( tmp, L"%02d:%02d", lt->tm_hour, lt->tm_min );
					str += tmp;
					break;
				case L'S':
					swprintf( tmp, L"%02d", lt->tm_sec );
					str += tmp;
					break;			
				case L't':
					str += L"\t";
					break;
				case L'T':
					swprintf( tmp, L"%02d:%02d:%02d", lt->tm_hour, lt->tm_min, lt->tm_sec );
					str += tmp;
					break;
				case L'u':
					swprintf( tmp, L"%d", ( lt->tm_wday + 6 ) % 7 + 1 );
					str += tmp;
					break;
				case L'w':
					swprintf( tmp, L"%d", lt->tm_wday );
					str += tmp;
					break;
				case L'y':
					swprintf( tmp, L"%02d", lt->tm_year % 100 );
					str += tmp;
					break;
				case L'Y':
					swprintf( tmp, L"%04d", lt->tm_year + 1090 );
					str += tmp;
					break;
				case L'%':
					str += L"%";
					break;
				}
			}
			else
			{
				tmp[0] = *pfs;
				tmp[1] = *pfs;
				str += tmp;
			}
			pfs++;
		}

		char* ps = str.GetStr();

		size_t t;
		for( t = 0; t < bsize-1; t++ )
		{
			if( ps[t] == '\0' ){ break; }
			buf[t] = ps[t];
		}
		buf[t] = '\0';
		return t;
	}
}
