/*
	WindownAPIȂǂ̃bp[NX
	MFC̑pƍlĂ
*/

#include "wfc.h"
#include "wfcstr.h"


#ifdef WINCE
#include <aygshell.h>
#endif

// Class CWfcWnd

#define CHK_FLG(a,b) (((a)&(b))==(b))

ATOM CWfcWnd::s_wfcClassAtom = 0;

LRESULT CALLBACK CWfcWnd::WfcWndProc( HWND hw, UINT msg, WPARAM wp, LPARAM lp )
{
	if( msg == WM_CREATE )
	{
		CREATESTRUCT* cs = (CREATESTRUCT*)lp;
		CWfcWnd* cw = (CWfcWnd*)cs->lpCreateParams;
		if( cw )
		{
			SetWindowLong( hw, GWL_USERDATA, (LONG)cs->lpCreateParams );
			cw->_hWnd = hw;
			return cw->onCreate();
		}
		else
		{
			return -1;
		}
	}

	CWfcWnd* cw = (CWfcWnd*)GetWindowLong( hw, GWL_USERDATA );
	if( cw )
	{
		switch( msg )
		{
		case WM_PAINT:
			{
				cw->ReleaseDC();
				PAINTSTRUCT ps;
				cw->_hdc = BeginPaint( cw->_hWnd, &ps );
				cw->_isPainting = TRUE;
				LRESULT ret = cw->onPaint( cw->_hdc );
				cw->_isPainting = FALSE;
				EndPaint( cw->_hWnd, &ps );
				cw->_hdc = NULL;
				return ret;
			}
		case WM_KEYDOWN:
			return cw->onKeyDown( LOWORD(wp), LOWORD(lp), HIWORD(lp) );
		case WM_KEYUP:
			return cw->onKeyUp( LOWORD(wp), LOWORD(lp), HIWORD(lp) );
		case WM_CHAR:
			return cw->onChar( LOWORD(wp), LOWORD(lp), HIWORD(lp) );
		case WM_SIZE:
			return cw->onSize( LOWORD(lp), HIWORD(lp), (DWORD)wp );
		case WM_TIMER:
			return cw->onTimer( (DWORD)wp );
		case WM_LBUTTONDOWN:
			return cw->onLButtonDown( LOWORD(lp), HIWORD(lp), (DWORD)wp );
		case WM_LBUTTONUP:
			return cw->onLButtonUp( LOWORD(lp), HIWORD(lp), (DWORD)wp );
		case WM_COMMAND:
			return cw->onCommand( LOWORD(wp), HIWORD(wp), (HANDLE)lp );
		case WM_CLOSE:
			return cw->onClose();
		case WM_DESTROY:
			return cw->onDestroy();
		default:
			return cw->onMessage( msg, wp, lp );
		}
	}
	return DefWindowProc( hw, msg, wp, lp );
}

CWfcWnd::CWfcWnd( HMENU menu, RECT* wr, HBRUSH bkBrush )
{
	_hInst  = NULL;
	_hWnd   = NULL;
	_hMenu  = menu;
	_hdc    = NULL;
	_owner  = NULL;

	_isPainting = FALSE;

	if( wr )
	{
		_ox = wr->left;
		_oy = wr->top;
		_width  = wr->right  - wr->left;
		_height = wr->bottom - wr->top;
	}
	else
	{
		_ox     = CW_USEDEFAULT;
		_oy     = CW_USEDEFAULT;
		_width  = CW_USEDEFAULT;
		_height = CW_USEDEFAULT;
	}

	if( bkBrush )
	{
		_hBkBrush = bkBrush;
	}
	else
	{
		_hBkBrush = (HBRUSH)GetStockObject( BLACK_BRUSH );
	}
}

CWfcWnd::~CWfcWnd()
{

}

BOOL CWfcWnd::Create( LPCTSTR wndTitle, DWORD style, DWORD exStyle )
{
	_hInst = GetModuleHandle( NULL );

	HWND ow = NULL;
	if( _owner ){ ow = _owner->_hWnd; }

	LPCTSTR wndcls = (LPCTSTR)getClassAtom();
	_hWnd = CreateWindowEx( exStyle, wndcls, wndTitle, style,
		_ox, _oy, _width, _height,
		ow, _hMenu, _hInst, (void*)this );

	if( !_hWnd ){ return FALSE; }

	RECT wr;
	GetWindowRect( _hWnd, &wr );
	_ox = wr.left;
	_oy = wr.top;
	_width  = wr.right - wr.left;
	_height = wr.bottom - wr.top;

	return TRUE;
}

/* WindowClass̑do^̓G[ɂȂ̂ŁÂݓo^ */
ATOM CWfcWnd::getClassAtom()
{
	if( !s_wfcClassAtom )
	{
		WNDCLASS wc = {0};
		wc.style         = CS_HREDRAW | CS_VREDRAW;
		wc.lpfnWndProc   = CWfcWnd::WfcWndProc;
		wc.hInstance     = _hInst;
		wc.hbrBackground = _hBkBrush;
		wc.lpszClassName = WFC_WND_CLASS;

		wc.hCursor       = LoadCursor( NULL, IDC_ARROW );

		s_wfcClassAtom   = RegisterClass(&wc);
	}
	return s_wfcClassAtom;
}

HDC  CWfcWnd::GetDC(void)
{
	if( !_hdc )
	{
		_hdc = ::GetDC( _hWnd );
	}

	return _hdc;
}

void CWfcWnd::ReleaseDC(void)
{
	if( _hdc && !_isPainting )
	{
		::ReleaseDC( _hWnd, _hdc );
		_hdc = NULL;
	}
}

void CWfcWnd::UpdateWindow(void)
{
	::InvalidateRect( _hWnd, NULL, false );
	::UpdateWindow( _hWnd );
}

void CWfcWnd::Show( int cmd  )
{
	ShowWindow( _hWnd, cmd );
}


void CWfcWnd::MoveWindow( RECT& rt, BOOL redraw )
{
	_ox = rt.left;
	_oy = rt.top;
	_width  = rt.right  - rt.left;
	_height = rt.bottom - rt.top;

	if( _width > 0 && _height > 0 )
	{
		::MoveWindow( _hWnd, _ox, _oy, _width, _height, redraw );
	}
	else
	{
		Show( SW_HIDE );
	}
}

/* bZ[Wnh̊NX\bhF{Iɋ֐ */
LRESULT CWfcWnd::onCreate()
{
	return 0;
}

LRESULT CWfcWnd::onPaint( HDC dc )
{
	return DefWindowProc( _hWnd, WM_PAINT, 0, 0 );
}

LRESULT CWfcWnd::onKeyDown( WORD key, WORD rept, WORD flag )
{
	return 0;
}

LRESULT CWfcWnd::onKeyUp( WORD key, WORD rept, WORD flag )
{
	return 0;
}

LRESULT CWfcWnd::onChar( WORD key, WORD rept, WORD flag )
{
	return 0;
}

LRESULT CWfcWnd::onSize( WORD cx, WORD cy, DWORD type )
{
	return 0;
}

LRESULT CWfcWnd::onTimer( DWORD id )
{
	return 0;
}

LRESULT CWfcWnd::onLButtonDown( WORD px, WORD py, DWORD flag )
{
	return 0;
}

LRESULT CWfcWnd::onLButtonUp( WORD px, WORD py, DWORD flag )
{
	return 0;
}
LRESULT CWfcWnd::onCommand( WORD cmd, WORD flag, HANDLE sender )
{
	return 0;
}

LRESULT CWfcWnd::onClose(void)
{
	return DefWindowProc( _hWnd, WM_CLOSE, 0, 0 );
}

LRESULT CWfcWnd::onDestroy(void)
{
	return DefWindowProc( _hWnd, WM_DESTROY, 0, 0 );
}

LRESULT CWfcWnd::onMessage( UINT msg, WPARAM wp, LPARAM lp )
{
	return DefWindowProc( _hWnd, msg, wp, lp );
}


// Class CWfcWndChild

/* ChildWindowID͒ʏgȂ̂ŁAŃioO */
DWORD CWfcWndChild::s_idCounter = 0x0A008001;

CWfcWndChild::CWfcWndChild( enum ChildWndPosition cwp,
			RECT* wr ,HBRUSH bkBrush )
	: CWfcWnd( (HMENU)(s_idCounter++), wr, bkBrush )
{
	_cwp = (enum ChildWndPosition)cwp;
}

CWfcWndChild::~CWfcWndChild()
{

}

BOOL CWfcWndChild::Create( CWfcWnd* owner, LPCTSTR wndTitle,
		DWORD style, DWORD exStyle )
{
	_owner = owner;
	return CWfcWnd::Create( wndTitle, style | WS_CHILD, exStyle );
}

/* ^ꂽRECTɁAݒ肳ꂽtOɉĔzuύX */
void CWfcWndChild::AdjustClientArea( RECT& ownerRect )
{
	int orw = ownerRect.right  - ownerRect.left;
	int orh = ownerRect.bottom - ownerRect.top;

	if( orw < 0 || orh < 0 ){
		_width  = 0;
		_height = 0;
		::MoveWindow( _hWnd, _ox, _oy, 0, 0, FALSE );
		return;
	}

	if( CHK_FLG( _cwp, HORIZONTAL ) )
	{
		_width = orw;
		_ox = ownerRect.left;
	}
	else
	{
		if( _cwp & CLIP_LEFT )
		{
			_ox = ownerRect.left;
		}
		else if( _cwp & CLIP_RIGHT )
		{
			_ox = ownerRect.right - _width;
		}
	}

	if( CHK_FLG( _cwp, VERTICAL ) )
	{
		_height = orh;
		_oy = ownerRect.top;
	}
	else
	{
		if( _cwp & CLIP_TOP )
		{
			_oy = ownerRect.top;
		}
		else if( _cwp & CLIP_BOTTOM )
		{
			_oy = ownerRect.bottom - _height;
		}
	}
	::MoveWindow( _hWnd, _ox, _oy, _width, _height, TRUE );

	/* REDUCEnZbgĂꍇA^ꂽRECTύX */
	if( isVisible() ){
		if( CHK_FLG( _cwp, REDUCE_LEFT   ) ){ ownerRect.left   += _width; }
		if( CHK_FLG( _cwp, REDUCE_RIGHT  ) ){ ownerRect.right  -= _width; }
		if( CHK_FLG( _cwp, REDUCE_TOP    ) ){ ownerRect.top    += _height; }
		if( CHK_FLG( _cwp, REDUCE_BOTTOM ) ){ ownerRect.bottom -= _height; }
	}
}


// Class CWfcDialog

INT_PTR CALLBACK CWfcDialog::WfcDialogProc( HWND hw, UINT msg, WPARAM wp, LPARAM lp )
{
	if( msg == WM_INITDIALOG )
	{
		if( lp )
		{
			SetWindowLong( hw, GWL_USERDATA, (LONG)lp );
			((CWfcDialog*)lp)->_hWnd = hw;
			return  ((CWfcDialog*)lp)->onInitDialog();
		}
	}

	CWfcDialog* cw = (CWfcDialog*)GetWindowLong( hw, GWL_USERDATA );

	if( cw )
	{
		if( msg == WM_COMMAND )
		{
			if( LOWORD(wp) == IDOK )
			{
				cw->onOK();
			}
			else if( LOWORD(wp) == IDCANCEL )
			{
				cw->onCancel();
			}
			else
			{
				cw->onCommand( (DWORD)wp, (HWND)lp );
			}
		}
		else if( msg == WM_PAINT )
		{
			cw->onPaint();
		}
		else if( msg == WM_DRAWITEM )
		{
			cw->onDrawItem( (DRAWITEMSTRUCT*)lp );
		}
		else
		{
			return cw->onWndMsg( msg, wp, lp );
		}
	}
	return FALSE;
}

CWfcDialog::CWfcDialog()
{
	_hWnd = NULL;
}

CWfcDialog::~CWfcDialog()
{
}

INT_PTR CWfcDialog::DoModal( WORD dlgID, HWND owner )
{
	return DialogBoxParam( GetModuleHandle(NULL),
				MAKEINTRESOURCE(dlgID), owner,
				CWfcDialog::WfcDialogProc, (LPARAM)this );
}

void CWfcDialog::UpdateWindow(void)
{
	::InvalidateRect( _hWnd, NULL, false );
	::UpdateWindow( _hWnd );
}

BOOL CWfcDialog::onInitDialog(void)
{
#ifdef _WIN32_WCE
	/* WindowsCEn̏ꍇ͑Sʃ_CAÖׂAPIR[ */

	SHINITDLGINFO shidi = {0};
	
	shidi.dwMask  = SHIDIM_FLAGS;
	shidi.dwFlags = SHIDIF_DONEBUTTON | SHIDIF_SIPDOWN | SHIDIF_SIZEDLGFULLSCREEN | SHIDIF_EMPTYMENU;
	shidi.hDlg    = _hWnd;

	SetForegroundWindow(_hWnd);

	SHInitDialog(&shidi);
#endif
	return FALSE;
}

BOOL CWfcDialog::onWndMsg( UINT msg, WPARAM wp, LPARAM lp )
{
	return FALSE;
}

void CWfcDialog::onOK(void)
{
	EndDialog( _hWnd, TRUE );
	return;
}

void CWfcDialog::onCancel(void)
{
	EndDialog( _hWnd, FALSE );
	return;
}

void CWfcDialog::onCommand( DWORD notify, HWND hitem )
{
	return;
}

void CWfcDialog::onPaint()
{
	return;
}

void CWfcDialog::onDrawItem( DRAWITEMSTRUCT* di )
{
	return;
}

// Class CWfcDialog Helper Funtions

/* _CAO{bNXACeɌ肵֐ł͂Ȃcc */
BOOL CWfcDialog::GetItemText( HWND hwi, CWfcStr& str )
{
	if( !hwi ){ return FALSE; }

	int len = GetWindowTextLength( hwi );
	if( len )
	{
		str.Alloc( len+1 );
		if( GetWindowText( hwi, str, len+1 ) )
		{
			return TRUE;
		}
	}
	return FALSE;
}

int  CWfcDialog::GetItemInt( HWND hwi )
{
	CWfcStr str;
	if( !GetItemText( hwi, str ) ){ return 0; }

	return _ttoi( str );
}

/* Xg{bNXp */
int  CWfcDialog::LB_AddStr( HWND hlb, LPCTSTR str )
{
	if( !hlb ){ return FALSE; }
	return SendMessage( hlb, LB_ADDSTRING, 0, (LPARAM)str );
}

BOOL CWfcDialog::LB_SetCurSel( HWND hlb, int idx )
{
	if( !hlb ){ return FALSE; }
	return ( SendMessage( hlb, LB_SETCURSEL, idx, 0 ) != CB_ERR );
}

BOOL CWfcDialog::LB_GetText( HWND hlb, CWfcStr& str )
{
	if( !hlb ){ return FALSE; }

	int idx = LB_GetCurSel( hlb );

	if( idx == LB_ERR )
	{
		str = _T("");
		return FALSE;
	}
	else
	{
		int len = SendMessage( hlb, LB_GETTEXTLEN, idx, 0 );
		if( len )
		{
			str.Alloc( len + 1 );
			if( SendMessage( hlb, LB_GETTEXT, idx, (LPARAM)((LPTSTR)str) ) )
			{
				return TRUE;
			}
		}
	}
	return FALSE;
}

int  CWfcDialog::LB_GetInt( HWND hlb )
{
	CWfcStr str;
	if( !LB_GetText( hlb, str ) ){ return -1; }

	return _ttoi( str );
}

/* R{{bNXp */
int CWfcDialog::CB_AddStr( HWND hcb, LPCTSTR str )
{
	if( !hcb ){ return FALSE; }
	return SendMessage( hcb, CB_ADDSTRING, 0, (LPARAM)str );
}

BOOL CWfcDialog::CB_SetCurSel( HWND hcb, int idx )
{
	if( !hcb ){ return FALSE; }
	return ( SendMessage( hcb, CB_SETCURSEL, idx, 0 ) != CB_ERR );
}

BOOL CWfcDialog::CB_GetText( HWND hcb, CWfcStr& str )
{
	if( !hcb ){ return FALSE; }

	int idx = CB_GetCurSel( hcb );

	if( idx == CB_ERR )
	{
		GetItemText( hcb, str );
	}
	else
	{
		int len = SendMessage( hcb, CB_GETLBTEXTLEN, idx, 0 );
		if( len )
		{
			str.Alloc( len + 1 );
			if( SendMessage( hcb, CB_GETLBTEXT, idx, (LPARAM)((LPTSTR)str) ) )
			{
				return TRUE;
			}
		}
	}
	return FALSE;
}

int  CWfcDialog::CB_GetInt( HWND hcb )
{
	CWfcStr str;
	if( !CB_GetText( hcb, str ) ){ return -1; }

	return _ttoi( str );
}


// Class CWfcFont

CWfcFont::CWfcFont() :
	_hFont(NULL), _size(1), _chPitch(0), _lfPitch(0), _fixedPitch(FALSE)
{

}

CWfcFont::~CWfcFont()
{
	if( _hFont ){ DeleteObject( _hFont ); }
}

BOOL CWfcFont::Create( int size, LPCTSTR fontface,
		BOOL bold, BOOL ctype, BOOL fixedPitch, int chPitch, int lfPitch )
{
	_size = size;
	_fixedPitch = fixedPitch;
	_chPitch = fixedPitch?chPitch:0; // Œsb`̎̂ݗL
	_lfPitch = lfPitch;

	if( _chPitch + _size <= 0 ){ _chPitch = 0; }
	if( _lfPitch + _size <= 0 ){ _lfPitch = 0; }

	if( size <= 0  ){ size = 1; }

	LOGFONT lf = {0};
	lf.lfHeight = -(size*2); // absolute height
#ifdef JP
	lf.lfCharSet = SHIFTJIS_CHARSET;
#endif

#ifdef WINCE
	lf.lfQuality = ctype?CLEARTYPE_QUALITY:DEFAULT_QUALITY;
#else
	lf.lfQuality = ctype?ANTIALIASED_QUALITY:DEFAULT_QUALITY;
#endif
	lf.lfWeight  = bold?FW_BOLD:FW_NORMAL;

	if( !fontface || !*fontface )
	{
		/* tHgw肪ꍇAŒsb`ۂZbg */
		/* VXeɓKɑI΂ */
		lf.lfPitchAndFamily = fixedPitch?FIXED_PITCH:VARIABLE_PITCH;
	}
	else
	{
#ifdef UNICODE
		wcscpy_s( lf.lfFaceName, LF_FACESIZE, fontface );
#else
		strcpy_s( lf.lfFaceName, LF_FACESIZE, fontface );
#endif
	}

	HFONT hf = CreateFontIndirect( &lf );
	if( hf )
	{
		if( _hFont ){ DeleteObject( _hFont ); }
		_hFont = hf;
		return TRUE;
	}
	return FALSE;
}

BOOL CWfcFont::Draw( HDC dc, int x, int y, int len, const LPCTSTR str,
		DWORD opt, RECT* rc ) const
{
	int* pdx = NULL;
	RECT lrc = {0};

	if( opt && !rc )
	{
		lrc.left   = x; 
		lrc.top    = y;
		lrc.right  = x + ( len * Width() );
		lrc.bottom = y + Height();
		rc = &lrc;
	}
	x += _chPitch / 2; // NA^CṽS~΍ŕʒu𒲐

	if( _fixedPitch )
	{
		/* Œsb`̏ꍇAf[^𐶐Ă */
		/* WindowsAPIɔCƁAɃYo͂邱Ƃ */
		pdx = new int[ len ];
		for( int t = 0; t < len; t++ )
		{
			pdx[t] = _size + _chPitch;
		}
#ifdef UNICODE
		/* UNICODE͑SpPvf̂߁ACĂ */
		for( int t = 1; t < len; t++ )
		{
			/* ȂGcA0x0080ȍ~͑SpƔ */
			/* ASCIIR[hO̔p͎gĂȂccłˁH */
			if( str[t] > 0x7f )
			{
				/* pdx[t] += _size + _chPitch;ƂĂ܂ */
				/* sb`w莞ɔɊĂ܂̂ŁAAA */
				pdx[t-1] += _chPitch;
				pdx[t]   += _size;

				lrc.right += Width();
			}
		}
		if( str[0] > 0x7f )
		{
			/* PڂSp̏ꍇ */
			x += _chPitch;
			pdx[0] += _size;

			lrc.right += Width();
		}
#endif
	}

	HGDIOBJ oldFont = NULL;
	if( _hFont ){ oldFont = SelectObject( dc, _hFont ); }

	BOOL ret = ExtTextOut( dc, x, y, opt, rc, str, len, pdx );

	if( _hFont ){ SelectObject( dc, oldFont ); }

	SAFE_DELETE( pdx );
	return ret;
}