/*
	WindownAPIȂǂ̃bp[NX
	MFC̑pƍlĂ
*/

#pragma once

#include <windows.h>

#ifdef WINCE
#include <altcecrt.h>
#endif

#include "wfcstr.h"

#ifndef SAFE_DELETE
#define SAFE_DELETE(x) if(x){ delete (x); (x)=NULL; }
#endif

#define WFC_WND_CLASS _T("WfcWindowClass")

/* EBhE̊NX */
class CWfcWnd
{
protected:
	static LRESULT CALLBACK WfcWndProc(HWND, UINT, WPARAM, LPARAM);
	static ATOM s_wfcClassAtom;

public:
	CWfcWnd( HMENU menu = NULL, RECT* wr = NULL, HBRUSH bkBrush = NULL );
	virtual ~CWfcWnd();

public:
	virtual BOOL Create( LPCTSTR wndTitle = _T(""),
		DWORD style = 0, DWORD exStyle = 0 );

	BOOL isVisible(){ return IsWindowVisible( _hWnd ); }
	BOOL isValid(){ return _hWnd?TRUE:FALSE; }

	HWND SetFocus(void){ return ::SetFocus( _hWnd ); }

	HWND GetWnd(){ return _hWnd; }
	HDC  GetDC(void);
	void ReleaseDC(void);
	void UpdateWindow(void);

	void Hide(void){ Show( SW_HIDE ); }

	virtual void Show( int cmd = SW_SHOW );
	virtual void MoveWindow( RECT& rt, BOOL redraw = FALSE );

	LRESULT SendMessage( UINT msg, WPARAM wp, LPARAM lp )
	{
		return ::SendMessage( _hWnd, msg, wp, lp );
	}
	BOOL PostMessage( UINT msg, WPARAM wp, LPARAM lp )
	{
		return ::PostMessage(  _hWnd, msg, wp, lp );
	}

	operator HWND(){ return _hWnd; }

protected:
	virtual ATOM getClassAtom(void);
	virtual LRESULT onCreate();

protected:
	virtual LRESULT onPaint( HDC dc );
	virtual LRESULT onKeyDown( WORD key, WORD rept, WORD flag );
	virtual LRESULT onKeyUp( WORD key, WORD rept, WORD flag );
	virtual LRESULT onChar( WORD key, WORD rept, WORD flag );
	virtual LRESULT onSize( WORD cx, WORD cy, DWORD type );
	virtual LRESULT onTimer( DWORD id );
	virtual LRESULT onLButtonDown( WORD px, WORD py, DWORD flag );
	virtual LRESULT onLButtonUp( WORD px, WORD py, DWORD flag );
	virtual LRESULT onCommand( WORD cmd, WORD flag, HANDLE sender );
	virtual LRESULT onClose(void);
	virtual LRESULT onDestroy(void);
	virtual LRESULT onMessage( UINT msg, WPARAM wp, LPARAM lp );

protected:
	HINSTANCE _hInst;
	HWND   _hWnd;
	HBRUSH _hBkBrush;
	HMENU  _hMenu;
	int    _ox, _oy, _width, _height;
	HDC    _hdc;
	BOOL   _isPainting;

	/* CWfcWndChild瑀 */
	CWfcWnd* _owner;
};

/* qEBhE̊NX */
class CWfcWndChild : public CWfcWnd
{
public:
	/* AdjustClientArea()̋ */
	enum ChildWndPosition
	{
		DEFAULT      = 0,

		CLIP_LEFT    = 1,
		CLIP_RIGHT   = 2,
		CLIP_TOP     = 4,
		CLIP_BOTTOM  = 8,

		REDUCE_LEFT   = 64,
		REDUCE_RIGHT  = 128,
		REDUCE_TOP    = 256,
		REDUCE_BOTTOM = 512,

		HORIZONTAL   = CLIP_LEFT  | CLIP_RIGHT,
		VERTICAL     = CLIP_TOP   | CLIP_BOTTOM,
		CORNER_LT    = CLIP_LEFT  | CLIP_TOP,
		CORNER_RT    = CLIP_RIGHT | CLIP_TOP,
		CORNER_LB    = CLIP_LEFT  | CLIP_BOTTOM,
		CORNER_RB    = CLIP_RIGHT | CLIP_BOTTOM,

		BAR_LEFT      = CLIP_LEFT  | VERTICAL   | REDUCE_LEFT,
		BAR_RIGHT     = CLIP_RIGHT | VERTICAL   | REDUCE_RIGHT,
		BAR_TOP       = CLIP_TOP   | HORIZONTAL | REDUCE_TOP,
		BAR_BOTTOM    = CLIP_BOTTOM| HORIZONTAL | REDUCE_BOTTOM
	};

private:
	static DWORD s_idCounter;

public:
	CWfcWndChild( enum ChildWndPosition cwp = DEFAULT,
		RECT* wr = NULL, HBRUSH bkBrush = NULL );
	virtual ~CWfcWndChild();

public:
	virtual BOOL Create( CWfcWnd* owner, LPCTSTR wndTitle = _T(""),
		DWORD style = 0, DWORD exStyle = 0 );

	virtual void AdjustClientArea( RECT& ownerRect );

	void SetDefaultSize( int width, int height )
	{
		_width  = width;
		_height = height;
	}

	void SetPosition( enum ChildWndPosition cwp )
	{
		_cwp = cwp;
	}

protected:
	enum ChildWndPosition _cwp;
};


#define NOTIFY(i,m) MAKELONG(i,m)

class CWfcDialog
{
	static INT_PTR CALLBACK WfcDialogProc(HWND, UINT, WPARAM, LPARAM);

public:
	static BOOL GetItemText( HWND hwi, CWfcStr& str );
	static int  GetItemInt( HWND hwi );

	static int  LB_AddStr( HWND hlb, LPCTSTR str );
	static BOOL LB_SetCurSel( HWND hlb, int idx );
	static BOOL LB_GetText( HWND hlb, CWfcStr& str );
	static int  LB_GetInt( HWND hlb );
	static int LB_GetCurSel( HWND hlb )
	{
		return SendMessage( hlb, LB_GETCURSEL, 0, 0 );
	}

	static int  CB_AddStr( HWND hcb, LPCTSTR str );
	static BOOL CB_SetCurSel( HWND hcb, int idx );
	static BOOL CB_GetText( HWND hcb, CWfcStr& str );
	static int  CB_GetInt( HWND hcb );
	static int CB_GetCurSel( HWND hcb )
	{
		return SendMessage( hcb, CB_GETCURSEL, 0, 0 );
	}

	static void EnableItem( HWND hwi, BOOL enable )
	{
		if( hwi ){ EnableWindow( hwi, enable ); }
	}

public:
	CWfcDialog();
	virtual ~CWfcDialog();

	virtual INT_PTR DoModal( WORD dlgID, HWND owner );

	void UpdateWindow(void);
	
	HWND GetItem( int id ){ return GetDlgItem( _hWnd, id ); }

	void SetItemText( int id, LPCTSTR str )
	{
		SetDlgItemText( _hWnd, id, str );
	}
	void SetItemInt( int id, int num )
	{
		SetDlgItemInt( _hWnd, id, num, FALSE );
	}

	BOOL GetItemText( int id, CWfcStr& str )
	{
		return GetItemText( GetItem(id), str );
	}
	int GetItemInt( int id )
	{
		return GetItemInt( GetItem(id) );
	}

	void SetButtonState( int id, DWORD state )
	{
		CheckDlgButton( _hWnd, id, state );
	}

	DWORD GetButtonState( int id )
	{
		return IsDlgButtonChecked( _hWnd, id );
	}

	int  LB_AddStr( int id, LPCTSTR str )
	{
		return LB_AddStr( GetItem(id), str );
	}

	BOOL LB_SetCurSel( int id, int idx )
	{
		return LB_SetCurSel( GetItem(id), idx );
	}

	BOOL LB_GetText( int id, CWfcStr& str )
	{
		return LB_GetText( GetItem(id), str );
	}
	int  LB_GetInt( int id )
	{
		return LB_GetInt( GetItem(id) );
	}

	int  LB_GetCurSel( int id )
	{
		return LB_GetCurSel( GetItem(id) );
	}

	int  CB_AddStr( int id, LPCTSTR str )
	{
		return CB_AddStr( GetItem(id), str );
	}

	BOOL CB_SetCurSel( int id, int idx )
	{
		return CB_SetCurSel( GetItem(id), idx );
	}

	BOOL CB_GetText( int id, CWfcStr& str )
	{
		return CB_GetText( GetItem(id), str );
	}

	int  CB_GetInt( int id )
	{
		return CB_GetInt( GetItem(id) );
	}

	int  CB_GetCurSel( int id )
	{
		return CB_GetCurSel( GetItem(id) );
	}

	DWORD IsButtonChecked( int id )
	{
		return IsDlgButtonChecked( _hWnd, id );
	}

	void EnableItem( int id, BOOL enable )
	{
		EnableItem( GetItem(id), enable );
	}

protected:
	virtual BOOL onInitDialog(void);
	virtual BOOL onWndMsg( UINT msg, WPARAM wp, LPARAM lp );
	virtual void onOK(void);
	virtual void onCancel(void);

	virtual void onCommand( DWORD notify, HWND hitem );
	virtual void onPaint();
	virtual void onDrawItem( DRAWITEMSTRUCT* di );
protected:
	HWND   _hWnd;
};

/* tHgAeLXgo͗pNX */
class CWfcFont
{
public:
	CWfcFont();
	~CWfcFont();

	BOOL Create( int size, LPCTSTR fontface = NULL,
		BOOL bold = FALSE, BOOL ctype = FALSE, BOOL fixedPitch = FALSE, 
		int chPitch = 0, int lfPitch = 0 );

	operator HFONT() const { return _hFont; }

	int Width() const { return _size + _chPitch; }
	int Height() const { return (_size*2) + _lfPitch; }

	int GetCharPitch(){ return _chPitch; }
	int GetLinePitch(){ return _lfPitch; }

	BOOL Draw( HDC dc, int x, int y, int len, const LPCTSTR str,
		DWORD opt = 0, RECT* rc = NULL ) const;

	BOOL Draw( HDC dc, int x, int y, const CWfcStr &str,
		DWORD opt = 0, RECT* rc = NULL ) const
	{
		return Draw( dc, x, y, str.Length(), str, opt, rc );
	}

private:
	HFONT _hFont;
	int _size, _chPitch, _lfPitch;
	BOOL _fixedPitch;
};
