/*
	NX
	MFC/ATLɂCStringNX̑pƍlĂ
*/

#include "wfcstr.h"

/* AP[g32Pʂɐ؂グ */
const int CWfcStr::ALLOC_UNIT = 32;

CWfcStr::CWfcStr( size_t len )
	: _alloc(0), _length(0), _str(NULL), _strtmp(NULL)
{
	Alloc( len );
}

CWfcStr::CWfcStr( const CWfcStr& ref)
	: _alloc(0), _length(0), _str(NULL), _strtmp(NULL), _isChecked(false)
{
	copy( ref );
}

CWfcStr::CWfcStr( LPCSTR instr )
	: _alloc(0), _length(0), _str(NULL), _strtmp(NULL), _isChecked(false)
{
#ifdef  UNICODE  
	int len = strlen( instr );
	Alloc( len+1 );
	mbstowcs( _str, instr, len+1 );
	_length = _tcslen( _str );
	_isChecked = true;
#else
	copy( instr );
#endif
}

CWfcStr::CWfcStr( LPCWSTR instr )
	: _alloc(0), _length(0), _str(NULL), _strtmp(NULL), _isChecked(false)
{
#ifdef  UNICODE  
	copy( instr );
#else
	int len = wcslen( instr );
	Alloc( (len*2)+1 );
	wcstombs( _str, instr, (len*2)+1 );
	_length = _tcslen( _str );
	_isChecked = true;
#endif
}


CWfcStr::~CWfcStr()
{
	SAFE_DELETE( _str );
	SAFE_DELETE( _strtmp );
}

void CWfcStr::Alloc( size_t alloc )
{
	if( alloc == 0 ){ alloc = 1; }
	if( alloc <= _alloc ){ return; }

	SAFE_DELETE( _str );
	_alloc = ( alloc + ALLOC_UNIT ) / ALLOC_UNIT * ALLOC_UNIT;
	_str = new TCHAR[_alloc];
	memset( _str, 0, sizeof(TCHAR) * _alloc );
	_length = 0;
	_isChecked = true;
}

void CWfcStr::Realloc( size_t alloc )
{
	if( !_str )
	{
		Alloc( alloc );
		return;
	}

	if( alloc <= _alloc ){ return; }

	checkLength();

	LPTSTR old = _str;
	_alloc = ( alloc + ALLOC_UNIT ) / ALLOC_UNIT * ALLOC_UNIT;
	_str = new TCHAR[_alloc];
	memset( _str, 0, sizeof(TCHAR) * _alloc );
	memcpy( _str, old, sizeof(TCHAR) * (_length+1) );
	delete old;
}

size_t CWfcStr::Truncate( size_t len )
{
	checkLength();
	if( len < _length )
	{
		_str[len] = _T('\0');
		_length = len;
	}
	return _length;
}

void CWfcStr::Trim(void)
{
	LPCTSTR space = _T(" \t\r\n");

	checkLength();
	int sp = 0;
	while( sp < (int)_length )
	{
		bool find = false;
		for( int f = 0; space[f]; f++ )
		{
			if( _str[sp] != space[f] ){ find = true; break; }
		}
		if( find ){ break; }
		sp++;
	}

	int ep = _length - 1;
	while( ep >= 0 )
	{
		bool find = false;
		for( int f = 0; space[f]; f++ )
		{
			if( _str[ep] != space[f] ){ find = true;break; }
		}
		if( find ){ break; }
		ep--;
	}
	if( ep <= sp )
	{
		_length = 0;
		_str[0] = _T('\0');
		return;
	}

	if( sp > 0 )
	{
		for( int t = 0; t + sp < ep; t++ )
		{
			_str[t] = _str[t+sp];
		}
	}
	_length = ep - sp;
	_str[_length] = _T('\0');
	_isChecked = true;
}

int CWfcStr::FindChar( TCHAR find, int sPos ) const
{
	checkLength();
	if( sPos >= (int)_length ){ return -1; }

	if( sPos < 0 ){ sPos = 0; }
	for( int t = sPos; t < (int)_length; t++ )
	{
		if( _str[t] == find ){ return t; }
	}
	return -1;
}

int CWfcStr::FindChar( LPCTSTR find, int sPos ) const
{
	checkLength();
	if( !find ){ return -1; }
	if( sPos >= (int)_length ){ return -1; }

	if( sPos < 0 ){ sPos = 0; }
	for( int t = sPos; t < (int)_length; t++ )
	{
		for( int f = 0; find[f]; f++ )
		{
			if( _str[t] == find[f] ){ return t; }
		}
	}
	return -1;
}

int CWfcStr::FindStr( LPCTSTR find, int sPos ) const
{
	checkLength();
	if( !find ){ return -1; }
	if( sPos >= (int)_length ){ return -1; }

	size_t flen = _tcslen( find );
	if( sPos < 0 ){ sPos = 0; }
	if( (int)_length - (int)flen < sPos ){ return -1; }

	for( unsigned int t = sPos; t <= _length - flen; t++ )
	{
		bool result = true;
		for( int f = 0; find[f]; f++ )
		{
			if( _str[t+f] != find[f] )
			{
				result = false;
				break;
			}
		}
		if( result ){ return t; }
	}
	return -1;
}

int CWfcStr::FindCharRev( TCHAR find, int sPos ) const
{
	checkLength();
	if( sPos < 0 || sPos >= (int)_length ){ sPos = _length - 1; }
	for( int t = sPos; t >= 0; t-- )
	{
		if( _str[t] == find ){ return t; }
	}

	return -1;
}

int CWfcStr::FindCharRev( LPCTSTR find, int sPos ) const
{
	checkLength();
	if( !find ){ return -1; }
	if( sPos < 0 || sPos >= (int)_length ){ sPos = _length - 1; }

	for( unsigned int t = sPos; t >= 0; t-- )
	{
		for( int f = 0; find[f]; f++ )
		{
			if( _str[t] == find[f] ){ return t; }
		}
	}
	return -1;
}

int CWfcStr::FindStrRev( LPCTSTR find, int sPos ) const
{
	checkLength();
	if( !find ){ return -1; }

	size_t flen = _tcslen( find );
	if( _length < flen ){ return -1; }
	if( sPos < 0 || sPos > (int)_length - (int)flen ){ sPos = _length - flen; }

	for( unsigned int t = sPos; t >= 0; t-- )
	{
		bool result = true;
		for( int f = 0; find[f]; f++ )
		{
			if( _str[t+f] != find[f] )
			{
				result = false;
				break;
			}
		}
		if( result ){ return t; }
	}
	return -1;
}

LPCTSTR CWfcStr::Substr( int sPos, int len ) const
{
	checkLength();
	if( sPos >= (int)_length ){ return NULL; }
	if( len < 0 || sPos + len > (int)_length ){ len = _length - sPos; }

	TCHAR* st = new TCHAR[len+1];

	for( int t = 0; t < len; t++ )
	{
		st[t] = _str[t+sPos];
	}
	st[len] = _T('\0');

	SAFE_DELETE( _strtmp );
	_strtmp = st;

	return (LPCTSTR)_strtmp;
}

void CWfcStr::checkLength( void ) const
{
	if( !_isChecked )
	{
		_length = (_str)?_tcslen(_str):0;
		_isChecked = true;
	}
}

LPSTR CWfcStr::GetStr() const
{
	checkLength();
	SAFE_DELETE( _strtmp );

#ifdef  UNICODE  
	_strtmp = new char[(_length*2)+1];
	memset( _strtmp, 0, sizeof(char) * (_length*2)+1 );
	wcstombs( (LPSTR)_strtmp, _str, (_length*2)+1 );
#else
	_strtmp = new char[_length+1];
	memcpy( _str, instr, sizeof(char) * (_length+1) );
#endif
	return (LPSTR)_strtmp;
}

LPWSTR CWfcStr::GetWStr() const
{
	checkLength();

	SAFE_DELETE( _strtmp );
	_strtmp = new WCHAR[_length+1];

#ifdef  UNICODE  
	memcpy( _strtmp, _str, sizeof(WCHAR) * (_length+1) );
#else
	memset( _strtmp, 0, sizeof(WCHAR) * _length+1 );
	mbstowcs( (LPWSTR)_strtmp, _str, _length+1 );
#endif
	return (LPWSTR)_strtmp;
}


CWfcStr& CWfcStr::operator=(const CWfcStr& ref)
{
	copy( ref );
	return *this;
}

CWfcStr& CWfcStr::operator=(LPCSTR instr)
{
#ifdef  UNICODE  
	copy( CWfcStr(instr) );
#else
	copy( instr );
#endif
	return *this;
}

CWfcStr& CWfcStr::operator=(LPCWSTR instr)
{
#ifdef  UNICODE  
	copy( instr );
#else
	copy( CWfcStr(instr) );
#endif
	return *this;
}


CWfcStr& CWfcStr::operator+=(const CWfcStr& ref)
{
	add( ref );
	return *this;
}

CWfcStr& CWfcStr::operator+=(LPCSTR instr)
{
#ifdef  UNICODE  
	add( CWfcStr(instr) );
#else
	add( instr );
#endif
	return *this;
}

CWfcStr& CWfcStr::operator+=(LPCWSTR instr)
{
#ifdef  UNICODE  
	add( instr );
#else
	add( CWfcStr(instr) );
#endif
	return *this;
}

void CWfcStr::copy( LPCTSTR instr )
{
	size_t len = _tcslen( instr );
	Alloc( len+1 );
	memcpy( _str, instr, sizeof(TCHAR) * (len+1) );
	_length = len;
	_isChecked = true;
}

void CWfcStr::copy( const CWfcStr& ref )
{
	size_t len = ref.Length();
	Alloc( len+1 );
	memcpy( _str, ref._str, sizeof(TCHAR) * (len+1) );
	_length = len;
	_isChecked = true;
}

void CWfcStr::add( LPCTSTR instr )
{
	checkLength();
	size_t alen = _tcslen( instr );
	Realloc( _length+alen+1 );
	memcpy( _str+_length, instr, sizeof(TCHAR) * (alen+1) );
	_length += alen;
	_isChecked = true;
}

void CWfcStr::add( const CWfcStr& ref )
{
	checkLength();
	size_t alen = ref.Length();
	Realloc( _length+alen+1 );
	memcpy( _str+_length, ref._str, sizeof(TCHAR) * (alen+1) );
	_length += alen;
	_isChecked = true;
}
