/*
	NX
	MFC/ATLɂCStringNX̑pƍlĂ
*/
#pragma once

#include <windows.h>

#ifdef WINCE
#include <altcecrt.h>
#else
#include <tchar.h>
#endif

#ifndef SAFE_DELETE
#define SAFE_DELETE(x) if(x){ delete (x); (x)=NULL; }
#endif

class CWfcStr
{
	static const int ALLOC_UNIT;

public:
	CWfcStr( size_t len = 0 );
	CWfcStr( const CWfcStr& ref);
	CWfcStr( LPCSTR instr );
	CWfcStr( LPCWSTR instr );
	~CWfcStr();
	
	void Alloc( size_t alloc );
	void Realloc( size_t alloc );

	size_t Truncate( size_t len );
	void Trim(void);

	void TruncateTail( TCHAR chr )
	{
		int p = FindCharRev( chr );
		if( p >= 0 )
		{
			Truncate( (size_t)p );
		}
	}

	int FindChar(   TCHAR find, int sPos = 0 ) const;
	int FindChar( LPCTSTR find, int sPos = 0 ) const;
	int FindStr(  LPCTSTR find, int sPos = 0 ) const; 

	int FindCharRev(   TCHAR find, int sPos = -1 ) const;
	int FindCharRev( LPCTSTR find, int sPos = -1 ) const;
	int FindStrRev(  LPCTSTR find, int sPos = -1 ) const; 

	LPCTSTR Substr( int sPos, int len = -1 ) const;
	LPCTSTR Left( int len ) const { return Substr( 0, len ); }

	void SetChat( size_t pos, TCHAR chr )
	{
		if( pos >= _length ){ return; }
		_str[pos] = chr;
		_length = _tcslen(_str);
	}

	CWfcStr& operator=(const CWfcStr& ref);
	CWfcStr& operator=(LPCSTR instr);
	CWfcStr& operator=(LPCWSTR instr);

	CWfcStr& operator+=(const CWfcStr& ref);
	CWfcStr& operator+=(LPCSTR instr);
	CWfcStr& operator+=(LPCWSTR instr);

	bool operator<(LPCTSTR instr) const 
	{
		return ( _tcscmp( _str, instr ) < 0 );
	}

	bool operator>(LPCTSTR instr) const 
	{
		return ( _tcscmp( _str, instr ) > 0 );
	}

	bool operator==(LPCTSTR instr) const 
	{
		return ( _tcscmp( _str, instr ) == 0 );
	}

	operator LPTSTR(){
		_isChecked = false;
		return _str;
	}

	operator LPCTSTR() const { return _str; }

	size_t Length() const
	{
		checkLength();
		return _length;
	}

	LPSTR  GetStr()  const;
	LPWSTR GetWStr() const;

private:
	void checkLength( void ) const;
	void copy( LPCTSTR instr );
	void copy( const CWfcStr& ref );
	void add( LPCTSTR instr );
	void add( const CWfcStr& ref );

private:
	mutable size_t _length;   // 
	size_t _alloc;            // AP[gĂTCY(TCHAR)
	LPTSTR _str;
	mutable void* _strtmp;
	mutable bool  _isChecked; // _length`FbNĂ邩
};
