#include "angband.h"

#define MAX_SNIPE_POWERS 14

typedef struct snipe_power snipe_power;
struct snipe_power
{
	int     min_lev;
	int     mana_cost;
	const char *name;
};

static const char *snipe_tips[MAX_SNIPE_POWERS] =
{
#ifdef JP
	"椹롣ͷΰϡ٤夬ꡢ٤ʼͷѤѤǤ褦ˤʤ롣",
	"ġ˼夤󥹥˰Ϥȯ롣",
	"ͷԤä塢ûΥνְִưԤ",
	"б°ġ",
	"ɤʴդġǤǤ󥹥̵ʪΥ󥹥˰Ϥȯ롣",
	"䵤°ġ",
	"Ũ̲餻ġ",
	"ŷ°ġ",
	"ʣṲ̃ġ",
	"ŨͤФġ",
	"2ͷԤ",
	"ȯġ",
	"ɤʥ󥹥˰Ϥȯġ",
	"ٰʥ󥹥˰Ϥȯġ",
#else
	"yet.",
	"yet.",
	"yet.",
	"yet.",
	"yet.",
	"yet.",
	"yet.",
	"yet.",
	"yet.",
	"yet.",
	"yet.",
	"yet.",
	"yet.",
	"yet.",
#endif
};

snipe_power snipe_powers[MAX_SNIPE_POWERS] =
{
	/* Level gained,  cost,  name */
#ifdef JP
	{  1,  0,  "" },
	{  2,  1,  "եå奢" },
	{  3,  2,  "塼ȡ" },
	{  5,  1,  "б" },
	{  8,  3,  "դ" },
	{ 10,  2,  "䵤" },
	{ 12,  2,  "" },
	{ 18,  3,  "ץ饺ޥܥ" },
	{ 20,  5,  "" },
	{ 25,  4,  ""},
	{ 28,  5,  "֥륷å" },
	{ 32,  3,  "ȯ"},
	{ 35,  5,  "ǰ"},
	{ 42,  5,  "" },
#else
	{  1,  1,  "Concentration" },
	{  2,  1,  "Flush Arrow" },
	{  3,  2,  "Shoot & Away" },
	{  5,  2,  "Fire Shot" },
	{  8,  2,  "Shatter Arrow" },
	{ 10,  2,  "Ice Shot" },
	{ 12,  3,  "Anesthesia" },
	{ 18,  3,  "Plasma Bolt" },
	{ 20,  4,  "Piercing Shot" },
	{ 25,  4,  "Rushing Arrow"},
	{ 28,  5,  "Double Shot" },
	{ 32,  5,  "Missile"},
	{ 35,  5,  "Evil Shot"},
	{ 42,  5,  "Holy Shot" },
#endif
};


bool snipe_concentrate(void)
{
	if ((int)p_ptr->concent < (5 + (p_ptr->lev + 5) / 10)) p_ptr->concent++;

#ifdef JP
	msg_format("椷( %d)", p_ptr->concent);
#else
	msg_format("You concentrate deeply. (lvl %d)", p_ptr->concent);
#endif

	reset_concent = FALSE;

	/* Update the monsters */
	p_ptr->update |= (PU_MONSTERS);

	return (TRUE);
}

void reset_concentration(bool msg)
{
	if (msg)
	{
#ifdef JP
		msg_print("ϤڤƤޤä");
#else
		msg_print("Stop concentrating.");
#endif
	}

	p_ptr->concent = 0;
	reset_concent = FALSE;

	/* Update the monsters */
	p_ptr->update |= (PU_MONSTERS);
}

int boost_concentration_damage(int tdam)
{
	tdam *= (5 + p_ptr->concent);
	tdam /= 5;

	return (tdam);
}

void display_snipe_list(void)
{
	int             i;
	int             y = 1;
	int             x = 1;
	int             plev = p_ptr->lev;
	snipe_power     spell;
	char            psi_desc[80];

	/* Display a list of spells */
	prt("", y, x);
#ifdef JP
	put_str("̾", y, x + 5);
	put_str("Lv   MP", y, x + 35);
#else
	put_str("Name", y, x + 5);
	put_str("Lv Mana", y, x + 35);
#endif

	/* Dump the spells */
	for (i = 0; i < MAX_SNIPE_POWERS; i++)
	{
		/* Access the available spell */
		spell = snipe_powers[i];
		if (spell.min_lev > plev) continue;
		if (spell.mana_cost > (int)p_ptr->concent) continue;

		/* Dump the spell */
		sprintf(psi_desc, "  %c) %-30s%2d %4d",
			I2A(i), spell.name, spell.min_lev, spell.mana_cost);

		Term_putstr(x, y + i + 1, -1, TERM_WHITE, psi_desc);
	}
	return;
}


/*
 * Allow user to choose a mindcrafter power.
 *
 * If a valid spell is chosen, saves it in '*sn' and returns TRUE
 * If the user hits escape, returns FALSE, and set '*sn' to -1
 * If there are no legal choices, returns FALSE, and sets '*sn' to -2
 *
 * The "prompt" should be "cast", "recite", or "study"
 * The "known" should be TRUE for cast/pray, FALSE for study
 *
 * nb: This function has a (trivial) display bug which will be obvious
 * when you run it. It's probably easy to fix but I haven't tried,
 * sorry.
 */
static int get_snipe_power(int *sn, bool only_browse)
{
	int             i;
	int             num = 0;
	int             y = 1;
	int             x = 20;
	int             plev = p_ptr->lev;
	int             ask;
	char            choice;
	char            out_val[160];
#ifdef JP
	cptr            p = "ͷ";
#else
	cptr            p = "power";
#endif
	snipe_power     spell;
	bool            flag, redraw;

	/* Assume cancelled */
	*sn = (-1);

#ifdef ALLOW_REPEAT /* TNB */

	/* Get the spell, if available */
	if (repeat_pull(sn))
	{
		/* Verify the spell */
		if ((snipe_powers[*sn].min_lev <= plev) && (snipe_powers[*sn].mana_cost <= (int)p_ptr->concent))
		{
			/* Success */
			return (TRUE);
		}
	}

#endif /* ALLOW_REPEAT -- TNB */

	/* Nothing chosen yet */
	flag = FALSE;

	/* No redraw yet */
	redraw = FALSE;

	for (i = 0; i < MAX_SNIPE_POWERS; i++)
	{
		if ((snipe_powers[i].min_lev <= plev) &&
			((only_browse) || (snipe_powers[i].mana_cost <= (int)p_ptr->concent)))
		{
			num = i;
		}
	}

	/* Build a prompt (accept all spells) */
	if (only_browse)
	{
#ifdef JP
		(void)strnfmt(out_val, 78, "(%^s %c-%c, '*'ǰ, ESC) ɤ%sˤĤΤޤ",
#else
		(void)strnfmt(out_val, 78, "(%^ss %c-%c, *=List, ESC=exit) Use which %s? ",
#endif
			      p, I2A(0), I2A(num), p);
	}
	else
	{
#ifdef JP
		(void)strnfmt(out_val, 78, "(%^s %c-%c, '*'ǰ, ESC) ɤ%sȤޤ",
#else
		(void)strnfmt(out_val, 78, "(%^ss %c-%c, *=List, ESC=exit) Use which %s? ",
#endif
			  p, I2A(0), I2A(num), p);
	}

	/* Get a spell from the user */
	choice = always_show_list ? ESCAPE : 1;
	while (!flag)
	{
		if(choice == ESCAPE) choice = ' ';
		else if( !get_com(out_val, &choice) )break; 

		/* Request redraw */
		if ((choice == ' ') || (choice == '*') || (choice == '?'))
		{
			/* Show the list */
			if (!redraw)
			{
				char psi_desc[80];

				/* Show list */
				redraw = TRUE;

				/* Save the screen */
				screen_save();

				/* Display a list of spells */
				prt("", y, x);
#ifdef JP
				put_str("̾", y, x + 5);
				if (only_browse) put_str("Lv   ", y, x + 35);
#else
				put_str("Name", y, x + 5);
				if (only_browse) put_str("Lv Pow", y, x + 35);
#endif

				/* Dump the spells */
				for (i = 0; i < MAX_SNIPE_POWERS; i++)
				{
					Term_erase(x, y + i + 1, 255);

					/* Access the spell */
					spell = snipe_powers[i];
					if (spell.min_lev > plev) continue;
					if (!only_browse && (spell.mana_cost > (int)p_ptr->concent)) continue;

					/* Dump the spell --(-- */
					if (only_browse)
						sprintf(psi_desc, "  %c) %-30s%2d %4d",
							I2A(i), spell.name,	spell.min_lev, spell.mana_cost);
					else
						sprintf(psi_desc, "  %c) %-30s%", I2A(i), spell.name);
					prt(psi_desc, y + i + 1, x);
				}

				/* Clear the bottom line */
				prt("", y + i + 1, x);
			}

			/* Hide the list */
			else
			{
				/* Hide list */
				redraw = FALSE;

				/* Restore the screen */
				screen_load();
			}

			/* Redo asking */
			continue;
		}

		/* Note verify */
		ask = isupper(choice);

		/* Lowercase */
		if (ask) choice = tolower(choice);

		/* Extract request */
		i = (islower(choice) ? A2I(choice) : -1);

		/* Totally Illegal */
		if ((i < 0) || (i > num) || 
			(!only_browse &&(snipe_powers[i].mana_cost > (int)p_ptr->concent)))
		{
			bell();
			continue;
		}

		/* Save the spell index */
		spell = snipe_powers[i];

		/* Verify it */
		if (ask)
		{
			char tmp_val[160];

			/* Prompt */
#ifdef JP
			(void) strnfmt(tmp_val, 78, "%sȤޤ", snipe_powers[i].name);
#else
			(void)strnfmt(tmp_val, 78, "Use %s? ", snipe_powers[i].name);
#endif

			/* Belay that order */
			if (!get_check(tmp_val)) continue;
		}

		/* Stop the loop */
		flag = TRUE;
	}

	/* Restore the screen */
	if (redraw) screen_load();

	/* Show choices */
	if (show_choices)
	{
		/* Update */
		p_ptr->window |= (PW_SPELL);

		/* Window stuff */
		window_stuff();
	}

	/* Abort if needed */
	if (!flag) return (FALSE);

	/* Save the choice */
	(*sn) = i;

#ifdef ALLOW_REPEAT /* TNB */

	repeat_push(*sn);

#endif /* ALLOW_REPEAT -- TNB */

	/* Success */
	return (TRUE);
}


int tot_dam_aux_snipe (int mult, monster_type *m_ptr)
{
	monster_race *r_ptr = &r_info[m_ptr->r_idx];
	bool seen = is_seen(m_ptr);

	switch (snipe_type)
	{
	case SP_LITE:
		if (r_ptr->flags3 & (RF3_HURT_LITE))
		{
			int n = 15 + p_ptr->concent;
			if (seen) r_ptr->r_flags3 |= (RF3_HURT_LITE);
			if (mult < n) mult = n;
		}
		break;
	case SP_FIRE:
		if (r_ptr->flags3 & RF3_IM_FIRE)
		{
			if (seen) r_ptr->r_flags3 |= RF3_IM_FIRE;
		}
		else
		{
			int n = 10 + p_ptr->concent * 2;
			if (mult < n) mult = n;
		}
		break;
	case SP_COLD:
		if (r_ptr->flags3 & RF3_IM_COLD)
		{
			if (seen) r_ptr->r_flags3 |= RF3_IM_COLD;
		}
		else
		{
			int n = 10 + p_ptr->concent * 2;
			if (mult < n) mult = n;
		}
		break;
	case SP_ELEC:
		if (r_ptr->flags3 & RF3_IM_ELEC)
		{
			if (seen) r_ptr->r_flags3 |= RF3_IM_ELEC;
		}
		else
		{
			int n = 10 + p_ptr->concent * 2;
			if (mult < n) mult = n;
		}
	case SP_KILL_WALL:
		if (r_ptr->flags3 & RF3_HURT_ROCK)
		{
			int n = 15 + p_ptr->concent;
			if (seen) r_ptr->r_flags3 |= RF3_HURT_ROCK;
			if (mult < n) mult = n;
		}
		else if (r_ptr->flags3 & RF3_NONLIVING)
		{
			int n = 15 + p_ptr->concent;
			if (seen) r_ptr->r_flags3 |= RF3_NONLIVING;
			if (mult < n) mult = n;
		}
		break;
	case SP_EVILNESS:
		if (r_ptr->flags3 & RF3_GOOD)
		{
			int n = 15 + p_ptr->concent;
			if (seen) r_ptr->r_flags3 |= RF3_GOOD;
			if (mult < n) mult = n;
		}
		break;
	case SP_HOLYNESS:
		if (r_ptr->flags3 & RF3_EVIL)
		{
			int n = 15 + p_ptr->concent;
			if (seen) r_ptr->r_flags3 |= RF3_EVIL;
			if (mult < n) mult = n;
		}
		break;
	}

	return (mult);
}

/*
 * do_cmd_cast calls this function if the player's class
 * is 'mindcrafter'.
 */
static bool cast_sniper_spell(int spell)
{
	object_type *o_ptr = &inventory[INVEN_BOW];

	if (o_ptr->tval != TV_BOW)
	{
#ifdef JP
		msg_print("ݤƤʤ");
#else
		msg_print("You wield no bow!");
#endif
		return (FALSE);
	}

	/* spell code */
	switch (spell)
	{
	case 0: /* Concentration */
		if (!snipe_concentrate()) return (FALSE);
		return (TRUE);
	case 1: snipe_type = SP_LITE; break;
	case 2: snipe_type = SP_AWAY; break;
	case 3: snipe_type = SP_FIRE; break;
	case 4: snipe_type = SP_KILL_WALL; break;
	case 5: snipe_type = SP_COLD; break;
	case 6: snipe_type = SP_PARALYZE; break;
	case 7: snipe_type = SP_ELEC; break;
	case 8: snipe_type = SP_PIERCE; break;
	case 9: snipe_type = SP_RUSH; break;
	case 10: snipe_type = SP_DOUBLE; break;
	case 11: snipe_type = SP_EXPLODE; break;
	case 12: snipe_type = SP_EVILNESS; break;
	case 13: snipe_type = SP_HOLYNESS; break;
	default:
#ifdef JP
		msg_print("ʤˡ");
#else
		msg_print("Zap?");
#endif
	}

	do_cmd_fire();
	snipe_type = 0;

	return TRUE;
}


/*
 * do_cmd_cast calls this function if the player's class
 * is 'mindcrafter'.
 */
void do_cmd_snipe(void)
{
	int             n = 0;
	int             plev = p_ptr->lev;
	int             old_chp = p_ptr->chp;
	snipe_power     spell;
	bool            cast;


	/* not if confused */
	if (p_ptr->confused)
	{
#ifdef JP
		msg_print("𤷤ƤƽǤʤ");
#else
		msg_print("You are too confused!");
#endif
		return;
	}

	/* get power */
	if (!get_snipe_power(&n, FALSE)) return;

	spell = snipe_powers[n];

	sound(SOUND_ZAP);

	/* Cast the spell */
	cast = cast_sniper_spell(n);

	if (!cast) return;

	/* Take a turn */
	energy_use = 100;

	/* Redraw mana */
	p_ptr->redraw |= (PR_HP | PR_MANA);

	/* Window stuff */
	p_ptr->window |= (PW_PLAYER);
	p_ptr->window |= (PW_SPELL);
}

/*
 * do_cmd_cast calls this function if the player's class
 * is 'mindcrafter'.
 */
void do_cmd_snipe_browse(void)
{
	int n = 0;
	int j, line;
	char temp[62 * 5];

	screen_save();

	while(1)
	{
		/* get power */
		if (!get_snipe_power(&n, TRUE))
		{
			screen_load();
			return;
		}

		/* Clear lines, position cursor  (really should use strlen here) */
		Term_erase(12, 21, 255);
		Term_erase(12, 20, 255);
		Term_erase(12, 19, 255);
		Term_erase(12, 18, 255);
		Term_erase(12, 17, 255);
		Term_erase(12, 16, 255);

		roff_to_buf(snipe_tips[n], 62, temp, sizeof(temp));
		for(j = 0, line = 17; temp[j]; j += (1 + strlen(&temp[j])))
		{
			prt(&temp[j], line, 15);
			line++;
		}
	}
}
