/* File: birth.c */

/* Purpose: create a player character */

/*
 * Copyright (c) 1989 James E. Wilson, Robert A. Koeneke
 *
 * This software may be copied and distributed for educational, research, and
 * not for profit purposes provided that this copyright and statement are
 * included in all such copies.
 */

#include "angband.h"

/*
 * How often the autoroller will update the display and pause
 * to check for user interuptions.
 * Bigger values will make the autoroller faster, but slower
 * system may have problems because the user can't stop the
 * autoroller for this number of rolls.
 */
#define AUTOROLLER_STEP		25L

/*
 * Maximum number of tries for selection of a proper quest monster
 */
#define MAX_TRIES 100

/*
 * Forward declare
 */
typedef struct birther birther;

/*
 * A structure to hold "rolled" information
 */
struct birther
{
	s16b age;
	s16b wt;
	s16b ht;
	s16b sc;

	s32b au;

	s16b stat[6];

	char history[4][60];

	s16b patron;

	s16b hp[PY_MAX_LEVEL];
};



/*
 * The last character displayed
 */
static birther prev;



/*
 * Forward declare
 */
typedef struct hist_type hist_type;

/*
 * Player background information
 */
struct hist_type
{
	cptr info;			    /* Textual History */

	byte roll;			    /* Frequency of this entry */
	byte chart;			    /* Chart index */
	byte next;			    /* Next chart index */
	byte bonus;			    /* Social Class Bonus + 50 */
};


/*
 * Background information (see below)
 *
 * Chart progression by race:
 *   Human         -->  1 -->  2 -->  3 --> 50 --> 51 --> 52 --> 53
 *   Half-Elf      -->  4 -->  1 -->  2 -->  3 --> 50 --> 51 --> 52 --> 53
 *   Elf/High-Elf  -->  7 -->  8 -->  9 --> 54 --> 55 --> 56
 *   Hobbit        --> 10 --> 11 -->  3 --> 50 --> 51 --> 52 --> 53
 *   Gnome         --> 13 --> 14 -->  3 --> 50 --> 51 --> 52 --> 53
 *   Dwarf         --> 16 --> 17 --> 18 --> 57 --> 58 --> 59 --> 60 --> 61
 *   Half-Orc      --> 19 --> 20 -->  2 -->  3 --> 50 --> 51 --> 52 --> 53
 *   Half-Troll    --> 22 --> 23 --> 62 --> 63 --> 64 --> 65 --> 66
 *
 * XXX XXX XXX This table *must* be correct or drastic errors may occur!
 */
static hist_type bg[] =
{
#ifdef JP
	{"ʢλҤǧΤ餵Ƥޤ",			 10, 2, 3, 25},
	{"ʢλҤǤǧΤϤƤޤ",			 20, 2, 3, 35},
	{"ͤλҶΤΰͤǤ",			 95, 2, 3, 45},
	{"ĹҤǤ",						100, 2, 3, 50},
#else
	{"You are the illegitimate and unacknowledged child ",   10, 1, 2, 25},
	{"You are the illegitimate but acknowledged child ",     20, 1, 2, 35},
	{"You are one of several children ",                     95, 1, 2, 45},
	{"You are the first child ",                            100, 1, 2, 50},
#endif


#ifdef JP
	{"ʤۤ",					 40, 1, 2, 65},
	{"ʤϼ",					 65, 1, 2, 80},
	{"ʤĮͤ",					 80, 1, 2, 90},
	{"ʤϿͤ",					 90, 1, 2,105},
	{"ʤεΤ",				 96, 1, 2,120},
	{"ʤϺ٤εμ̤߰뵮²",				 99, 1, 2,130},
	{"ʤϥСβȤηԤ",				100, 1, 2,140},
#else
	{"of a Serf.  ",                                         40, 2, 3, 65},
	{"of a Yeoman.  ",                                       65, 2, 3, 80},
	{"of a Townsman.  ",                                     80, 2, 3, 90},
	{"of a Guildsman.  ",                                    90, 2, 3, 105},
	{"of a Landed Knight.  ",                                96, 2, 3, 120},
	{"of a Noble Family in the Courts of Chaos.  ",          99, 2, 3, 130},
	{"of the Royal Blood Line of Amber.  ",                 100, 2, 3, 140},
#endif


#ifdef JP
	{"ʤϰȤΤʪǤ",				 20, 3,50, 20},
	{"ʤϰȤθؤǤ",				 80, 3,50, 55},
	{"ʤϲ²ڤˤƤޤ",			100, 3,50, 60},
#else
	{"You are the black sheep of the family.  ",             20, 3, 50, 20},
	{"You are a credit to the family.  ",                    80, 3, 50, 55},
	{"You are a well liked child.  ",                       100, 3, 50, 60},
#endif


#ifdef JP
	{"ʤϥƥ²ΥդǤ",		 40, 4, 1, 50},
	{"ʤϥƥ²ΥդǤ",		 75, 4, 1, 55},
	{"ʤϥΥɡ²ΥդǤ",		 90, 4, 1, 55},
	{"ʤϥΥɡ²ΥդǤ",		 95, 4, 1, 60},
	{"ʤϥ䡼²ΥդǤ",		 98, 4, 1, 65},
	{"ʤϥ䡼²ΥդǤ",				100, 4, 1, 70},
#else
	{"Your mother was of the Teleri.  ",			 40, 4, 1, 50},
	{"Your father was of the Teleri.  ",			 75, 4, 1, 55},
	{"Your mother was of the Noldor.  ",		 	 90, 4, 1, 55},
	{"Your father was of the Noldor.  ",		 	 95, 4, 1, 60},
	{"Your mother was of the Vanyar.  ",			 98, 4, 1, 65},
	{"Your father was of the Vanyar.  ",			100, 4, 1, 70},
#endif


#ifdef JP
	{"ͤλҶΤΰͤǤ",			 60, 9, 54, 50},
	{"γǤ",					100, 9, 54, 55},
#else
	{"You are one of several children ",			 60, 7, 8, 50},
	{"You are the only child ",					100, 7, 8, 55},
#endif


#ifdef JP
	{"ʤϥƥ²Υդ",				 75, 7, 8, 50},
	{"ʤϥΥɡ²Υդ",			 95, 7, 8, 55},
	{"ʤϥ䡼²Υդ",			100, 7, 8, 60},
#else
	{"of a Teleri ",						 75, 8, 9, 50},
	{"of a Noldor ",						 95, 8, 9, 55},
	{"of a Vanyar ",						100, 8, 9, 60},
#endif


#ifdef JP
	{"󥸥㡼",					 40, 8,9, 80},
	{"㡼",					 70, 8,9, 90},
	{"Τ",						 87, 8,9,110},
	{"ᥤ",						 95, 8,9,125},
	{"Ҥ",						 99, 8,9,140},
	{"",						100, 8,9,145},
#else
	{"Ranger.  ",						 40, 9, 54, 80},
	{"Archer.  ",						 70, 9, 54, 90},
	{"Warrior.  ",						 87, 9, 54, 110},
	{"Mage.  ",							 95, 9, 54, 125},
	{"Prince.  ",						 99, 9, 54, 140},
	{"King.  ",							100, 9, 54, 145},
#endif


#ifdef JP
	{"ۥӥåȤβͤλҶΤΰͤǤ",		 85,11,3, 45},
	{"ۥӥåȤΰγǤ",			        100,11,3, 55},
#else
	{"You are one of several children of a Hobbit ",		 85, 10, 11, 45},
	{"You are the only child of a Hobbit ",		        100, 10, 11, 55},
#endif


#ifdef JP
	{"ʤϸ𿩤",							 20,10,11, 55},
	{"ʤϵ򲰤Ź",						 30,10,11, 80},
	{"ʤʴ",							 40,10,11, 90},
	{"ʤϲȼ",							 50,10,11,100},
	{"ʤͤ",							 80,10,11,110},
	{"ʤΤ",							 95,10,11,115},
	{"ʤϥᥤ",							 99,10,11,125},
	{"ʤϰ²Ĺ",							100,10,11,140},
#else
	{"Bum.  ",							 20, 11, 3, 55},
	{"Tavern Owner.  ",						 30, 11, 3, 80},
	{"Miller.  ",						 40, 11, 3, 90},
	{"Home Owner.  ",						 50, 11, 3, 100},
	{"Burglar.  ",						 80, 11, 3, 110},
	{"Warrior.  ",						 95, 11, 3, 115},
	{"Mage.  ",							 99, 11, 3, 125},
	{"Clan Elder.  ",						100, 11, 3, 140},
#endif


#ifdef JP
	{"ΡδͤλҶΤΰͤǤ",		 85,14,3, 45},
	{"ΡΰγǤ",			        100,14,3, 55},
#else
	{"You are one of several children of a Gnome ",		 85, 13, 14, 45},
	{"You are the only child of a Gnome ",			100, 13, 14, 55},
#endif


#ifdef JP
	{"ʤʪ𤤤",							 20,13,14, 55},
	{"ʤϥۥ᤭",							 50,13,14, 70},
	{"ʤϤĴҼԤ",							 75,13,14, 85},
	{"ʤΤ",							 95,13,14,100},
	{"ʤϥᥤ",							100,13,14,125},
#else
	{"Beggar.  ",						 20, 14, 3, 55},
	{"Braggart.  ",						 50, 14, 3, 70},
	{"Prankster.  ",						 75, 14, 3, 85},
	{"Warrior.  ",						 95, 14, 3, 100},
	{"Mage.  ",							100, 14, 3, 125},
#endif


#ifdef JP
	{"ɥդͤλҶΤΰͤǤ",		 25,17,18, 40},
	{"ɥդΰγǤ",			        100,17,18, 50},
#else
	{"You are one of two children of a Dwarven ",		 25, 16, 17, 40},
	{"You are the only child of a Dwarven ",			100, 16, 17, 50},
#endif


#ifdef JP
	{"ʤť",							 10,16,17, 60},
	{"ʤϴ֤",							 25,16,17, 75},
	{"ʤϹפ",							 75,16,17, 90},
	{"ʤΤ",							 90,16,17,110},
	{"ʤϥץ꡼Ȥ",					 99,16,17,130},
	{"ʤϲ",							100,16,17,150},
#else
	{"Thief.  ",						 10, 17, 18, 60},
	{"Prison Guard.  ",						 25, 17, 18, 75},
	{"Miner.  ",						 75, 17, 18, 90},
	{"Warrior.  ",						 90, 17, 18, 110},
	{"Priest.  ",						 99, 17, 18, 130},
	{"King.  ",							100, 17, 18, 150},
#endif


#ifdef JP
	{"ʤϰȤΤʪǤ",						 15,18,57,10},
	{"ʤϰȤθؤǤ",						 85,18,57, 50},
	{"ʤϲ²ڤˤƤޤ",				100,18,57, 55},
#else
	{"You are the black sheep of the family.  ",		 15, 18, 57, 10},
	{"You are a credit to the family.  ",			 85, 18, 57, 50},
	{"You are a well liked child.  ",				100, 18, 57, 55},
#endif


#ifdef JP
	{"ʤϥǤ̩ˤƤޤ",	 25,19,20, 25},
	{"ʤϥǤ̩ˤƤޤ",	100,19,20, 25},
#else
	{"Your mother was an Orc, but it is unacknowledged.  ",	 25, 19, 20, 25},
	{"Your father was an Orc, but it is unacknowledged.  ",	100, 19, 20, 25},
#endif


#ifdef JP
	{"ʤܻۤҤǤ",						 40,20, 3, 65},
	{"ʤϼܻҤǤ",						 65,20, 3, 80},
	{"ʤĮܻͤҤǤ",						 80,20, 3, 90},
	{"ʤϿܻͤҤǤ",						 90,20, 3,105},
	{"ʤεΤܻҤǤ",					 96,20, 3,120},
	{"ʤϼ̤߰뵮²ܻҤǤ",				 99,20, 3,130},
	{"ʤϲȤηԤܻҤǤ",			100,20, 3,140},
#else
	{"You are the adopted child ",				100, 20, 2, 50},
#endif


#ifdef JP
	{"ʤƶȥ",				 30,22,23, 20},
	{"ʤƶȥ",				 60,22,23, 25},
	{"ʤϵ֥ȥ",					 75,22,23, 30},
	{"ʤϵ֥ȥ",					 90,22,23, 35},
	{"ʤϿȥ",					 95,22,23, 40},
	{"ʤϿȥ",					100,22,23, 45},
#else
	{"Your mother was a Cave-Troll ",				 30, 22, 23, 20},
	{"Your father was a Cave-Troll ",				 60, 22, 23, 25},
	{"Your mother was a Hill-Troll ",				 75, 22, 23, 30},
	{"Your father was a Hill-Troll ",				 90, 22, 23, 35},
	{"Your mother was a Water-Troll ",				 95, 22, 23, 40},
	{"Your father was a Water-Troll ",				100, 22, 23, 45},
#endif


#ifdef JP
	{"åǤ",							  5,23,62, 60},
	{"ΤǤ",							 95,23,62, 55},
	{"ѻդǤ",							 99,23,62, 65},
	{"²ĹǤ",						100,23,62, 80},
#else
	{"Cook.  ",							  5, 23, 62, 60},
	{"Warrior.  ",						 95, 23, 62, 55},
	{"Shaman.  ",						 99, 23, 62, 65},
	{"Clan Chief.  ",						100, 23, 62, 80},
#endif


#ifdef JP
	{"ʤϿ֥饦Ʒ",				 20,50,51, 50},
	{"ʤϥ֥饦Ʒ",					 60,50,51, 50},
	{"ʤøƷ",					 70,50,51, 50},
	{"ʤϥ꡼Ʒ",					 80,50,51, 50},
	{"ʤĤƷ",						 90,50,51, 50},
	{"ʤϥ֥롼쥤Ʒ",				100,50,51, 50},
#else
	{"You have dark brown eyes, ",				 20, 50, 51, 50},
	{"You have brown eyes, ",					 60, 50, 51, 50},
	{"You have hazel eyes, ",					 70, 50, 51, 50},
	{"You have green eyes, ",					 80, 50, 51, 50},
	{"You have blue eyes, ",					 90, 50, 51, 50},
	{"You have blue-gray eyes, ",				100, 50, 51, 50},
#endif


#ifdef JP
	{"ʤ餫",							 70,51,52, 50},
	{"Ǥä",							 90,51,52, 50},
	{"뤷",							100,51,52, 50},
#else
	{"straight ",						 70, 51, 52, 50},
	{"wavy ",							 90, 51, 52, 50},
	{"curly ",							100, 51, 52, 50},
#endif


#ifdef JP
	{"ȱ",						 30,52,53, 50},
	{"ȱ",						 70,52,53, 50},
	{"Ȥӿȱ",					 80,52,53, 50},
	{"֤ȱ",						 90,52,53, 50},
	{"֥ɤȱ",				100,52,53, 50},
#else
	{"black hair, ",						 30, 52, 53, 50},
	{"brown hair, ",						 70, 52, 53, 50},
	{"auburn hair, ",						 80, 52, 53, 50},
	{"red hair, ",						 90, 52, 53, 50},
	{"blond hair, ",						100, 52, 53, 50},
#endif


#ifdef JP
	{"ȩ򤷤Ƥޤ",					 10,53, 0, 50},
	{"ȩ򤷤Ƥޤ",					 30,53, 0, 50},
	{"̤ȩ򤷤Ƥޤ",				 80,53, 0, 50},
	{"ȩ򤷤Ƥޤ",					 90,53, 0, 50},
	{"Ʃ̤褦ȩ򤷤Ƥޤ",		100,53, 0, 50},
#else
	{"and a very dark complexion.",				 10, 53, 0, 50},
	{"and a dark complexion.",					 30, 53, 0, 50},
	{"and an average complexion.",				 80, 53, 0, 50},
	{"and a fair complexion.",					 90, 53, 0, 50},
	{"and a very fair complexion.",				100, 53, 0, 50},
#endif


#ifdef JP
	{"ʤ뤤졼Ʒ",					 85,54,55, 50},
	{"ʤ뤤֥롼Ʒ",					 95,54,55, 50},
	{"ʤ뤤꡼Ʒ",					100,54,55, 50},
#else
	{"You have light grey eyes, ",				 85, 54, 55, 50},
	{"You have light blue eyes, ",				 95, 54, 55, 50},
	{"You have light green eyes, ",				100, 54, 55, 50},
#endif


#ifdef JP
	{"ʤ餫",							 75,55,56, 50},
	{"Ǥä",							100,55,56, 50},
#else
	{"straight ",						 75, 55, 56, 50},
	{"wavy ",							100, 55, 56, 50},
#endif


#ifdef JP
	{"ȱȩ򤷤Ƥޤ",				 75,56, 0, 50},
	{"ȱȩ򤷤Ƥޤ",				 85,56, 0, 50},
	{"֥ɤȱȩ򤷤Ƥޤ",				 95,56, 0, 50},
	{"ȱȩ򤷤Ƥޤ",				100,56, 0, 50},
#else
	{"black hair, and a fair complexion.",			 75, 56, 0, 50},
	{"brown hair, and a fair complexion.",			 85, 56, 0, 50},
	{"blond hair, and a fair complexion.",			 95, 56, 0, 50},
	{"silver hair, and a fair complexion.",			100, 56, 0, 50},
#endif


#ifdef JP
	{"ʤϿ֥饦Ʒ",					 99,57,58, 50},
	{"ʤϵ֤Ʒ",					100,57,58, 60},
#else
	{"You have dark brown eyes, ",				 99, 57, 58, 50},
	{"You have glowing red eyes, ",				100, 57, 58, 60},
#endif


#ifdef JP
	{"ʤ餫",							 90,58,59, 50},
	{"Ǥä",							100,58,59, 50},
#else
	{"straight ",						 90, 58, 59, 50},
	{"wavy ",							100, 58, 59, 50},
#endif


#ifdef JP
	{"ȱ",						 75,59,60, 50},
	{"ȱ",						100,59,60, 50},
#else
	{"black hair, ",						 75, 59, 60, 50},
	{"brown hair, ",						100, 59, 60, 50},
#endif


#ifdef JP
	{" 30cm ۤɤΥҥ",						 25,60,61, 50},
	{" 60cm ۤɤΥҥ",						 60,60,61, 51},
	{" 90cm ۤɤΥҥ",					 90,60,61, 53},
	{" 1m20cm ۤɤΥҥ ",						100,60,61, 55},
#else
	{"a one foot beard, ",					 25, 60, 61, 50},
	{"a two foot beard, ",					 60, 60, 61, 51},
	{"a three foot beard, ",					 90, 60, 61, 53},
	{"a four foot beard, ",					100, 60, 61, 55},
#endif


#ifdef JP
	{"ȩ򤷤Ƥޤ",					100,61, 0, 50},
#else
	{"and a dark complexion.",					100, 61, 0, 50},
#endif


#ifdef JP
	{"ʤϥ٥ȤĤ褦ФƷ",					 60,62,63, 50},
	{"ʤϱʪΤ褦ʲƷ",					 85,62,63, 50},
	{"ʤĤäƷ",				 99,62,63, 50},
	{"ʤϵ֤Ʒ",					100,62,63, 55},
#else
	{"You have slime green eyes, ",				 60, 62, 63, 50},
	{"You have puke yellow eyes, ",				 85, 62, 63, 50},
	{"You have blue-bloodshot eyes, ",				 99, 62, 63, 50},
	{"You have glowing red eyes, ",				100, 62, 63, 55},
#endif


#ifdef JP
	{"餷",							 33,63,64, 50},
	{"Է",							 66,63,64, 50},
	{"餮ä",							100,63,64, 50},
#else
	{"dirty ",							 33, 63, 64, 50},
	{"mangy ",							 66, 63, 64, 50},
	{"oily ",							100, 63, 64, 50},
#endif


#ifdef JP
	{"參ͤȱ",					 33,64,65, 50},
	{"뤤ֿȱ",						 66,64,65, 50},
	{"Ť翧ȱ",						100,64,65, 50},
#else
	{"sea-weed green hair, ",					 33, 64, 65, 50},
	{"bright red hair, ",					 66, 64, 65, 50},
	{"dark purple hair, ",					100, 64, 65, 50},
#endif


#ifdef JP
	{"п",							 25,65,66, 50},
	{"Ĥ",							 50,65,66, 50},
	{"",							 75,65,66, 50},
	{"",							100,65,66, 50},
#else
	{"and green ",						 25, 65, 66, 50},
	{"and blue ",						 50, 65, 66, 50},
	{"and white ",						 75, 65, 66, 50},
	{"and black ",						100, 65, 66, 50},
#endif


#ifdef JP
	{"֥ĥ֥Ĥȩ򤷤Ƥޤ",						 33,66, 0, 50},
	{"֥餱ȩ򤷤Ƥޤ",						 66,66, 0, 50},
	{"ȩ򤷤Ƥޤ",						100,66, 0, 50},
#else
	{"ulcerous skin.",						 33, 66, 0, 50},
	{"scabby skin.",						 66, 66, 0, 50},
	{"leprous skin.",                       100, 66, 0, 50},
#endif


#ifdef JP
	{"ǧΤƤʤҶǤ",          50, 68, 50, 45},
	{"줿ҶǤ",           80, 68, 50, 65},
	{"᤯̤줿ҶǤ",      100, 68, 50, 55},
#else
	{"You are an unacknowledged child of ", 50, 67, 68, 45},
	{"You are a rebel child of ",         80, 67, 68, 65},
	{"You are a long lost child of ",     100, 67, 68, 55},
#endif


#ifdef JP
	{"ʤ̾Τ̥Сβ²",               50, 67, 68, 80 },
	{"ʤ軰ΥС²", 65, 67, 68, 90 },
	{"ʤΥС²", 79, 67, 68, 100 },
	{"ʤϥ٥",       80, 67, 68, 130 },
	{"ʤϥå",        83, 67, 68, 105 },
	{"ʤϥեɡ",       84, 67, 68, 105 },
	{"ʤϥ֥ɤ",        85, 67, 68, 90 },
	{"ʤϥե",        87, 67, 68, 100 },
	{"ʤϥ顼ɤ",       88, 67, 68, 125 },
	{"ʤϥǥɥ",      89, 67, 68, 120 },
	{"ʤϥ",       90, 67, 68, 140 },
	{"ʤϥ٥ͥǥȤ",     91, 67, 68, 115 },
	{"ʤϥ",       92, 67, 68, 110 },
	{"ʤϥꥢ",       93, 67, 68, 105 },
	{"ʤϥ",        94, 67, 68, 95 },
	{"ʤϥ֥쥤",        95, 67, 68, 115 },
	{"ʤϥեʤ",        96, 67, 68, 110 },
	{"ʤϥå",         97, 67, 68, 135 },
	{"ʤϥʥɤ",      98, 67, 68, 90 },
	{"ʤϥޡ",       99, 67, 68, 105 },
	{"ʤϥޡƥ",       100, 67,68, 80 },
#else
	{"an unknown Amberite.  ",               50, 68, 50, 80 },
	{"an unknown third generation Amberite.  ", 65, 68, 50, 90 },
	{"an unknown second generation Amberite.  ", 79, 68, 50, 100 },
	{"Oberon.  ",       80, 68, 50, 130 },
	{"Osric.  ",        83, 68, 50, 105 },
	{"Finndo.  ",       84, 68, 50, 105 },
	{"Brand.  ",        85, 68, 50, 90 },
	{"Flora.  ",        87, 68, 50, 100 },
	{"Gerard.  ",       88, 68, 50, 125 },
	{"Deirdre.  ",      89, 68, 50, 120 },
	{"Random.  ",       90, 68, 50, 140 },
	{"Benedict.  ",     91, 68, 50, 115 },
	{"Corwin.  ",       92, 68, 50, 110 },
	{"Julian.  ",       93, 68, 50, 105 },
	{"Caine.  ",        94, 68, 50, 95 },
	{"Bleys.  ",        95, 68, 50, 115 },
	{"Fiona.  ",        96, 68, 50, 110 },
	{"Eric.  ",         97, 68, 50, 135 },
	{"Rinaldo.  ",      98, 68, 50, 90 },
	{"Merlin.  ",       99, 68, 50, 105 },
	{"Martin.  ",       100, 68, 50, 80 },
#endif



#ifdef JP
	{"ͤλҶΤΰͤǤ",      85, 70, 71, 45},
	{"γǤ",         	 100, 70, 71, 55},

	{"ʤϥդΤ", 50, 69, 70, 60 },
	{"ʤϥդѻΤ", 80, 69, 70, 75 },
	{"ʤϥդε²", 100,  69, 70, 95 },
#else
	{"You are one of several children of a Dark Elven ",      85, 69, 70, 45},
	{"You are the only child of a Dark Elven ",          100, 69, 70, 55},

	{"Warrior.  ", 50, 70, 71, 60 },
	{"Warlock.  ", 80, 70, 71, 75 },
	{"Noble.  ", 100, 70, 71, 95 },
#endif


#ifdef JP
	{"ʤϹƷ", 100, 71, 72, 50},
#else
	{"You have black eyes, ", 100, 71, 72, 50},
#endif


#ifdef JP
	{"ʤ餫",                        70, 72, 73, 50},
	{"Ǥä",                            90, 72, 73, 50},
	{"뤷",                          100, 72, 73, 50},

	{"ȱƤȤƤŤȩ򤷤Ƥޤ", 100, 73, 0, 50 },
#else
	{"straight ",                        70, 72, 73, 50},
	{"wavy ",                            90, 72, 73, 50},
	{"curly ",                          100, 72, 73, 50},

	{"black hair and a very dark complexion.", 100, 73, 0, 50 },
#endif


#ifdef JP
	{"ʤƤϥǤ̩ˤƤޤ", 25, 74, 20, 25},
	{"ʤƤϥǤ̩ˤƤޤ", 100, 74, 20, 25},
#else
	{"Your mother was an Ogre, but it is unacknowledged.  ", 25, 74, 20, 25},
	{"Your father was an Ogre, but it is unacknowledged.  ", 100, 74, 20, 25},
#endif


#ifdef JP
	{"ʤƤϵ֥㥤ȤǤ", 10, 75, 20, 50},
	{"ʤƤϥե㥤ȤǤ", 12, 75, 20, 55},
	{"ʤƤϥեȡ㥤ȤǤ", 20, 75, 20, 60},
	{"ʤƤϥ饦ɡ㥤ȤǤ", 23, 75, 20, 65},
	{"ʤƤϥȡࡦ㥤ȤǤ", 25, 75, 20, 70},
	{"ʤƤϵ֥㥤ȤǤ",  60, 75, 20, 50},
	{"ʤƤϥե㥤ȤǤ",  70, 75, 20, 55},
	{"ʤƤϥեȡ㥤ȤǤ",  80, 75, 20, 60},
	{"ʤƤϥ饦ɡ㥤ȤǤ",  90, 75, 20, 65},
	{"ʤƤϥȡࡦ㥤ȤǤ", 100, 75, 20, 70},
#else
	{"Your mother was a Hill Giant.  ", 10, 75, 20, 50},
	{"Your mother was a Fire Giant.  ", 12, 75, 20, 55},
	{"Your mother was a Frost Giant.  ", 20, 75, 20, 60},
	{"Your mother was a Cloud Giant.  ", 23, 75, 20, 65},
	{"Your mother was a Storm Giant.  ", 25, 75, 20, 70},
	{"Your father was a Hill Giant.  ",  60, 75, 20, 50},
	{"Your father was a Fire Giant.  ",  70, 75, 20, 55},
	{"Your father was a Frost Giant.  ",  80, 75, 20, 60},
	{"Your father was a Cloud Giant.  ",  90, 75, 20, 65},
	{"Your father was a Storm Giant.  ", 100, 75, 20, 70},
#endif


#ifdef JP
	{"ʤƤ̾Τ̥Ǥ", 75, 76, 20, 50 },
	{"ʤƤϥƥߥǤ",        80, 76, 20, 100 },
	{"ʤƤϥΥǤ",     85, 76, 20, 100 },
	{"ʤƤϥΥǤ",      90, 76, 20, 100 },
	{"ʤƤϥꥦǤ",         95, 76, 20, 100 },
	{"ʤƤϥϥڥꥪǤ",      98, 76, 20, 125 },
	{"ʤƤϥΥǤ",       100, 76, 20, 150 },
#else
	{"Your father was an unknown Titan.  ", 75, 76, 20, 50 },
	{"Your mother was Themis.  ",        80, 76, 20, 100 },
	{"Your mother was Mnemosyne.  ",     85, 76, 20, 100 },
	{"Your father was Okeanoas.  ",      90, 76, 20, 100 },
	{"Your father was Crius.  ",         95, 76, 20, 100 },
	{"Your father was Hyperion.  ",      98, 76, 20, 125 },
	{"Your father was Kronos.  ",       100, 76, 20, 150 },
#endif


#ifdef JP
	{"ʤ̾Τ̥ץλ¹Ǥ", 90, 77, 109, 50 },
	{"ʤϥݥե⥹λҶǤ", 98, 77, 109, 80 },
	{"ʤϥΥλҶǤ", 100, 77, 109, 135 },
#else
	{"You are the offspring of an unknown Cyclops.  ", 90, 77, 109, 50 },
	{"You are Polyphemos's child.  ", 98, 77, 109, 80 },
	{"You are Uranos's child.  ", 100, 77, 109, 135 },
#endif


#ifdef JP
	{"ͤλҶΤΰͤǤ", 100, 79, 80, 50 },

	{"ʤϥ֥饦󡦥", 		50, 78, 79, 50 },
	{"ʤϥ֥롼", 		75, 78, 79, 50 },
	{"ʤϥޥ", 		95, 78, 79, 85 },
	{"ʤϥβإܥɡ٤",   100, 78, 79, 120 },
#else
	{"You are one of several children of ", 100, 78, 79, 50 },

	{"a Brown Yeek. ", 50, 79, 80, 50 },
	{"a Blue Yeek.  ", 75, 79, 80, 50 },
	{"a Master Yeek.  ", 95, 79, 80, 85 },
	{"Boldor, the King of the Yeeks.  ", 100, 79, 80, 120 },
#endif


#ifdef JP
	{"ʤĤƷ",    25, 80, 81, 50 },
	{"ʤϸƷ",    50, 80, 81, 50 },
	{"ʤϾʹƷ",    75, 80, 81, 50 },
	{"ʤϹƷ",    100, 80, 81, 50 },

	{"ȱΤʤƬ",        20, 81, 65, 50 },
	{"ûȱ",        40, 81, 65, 50 },
	{"Ĺȱ",        60, 81, 65, 50 },
	{"ǳ褦֤ȱ",        80, 81, 65, 50 },
	{"Τʤȱ",        100, 81, 65, 50 },
#else
	{"You have pale eyes, ",    25, 80, 81, 50 },
	{"You have glowing eyes, ",    50, 80, 81, 50 },
	{"You have tiny black eyes, ",    75, 80, 81, 50 },
	{"You have shining black eyes, ",    100, 80, 81, 50 },

	{"no hair at all, ",        20, 81, 65, 50 },
	{"short black hair, ",        40, 81, 65, 50 },
	{"long black hair, ",        60, 81, 65, 50 },
	{"bright red hair, ",        80, 81, 65, 50 },
	{"colourless albino hair, ",        100, 81, 65, 50 },
#endif


#ifdef JP
	{"βͤλҶΤΰͤǤ ", 100, 83, 80, 50 },

	{"ʤϥ⡼롦ܥ",   	40, 82, 83, 50 },
	{"ʤϥܥ",         		75, 82, 83, 55 },
	{"ʤϥ顼ܥ",   		95, 82, 83, 65 },
	{"ʤϥܥɤβإ६",   100, 82, 83, 100 },
#else
	{"You are one of several children of ", 100, 82, 83, 50 },

	{"a Small Kobold.  ",   40, 83, 80, 50 },
	{"a Kobold.  ",         75, 83, 80, 55 },
	{"a Large Kobold.  ",   95, 83, 80, 65 },
	{"Mughash, the Kobold Lord.  ",     100, 83, 80, 100 },
#endif


#ifdef JP
	{"ʤϽ饳βͤλҶΤΰͤǤ"
	, 100, 84, 85, 50 },

	{"ʤ֤ȩ", 40, 85, 86, 50 },
	{"ʤϹȩ", 90, 85, 86, 50 },
	{"ʤϲȩ", 100, 85, 86, 50 },

	{"ܤ򤷤Ƥޤ", 100, 86, 0, 50 },
#else
	{"You are one of several children of a Klackon hive queen.  "
	, 100, 84, 85, 50 },

	{"You have red skin, ", 40, 85, 86, 50 },
	{"You have black skin, ", 90, 85, 86, 50 },
	{"You have yellow skin, ", 100, 85, 86, 50 },

	{"and black eyes.", 100, 86, 0, 50 },
#endif


#ifdef JP
	{"βͤλҶΤΰͤǤ", 100, 88, 18, 89 },

	{"ʤϥˡ٥󥰤", 30,	87, 88, 20 },
	{"ʤϥˡ٥󥰤±", 50, 	87, 88, 40 },
	{"ʤϥˡ٥󥰤결", 70, 	87, 88, 60 },
	{"ʤϥˡ٥󥰤ι", 90, 	87, 88, 75 },
	{"ʤϥˡ٥󥰤Υ㡼ޥ", 95,87, 88, 100 },
	{"ʤϥˡ٥󥰤βإߡ", 100,87, 88, 100 },
#else
	{"You are one of several children of ", 100, 87, 88, 89 },

	{"a Nibelung Slave.  ", 30, 88, 18, 20 },
	{"a Nibelung Thief.  ", 50, 88, 18, 40 },
	{"a Nibelung Smith.  ", 70, 88, 18, 60 },
	{"a Nibelung Miner.  ", 90, 88, 18, 75 },
	{"a Nibelung Shaman.  ", 95, 88, 18, 100 },
	{"Mime, the Nibelung.  ", 100, 88, 18, 100 },
#endif


#ifdef JP
	{"ʤϥɥ饳˥", 100, 89, 90, 50 },

	{"ĹҤǤ", 30, 135, 91, 55 },
	{"ҤǤ", 50, 135, 91, 50 },
	{"ܻҤǤ", 55, 135, 91, 50 },
	{"θɻǤ", 60, 135, 91, 45 },
	{"δͤλҶΤΰͤǤ", 85, 135, 91, 50 },
	{"ΰγǤ", 100, 135, 91, 55 },

	{"", 10, 90, 135, 20 },
	{"±", 21, 90, 135, 30 },
	{"", 26, 90, 135, 45 },
	{"ʼ", 42, 90, 135, 45 },
	{"", 73, 90, 135, 50 },
	{"", 78, 90, 135, 50 },
	{"", 85, 90, 135, 55 },
	{"Ų", 89, 90, 135, 60 },
	{"η", 94, 90, 135, 65 },
	{"ѻ", 97, 90, 135, 70 },
	{"ؼ", 99, 90, 135, 80 },
	{"²", 100, 90, 135, 100 },

	{"ʤ", 100, 91, 136, 50 },

	{"ϹȩƳʢ򤷤Ƥޤ", 11, 136, 0, 50 },
	{"֥󥺿ȩƼʢ򤷤Ƥޤ", 16, 136, 0, 50 },
	{"ȩ򤷤Ƥޤ", 24, 136, 0, 50 },
	{"ȩ򤷤Ƥޤ", 26, 136, 0, 60 },
	{"Ĥȩƿ忧ʢ򤷤Ƥޤ", 32, 136, 0, 50 },
	{"ȩǤ", 33, 136, 0, 70 },
	{"㿧㿧ȩ򤷤Ƥޤ", 37, 136, 0, 45 },
	{"ȩʢ򤷤Ƥޤ", 41, 136, 0, 50 },
	{"翧ȩʢ򤷤Ƥޤ", 48, 136, 0, 50 },
	{"пȩƲʢ򤷤Ƥޤ", 65, 136, 0, 50 },
	{"ппȩ򤷤Ƥޤ", 75, 136, 0, 50 },
	{"֤֤ȩ򤷤Ƥޤ", 88, 136, 0, 50 },
	{"ȩ򤷤Ƥޤ", 94, 136, 0, 50 },
	{"᤯°Ūȩ򤷤Ƥޤ", 100, 136, 0, 55},
#else
	{"You are ", 100, 89, 135, 50 },

	{"the oldest child of a Draconian ", 30, 135, 90, 55 },
	{"the youngest child of a Draconian ", 50, 135, 90, 50 },
	{"the adopted child of a Draconian ", 55, 135, 90, 50 },
	{"an orphaned child of a Draconian ", 60, 135, 90, 45 },
	{"one of several children of a Draconian ", 85, 135, 90, 50 },
	{"the only child of a Draconian ", 100, 135, 90, 55 },

	{"Beggar.  ", 10, 90, 91, 20 },
	{"Thief.  ", 21, 90, 91, 30 },
	{"Sailor.  ", 26, 90, 91, 45 },
	{"Mercenary.  ", 42, 90, 91, 45 },
	{"Warrior.  ", 73, 90, 91, 50 },
	{"Merchant.  ", 78, 90, 91, 50 },
	{"Artisan.  ", 85, 90, 91, 55 },
	{"Healer.  ", 89, 90, 91, 60 },
	{"Priest.  ", 94, 90, 91, 65 },
	{"Mage.  ", 97, 90, 91, 70 },
	{"Scholar.  ", 99, 90, 91, 80 },
	{"Noble.  ", 100, 90, 91, 100 },

	{"You have ", 100, 91, 136, 50 },

	{"charcoal wings, charcoal skin and a smoke-gray belly.", 11, 136, 0, 50 },
	{"bronze wings, bronze skin, and a copper belly.", 16, 136, 0, 50 },
	{"golden wings, and golden skin.", 24, 136, 0, 50 },
	{"white wings, and white skin.", 26, 136, 0, 60 },
	{"blue wings, blue skin, and a cyan belly.", 32, 136, 0, 50 },
	{"multi-hued wings, and multi-hued skin.", 33, 136, 0, 70 },
	{"brown wings, and brown skin.", 37, 136, 0, 45 },
	{"black wings, black skin, and a white belly.", 41, 136, 0, 50 },
	{"lavender wings, lavender skin, and a white belly.", 48, 136, 0, 50 },
	{"green wings, green skin and yellow belly.", 65, 136, 0, 50 },
	{"green wings, and green skin.", 75, 136, 0, 50 },
	{"red wings, and red skin.", 88, 136, 0, 50 },
	{"black wings, and black skin.", 94, 136, 0, 50 },
	{"metallic skin, and shining wings.", 100, 136, 0, 55},
#endif


#ifdef JP
	{"ʤϰʤĹϷǾ̣⤫ǤʤӤǥޥ㥯Ȥޤޤʤϥ̥̥뤷ȩȵܤ򤷤Ƥơ", 100, 92, 93, 80 },
	{"μ˻ܤο꤬Ƥޤ", 20, 93, 0, 45 },
	{"μ˻ܤο꤬Ƥޤ", 80, 93, 0, 50 },
	{"μ˸ܤο꤬Ƥޤ", 100, 93, 0, 55 },
#else
	{"You have slimy skin, empty glowing eyes, and ", 100, 92, 93, 80 },
	{"three tentacles around your mouth.", 20, 93, 0, 45 },
	{"four tentacles around your mouth.", 80, 93, 0, 50 },
	{"five tentacles around your mouth.", 100, 93, 0, 55 },
#endif


#ifdef JP
	{"ʤ", 100, 94, 95, 50 },

	{"ʤϹʪǤ", 30, 95, 96, 20 },
	{"鰭Ǥ", 60, 95, 96, 50 },
	{"鰭Ǥ", 90, 95, 96, 75 },
	{"ⲦǤ", 100, 95, 96, 99 },

	{"ʤ֤ȩ", 50, 96, 97, 50 },
	{"ʤ㿧ȩ", 100, 96, 97, 50},

	{"֤ǳƷ򤷤ƤơޤȲȻɤƤޤ", 40, 97, 0, 50 },
	{"֤ǳƷ򤷤ƤơޤȲ礬Ƥޤ", 70, 97, 0, 50 },
	{"֤ǳƷ򤷤ƤơޤƤޤ", 100, 97, 0, 50 },
#else
	{"You ancestor was ", 100, 94, 95, 50 },

	{"a mindless demonic spawn.  ", 30, 95, 96, 20 },
	{"a minor demon.  ", 60, 95, 96, 50 },
	{"a major demon.  ", 90, 95, 96, 75 },
	{"a demon lord.  ", 100, 95, 96, 99 },

	{"You have red skin, ", 50, 96, 97, 50 },
	{"You have brown skin, ", 100, 96, 97, 50},

	{"claws, fangs, spikes, and glowing red eyes.", 40, 97, 0, 50 },
	{"claws, fangs, and glowing red eyes.", 70, 97, 0, 50 },
	{"claws, and glowing red eyes.", 100, 97, 0, 50 },
#endif


#ifdef JP
	{"ʤϥХѤˤä", 40,	98, 99, 50 },
	{"ʤˡȤˤä", 65, 	98, 99, 50 },
	{"ʤϣѻդˤä",	     90,	98, 99, 50},
	{"ʤηˤä", 100,	98, 99, 60},

	{"臘", 10, 99, 100, 65 },
	{"",		 100,  99, 100, 50 },

	{"Ǵڤ", 40, 100, 101, 50 },
	{"Ф", 80, 100, 101, 50 },
	{"ڤ", 85, 100, 101, 40 },
	{"Ŵ", 99, 100, 101, 50 },
	{"⤫", 100, 100, 101, 100},

	{"Фޤ", 100,101, 0, 50 },
#else
	{"You were shaped from ", 100, 98, 99, 50 },

	{"clay ", 40, 99, 100, 50 },
	{"stone ", 80, 99, 100, 50 },
	{"wood ", 85, 99, 100, 40 },
	{"iron ", 99, 99, 100, 50 },
	{"pure gold ", 100, 99, 100, 100},

	{"by a Kabbalist", 40, 100, 101, 50 },
	{"by a Wizard", 65, 100, 101, 50 },
	{"by an Alchemist", 90, 100, 101, 50},
	{"by a Priest", 100, 100, 101, 60},

	{" to fight evil.", 10, 101, 0, 65 },
	{".", 100, 101, 0, 50 },
#endif


#ifdef JP
	{"ʤ", 100, 102, 103, 50 },

	{"ѻΤˤФޤ", 30, 103, 104, 50 },
	{"ˡμ¸ˤФޤ", 50, 103, 104, 50 },
	{"ٰηˤФޤ", 70, 103, 104, 50 },
	{"Ȥηˤ߽Фޤ", 75, 103, 104, 50 },
	{"ޤޤ", 85, 103, 104, 50 },
	{"ޤޤ", 95, 103, 104, 30 },
	{"̾Ѥˤ߽Фޤ", 100, 103, 104, 50 },

	{"ʤ", 100, 104, 105, 50 },
	{"Ť줿ǽƤơ", 40, 105, 106, 50 },
	{"äǽƤơ", 60, 105, 106, 50 },
	{"줿㿧ǽƤơ", 80, 105, 106, 50 },
	{"򤯵ǽƤơ", 100, 105, 106, 50 },

	{"ܤ򤷤Ƥޤ", 30, 106, 0, 50 },
	{"ϹιФǳܤ򤷤Ƥޤ", 50, 106, 0, 50 },
	{"ݤϤäݤǤ", 100, 106, 0, 50 },
#else
	{"You were created by ", 100, 102, 103, 50 },

	{"a Necromancer.  ", 30, 103, 104, 50 },
	{"a magical experiment.  ", 50, 103, 104, 50 },
	{"an Evil Priest.  ", 70, 103, 104, 50 },
	{"a pact with the demons.  ", 75, 103, 104, 50 },
	{"a restless spirit.  ", 85, 103, 104, 50 },
	{"a curse.  ", 95, 103, 104, 30 },
	{"an oath.  ", 100, 103, 104, 50 },

	{"You have ", 100, 104, 105, 50 },
	{"dirty, dry bones, ", 40, 105, 106, 50 },
	{"rotten black bones, ", 60, 105, 106, 50 },
	{"filthy, brown bones, ", 80, 105, 106, 50 },
	{"shining white bones, ", 100, 105, 106, 50 },

	{"and glowing eyes.", 30, 106, 0, 50 },
	{"and eyes which burn with hellfire.", 50, 106, 0, 50 },
	{"and empty eyesockets.", 100, 106, 0, 50 },
#endif


#ifdef JP
	{"ʤ", 100, 107, 108, 50 },

	{"ѻΤˤ߽Фޤ", 30, 108, 62, 50 },
	{"ˡȤˤ߽Фޤ", 50, 108, 62, 50 },
	{"ޤޤ",60, 108, 62, 50 },
	{"ٰηˤ߽Фޤ", 70, 108, 62, 50 },
	{"Ȥηˤ߽Фޤ", 80, 108, 62, 50 },
	{"ޤޤ", 95, 108, 62, 30 },
	{"̾Ѥˤ߽Фޤ", 100, 108, 62, 50 },

	{"ʤϰų쿧Ʒ",               20, 109, 110, 50},
	{"ʤϳ쿧Ʒ",                    60, 109, 110, 50},
	{"ʤ㿧Ʒ",                    70, 109, 110, 50},
	{"ʤпƷ",                    80, 109, 110, 50},
	{"ʤĤƷ",                     90, 109, 110, 50},
	{"ʤøĿƷ",               100, 109, 110, 50}, /*tansei.cc.u-tokyoͳ*/

	{"ʤ餫",                        70, 110, 111, 50},
	{"Ǥä",                            90, 110, 111, 50},
	{"뤷",                          100, 110, 111, 50},

	{"ȱ",                         30, 111, 112, 50},
	{"㿧ȱ",                         70, 111, 112, 50},
	{"㿧ȱ",                        80, 111, 112, 50},
	{"֤ȱ",                       90, 111, 112, 50},
	{"ȱ",                        100, 111, 112, 50},

	{"ƤȤƤŤȩ򤷤Ƥޤ",              10, 112, 0, 50},
	{"ưŤȩ򤷤Ƥޤ",                   30, 112, 0, 50},
	{"ʿŪȩο򤷤Ƥޤ",               80, 112, 0, 50},
	{"Ʒ쿧Τȩ򤷤Ƥޤ",                   90, 112, 0, 50},
	{"ƤȤƤ쿧Τȩ򤷤Ƥޤ",             100, 112, 0, 50},
#else
	{"You were created by ", 100, 107, 108, 50 },

	{"a Necromancer.  ", 30, 108, 62, 50 },
	{"a Wizard.  ", 50, 108, 62, 50 },
	{"a restless spirit.  ", 60, 108, 62, 50 },
	{"an Evil Priest.  ", 70, 108, 62, 50 },
	{"a pact with the demons.  ", 80, 108, 62, 50 },
	{"a curse.  ", 95, 108, 62, 30 },
	{"an oath.  ", 100, 108, 62, 50 },

	{"You have a dark brown eye, ",               20, 109, 110, 50},
	{"You have a brown eye, ",                    60, 109, 110, 50},
	{"You have a hazel eye, ",                    70, 109, 110, 50},
	{"You have a green eye, ",                    80, 109, 110, 50},
	{"You have a blue eye, ",                     90, 109, 110, 50},
	{"You have a blue-gray eye, ",               100, 109, 110, 50},

	{"straight ",                        70, 110, 111, 50},
	{"wavy ",                            90, 110, 111, 50},
	{"curly ",                          100, 110, 111, 50},

	{"black hair, ",                         30, 111, 112, 50},
	{"brown hair, ",                         70, 111, 112, 50},
	{"auburn hair, ",                        80, 111, 112, 50},
	{"red hair, ",                       90, 111, 112, 50},
	{"blond hair, ",                        100, 111, 112, 50},

	{"and a very dark complexion.",              10, 112, 0, 50},
	{"and a dark complexion.",                   30, 112, 0, 50},
	{"and an average complexion.",               80, 112, 0, 50},
	{"and a fair complexion.",                   90, 112, 0, 50},
	{"and a very fair complexion.",             100, 112, 0, 50},
#endif


#ifdef JP
	{"ʤäΤʤ椫ᴤޤ", 20, 113, 114, 50 },
	{"ʤɴǤʥХѥɤα¿ȤʤäƤޤޤ", 40, 113, 114, 50 },
	{"ʤϥХѥϥ󥿡Ǥα¿ȤʤäƤޤޤ", 60, 113, 114, 50 },
	{"ʤϻѻΤǤ", 80, 113, 114, 50 },
	{"ʤ϶ʵ²Ǥ", 95, 113, 114, 50 },
	{"ʤ϶ǻǦǤ", 100, 113, 114, 50 },
#else
	{"You arose from an unmarked grave.  ", 20, 113, 114, 50 },
	{"In life you were a simple peasant, the victim of a powerful Vampire Lord.  ", 40, 113, 114, 50 },
	{"In life you were a Vampire Hunter, but they got you.  ", 60, 113, 114, 50 },
	{"In life you were a Necromancer.  ", 80, 113, 114, 50 },
	{"In life you were a powerful noble.  ", 95, 113, 114, 50 },
	{"In life you were a powerful and cruel tyrant.  ", 100, 113, 114, 50 },
#endif


#ifdef JP
	{"ʤ", 100, 114, 115, 50 },

	{"ȱ", 25, 115, 116, 50 },
	{"Ĥ줿֥饦ȱ", 50, 115, 116, 50 },
	{"ȱ", 75, 115, 116, 50 },
	{"ȱΤʤƬ", 100, 115, 116, 50 },
#else
	{"You have ", 100, 114, 115, 50 },

	{"jet-black hair, ", 25, 115, 116, 50 },
	{"matted brown hair, ", 50, 115, 116, 50 },
	{"white hair, ", 75, 115, 116, 50 },
	{"a hairless head, ", 100, 115, 116, 50 },
#endif


#ifdef JP
	{"ǳúΤ褦Ʒ", 25, 116, 117, 50 },
	{"ƷΤʤܡ", 50, 116, 117, 50 },
	{"˽ʲƷ", 75, 116, 117, 50 },
	{"ä֤Ʒ", 100, 116, 117, 50 },

	{"ƻͤΤ褦Ĥ᤿ȩ򤷤Ƥޤ", 100, 117, 0, 50 },
#else
	{"eyes like red coals, ", 25, 116, 117, 50 },
	{"blank white eyes, ", 50, 116, 117, 50 },
	{"feral yellow eyes, ", 75, 116, 117, 50 },
	{"bloodshot red eyes, ", 100, 116, 117, 50 },

	{"and a deathly pale complexion.", 100, 117, 0, 50 },
#endif


#ifdef JP
	{"ʤ", 100, 118, 119, 50 },

	{"ѻΤˤФޤ", 30, 119, 134, 50 },
	{"ˡμ¸ˤФޤ", 50, 119, 134, 50 },
	{"ٰηˤФޤ", 70, 119, 134, 50 },
	{"Ȥηˤ߽Фޤ", 75, 119, 134, 50 },
	{"ޤޤ", 85, 119, 134, 50 },
	{"ޤޤ", 95, 119, 134, 30 },
	{"̾Ѥˤ߽Фޤ", 100, 119, 134, 50 },
#else
	{"You were created by ", 100, 118, 119, 50 },

	{"a Necromancer.  ", 30, 119, 134, 50 },
	{"a magical experiment.  ", 50, 119, 134, 50 },
	{"an Evil Priest.  ", 70, 119, 134, 50 },
	{"a pact with the demons.  ", 75, 119, 134, 50 },
	{"a restless spirit.  ", 85, 119, 134, 50 },
	{"a curse.  ", 95, 119, 134, 30 },
	{"an oath.  ", 100, 119, 134, 50 },
#endif


#ifdef JP
	{"ȱ", 25, 120, 121, 50 },
	{"Ĥ줿֥饦ȱ", 50, 120, 121, 50 },
	{"ȱ", 75, 120, 121, 50 },
	{"ȱΤʤƬ", 100, 120, 121, 50 },
#else
	{"jet-black hair, ", 25, 120, 121, 50 },
	{"matted brown hair, ", 50, 120, 121, 50 },
	{"white hair, ", 75, 120, 121, 50 },
	{"a hairless head, ", 100, 120, 121, 50 },
#endif


#ifdef JP
	{"ǳúΤ褦Ʒ", 25, 121, 122, 50 },
	{"ƷΤʤܡ", 50, 121, 122, 50 },
	{"˽ʲƷ", 75, 121, 122, 50 },
	{"ä֤Ʒ", 100, 121, 122, 50 },
#else
	{"eyes like red coals, ", 25, 121, 122, 50 },
	{"blank white eyes, ", 50, 121, 122, 50 },
	{"feral yellow eyes, ", 75, 121, 122, 50 },
	{"bloodshot red eyes, ", 100, 121, 122, 50 },
#endif


#ifdef JP
	{"ƻͤΤ褦ڿȩ򤷤Ƥޤ", 100, 122, 123, 50 },
	{"ʤμˤԵ̣пΥ餬äƤޤ", 100, 123, 0, 50 },
#else
	{" and a deathly gray complexion. ", 100, 122, 123, 50 },
	{"An eerie green aura surrounds you.", 100, 123, 0, 50 },
#endif


#ifdef JP
	{"ʤξƤ", 100, 124, 125, 50 },

	{"ԥǤ", 20, 125, 126, 35 },
	{"˥Ǥ", 30, 125, 126, 25 },
	{"Ǥ", 75, 125, 126, 50 },
	{"Ǥ", 90, 125, 126, 75 },
	{"ε²Ǥ", 100, 125, 126, 85 }, 
#else
	{"Your parents were ", 100, 124, 125, 50 },

	{"pixies.  ", 20, 125, 126, 35 },
	{"nixies.  ", 30, 125, 126, 25 },
	{"wood sprites.  ", 75, 125, 126, 50 },
	{"wood spirits.  ", 90, 125, 126, 75 },
	{"noble faerie folk.  ", 100, 125, 126, 85 },
#endif


#ifdef JP
	{"ʤ˥饤ȥ֥롼αƤơ", 100, 126, 127, 50 },

	{"ʤ餫ʶȱ",                        80, 127, 128, 50},
	{"Ǥäȱ",                            100, 127, 128, 50},

	{"ĤƷȤȩ򤷤Ƥޤ", 100, 128, 0, 50},
#else
	{"You have light blue wings attached to your back, ", 100, 126, 127, 50 },

	{"straight blond hair, ",                        80, 127, 128, 50},
	{"wavy blond hair, ",                            100, 127, 128, 50},

	{"blue eyes, and a very fair complexion.", 100, 128, 0, 50},
#endif


#ifdef JP
	{"ʤˡμ¸ˤ߽Фޤ", 30, 129, 130, 40},
	{"ʤϻҶ塢򤫤ˤ륹˼ͤùǤޤޤ",
	50, 129, 130, 50 }, 
	{"륫ⲦͷӤǤʤ夲ޤ",
	60, 129, 130, 60 },
	{"ʤˡˤݤ蘆줿ưʪȿʹ֤λҶǤ", 75, 129, 130, 50},
	{"ʤϸ⤪ޤʪŪʳݤ碌ˤޤޤ", 100, 129, 130, 30},
#else
	{"You were produced by a magical experiment.  ", 30, 129, 130, 40},
	{"In your childhood, you were stupid enough to stick your head in raw Logrus.  ",
	50, 129, 130, 50 },
	{"A Demon Lord of Chaos decided to have some fun, and so he created you.  ",
	60, 129, 130, 60 },
	{"You are the magical crossbreed of an animal and a man.  ", 75, 129, 130, 50},
	{"You are the blasphemous crossbreed of unspeakable creatures of chaos.  ", 100, 129, 130, 30},
#endif



#ifdef JP
	{"ʤп",              60, 130, 131, 50},
	{"ʤϹĻ",                    85, 130, 131, 50},
	{"ʤϥ󥸿ǭ",            99, 130, 131, 50},
	{"ʤǳ褦ʰ",          100, 130, 131, 55},
#else
	{"You have green reptilian eyes, ",              60, 130, 131, 50},
	{"You have the black eyes of a bird, ",              85, 130, 131, 50},
	{"You have the orange eyes of a cat, ",               99, 130, 131, 50},
	{"You have the fiery eyes of a demon, ",             100, 130, 131, 55},
#endif


#ifdef JP

	{"ȱΤʤƬ",                 10, 131, 133, 50},
	{"򤷤Ƥơ",                     33, 131, 132, 50},
	{"򤷤Ƥơߤܤ餷",             66, 131, 132, 50},
	{"򤷤ƤơƤä",                100, 131, 132, 50},
#else
	{"no hair at all, ",                 10, 131, 133, 50 },
	{"dirty ",                           33, 131, 132, 50},
	{"mangy ",                           66, 131, 132, 50},
	{"oily ",                           100, 131, 132, 50},
#endif


#ifdef JP

	{"㿧",                    33, 132, 133, 50},
	{"",                    66, 132, 133, 50},
	{"",                     100, 132, 133, 50},
#else
	{"brown fur, ",                    33, 132, 133, 50},
	{"gray fur, ",                    66, 132, 133, 50},
	{"albino fur, ",                  100, 132, 133, 50},
#endif


#ifdef JP
        {"Ӥޤ",      50, 133, 0, 50 },
        {"ʹ֤­Ƥޤ",  75, 133, 0, 50 },
        {"Ļ­Ƥޤ",    85, 133, 0, 50 },
        {"­Ƥޤ",90, 133, 0, 50 },
        {"­Ƥޤ",    95, 133, 0, 50 },
        {"ǭ­Ƥޤ",    97, 133, 0, 50 },
        {"­Ƥޤ",   100, 133, 0, 50 },

        {"ʤ", 100, 134, 120, 50 },
#else
	{"and the hooves of a goat.",      50, 133, 0, 50 },
	{"and human feet.",        75, 133, 0, 50 },
	{"and bird's feet.",       85, 133, 0, 50 },
	{"and reptilian feet.",    90, 133, 0, 50 },
	{"and bovine feet.",       95, 133, 0, 50 },
	{"and feline feet.",       97, 133, 0, 50 },
	{"and canine feet.",       100, 133, 0, 50 },

	{"You have ", 100, 134, 120, 50 },
#endif

};



/*
 * Current stats
 */
static s16b stat_use[A_MAX];






/*
 * Choose from one of the available magical realms
 */
static byte choose_realm(byte choices)
{
	int picks[MAX_REALM] = {0};
	int k;
	int count = 0;
	byte auto_select = REALM_NONE;
	int n = 0;
	char c;
	char p2 = ')';
	char buf[80];

	/* Count the choices */
	if (choices & CH_LIFE)
	{
		count++;
		auto_select = REALM_LIFE;
	}
	if (choices & CH_SORCERY)
	{
		count++;
		auto_select = REALM_SORCERY;
	}
	if (choices & CH_MUSOU)
	{
		count++;
		auto_select = REALM_MUSOU;
	}
#if 0
	if (choices & CH_CHAOS)
	{
		count++;
		auto_select = REALM_CHAOS;
	}
	if (choices & CH_DEATH)
	{
		count++;
		auto_select = REALM_DEATH;
	}
	if (choices & CH_TRUMP)
	{
		count++;
		auto_select = REALM_TRUMP;
	}
	if (choices & CH_ARCANE)
	{
		count++;
		auto_select = REALM_ARCANE;
	}
#endif

	/* Auto-select the realm */
	if (count < 2) return auto_select;

	/* Extra info */
	Term_putstr(5, 15, -1, TERM_WHITE,
#ifdef JP
"ˡΰˤꤢʤʸΥפޤޤ");
#else
		"The realm of magic will determine which spells you can learn.");
#endif

#if 0
	Term_putstr(5, 16, -1, TERM_WHITE,
#ifdef JP
"̿ѤɸѤΡȰŹ˲ŪʼʸǤ");
#else
		"Life and Sorcery are protective, Chaos and Death are destructive.");
#endif

	Term_putstr(5, 17, -1, TERM_WHITE,
#ifdef JP
"Ϲɸξμʸޤߤޤ");
#else
		"Nature has both defensive and offensive spells.");
#endif
#endif


	if ((choices & CH_LIFE) && (p_ptr->realm1 != REALM_LIFE))
	{
#ifdef JP
sprintf(buf, "%c%c %s", I2A(n), p2, "̿");
#else
		sprintf(buf, "%c%c %s", I2A(n), p2, "Life");
#endif

		put_str(buf, 21 + (n/5), 2 + 15 * (n%5));
		picks[n] = REALM_LIFE;
		n++;
	}

	if ((choices & CH_SORCERY) && (p_ptr->realm1 != REALM_SORCERY))
	{
#ifdef JP
sprintf(buf, "%c%c %s", I2A(n), p2, "");
#else
		sprintf(buf, "%c%c %s", I2A(n), p2, "Sorcery");
#endif

		put_str(buf, 21 + (n/5), 2 + 15 * (n%5));
		picks[n] = REALM_SORCERY;
		n++;
	}

	if ((choices & CH_MUSOU) && (p_ptr->realm1 != REALM_MUSOU))
	{
#ifdef JP
sprintf(buf, "%c%c %s", I2A(n), p2, "̵");
#else
		sprintf(buf, "%c%c %s", I2A(n), p2, "Musou");
#endif

		put_str(buf, 21 + (n/5), 2 + 15 * (n%5));
		picks[n] = REALM_MUSOU;
		n++;
	}

#if 0
	if ((choices & CH_TRUMP) && (p_ptr->realm1 != REALM_TRUMP))
	{
#ifdef JP
sprintf(buf, "%c%c %s", I2A(n), p2, "ȥ");
#else
		sprintf(buf, "%c%c %s", I2A(n), p2, "Trump");
#endif

		put_str(buf, 21 + (n/5), 2 + 15 * (n%5));
		picks[n] = REALM_TRUMP;
		n++;
	}

	if ((choices & CH_NATURE) && (p_ptr->realm1 != REALM_NATURE))
	{
#ifdef JP
sprintf(buf, "%c%c %s", I2A(n), p2, "");
#else
		sprintf(buf, "%c%c %s", I2A(n), p2, "Nature");
#endif

		put_str(buf, 21 + (n/5), 2 + 15 * (n%5));
		picks[n] = REALM_NATURE;
		n++;
	}

	if ((choices & CH_CHAOS) && (p_ptr->realm1 != REALM_CHAOS))
	{
#ifdef JP
sprintf(buf, "%c%c %s", I2A(n), p2, "");
#else
		sprintf(buf, "%c%c %s", I2A(n), p2, "Chaos");
#endif

		put_str(buf, 21 + (n/5), 2 + 15 * (n%5));
		picks[n] = REALM_CHAOS;
		n++;
	}

	if ((choices & CH_DEATH) && (p_ptr->realm1 != REALM_DEATH))
	{
#ifdef JP
sprintf(buf, "%c%c %s", I2A(n), p2, "Ź");
#else
		sprintf(buf, "%c%c %s", I2A(n), p2, "Death");
#endif

		put_str(buf, 21 + (n/5), 2 + 15 * (n%5));
		picks[n] = REALM_DEATH;
		n++;
	}
#endif

	/* Get a realm */
	while (1)
	{
#ifdef JP
sprintf(buf, "ΰǲ(%c-%c) '*'ǥࡢ'='ǽץ: ", I2A(0), I2A(n-1));
#else
		sprintf(buf, "Choose a realm (%c-%c), * for random, or = for options: ", I2A(0), I2A(n-1));
#endif

		put_str(buf, 20, 2);
		c = inkey();
		if (c == 'Q')
		{
			remove_loc();
			quit(NULL);
		}
		if (c == '*')
		{
			k = rand_int(n);
			break;
		}
		k = (islower(c) ? A2I(c) : -1);
		if ((k >= 0) && (k < n)) break;
		if (c == '?') do_cmd_help();
		else if (c == '=')
		{
			screen_save();
#ifdef JP
do_cmd_options_aux(6, "ץ");
#else
			do_cmd_options_aux(6, "Startup Options");
#endif

			screen_load();
		}
		else bell();
	}


	/* Clean up */
	clear_from(15);

	return (picks[k]);
}


/*
 * Choose the magical realms
 */
static bool get_player_realms(void)
{
#ifdef USE_SCRIPT
	int result = get_player_realms_callback();

	if (result == -1)
		/* Restart */
		return FALSE;
	else if (result == 1)
		/* Success */
		return TRUE;
#endif /* USE_SCRIPT */

	/* Select the first realm */
	p_ptr->realm1 = choose_realm(realm_choices1[p_ptr->pclass]);

	if (p_ptr->realm1)
	{
		/* Print the realm */
#ifdef JP
put_str("ˡ        :", 6, 1);
#else
		put_str("Magic       :", 6, 1);
#endif

		c_put_str(TERM_L_BLUE, realm_names[p_ptr->realm1], 6, 15);

		/* Select the second realm */
		p_ptr->realm2 = choose_realm(realm_choices2[p_ptr->pclass]);

		/* Print the realm */
		if (p_ptr->realm2)
			c_put_str(TERM_L_BLUE, realm_names[p_ptr->realm2], 7, 15);
	}

	return (TRUE);
}


/*
 * Save the current data for later
 */
static void save_prev_data(void)
{
	int i;


	/*** Save the current data ***/

	/* Save the data */
	prev.age = p_ptr->age;
	prev.wt = p_ptr->wt;
	prev.ht = p_ptr->ht;
	prev.sc = p_ptr->sc;
	prev.au = p_ptr->au;

	/* Save the stats */
	for (i = 0; i < A_MAX; i++)
	{
		prev.stat[i] = p_ptr->stat_max[i];
	}

	/* Save the history */
	for (i = 0; i < 4; i++)
	{
		strcpy(prev.history[i], history[i]);
	}

	/* Save the patron */
	prev.patron = p_ptr->chaos_patron;

	/* Save the hitpoints */
	for (i = 0; i < PY_MAX_LEVEL; i++)
	{
		prev.hp[i] = player_hp[i];
	}
}


/*
 * Load the previous data
 */
static void load_prev_data(void)
{
	int i;

	birther	temp;


	/*** Save the current data ***/

	/* Save the data */
	temp.age = p_ptr->age;
	temp.wt = p_ptr->wt;
	temp.ht = p_ptr->ht;
	temp.sc = p_ptr->sc;
	temp.au = p_ptr->au;

	/* Save the stats */
	for (i = 0; i < A_MAX; i++)
	{
		temp.stat[i] = p_ptr->stat_max[i];
	}

	/* Save the history */
	for (i = 0; i < 4; i++)
	{
		strcpy(temp.history[i], history[i]);
	}

	/* Save the patron */
	temp.patron = p_ptr->chaos_patron;

	/* Save the hitpoints */
	for (i = 0; i < PY_MAX_LEVEL; i++)
	{
		temp.hp[i] = player_hp[i];
	}


	/*** Load the previous data ***/

	/* Load the data */
	p_ptr->age = prev.age;
	p_ptr->wt = prev.wt;
	p_ptr->ht = prev.ht;
	p_ptr->sc = prev.sc;
	p_ptr->au = prev.au;

	/* Load the stats */
	for (i = 0; i < A_MAX; i++)
	{
		p_ptr->stat_max[i] = prev.stat[i];
		p_ptr->stat_cur[i] = prev.stat[i];
	}

	/* Load the history */
	for (i = 0; i < 4; i++)
	{
		strcpy(history[i], prev.history[i]);
	}

	/* Save the patron */
	p_ptr->chaos_patron = prev.patron;

	/* Save the hitpoints */
	for (i = 0; i < PY_MAX_LEVEL; i++)
	{
		player_hp[i] = prev.hp[i];
	}


	/*** Save the current data ***/

	/* Save the data */
	prev.age = temp.age;
	prev.wt = temp.wt;
	prev.ht = temp.ht;
	prev.sc = temp.sc;
	prev.au = temp.au;

	/* Save the stats */
	for (i = 0; i < A_MAX; i++)
	{
		prev.stat[i] = temp.stat[i];
	}

	/* Save the history */
	for (i = 0; i < 4; i++)
	{
		strcpy(prev.history[i], temp.history[i]);
	}

	/* Save the patron */
	prev.patron = temp.patron;

	/* Save the hitpoints */
	for (i = 0; i < PY_MAX_LEVEL; i++)
	{
		prev.hp[i] = temp.hp[i];
	}
}




/*
 * Returns adjusted stat -JK-  Algorithm by -JWT-
 *
 * auto_roll is boolean and states maximum changes should be used rather
 * than random ones to allow specification of higher values to wait for
 *
 * The "maximize" code is important	-BEN-
 */
static int adjust_stat(int value, int amount, int auto_roll)
{
	int i;

	/* Negative amounts */
	if (amount < 0)
	{
		/* Apply penalty */
		for (i = 0; i < (0 - amount); i++)
		{
			if (value >= 18+10)
			{
				value -= 10;
			}
			else if (value > 18)
			{
				value = 18;
			}
			else if (value > 3)
			{
				value--;
			}
		}
	}

	/* Positive amounts */
	else if (amount > 0)
	{
		/* Apply reward */
		for (i = 0; i < amount; i++)
		{
			if (value < 18)
			{
				value++;
			}
			else if (maximize_mode)
			{
				value += 10;
			}
			else if (value < 18+70)
			{
				value += ((auto_roll ? 15 : randint(15)) + 5);
			}
			else if (value < 18+90)
			{
				value += ((auto_roll ? 6 : randint(6)) + 2);
			}
			else if (value < 18+100)
			{
				value++;
			}
		}
	}

	/* Return the result */
	return (value);
}




/*
 * Roll for a characters stats
 *
 * For efficiency, we include a chunk of "calc_bonuses()".
 */
static void get_stats(void)
{
	int		i, j;

	int		bonus;

	int		dice[18];


	/* Roll and verify some stats */
	while (TRUE)
	{
		/* Roll some dice */
		for (j = i = 0; i < 18; i++)
		{
			/* Roll the dice */
			dice[i] = randint(3 + i % 3);

			/* Collect the maximum */
			j += dice[i];
		}

		/* Verify totals */
		if ((j > 42) && (j < 57)) break;
		/* 57 was 54... I hate 'magic numbers' :< TY */
	}

	/* Acquire the stats */
	for (i = 0; i < A_MAX; i++)
	{
		/* Extract 5 + 1d3 + 1d4 + 1d5 */
		j = 5 + dice[3*i] + dice[3*i+1] + dice[3*i+2];

		/* Save that value */
		p_ptr->stat_max[i] = j;

		/* Obtain a "bonus" for "race" and "class" */
		bonus = rp_ptr->r_adj[i] + cp_ptr->c_adj[i];

		/* Variable stat maxes */
		if (maximize_mode)
		{
			/* Start fully healed */
			p_ptr->stat_cur[i] = p_ptr->stat_max[i];

			/* Efficiency -- Apply the racial/class bonuses */
			stat_use[i] = modify_stat_value(p_ptr->stat_max[i], bonus);
		}

		/* Fixed stat maxes */
		else
		{
			/* Apply the bonus to the stat (somewhat randomly) */
			stat_use[i] = adjust_stat(p_ptr->stat_max[i], bonus, FALSE);

			/* Save the resulting stat maximum */
			p_ptr->stat_cur[i] = p_ptr->stat_max[i] = stat_use[i];
		}
	}
}


/*
 * Roll for some info that the auto-roller ignores
 */
static void get_extra(void)
{
	int		i, j, min_value, max_value;

	/* Level one */
	p_ptr->max_plv = p_ptr->lev = 1;

	/* Experience factor */
	p_ptr->expfact = rp_ptr->r_exp + cp_ptr->c_exp;

	/* Initialize arena and rewards information -KMW- */
	p_ptr->arena_number = 0;
	p_ptr->inside_arena = 0;
	p_ptr->inside_quest = 0;
	p_ptr->leftbldg = FALSE;
	p_ptr->exit_bldg = TRUE; /* only used for arena now -KMW- */

	/* Reset rewards */
	for (i = 0; i < MAX_BACT; i++)
	{
		p_ptr->rewards[i] = 0;
	}

	/* Hitdice */
	p_ptr->hitdie = rp_ptr->r_mhp + cp_ptr->c_mhp;

	/* Initial hitpoints */
	p_ptr->mhp = p_ptr->hitdie;

	/* Minimum hitpoints at highest level */
	min_value = ((PY_MAX_LEVEL+3) * (p_ptr->hitdie - 1) * 3) / 8;
	min_value += PY_MAX_LEVEL;

	/* Maximum hitpoints at highest level */
	max_value = ((PY_MAX_LEVEL+3) * (p_ptr->hitdie - 1) * 5) / 8;
	max_value += PY_MAX_LEVEL;

	/* Roll out the hitpoints */
	while (TRUE)
	{
		/* Pre-calculate level 1 hitdice */
		player_hp[0] = p_ptr->hitdie;

		/* Gain level 1 HP */
		for (i = 1; i < 4; i++)
		{
			player_hp[0] += randint(rp_ptr->r_mhp);

			if (cp_ptr->c_mhp)
			{
				player_hp[0] += randint(cp_ptr->c_mhp);
			}
		}

		/* Roll the hitpoint values */
		for (i = 1; i < PY_MAX_LEVEL; i++)
		{
			/* Add in racial hit dice */
			j = randint(rp_ptr->r_mhp);
			player_hp[i] = player_hp[i - 1] + j;

			/* If class hit dice is non zero - add it on */
			if (cp_ptr->c_mhp)
			{
				player_hp[i] += randint(cp_ptr->c_mhp);
			}
		}

		/* XXX Could also require acceptable "mid-level" hitpoints */

		/* Require "valid" hitpoints at highest level */
		if (player_hp[PY_MAX_LEVEL - 1] < min_value) continue;
		if (player_hp[PY_MAX_LEVEL - 1] > max_value) continue;

		/* Acceptable */
		break;
	}
}


/*
 * Get the racial history, and social class, using the "history charts".
 */
static void get_history(void)
{
	int i, n, chart, roll, social_class;

	char *s, *t;

	char buf[240];

	/* Clear the previous history strings */
	for (i = 0; i < 4; i++) history[i][0] = '\0';

	/* Clear the history text */
	buf[0] = '\0';

	/* Initial social class */
	social_class = randint(4);

	/* Starting place */
	switch (p_ptr->prace)
	{
		case RACE_AMBERITE:
		{
			chart = 67;
			break;
		}
		case RACE_HUMAN:
		case RACE_BARBARIAN:
		{
			chart = 1;
			break;
		}
		case RACE_HALF_ELF:
		{
			chart = 4;
			break;
		}
		case RACE_ELF:
		case RACE_HIGH_ELF:
		{
			chart = 7;
			break;
		}
		case RACE_HOBBIT:
		{
			chart = 10;
			break;
		}
		case RACE_GNOME:
		{
			chart = 13;
			break;
		}
		case RACE_DWARF:
		{
			chart = 16;
			break;
		}
		case RACE_HALF_ORC:
		{
			chart = 19;
			break;
		}
		case RACE_HALF_TROLL:
		{
			chart = 22;
			break;
		}
		case RACE_DARK_ELF:
		{
			chart = 69;
			break;
		}
		case RACE_HALF_OGRE:
		{
			chart = 74;
			break;
		}
		case RACE_HALF_GIANT:
		{
			chart = 75;
			break;
		}
		case RACE_HALF_TITAN:
		{
			chart = 76;
			break;
		}
		case RACE_CYCLOPS:
		{
			chart = 77;
			break;
		}
		case RACE_YEEK:
		{
			chart = 78;
			break;
		}
		case RACE_KOBOLD:
		{
			chart = 82;
			break;
		}
		case RACE_KLACKON:
		{
			chart = 84;
			break;
		}
		case RACE_NIBELUNG:
		{
			chart = 87;
			break;
		}
		case RACE_DRACONIAN:
		{
			chart = 89;
			break;
		}
		case RACE_MIND_FLAYER:
		{
			chart = 92;
			break;
		}
		case RACE_IMP:
		{
			chart = 94;
			break;
		}
		case RACE_GOLEM:
		{
			chart = 98;
			break;
		}
		case RACE_SKELETON:
		{
			chart = 102;
			break;
		}
		case RACE_ZOMBIE:
		{
			chart = 107;
			break;
		}
		case RACE_VAMPIRE:
		{
			chart = 113;
			break;
		}
		case RACE_SPECTRE:
		{
			chart = 118;
			break;
		}
		case RACE_SPRITE:
		{
			chart = 124;
			break;
		}
		case RACE_BEASTMAN:
		{
			chart = 129;
			break;
		}
		default:
		{
			chart = 0;
			break;
		}
	}


	/* Process the history */
	while (chart)
	{
		/* Start over */
		i = 0;

		/* Roll for nobility */
		roll = randint(100);


		/* Access the proper entry in the table */
		while ((chart != bg[i].chart) || (roll > bg[i].roll)) i++;

		/* Acquire the textual history */
		(void)strcat(buf, bg[i].info);

		/* Add in the social class */
		social_class += (int)(bg[i].bonus) - 50;

		/* Enter the next chart */
		chart = bg[i].next;
	}



	/* Verify social class */
	if (social_class > 100) social_class = 100;
	else if (social_class < 1) social_class = 1;

	/* Save the social class */
	p_ptr->sc = social_class;


	/* Skip leading spaces */
	for (s = buf; *s == ' '; s++) /* loop */;

	/* Get apparent length */
	n = strlen(s);

	/* Kill trailing spaces */
	while ((n > 0) && (s[n-1] == ' ')) s[--n] = '\0';


#ifdef JP
       {
        unsigned char temp[64*4];
        roff_to_buf(s, 60, temp);
        t = temp;
        for(i=0 ; i<4 ; i++){
             if(t[0]==0)break; 
             else {strcpy(history[i], t);t += strlen(t)+1;}
             }
       }
#else
	/* Start at first line */
	i = 0;

	/* Collect the history */
	while (TRUE)
	{
		/* Extract remaining length */
		n = strlen(s);

		/* All done */
		if (n < 60)
		{
			/* Save one line of history */
			strcpy(history[i++], s);

			/* All done */
			break;
		}

		/* Find a reasonable break-point */
		for (n = 60; ((n > 0) && (s[n-1] != ' ')); n--) /* loop */;

		/* Save next location */
		t = s + n;

		/* Wipe trailing spaces */
		while ((n > 0) && (s[n-1] == ' ')) s[--n] = '\0';

		/* Save one line of history */
		strcpy(history[i++], s);

		/* Start next line */
		for (s = t; *s == ' '; s++) /* loop */;
	}
#endif

}


/*
 * Computes character's age, height, and weight
 */
static void get_ahw(void)
{	
	int h_percent; 

	/* Calculate the age */
	p_ptr->age = rp_ptr->b_age + randint(rp_ptr->m_age);
	
	/* Calculate the height/weight for males */
	if (p_ptr->psex == SEX_MALE)
	{
		p_ptr->ht = randnor(rp_ptr->m_b_ht, rp_ptr->m_m_ht);
		h_percent = (int)(p_ptr->ht) * 100 / (int)(rp_ptr->m_b_ht);
		p_ptr->wt = randnor((int)(rp_ptr->m_b_wt) * h_percent / 100,
			(int)(rp_ptr->m_m_wt) * h_percent / 300 );
	}
	/* Calculate the height/weight for females */
	else if (p_ptr->psex == SEX_FEMALE)
	{
		p_ptr->ht = randnor(rp_ptr->f_b_ht, rp_ptr->f_m_ht);
		
		h_percent = (int)(p_ptr->ht) * 100 / (int)(rp_ptr->f_b_ht);
		p_ptr->wt = randnor((int)(rp_ptr->f_b_wt) * h_percent / 100,
			(int)(rp_ptr->f_m_wt) * h_percent / 300 );
	}
}




/*
 * Get the player's starting money
 */
static void get_money(void)
{
	int i, gold;

	/* Social Class determines starting gold */
	gold = (p_ptr->sc * 6) + randint(100) + 300;

	/* Process the stats */
	for (i = 0; i < A_MAX; i++)
	{
		/* Mega-Hack -- reduce gold for high stats */
		if (stat_use[i] >= 18 + 50) gold -= 300;
		else if (stat_use[i] >= 18 + 20) gold -= 200;
		else if (stat_use[i] > 18) gold -= 150;
		else gold -= (stat_use[i] - 8) * 10;
	}

	/* Minimum 100 gold */
	if (gold < 100) gold = 100;

	/* Save the gold */
	p_ptr->au = gold;
}



#if 0
/*
 * Display stat values, subset of "put_stats()"
 *
 * See 'display_player()' for screen layout constraints.
 */
static void birth_put_stats(void)
{
	int i, p;
	int col = 42;
	byte attr;
	char buf[80];


	/* Put the stats (and percents) */
	for (i = 0; i < A_MAX; i++)
	{
		/* Put the stat */
		cnv_stat(stat_use[i], buf);
		c_put_str(TERM_L_GREEN, buf, 3+i, col+24);

		/* Put the percent */
		if (stat_match[i])
		{
			p = 1000L * stat_match[i] / auto_round;
			attr = (p < 100) ? TERM_YELLOW : TERM_L_GREEN;
			sprintf(buf, "%3d.%d%%", p/10, p%10);
			c_put_str(attr, buf, 3+i, col+13);
		}

		/* Never happened */
		else
		{
#ifdef JP
			c_put_str(TERM_RED, "(ʤ)", 3+i, col+13);
#else
			c_put_str(TERM_RED, "(NONE)", 3+i, col+13);
#endif

		}
	}
}

#endif /* 0 */

/*
 * Clear all the global "character" data
 */
static void player_wipe(void)
{
	int i;


	/* Hack -- zero the struct */
	(void)WIPE(p_ptr, player_type);

	/* Wipe the history */
	for (i = 0; i < 4; i++)
	{
		strcpy(history[i], "");
	}

	/* Wipe the quests */
	for (i = 0; i < max_quests; i++)
	{
		quest[i].status = QUEST_STATUS_UNTAKEN;

		quest[i].cur_num = 0;
		quest[i].max_num = 0;
		quest[i].type = 0;
		quest[i].level = 0;
		quest[i].r_idx = 0;
	}

	/* No weight */
	p_ptr->total_weight = 0;

	/* No items */
	inven_cnt = 0;
	equip_cnt = 0;

	/* Clear the inventory */
	for (i = 0; i < INVEN_TOTAL; i++)
	{
		object_wipe(&inventory[i]);
	}


	/* Start with no artifacts made yet */
	for (i = 0; i < max_a_idx; i++)
	{
		artifact_type *a_ptr = &a_info[i];
		a_ptr->cur_num = 0;
	}

	/* Reset the objects */
	k_info_reset();

	/* Reset the "monsters" */
	for (i = 1; i < max_r_idx; i++)
	{
		monster_race *r_ptr = &r_info[i];

		/* Hack -- Reset the counter */
		r_ptr->cur_num = 0;

		/* Hack -- Reset the max counter */
		r_ptr->max_num = 100;

		/* Hack -- Reset the max counter */
		if (r_ptr->flags1 & RF1_UNIQUE) r_ptr->max_num = 1;
		if (r_ptr->flags3 & RF3_UNIQUE_7) r_ptr->max_num = 7;

		/* Clear player kills */
		r_ptr->r_pkills = 0;
	}


	/* Hack -- Well fed player */
	p_ptr->food = PY_FOOD_FULL - 1;


	/* Wipe the spells */
	spell_learned1 = spell_learned2 = 0L;
	spell_worked1 = spell_worked2 = 0L;
	spell_forgotten1 = spell_forgotten2 = 0L;
	for (i = 0; i < 64; i++) spell_order[i] = 99;

	/* Clean the mutation count */
	mutant_regenerate_mod = 100;

	/* Clear "cheat" options */
	cheat_peek = FALSE;
	cheat_hear = FALSE;
	cheat_room = FALSE;
	cheat_xtra = FALSE;
	cheat_know = FALSE;
	cheat_live = FALSE;

	/* Assume no winning game */
	total_winner = FALSE;

	/* Assume no panic save */
	panic_save = 0;

	/* Assume no cheating */
	noscore = 0;

	/* Default pet command settings */
	p_ptr->pet_follow_distance = PET_FOLLOW_DIST;
	p_ptr->pet_open_doors = FALSE;
	p_ptr->pet_pickup_items = FALSE;
}


/*
 * Each player starts out with a few items, given as tval/sval pairs.
 * In addition, he always has some food and a few torches.
 */
static byte player_init[MAX_CLASS][3][2] =
{
	{
		/* Warrior */
		{ TV_RING, SV_RING_RES_FEAR }, /* Warriors need it! */
		{ TV_SWORD, SV_BASTARD_SWORD },
		{ TV_HARD_ARMOR, SV_CHAIN_MAIL }
	},

	{
		/* Mage */
		{ TV_SORCERY_BOOK, 0 }, /* Hack: for realm1 book */
		{ TV_SORCERY_BOOK, 1 },
		{ TV_SWORD, SV_DAGGER },
#if 0
		{ TV_DEATH_BOOK, 0 } /* Hack: for realm2 book */
#endif
	},

	{
		/* Priest */
		{ TV_SORCERY_BOOK, 0 }, /* Hack: for Life / Death book */
		{ TV_SORCERY_BOOK, 1 },
		{ TV_HAFTED, SV_MACE },
#if 0
		{ TV_DEATH_BOOK, 0 } /* Hack: for realm2 book */
#endif
	},

	{
		/* Ranger */
		{ TV_SORCERY_BOOK, 0 }, /* Hack: for realm1 book */
		{ TV_SOFT_ARMOR, SV_SOFT_LEATHER_ARMOR },
		{ TV_SWORD, SV_SHORT_SWORD },
#if 0
		{ TV_DEATH_BOOK, 0 }		/* Hack: for realm2 book */
#endif
	},

	{
		/* Paladin */
		{ TV_SORCERY_BOOK, 0 },
		{ TV_SWORD, SV_BROAD_SWORD },
		{ TV_SCROLL, SV_SCROLL_PROTECTION_FROM_EVIL }
	},

	{
		/* Warrior-Mage */
		{ TV_SORCERY_BOOK, 0 }, /* Hack: for realm1 book */
		{ TV_SOFT_ARMOR, SV_LEATHER_SCALE_MAIL },
		{ TV_SWORD, SV_LONG_SWORD },
#if 0
		{ TV_DEATH_BOOK, 0 } /* Hack: for realm2 book */
#endif
	},

	{
		/* Mindcrafter */
		{ TV_SWORD, SV_SMALL_SWORD },
		{ TV_POTION, SV_POTION_RESTORE_MANA },
		{ TV_SOFT_ARMOR, SV_SOFT_LEATHER_ARMOR },
	},
};


/*
 * Init players with some belongings
 *
 * Having an item makes the player "aware" of its purpose.
 */
static void player_outfit(void)
{
	int i, tv, sv;

	object_type	forge;
	object_type	*q_ptr;


#ifdef USE_SCRIPT
	if (player_outfit_callback()) return;
#endif /* USE_SCRIPT */

	/* Get local object */
	q_ptr = &forge;

	/* Give the player some food */
	switch (p_ptr->prace)
	{
		case RACE_GOLEM:
		case RACE_SKELETON:
		case RACE_ZOMBIE:
		case RACE_VAMPIRE:
		case RACE_SPECTRE:
		{
			/* Scrolls of satisfy hunger */
			object_prep(q_ptr, lookup_kind(TV_SCROLL, SV_SCROLL_SATISFY_HUNGER));
			q_ptr->number = (byte)rand_range(2, 5);
			object_aware(q_ptr);
			object_known(q_ptr);

			/* These objects are "storebought" */
			q_ptr->ident |= IDENT_STOREB;

#ifdef USE_SCRIPT
			q_ptr->python = object_create_callback(q_ptr);
#endif /* USE_SCRIPT */

			(void)inven_carry(q_ptr);

			break;
		}
		default:
		{
			/* Food rations */
			object_prep(q_ptr, lookup_kind(TV_FOOD, SV_FOOD_RATION));
			q_ptr->number = (byte)rand_range(3, 7);
			object_aware(q_ptr);
			object_known(q_ptr);

#ifdef USE_SCRIPT
			q_ptr->python = object_create_callback(q_ptr);
#endif /* USE_SCRIPT */

			(void)inven_carry(q_ptr);
		}
	}

	/* Get local object */
	q_ptr = &forge;

	if (p_ptr->prace == RACE_VAMPIRE)
	{
		/* Hack -- Give the player scrolls of DARKNESS! */
		object_prep(q_ptr, lookup_kind(TV_SCROLL, SV_SCROLL_DARKNESS));

		q_ptr->number = (byte)rand_range(2, 5);

		object_aware(q_ptr);
		object_known(q_ptr);

		/* These objects are "storebought" */
		q_ptr->ident |= IDENT_STOREB;

#ifdef USE_SCRIPT
		q_ptr->python = object_create_callback(q_ptr);
#endif /* USE_SCRIPT */

		(void)inven_carry(q_ptr);
	}
	else
	{
		/* Hack -- Give the player some torches */
		object_prep(q_ptr, lookup_kind(TV_LITE, SV_LITE_TORCH));
		q_ptr->number = (byte)rand_range(3, 7);
		q_ptr->pval = rand_range(3, 7) * 500;
		object_aware(q_ptr);
		object_known(q_ptr);

#ifdef USE_SCRIPT
	q_ptr->python = object_create_callback(q_ptr);
#endif /* USE_SCRIPT */

		(void)inven_carry(q_ptr);
	}

	/* Get local object */
	q_ptr = &forge;

	if (p_ptr->pclass == CLASS_RANGER)
	{
		/* Hack -- Give the player some arrows */
		object_prep(q_ptr, lookup_kind(TV_ARROW, SV_AMMO_NORMAL));
		q_ptr->number = (byte)rand_range(15, 20);

		/* These objects are "storebought" */
		q_ptr->ident |= IDENT_STOREB;

		object_aware(q_ptr);
		object_known(q_ptr);

#ifdef USE_SCRIPT
		q_ptr->python = object_create_callback(q_ptr);
#endif /* USE_SCRIPT */

		(void)inven_carry(q_ptr);

		/* Hack -- Give the player some arrows */
		object_prep(q_ptr, lookup_kind(TV_BOW, SV_SHORT_BOW));

		/* These objects are "storebought" */
		q_ptr->ident |= IDENT_STOREB;

		object_aware(q_ptr);
		object_known(q_ptr);

#ifdef USE_SCRIPT
		q_ptr->python = object_create_callback(q_ptr);
#endif /* USE_SCRIPT */

		(void)inven_carry(q_ptr);
	}
	else if (p_ptr->pclass == CLASS_HIGH_MAGE)
	{
		/* Hack -- Give the player some arrows */
		object_prep(q_ptr, lookup_kind(TV_WAND, SV_WAND_MAGIC_MISSILE));
		q_ptr->number = 1;
		q_ptr->pval = (byte)rand_range(25, 30);

		/* These objects are "storebought" */
		q_ptr->ident |= IDENT_STOREB;

		object_aware(q_ptr);
		object_known(q_ptr);

#ifdef USE_SCRIPT
		q_ptr->python = object_create_callback(q_ptr);
#endif /* USE_SCRIPT */

		(void)inven_carry(q_ptr);
	}

	/* Hack -- Give the player three useful objects */
	for (i = 0; i < 3; i++)
	{
		/* Look up standard equipment */
		tv = player_init[p_ptr->pclass][i][0];
		sv = player_init[p_ptr->pclass][i][1];

		/* Hack to initialize spellbooks */
		if (tv == TV_SORCERY_BOOK) tv = TV_LIFE_BOOK + p_ptr->realm1 - 1;
#if 0
		else if (tv == TV_DEATH_BOOK) tv = TV_LIFE_BOOK + p_ptr->realm2 - 1;
#endif

		else if (tv == TV_RING && sv == SV_RING_RES_FEAR &&
		    p_ptr->prace == RACE_BARBARIAN)
			/* Barbarians do not need a ring of resist fear */
			sv = SV_RING_SUSTAIN_STR;

		/* Get local object */
		q_ptr = &forge;

		/* Hack -- Give the player an object */
		object_prep(q_ptr, lookup_kind(tv, sv));

#if 0
		/* Assassins begin the game with a poisoned dagger */
		if (tv == TV_SWORD && p_ptr->pclass == CLASS_ROGUE &&
			p_ptr->realm1 == REALM_DEATH) /* Only assassins get a poisoned weapon */
		{
			q_ptr->name2 = EGO_BRAND_POIS;
		}
#endif

		/* These objects are "storebought" */
		q_ptr->ident |= IDENT_STOREB;

		object_aware(q_ptr);
		object_known(q_ptr);

#ifdef USE_SCRIPT
		q_ptr->python = object_create_callback(q_ptr);
#endif /* USE_SCRIPT */

		(void)inven_carry(q_ptr);
	}
}


/*
 * Player race
 */
static bool get_player_race(void)
{
	int     k, n;
	cptr    str;
	char    c;
	char    p2 = ')';
	char    buf[80];


#ifdef USE_SCRIPT
	int result = get_player_race_callback();

	if (result == -1)
		/* Restart */
		return FALSE;
	else if (result == 1)
		/* Success */
		return TRUE;
#endif /* USE_SCRIPT */

	/* Extra info */
	Term_putstr(5, 15, -1, TERM_WHITE,
#ifdef JP
"Լ²դˤäƥ饯ŷŪʻܡʥѲޤ");
#else
		"Your 'race' determines various intrinsic factors and bonuses.");
#endif

	hack_mutation = FALSE;

	/* Dump races */
	for (n = 0, k = 0; n < MAX_RACES; n++)
	{
		/* Analyze */
		p_ptr->prace = n;
		rp_ptr = &race_info[p_ptr->prace];

		/* Hack -- ٤ʤ²ҥåȥȽ */
		if (!rp_ptr->r_mhp) continue;

#ifdef JP
		/* ڤؤ²ɽ */
		str = (english_others == TRUE) ? rp_ptr->E_title : rp_ptr->title;
#else
		str = rp_ptr->title;
#endif


		/* Display */

		if (n < RACE_VAMPIRE)
#ifdef JP
sprintf(buf, "%c%c%s", I2A(k), p2, str);
#else
			sprintf(buf, "%c%c %s", I2A(k), p2, str);
#endif

		else
#ifdef JP
			sprintf(buf, "%d%c%s", (n - RACE_ZOMBIE), p2, str); /* HACK */
#else
			sprintf(buf, "%d%c %s", (n - RACE_ZOMBIE), p2, str); /* HACK */
#endif

#ifdef JP
		put_str(buf, 18 + (k/5), 1 + 16 * (k%5));
#else
		put_str(buf, 18 + (k/5), 2 + 15 * (k%5));
#endif

		k++;
	}

	/* Choose */
	while (1)
	{
#ifdef JP
sprintf(buf, "²ǲ (%c-%c) '*'ǥ, '='ǽץ: ", I2A(0), I2A(14));
#else
		sprintf(buf, "Choose a race (%c-%c), * for random, or = for options: ", I2A(0), I2A(14));
#endif

		put_str(buf, 17, 2);
		c = inkey();
		if (c == 'Q')
		{
			remove_loc();
			quit(NULL);
		}
		if (c == 'S') return (FALSE);
		if (c == '*')
		{
			do
			{
				k = rand_int(MAX_RACES);
			}while (!race_info[k].r_mhp);
			break;
		}
#if 0
		if (c == '1')
		{
			k = RACE_VAMPIRE;
			break;
		}
		else if (c == '2')
		{
			k = RACE_SPECTRE;
			break;
		}
		else if (c == '3')
		{
			k = RACE_SPRITE;
			break;
		}
		else if (c == '4')
		{
			k = RACE_BEASTMAN;
			break;
		}
#endif
		else
		{
			int input2race[15] = { 0, 1, 2, 3, 4,
					       5, 6, 7, 8, 9,
					       12, 16, 17, 18, 21 };
			k = (islower(c) ? A2I(c) : -1);
			if( k >= 0 && k < 15 ) k = input2race[k];
			else k = -1;
			if ((k >= 0) && (k < n)) break;

			if (c == '?') do_cmd_help();
			else if (c == '=')
			{
				screen_save();
#ifdef JP
do_cmd_options_aux(6, "ץ");
#else
				do_cmd_options_aux(6, "Startup Options");
#endif

				screen_load();
			}
			else bell();
		}
	}

	/* Set race */
	p_ptr->prace = k;

	/* Give beastman a mutation at character birth */
	if (p_ptr->prace == RACE_BEASTMAN)
		hack_mutation = TRUE;

	rp_ptr = &race_info[p_ptr->prace];
#ifdef JP
		/* ڤؤ²ɽ */
	str = (english_others == TRUE) ? rp_ptr->E_title : rp_ptr->title;
#else
	str = rp_ptr->title;
#endif


	/* Display */
#ifdef JP
put_str("²        :", 4, 1);
#else
	put_str("Race        :", 4, 1);
#endif

	c_put_str(TERM_L_BLUE, str, 4, 15);

	/* Success */
	return TRUE;
}


/*
 * Player class
 */
static bool get_player_class(void)
{
	int     k, n;
	char    c;
	char    p2 = ')';
	char    buf[80];
	cptr    str;


#ifdef USE_SCRIPT
	int result = get_player_class_callback();

	if (result == -1)
		/* Restart */
		return FALSE;
	else if (result == 1)
		/* Success */
		return TRUE;
#endif /* USE_SCRIPT */

	/* Extra info */
	Term_putstr(5, 15, -1, TERM_WHITE,
#ifdef JP
"Կȡդˤäƥ饯ŷŪǽϤܡʥѲޤ");
#else
		"Your 'class' determines various intrinsic abilities and bonuses.");
#endif

	Term_putstr(5, 16, -1, TERM_WHITE,
#ifdef JP
    "()ǰϤޤ줿Ͽ侩ʤȤǤ");
#else
	    "Any entries in parentheses should only be used by advanced players.");
#endif


	/* Dump classes */
	for (n = 0; n < MAX_CLASS; n++)
	{
		cptr mod = "";

		/* Analyze */
		p_ptr->pclass = n;
		cp_ptr = &class_info[p_ptr->pclass];
		mp_ptr = &magic_info[p_ptr->pclass];
#ifdef JP
		/* ȤαѸɽб */
		str = (english_others == TRUE) ? cp_ptr->E_title : cp_ptr->title;
#else
		str = cp_ptr->title;
#endif


		if (!(rp_ptr->choice & (1L << n)))
#ifdef JP
sprintf(buf, "%c%c(%s)%s", I2A(n), p2, str, mod);
#else
			sprintf(buf, "%c%c (%s)%s", I2A(n), p2, str, mod);
#endif

		else
			/* Display */
#ifdef JP
sprintf(buf, "%c%c%s%s", I2A(n), p2, str, mod);
#else
			sprintf(buf, "%c%c %s%s", I2A(n), p2, str, mod);
#endif


		put_str(buf, 19 + (n/3), 2 + 20 * (n%3));
	}

	/* Get a class */
	while (1)
	{
#ifdef JP
sprintf(buf, "Ȥǲ (%c-%c) '*'ǥࡢ'='ǽץ: ", I2A(0), I2A(n-1));
#else
		sprintf(buf, "Choose a class (%c-%c), * for random, or = for options: ", I2A(0), I2A(n-1));
#endif

		put_str(buf, 18, 2);
		c = inkey();
		if (c == 'Q')
		{
			remove_loc();
			quit(NULL);
		}
		if (c == 'S') return (FALSE);
		if (c == '*')
		{
			k = rand_int(n);
			break;
		}
		k = (islower(c) ? A2I(c) : -1);
		if ((k >= 0) && (k < n)) break;
		if (c == '?') do_cmd_help();
		else if (c == '=')
		{
			screen_save();
#ifdef JP
do_cmd_options_aux(6, "ץ");
#else
			do_cmd_options_aux(6, "Startup Options");
#endif

			screen_load();
		}
		else bell();
	}

	/* Set class */
	p_ptr->pclass = k;
	cp_ptr = &class_info[p_ptr->pclass];
	mp_ptr = &magic_info[p_ptr->pclass];
#ifdef JP
        str = (english_others == TRUE) ? cp_ptr->E_title : cp_ptr->title;
#else
	str = cp_ptr->title;
#endif


	/* Display */
#ifdef JP
put_str("        :", 5, 1);
#else
	put_str("Class       :", 5, 1);
#endif

#ifdef JP
	c_put_str(TERM_L_BLUE, str, 5, 15);
#else
	c_put_str(TERM_L_BLUE, cp_ptr->title, 5, 15);
#endif


	/* Clean up */
	clear_from(15);

	return TRUE;
}

/*
 * Helper function for 'player_birth()'.
 *
 * This function allows the player to select a sex, race, and class, and
 * modify options (including the birth options).
 */
static bool player_birth_aux_1(void)
{
#if 0
	int i, j, k, n, v;
#else
	int i, k, n, v;
#endif

	cptr str;

	char ch;

#if 0
	char p1 = '(';
#endif
	char p2 = ')';

	char buf[80];
	char inp[80];

#ifdef USE_SCRIPT
	int result;
#endif /* USE_SCRIPT */

	/*** Instructions ***/

	/* Clear screen */
	Term_clear();

	/* Display some helpful information */
#ifdef JP
	Term_putstr(9, 10, -1, TERM_WHITE,
		"ʲμƲɽƤ椫");
	Term_putstr(9, 11, -1, TERM_WHITE,
		"ǲ 'Q' 򲡤ȥλ'S'  ");
	Term_putstr(9, 12, -1, TERM_WHITE,
		"Ƚᤫľ'?' 򲡤ȥإפɽޤ");
	Term_putstr(9, 13, -1, TERM_WHITE,
		"'Q'  'S' ʸϤƲ                       ");
#else
	Term_putstr(5, 10, -1, TERM_WHITE,
	            "Please answer the following questions.  Most of the questions");
	Term_putstr(5, 11, -1, TERM_WHITE,
	            "display a set of standard answers, and many will also accept");
	Term_putstr(5, 12, -1, TERM_WHITE,
	            "some special responses, including 'Q' to quit, 'S' to restart,");
	Term_putstr(5, 13, -1, TERM_WHITE,
	            "and '?' for help.  Note that 'Q' and 'S' must be capitalized.");
#endif



#ifdef USE_SCRIPT
	/*
	 * Ask for the world
	 */
	result = get_world_callback();

	if (result == -1)
		/* Restart */
		return FALSE;

	/* Clean up */
	clear_from(15);
#endif /* USE_SCRIPT */

	/*** Player sex ***/

	/* Extra info */
#ifdef JP
	Term_putstr(9, 15, -1, TERM_WHITE,
		"̡դΰ㤤ϥä˱ƶڤܤޤ");
#else
	Term_putstr(5, 15, -1, TERM_WHITE,
		"Your 'sex' does not have any significant gameplay effects.");
#endif


	/* Prompt for "Sex" */
	for (n = 0; n < MAX_SEXES; n++)
	{
		/* Analyze */
		p_ptr->psex = n;
		sp_ptr = &sex_info[p_ptr->psex];
#ifdef JP
		/* ڤؤ ɽ*/
                str = (english_others == TRUE) ? sp_ptr->E_title : sp_ptr->title;
#else
		str = sp_ptr->title;
#endif


		/* Display */
#ifdef JP
sprintf(buf, "%c%c%s", I2A(n), p2, str);
#else
		sprintf(buf, "%c%c %s", I2A(n), p2, str);
#endif

		put_str(buf, 21 + (n/5), 2 + 15 * (n%5));
	}

	/* Choose */
	while (1)
	{
#ifdef JP
sprintf(buf, "̤ǲ (%c-%c) '*'ǥ, '='ǽץ: ", I2A(0), I2A(n-1));
#else
		sprintf(buf, "Choose a sex (%c-%c), * for random, or = for options: ",
		        I2A(0), I2A(n-1));
#endif

		put_str(buf, 20, 2);
		ch = inkey();
		if (ch == 'Q')
		{
			remove_loc();
			quit(NULL);
		}

		if (ch == 'S') return (FALSE);
		k = (islower(ch) ? A2I(ch) : -1);

		if (ch == '*')
		{
			k = rand_int(MAX_SEXES);
			break;
		}

		k = (islower(ch) ? A2I(ch) : -1);
		if ((k >= 0) && (k < n)) break;
		if (ch == '?') do_cmd_help();
		else if (ch == '=')
		{
			screen_save();
#ifdef JP
do_cmd_options_aux(6, "ץ");
#else
			do_cmd_options_aux(6, "Startup Options");
#endif

			screen_load();
		}
		else bell();
	}

	/* Set sex */
	p_ptr->psex = k;
	sp_ptr = &sex_info[p_ptr->psex];
#ifdef JP
	str = (english_others == TRUE) ? sp_ptr->E_title : sp_ptr->title;
#else
	str = sp_ptr->title;
#endif


	/* Sex */
#ifdef JP
put_str("        :", 3, 1);
#else
	put_str("Sex         :", 3, 1);
#endif

	c_put_str(TERM_L_BLUE, sp_ptr->title, 3, 15);

	/* Clean up */
	clear_from(15);

	/* Choose the players race */
	if (!get_player_race()) return FALSE;

	/* Clean up */
	clear_from(15);

	/* Choose the players class */
	if (!get_player_class()) return FALSE;

	/* Clean up */
	clear_from(15);

	/* Choose the magic realms */
	if (!get_player_realms()) return FALSE;

	/* Clear */
	clear_from(20);

	/*** User enters number of quests ***/
	/* Heino Vander Sanden and Jimmy De Laet */

	/* Extra info */
	Term_putstr(5, 15, -1, TERM_WHITE,
#ifdef JP
"ɬܤΥ(٥ڤӺ٤Υڥ)˲äơɲäΥȤ");
#else
		"You can enter the number of quests you'd like to perform in addition");
#endif

	Term_putstr(5, 16, -1, TERM_WHITE,
#ifdef JP
"ꤹ뤳Ȥޤ");
#else
		"to the two obligatory ones ( Oberon and the Serpent of Chaos )");
#endif

	Term_putstr(5, 17, -1, TERM_WHITE,
#ifdef JP
"ɲåȤԤʤʤ '0'ϤƲ");
#else
		"In case you do not want any additional quests, just enter 0");
#endif


	Term_putstr(5, 18, -1, TERM_WHITE,
#ifdef JP
                "˷ꤹˤ'*'ϤƲ");
#else
		"If you want a random number of random quests, just enter *");
#endif


	/* Ask the number of additional quests */
	while (TRUE)
	{

#ifdef JP
put_str(format("ɲåȤο (%uʲ) ", MAX_RANDOM_QUEST - MIN_RANDOM_QUEST + 1), 20, 2);
#else
		put_str(format("Number of additional quests? (<%u) ", MAX_RANDOM_QUEST - MIN_RANDOM_QUEST + 2), 20, 2);
#endif


		/* Get a the number of additional quest */
		while (TRUE)
		{
			/* Move the cursor */
			put_str("", 20, 37);

			/* Default */
			strcpy(inp, "10");

			/* Get a response (or escape) */
			if (!askfor_aux(inp, 2)) inp[0] = '\0';

			/* Check for random number of quests */
			if (inp[0] == '*')
			{
				/* 0 to 10 random quests */
				v = rand_int(11);
			}
			else
			{
				v = atoi(inp);
			}

			/* Break on valid input */
			if ((v <= MAX_RANDOM_QUEST - MIN_RANDOM_QUEST + 1) && (v >= 0)) break;
		}
		break;
	}

	/* Clear */
	clear_from(15);

	/* Init the random quests */
	init_flags = INIT_ASSIGN;
	p_ptr->inside_quest = MIN_RANDOM_QUEST;
#ifdef JP
	process_dungeon_file("q_info_j.txt", 0, 0, 0, 0);
#else
	process_dungeon_file("q_info.txt", 0, 0, 0, 0);
#endif

	p_ptr->inside_quest = 0;

	/* Prepare allocation table */
	get_mon_num_prep(monster_quest, NULL);

	/* Generate quests */
	for (i = MIN_RANDOM_QUEST + v - 1; i >= MIN_RANDOM_QUEST; i--)
	{
		quest_type      *q_ptr = &quest[i];
		monster_race    *r_ptr;
		monster_race    *quest_r_ptr;
		int             r_idx;

		q_ptr->status = QUEST_STATUS_TAKEN;

		/* You have only once cheance to complete Random Quest */
		q_ptr->flags |= QUEST_FLAG_ONCE;

		while (TRUE)
		{
			/*
			 * Random monster 5 - 10 levels out of depth
			 * (depending on level)
			 */
			r_idx = get_mon_num(q_ptr->level + 4 + randint(q_ptr->level / 10));
			r_ptr = &r_info[r_idx];

			/* Accept Only Unique Monster */
			if(!(r_ptr->flags1 & RF1_UNIQUE)) continue;

			/*
			 * Accept monsters that are 2 - 6 levels
			 * out of depth depending on the quest level
			 */
			if (r_ptr->level > (q_ptr->level + (q_ptr->level / 20) + 1)) break;
		}

		q_ptr->r_idx = r_idx;
		quest_r_ptr = &r_info[q_ptr->r_idx];

		/* Mark uniques */
		quest_r_ptr->flags1 |= RF1_QUESTOR;

		q_ptr->max_num = 1;
	}

	/* Init the two main quests (Oberon + Serpent) */
	init_flags = INIT_ASSIGN;
	p_ptr->inside_quest = QUEST_OBERON;
#ifdef JP
	process_dungeon_file("q_info_j.txt", 0, 0, 0, 0);
#else
	process_dungeon_file("q_info.txt", 0, 0, 0, 0);
#endif

	quest[QUEST_OBERON].status = QUEST_STATUS_TAKEN;

	p_ptr->inside_quest = QUEST_SERPENT;
#ifdef JP
	process_dungeon_file("q_info_j.txt", 0, 0, 0, 0);
#else
	process_dungeon_file("q_info.txt", 0, 0, 0, 0);
#endif

	quest[QUEST_SERPENT].status = QUEST_STATUS_TAKEN;
	p_ptr->inside_quest = 0;

	/* Clear */
	clear_from(14);

	/* Done */
	return (TRUE);
}


/*
 * Initial stat costs (initial stats always range from 10 to 18 inclusive).
 */
static int birth_stat_costs[(18-10)+1] = { 0, 1, 2, 4, 7, 11, 16, 22, 30 };


/*
 * Helper function for 'player_birth()'.
 *
 * This function handles "point-based" character creation.
 *
 * The player selects, for each stat, a value from 10 to 18 (inclusive),
 * each costing a certain amount of points (as above), from a pool of 48
 * available points, to which race/class modifiers are then applied.
 *
 * Each unused point is converted into 100 gold pieces.
 */
static bool player_birth_aux_2(void)
{
	int i;

	int row = 3;
	int col = 42;

	int stat = 0;

	int stats[A_MAX];

	int cost;

	char ch;

	char buf[80];


	/* Initialize stats */
	for (i = 0; i < A_MAX; i++)
	{
		/* Initial stats */
		stats[i] = 10;
	}


	/* Roll for base hitpoints */
	get_extra();

	/* Roll for age/height/weight */
	get_ahw();

	/* Roll for social class */
	get_history();
	
	/* Hack -- get a chaos patron even if you are not a chaos warrior */
	p_ptr->chaos_patron = (s16b)rand_int(MAX_PATRON);

	p_ptr->muta1 = 0;
	p_ptr->muta2 = 0;
	p_ptr->muta3 = 0;


	/* Interact */
	while (1)
	{
		/* Reset cost */
		cost = 0;

		/* Process stats */
		for (i = 0; i < A_MAX; i++)
		{
			/* Variable stat maxes */
			if (maximize_mode)
			{
				/* Reset stats */
				p_ptr->stat_cur[i] = p_ptr->stat_max[i] = stats[i];

			}

			/* Fixed stat maxes */
			else
			{
				/* Obtain a "bonus" for "race" and "class" */
				int bonus = rp_ptr->r_adj[i] + cp_ptr->c_adj[i];

				/* Apply the racial/class bonuses */
				p_ptr->stat_cur[i] = p_ptr->stat_max[i] =
					modify_stat_value(stats[i], bonus);
			}

			/* Total cost */
			cost += birth_stat_costs[stats[i] - 10];
		}

		/* Restrict cost */
		if (cost > 48)
		{
			/* Warning */
#ifdef JP
			bell();
#else
			bell();
#endif


			/* Reduce stat */
			stats[stat]--;

			/* Recompute costs */
			continue;
		}

		/* Gold is inversely proportional to cost */
		p_ptr->au = (100 * (48 - cost)) + 100;

		/* Calculate the bonuses and hitpoints */
		p_ptr->update |= (PU_BONUS | PU_HP);

		/* Update stuff */
		update_stuff();

		/* Fully healed */
		p_ptr->chp = p_ptr->mhp;

		/* Fully rested */
		p_ptr->csp = p_ptr->msp;

		/* Display the player */
		display_player(0);

		/* Display the costs header */
#ifdef JP
put_str("", row - 2, col + 32);
#else
		put_str("Cost", row - 2, col + 32);
#endif


		/* Display the costs */
		for (i = 0; i < A_MAX; i++)
		{
			/* Display cost */
			sprintf(buf, "%4d", birth_stat_costs[stats[i] - 10]);
			put_str(buf, row + (i-1), col + 32);
		}


		/* Prompt XXX XXX XXX */
#ifdef JP
sprintf(buf, "ȹ: %2d/48  2/8 ǰư,  4/6 ѹ,  ESC ǽλ", cost);
#else
		sprintf(buf, "Total Cost %2d/48.  Use 2/8 to move, 4/6 to modify, ESC to accept.", cost);
#endif

		prt(buf, 0, 0);

		/* Place cursor just after cost of current stat */
		Term_gotoxy(col + 36, row + stat - 1);

		/* Get key */
		ch = inkey();

		/* Quit */
		if (ch == 'Q') quit(NULL);

		/* Start over */
		if (ch == 'S') return (FALSE);

		/* Done */
		if (ch == ESCAPE) break;

		/* Prev stat */
		if (ch == '8')
		{
			stat = (stat + 5) % 6;
		}

		/* Next stat */
		if (ch == '2')
		{
			stat = (stat + 1) % 6;
		}

		/* Decrease stat */
		if ((ch == '4') && (stats[stat] > 10))
		{
			stats[stat]--;
		}

		/* Increase stat */
		if ((ch == '6') && (stats[stat] < 18))
		{
			stats[stat]++;
		}
	}


	/* Done */
	return (TRUE);
}


/*
 * Helper function for 'player_birth()'.
 *
 * This function handles "auto-rolling" and "random-rolling".
 *
 * The delay may be reduced, but is recommended to keep players
 * from continuously rolling up characters, which can be VERY
 * expensive CPU wise.  And it cuts down on player stupidity.
 */
static bool player_birth_aux_3(void)
{
	int i, j, m, v;

	bool flag;
	bool prev = FALSE;

	char ch;

	char b1 = '[';
	char b2 = ']';

	char buf[80];


#ifdef ALLOW_AUTOROLLER

	s16b stat_limit[A_MAX];

	s32b stat_match[A_MAX];

	s32b auto_round = 0L;

	s32b last_round;


	/*** Autoroll ***/

	/* Initialize */
	if (autoroller)
	{
		int mval[A_MAX];

		char inp[80];


		/* Clean up */
		clear_from(10);

		/* Extra info */
		Term_putstr(5, 10, -1, TERM_WHITE,
#ifdef JP
            "ȥ顼Ѥȡʲꤵ줿ͤ㤤ơ");
#else
		            "The auto-roller will automatically ignore characters which do");
#endif

		Term_putstr(5, 11, -1, TERM_WHITE,
#ifdef JP
            "ĤǤ⤢륭饯̵뤵ޤ");
#else
		            "not meet the minimum values for any stats specified below.");
#endif

		Term_putstr(5, 12, -1, TERM_WHITE,
#ifdef JP
            "ƥơΩǤϤʤΤǡƤΥơǺǹͤޤ");
#else
		            "Note that stats are not independant, so it is not possible to");
#endif

		Term_putstr(5, 13, -1, TERM_WHITE,
#ifdef JP
            "˶ᤤͤ뤳ȤϤۤԲǽǤ뤳ȤդƲ");
#else
		            "get perfect (or even high) values for all your stats.");
#endif


		/* Prompt for the minimum stats */
#ifdef JP
put_str("ǾͤϤƲ:", 15, 2);
#else
		put_str("Enter minimum value for: ", 15, 2);
#endif


		/* Output the maximum stats */
		for (i = 0; i < A_MAX; i++)
		{
			/* Reset the "success" counter */
			stat_match[i] = 0;

			/* Race/Class bonus */
			j = rp_ptr->r_adj[i] + cp_ptr->c_adj[i];

			/* Obtain the "maximal" stat */
			m = adjust_stat(17, j, TRUE);

			/* Save the maximum */
			mval[i] = m;

			/* Extract a textual format */
			/* cnv_stat(m, inp); */

			/* Above 18 */
			if (m > 18)
			{
#ifdef JP
				sprintf(inp, "( 18/%02d):", (m - 18));
#else
				sprintf(inp, "(Max of 18/%02d):", (m - 18));
#endif

			}

			/* From 3 to 18 */
			else
			{
#ifdef JP
				sprintf(inp, "( %2d):", m);
#else
				sprintf(inp, "(Max of %2d):", m);
#endif

			}

			/* Prepare a prompt */
			sprintf(buf, "%-5s%-20s", stat_names[i], inp);

			/* Dump the prompt */
			put_str(buf, 16 + i, 5);
		}

		/* Input the minimum stats */
		for (i = 0; i < A_MAX; i++)
		{
			/* Get a minimum stat */
			while (TRUE)
			{
				char *s;

				/* Move the cursor */
				put_str("", 16 + i, 30);

				/* Default */
				strcpy(inp, "");

				/* Get a response (or escape) */
				if (!askfor_aux(inp, 8)) inp[0] = '\0';

				/* Hack -- add a fake slash */
				strcat(inp, "/");

				/* Hack -- look for the "slash" */
				s = strchr(inp, '/');

				/* Hack -- Nuke the slash */
				*s++ = '\0';

				/* Hack -- Extract an input */
				v = atoi(inp) + atoi(s);

				/* Break on valid input */
				if (v <= mval[i]) break;
			}

			/* Save the minimum stat */
			stat_limit[i] = (v > 0) ? v : 0;
		}
	}

#endif /* ALLOW_AUTOROLLER */

	/* Clean up */
	clear_from(10);


	/*** Generate ***/

	/* Roll */
	while (TRUE)
	{
		int col = 42;

		/* Feedback */
		if (autoroller)
		{
			Term_clear();

			/* Label */
#ifdef JP
			put_str("Ǿ", 2, col+5);
#else
			put_str(" Limit", 2, col+5);
#endif


			/* Label */
#ifdef JP
			put_str("Ψ", 2, col+13);
#else
			put_str("  Freq", 2, col+13);
#endif


			/* Label */
#ifdef JP
			put_str("", 2, col+24);
#else
			put_str("  Roll", 2, col+24);
#endif


			/* Put the minimal stats */
			for (i = 0; i < A_MAX; i++)
			{
				/* Label stats */
				put_str(stat_names[i], 3+i, col);

				/* Put the stat */
				cnv_stat(stat_limit[i], buf);
				c_put_str(TERM_L_BLUE, buf, 3+i, col+5);
			}

			/* Note when we started */
			last_round = auto_round;

			/* Label count */
#ifdef JP
			put_str(" :", 10, col+13);
#else
			put_str("Round:", 10, col+13);
#endif


			/* Indicate the state */
#ifdef JP
			put_str("(ESC)", 12, col+13);
#else
			put_str("(Hit ESC to stop)", 12, col+13);
#endif


			/* Auto-roll */
			while (1)
			{
				bool accept = TRUE;

				/* Get a new character */
				get_stats();

				/* Advance the round */
				auto_round++;

				/* Hack -- Prevent overflow */
				if (auto_round >= 1000000L) break;

				/* Check and count acceptable stats */
				for (i = 0; i < A_MAX; i++)
				{
					/* This stat is okay */
					if (stat_use[i] >= stat_limit[i])
					{
						stat_match[i]++;
					}

					/* This stat is not okay */
					else
					{
						accept = FALSE;
					}
				}

				/* Break if "happy" */
				if (accept) break;

				/* Take note every 25 rolls */
				flag = (!(auto_round % 25L));

				/* Update display occasionally */
				if (flag || (auto_round < last_round + 100))
				{
					/* Put the stats (and percents) */
					for (i = 0; i < A_MAX; i++)
					{
						/* Put the stat */
						cnv_stat(stat_use[i], buf);
						c_put_str(TERM_L_GREEN, buf, 3+i, col+24);

						/* Put the percent */
						if (stat_match[i])
						{
							int p = 1000L * stat_match[i] / auto_round;
							byte attr = (p < 100) ? TERM_YELLOW : TERM_L_GREEN;
							sprintf(buf, "%3d.%d%%", p/10, p%10);
							c_put_str(attr, buf, 3+i, col+13);
						}

						/* Never happened */
						else
						{
#ifdef JP
c_put_str(TERM_RED, "(ʤ)", 3+i, col+13);
#else
							c_put_str(TERM_RED, "(NONE)", 3+i, col+13);
#endif

						}
					}

					/* Dump round */
					put_str(format("%10ld", auto_round), 10, col+20);

					/* Make sure they see everything */
					Term_fresh();

					/* Delay 1/10 second */
					if (flag && delay_autoroll) Term_xtra(TERM_XTRA_DELAY, 100);

					/* Do not wait for a key */
					inkey_scan = TRUE;

					/* Check for a keypress */
					if (inkey()) break;
				}
			}
		}

		/* Otherwise just get a character */
		else
		{
			/* Get a new character */
			get_stats();
		}

		/* Flush input */
		flush();


		/*** Display ***/

		/* Roll for base hitpoints */
		get_extra();

		/* Roll for age/height/weight */
		get_ahw();

		/* Roll for social class */
		get_history();

		/* Roll for gold */
		get_money();

		/* Hack -- get a chaos patron even if you are not a chaos warrior */
		p_ptr->chaos_patron = (s16b)rand_int(MAX_PATRON);

		p_ptr->muta1 = 0;
		p_ptr->muta2 = 0;
		p_ptr->muta3 = 0;

		/* Input loop */
		while (TRUE)
		{
			/* Calculate the bonuses and hitpoints */
			p_ptr->update |= (PU_BONUS | PU_HP);

			/* Update stuff */
			update_stuff();

			/* Fully healed */
			p_ptr->chp = p_ptr->mhp;

			/* Fully rested */
			p_ptr->csp = p_ptr->msp;

			/* Display the player */
			display_player(0);

			/* Prepare a prompt (must squeeze everything in) */
			Term_gotoxy(2, 23);
			Term_addch(TERM_WHITE, b1);
#ifdef JP
Term_addstr(-1, TERM_WHITE, "'r'Ǽο");
#else
			Term_addstr(-1, TERM_WHITE, "'r' to reroll");
#endif

#ifdef JP
if (prev) Term_addstr(-1, TERM_WHITE, ", 'p'ο");
#else
			if (prev) Term_addstr(-1, TERM_WHITE, ", 'p' for prev");
#endif

#ifdef JP
Term_addstr(-1, TERM_WHITE, ", ESCǤοͤ˷");
#else
			Term_addstr(-1, TERM_WHITE, ", or ESC to accept");
#endif

			Term_addch(TERM_WHITE, b2);

			/* Prompt and get a command */
			ch = inkey();

			/* Quit */
			if (ch == 'Q') quit(NULL);

			/* Start over */
			if (ch == 'S') return (FALSE);

			/* Escape accepts the roll */
			if (ch == ESCAPE) break;

			/* Reroll this character */
			if ((ch == ' ') || (ch == 'r')) break;

			/* Previous character */
			if (prev && (ch == 'p'))
			{
				load_prev_data();
				continue;
			}

			/* Help */
			if (ch == '?')
			{
				do_cmd_help();
				continue;
			}
			else if (ch == '=')
			{
				screen_save();
#ifdef JP
do_cmd_options_aux(6, "ץ");
#else
				do_cmd_options_aux(6, "Startup Options");
#endif

				screen_load();
				continue;
			}

			/* Warning */
			bell();
		}

		/* Are we done? */
		if (ch == ESCAPE) break;

		/* Save this for the "previous" character */
		save_prev_data();

		/* Note that a previous roll exists */
		prev = TRUE;
	}

	/* Clear prompt */
	clear_from(23);

	/* Done */
	return (TRUE);
}


static bool player_birth_aux(void)
{
	char ch;

	/* Ask questions */
	if (!player_birth_aux_1()) return FALSE;

	/* Point based */
	if (point_based)
	{
		if (!player_birth_aux_2()) return FALSE;
	}

	/* Auto-roll */
	else
	{
		if (!player_birth_aux_3()) return FALSE;
	}

	/* Get a name, prepare savefile */
	get_character_name();

	/* Initialize the virtues */
	get_virtues();

	/* Display the player */
	display_player(0);

	/* Prompt for it */
#ifdef JP
	prt("[ 'Q' , 'S' ǽᤫ, ESC ǥ೫ ]", 23, 14);
#else
	prt("['Q' to suicide, 'S' to start over, or ESC to continue]", 23, 10);
#endif


	/* Get a key */
	ch = inkey();

	/* Quit */
	if (ch == 'Q') quit(NULL);

	/* Start over */
	if (ch == 'S') return (FALSE);

	/* Accept */
	return (TRUE);
}


/*
 * Create a new character.
 *
 * Note that we may be called with "junk" leftover in the various
 * fields, so we must be sure to clear them first.
 */
void player_birth(void)
{
	int i, j;


	/* Initialize Playtime */
	playtime = 0;

	/* Create a new character */
	while (1)
	{
		/* Wipe the player */
		player_wipe();

		/* Roll up a new character */
		if (player_birth_aux()) break;
	}

	/* Create a note file if that option is set */
	if (take_notes)
	{
		add_note_type(NOTE_BIRTH);
	}

	/* Note player birth in the message recall */
	message_add(" ");
	message_add("  ");
	message_add("====================");
	message_add("  ");
	message_add(" ");

	/* Hack -- outfit the player */
	player_outfit();

	/* Init the shops */
	for (i = 1; i < max_towns; i++)
	{
		for (j = 0; j < MAX_STORES; j++)
		{
			/* Initialize */
			store_init(i, j);
		}
	}

	/* Set the message window flag as default */
	if (!window_flag[1])
		window_flag[1] |= PW_MESSAGE;

	/* Set the inv/equip window flag as default */
	if (!window_flag[2])
		window_flag[2] |= PW_INVEN;
}
