/* File: japanese.c */


/*
 * Copyright (c) 1997 Ben Harrison
 *
 * This software may be copied and distributed for educational, research,
 * and not for profit purposes provided that this copyright and statement
 * are included in all such copies.  Other copyrights may also apply.
 */

#include "angband.h"

#ifdef JP

/*
 * θ strstr
 */
cptr strstr_j(const char* s, const char* t)
{
      int i, l1, l2;

      l1 = strlen(s);
      l2 = strlen(t);
      if (l1 >= l2) {
              for(i = 0; i <= l1 - l2; i++) {
                      if(!strncmp(s + i, t, l2))
                              return s + i;
                      if (iskanji(*(s + i)))
                              i++;
              }
      }
      return NULL;
}

/*
 * Find valid breakpoint in a Japanese string
 */
int null_pos_j(const char* s, int maxpos)
{
    int i = 0;

    while (s[i] != 0 && i < ((iskanji(s[i])) ? maxpos-1 : maxpos))
      i+= iskanji(s[i]) ? 2 : 1;

    return(i);
}

typedef struct convert_key convert_key;

struct convert_key {
  char *key1;
  char *key2;
};

static const convert_key s2j_table[]= {
{"mb","nb"},{"mp","np"},{"mv","nv"},{"mm","nm"},
{"x","ks"},
  /* sindar:  parantir:ѥƥ  feanor:եΡ */
{"ar$","a-ru$"},{"ir$","ia$"},{"or$","o-ru$"},
{"ra",""},{"ri",""},{"ru",""},{"re",""},{"ro",""},
{"ir","ia"},{"ur","ua"},{"er","ea"},
{"ar","aru"},
{"sha",""},{"shi",""},{"shu",""},{"she",""},{"sho",""},
{"tha",""},{"thi",""},{"thu",""},{"the",""},{"tho",""},
{"cha",""},{"chi",""},{"chu",""},{"che",""},{"cho",""},
{"dha",""},{"dhi",""},{"dhu",""},{"dhe",""},{"dho",""},
{"ba",""},{"bi",""},{"bu",""},{"be",""},{"bo",""},
{"ca",""},{"ci",""},{"cu",""},{"ce",""},{"co",""},
{"da",""},{"di","ǥ"},{"du","ɥ"},{"de",""},{"do",""},
{"fa","ե"},{"fi","ե"},{"fu",""},{"fe","ե"},{"fo","ե"},
{"ga",""},{"gi",""},{"gu",""},{"ge",""},{"go",""},
{"ha",""},{"hi",""},{"hu",""},{"he",""},{"ho",""},
{"ja",""},{"ji",""},{"ju",""},{"je",""},{"jo",""},
{"ka",""},{"ki",""},{"ku",""},{"ke",""},{"ko",""},
{"la",""},{"li",""},{"lu",""},{"le",""},{"lo",""},
{"ma",""},{"mi",""},{"mu",""},{"me",""},{"mo",""},
{"na",""},{"ni",""},{"nu",""},{"ne",""},{"no",""},
{"pa",""},{"pi",""},{"pu",""},{"pe",""},{"po",""},
{"qu",""},
{"sa",""},{"si",""},{"su",""},{"se",""},{"so",""},
{"ta",""},{"ti","ƥ"},{"tu","ȥ"},{"te",""},{"to",""},
{"va",""},{"vi",""},{"vu",""},{"ve",""},{"vo",""},
{"wa",""},{"wi",""},{"wu",""},{"we",""},{"wo",""},
{"ya",""},{"yu",""},{"yo",""},
{"za",""},{"zi",""},{"zu",""},{"ze",""},{"zo",""},
{"dh",""},{"ch",""},{"th",""},
{"b",""},{"c",""},{"d",""},{"f",""},{"g",""},
{"h",""},{"j",""},{"k",""},{"l",""},{"m",""},
{"n",""},{"p",""},{"q",""},{"r",""},{"s",""},
{"t",""},{"v",""},{"w",""},{"y",""},
{"a",""},{"i",""},{"u",""},{"e",""},{"o",""},
{"-",""},
{NULL,NULL}
};

unsigned char *sindarin_to_kana(unsigned char *sindarin){
static unsigned char buf1[256], buf2[256];
int idx;

sprintf(buf1,"%s$",sindarin);
for (idx=0; buf1[idx]; idx++) if (isupper(buf1[idx])) buf1[idx] = tolower(buf1[idx]);

for (idx=0; s2j_table[idx].key1 != NULL; idx++){
  unsigned char *pat1 = s2j_table[idx].key1;
  unsigned char *pat2 = s2j_table[idx].key2;
  int len=strlen(pat1);
  unsigned char *dest = buf2;
  unsigned char *src = buf1;
 
  while (*src){
    if( strncmp(src, pat1, len)==0 )
    {
      strcpy(dest, pat2);
      src+= len;
      dest+= strlen(pat2);
    } else {
        if( iskanji(*src) )
	{
	  *dest = *src;
	  dest++; src++;
	}
      *dest=*src;
      dest++; src++;
    }
  }
  *dest=0;
  strcpy(buf1,buf2);
}
idx=0;
while( buf1[idx] != '$' ) idx++;
buf1[idx]=0;
return(buf1);
}


/*ܸư (ǤġǤä,Ǥ etc) */

#define CMPTAIL(y) strncmp(&in[l-strlen(y)],y,strlen(y))

/* ,䲥, */
void jverb1( const char *in , char *out){
int l=strlen(in);
strcpy(out,in);

if( CMPTAIL("")==0) sprintf(&out[l-4],"");else
if( CMPTAIL("")==0) sprintf(&out[l-4],"");else

if( CMPTAIL("")==0) sprintf(&out[l-4],"");else
if( CMPTAIL("")==0) sprintf(&out[l-4],"");else
if( CMPTAIL("")==0) sprintf(&out[l-4],"");else
if( CMPTAIL("")==0) sprintf(&out[l-4],"");else
if( CMPTAIL("")==0) sprintf(&out[l-4],"");else
if( CMPTAIL("Ƥ")==0) sprintf(&out[l-4],"");else
if( CMPTAIL("Ǥ")==0) sprintf(&out[l-4],"");else
if( CMPTAIL("ͤ")==0) sprintf(&out[l-4],"");else
if( CMPTAIL("ؤ")==0) sprintf(&out[l-4],"");else
if( CMPTAIL("٤")==0) sprintf(&out[l-4],"");else
if( CMPTAIL("")==0) sprintf(&out[l-4],"");else
if( CMPTAIL("")==0) sprintf(&out[l-4],"");else

if( CMPTAIL("")==0) sprintf(&out[l-2],"");else
if( CMPTAIL("")==0) sprintf(&out[l-2],"");else
if( CMPTAIL("")==0) sprintf(&out[l-2],"");else
if( CMPTAIL("")==0) sprintf(&out[l-2],"");else
if( CMPTAIL("")==0) sprintf(&out[l-2],"");else
if( CMPTAIL("")==0) sprintf(&out[l-2],"");else
if( CMPTAIL("")==0) sprintf(&out[l-2],"");else
if( CMPTAIL("")==0) sprintf(&out[l-2],"");else
if( CMPTAIL("")==0) sprintf(&out[l-2],"");else
if( CMPTAIL("")==0) sprintf(&out[l-2],"");else
if( CMPTAIL("")==0) sprintf(&out[l-2],"");else
if( CMPTAIL("")==0) sprintf(&out[l-2],"");else

  sprintf(&out[l],"");}

/* ,> äƽ */
void jverb2( const char *in , char *out){
int l=strlen(in);
strcpy(out,in);

if( CMPTAIL("")==0) sprintf(&out[l-4],"");else
if( CMPTAIL("")==0) sprintf(&out[l-4],"");else

if( CMPTAIL("")==0) sprintf(&out[l-4],"");else
if( CMPTAIL("")==0) sprintf(&out[l-4],"");else
if( CMPTAIL("")==0) sprintf(&out[l-4],"");else
if( CMPTAIL("")==0) sprintf(&out[l-4],"");else
if( CMPTAIL("")==0) sprintf(&out[l-4],"");else
if( CMPTAIL("Ƥ")==0) sprintf(&out[l-4],"Ƥä");else
if( CMPTAIL("Ǥ")==0) sprintf(&out[l-4],"Ǥ");else
if( CMPTAIL("ͤ")==0) sprintf(&out[l-4],"ͤ");else
if( CMPTAIL("ؤ")==0) sprintf(&out[l-4],"ؤ");else
if( CMPTAIL("٤")==0) sprintf(&out[l-4],"٤");else
if( CMPTAIL("")==0) sprintf(&out[l-4],"");else
if( CMPTAIL("")==0) sprintf(&out[l-4],"");else

if( CMPTAIL("")==0) sprintf(&out[l-2],"ä");else
if( CMPTAIL("")==0) sprintf(&out[l-2],"");else
if( CMPTAIL("")==0) sprintf(&out[l-2],"");else
if( CMPTAIL("")==0) sprintf(&out[l-2],"");else
if( CMPTAIL("")==0) sprintf(&out[l-2],"");else
if( CMPTAIL("")==0) sprintf(&out[l-2],"ä");else
if( CMPTAIL("")==0) sprintf(&out[l-2],"ä");else
if( CMPTAIL("")==0) sprintf(&out[l-2],"ͤ");else
if( CMPTAIL("")==0) sprintf(&out[l-2],"ؤ");else
if( CMPTAIL("")==0) sprintf(&out[l-2],"");else
if( CMPTAIL("")==0) sprintf(&out[l-2],"");else
if( CMPTAIL("")==0) sprintf(&out[l-2],"ä");else
  sprintf(&out[l],"Ȥˤ");}

/* , > ä꽳ä */
void jverb3( const char *in , char *out){
int l=strlen(in);
strcpy(out,in);

if( CMPTAIL("")==0) sprintf(&out[l-4],"");else
if( CMPTAIL("")==0) sprintf(&out[l-4],"");else

if( CMPTAIL("")==0) sprintf(&out[l-4],"");else
if( CMPTAIL("")==0) sprintf(&out[l-4],"");else
if( CMPTAIL("")==0) sprintf(&out[l-4],"");else
if( CMPTAIL("")==0) sprintf(&out[l-4],"");else
if( CMPTAIL("")==0) sprintf(&out[l-4],"");else
if( CMPTAIL("Ƥ")==0) sprintf(&out[l-4],"Ƥä");else
if( CMPTAIL("Ǥ")==0) sprintf(&out[l-4],"Ǥ");else
if( CMPTAIL("ͤ")==0) sprintf(&out[l-4],"ͤ");else
if( CMPTAIL("ؤ")==0) sprintf(&out[l-4],"ؤ");else
if( CMPTAIL("٤")==0) sprintf(&out[l-4],"٤");else
if( CMPTAIL("")==0) sprintf(&out[l-4],"᤿");else
if( CMPTAIL("")==0) sprintf(&out[l-4],"줿");else

if( CMPTAIL("")==0) sprintf(&out[l-2],"ä");else
if( CMPTAIL("")==0) sprintf(&out[l-2],"");else
if( CMPTAIL("")==0) sprintf(&out[l-2],"");else
if( CMPTAIL("")==0) sprintf(&out[l-2],"");else
if( CMPTAIL("")==0) sprintf(&out[l-2],"");else
if( CMPTAIL("")==0) sprintf(&out[l-2],"ä");else
if( CMPTAIL("")==0) sprintf(&out[l-2],"ä");else
if( CMPTAIL("")==0) sprintf(&out[l-2],"ͤ");else
if( CMPTAIL("")==0) sprintf(&out[l-2],"ؤ");else
if( CMPTAIL("")==0) sprintf(&out[l-2],"");else
if( CMPTAIL("")==0) sprintf(&out[l-2],"");else
if( CMPTAIL("")==0) sprintf(&out[l-2],"ä");else
  sprintf(&out[l],"Ȥ");}


void jverb( const char *in , char *out , int flag){
  switch (flag){
  case JVERB_AND:jverb1(in , out);break;
  case JVERB_TO :jverb2(in , out);break;
  case JVERB_OR :jverb3(in , out);break;
  }
}

/*
 *   ܸޤĹʸŬʰ֤ǲԤƥ˽񤭹
 *   : str = " abc dddd eeeeeeeee", wlen = 6
 *   ΤȤ tbuf="\0\0abc\0dddd\0eeeeee\0eee\0\0"
 */
void roff_to_buf(char * str, int wlen, char *tbuf)
{
   /* temp ǲԤǤָΰ */
   int wpos = -1;

   /* ϥХåե tbuf θߤν񤭹߰ */
   int dpos = 0;

   /* ߤιԤ˲ʸ񤤤 */
   int len = 0;

   bool wrap;
   int i;
   char ch[3], temp [128];
   ch[2]=0;

	/* Scan the given string, character at a time */
	for (; *str; str++)
	{
                int k_flag = iskanji((unsigned char)(*str));
		ch[0] = *str; ch[1] = 0;
                if( k_flag ) {str++; ch[1] = *str;}

		/* Erase illegal char */
                if (!isprint(ch[0]) && !k_flag ) ch[0] = ' ';

                wrap = (ch[0] == '\n' || len >= wlen);

		/* Խ */
		if (wrap)
		{
			if (wpos == -1) wpos = len;

			/* Բǽ֤ǲ */
			strncpy(&tbuf[dpos], temp, wpos);
			tbuf[dpos + wpos] = '\0';
			dpos+=wpos+1;
			/* Ĥäʸ temp Ƭ˰ư ϥå*/
			while (temp[wpos] == ' ') wpos++;
			for (i = 0; i < len - wpos; i++) temp[i] = temp[wpos + i]; 
			len-=wpos;
			wpos = -1;
		}

		/* ֤߰ǲԲǽ */
		if (strcmp(ch," ")==0 ||
		    (k_flag && strcmp(ch, "") != 0 && 
		     strcmp(ch, "") != 0 &&
		     strcmp(ch, "") != 0 &&
		     strcmp(ch, "") != 0)) wpos = len;

		/* temp ˥ԡ */
                if (len>0 || strcmp(ch," "))
		{
		    strcpy(&temp[len], ch); 
		    len+= k_flag ? 2:1;
		}
	}
	
	/* Ĥ򥳥ԡ */
	strncpy(&tbuf[dpos], temp, len);
	tbuf[dpos + len] = '\0';
	dpos+=len+1;
	tbuf[dpos] = 0;
}

/* Ϳ줿ʸ򤽤줾δĶ˹äɤˤ */
void codeconv(char *str)
{
  int i;
  int kanji, iseuc;
  unsigned char c1, c2;
  unsigned char tmp[256];
  
  /* ¸ߤδɤEUCɤĴ٤롣*/
  kanji = 0;
  iseuc = 1;
  for(i = 0; str[i]; i++){
    c1 = str[i];
    if (c1 & 0x80)  kanji = 1;
    if ( c1>=0x80 && (c1 < 0xa1 || c1 > 0xfe)) iseuc = 0;
  }
#ifdef EUC
  if (kanji && !iseuc) { /* SJIS -> EUC */
    for(i = 0; str[i]; i++){
      c1 = str[i];
      if (c1 & 0x80) {
        i++;
        c2 = str[i];
        if (c2 >= 0x9f) {
          c1 = c1 * 2 - (c1 >= 0xe0 ? 0xe0 : 0x60);
          c2 += 2;
        } else {
          c1 = c1 * 2 - (c1 >= 0xe0 ? 0xe1 : 0x61);
          c2 += 0x60 + (c2 < 0x7f);
        }
        tmp[i - 1] = c1;
        tmp[i] = c2;
      } else
        tmp[i] = c1;
    }
    tmp[i] = '\0';
    strcpy(str, tmp);
  }
#endif

#ifdef SJIS
  if (kanji && iseuc) { /* EUC -> SJIS */
    for (i = 0; str[i]; i++) {
      c1 = str[i];
      if (c1 & 0x80) {
        i++;
        c2 = str[i];
        if (c1 % 2) {
          c1 = (c1 >> 1) + (c1 < 0xdf ? 0x31 : 0x71);
          c2 -= 0x60 + (c2 < 0xe0);
        } else {
          c1 = (c1 >> 1) + (c1 < 0xdf ? 0x30 : 0x70);
          c2 -= 2;
        }
        tmp[i - 1] = c1;
        tmp[i] = c2;
      } else
        tmp[i] = c1;
    }
    tmp[i] = '\0';
    strcpy(str, tmp);
  }
#endif
}

#endif
