#include "angband.h"

#ifdef CHUUKEI

#include <stdio.h>
#include <stdarg.h>
#include <ctype.h>

#if defined(WINDOWS)
#include <winsock.h>
#elif defined(MACINTOSH)
#include <OpenTransport.h>
#include <OpenTptInternet.h>
#else
#include <sys/types.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <netdb.h>
#include <sys/time.h>
#include <arpa/inet.h>

#include <setjmp.h>
#include <signal.h>
#endif

#include <stdlib.h>


static int sd; /* å */

int connect_chuukei_server(char *server_string){
#ifdef WINDOWS
	WSADATA wsaData;
	WORD wVersionRequested =(WORD) (( 1) |  ( 1 << 8));
#endif

	struct sockaddr_in ask;
	struct hostent *hp;
	int server_port;
	char *server_name;
  
#ifdef WINDOWS
	if(WSAStartup(wVersionRequested, &wsaData)){
		msg_print("Report: WSAStartup failed.");
		return -1;
	}
#endif

	server_port = atoi(strchr(server_string, ':')+1);
	*strchr(server_string, ':') = 0;
	server_name = server_string;
	printf("server = %s\nport = %d\n", server_name, server_port);

	if((hp=gethostbyname(server_name)) != NULL){
		memset(&ask, 0, sizeof(ask));
		memcpy(&ask.sin_addr, hp->h_addr_list[0], hp->h_length);
	}else{
		if((ask.sin_addr.s_addr=inet_addr(server_name)) == 0){
			printf("Bad hostname\n");
			return -1;
		}
	}

	ask.sin_family=AF_INET;
	ask.sin_port = htons(server_port);

#ifndef WINDOWS
	if((sd=socket(PF_INET,SOCK_STREAM, 0)) < 0){
#else
	if((sd=socket(PF_INET,SOCK_STREAM, 0)) == INVALID_SOCKET){
#endif
		printf("Can't create socket\n");
		return -1;
	}

	if(connect(sd, (struct sockaddr *)&ask, sizeof(ask)) < 0){
#ifndef WINDOWS
		close(sd);
#else
		closesocket(sd);
#endif
		printf("Can't connect %s port %d\n", server_name, server_port);
		return -1;
	}

	return 0;
}

static void send_to_chuukei_server(char *string)
{
	int left;
	left = strlen(string)+1; /* üʸ */
	while( left > 0 ){
		int written = send(sd, string, left, 0);
		if( written <= 0 ) exit(1);
		left -= written;
		string += written;
	}
}

#ifdef SJIS
static void sjis2euc(char *str)
{
	int i, l;
	unsigned char c1, c2;
	int kanji = 0;
	int iseuc = 1;
	l=strlen(str);
	for (i = 0; i < l; i++) {
		c1 = str[i];
		if (c1 & 0x80)  kanji = 1;
		if ( c1>=0x80 && (c1 < 0xa1 || c1 > 0xfe)) iseuc = 0;
	}
	if (kanji && !iseuc) {
		unsigned char   tmp[256];
		for (i = 0; i < l; i++) {
			c1 = str[i];
			if (c1 & 0x80) {
				i++;
				c2 = str[i];
				if (c2 >= 0x9f) {
					c1 = c1 * 2 - (c1 >= 0xe0 ? 0xe0 : 0x60);
					c2 += 2;
				} else {
					c1 = c1 * 2 - (c1 >= 0xe0 ? 0xe1 : 0x61);
					c2 += 0x60 + (c2 < 0x7f);
				}
				tmp[i - 1] = c1;
				tmp[i] = c2;
			} else
				tmp[i] = c1;
		}
		tmp[l] = 0;
		strcpy(str, tmp);
	}
}  

static void euc2sjis(char *str)
{
	int i, l;
	unsigned char c1, c2;
	int kanji = 0;
	int iseuc = 1;
	l=strlen(str);
	for (i = 0; i < l; i++) {
		c1 = str[i];
		if (c1 & 0x80)  kanji = 1;
		if ( c1>=0x80 && (c1 < 0xa1 || c1 > 0xfe)) iseuc = 0;
	}
	if (kanji && iseuc) {
		unsigned char   tmp[256];
		for (i = 0; i < l; i++) {
			c1 = str[i];
			if (c1 & 0x80) {
				i++;
				c2 = str[i];
				if (c1 % 2) {
					c1 = (c1 >> 1) + (c1 < 0xdf ? 0x31 : 0x71);
					c2 -= 0x60 + (c2 < 0xe0);
				} else {
					c1 = (c1 >> 1) + (c1 < 0xdf ? 0x30 : 0x70);
					c2 -= 2;
				}
				tmp[i - 1] = c1;
				tmp[i] = c2;
			} else
				tmp[i] = c1;
		}
		tmp[l] = 0;
		strcpy(str, tmp);
	}
}  
#endif

/* strƱʸη֤ɤĴ٤ */
static bool string_is_repeat(char *str, int len)
{
	char c = str[0];
	int i;
	if(len < 2) return FALSE;
	if(iskanji(c)) return FALSE;
	for(i = 1; i < len; i++){
		if( c != str[i] || iskanji(str[i]) ) return FALSE;
	}
	return TRUE;
}

void send_text_to_chuukei_server(int x, int y, int len, int col, char *str)
{
	char buf[1024];
	char buf2[1024];

	if(!chuukei_server || Term != angband_term[0]) return;
	strncpy(buf2, str, len);
	buf2[len] = '\0';
#ifdef SJIS
	sjis2euc(buf2);
#endif
	if(len == 1){
		sprintf(buf, "s%c%c%c%c", x+1, y+1, col, buf2[0]);
	}else if(string_is_repeat(buf2, len)){
		sprintf(buf, "n%c%c%c%c%c", x+1, y+1, len, col, buf2[0]);
	}else{    
		sprintf(buf, "t%c%c%c%c%s", x+1, y+1, len, col, buf2);
	}
	send_to_chuukei_server(buf);
#if 0
	fprintf(stderr, buf);
	fprintf(stderr, "\n");
#endif
}

void send_wipe_to_chuukei_server(int x, int y, int len)
{
	char buf[1024];

	if(!chuukei_server || Term != angband_term[0]) return;
	sprintf(buf, "w%c%c%c", x+1, y+1, len);
	send_to_chuukei_server(buf);
#if 0
	fprintf(stderr, buf);
	fprintf(stderr, "\n");
#endif
}

void send_xtra_to_chuukei_server(int n)
{
	char buf[1024];
	if(!chuukei_server || Term != angband_term[0]) return;
	sprintf(buf, "x%c", n+1);

	send_to_chuukei_server(buf);
#if 0
	fprintf(stderr, buf);
	fprintf(stderr, "\n");
#endif
}

void send_curs_to_chuukei_server(int x, int y)
{
	char buf[1024];
	if(!chuukei_server || Term != angband_term[0]) return;
	sprintf(buf, "c%c%c", x+1, y+1);

	send_to_chuukei_server(buf);
#if 0
	fprintf(stderr, buf);
	fprintf(stderr, "\n");
#endif
}

static int read_sock(char *buf)
{
#ifdef CHUUKEI_DEBUG
	static int data_num = 0;
	static int start_time = 0;
#endif
	int i;

#ifdef CHUUKEI_DEBUG
	if(start_time == 0){
		start_time = time(NULL);
	}
#endif
	for(i = 0;; i++){
		if(recv(sd, buf+i, 1, 0) <= 0) return -1;
#ifdef CHUUKEI_DEBUG
		data_num ++;
		if(start_time != 0 && time(NULL) - start_time > 20){
			printf("%dbytes/sec\n", data_num/20);
			data_num = 0;
			start_time = 0;
		}
#endif
		if(buf[i] == '\0'){
			return i;
		}
	}
}


#ifndef WINDOWS
/* WinǤξɤƦԥꥪɤȥ㡼פˤ롣*/
void win2unix(int col, char *buf)
{
	char kabe;
	if( col == 9 ) kabe = '%';
	else           kabe = '#';

	while(*buf){
		if(iskanji(*buf)){
			buf += 2;
			continue;
		}
		if(*buf == 127) *buf = kabe;
		else if(*buf == 31) *buf = '.';
		buf++;
	}
}
#endif

void browse_chuukei()
{
	char id;
	int x, y, len, col;
	char buf[1024];
	char *mesg;
	int i;
	int fresh = FALSE;
	fd_set fdset;
	struct timeval tv;

	tv.tv_sec = 0;
	tv.tv_usec = 100;

	FD_ZERO( &fdset );
	FD_SET( sd, &fdset );

	Term_clear();
	Term_fresh();
	Term_xtra(TERM_XTRA_REACT, 0);

	while(1){
		fd_set tmp_fdset;
		struct timeval tmp_tv;
		char tmp1, tmp2, tmp3, tmp4;

		tmp_fdset = fdset;
		tmp_tv = tv;
		/* åȤ˥ǡƤ뤫ɤĴ٤ */
		select( sd+1, &tmp_fdset, (fd_set *)NULL, (fd_set *)NULL, &tmp_tv );
		if( FD_ISSET( sd, &tmp_fdset ) == 0 ){
			if (fresh)
			{
				Term_xtra(TERM_XTRA_FRESH, 0);
				fresh = FALSE;
			}
			Term_xtra(TERM_XTRA_FLUSH, 0);
			continue;
		}

		if(read_sock(buf) < 0) break;
		sscanf(buf, "%c%c%c%c%c", &id, &tmp1, &tmp2, &tmp3, &tmp4);
		x = tmp1-1; y = tmp2-1; len = tmp3; col = tmp4;
		if(id == 's'){
			col=tmp3;
			mesg = &buf[4];
		}
		else mesg = &buf[5];
#ifndef WINDOWS
		win2unix(col, mesg);
#endif
		switch(id){
		case 't': /* ̾ */
#ifdef SJIS
			euc2sjis(mesg);
#endif
			(void)((*angband_term[0]->text_hook)(x, y, len, col, mesg));
			strncpy(&Term->scr->c[y][x], mesg, len);
			for( i = x; i < x+len; i++){
				Term->scr->a[y][i] = col;
			}
			break;
		case 'n': /* ֤ */
			for(i = 1; i < len; i++){
				mesg[i] = mesg[0];
			}
			mesg[i] = '\0';
			(void)((*angband_term[0]->text_hook)(x, y, len, col, mesg));
			strncpy(&Term->scr->c[y][x], mesg, len);
			for( i = x; i < x+len; i++){
				Term->scr->a[y][i] = col;
			}
			break;
		case 's': /* ʸ */
			(void)((*angband_term[0]->text_hook)(x, y, 1, col, mesg));
			strncpy(&Term->scr->c[y][x], mesg, 1);
			Term->scr->a[y][x] = col;
			break;
		case 'w':
			(void)((*angband_term[0]->wipe_hook)(x, y, len));
			break;
		case 'x':
			if( x == TERM_XTRA_CLEAR ) Term_clear();
			if ( x == TERM_XTRA_FRESH ){
				/* fresh later */
				fresh = TRUE;
				break;
			}				
			(void)((*angband_term[0]->xtra_hook)(x, 0));
			break;
		case 'c':
			//      fprintf(stderr, "c%02d%02d\n", x, y);
			(void)((*angband_term[0]->curs_hook)(x, y));
			break;
		}
	}
}


#endif
