/* File: spells2.c */

/* Purpose: Spell code (part 2) */

/*
 * Copyright (c) 1989 James E. Wilson, Robert A. Koeneke
 *
 * This software may be copied and distributed for educational, research, and
 * not for profit purposes provided that this copyright and statement are
 * included in all such copies.
 */

#include "angband.h"


/*
 * self-knowledge... idea from nethack.  Useful for determining powers and
 * resistences of items.  It saves the screen, clears it, then starts listing
 * attributes, a screenful at a time.  (There are a LOT of attributes to
 * list.  It will probably take 2 or 3 screens for a powerful character whose
 * using several artifacts...) -CFT
 *
 * It is now a lot more efficient. -BEN-
 *
 * See also "identify_fully()".
 *
 * XXX XXX XXX Use the "show_file()" method, perhaps.
 */
void self_knowledge(void)
{
	int i = 0, j, k;

	int v_nr;
	char v_string[8][128];

	u32b f1 = 0L, f2 = 0L, f3 = 0L;

	object_type *o_ptr;

	char Dummy[80], Liferating[80];

	cptr info[220];

	int plev = p_ptr->lev;

	int percent;

	strcpy(Dummy, "");
	strcpy(Liferating, "");

	percent = (int)(((long)player_hp[PY_MAX_LEVEL - 1] * 200L) /
		(2 * p_ptr->hitdie +
		((PY_MAX_LEVEL - 1 + 3) * (p_ptr->hitdie + (cp_ptr->c_mhp ? 2 : 1 )))));

#ifdef JP
sprintf(Liferating, "ߤϥ󥯤 %d/100Ǥ", percent);
#else
	sprintf(Liferating, "Your current Life Rating is %d/100.", percent);
#endif

	info[i++] = Liferating;

	chg_virtue(V_KNOWLEDGE, 1);
	chg_virtue(V_ENLIGHTEN, 1);

	/* Acquire item flags from equipment */
	for (k = INVEN_WIELD; k < INVEN_TOTAL; k++)
	{
		u32b t1, t2, t3;

		o_ptr = &inventory[k];

		/* Skip non-objects */
		if (!o_ptr->k_idx) continue;

		/* Extract the flags */
		object_flags(o_ptr, &t1, &t2, &t3);

		/* Extract flags */
		f1 |= t1;
		f2 |= t2;
		f3 |= t3;
	}

	for (v_nr = 0; v_nr < MAX_PLAYER_VIRTUES; v_nr++)
	{
		char v_name[20];
		char vir_desc[80];
		int tester = p_ptr->virtues[v_nr];

		strcpy(v_name, virtue[(p_ptr->vir_types[v_nr]) - 1]);

#ifdef JP
sprintf(vir_desc, "äȡ%sξʤ", v_name);
#else
		sprintf(vir_desc, "Oops. No info about %s.", v_name);
#endif

		if (tester < -100)
#ifdef JP
sprintf(vir_desc, "[%s]ж (%d)",
#else
			sprintf(vir_desc, "You are the polar opposite of %s (%d).",
#endif

				v_name, tester);
		else if (tester < -80)
#ifdef JP
sprintf(vir_desc, "[%s]Ũ (%d)",
#else
			sprintf(vir_desc, "You are an arch-enemy of %s (%d).",
#endif

				v_name, tester);
		else if (tester < -60)
#ifdef JP
sprintf(vir_desc, "[%s]ζŨ (%d)",
#else
			sprintf(vir_desc, "You are a bitter enemy of %s (%d).",
#endif

				v_name, tester);
		else if (tester < -40)
#ifdef JP
sprintf(vir_desc, "[%s]Ũ (%d)",
#else
			sprintf(vir_desc, "You are an enemy of %s (%d).",
#endif

				v_name, tester);
		else if (tester < -20)
#ifdef JP
sprintf(vir_desc, "[%s]ȿռ (%d)",
#else
			sprintf(vir_desc, "You have sinned against %s (%d).",
#endif

				v_name, tester);
		else if (tester < 0)
#ifdef JP
sprintf(vir_desc, "[%s] (%d)",
#else
			sprintf(vir_desc, "You have strayed from the path of %s (%d).",
#endif

				v_name, tester);
		else if (tester == 0)
#ifdef JP
sprintf(vir_desc, "[%s]Ω (%d)",
#else
			sprintf(vir_desc,"You are neutral to %s (%d).",
#endif

				v_name, tester);
		else if (tester < 20)
#ifdef JP
sprintf(vir_desc,"[%s]ξ (%d)",
#else
			sprintf(vir_desc,"You are somewhat virtuous in %s (%d).",
#endif

				v_name, tester);
		else if (tester < 40)
#ifdef JP
sprintf(vir_desc, "[%s] (%d)",
#else
			sprintf(vir_desc,"You are virtuous in %s (%d).",
#endif

				v_name, tester);
		else if (tester < 60)
#ifdef JP
sprintf(vir_desc, "[%s]ι (%d)",
#else
			sprintf(vir_desc,"You are very virtuous in %s (%d).",
#endif

				v_name, tester);
		else if (tester < 80)
#ifdef JP
sprintf(vir_desc,"[%s]ֿ (%d)",
#else
			sprintf(vir_desc,"You are a champion of %s (%d).",
#endif

				v_name, tester);
		else if (tester < 100)
#ifdef JP
sprintf(vir_desc,"[%s]μ (%d)",
#else
			sprintf(vir_desc,"You are a great champion of %s (%d).",
#endif

				v_name, tester);
		else
#ifdef JP
sprintf(vir_desc,"[%s]ζ񸽼 (%d)",
#else
			sprintf(vir_desc,"You are the living embodiment of %s (%d).",
#endif

		v_name, tester);

		strcpy(v_string[v_nr], vir_desc);

		info[i++] = v_string[v_nr];
	}

	/* Racial powers... */
	switch (p_ptr->prace)
	{
		case RACE_NIBELUNG:
		case RACE_DWARF:
			if (plev > 4)
#ifdef JP
info[i++] = "ʤ櫤ȥɥȳʤΤǤ롣(5 MP)";
#else
				info[i++] = "You can find traps, doors and stairs (cost 5).";
#endif

			break;
		case RACE_HOBBIT:
			if (plev > 14)
			{
#ifdef JP
info[i++] = "ʤϿǤ롣(10 MP)";
#else
				info[i++] = "You can produce food (cost 10).";
#endif

			}
			break;
		case RACE_GNOME:
			if (plev > 4)
			{
#ifdef JP
sprintf(Dummy, "ʤϰ %d ˥ƥݡȤǤ롣(%d MP)",
#else
				sprintf(Dummy, "You can teleport, range %d (cost %d).",
#endif

				    (1 + plev), (5 + (plev / 5)));
				info[i++] = Dummy;
			}
			break;
		case RACE_HALF_ORC:
			if (plev > 2)
#ifdef JP
info[i++] = "ʤ϶ݤǤ롣(5 MP)";
#else
				info[i++] = "You can remove fear (cost 5).";
#endif

			break;
		case RACE_HALF_TROLL:
			if (plev > 9)
#ifdef JP
info[i++] = "ʤ϶˽뤳ȤǤ롣(12 MP) ";
#else
				info[i++] = "You enter berserk fury (cost 12).";
#endif

			break;
		case RACE_AMBERITE:
			if (plev > 29)
#ifdef JP
info[i++] = "ʤϥɥեȤ뤳ȤǤ롣(50 MP)";
#else
				info[i++] = "You can Shift Shadows (cost 50).";
#endif

			if (plev > 39)
#ifdef JP
info[i++] = "ʤϡ֥ѥפ򿴤⤯ȤǤ롣(75 MP)";
#else
				info[i++] = "You can mentally Walk the Pattern (cost 75).";
#endif

			break;
		case RACE_BARBARIAN:
			if (plev > 7)
#ifdef JP
info[i++] = "ʤ϶˽뤳ȤǤ롣(10 MP) ";
#else
				info[i++] = "You can enter berserk fury (cost 10).";
#endif

			break;
		case RACE_HALF_OGRE:
			if (plev > 24)
#ifdef JP
info[i++] = "ʤȯΥ롼ųݤ뤳ȤǤ롣(35 MP)";
#else
				info[i++] = "You can set an Explosive Rune (cost 35).";
#endif

			break;
		case RACE_HALF_GIANT:
			if (plev > 19)
#ifdef JP
info[i++] = "ʤФɤȤǤ롣(10 MP)";
#else
				info[i++] = "You can break stone walls (cost 10).";
#endif

			break;
		case RACE_HALF_TITAN:
			if (plev > 34)
#ifdef JP
info[i++] = "ʤϥ󥹥򥹥󤹤뤳ȤǤ롣(20 MP)";
#else
				info[i++] = "You can probe monsters (cost 20).";
#endif

			break;
		case RACE_CYCLOPS:
			if (plev > 19)
			{
#ifdef JP
sprintf(Dummy, "ʤ %d ᡼δФꤲ뤳ȤǤ롣(15 MP)",
#else
				sprintf(Dummy, "You can throw a boulder, dam. %d (cost 15).",
#endif

				    3 * plev);
				info[i++] = Dummy;
			}
			break;
		case RACE_YEEK:
			if (plev > 14)
#ifdef JP
info[i++] = "ʤ϶ݤƤӵȯ뤳ȤǤ롣(15 MP)";
#else
				info[i++] = "You can make a terrifying scream (cost 15).";
#endif

			break;
		case RACE_KLACKON:
			if (plev > 8)
			{
#ifdef JP
sprintf(Dummy, "ʤ %d ᡼λ᤭뤳ȤǤ롣(9 MP)", plev);
#else
				sprintf(Dummy, "You can spit acid, dam. %d (cost 9).", plev);
#endif

				info[i++] = Dummy;
			}
			break;
		case RACE_KOBOLD:
			if (plev > 11)
			{
				sprintf(Dummy,
#ifdef JP
    "ʤ %d ᡼ꤲ뤳ȤǤ롣(8 MP)", plev);
#else
				    "You can throw a dart of poison, dam. %d (cost 8).", plev);
#endif

				info[i++] = Dummy;
			}
			break;
		case RACE_DARK_ELF:
			if (plev > 1)
			{
#ifdef JP
sprintf(Dummy, "ʤ %d ᡼ΥޥåߥμʸȤ롣(2 MP)",
#else
				sprintf(Dummy, "You can cast a Magic Missile, dam %d (cost 2).",
#endif

				    (3 + ((plev-1) / 5)));
				info[i++] = Dummy;
			}
			break;
		case RACE_DRACONIAN:
#ifdef JP
sprintf(Dummy, "ʤ %d ᡼Υ֥쥹ǤȤǤ롣(%d MP)", 2 * plev, plev);
#else
			sprintf(Dummy, "You can breathe, dam. %d (cost %d).", 2 * plev, plev);
#endif

			info[i++] = Dummy;
			break;
		case RACE_MIND_FLAYER:
			if (plev > 14)
#ifdef JP
sprintf(Dummy, "ʤ %d ᡼򤹤뤳ȤǤ롣(12 MP)", plev);
#else
				sprintf(Dummy, "You can mind blast your enemies, dam %d (cost 12).", plev);
#endif

			info[i++] = Dummy;
			break;
		case RACE_IMP:
			if (plev > 29)
			{
#ifdef JP
sprintf(Dummy, "ʤ %d ᡼ΥեܡμʸȤ롣(15 MP)", plev);
#else
				sprintf(Dummy, "You can cast a Fire Ball, dam. %d (cost 15).", plev);
#endif

				info[i++] = Dummy;
			}
			else if (plev > 8)
			{
#ifdef JP
sprintf(Dummy, "ʤ %d ᡼ΥեܥȤμʸȤ롣(15 MP)", plev);
#else
				sprintf(Dummy, "You can cast a Fire Bolt, dam. %d (cost 15).", plev);
#endif

				info[i++] = Dummy;
			}
			break;
		case RACE_GOLEM:
			if (plev > 19)
#ifdef JP
info[i++] = "ʤ d20+30 δȩФѲ롣(15 MP)";
#else
				info[i++] = "You can turn your skin to stone, dur d20+30 (cost 15).";
#endif

			break;
		case RACE_ZOMBIE:
		case RACE_SKELETON:
			if (plev > 29)
#ifdef JP
info[i++] = "ʤϼä̿Ϥ뤳ȤǤ롣(30 MP)";
#else
				info[i++] = "You can restore lost life forces (cost 30).";
#endif

			break;
		case RACE_VAMPIRE:
			if (plev > 1)
			{
#ifdef JP
sprintf(Dummy, "ʤŨ %d-%d HP ̿ϤۼǤ롣(%d MP)",
#else
				sprintf(Dummy, "You can steal life from a foe, dam. %d-%d (cost %d).",
#endif

				    plev + MAX(1, plev / 10), plev + plev * MAX(1, plev / 10), 1 + (plev / 3));
				info[i++] = Dummy;
			}
			break;
		case RACE_SPECTRE:
			if (plev > 3)
			{
#ifdef JP
info[i++] = "ʤϵ㤭Ũݤ뤳ȤǤ롣(3 MP)";
#else
				info[i++] = "You can wail to terrify your enemies (cost 3).";
#endif

			}
			break;
		case RACE_SPRITE:
			if (plev > 11)
			{
#ifdef JP
info[i++] = "ʤŨ̲餻ˡʴꤲ뤳ȤǤ롣(12 MP)";
#else
				info[i++] = "You can throw magic dust which induces sleep (cost 12).";
#endif

			}
			break;
		default:
			break;
	}

	if (p_ptr->muta1)
	{
		if (p_ptr->muta1 & MUT1_SPIT_ACID)
		{
#ifdef JP
info[i++] = "ʤϻ᤭뤳ȤǤ롣(᡼ ٥X1)";
#else
			info[i++] = "You can spit acid (dam lvl).";
#endif

		}
		if (p_ptr->muta1 & MUT1_BR_FIRE)
		{
#ifdef JP
info[i++] = "ʤϱΥ֥쥹ǤȤǤ롣(᡼ ٥X2)";
#else
			info[i++] = "You can breathe fire (dam lvl * 2).";
#endif

		}
		if (p_ptr->muta1 & MUT1_HYPN_GAZE)
		{
#ifdef JP
info[i++] = "ʤˤߤϺ̲̤ġ";
#else
			info[i++] = "Your gaze is hypnotic.";
#endif

		}
		if (p_ptr->muta1 & MUT1_TELEKINES)
		{
#ifdef JP
info[i++] = "ʤǰưϤäƤ롣";
#else
			info[i++] = "You are telekinetic.";
#endif

		}
		if (p_ptr->muta1 & MUT1_VTELEPORT)
		{
#ifdef JP
info[i++] = "ʤϼʬΰջפǥƥݡȤǤ롣";
#else
			info[i++] = "You can teleport at will.";
#endif

		}
		if (p_ptr->muta1 & MUT1_MIND_BLST)
		{
#ifdef JP
info[i++] = "ʤԤ롣(᡼ 312d3)";
#else
			info[i++] = "You can Mind Blast your enemies (3 to 12d3 dam).";
#endif

		}
		if (p_ptr->muta1 & MUT1_RADIATION)
		{
#ifdef JP
info[i++] = "ʤϼʬΰջפǶȯ뤳ȤǤ롣(᡼ ٥X2)";
#else
			info[i++] = "You can emit hard radiation at will (dam lvl * 2).";
#endif

		}
		if (p_ptr->muta1 & MUT1_VAMPIRISM)
		{
#ifdef JP
info[i++] = "ʤϵ۷쵴Τ褦Ũ̿Ϥۼ뤳ȤǤ롣(᡼ ٥X2)";
#else
			info[i++] = "You can drain life from a foe like a vampire (dam lvl * 2).";
#endif

		}
		if (p_ptr->muta1 & MUT1_SMELL_MET)
		{
#ifdef JP
info[i++] = "ʤ϶᤯ˤ뵮°򤫤ʬ뤳ȤǤ롣";
#else
			info[i++] = "You can smell nearby precious metal.";
#endif

		}
		if (p_ptr->muta1 & MUT1_SMELL_MON)
		{
#ifdef JP
info[i++] = "ʤ϶᤯Υ󥹥¸ߤ򤫤ʬ뤳ȤǤ롣";
#else
			info[i++] = "You can smell nearby monsters.";
#endif

		}
		if (p_ptr->muta1 & MUT1_BLINK)
		{
#ifdef JP
info[i++] = "ʤûΥƥݡȤǤ롣";
#else
			info[i++] = "You can teleport yourself short distances.";
#endif

		}
		if (p_ptr->muta1 & MUT1_EAT_ROCK)
		{
#ifdef JP
info[i++] = "ʤϹŤ򿩤٤뤳ȤǤ롣";
#else
			info[i++] = "You can consume solid rock.";
#endif

		}
		if (p_ptr->muta1 & MUT1_SWAP_POS)
		{
#ifdef JP
info[i++] = "ʤ¾μԤȾؤ뤳ȤǤ롣";
#else
			info[i++] = "You can switch locations with another being.";
#endif

		}
		if (p_ptr->muta1 & MUT1_SHRIEK)
		{
#ifdef JP
info[i++] = "ʤϿȤӤĶȯ뤳ȤǤ롣(᡼ ٥X2)";
#else
			info[i++] = "You can emit a horrible shriek (dam 2 * lvl).";
#endif

		}
		if (p_ptr->muta1 & MUT1_ILLUMINE)
		{
#ifdef JP
info[i++] = "ʤ뤤ĤȤǤ롣";
#else
			info[i++] = "You can emit bright light.";
#endif

		}
		if (p_ptr->muta1 & MUT1_DET_CURSE)
		{
#ifdef JP
info[i++] = "ʤϼٰˡδ򴶤Ȥ뤳ȤǤ롣";
#else
			info[i++] = "You can feel the danger of evil magic.";
#endif

		}
		if (p_ptr->muta1 & MUT1_BERSERK)
		{
#ifdef JP
info[i++] = "ʤϼʬΰջפǶƮ֤ˤʤ뤳ȤǤ롣";
#else
			info[i++] = "You can drive yourself into a berserk frenzy.";
#endif

		}
		if (p_ptr->muta1 & MUT1_POLYMORPH)
		{
#ifdef JP
info[i++] = "ʤϼʬΰջ֤ѲǤ롣";
#else
			info[i++] = "You can polymorph yourself at will.";
#endif

		}
		if (p_ptr->muta1 & MUT1_MIDAS_TCH)
		{
#ifdef JP
info[i++] = "ʤ̾異ƥѤ뤳ȤǤ롣";
#else
			info[i++] = "You can turn ordinary items to gold.";
#endif

		}
		if (p_ptr->muta1 & MUT1_GROW_MOLD)
		{
#ifdef JP
info[i++] = "ʤϼϤ˥Υ䤹ȤǤ롣";
#else
			info[i++] = "You can cause mold to grow near you.";
#endif

		}
		if (p_ptr->muta1 & MUT1_RESIST)
		{
#ifdef JP
info[i++] = "ʤϸǤιФƿȤŤ뤳ȤǤ롣";
#else
			info[i++] = "You can harden yourself to the ravages of the elements.";
#endif

		}
		if (p_ptr->muta1 & MUT1_EARTHQUAKE)
		{
#ifdef JP
info[i++] = "ʤϼϤΥ󥸥뤳ȤǤ롣";
#else
			info[i++] = "You can bring down the dungeon around your ears.";
#endif

		}
		if (p_ptr->muta1 & MUT1_EAT_MAGIC)
		{
#ifdef JP
info[i++] = "ʤˡΥͥ륮ʬʪȤƻѤǤ롣";
#else
			info[i++] = "You can consume magic energy for your own use.";
#endif

		}
		if (p_ptr->muta1 & MUT1_WEIGH_MAG)
		{
#ifdef JP
info[i++] = "ʤϼʬ˱ƶͿˡϤ򴶤뤳ȤǤ롣";
#else
			info[i++] = "You can feel the strength of the magics affecting you.";
#endif

		}
		if (p_ptr->muta1 & MUT1_STERILITY)
		{
#ifdef JP
info[i++] = "ʤϽŪǽ򵯤ȤǤ롣";
#else
			info[i++] = "You can cause mass impotence.";
#endif

		}
		if (p_ptr->muta1 & MUT1_PANIC_HIT)
		{
#ifdef JP
info[i++] = "ʤϹ⤷Ȥ뤿ƨ뤳ȤǤ롣";
#else
			info[i++] = "You can run for your life after hitting something.";
#endif

		}
		if (p_ptr->muta1 & MUT1_DAZZLE)
		{
#ifdef JP
info[i++] = "ʤϺܤǽȯ뤳ȤǤ롣 ";
#else
			info[i++] = "You can emit confusing, blinding radiation.";
#endif

		}
		if (p_ptr->muta1 & MUT1_LASER_EYE)
		{
#ifdef JP
info[i++] = "ʤܤ졼ȯ뤳ȤǤ롣(᡼ ٥X2)";
#else
			info[i++] = "Your eyes can fire laser beams (dam 2 * lvl).";
#endif

		}
		if (p_ptr->muta1 & MUT1_RECALL)
		{
#ifdef JP
info[i++] = "ʤϳȥ󥸥δ֤Ԥ褹뤳ȤǤ롣";
#else
			info[i++] = "You can travel between town and the depths.";
#endif

		}
		if (p_ptr->muta1 & MUT1_BANISH)
		{
#ifdef JP
info[i++] = "ʤϼٰʥ󥹥ϹȤȤǤ롣";
#else
			info[i++] = "You can send evil creatures directly to Hell.";
#endif

		}
		if (p_ptr->muta1 & MUT1_COLD_TOUCH)
		{
#ifdef JP
info[i++] = "ʤŨ򿨤ä餻뤳ȤǤ롣(᡼ ٥X3)";
#else
			info[i++] = "You can freeze things with a touch (dam 3 * lvl).";
#endif

		}
		if (p_ptr->muta1 & MUT1_LAUNCHER)
		{
#ifdef JP
info[i++] = "ʤϥƥ϶ꤲ뤳ȤǤ롣";
#else
			info[i++] = "You can hurl objects with great force.";
#endif

		}
	}

	if (p_ptr->muta2)
	{
		if (p_ptr->muta2 & MUT2_BERS_RAGE)
		{
#ifdef JP
info[i++] = "ʤòȯ򵯤";
#else
			info[i++] = "You are subject to berserker fits.";
#endif

		}
		if (p_ptr->muta2 & MUT2_COWARDICE)
		{
#ifdef JP
info[i++] = "ʤϻ¤ˤʤ롣";
#else
			info[i++] = "You are subject to cowardice.";
#endif

		}
		if (p_ptr->muta2 & MUT2_RTELEPORT)
		{
#ifdef JP
info[i++] = "ʤϥ˥ƥݡȤ롣";
#else
			info[i++] = "You are teleporting randomly.";
#endif

		}
		if (p_ptr->muta2 & MUT2_ALCOHOL)
		{
#ifdef JP
info[i++] = "ʤΤϥ륳ʬ礹롣";
#else
			info[i++] = "Your body produces alcohol.";
#endif

		}
		if (p_ptr->muta2 & MUT2_HALLU)
		{
#ifdef JP
info[i++] = "ʤϸФ˿Ƥ롣";
#else
			info[i++] = "You have a hallucinatory insanity.";
#endif

		}
		if (p_ptr->muta2 & MUT2_FLATULENT)
		{
#ifdef JP
info[i++] = "ʤǤʤ򤳤";
#else
			info[i++] = "You are subject to uncontrollable flatulence.";
#endif

		}
		if (p_ptr->muta2 & MUT2_PROD_MANA)
		{
#ifdef JP
info[i++] = "ʤǽˡΥͥ륮ȯƤ롣";
#else
			info[i++] = "You are producing magical energy uncontrollably.";
#endif

		}
		if (p_ptr->muta2 & MUT2_ATT_DEMON)
		{
#ifdef JP
info[i++] = "ʤϥǡĤ롣";
#else
			info[i++] = "You attract demons.";
#endif

		}
		if (p_ptr->muta2 & MUT2_SCOR_TAIL)
		{
#ifdef JP
info[i++] = "ʤϥοƤ롣(ǡ᡼ 3d7)";
#else
			info[i++] = "You have a scorpion tail (poison, 3d7).";
#endif

		}
		if (p_ptr->muta2 & MUT2_HORNS)
		{
#ifdef JP
info[i++] = "ʤϳѤƤ롣(᡼ 2d6)";
#else
			info[i++] = "You have horns (dam. 2d6).";
#endif

		}
		if (p_ptr->muta2 & MUT2_BEAK)
		{
#ifdef JP
info[i++] = "ʤϥХƤ롣(᡼ 2d4)";
#else
			info[i++] = "You have a beak (dam. 2d4).";
#endif

		}
		if (p_ptr->muta2 & MUT2_SPEED_FLUX)
		{
#ifdef JP
info[i++] = "ʤϥ᤯ư٤ưꤹ롣";
#else
			info[i++] = "You move faster or slower randomly.";
#endif

		}
		if (p_ptr->muta2 & MUT2_BANISH_ALL)
		{
#ifdef JP
info[i++] = "ʤϻ᤯Υ󥹥Ǥ롣";
#else
			info[i++] = "You sometimes cause nearby creatures to vanish.";
#endif

		}
		if (p_ptr->muta2 & MUT2_EAT_LIGHT)
		{
#ifdef JP
info[i++] = "ʤϻϤθۼƱܤˤ롣";
#else
			info[i++] = "You sometimes feed off of the light around you.";
#endif

		}
		if (p_ptr->muta2 & MUT2_TRUNK)
		{
#ifdef JP
info[i++] = "ʤϾݤΤ褦ɡäƤ롣(᡼ 1d4)";
#else
			info[i++] = "You have an elephantine trunk (dam 1d4).";
#endif

		}
		if (p_ptr->muta2 & MUT2_ATT_ANIMAL)
		{
#ifdef JP
info[i++] = "ʤưʪĤ롣";
#else
			info[i++] = "You attract animals.";
#endif

		}
		if (p_ptr->muta2 & MUT2_TENTACLES)
		{
#ifdef JP
info[i++] = "ʤϼٰʿäƤ롣(᡼ 2d5)";
#else
			info[i++] = "You have evil looking tentacles (dam 2d5).";
#endif

		}
		if (p_ptr->muta2 & MUT2_RAW_CHAOS)
		{
#ifdef JP
info[i++] = "ʤϤФн㥫ޤ롣";
#else
			info[i++] = "You occasionally are surrounded with raw chaos.";
#endif

		}
		if (p_ptr->muta2 & MUT2_NORMALITY)
		{
#ifdef JP
info[i++] = "ʤѰۤƤƤƤ롣";
#else
			info[i++] = "You may be mutated, but you're recovering.";
#endif

		}
		if (p_ptr->muta2 & MUT2_WRAITH)
		{
#ifdef JP
info[i++] = "ʤΤͩββꤹ롣";
#else
			info[i++] = "You fade in and out of physical reality.";
#endif

		}
		if (p_ptr->muta2 & MUT2_POLY_WOUND)
		{
#ifdef JP
info[i++] = "ʤη򹯤ϥϤ˱ƶ롣";
#else
			info[i++] = "Your health is subject to chaotic forces.";
#endif

		}
		if (p_ptr->muta2 & MUT2_WASTING)
		{
#ifdef JP
info[i++] = "ʤϿ夹붲µˤäƤ롣";
#else
			info[i++] = "You have a horrible wasting disease.";
#endif

		}
		if (p_ptr->muta2 & MUT2_ATT_DRAGON)
		{
#ifdef JP
info[i++] = "ʤϥɥ饴Ĥ롣";
#else
			info[i++] = "You attract dragons.";
#endif

		}
		if (p_ptr->muta2 & MUT2_WEIRD_MIND)
		{
#ifdef JP
info[i++] = "ʤϥ˳礷̾ꤷƤ롣";
#else
			info[i++] = "Your mind randomly expands and contracts.";
#endif

		}
		if (p_ptr->muta2 & MUT2_NAUSEA)
		{
#ifdef JP
info[i++] = "ʤΰߤ夭ʤ";
#else
			info[i++] = "You have a seriously upset stomach.";
#endif

		}
		if (p_ptr->muta2 & MUT2_CHAOS_GIFT)
		{
#ifdef JP
info[i++] = "ʤϥμ⤫˫򤦤Ȥ롣";
#else
			info[i++] = "Chaos deities give you gifts.";
#endif

		}
		if (p_ptr->muta2 & MUT2_WALK_SHAD)
		{
#ifdef JP
info[i++] = "ʤϤФ¾Ρֱơפ¤ࡣ";
#else
			info[i++] = "You occasionally stumble into other shadows.";
#endif

		}
		if (p_ptr->muta2 & MUT2_WARNING)
		{
#ifdef JP
info[i++] = "ʤŨ˴ؤٹ򴶤롣";
#else
			info[i++] = "You receive warnings about your foes.";
#endif

		}
		if (p_ptr->muta2 & MUT2_INVULN)
		{
#ifdef JP
info[i++] = "ʤϻ餱Τ餺ʵʬˤʤ롣";
#else
			info[i++] = "You occasionally feel invincible.";
#endif

		}
		if (p_ptr->muta2 & MUT2_SP_TO_HP)
		{
#ifdef JP
info[i++] = "ʤϻ줬ˤɤäή롣";
#else
			info[i++] = "Your blood sometimes rushes to your muscles.";
#endif

		}
		if (p_ptr->muta2 & MUT2_HP_TO_SP)
		{
#ifdef JP
info[i++] = "ʤϻƬ˷줬ɤäή롣";
#else
			info[i++] = "Your blood sometimes rushes to your head.";
#endif

		}
		if (p_ptr->muta2 & MUT2_DISARM)
		{
#ifdef JP
info[i++] = "ʤϤ褯ĤޤŤʪȤ";
#else
			info[i++] = "You occasionally stumble and drop things.";
#endif

		}
	}

	if (p_ptr->muta3)
	{
		if (p_ptr->muta3 & MUT3_HYPER_STR)
		{
#ifdef JP
info[i++] = "ʤĶŪ˶(+4)";
#else
			info[i++] = "You are superhumanly strong (+4 STR).";
#endif

		}
		if (p_ptr->muta3 & MUT3_PUNY)
		{
#ifdef JP
info[i++] = "ʤϵ(-4)";
#else
			info[i++] = "You are puny (-4 STR).";
#endif

		}
		if (p_ptr->muta3 & MUT3_HYPER_INT)
		{
#ifdef JP
info[i++] = "ʤǾΥԥ塼(ǽ+4)";
#else
			info[i++] = "Your brain is a living computer (+4 INT/WIS).";
#endif

		}
		if (p_ptr->muta3 & MUT3_MORONIC)
		{
#ifdef JP
info[i++] = "ʤ(ǽ-4)";
#else
			info[i++] = "You are moronic (-4 INT/WIS).";
#endif

		}
		if (p_ptr->muta3 & MUT3_RESILIENT)
		{
#ifdef JP
info[i++] = "ʤ˥դ(ѵ+4)";
#else
			info[i++] = "You are very resilient (+4 CON).";
#endif

		}
		if (p_ptr->muta3 & MUT3_XTRA_FAT)
		{
#ifdef JP
info[i++] = "ʤ϶üäƤ롣(ѵ+2,ԡ-2)";
#else
			info[i++] = "You are extremely fat (+2 CON, -2 speed).";
#endif

		}
		if (p_ptr->muta3 & MUT3_ALBINO)
		{
#ifdef JP
info[i++] = "ʤϥӥΤ(ѵ-4)";
#else
			info[i++] = "You are albino (-4 CON).";
#endif

		}
		if (p_ptr->muta3 & MUT3_FLESH_ROT)
		{
#ifdef JP
info[i++] = "ʤΤԤƤ롣(ѵ-2,̥-1)";
#else
			info[i++] = "Your flesh is rotting (-2 CON, -1 CHR).";
#endif

		}
		if (p_ptr->muta3 & MUT3_SILLY_VOI)
		{
#ifdef JP
info[i++] = "ʤϴȴʥ(̥-4)";
#else
			info[i++] = "Your voice is a silly squeak (-4 CHR).";
#endif

		}
		if (p_ptr->muta3 & MUT3_BLANK_FAC)
		{
#ifdef JP
info[i++] = "ʤϤΤäڤܤ(̥-1)";
#else
			info[i++] = "Your face is featureless (-1 CHR).";
#endif

		}
		if (p_ptr->muta3 & MUT3_ILL_NORM)
		{
#ifdef JP
info[i++] = "ʤϸƤʤƤ롣";
#else
			info[i++] = "Your appearance is masked with illusion.";
#endif

		}
		if (p_ptr->muta3 & MUT3_XTRA_EYES)
		{
#ifdef JP
info[i++] = "ʤ;ʬĤܤäƤ롣(õ+15)";
#else
			info[i++] = "You have an extra pair of eyes (+15 search).";
#endif

		}
		if (p_ptr->muta3 & MUT3_MAGIC_RES)
		{
#ifdef JP
info[i++] = "ʤˡؤäƤ롣";
#else
			info[i++] = "You are resistant to magic.";
#endif

		}
		if (p_ptr->muta3 & MUT3_XTRA_NOIS)
		{
#ifdef JP
info[i++] = "ʤѤʲȯƤ롣(̩-3)";
#else
			info[i++] = "You make a lot of strange noise (-3 stealth).";
#endif

		}
		if (p_ptr->muta3 & MUT3_INFRAVIS)
		{
#ifdef JP
info[i++] = "ʤ餷ֳϤäƤ롣(+3)";
#else
			info[i++] = "You have remarkable infravision (+3).";
#endif

		}
		if (p_ptr->muta3 & MUT3_XTRA_LEGS)
		{
#ifdef JP
info[i++] = "ʤ;ʬܤ­Ƥ롣(®+3)";
#else
			info[i++] = "You have an extra pair of legs (+3 speed).";
#endif

		}
		if (p_ptr->muta3 & MUT3_SHORT_LEG)
		{
#ifdef JP
info[i++] = "ʤ­û͵(®-3)";
#else
			info[i++] = "Your legs are short stubs (-3 speed).";
#endif

		}
		if (p_ptr->muta3 & MUT3_ELEC_TOUC)
		{
#ifdef JP
info[i++] = "ʤηɤˤήήƤ롣";
#else
			info[i++] = "Electricity is running through your veins.";
#endif

		}
		if (p_ptr->muta3 & MUT3_FIRE_BODY)
		{
#if 0
			/* Unnecessary, actually... */
#ifdef JP
info[i++] = "ʤΤϱˤĤĤޤƤ롣";
#else
			info[i++] = "Your body is enveloped in flames.";
#endif

#endif
		}
		if (p_ptr->muta3 & MUT3_WART_SKIN)
		{
#ifdef JP
info[i++] = "ʤȩϥܤƤ롣(̥-2, AC+5)";
#else
			info[i++] = "Your skin is covered with warts (-2 CHR, +5 AC).";
#endif

		}
		if (p_ptr->muta3 & MUT3_SCALES)
		{
#ifdef JP
info[i++] = "ʤȩڤˤʤäƤ롣(̥-1, AC+10)";
#else
			info[i++] = "Your skin has turned into scales (-1 CHR, +10 AC).";
#endif

		}
		if (p_ptr->muta3 & MUT3_IRON_SKIN)
		{
#ifdef JP
info[i++] = "ʤȩŴǤǤƤ롣(-1, AC+25)";
#else
			info[i++] = "Your skin is made of steel (-1 DEX, +25 AC).";
#endif

		}
		if (p_ptr->muta3 & MUT3_WINGS)
		{
#ifdef JP
info[i++] = "ʤϱäƤ롣";
#else
			info[i++] = "You have wings.";
#endif

		}
		if (p_ptr->muta3 & MUT3_FEARLESS)
		{
			/* Unnecessary */
		}
		if (p_ptr->muta3 & MUT3_REGEN)
		{
			/* Unnecessary */
		}
		if (p_ptr->muta3 & MUT3_ESP)
		{
			/* Unnecessary */
		}
		if (p_ptr->muta3 & MUT3_LIMBER)
		{
#ifdef JP
info[i++] = "ʤΤˤʤ䤫(+3)";
#else
			info[i++] = "Your body is very limber (+3 DEX).";
#endif

		}
		if (p_ptr->muta3 & MUT3_ARTHRITIS)
		{
#ifdef JP
info[i++] = "ʤϤĤˤߤ򴶤Ƥ롣(-3)";
#else
			info[i++] = "Your joints ache constantly (-3 DEX).";
#endif

		}
#ifdef MUT3_RES_TIME
		if (p_ptr->muta3 & MUT3_RES_TIME)
		{
#ifdef JP
info[i++] = "ʤϻֵž⤫Ƥ롣";
#else
			info[i++] = "You are protected from the ravages of time.";
#endif

		}
#endif /* MUT3_RES_TIME */
		if (p_ptr->muta3 & MUT3_VULN_ELEM)
		{
#ifdef JP
info[i++] = "ʤϸǤι˼夤";
#else
			info[i++] = "You are susceptible to damage from the elements.";
#endif

		}
		if (p_ptr->muta3 & MUT3_MOTION)
		{
#ifdef JP
info[i++] = "ʤưΤ϶(̩+1)";
#else
			info[i++] = "Your movements are precise and forceful (+1 STL).";
#endif

		}
		if (p_ptr->muta3 & MUT3_GOOD_LUCK)
		{
#ifdef JP
info[i++] = "ʤ򤤥ˤĤĤޤƤ롣";
#else
			info[i++] = "There is a white aura surrounding you.";
#endif

		}
		if (p_ptr->muta3 & MUT3_BAD_LUCK)
		{
#ifdef JP
info[i++] = "ʤϹˤĤĤޤƤ롣";
#else
			info[i++] = "There is a black aura surrounding you.";
#endif

		}
	}

	if (p_ptr->blind)
	{
#ifdef JP
info[i++] = "ʤܤʤ";
#else
		info[i++] = "You cannot see.";
#endif

	}
	if (p_ptr->confused)
	{
#ifdef JP
info[i++] = "ʤϺ𤷤Ƥ롣";
#else
		info[i++] = "You are confused.";
#endif

	}
	if (p_ptr->afraid)
	{
#ifdef JP
info[i++] = "ʤ϶ݤ˿Ƥ롣";
#else
		info[i++] = "You are terrified.";
#endif

	}
	if (p_ptr->cut)
	{
#ifdef JP
info[i++] = "ʤϽз줷Ƥ롣";
#else
		info[i++] = "You are bleeding.";
#endif

	}
	if (p_ptr->stun)
	{
#ifdef JP
info[i++] = "ʤϤ⤦ȤƤ롣";
#else
		info[i++] = "You are stunned.";
#endif

	}
	if (p_ptr->poisoned)
	{
#ifdef JP
info[i++] = "ʤǤ˿Ƥ롣";
#else
		info[i++] = "You are poisoned.";
#endif

	}
	if (p_ptr->image)
	{
#ifdef JP
info[i++] = "ʤϸФ򸫤Ƥ롣";
#else
		info[i++] = "You are hallucinating.";
#endif

	}
	if (p_ptr->aggravate)
	{
#ifdef JP
info[i++] = "ʤϥ󥹥ܤ餻Ƥ롣";
#else
		info[i++] = "You aggravate monsters.";
#endif

	}
	if (p_ptr->teleport)
	{
#ifdef JP
info[i++] = "ʤΰ֤ϤҤ礦԰";
#else
		info[i++] = "Your position is very uncertain.";
#endif

	}
	if (p_ptr->blessed)
	{
#ifdef JP
info[i++] = "ʤϸ򴶤Ƥ롣";
#else
		info[i++] = "You feel rightous.";
#endif

	}
	if (p_ptr->hero)
	{
#ifdef JP
info[i++] = "ʤϥҡʬ";
#else
		info[i++] = "You feel heroic.";
#endif

	}
	if (p_ptr->shero)
	{
#ifdef JP
info[i++] = "ʤƮ";
#else
		info[i++] = "You are in a battle rage.";
#endif

	}
	if (p_ptr->protevil)
	{
#ifdef JP
info[i++] = "ʤϼٰʤ¸ߤƤ롣";
#else
		info[i++] = "You are protected from evil.";
#endif

	}
	if (p_ptr->shield)
	{
#ifdef JP
info[i++] = "ʤϿΥɤǼƤ롣";
#else
		info[i++] = "You are protected by a mystic shield.";
#endif

	}
	if (p_ptr->invuln)
	{
#ifdef JP
info[i++] = "ʤϸ߽Ĥʤ";
#else
		info[i++] = "You are temporarily invulnerable.";
#endif

	}
	if (p_ptr->wraith_form)
	{
#ifdef JP
info[i++] = "ʤϰŪͩβƤ롣";
#else
		info[i++] = "You are temporarily incorporeal.";
#endif

	}
	if (p_ptr->confusing)
	{
#ifdef JP
info[i++] = "ʤμ֤Ƥ롣";
#else
		info[i++] = "Your hands are glowing dull red.";
#endif

	}
	if (p_ptr->searching)
	{
#ifdef JP
info[i++] = "ʤϤҤ礦տϤϤƤ롣";
#else
		info[i++] = "You are looking around very carefully.";
#endif

	}
	if (p_ptr->new_spells)
	{
#ifdef JP
info[i++] = "ʤϼʸ䵧ؤ֤ȤǤ롣";
#else
		info[i++] = "You can learn some spells/prayers.";
#endif

	}
	if (p_ptr->word_recall)
	{
#ifdef JP
info[i++] = "ʤϤ˵Ԥ";
#else
		info[i++] = "You will soon be recalled.";
#endif

	}
	if (p_ptr->see_infra)
	{
#ifdef JP
info[i++] = "ʤƷֳҴǤ롣";
#else
		info[i++] = "Your eyes are sensitive to infrared light.";
#endif

	}
	if (p_ptr->see_inv)
	{
#ifdef JP
info[i++] = "ʤƩʥ󥹥򸫤뤳ȤǤ롣";
#else
		info[i++] = "You can see invisible creatures.";
#endif

	}
	if (p_ptr->ffall)
	{
#ifdef JP
info[i++] = "ʤ֤ȤǤ롣";
#else
		info[i++] = "You can fly.";
#endif

	}
	if (p_ptr->free_act)
	{
#ifdef JP
info[i++] = "ʤΤ餺θ̤äƤ롣";
#else
		info[i++] = "You have free action.";
#endif

	}
	if (p_ptr->regenerate)
	{
#ifdef JP
info[i++] = "ʤ᤯Ϥ롣";
#else
		info[i++] = "You regenerate quickly.";
#endif

	}
	if (p_ptr->slow_digest)
	{
#ifdef JP
info[i++] = "ʤϿߤʤ";
#else
		info[i++] = "Your appetite is small.";
#endif

	}
	if (p_ptr->telepathy)
	{
#ifdef JP
info[i++] = "ʤĶǽϤäƤ롣";
#else
		info[i++] = "You have ESP.";
#endif

	}
	if (p_ptr->hold_life)
	{
#ifdef JP
info[i++] = "ʤϼʤ̿Ϥ򤷤äȰݻ롣";
#else
		info[i++] = "You have a firm hold on your life force.";
#endif

	}
	if (p_ptr->reflect)
	{
#ifdef JP
info[i++] = "ʤܥȤȿͤ롣";
#else
		info[i++] = "You reflect arrows and bolts.";
#endif

	}
	if (p_ptr->sh_fire)
	{
#ifdef JP
info[i++] = "ʤϱΥޤƤ롣";
#else
		info[i++] = "You are surrounded with a fiery aura.";
#endif

	}
	if (p_ptr->sh_elec)
	{
#ifdef JP
info[i++] = "ʤŵޤƤ롣";
#else
		info[i++] = "You are surrounded with electricity.";
#endif

	}
	if (p_ptr->sh_cold)
	{
#ifdef JP
info[i++] = "ʤ䵤ΥޤƤ롣";
#else
		info[i++] = "You are surrounded with a cold aura.";
#endif

	}
	if (p_ptr->anti_magic)
	{
#ifdef JP
info[i++] = "ʤȿˡɤޤƤ롣";
#else
		info[i++] = "You are surrounded by an anti-magic shell.";
#endif

	}
	if (p_ptr->anti_tele)
	{
#ifdef JP
info[i++] = "ʤϥƥݡȤǤʤ";
#else
		info[i++] = "You cannot teleport.";
#endif

	}
	if (p_ptr->lite)
	{
#ifdef JP
info[i++] = "ʤϱʵ׸äƤ롣";
#else
		info[i++] = "You are carrying a permanent light.";
#endif

	}

	if (p_ptr->immune_acid)
	{
#ifdef JP
info[i++] = "ʤϻФ봰ʤȱ֤äƤ롣";
#else
		info[i++] = "You are completely immune to acid.";
#endif

	}
	else if ((p_ptr->resist_acid) && (p_ptr->oppose_acid))
	{
#ifdef JP
info[i++] = "ʤϻؤζϤäƤ롣";
#else
		info[i++] = "You resist acid exceptionally well.";
#endif

	}
	else if ((p_ptr->resist_acid) || (p_ptr->oppose_acid))
	{
#ifdef JP
info[i++] = "ʤϻؤäƤ롣";
#else
		info[i++] = "You are resistant to acid.";
#endif

	}

	if (p_ptr->immune_elec)
	{
#ifdef JP
info[i++] = "ʤŷФ봰ʤȱ֤äƤ롣";
#else
		info[i++] = "You are completely immune to lightning.";
#endif

	}
	else if ((p_ptr->resist_elec) && (p_ptr->oppose_elec))
	{
#ifdef JP
info[i++] = "ʤŷؤζϤäƤ롣";
#else
		info[i++] = "You resist lightning exceptionally well.";
#endif

	}
	else if ((p_ptr->resist_elec) || (p_ptr->oppose_elec))
	{
#ifdef JP
info[i++] = "ʤŷؤäƤ롣";
#else
		info[i++] = "You are resistant to lightning.";
#endif

	}

	if (p_ptr->immune_fire)
	{
#ifdef JP
info[i++] = "ʤϲФФ봰ʤȱ֤äƤ롣";
#else
		info[i++] = "You are completely immune to fire.";
#endif

	}
	else if ((p_ptr->resist_fire) && (p_ptr->oppose_fire))
	{
#ifdef JP
info[i++] = "ʤФؤζϤäƤ롣";
#else
		info[i++] = "You resist fire exceptionally well.";
#endif

	}
	else if ((p_ptr->resist_fire) || (p_ptr->oppose_fire))
	{
#ifdef JP
info[i++] = "ʤϲФؤäƤ롣";
#else
		info[i++] = "You are resistant to fire.";
#endif

	}

	if (p_ptr->immune_cold)
	{
#ifdef JP
info[i++] = "ʤ䵤Ф봰ʤȱ֤äƤ롣";
#else
		info[i++] = "You are completely immune to cold.";
#endif

	}
	else if ((p_ptr->resist_cold) && (p_ptr->oppose_cold))
	{
#ifdef JP
info[i++] = "ʤ䵤ؤζϤäƤ롣";
#else
		info[i++] = "You resist cold exceptionally well.";
#endif

	}
	else if ((p_ptr->resist_cold) || (p_ptr->oppose_cold))
	{
#ifdef JP
info[i++] = "ʤ䵤ؤäƤ롣";
#else
		info[i++] = "You are resistant to cold.";
#endif

	}

	if ((p_ptr->resist_pois) && (p_ptr->oppose_pois))
	{
#ifdef JP
info[i++] = "ʤǤؤζϤäƤ롣";
#else
		info[i++] = "You resist poison exceptionally well.";
#endif

	}
	else if ((p_ptr->resist_pois) || (p_ptr->oppose_pois))
	{
#ifdef JP
info[i++] = "ʤǤؤäƤ롣";
#else
		info[i++] = "You are resistant to poison.";
#endif

	}

	if (p_ptr->resist_lite)
	{
#ifdef JP
info[i++] = "ʤؤäƤ롣";
#else
		info[i++] = "You are resistant to bright light.";
#endif

	}
	if (p_ptr->resist_dark)
	{
#ifdef JP
info[i++] = "ʤϰŹؤäƤ롣";
#else
		info[i++] = "You are resistant to darkness.";
#endif

	}
	if (p_ptr->resist_conf)
	{
#ifdef JP
info[i++] = "ʤϺؤäƤ롣";
#else
		info[i++] = "You are resistant to confusion.";
#endif

	}
	if (p_ptr->resist_sound)
	{
#ifdef JP
info[i++] = "ʤϲȤξ׷ؤäƤ롣";
#else
		info[i++] = "You are resistant to sonic attacks.";
#endif

	}
	if (p_ptr->resist_disen)
	{
#ifdef JP
info[i++] = "ʤؤäƤ롣";
#else
		info[i++] = "You are resistant to disenchantment.";
#endif

	}
	if (p_ptr->resist_chaos)
	{
#ifdef JP
info[i++] = "ʤϥϤؤäƤ롣";
#else
		info[i++] = "You are resistant to chaos.";
#endif

	}
	if (p_ptr->resist_shard)
	{
#ifdef JP
info[i++] = "ʤҤιؤäƤ롣";
#else
		info[i++] = "You are resistant to blasts of shards.";
#endif

	}
	if (p_ptr->resist_nexus)
	{
#ifdef JP
info[i++] = "ʤϰ̺ιؤäƤ롣";
#else
		info[i++] = "You are resistant to nexus attacks.";
#endif

	}
	if (p_ptr->resist_neth)
	{
#ifdef JP
info[i++] = "ʤϹϤؤäƤ롣";
#else
		info[i++] = "You are resistant to nether forces.";
#endif

	}
	if (p_ptr->resist_fear)
	{
#ifdef JP
info[i++] = "ʤݤ򴶤ʤ";
#else
		info[i++] = "You are completely fearless.";
#endif

	}
	if (p_ptr->resist_blind)
	{
#ifdef JP
info[i++] = "ʤܤܤؤäƤ롣";
#else
		info[i++] = "Your eyes are resistant to blindness.";
#endif

	}

	if (p_ptr->sustain_str)
	{
#ifdef JP
info[i++] = "ʤϤϰݻƤ롣";
#else
		info[i++] = "Your strength is sustained.";
#endif

	}
	if (p_ptr->sustain_int)
	{
#ifdef JP
info[i++] = "ʤǽϰݻƤ롣";
#else
		info[i++] = "Your intelligence is sustained.";
#endif

	}
	if (p_ptr->sustain_wis)
	{
#ifdef JP
info[i++] = "ʤθϰݻƤ롣";
#else
		info[i++] = "Your wisdom is sustained.";
#endif

	}
	if (p_ptr->sustain_con)
	{
#ifdef JP
info[i++] = "ʤѵϤϰݻƤ롣";
#else
		info[i++] = "Your constitution is sustained.";
#endif

	}
	if (p_ptr->sustain_dex)
	{
#ifdef JP
info[i++] = "ʤδѤϰݻƤ롣";
#else
		info[i++] = "Your dexterity is sustained.";
#endif

	}
	if (p_ptr->sustain_chr)
	{
#ifdef JP
info[i++] = "ʤ̥ϤϰݻƤ롣";
#else
		info[i++] = "Your charisma is sustained.";
#endif

	}

	if (f1 & (TR1_STR))
	{
#ifdef JP
info[i++] = "ʤϤˤäƱƶƤ롣";
#else
		info[i++] = "Your strength is affected by your equipment.";
#endif

	}
	if (f1 & (TR1_INT))
	{
#ifdef JP
info[i++] = "ʤǽˤäƱƶƤ롣";
#else
		info[i++] = "Your intelligence is affected by your equipment.";
#endif

	}
	if (f1 & (TR1_WIS))
	{
#ifdef JP
info[i++] = "ʤθˤäƱƶƤ롣";
#else
		info[i++] = "Your wisdom is affected by your equipment.";
#endif

	}
	if (f1 & (TR1_DEX))
	{
#ifdef JP
info[i++] = "ʤδѤˤäƱƶƤ롣";
#else
		info[i++] = "Your dexterity is affected by your equipment.";
#endif

	}
	if (f1 & (TR1_CON))
	{
#ifdef JP
info[i++] = "ʤѵϤˤäƱƶƤ롣";
#else
		info[i++] = "Your constitution is affected by your equipment.";
#endif

	}
	if (f1 & (TR1_CHR))
	{
#ifdef JP
info[i++] = "ʤ̥ϤˤäƱƶƤ롣";
#else
		info[i++] = "Your charisma is affected by your equipment.";
#endif

	}

	if (f1 & (TR1_STEALTH))
	{
#ifdef JP
info[i++] = "ʤα̩ưǽϤˤäƱƶƤ롣";
#else
		info[i++] = "Your stealth is affected by your equipment.";
#endif

	}
	if (f1 & (TR1_SEARCH))
	{
#ifdef JP
info[i++] = "ʤõǽϤˤäƱƶƤ롣";
#else
		info[i++] = "Your searching ability is affected by your equipment.";
#endif

	}
	if (f1 & (TR1_INFRA))
	{
#ifdef JP
info[i++] = "ʤֳϤˤäƱƶƤ롣";
#else
		info[i++] = "Your infravision is affected by your equipment.";
#endif

	}
	if (f1 & (TR1_TUNNEL))
	{
#ifdef JP
info[i++] = "ʤκηǽϤˤäƱƶƤ롣";
#else
		info[i++] = "Your digging ability is affected by your equipment.";
#endif

	}
	if (f1 & (TR1_SPEED))
	{
#ifdef JP
info[i++] = "ʤΥԡɤˤäƱƶƤ롣";
#else
		info[i++] = "Your speed is affected by your equipment.";
#endif

	}
	if (f1 & (TR1_BLOWS))
	{
#ifdef JP
info[i++] = "ʤι®٤ˤäƱƶƤ롣";
#else
		info[i++] = "Your attack speed is affected by your equipment.";
#endif

	}


	/* Access the current weapon */
	o_ptr = &inventory[INVEN_WIELD];

	/* Analyze the weapon */
	if (o_ptr->k_idx)
	{
		/* Indicate Blessing */
		if (f3 & (TR3_BLESSED))
		{
#ifdef JP
info[i++] = "ʤϿνʡƤ롣";
#else
			info[i++] = "Your weapon has been blessed by the gods.";
#endif

		}

		if (f1 & (TR1_CHAOTIC))
		{
#ifdef JP
info[i++] = "ʤϥ륹ħ°ġ";
#else
			info[i++] = "Your weapon is branded with the Sign of Logrus.";
#endif

		}

		/* Hack */
		if (f1 & (TR1_IMPACT))
		{
#ifdef JP
info[i++] = "ʤǷϿ̤ȯ뤳ȤǤ롣";
#else
			info[i++] = "The impact of your weapon can cause earthquakes.";
#endif

		}

		if (f1 & (TR1_VORPAL))
		{
#ifdef JP
info[i++] = "ʤ˱Ԥ";
#else
			info[i++] = "Your weapon is very sharp.";
#endif

		}

		if (f1 & (TR1_VAMPIRIC))
		{
#ifdef JP
info[i++] = "ʤŨ̿Ϥۼ롣";
#else
			info[i++] = "Your weapon drains life from your foes.";
#endif

		}

		/* Special "Attack Bonuses" */
		if (f1 & (TR1_BRAND_ACID))
		{
#ifdef JP
info[i++] = "ʤŨϤ";
#else
			info[i++] = "Your weapon melts your foes.";
#endif

		}
		if (f1 & (TR1_BRAND_ELEC))
		{
#ifdef JP
info[i++] = "ʤŨŤ롣";
#else
			info[i++] = "Your weapon shocks your foes.";
#endif

		}
		if (f1 & (TR1_BRAND_FIRE))
		{
#ifdef JP
info[i++] = "ʤŨǳ䤹";
#else
			info[i++] = "Your weapon burns your foes.";
#endif

		}
		if (f1 & (TR1_BRAND_COLD))
		{
#ifdef JP
info[i++] = "ʤŨ餻롣";
#else
			info[i++] = "Your weapon freezes your foes.";
#endif

		}
		if (f1 & (TR1_BRAND_POIS))
		{
#ifdef JP
info[i++] = "ʤŨǤǿ";
#else
			info[i++] = "Your weapon poisons your foes.";
#endif

		}

		/* Special "slay" flags */
		if (f1 & (TR1_SLAY_ANIMAL))
		{
#ifdef JP
info[i++] = "ʤưʪФƶϤȯ롣";
#else
			info[i++] = "Your weapon strikes at animals with extra force.";
#endif

		}
		if (f1 & (TR1_SLAY_EVIL))
		{
#ifdef JP
info[i++] = "ʤϼٰʤ¸ߤФƶϤȯ롣";
#else
			info[i++] = "Your weapon strikes at evil with extra force.";
#endif

		}
		if (f1 & (TR1_SLAY_UNDEAD))
		{
#ifdef JP
info[i++] = "ʤϥǥåɤФƿʤϤȯ롣";
#else
			info[i++] = "Your weapon strikes at undead with holy wrath.";
#endif

		}
		if (f1 & (TR1_SLAY_DEMON))
		{
#ifdef JP
info[i++] = "ʤϥǡФƿʤϤȯ롣";
#else
			info[i++] = "Your weapon strikes at demons with holy wrath.";
#endif

		}
		if (f1 & (TR1_SLAY_ORC))
		{
#ifdef JP
info[i++] = "ʤϥФä˶Ϥȯ롣";
#else
			info[i++] = "Your weapon is especially deadly against orcs.";
#endif

		}
		if (f1 & (TR1_SLAY_TROLL))
		{
#ifdef JP
info[i++] = "ʤϥȥФä˶Ϥȯ롣";
#else
			info[i++] = "Your weapon is especially deadly against trolls.";
#endif

		}
		if (f1 & (TR1_SLAY_GIANT))
		{
#ifdef JP
info[i++] = "ʤϥ㥤ȤФä˶Ϥȯ롣";
#else
			info[i++] = "Your weapon is especially deadly against giants.";
#endif

		}
		if (f1 & (TR1_SLAY_DRAGON))
		{
#ifdef JP
info[i++] = "ʤϥɥ饴Фä˶Ϥȯ롣";
#else
			info[i++] = "Your weapon is especially deadly against dragons.";
#endif

		}

		/* Special "kill" flags */
		if (f1 & (TR1_KILL_DRAGON))
		{
#ifdef JP
info[i++] = "ʤϥɥ饴ŷŨǤ롣";
#else
			info[i++] = "Your weapon is a great bane of dragons.";
#endif

		}

		if (f2 & (TR2_THROW))
		{
#ifdef JP
info[i++] = "ʤꤲΤŬƤ롣";
#else
			info[i++] = "Your weapon can be thrown well.";
#endif

		}
	}


	/* Save the screen */
	screen_save();

	/* Erase the screen */
	for (k = 1; k < 24; k++) prt("", k, 13);

	/* Label the information */
#ifdef JP
prt("        ʤξ:", 1, 15);
#else
	prt("     Your Attributes:", 1, 15);
#endif


	/* We will print on top of the map (column 13) */
	for (k = 2, j = 0; j < i; j++)
	{
		/* Show the info */
		prt(info[j], k++, 15);

		/* Every 20 entries (lines 2 to 21), start over */
		if ((k == 22) && (j+1 < i))
		{
#ifdef JP
prt("-- ³ --", k, 15);
#else
			prt("-- more --", k, 15);
#endif

			inkey();
			for (; k > 2; k--) prt("", k, 15);
		}
	}

	/* Pause */
#ifdef JP
prt("[򲡤ȥޤ]", k, 13);
#else
	prt("[Press any key to continue]", k, 13);
#endif

	inkey();

	/* Restore the screen */
	screen_load();
}


static int report_magics_aux(int dur)
{
	if (dur <= 5)
	{
		return 0;
	}
	else if (dur <= 10)
	{
		return 1;
	}
	else if (dur <= 20)
	{
		return 2;
	}
	else if (dur <= 50)
	{
		return 3;
	}
	else if (dur <= 100)
	{
		return 4;
	}
	else if (dur <= 200)
	{
		return 5;
	}
	else
	{
		return 6;
	}
}

static cptr report_magic_durations[] =
{
#ifdef JP
"û",
"δ",
"Ф餯δ",
"¿Ĺ",
"Ĺ",
"Ĺ",
"񤤤ۤĹ",
"󥹥򹶷⤹ޤ"
#else
	"for a short time",
	"for a little while",
	"for a while",
	"for a long while",
	"for a long time",
	"for a very long time",
	"for an incredibly long time",
	"until you hit a monster"
#endif

};


/*
 * Report all currently active magical effects.
 */
void report_magics(void)
{
	int     i = 0, j, k;
	char    Dummy[80];
	cptr    info[128];
	int     info2[128];


	if (p_ptr->blind)
	{
		info2[i]  = report_magics_aux(p_ptr->blind);
#ifdef JP
info[i++] = "ʤܤʤ";
#else
		info[i++] = "You cannot see";
#endif

	}
	if (p_ptr->confused)
	{
		info2[i]  = report_magics_aux(p_ptr->confused);
#ifdef JP
info[i++] = "ʤϺ𤷤Ƥ롣";
#else
		info[i++] = "You are confused";
#endif

	}
	if (p_ptr->afraid)
	{
		info2[i]  = report_magics_aux(p_ptr->afraid);
#ifdef JP
info[i++] = "ʤ϶ݤ˿Ƥ롣";
#else
		info[i++] = "You are terrified";
#endif

	}
	if (p_ptr->poisoned)
	{
		info2[i]  = report_magics_aux(p_ptr->poisoned);
#ifdef JP
info[i++] = "ʤǤ˿Ƥ롣";
#else
		info[i++] = "You are poisoned";
#endif

	}
	if (p_ptr->image)
	{
		info2[i]  = report_magics_aux(p_ptr->image);
#ifdef JP
info[i++] = "ʤϸФ򸫤Ƥ롣";
#else
		info[i++] = "You are hallucinating";
#endif

	}
	if (p_ptr->blessed)
	{
		info2[i]  = report_magics_aux(p_ptr->blessed);
#ifdef JP
info[i++] = "ʤϸ򴶤Ƥ롣";
#else
		info[i++] = "You feel rightous";
#endif

	}
	if (p_ptr->hero)
	{
		info2[i]  = report_magics_aux(p_ptr->hero);
#ifdef JP
info[i++] = "ʤϥҡʬ";
#else
		info[i++] = "You feel heroic";
#endif

	}
	if (p_ptr->shero)
	{
		info2[i]  = report_magics_aux(p_ptr->shero);
#ifdef JP
info[i++] = "ʤƮ";
#else
		info[i++] = "You are in a battle rage";
#endif

	}
	if (p_ptr->protevil)
	{
		info2[i]  = report_magics_aux(p_ptr->protevil);
#ifdef JP
info[i++] = "ʤϼٰʤ¸ߤƤ롣";
#else
		info[i++] = "You are protected from evil";
#endif

	}
	if (p_ptr->shield)
	{
		info2[i]  = report_magics_aux(p_ptr->shield);
#ifdef JP
info[i++] = "ʤϿΥɤǼƤ롣";
#else
		info[i++] = "You are protected by a mystic shield";
#endif

	}
	if (p_ptr->invuln)
	{
		info2[i]  = report_magics_aux(p_ptr->invuln);
#ifdef JP
info[i++] = "̵ŨǤ롣";
#else
		info[i++] = "You are invulnerable";
#endif

	}
	if (p_ptr->wraith_form)
	{
		info2[i]  = report_magics_aux(p_ptr->wraith_form);
#ifdef JP
info[i++] = "ͩβǤ롣";
#else
		info[i++] = "You are incorporeal";
#endif

	}
	if (p_ptr->confusing)
	{
		info2[i]  = 7;
#ifdef JP
info[i++] = "ʤμ֤Ƥ롣";
#else
		info[i++] = "Your hands are glowing dull red.";
#endif

	}
	if (p_ptr->word_recall)
	{
		info2[i]  = report_magics_aux(p_ptr->word_recall);
#ifdef JP
info[i++] = "θ嵢Ԥξۤȯư롣";
#else
		info[i++] = "You are waiting to be recalled";
#endif

	}
	if (p_ptr->oppose_acid)
	{
		info2[i]  = report_magics_aux(p_ptr->oppose_acid);
#ifdef JP
info[i++] = "ʤϻؤäƤ롣";
#else
		info[i++] = "You are resistant to acid";
#endif

	}
	if (p_ptr->oppose_elec)
	{
		info2[i]  = report_magics_aux(p_ptr->oppose_elec);
#ifdef JP
info[i++] = "ʤŷؤäƤ롣";
#else
		info[i++] = "You are resistant to lightning";
#endif

	}
	if (p_ptr->oppose_fire)
	{
		info2[i]  = report_magics_aux(p_ptr->oppose_fire);
#ifdef JP
info[i++] = "ʤϲФؤäƤ롣";
#else
		info[i++] = "You are resistant to fire";
#endif

	}
	if (p_ptr->oppose_cold)
	{
		info2[i]  = report_magics_aux(p_ptr->oppose_cold);
#ifdef JP
info[i++] = "ʤ䵤ؤäƤ롣";
#else
		info[i++] = "You are resistant to cold";
#endif

	}
	if (p_ptr->oppose_pois)
	{
		info2[i]  = report_magics_aux(p_ptr->oppose_pois);
#ifdef JP
info[i++] = "ʤǤؤäƤ롣";
#else
		info[i++] = "You are resistant to poison";
#endif

	}

	/* Save the screen */
	screen_save();

	/* Erase the screen */
	for (k = 1; k < 24; k++) prt("", k, 13);

	/* Label the information */
#ifdef JP
prt("           ˡ        :", 1, 15);
#else
	prt("     Your Current Magic:", 1, 15);
#endif


	/* We will print on top of the map (column 13) */
	for (k = 2, j = 0; j < i; j++)
	{
		/* Show the info */
#ifdef JP
sprintf(Dummy, "ʤ%s%s", info[j],
#else
		sprintf(Dummy, "%s %s.", info[j],
#endif

			report_magic_durations[info2[j]]);
		prt(Dummy, k++, 15);

		/* Every 20 entries (lines 2 to 21), start over */
		if ((k == 22) && (j + 1 < i))
		{
#ifdef JP
prt("-- ³ --", k, 15);
#else
			prt("-- more --", k, 15);
#endif

			inkey();
			for (; k > 2; k--) prt("", k, 15);
		}
	}

	/* Pause */
#ifdef JP
prt("[򲡤ȥޤ]", k, 13);
#else
	prt("[Press any key to continue]", k, 13);
#endif

	inkey();

	/* Restore the screen */
	screen_load();
}


/*
 * Detect all traps on current panel
 */
bool detect_traps(void)
{
	int             x, y;
	bool            detect = FALSE;
	cave_type       *c_ptr;


	/* Scan the current panel */
	for (y = panel_row_min; y <= panel_row_max; y++)
	{
		for (x = panel_col_min; x <= panel_col_max; x++)
		{
			/* Access the grid */
			c_ptr = &cave[y][x];

			/* Detect invisible traps */
			if (c_ptr->feat == FEAT_INVIS)
			{
				/* Pick a trap */
				pick_trap(y, x);
			}

			/* Detect traps */
			if (is_trap(c_ptr->feat))
			{
				/* Hack -- Memorize */
				c_ptr->info |= (CAVE_MARK);

				/* Redraw */
				lite_spot(y, x);

				/* Obvious */
				detect = TRUE;
			}
		}
	}

	/* Describe */
	if (detect)
	{
#ifdef JP
msg_print("ȥåפ¸ߤ򴶤Ȥä");
#else
		msg_print("You sense the presence of traps!");
#endif

	}

	/* Result */
	return (detect);
}



/*
 * Detect all doors on current panel
 */
bool detect_doors(void)
{
	int y, x;

	bool detect = FALSE;

	cave_type *c_ptr;


	/* Scan the panel */
	for (y = panel_row_min; y <= panel_row_max; y++)
	{
		for (x = panel_col_min; x <= panel_col_max; x++)
		{
			c_ptr = &cave[y][x];

			/* Detect secret doors */
			if (c_ptr->feat == FEAT_SECRET)
			{
				/* Pick a door */
				place_closed_door(y, x);
			}

			/* Detect doors */
			if (((c_ptr->feat >= FEAT_DOOR_HEAD) &&
			     (c_ptr->feat <= FEAT_DOOR_TAIL)) ||
			    ((c_ptr->feat == FEAT_OPEN) ||
			     (c_ptr->feat == FEAT_BROKEN)))
			{
				/* Hack -- Memorize */
				c_ptr->info |= (CAVE_MARK);

				/* Redraw */
				lite_spot(y, x);

				/* Obvious */
				detect = TRUE;
			}
		}
	}

	/* Describe */
	if (detect)
	{
#ifdef JP
msg_print("ɥ¸ߤ򴶤Ȥä");
#else
		msg_print("You sense the presence of doors!");
#endif

	}

	/* Result */
	return (detect);
}


/*
 * Detect all stairs on current panel
 */
bool detect_stairs(void)
{
	int y, x;

	bool detect = FALSE;

	cave_type *c_ptr;


	/* Scan the panel */
	for (y = panel_row_min; y <= panel_row_max; y++)
	{
		for (x = panel_col_min; x <= panel_col_max; x++)
		{
			c_ptr = &cave[y][x];

			/* Detect stairs */
			if ((c_ptr->feat == FEAT_LESS) ||
			    (c_ptr->feat == FEAT_MORE))
			{
				/* Hack -- Memorize */
				c_ptr->info |= (CAVE_MARK);

				/* Redraw */
				lite_spot(y, x);

				/* Obvious */
				detect = TRUE;
			}
		}
	}

	/* Describe */
	if (detect)
	{
#ifdef JP
msg_print("ʤ¸ߤ򴶤Ȥä");
#else
		msg_print("You sense the presence of stairs!");
#endif

	}

	/* Result */
	return (detect);
}


/*
 * Detect any treasure on the current panel
 */
bool detect_treasure(void)
{
	int y, x;

	bool detect = FALSE;

	cave_type *c_ptr;


	/* Scan the current panel */
	for (y = panel_row_min; y <= panel_row_max; y++)
	{
		for (x = panel_col_min; x <= panel_col_max; x++)
		{
			c_ptr = &cave[y][x];

			/* Notice embedded gold */
			if ((c_ptr->feat == FEAT_MAGMA_H) ||
			    (c_ptr->feat == FEAT_QUARTZ_H))
			{
				/* Expose the gold */
				c_ptr->feat += 0x02;
			}

			/* Magma/Quartz + Known Gold */
			if ((c_ptr->feat == FEAT_MAGMA_K) ||
			    (c_ptr->feat == FEAT_QUARTZ_K))
			{
				/* Hack -- Memorize */
				c_ptr->info |= (CAVE_MARK);

				/* Redraw */
				lite_spot(y, x);

				/* Detect */
				detect = TRUE;
			}
		}
	}

	/* Describe */
	if (detect)
	{
#ifdef JP
msg_print("¢줿¸ߤ򴶤Ȥä");
#else
		msg_print("You sense the presence of buried treasure!");
#endif

	}


	/* Result */
	return (detect);
}



/*
 * Detect all "gold" objects on the current panel
 */
bool detect_objects_gold(void)
{
	int i, y, x;

	bool detect = FALSE;


	/* Scan objects */
	for (i = 1; i < o_max; i++)
	{
		object_type *o_ptr = &o_list[i];

		/* Skip dead objects */
		if (!o_ptr->k_idx) continue;

		/* Skip held objects */
		if (o_ptr->held_m_idx) continue;

		/* Location */
		y = o_ptr->iy;
		x = o_ptr->ix;

		/* Only detect nearby objects */
		if (!panel_contains(y, x)) continue;

		/* Detect "gold" objects */
		if (o_ptr->tval == TV_GOLD)
		{
			/* Hack -- memorize it */
			o_ptr->marked = TRUE;

			/* Redraw */
			lite_spot(y, x);

			/* Detect */
			detect = TRUE;
		}
	}

	/* Describe */
	if (detect)
	{
#ifdef JP
msg_print("¸ߤ򴶤Ȥä");
#else
		msg_print("You sense the presence of treasure!");
#endif

	}

	if (detect_monsters_string("$"))
	{
		detect = TRUE;
	}

	/* Result */
	return (detect);
}


/*
 * Detect all "normal" objects on the current panel
 */
bool detect_objects_normal(void)
{
	int i, y, x;

	bool detect = FALSE;


	/* Scan objects */
	for (i = 1; i < o_max; i++)
	{
		object_type *o_ptr = &o_list[i];

		/* Skip dead objects */
		if (!o_ptr->k_idx) continue;

		/* Skip held objects */
		if (o_ptr->held_m_idx) continue;

		/* Location */
		y = o_ptr->iy;
		x = o_ptr->ix;

		/* Only detect nearby objects */
		if (!panel_contains(y, x)) continue;

		/* Detect "real" objects */
		if (o_ptr->tval != TV_GOLD)
		{
			/* Hack -- memorize it */
			o_ptr->marked = TRUE;

			/* Redraw */
			lite_spot(y, x);

			/* Detect */
			detect = TRUE;
		}
	}

	/* Describe */
	if (detect)
	{
#ifdef JP
msg_print("ƥ¸ߤ򴶤Ȥä");
#else
		msg_print("You sense the presence of objects!");
#endif

	}

	if (detect_monsters_string("!=?|"))
	{
		detect = TRUE;
	}

	/* Result */
	return (detect);
}


/*
 * Detect all "magic" objects on the current panel.
 *
 * This will light up all spaces with "magic" items, including artifacts,
 * ego-items, potions, scrolls, books, rods, wands, staves, amulets, rings,
 * and "enchanted" items of the "good" variety.
 *
 * It can probably be argued that this function is now too powerful.
 */
bool detect_objects_magic(void)
{
	int i, y, x, tv;

	bool detect = FALSE;


	/* Scan all objects */
	for (i = 1; i < o_max; i++)
	{
		object_type *o_ptr = &o_list[i];

		/* Skip dead objects */
		if (!o_ptr->k_idx) continue;

		/* Skip held objects */
		if (o_ptr->held_m_idx) continue;

		/* Location */
		y = o_ptr->iy;
		x = o_ptr->ix;

		/* Only detect nearby objects */
		if (!panel_contains(y, x)) continue;

		/* Examine the tval */
		tv = o_ptr->tval;

		/* Artifacts, misc magic items, or enchanted wearables */
		if (artifact_p(o_ptr) ||
			ego_item_p(o_ptr) ||
			o_ptr->art_name ||
		    (tv == TV_AMULET) ||
			(tv == TV_RING) ||
		    (tv == TV_STAFF) ||
			(tv == TV_WAND) ||
			(tv == TV_ROD) ||
		    (tv == TV_SCROLL) ||
			(tv == TV_POTION) ||
		    (tv == TV_LIFE_BOOK) ||
			(tv == TV_SORCERY_BOOK) ||
		    (tv == TV_MUSOU_BOOK) ||
		    ((o_ptr->to_a > 0) || (o_ptr->to_h + o_ptr->to_d > 0)))
		{
			/* Memorize the item */
			o_ptr->marked = TRUE;

			/* Redraw */
			lite_spot(y, x);

			/* Detect */
			detect = TRUE;
		}
	}

	/* Describe */
	if (detect)
	{
#ifdef JP
msg_print("ˡΥƥ¸ߤ򴶤Ȥä");
#else
		msg_print("You sense the presence of magic objects!");
#endif

	}

	/* Return result */
	return (detect);
}


/*
 * Detect all "normal" monsters on the current panel
 */
bool detect_monsters_normal(void)
{
	int i, y, x;

	bool flag = FALSE;


	/* Scan monsters */
	for (i = 1; i < m_max; i++)
	{
		monster_type *m_ptr = &m_list[i];
		monster_race *r_ptr = &r_info[m_ptr->r_idx];

		/* Skip dead monsters */
		if (!m_ptr->r_idx) continue;

		/* Location */
		y = m_ptr->fy;
		x = m_ptr->fx;

		/* Only detect nearby monsters */
		if (!panel_contains(y, x)) continue;

		/* Detect all non-invisible monsters */
		if ((!(r_ptr->flags2 & RF2_INVISIBLE)) ||
		    p_ptr->see_inv || p_ptr->tim_invis)
		{
			/* Repair visibility later */
			repair_monsters = TRUE;

			/* Hack -- Detect monster */
			m_ptr->mflag |= (MFLAG_MARK | MFLAG_SHOW);

			/* Update the monster */
			update_mon(i, FALSE);

			/* Detect */
			flag = TRUE;
		}
	}

	/* Describe */
	if (flag)
	{
		/* Describe result */
#ifdef JP
msg_print("󥹥¸ߤ򴶤Ȥä");
#else
		msg_print("You sense the presence of monsters!");
#endif

	}

	/* Result */
	return (flag);
}


/*
 * Detect all "invisible" monsters around the player
 */
bool detect_monsters_invis(void)
{
	int i, y, x;
	bool flag = FALSE;

	/* Scan monsters */
	for (i = 1; i < m_max; i++)
	{
		monster_type *m_ptr = &m_list[i];
		monster_race *r_ptr = &r_info[m_ptr->r_idx];

		/* Skip dead monsters */
		if (!m_ptr->r_idx) continue;

		/* Location */
		y = m_ptr->fy;
		x = m_ptr->fx;

		/* Only detect nearby monsters */
		if (!panel_contains(y, x)) continue;

		/* Detect invisible monsters */
		if (r_ptr->flags2 & RF2_INVISIBLE)
		{
			/* Update monster recall window */
			if (p_ptr->monster_race_idx == m_ptr->r_idx)
			{
				/* Window stuff */
				p_ptr->window |= (PW_MONSTER);
			}

			/* Repair visibility later */
			repair_monsters = TRUE;

			/* Hack -- Detect monster */
			m_ptr->mflag |= (MFLAG_MARK | MFLAG_SHOW);

			/* Update the monster */
			update_mon(i, FALSE);

			/* Detect */
			flag = TRUE;
		}
	}

	/* Describe */
	if (flag)
	{
		/* Describe result */
#ifdef JP
msg_print("Ʃʪ¸ߤ򴶤Ȥä");
#else
		msg_print("You sense the presence of invisible creatures!");
#endif

	}

	/* Result */
	return (flag);
}



/*
 * Detect all "evil" monsters on current panel
 */
bool detect_monsters_evil(void)
{
	int i, y, x;
	bool flag = FALSE;


	/* Scan monsters */
	for (i = 1; i < m_max; i++)
	{
		monster_type *m_ptr = &m_list[i];
		monster_race *r_ptr = &r_info[m_ptr->r_idx];

		/* Skip dead monsters */
		if (!m_ptr->r_idx) continue;

		/* Location */
		y = m_ptr->fy;
		x = m_ptr->fx;

		/* Only detect nearby monsters */
		if (!panel_contains(y, x)) continue;

		/* Detect evil monsters */
		if (r_ptr->flags3 & RF3_EVIL)
		{
			/* Take note that they are evil */
			r_ptr->r_flags3 |= (RF3_EVIL);

			/* Update monster recall window */
			if (p_ptr->monster_race_idx == m_ptr->r_idx)
			{
				/* Window stuff */
				p_ptr->window |= (PW_MONSTER);
			}

			/* Repair visibility later */
			repair_monsters = TRUE;

			/* Hack -- Detect monster */
			m_ptr->mflag |= (MFLAG_MARK | MFLAG_SHOW);

			/* Update the monster */
			update_mon(i, FALSE);

			/* Detect */
			flag = TRUE;
		}
	}

	/* Describe */
	if (flag)
	{
		/* Describe result */
#ifdef JP
msg_print("ٰʤʪ¸ߤ򴶤Ȥä");
#else
		msg_print("You sense the presence of evil creatures!");
#endif

	}

	/* Result */
	return (flag);
}




/*
 * Detect all (string) monsters on current panel
 */
bool detect_monsters_string(cptr Match)
{
	int i, y, x;
	bool flag = FALSE;


	/* Scan monsters */
	for (i = 1; i < m_max; i++)
	{
		monster_type *m_ptr = &m_list[i];
		monster_race *r_ptr = &r_info[m_ptr->r_idx];

		/* Skip dead monsters */
		if (!m_ptr->r_idx) continue;

		/* Location */
		y = m_ptr->fy;
		x = m_ptr->fx;

		/* Only detect nearby monsters */
		if (!panel_contains(y, x)) continue;

		/* Detect monsters with the same symbol */
		if (strchr(Match, r_ptr->d_char))
		{
			/* Update monster recall window */
			if (p_ptr->monster_race_idx == m_ptr->r_idx)
			{
				/* Window stuff */
				p_ptr->window |= (PW_MONSTER);
			}

			/* Repair visibility later */
			repair_monsters = TRUE;

			/* Hack -- Detect monster */
			m_ptr->mflag |= (MFLAG_MARK | MFLAG_SHOW);

			/* Update the monster */
			update_mon(i, FALSE);

			/* Detect */
			flag = TRUE;
		}
	}

	/* Describe */
	if (flag)
	{
		/* Describe result */
#ifdef JP
msg_print("󥹥¸ߤ򴶤Ȥä");
#else
		msg_print("You sense the presence of monsters!");
#endif

	}

	/* Result */
	return (flag);
}


/*
 * A "generic" detect monsters routine, tagged to flags3
 */
bool detect_monsters_xxx(u32b match_flag)
{
	int  i, y, x;
	bool flag = FALSE;
#ifdef JP
cptr desc_monsters = "Ѥʥ󥹥";
#else
	cptr desc_monsters = "weird monsters";
#endif



	/* Scan monsters */
	for (i = 1; i < m_max; i++)
	{
		monster_type *m_ptr = &m_list[i];
		monster_race *r_ptr = &r_info[m_ptr->r_idx];

		/* Skip dead monsters */
		if (!m_ptr->r_idx) continue;

		/* Location */
		y = m_ptr->fy;
		x = m_ptr->fx;

		/* Only detect nearby monsters */
		if (!panel_contains(y, x)) continue;

		/* Detect evil monsters */
		if (r_ptr->flags3 & (match_flag))
		{
			/* Take note that they are something */
			r_ptr->r_flags3 |= (match_flag);

			/* Update monster recall window */
			if (p_ptr->monster_race_idx == m_ptr->r_idx)
			{
				/* Window stuff */
				p_ptr->window |= (PW_MONSTER);
			}

			/* Repair visibility later */
			repair_monsters = TRUE;

			/* Hack -- Detect monster */
			m_ptr->mflag |= (MFLAG_MARK | MFLAG_SHOW);

			/* Update the monster */
			update_mon(i, FALSE);

			/* Detect */
			flag = TRUE;
		}
	}

	/* Describe */
	if (flag)
	{
		switch (match_flag)
		{
			case RF3_DEMON:
#ifdef JP
desc_monsters = "ǡ";
#else
				desc_monsters = "demons";
#endif

				break;
			case RF3_UNDEAD:
#ifdef JP
desc_monsters = "ǥå";
#else
				desc_monsters = "the undead";
#endif

				break;
		}

		/* Describe result */
#ifdef JP
msg_format("%s¸ߤ򴶤Ȥä", desc_monsters);
#else
		msg_format("You sense the presence of %s!", desc_monsters);
#endif

		msg_print(NULL);
	}

	/* Result */
	return (flag);
}


/*
 * Detect everything
 */
bool detect_all(void)
{
	bool detect = FALSE;

	/* Detect everything */
	if (detect_traps()) detect = TRUE;
	if (detect_doors()) detect = TRUE;
	if (detect_stairs()) detect = TRUE;
	if (detect_treasure()) detect = TRUE;
	if (detect_objects_gold()) detect = TRUE;
	if (detect_objects_normal()) detect = TRUE;
	if (detect_monsters_invis()) detect = TRUE;
	if (detect_monsters_normal()) detect = TRUE;

	/* Result */
	return (detect);
}


/*
 * Apply a "project()" directly to all viewable monsters
 *
 * Note that affected monsters are NOT auto-tracked by this usage.
 *
 * To avoid misbehavior when monster deaths have side-effects,
 * this is done in two passes. -- JDL
 */
bool project_hack(int typ, int dam)
{
	int     i, x, y;
	u16b    flg = PROJECT_JUMP | PROJECT_KILL | PROJECT_HIDE;
	bool    obvious = FALSE;


	/* Mark all (nearby) monsters */
	for (i = 1; i < m_max; i++)
	{
		monster_type *m_ptr = &m_list[i];

		/* Paranoia -- Skip dead monsters */
		if (!m_ptr->r_idx) continue;

		/* Location */
		y = m_ptr->fy;
		x = m_ptr->fx;

		/* Require line of sight */
		if (!player_has_los_bold(y, x)) continue;

		/* Mark the monster */
		m_ptr->mflag |= (MFLAG_TEMP);
	}

	/* Affect all marked monsters */
	for (i = 1; i < m_max; i++)
	{
		monster_type *m_ptr = &m_list[i];

		/* Skip unmarked monsters */
		if (!(m_ptr->mflag & (MFLAG_TEMP))) continue;

		/* Remove mark */
		m_ptr->mflag &= ~(MFLAG_TEMP);

		/* Location */
		y = m_ptr->fy;
		x = m_ptr->fx;

		/* Jump directly to the target monster */
		if (project(0, 0, y, x, dam, typ, flg)) obvious = TRUE;
	}

	/* Result */
	return (obvious);
}


/*
 * Speed monsters
 */
bool speed_monsters(void)
{
	return (project_hack(GF_OLD_SPEED, p_ptr->lev));
}

/*
 * Slow monsters
 */
bool slow_monsters(void)
{
	return (project_hack(GF_OLD_SLOW, p_ptr->lev));
}

/*
 * Sleep monsters
 */
bool sleep_monsters(void)
{
	return (project_hack(GF_OLD_SLEEP, p_ptr->lev));
}


/*
 * Banish evil monsters
 */
bool banish_evil(int dist)
{
	return (project_hack(GF_AWAY_EVIL, dist));
}


/*
 * Turn undead
 */
bool turn_undead(void)
{
	bool tester = (project_hack(GF_TURN_UNDEAD, p_ptr->lev));

	if (tester)
		chg_virtue(V_UNLIFE, -1);

	return tester;
}


/*
 * Dispel undead monsters
 */
bool dispel_undead(int dam)
{
	bool tester = (project_hack(GF_DISP_UNDEAD, dam));

	if (tester)
		chg_virtue(V_UNLIFE, -2);

	return tester;
}

/*
 * Dispel evil monsters
 */
bool dispel_evil(int dam)
{
	return (project_hack(GF_DISP_EVIL, dam));
}

/*
 * Dispel good monsters
 */
bool dispel_good(int dam)
{
	return (project_hack(GF_DISP_GOOD, dam));
}

/*
 * Dispel all monsters
 */
bool dispel_monsters(int dam)
{
	return (project_hack(GF_DISP_ALL, dam));
}

/*
 * Dispel 'living' monsters
 */
bool dispel_living(int dam)
{
	return (project_hack(GF_DISP_LIVING, dam));
}

/*
 * Dispel demons
 */
bool dispel_demons(int dam)
{
	return (project_hack(GF_DISP_DEMON, dam));
}


/*
 * Wake up all monsters, and speed up "los" monsters.
 */
void aggravate_monsters(int who)
{
	int     i;
	bool    sleep = FALSE;
	bool    speed = FALSE;


	/* Aggravate everyone nearby */
	for (i = 1; i < m_max; i++)
	{
		monster_type    *m_ptr = &m_list[i];
		monster_race    *r_ptr = &r_info[m_ptr->r_idx];

		/* Paranoia -- Skip dead monsters */
		if (!m_ptr->r_idx) continue;

		/* Skip aggravating monster (or player) */
		if (i == who) continue;

		/* Wake up nearby sleeping monsters */
		if (m_ptr->cdis < MAX_SIGHT * 2)
		{
			/* Wake up */
			if (m_ptr->csleep)
			{
				/* Wake up */
				m_ptr->csleep = 0;
				sleep = TRUE;
				
				/* Redraw (later) if needed */
				if (p_ptr->health_who == i)
						p_ptr->redraw |= (PR_HEALTH);
			}
		}

		/* Speed up monsters in line of sight */
		if (player_has_los_bold(m_ptr->fy, m_ptr->fx))
		{
			/* Speed up (instantly) to racial base + 10 */
			if (m_ptr->mspeed < r_ptr->speed + 10)
			{
				/* Speed up */
				m_ptr->mspeed = r_ptr->speed + 10;
				speed = TRUE;
			}
		}
	}

	/* Messages */
#ifdef JP
if (speed) msg_print("նǲǡʳ褦ʴ");
else if (sleep) msg_print("ǡʳ褦󤯤ʹ");
#else
	if (speed) msg_print("You feel a sudden stirring nearby!");
	else if (sleep) msg_print("You hear a sudden stirring in the distance!");
#endif

}



/*
 * Delete all non-unique/non-quest monsters of a given "type" from the level
 */
/*
 * ironman_hengbandONλ񹳤Ǥͤɲápower0ʤԲġ
 */
bool genocide(int power)
{
	int     i;
	char    typ;
	bool    result = FALSE;
	int     msec = delay_factor * delay_factor * delay_factor;

	/* Prevent genocide in quest levels */
	if ((p_ptr->inside_quest && quest[p_ptr->inside_quest].type != QUEST_TYPE_RANDOM))
	{
		return (FALSE);
	}

	/* Mega-Hack -- Get a monster symbol */
#ifdef JP
(void)(get_com("ɤμ(ʸ)Υ󥹥ޤ: ", &typ));
#else
	(void)(get_com("Choose a monster race (by symbol) to genocide: ", &typ));
#endif


	/* Delete the monsters of that "type" */
	for (i = 1; i < m_max; i++)
	{
		monster_type    *m_ptr = &m_list[i];
		monster_race    *r_ptr = &r_info[m_ptr->r_idx];
		bool resist = FALSE;

		/* Paranoia -- Skip dead monsters */
		if (!m_ptr->r_idx) continue;

		/* Skip "wrong" monsters */
		if (r_ptr->d_char != typ) continue;

		/* Hack -- Skip Unique Monsters */
		if (r_ptr->flags1 & (RF1_UNIQUE)) resist = TRUE;

		/* Hack -- Skip Quest Monsters */
		if (r_ptr->flags1 & RF1_QUESTOR) resist = TRUE;

		/* Hack -- Monster have resistance to genocide */
		if (power && (m_ptr->flags & MF_NO_GENO)) resist = TRUE;

		/* Saving throw */
		if (ironman_hengband && power && r_ptr->level > randint(power)) resist = TRUE;

		if (resist)
		{
			char m_name[80];
			monster_desc(m_name, m_ptr, 0);
			if (m_ptr->ml)
			{
				msg_format("%^sˤϸ̤ʤä", m_name);
			}
			if (m_ptr->csleep)
			{
				m_ptr->csleep = 0;

				if (m_ptr->ml)
				{
					msg_format("%^sܤФޤ", m_name);
				}
			}
			if (is_friendly(m_ptr))
			{
				set_hostile(m_ptr);

				if (m_ptr->ml)
				{
					msg_format("%^sܤä", m_name);
				}
			}

			/* Monster occationally acquire resistance to genocide */
			if (one_in_(13)) m_ptr->flags |= MF_NO_GENO;
		}
		else
		{
			/* Delete the monster */
			delete_monster_idx(i);
		}


		if (power)
		{
			/* Take damage */
#ifdef JP
take_hit(randint(4), "μʸ򾧤ϫ");
#else
			take_hit(randint(4), "the strain of casting Genocide");
#endif

		}

		/* Visual feedback */
		move_cursor_relative(py, px);

		/* Redraw */
		p_ptr->redraw |= (PR_HP);

		/* Window stuff */
		p_ptr->window |= (PW_PLAYER);

		/* Handle */
		handle_stuff();

		/* Fresh */
		Term_fresh();

		/* Delay */
		Term_xtra(TERM_XTRA_DELAY, msec);

		/* Take note */
		result = TRUE;
	}

	if (result)
		chg_virtue(V_VITALITY, -2);

	return (result);
}


/*
 * Delete all nearby (non-unique) monsters
 */
/*
 * ironman_hengbandONλ񹳤Ǥͤɲápower0ʤԲġ
 */
bool mass_genocide(int power)
{
	int     i;
	bool    result = FALSE;
	int     msec = delay_factor * delay_factor * delay_factor;


	/* Prevent mass genocide in quest levels */
	if ((p_ptr->inside_quest && quest[p_ptr->inside_quest].type != QUEST_TYPE_RANDOM))
	{
		return (FALSE);
	}

	/* Delete the (nearby) monsters */
	for (i = 1; i < m_max; i++)
	{
		monster_type    *m_ptr = &m_list[i];
		monster_race    *r_ptr = &r_info[m_ptr->r_idx];
		bool resist = FALSE;

		/* Paranoia -- Skip dead monsters */
		if (!m_ptr->r_idx) continue;

		/* Skip distant monsters */
		if (m_ptr->cdis > MAX_SIGHT) continue;

		/* Hack -- Skip unique monsters */
		if (r_ptr->flags1 & (RF1_UNIQUE)) resist = TRUE;

		/* Hack -- Skip Quest Monsters */
		if (r_ptr->flags1 & RF1_QUESTOR) resist = TRUE;

		/* Hack -- Monster have resistance to genocide */
		if (power && (m_ptr->flags & MF_NO_GENO)) resist = TRUE;

		/* Saving throw */
		if (ironman_hengband && power && r_ptr->level > randint(power)) resist = TRUE;

		if (resist)
		{
			char m_name[80];
			monster_desc(m_name, m_ptr, 0);
			if (m_ptr->ml)
			{
				msg_format("%^sˤϸ̤ʤä", m_name);
			}
			if (m_ptr->csleep)
			{
				m_ptr->csleep = 0;

				if (m_ptr->ml)
				{
					msg_format("%^sܤФޤ", m_name);
				}
			}
			if (is_friendly(m_ptr))
			{
				set_hostile(m_ptr);

				if (m_ptr->ml)
				{
					msg_format("%^sܤä", m_name);
				}
			}

			/* Monster occationally acquire resistance to genocide */
			if (one_in_(13)) m_ptr->flags |= MF_NO_GENO;
		}
		else
		{
			/* Delete the monster */
			delete_monster_idx(i);
		}

		if (power)
		{
			/* Hack -- visual feedback */
#ifdef JP
take_hit(randint(3), "μʸ򾧤ϫ");
#else
			take_hit(randint(3), "the strain of casting Mass Genocide");
#endif

		}

		move_cursor_relative(py, px);

		/* Redraw */
		p_ptr->redraw |= (PR_HP);

		/* Window stuff */
		p_ptr->window |= (PW_PLAYER);

		/* Handle */
		handle_stuff();

		/* Fresh */
		Term_fresh();

		/* Delay */
		Term_xtra(TERM_XTRA_DELAY, msec);

		/* Note effect */
		result = TRUE;
	}

	if (result)
		chg_virtue(V_VITALITY, -2);

	return (result);
}



/*
 * Probe nearby monsters
 */
bool probing(void)
{
	int     i;
	bool    probe = FALSE;


	/* Probe all (nearby) monsters */
	for (i = 1; i < m_max; i++)
	{
		monster_type *m_ptr = &m_list[i];

		/* Paranoia -- Skip dead monsters */
		if (!m_ptr->r_idx) continue;

		/* Require line of sight */
		if (!player_has_los_bold(m_ptr->fy, m_ptr->fx)) continue;

		/* Probe visible monsters */
		if (m_ptr->ml)
		{
			char m_name[80];

			/* Start the message */
#ifdef JP
if (!probe) msg_print("Ĵ...");
#else
			if (!probe) msg_print("Probing...");
#endif


			/* Get "the monster" or "something" */
			monster_desc(m_name, m_ptr, 0x04);

			/* Describe the monster */
#ifdef JP
msg_format("%^s HP  %d 롣", m_name, m_ptr->hp);
#else
			msg_format("%^s has %d hit points.", m_name, m_ptr->hp);
#endif


			/* Learn all of the non-spell, non-treasure flags */
			lore_do_probe(i);

			/* Probe worked */
			probe = TRUE;
		}
	}

	/* Done */
	if (probe)
	{
		if (probe)
			chg_virtue(V_KNOWLEDGE, 1);

#ifdef JP
msg_print("Ǥ");
#else
		msg_print("That's all.");
#endif

	}

	/* Result */
	return (probe);
}



/*
 * The spell of destruction
 *
 * This spell "deletes" monsters (instead of "killing" them).
 *
 * Later we may use one function for both "destruction" and
 * "earthquake" by using the "full" to select "destruction".
 */
bool destroy_area(int y1, int x1, int r, int full)
{
	int       y, x, k, t;
	cave_type *c_ptr;
	bool      flag = FALSE;


	/* Prevent destruction of quest levels and town */
	if ((p_ptr->inside_quest && quest[p_ptr->inside_quest].type != QUEST_TYPE_RANDOM) || !dun_level)
	{
		return (FALSE);
	}

	/* Big area of affect */
	for (y = (y1 - r); y <= (y1 + r); y++)
	{
		for (x = (x1 - r); x <= (x1 + r); x++)
		{
			/* Skip illegal grids */
			if (!in_bounds(y, x)) continue;

			/* Extract the distance */
			k = distance(y1, x1, y, x);

			/* Stay in the circle of death */
			if (k > r) continue;

			/* Access the grid */
			c_ptr = &cave[y][x];

			/* Lose room and vault */
			c_ptr->info &= ~(CAVE_ROOM | CAVE_ICKY);

			/* Lose light and knowledge */
			c_ptr->info &= ~(CAVE_MARK | CAVE_GLOW);

			/* Hack -- Notice player affect */
			if ((x == px) && (y == py))
			{
				/* Hurt the player later */
				flag = TRUE;

				/* Do not hurt this grid */
				continue;
			}

			/* Hack -- Skip the epicenter */
			if ((y == y1) && (x == x1)) continue;

			if (r_info[m_list[c_ptr->m_idx].r_idx].flags1 & RF1_QUESTOR)
			{
				/* Heal the monster */
				m_list[c_ptr->m_idx].hp = m_list[c_ptr->m_idx].maxhp;

				/* Try to teleport away quest monsters */
				if (!teleport_away(c_ptr->m_idx, (r * 2) + 1)) continue;
			}
			else
			{
				/* Delete the monster (if any) */
				delete_monster(y, x);
			}

			/* Preserve Artifacts */
			if (ironman_hengband && preserve_mode)
			{
				s16b this_o_idx, next_o_idx = 0;

				/* Scan all objects in the grid */
				for (this_o_idx = c_ptr->o_idx; this_o_idx; this_o_idx = next_o_idx)
				{
					object_type *o_ptr;

					/* Acquire object */
					o_ptr = &o_list[this_o_idx];

					/* Acquire next object */
					next_o_idx = o_ptr->next_o_idx;

					/* Hack -- Preserve unknown artifacts */
					if (artifact_p(o_ptr) && !object_known_p(o_ptr))
					{
						/* Mega-Hack -- Preserve the artifact */
						a_info[o_ptr->name1].cur_num = 0;
					}
				}
			}
					
			/* Destroy "valid" grids */
			if (cave_valid_bold(y, x) ||
			    (ironman_hengband && !cave_perma_bold(y, x)))
			{
				/* Delete objects */
				delete_object(y, x);

				/* Wall (or floor) type */
				t = rand_int(200);

				/* Granite */
				if (t < 20)
				{
					/* Create granite wall */
					c_ptr->feat = FEAT_WALL_EXTRA;
				}

				/* Quartz */
				else if (t < 70)
				{
					/* Create quartz vein */
					c_ptr->feat = FEAT_QUARTZ;
				}

				/* Magma */
				else if (t < 100)
				{
					/* Create magma vein */
					c_ptr->feat = FEAT_MAGMA;
				}

				/* Floor */
				else
				{
					/* Create floor */
					c_ptr->feat = FEAT_FLOOR;
				}
			}
		}
	}


	/* Hack -- Affect player */
	if (flag)
	{
		/* Message */
#ifdef JP
msg_print("ǳ褦ȯ");
#else
		msg_print("There is a searing blast of light!");
#endif


		/* Blind the player */
		if (!p_ptr->resist_blind && !p_ptr->resist_lite)
		{
			/* Become blind */
			(void)set_blind(p_ptr->blind + 10 + randint(10));
		}
	}


	/* Mega-Hack -- Forget the view and lite */
	p_ptr->update |= (PU_UN_VIEW | PU_UN_LITE);

	/* Update stuff */
	p_ptr->update |= (PU_VIEW | PU_LITE | PU_FLOW);

	/* Update the monsters */
	p_ptr->update |= (PU_MONSTERS);

	/* Redraw map */
	p_ptr->redraw |= (PR_MAP);

	/* Window stuff */
	p_ptr->window |= (PW_OVERHEAD | PW_DUNGEON);

	/* Success */
	return (TRUE);
}


/*
 * Induce an "earthquake" of the given radius at the given location.
 *
 * This will turn some walls into floors and some floors into walls.
 *
 * The player will take damage and "jump" into a safe grid if possible,
 * otherwise, he will "tunnel" through the rubble instantaneously.
 *
 * Monsters will take damage, and "jump" into a safe grid if possible,
 * otherwise they will be "buried" in the rubble, disappearing from
 * the level in the same way that they do when genocided.
 *
 * Note that thus the player and monsters (except eaters of walls and
 * passers through walls) will never occupy the same grid as a wall.
 * Note that as of now (2.7.8) no monster may occupy a "wall" grid, even
 * for a single turn, unless that monster can pass_walls or kill_walls.
 * This has allowed massive simplification of the "monster" code.
 */
bool earthquake(int cy, int cx, int r)
{
	int             i, t, y, x, yy, xx, dy, dx, oy, ox;
	int             damage = 0;
	int             sn = 0, sy = 0, sx = 0;
	bool            hurt = FALSE;
	cave_type       *c_ptr;
	bool            map[32][32];


	/* Prevent destruction of quest levels and town */
	if (p_ptr->inside_quest || !dun_level)
	{
		return (FALSE);
	}

	/* Paranoia -- Enforce maximum range */
	if (r > 12) r = 12;

	/* Clear the "maximal blast" area */
	for (y = 0; y < 32; y++)
	{
		for (x = 0; x < 32; x++)
		{
			map[y][x] = FALSE;
		}
	}

	/* Check around the epicenter */
	for (dy = -r; dy <= r; dy++)
	{
		for (dx = -r; dx <= r; dx++)
		{
			/* Extract the location */
			yy = cy + dy;
			xx = cx + dx;

			/* Skip illegal grids */
			if (!in_bounds(yy, xx)) continue;

			/* Skip distant grids */
			if (distance(cy, cx, yy, xx) > r) continue;

			/* Access the grid */
			c_ptr = &cave[yy][xx];

			/* Lose room and vault */
			c_ptr->info &= ~(CAVE_ROOM | CAVE_ICKY);

			/* Lose light and knowledge */
			c_ptr->info &= ~(CAVE_GLOW | CAVE_MARK);

			/* Skip the epicenter */
			if (!dx && !dy) continue;

			/* Skip most grids */
			if (rand_int(100) < 85) continue;

			/* Damage this grid */
			map[16+yy-cy][16+xx-cx] = TRUE;

			/* Hack -- Take note of player damage */
			if ((yy == py) && (xx == px)) hurt = TRUE;
		}
	}

	/* First, affect the player (if necessary) */
	if (hurt)
	{
		/* Check around the player */
		for (i = 0; i < 8; i++)
		{
			/* Access the location */
			y = py + ddy_ddd[i];
			x = px + ddx_ddd[i];

			/* Skip non-empty grids */
			if (!cave_empty_bold(y, x)) continue;

			/* Important -- Skip "quake" grids */
			if (map[16+y-cy][16+x-cx]) continue;

			/* Count "safe" grids */
			sn++;

			/* Randomize choice */
			if (rand_int(sn) > 0) continue;

			/* Save the safe location */
			sy = y; sx = x;
		}

		/* Random message */
		switch (randint(3))
		{
			case 1:
			{
#ifdef JP
msg_print("󥸥ɤ줿");
#else
				msg_print("The cave ceiling collapses!");
#endif

				break;
			}
			case 2:
			{
#ifdef JP
msg_print("󥸥ξԼˤͤʤä");
#else
				msg_print("The cave floor twists in an unnatural way!");
#endif

				break;
			}
			default:
			{
#ifdef JP
msg_print("󥸥ɤ줿줿䤬Ƭ˹ߤäƤ");
#else
				msg_print("The cave quakes!  You are pummeled with debris!");
#endif

				break;
			}
		}

		/* Hurt the player a lot */
		if (!sn)
		{
			/* Message and damage */
#ifdef JP
msg_print("ʤϤҤɤä");
#else
			msg_print("You are severely crushed!");
#endif

			damage = 300;
		}

		/* Destroy the grid, and push the player to safety */
		else
		{
			/* Calculate results */
			switch (randint(3))
			{
				case 1:
				{
#ifdef JP
msg_print("ߤ򤦤ޤ򤱤");
#else
					msg_print("You nimbly dodge the blast!");
#endif

					damage = 0;
					break;
				}
				case 2:
				{
#ifdef JP
msg_print("Фʤľ⤷!");
#else
					msg_print("You are bashed by rubble!");
#endif

					damage = damroll(10, 4);
					(void)set_stun(p_ptr->stun + randint(50));
					break;
				}
				case 3:
				{
#ifdef JP
msg_print("ʤϾɤȤδ֤˶ޤƤޤä");
#else
					msg_print("You are crushed between the floor and ceiling!");
#endif

					damage = damroll(10, 4);
					(void)set_stun(p_ptr->stun + randint(50));
					break;
				}
			}

			/* Save the old location */
			oy = py;
			ox = px;

			/* Move the player to the safe location */
			py = sy;
			px = sx;

			/* Redraw the old spot */
			lite_spot(oy, ox);

			/* Redraw the new spot */
			lite_spot(py, px);

			/* Check for new panel */
			verify_panel();
		}

		/* Important -- no wall on player */
		map[16+py-cy][16+px-cx] = FALSE;

		/* Take some damage */
#ifdef JP
if (damage) take_hit(damage, "Ͽ");
#else
		if (damage) take_hit(damage, "an earthquake");
#endif

	}


	/* Examine the quaked region */
	for (dy = -r; dy <= r; dy++)
	{
		for (dx = -r; dx <= r; dx++)
		{
			/* Extract the location */
			yy = cy + dy;
			xx = cx + dx;

			/* Skip unaffected grids */
			if (!map[16+yy-cy][16+xx-cx]) continue;

			/* Access the grid */
			c_ptr = &cave[yy][xx];

			/* Process monsters */
			if (c_ptr->m_idx)
			{
				monster_type *m_ptr = &m_list[c_ptr->m_idx];
				monster_race *r_ptr = &r_info[m_ptr->r_idx];

				/* Quest monsters */
				if (r_ptr->flags1 & RF1_QUESTOR)
				{
					/* No wall on quest monsters */
					map[16+yy-cy][16+xx-cx] = FALSE;

					continue;
				}

				/* Most monsters cannot co-exist with rock */
				if (!(r_ptr->flags2 & (RF2_KILL_WALL)) &&
				    !(r_ptr->flags2 & (RF2_PASS_WALL)))
				{
					char m_name[80];

					/* Assume not safe */
					sn = 0;

					/* Monster can move to escape the wall */
					if (!(r_ptr->flags1 & (RF1_NEVER_MOVE)))
					{
						/* Look for safety */
						for (i = 0; i < 8; i++)
						{
							/* Access the grid */
							y = yy + ddy_ddd[i];
							x = xx + ddx_ddd[i];

							/* Skip non-empty grids */
							if (!cave_empty_bold(y, x)) continue;

							/* Hack -- no safety on glyph of warding */
							if (cave[y][x].feat == FEAT_GLYPH) continue;
							if (cave[y][x].feat == FEAT_MINOR_GLYPH) continue;

							/* ... nor on the Pattern */
							if ((cave[y][x].feat <= FEAT_PATTERN_XTRA2) &&
							    (cave[y][x].feat >= FEAT_PATTERN_START))
								continue;

							/* Important -- Skip "quake" grids */
							if (map[16+y-cy][16+x-cx]) continue;

							/* Count "safe" grids */
							sn++;

							/* Randomize choice */
							if (rand_int(sn) > 0) continue;

							/* Save the safe grid */
							sy = y; sx = x;
						}
					}

					/* Describe the monster */
					monster_desc(m_name, m_ptr, 0);

					/* Scream in pain */
#ifdef JP
msg_format("%^s϶ˤǵ㤭ᤤ", m_name);
#else
					msg_format("%^s wails out in pain!", m_name);
#endif


					/* Take damage from the quake */
					damage = (sn ? damroll(4, 8) : (m_ptr->hp + 1));

					/* Monster is certainly awake */
					m_ptr->csleep = 0;

					/* Apply damage directly */
					m_ptr->hp -= damage;

					/* Delete (not kill) "dead" monsters */
					if (m_ptr->hp < 0)
					{
						/* Message */
#ifdef JP
msg_format("%^sϴФƤޤä", m_name);
#else
						msg_format("%^s is embedded in the rock!", m_name);
#endif


						/* Delete the monster */
						delete_monster(yy, xx);

						/* No longer safe */
						sn = 0;
					}

					/* Hack -- Escape from the rock */
					if (sn)
					{
						int m_idx = cave[yy][xx].m_idx;

						/* Update the new location */
						cave[sy][sx].m_idx = m_idx;

						/* Update the old location */
						cave[yy][xx].m_idx = 0;

						/* Move the monster */
						m_ptr->fy = sy;
						m_ptr->fx = sx;

						/* Update the monster (new location) */
						update_mon(m_idx, TRUE);

						/* Redraw the old grid */
						lite_spot(yy, xx);

						/* Redraw the new grid */
						lite_spot(sy, sx);
					}
				}
			}
		}
	}


	/* Examine the quaked region */
	for (dy = -r; dy <= r; dy++)
	{
		for (dx = -r; dx <= r; dx++)
		{
			/* Extract the location */
			yy = cy + dy;
			xx = cx + dx;

			/* Skip unaffected grids */
			if (!map[16+yy-cy][16+xx-cx]) continue;

			/* Access the cave grid */
			c_ptr = &cave[yy][xx];

			/* Paranoia -- never affect player */
			if ((yy == py) && (xx == px)) continue;

			/* Destroy location (if valid) */
			if (cave_valid_bold(yy, xx))
			{
				bool floor = cave_floor_bold(yy, xx);

				/* Delete objects */
				delete_object(yy, xx);

				/* Wall (or floor) type */
				t = (floor ? rand_int(100) : 200);

				/* Granite */
				if (t < 20)
				{
					/* Create granite wall */
					c_ptr->feat = FEAT_WALL_EXTRA;
				}

				/* Quartz */
				else if (t < 70)
				{
					/* Create quartz vein */
					c_ptr->feat = FEAT_QUARTZ;
				}

				/* Magma */
				else if (t < 100)
				{
					/* Create magma vein */
					c_ptr->feat = FEAT_MAGMA;
				}

				/* Floor */
				else
				{
					/* Create floor */
					c_ptr->feat = FEAT_FLOOR;
				}
			}
		}
	}


	/* Mega-Hack -- Forget the view and lite */
	p_ptr->update |= (PU_UN_VIEW | PU_UN_LITE);

	/* Update stuff */
	p_ptr->update |= (PU_VIEW | PU_LITE | PU_FLOW);

	/* Update the monsters */
	p_ptr->update |= (PU_DISTANCE);

	/* Update the health bar */
	p_ptr->redraw |= (PR_HEALTH);

	/* Redraw map */
	p_ptr->redraw |= (PR_MAP);

	/* Window stuff */
	p_ptr->window |= (PW_OVERHEAD | PW_DUNGEON);

	/* Success */
	return (TRUE);
}


/*
 * This routine clears the entire "temp" set.
 *
 * This routine will Perma-Lite all "temp" grids.
 *
 * This routine is used (only) by "lite_room()"
 *
 * Dark grids are illuminated.
 *
 * Also, process all affected monsters.
 *
 * SMART monsters always wake up when illuminated
 * NORMAL monsters wake up 1/4 the time when illuminated
 * STUPID monsters wake up 1/10 the time when illuminated
 */
static void cave_temp_room_lite(void)
{
	int i, j;

	/* Clear them all */
	for (i = 0; i < temp_n; i++)
	{
		for (j = 0; j < 8; j++)
		{
			int y = temp_y[i] + ddy_cdd[j];
			int x = temp_x[i] + ddx_cdd[j];

			cave_type *c_ptr = &cave[y][x];

			/* Verify */
			if (!in_bounds2(y, x)) continue;

			/* No longer in the array */
			c_ptr->info &= ~(CAVE_TEMP);

			/* Update only non-CAVE_GLOW grids */
			if (c_ptr->info & (CAVE_GLOW)) continue;

			/* Perma-Lite */
			c_ptr->info |= (CAVE_GLOW);

			/* Process affected monsters */
			if (c_ptr->m_idx)
			{
				int chance = 25;

				monster_type    *m_ptr = &m_list[c_ptr->m_idx];

				monster_race    *r_ptr = &r_info[m_ptr->r_idx];

				/* Update the monster */
				update_mon(c_ptr->m_idx, FALSE);

				/* Stupid monsters rarely wake up */
				if (r_ptr->flags2 & (RF2_STUPID)) chance = 10;

				/* Smart monsters always wake up */
				if (r_ptr->flags2 & (RF2_SMART)) chance = 100;

				/* Sometimes monsters wake up */
				if (m_ptr->csleep && (rand_int(100) < chance))
				{
					/* Wake up! */
					m_ptr->csleep = 0;

					/* Notice the "waking up" */
					if (m_ptr->ml)
					{
						char m_name[80];

						/* Acquire the monster name */
						monster_desc(m_name, m_ptr, 0);

						/* Dump a message */
#ifdef JP
msg_format("%^sܤФޤ", m_name);
#else
						msg_format("%^s wakes up.", m_name);
#endif

						
						/* Redraw the health bar */
						if (p_ptr->health_who == c_ptr->m_idx)
							p_ptr->redraw |= (PR_HEALTH);
					}
				}
			}

			/* Note */
			note_spot(y, x);

			/* Redraw */
			lite_spot(y, x);
		}
	}

	/* None left */
	temp_n = 0;
}



/*
 * This routine clears the entire "temp" set.
 *
 * This routine will "darken" all "temp" grids.
 *
 * In addition, some of these grids will be "unmarked".
 *
 * This routine is used (only) by "unlite_room()"
 *
 * Also, process all affected monsters
 */
static void cave_temp_room_unlite(void)
{
	int i, j;

	/* Clear them all */
	for (i = 0; i < temp_n; i++)
	{
		for (j = 0; j < 8; j++)
		{
			int y = temp_y[i] + ddy_cdd[j];
			int x = temp_x[i] + ddx_cdd[j];

			cave_type *c_ptr = &cave[y][x];

			/* Verify */
			if (!in_bounds2(y, x)) continue;

			/* No longer in the array */
			c_ptr->info &= ~(CAVE_TEMP);

			/* Darken the grid */
			c_ptr->info &= ~(CAVE_GLOW);

			/* Hack -- Forget "boring" grids */
			if ((c_ptr->feat <= FEAT_INVIS) || (c_ptr->feat == FEAT_WALL_INVIS))
			{
				/* Forget the grid */
				c_ptr->info &= ~(CAVE_MARK);

				/* Notice */
				note_spot(y, x);
			}

			/* Process affected monsters */
			if (c_ptr->m_idx)
			{
				/* Update the monster */
				update_mon(c_ptr->m_idx, FALSE);
			}

			/* Redraw */
			lite_spot(y, x);
		}
	}

	/* None left */
	temp_n = 0;
}


/*
 * Determine how much contiguous open space this grid is next to
 */
static int next_to_open(int cy, int cx)
{
	int i;

	int y, x;

	int len = 0;
	int blen = 0;

	for (i = 0; i < 16; i++)
	{
		y = cy + ddy_cdd[i % 8];
		x = cx + ddx_cdd[i % 8];

		/* Found a wall, break the length */
		if (!cave_floor_bold(y, x))
		{
			/* Track best length */
			if (len > blen)
			{
				blen = len;
			}

			len = 0;
		}
		else
		{
			len++;
		}
	}

	return (MAX(len, blen));
}


static int next_to_walls_adj(int cy, int cx)
{
	int i;

	int y, x;

	int c = 0;

	for (i = 0; i < 8; i++)
	{
		y = cy + ddy_ddd[i];
		x = cx + ddx_ddd[i];

		if (!cave_floor_bold(y, x)) c++;
	}

	return c;
}


/*
 * Aux function -- see below
 */
static void cave_temp_room_aux(int y, int x)
{
	cave_type *c_ptr;

	/* Verify */
	if (!in_bounds(y, x)) return;

	/* Get the grid */
	c_ptr = &cave[y][x];

	/* Avoid infinite recursion */
	if (c_ptr->info & (CAVE_TEMP)) return;

	/* If a wall, exit */
	if (!cave_floor_bold(y, x)) return;

	/* Do not exceed the maximum spell range */
	if (distance(py, px, y, x) > MAX_RANGE) return;


	/* Verify this grid */
	/*
	* The reason why it is ==6 instead of >5 is that 8 is impossible
	* due to the check for cave_bold above.
	* 7 lights dead-end corridors (you need to do this for the
	* checkboard interesting rooms, so that the boundary is lit
	* properly.
	* This leaves only a check for 6 bounding walls!
	*/
	if ((next_to_walls_adj(y, x) == 6) && (next_to_open(y, x) <= 1)) return;

	/* Paranoia -- verify space */
	if (temp_n == TEMP_MAX) return;

	/* Mark the grid as "seen" */
	c_ptr->info |= (CAVE_TEMP);

	/* Add it to the "seen" set */
	temp_y[temp_n] = y;
	temp_x[temp_n] = x;
	temp_n++;
}



/*
 * Illuminate any room containing the given location.
 */
void lite_room(int y1, int x1)
{
	int i, x, y;

	/* Add the initial grid */
	cave_temp_room_aux(y1, x1);

	/* While grids are in the queue, add their neighbors */
	for (i = 0; i < temp_n; i++)
	{
		x = temp_x[i], y = temp_y[i];

		/* Walls get lit, but stop light */
		if (!cave_floor_bold(y, x)) continue;

		/* Spread adjacent */
		cave_temp_room_aux(y + 1, x);
		cave_temp_room_aux(y - 1, x);
		cave_temp_room_aux(y, x + 1);
		cave_temp_room_aux(y, x - 1);

		/* Spread diagonal */
		cave_temp_room_aux(y + 1, x + 1);
		cave_temp_room_aux(y - 1, x - 1);
		cave_temp_room_aux(y - 1, x + 1);
		cave_temp_room_aux(y + 1, x - 1);
	}

	/* Now, lite them all up at once */
	cave_temp_room_lite();
}


/*
 * Darken all rooms containing the given location
 */
void unlite_room(int y1, int x1)
{
	int i, x, y;

	/* Add the initial grid */
	cave_temp_room_aux(y1, x1);

	/* Spread, breadth first */
	for (i = 0; i < temp_n; i++)
	{
		x = temp_x[i], y = temp_y[i];

		/* Walls get dark, but stop darkness */
		if (!cave_floor_bold(y, x)) continue;

		/* Spread adjacent */
		cave_temp_room_aux(y + 1, x);
		cave_temp_room_aux(y - 1, x);
		cave_temp_room_aux(y, x + 1);
		cave_temp_room_aux(y, x - 1);

		/* Spread diagonal */
		cave_temp_room_aux(y + 1, x + 1);
		cave_temp_room_aux(y - 1, x - 1);
		cave_temp_room_aux(y - 1, x + 1);
		cave_temp_room_aux(y + 1, x - 1);
	}

	/* Now, darken them all at once */
	cave_temp_room_unlite();
}



/*
 * Hack -- call light around the player
 * Affect all monsters in the projection radius
 */
bool lite_area(int dam, int rad)
{
	u16b flg = PROJECT_GRID | PROJECT_KILL;

	/* Hack -- Message */
	if (!p_ptr->blind)
	{
#ifdef JP
msg_print("򤤸դʤä");
#else
		msg_print("You are surrounded by a white light.");
#endif

	}

	/* Hook into the "project()" function */
	(void)project(0, rad, py, px, dam, GF_LITE_WEAK, flg);

	/* Lite up the room */
	lite_room(py, px);

	/* Assume seen */
	return (TRUE);
}


/*
 * Hack -- call darkness around the player
 * Affect all monsters in the projection radius
 */
bool unlite_area(int dam, int rad)
{
	u16b flg = PROJECT_GRID | PROJECT_KILL;

	/* Hack -- Message */
	if (!p_ptr->blind)
	{
#ifdef JP
msg_print("ŰǤդʤä");
#else
		msg_print("Darkness surrounds you.");
#endif

	}

	/* Hook into the "project()" function */
	(void)project(0, rad, py, px, dam, GF_DARK_WEAK, flg);

	/* Lite up the room */
	unlite_room(py, px);

	/* Assume seen */
	return (TRUE);
}



/*
 * Cast a ball spell
 * Stop if we hit a monster, act as a "ball"
 * Allow "target" mode to pass over monsters
 * Affect grids, objects, and monsters
 */
bool fire_ball(int typ, int dir, int dam, int rad)
{
	int tx, ty;

	u16b flg = PROJECT_STOP | PROJECT_GRID | PROJECT_ITEM | PROJECT_KILL;

	/* Use the given direction */
	tx = px + 99 * ddx[dir];
	ty = py + 99 * ddy[dir];

	/* Hack -- Use an actual "target" */
	if ((dir == 5) && target_okay())
	{
		flg &= ~(PROJECT_STOP);
		tx = target_col;
		ty = target_row;
	}

	/* Analyze the "dir" and the "target".  Hurt items on floor. */
	return (project(0, rad, ty, tx, dam, typ, flg));
}


/*
 * Switch position with a monster.
 */
bool teleport_swap(int dir)
{
	int tx, ty;
	cave_type * c_ptr;
	monster_type * m_ptr;
	monster_race * r_ptr;

	if ((dir == 5) && target_okay())
	{
		tx = target_col;
		ty = target_row;
	}
	else
	{
		tx = px + ddx[dir];
		ty = py + ddy[dir];
	}
	c_ptr = &cave[ty][tx];

	if (!c_ptr->m_idx)
	{
#ifdef JP
msg_print("ȤϾ򴹤Ǥޤ");
#else
		msg_print("You can't trade places with that!");
#endif


		/* Failure */
		return FALSE;
	}

	m_ptr = &m_list[c_ptr->m_idx];
	r_ptr = &r_info[m_ptr->r_idx];

	if (r_ptr->flags3 & RF3_RES_TELE)
	{
#ifdef JP
msg_print("ƥݡȤ⤵줿");
#else
		msg_print("Your teleportation is blocked!");
#endif


		/* Failure */
		return FALSE;
	}

	sound(SOUND_TELEPORT);

	cave[py][px].m_idx = c_ptr->m_idx;

	/* Update the old location */
	c_ptr->m_idx = 0;

	/* Move the monster */
	m_ptr->fy = (byte)py;
	m_ptr->fx = (byte)px;

	/* Move the player */
	px = tx;
	py = ty;

	tx = m_ptr->fx;
	ty = m_ptr->fy;

	/* Update the monster (new location) */
	update_mon(cave[ty][tx].m_idx, TRUE);

	/* Redraw the old grid */
	lite_spot(ty, tx);

	/* Redraw the new grid */
	lite_spot(py, px);

	/* Check for new panel (redraw map) */
	verify_panel();

	/* Update stuff */
	p_ptr->update |= (PU_VIEW | PU_LITE | PU_FLOW);

	/* Update the monsters */
	p_ptr->update |= (PU_DISTANCE);

	/* Window stuff */
	p_ptr->window |= (PW_OVERHEAD | PW_DUNGEON);

	/* Handle stuff XXX XXX XXX */
	handle_stuff();

	/* Success */
	return TRUE;
}


/*
 * Hack -- apply a "projection()" in a direction (or at the target)
 */
bool project_hook(int typ, int dir, int dam, u16b flg)
{
	int tx, ty;

	/* Pass through the target if needed */
	flg |= (PROJECT_THRU);

	/* Use the given direction */
	tx = px + ddx[dir];
	ty = py + ddy[dir];

	/* Hack -- Use an actual "target" */
	if ((dir == 5) && target_okay())
	{
		tx = target_col;
		ty = target_row;
	}

	/* Analyze the "dir" and the "target", do NOT explode */
	return (project(0, 0, ty, tx, dam, typ, flg));
}


/*
 * Cast a bolt spell
 * Stop if we hit a monster, as a "bolt"
 * Affect monsters (not grids or objects)
 */
bool fire_bolt(int typ, int dir, int dam)
{
	u16b flg = PROJECT_STOP | PROJECT_KILL;
	return (project_hook(typ, dir, dam, flg));
}


/*
 * Cast a beam spell
 * Pass through monsters, as a "beam"
 * Affect monsters (not grids or objects)
 */
bool fire_beam(int typ, int dir, int dam)
{
	u16b flg = PROJECT_BEAM | PROJECT_KILL;
	return (project_hook(typ, dir, dam, flg));
}


/*
 * Cast a bolt spell, or rarely, a beam spell
 */
bool fire_bolt_or_beam(int prob, int typ, int dir, int dam)
{
	if (rand_int(100) < prob)
	{
		return (fire_beam(typ, dir, dam));
	}
	else
	{
		return (fire_bolt(typ, dir, dam));
	}
}


/*
 * Some of the old functions
 */
bool lite_line(int dir)
{
	u16b flg = PROJECT_BEAM | PROJECT_GRID | PROJECT_KILL;
	return (project_hook(GF_LITE_WEAK, dir, damroll(6, 8), flg));
}


bool drain_life(int dir, int dam)
{
	u16b flg = PROJECT_STOP | PROJECT_KILL;
	return (project_hook(GF_OLD_DRAIN, dir, dam, flg));
}


bool wall_to_mud(int dir)
{
	u16b flg = PROJECT_BEAM | PROJECT_GRID | PROJECT_ITEM | PROJECT_KILL;
	return (project_hook(GF_KILL_WALL, dir, 20 + randint(30), flg));
}


bool wizard_lock(int dir)
{
	u16b flg = PROJECT_BEAM | PROJECT_GRID | PROJECT_ITEM | PROJECT_KILL;
	return (project_hook(GF_JAM_DOOR, dir, 20 + randint(30), flg));
}


bool destroy_door(int dir)
{
	u16b flg = PROJECT_BEAM | PROJECT_GRID | PROJECT_ITEM;
	return (project_hook(GF_KILL_DOOR, dir, 0, flg));
}


bool disarm_trap(int dir)
{
	u16b flg = PROJECT_BEAM | PROJECT_GRID | PROJECT_ITEM;
	return (project_hook(GF_KILL_TRAP, dir, 0, flg));
}


bool heal_monster(int dir)
{
	u16b flg = PROJECT_STOP | PROJECT_KILL;
	return (project_hook(GF_OLD_HEAL, dir, damroll(4, 6), flg));
}


bool speed_monster(int dir)
{
	u16b flg = PROJECT_STOP | PROJECT_KILL;
	return (project_hook(GF_OLD_SPEED, dir, p_ptr->lev, flg));
}


bool slow_monster(int dir)
{
	u16b flg = PROJECT_STOP | PROJECT_KILL;
	return (project_hook(GF_OLD_SLOW, dir, p_ptr->lev, flg));
}


bool sleep_monster(int dir)
{
	u16b flg = PROJECT_STOP | PROJECT_KILL;
	return (project_hook(GF_OLD_SLEEP, dir, p_ptr->lev, flg));
}


bool stasis_monster(int dir)
{
	u16b flg = PROJECT_STOP | PROJECT_KILL;
	return (project_hook(GF_STASIS, dir, p_ptr->lev, flg));
}


bool confuse_monster(int dir, int plev)
{
	u16b flg = PROJECT_STOP | PROJECT_KILL;
	return (project_hook(GF_OLD_CONF, dir, plev, flg));
}


bool stun_monster(int dir, int plev)
{
	u16b flg = PROJECT_STOP | PROJECT_KILL;
	return (project_hook(GF_STUN, dir, plev, flg));
}


bool poly_monster(int dir)
{
	u16b flg = PROJECT_STOP | PROJECT_KILL;
	bool tester = (project_hook(GF_OLD_POLY, dir, p_ptr->lev, flg));

	if (tester)
		chg_virtue(V_CHANCE, 1);

	return(tester);
}


bool clone_monster(int dir)
{
	u16b flg = PROJECT_STOP | PROJECT_KILL;
	return (project_hook(GF_OLD_CLONE, dir, 0, flg));
}


bool fear_monster(int dir, int plev)
{
	u16b flg = PROJECT_STOP | PROJECT_KILL;
	return (project_hook(GF_TURN_ALL, dir, plev, flg));
}


bool death_ray(int dir, int plev)
{
	u16b flg = PROJECT_STOP | PROJECT_KILL;
	return (project_hook(GF_DEATH_RAY, dir, plev * 200, flg));
}


bool teleport_monster(int dir)
{
	u16b flg = PROJECT_BEAM | PROJECT_KILL;
	return (project_hook(GF_AWAY_ALL, dir, MAX_SIGHT * 5, flg));
}


/*
 * Hooks -- affect adjacent grids (radius 1 ball attack)
 */
bool door_creation(void)
{
	u16b flg = PROJECT_GRID | PROJECT_ITEM | PROJECT_HIDE;
	return (project(0, 1, py, px, 0, GF_MAKE_DOOR, flg));
}


bool trap_creation(void)
{
	u16b flg = PROJECT_GRID | PROJECT_ITEM | PROJECT_HIDE;
	return (project(0, 1, py, px, 0, GF_MAKE_TRAP, flg));
}


bool glyph_creation(void)
{
	u16b flg = PROJECT_GRID | PROJECT_ITEM;
	return (project(0, 1, py, px, 0, GF_MAKE_GLYPH, flg));
}


bool wall_stone(void)
{
	u16b flg = PROJECT_GRID | PROJECT_ITEM | PROJECT_HIDE;

	bool dummy = (project(0, 1, py, px, 0, GF_STONE_WALL, flg));

	/* Update stuff */
	p_ptr->update |= (PU_VIEW | PU_LITE | PU_FLOW);

	/* Update the monsters */
	p_ptr->update |= (PU_MONSTERS);

	/* Redraw map */
	p_ptr->redraw |= (PR_MAP);

	/* Window stuff */
	p_ptr->window |= (PW_OVERHEAD | PW_DUNGEON);

	return dummy;
}


bool destroy_doors_touch(void)
{
	u16b flg = PROJECT_GRID | PROJECT_ITEM | PROJECT_HIDE;
	return (project(0, 1, py, px, 0, GF_KILL_DOOR, flg));
}


bool sleep_monsters_touch(void)
{
	u16b flg = PROJECT_KILL | PROJECT_HIDE;
	return (project(0, 1, py, px, p_ptr->lev, GF_OLD_SLEEP, flg));
}


void call_chaos(void)
{
	int Chaos_type, dummy, dir;
	int plev = p_ptr->lev;
	bool line_chaos = FALSE;

	int hurt_types[30] =
	{
		GF_ELEC,      GF_POIS,    GF_ACID,    GF_COLD,
		GF_FIRE,      GF_MISSILE, GF_ARROW,   GF_PLASMA,
		GF_HOLY_FIRE, GF_WATER,   GF_LITE,    GF_DARK,
		GF_FORCE,     GF_INERTIA, GF_MANA,    GF_METEOR,
		GF_ICE,       GF_CHAOS,   GF_NETHER,  GF_DISENCHANT,
		GF_SHARDS,    GF_SOUND,   GF_NEXUS,   GF_CONFUSION,
		GF_TIME,      GF_GRAVITY, GF_ROCKET,  GF_NUKE,
		GF_HELL_FIRE, GF_DISINTEGRATE
	};

	Chaos_type = hurt_types[rand_int(30)];
	if (randint(4) == 1) line_chaos = TRUE;

	if (randint(6) == 1)
	{
		for (dummy = 1; dummy < 10; dummy++)
		{
			if (dummy - 5)
			{
				if (line_chaos)
					fire_beam(Chaos_type, dummy, 75);
				else
					fire_ball(Chaos_type, dummy, 75, 2);
			}
		}
	}
	else if (randint(3) == 1)
	{
		fire_ball(Chaos_type, 0, 300, 8);
	}
	else
	{
		if (!get_aim_dir(&dir)) return;
		if (line_chaos)
			fire_beam(Chaos_type, dir, 150);
		else
			fire_ball(Chaos_type, dir, 150, 3 + (plev / 35));
	}
}


/*
 * Activate the evil Topi Ylinen curse
 * rr9: Stop the nasty things when a Cyberdemon is summoned
 * or the player gets paralyzed.
 */
bool activate_ty_curse(bool stop_ty, int *count)
{
	int stat = 0;

	u16b flg = (PROJECT_GRID | PROJECT_ITEM | PROJECT_KILL | PROJECT_JUMP);

	do
	{
		switch (randint(34))
		{
			case 28: case 29:
			{
				if (!(*count))
				{
#ifdef JP
msg_print("̤ɤ줿...");
#else
					msg_print("The ground trembles...");
#endif

					earthquake(py, px, 5 + rand_int(10));
					if (randint(6) != 1) break;
				}
			}
			case 30: case 31:
			{
				if (!(*count))
				{
#ifdef JP
msg_print("Ϥμؤ⤬");
#else
					msg_print("A portal opens to a plane of raw mana!");
#endif

					destroy_area(py, px, 20, TRUE);
					project(1, 3, py, px, damroll(10, 5), GF_MANA, flg);
					if (randint(6) != 1) break;
				}
			}
			case 32: case 33:
			{
				if (!(*count))
				{
#ifdef JP
msg_print("Ϥζ֤Ĥ");
#else
					msg_print("Space warps about you!");
#endif

					teleport_player(damroll(10, 10));
					if (rand_int(13)) (*count) += activate_hi_summon();
					if (randint(6) != 1) break;
				}
			}
			case 34:
			{
#ifdef JP
msg_print("ͥ륮Τͤ򴶤");
#else
				msg_print("You feel a surge of energy!");
#endif

				wall_breaker();
				if (!rand_int(7))
				{
					project(1, 7, py, px, 50, GF_KILL_WALL, flg);
				}
				if (randint(6) != 1) break;
			}
			case 1: case 2: case 3: case 16: case 17:
			{
				aggravate_monsters(0);
				if (randint(6) != 1) break;
			}
			case 4: case 5: case 6:
			{
				(*count) += activate_hi_summon();
				if (randint(6) != 1) break;
			}
			case 7: case 8: case 9: case 18:
			{
				(*count) += summon_specific(0, py, px, dun_level, 0, TRUE, FALSE, FALSE);
				if (randint(6) != 1) break;
			}
			case 10: case 11: case 12:
			{
#ifdef JP
msg_print("̿ϤΤۤ줿롪");
#else
				msg_print("You feel your life draining away...");
#endif

				lose_exp(p_ptr->exp / 16);
				if (randint(6) != 1) break;
			}
			case 13: case 14: case 15: case 19: case 20:
			{
				if (stop_ty || (p_ptr->free_act && (randint(100) < p_ptr->skill_sav)))
				{
					/* Do nothing */ ;
				}
				else
				{
#ifdef JP
msg_print("Ħˤʤäʬ");
#else
					msg_print("You feel like a statue!");
#endif

					if (p_ptr->free_act)
					{
						set_paralyzed(p_ptr->paralyzed + 1);
					}
					else
					{
						set_paralyzed(p_ptr->paralyzed + randint(13));
					}
					stop_ty = TRUE;
				}
				if (randint(6) != 1) break;
			}
			case 21: case 22: case 23:
			{
				(void)do_dec_stat(rand_int(6));
				if (randint(6) != 1) break;
			}
			case 24:
			{
#ifdef JP
msg_print("ۤïǲƤ롩");
#else
				msg_print("Huh? Who am I? What am I doing here?");
#endif

				lose_all_info();
				if (randint(6) != 1) break;
			}
			case 25:
			{
				/*
				 * Only summon Cyberdemons deep in the dungeon.
				 */
				if ((dun_level > 65) && !stop_ty)
				{
					(*count) += summon_cyber(-1, py, px);
					stop_ty = TRUE;
					break;
				}
				if (randint(6) != 1) break;
			}
			default:
			{
				while (stat < 6)
				{
					do
					{
						(void)do_dec_stat(stat);
					}
					while (randint(2) == 1);

					stat++;
				}
			}
		}
	}
	while ((randint(3) == 1) && !stop_ty);

	return stop_ty;
}


int activate_hi_summon(void)
{
	int i;
	int count = 0;

	for (i = 0; i < (randint(9) + (dun_level / 40)); i++)
	{
		switch (randint(26) + (dun_level / 20))
		{
			case 1: case 2:
				count += summon_specific(0, py, px, dun_level, SUMMON_ANT, TRUE, FALSE, FALSE);
				break;
			case 3: case 4:
				count += summon_specific(0, py, px, dun_level, SUMMON_SPIDER, TRUE, FALSE, FALSE);
				break;
			case 5: case 6:
				count += summon_specific(0, py, px, dun_level, SUMMON_HOUND, TRUE, FALSE, FALSE);
				break;
			case 7: case 8:
				count += summon_specific(0, py, px, dun_level, SUMMON_HYDRA, TRUE, FALSE, FALSE);
				break;
			case 9: case 10:
				count += summon_specific(0, py, px, dun_level, SUMMON_ANGEL, TRUE, FALSE, FALSE);
				break;
			case 11: case 12:
				count += summon_specific(0, py, px, dun_level, SUMMON_UNDEAD, TRUE, FALSE, FALSE);
				break;
			case 13: case 14:
				count += summon_specific(0, py, px, dun_level, SUMMON_DRAGON, TRUE, FALSE, FALSE);
				break;
			case 15: case 16:
				count += summon_specific(0, py, px, dun_level, SUMMON_DEMON, TRUE, FALSE, FALSE);
				break;
			case 17:
				count += summon_specific(0, py, px, dun_level, SUMMON_AMBERITES, TRUE, FALSE, FALSE);
				break;
			case 18: case 19:
				count += summon_specific(0, py, px, dun_level, SUMMON_UNIQUE, TRUE, FALSE, FALSE);
				break;
			case 20: case 21:
				count += summon_specific(0, py, px, dun_level, SUMMON_HI_UNDEAD, TRUE, FALSE, FALSE);
				break;
			case 22: case 23:
				count += summon_specific(0, py, px, dun_level, SUMMON_HI_DRAGON, TRUE, FALSE, FALSE);
				break;
			case 24: case 25:
				count += summon_specific(0, py, px, 100, SUMMON_CYBER, TRUE, FALSE, FALSE);
				break;
			default:
				count += summon_specific(0, py, px, (((dun_level * 3) / 2) + 5), 0, TRUE, FALSE, FALSE);
		}
	}

	return count;
}


/* ToDo: check */
int summon_cyber(int who, int y, int x)
{
	int i;
	int max_cyber = (dun_level / 50) + randint(6);
	int count = 0;

	bool friendly = FALSE;
	bool pet = FALSE;

	/* Summoned by a monster */
	if (who > 0)
	{
		monster_type *m_ptr = &m_list[who];
		friendly = is_friendly(m_ptr);
		pet = is_pet(m_ptr);
	}

	for (i = 0; i < max_cyber; i++)
	{
		count += summon_specific(who, y, x, 100, SUMMON_CYBER, FALSE, friendly, pet);
	}

	return count;
}


void wall_breaker(void)
{
	int i;
	int y, x;
	int attempts = 1000;

	if (randint(80 + p_ptr->lev) < 70)
	{
		while (attempts--)
		{
			scatter(&y, &x, py, px, 4, 0);

			if ((y != py) || (x != px)) break;
		}

		project(0, 0, y, x, 20 + randint(30), GF_KILL_WALL,
				  (PROJECT_BEAM | PROJECT_THRU | PROJECT_GRID | PROJECT_ITEM | PROJECT_KILL));
	}
	else if (randint(100) > 30)
	{
		earthquake(py, px, 1);
	}
	else
	{
		int num = damroll(5, 3);

		for (i = 0; i < num; i++)
		{
			while (1)
			{
				scatter(&y, &x, py, px, 4, 0);

				if ((y != py) || (x != px)) break;
			}

			project(0, 0, y, x, 20 + randint(30), GF_KILL_WALL,
					  (PROJECT_BEAM | PROJECT_THRU | PROJECT_GRID | PROJECT_ITEM | PROJECT_KILL));
		}
	}
}


/*
 * Detect all "nonliving", "undead" or "demonic" monsters on current panel
 */
bool detect_monsters_nonliving(void)
{
	int     i, y, x;
	bool    flag = FALSE;

	/* Scan monsters */
	for (i = 1; i < m_max; i++)
	{
		monster_type *m_ptr = &m_list[i];
		monster_race *r_ptr = &r_info[m_ptr->r_idx];

		/* Skip dead monsters */
		if (!m_ptr->r_idx) continue;

		/* Location */
		y = m_ptr->fy;
		x = m_ptr->fx;

		/* Only detect nearby monsters */
		if (!panel_contains(y, x)) continue;

		/* Detect non-living monsters */
		if (!monster_living(r_ptr))
		{
			/* Update monster recall window */
			if (p_ptr->monster_race_idx == m_ptr->r_idx)
			{
				/* Window stuff */
				p_ptr->window |= (PW_MONSTER);
			}

			/* Repair visibility later */
			repair_monsters = TRUE;

			/* Hack -- Detect monster */
			m_ptr->mflag |= (MFLAG_MARK | MFLAG_SHOW);

			/* Update the monster */
			update_mon(i, FALSE);

			/* Detect */
			flag = TRUE;
		}
	}

	/* Describe */
	if (flag)
	{
		/* Describe result */
#ifdef JP
msg_print("Ǥʤ󥹥¸ߤ򴶤");
#else
		msg_print("You sense the presence of unnatural beings!");
#endif

	}

	/* Result */
	return (flag);
}


/*
 * Confuse monsters
 */
bool confuse_monsters(int dam)
{
	return (project_hack(GF_OLD_CONF, dam));
}


/*
 * Charm monsters
 */
bool charm_monsters(int dam)
{
	return (project_hack(GF_CHARM, dam));
}


/*
 * Charm animals
 */
bool charm_animals(int dam)
{
	return (project_hack(GF_CONTROL_ANIMAL, dam));
}


/*
 * Stun monsters
 */
bool stun_monsters(int dam)
{
	return (project_hack(GF_STUN, dam));
}


/*
 * Stasis monsters
 */
bool stasis_monsters(int dam)
{
	return (project_hack(GF_STASIS, dam));
}


/*
 * Mindblast monsters
 */
bool mindblast_monsters(int dam)
{
	return (project_hack(GF_PSI, dam));
}


/*
 * Banish all monsters
 */
bool banish_monsters(int dist)
{
	return (project_hack(GF_AWAY_ALL, dist));
}


/*
 * Turn evil
 */
bool turn_evil(int dam)
{
	return (project_hack(GF_TURN_EVIL, dam));
}


/*
 * Turn everyone
 */
bool turn_monsters(int dam)
{
	return (project_hack(GF_TURN_ALL, dam));
}


/*
 * Death-ray all monsters (note: OBSCENELY powerful)
 */
bool deathray_monsters(void)
{
	return (project_hack(GF_DEATH_RAY, p_ptr->lev * 200));
}


bool charm_monster(int dir, int plev)
{
	u16b flg = PROJECT_STOP | PROJECT_KILL;
	return (project_hook(GF_CHARM, dir, plev, flg));
}


bool control_one_undead(int dir, int plev)
{
	u16b flg = PROJECT_STOP | PROJECT_KILL;
	return (project_hook(GF_CONTROL_UNDEAD, dir, plev, flg));
}


bool charm_animal(int dir, int plev)
{
	u16b flg = PROJECT_STOP | PROJECT_KILL;
	return (project_hook(GF_CONTROL_ANIMAL, dir, plev, flg));
}


/*
 * Musou Attack Spell
 */
/* Nanka(ͷ) */
bool charge_monster(void)
{
	int             y, x;
	int             dir;

	if (!get_rep_dir(&dir)) return FALSE;

	if (dir == 5) return FALSE;
	y = py + ddy[dir];
	x = px + ddx[dir];

	if (!cave[y][x].m_idx)
	{
		msg_print("ˤϥ󥹥Ϥޤ");
		return FALSE;
	}

	py_attack(y, x);

	if (!player_can_enter(cave[y][x].feat) || is_trap(cave[y][x].feat))
		return TRUE;

	y += ddy[dir];
	x += ddx[dir];

	if (player_can_enter(cave[y][x].feat) && !is_trap(cave[y][x].feat) && !cave[y][x].m_idx)
	{
		int oy, ox;

		msg_print(NULL);

		/* Save the old location */
		oy = py;
		ox = px;

		/* Move the player */
		py = y;
		px = x;

		/* Forget the flow */
		forget_flow();

		/* Redraw the old spot */
		lite_spot(oy, ox);

		/* Redraw the new spot */
		lite_spot(py, px);

		/* Check for new panel (redraw map) */
		verify_panel();

		/* Update stuff */
		p_ptr->update |= (PU_VIEW | PU_LITE | PU_FLOW);

		/* Update the monsters */
		p_ptr->update |= (PU_DISTANCE);

		/* Window stuff */
		p_ptr->window |= (PW_OVERHEAD | PW_DUNGEON);

		/* Handle stuff XXX XXX XXX */
		handle_stuff();
	}

	return TRUE;
}
