/* File: cmd5.c */

/* Purpose: Spell/Prayer commands */

/*
 * Copyright (c) 1989 James E. Wilson, Robert A. Koeneke
 *
 * This software may be copied and distributed for educational, research, and
 * not for profit purposes provided that this copyright and statement are
 * included in all such copies.
 */

#include "angband.h"

#define tval2realm(A) ((A) - TV_LIFE_BOOK + 1)

static char *spell_tips[MAX_REALM][32] =
{
#ifdef JP
	{
		"᤯μٰʥ󥹥Τ롣",
		"Ϥ򾯤롣",
		"֡̿ΨAC˥ܡʥ롣",
		"ݤ",
		"Ȥ餷ƤϰϤΤʵפ뤯롣",
		"᤯Ƥ櫤ȳʤΤ롣",
		"Ϥٲ롣",
		"ʢˤ롣",
		"Ǥ",
		"ġ󥹥˸̤롣",

		"ƥˤä夤롣",
		"Ϥ˲ۯ۰֤롣",
		"ʤϤġٰʥ󥹥Ф礭ʥ᡼Ϳ뤬ɤʥ󥹥ˤϸ̤ʤ",
		"դϷΤ᤯櫡⡢ʡƤθ󥹥Τ롣",
		"֡ҡʬˤʤ롣",
		"󥹥1Τ̥λ롣񹳤̵",
		"ٰʥ󥹥ιɤХꥢĥ롣",
		"ˤƶϤʲʸǡۯ۰֤롣",
		"볦Ƥμٰʥ󥹥˥᡼Ϳ롣",
		"ʬΤ뾲ξˡ󥹥̤ȴ꾤줿ꤹ뤳ȤǤʤʤ롼",

		"ƥˤäϤʼ롣",
		"֡ŷ⡢ꡢ䵤ǤФ롣ˤѤ롣",
		"볦Ƥμٰʥ󥹥ƥݡȤ롣񹳤̵",
		"볦ƤΥ󥹥̥λ롣񹳤̵",
		"볦μٰ¸ߤ礭ʥ᡼ͿϤǡݡۯ۰֡롣",
		"ʡ롣ϤʼΤäˤ񹳤롣ƥեȤʡ褦ȤƼԤ롣",
		"٤ƤΥơȷиͤ롣",
		"ʬ濴Ȥεȯ롣ˡγΤʵפ˾Ȥ餷󥸥⤹٤ƤΥƥΤ롣",
		"ƥλǽϤΤ롣",
		"Ƕμˡǡۯ۰֤롣",
		"1ΤŷȤ򾤴롣",
		"ܤ󥹥ʤ᡼Ϳ볦Υ󥹥˥᡼®ۯ۰𡢶ݡ̲Ϳ롣Ϥݤֶβ®롣",
	},
	{
		"夤ˡġ",
		"᤯Ƥθ󥹥Τ롣",
		"ΥΥƥݡȤ򤹤롣",
		"᤯Ƥ櫤Τ롣",
		"Ȥ餷ƤϰϤΤʵפ뤯롣",
		"ľƤ櫤˲롣",
		"ΥΥƥݡȤ򤹤롣",
		"ʢˤʤ롣",
		"ˡεġ",
		"ϾˤȤϥ󥸥κǿء󥸥ˤȤϾؤȰư롣",

		"ɤϤƾˤ롣",
		"/ˡνŶ䤹ŶΥåɤνŶ֤򸺤餹",
		"դϷΤ롣",
		"ƥ1ļ̤롣٥뤬⤤ȥƥǽϤΤ뤳ȤǤ롣",
		"֡ƥѥǽϤ롣",
		"ϤΥӡġ",
		"֡®롣",
		"󥹥1ΤƥݡȤ롣񹳤̵",
		"åȤȯͤ롣",
		"ꤷʸΥ󥹥򸽺ߤγä롣񹳤̵",

		"󥹥λĤϡϡԡɤΤ롣",
		"ֻ˾夫γ˥ƥݡȤ롣",
		"θġ",
		"᤯ƤΥ󥹥櫡⡢ʡƥƥΤ롣",
		"դΥƥࡢ󥹥Ϸ˲롣",
		"γΤʵפ˾Ȥ餷󥸥⤹٤ƤΥƥΤ롣ˡ֥ƥѥǽϤ롣",
		"1ξ롣",
		"ûΥλꤷ˥ƥݡȤ롣",
		"1Τθɥ饴򾤴롣"
		"ʬμϤˤ󥹥򸽺ߤγä롣񹳤̵",
		"˶ϤǵʽϤεġ",
		"֡ɤ̤ȴ뤳ȤǤ᡼ڸͩΤξ֤ѿȤ롣"
	},
	{
		"֡Ϥ롣",
		"3Фƹ⤹롣",
		"֡䵤ؤ롣ˤѤ롣",
		"֡ؤ롣ˤѤ롣",
		"֡ҡʬˤʤ롣",
		"֡ŷؤ롣ˤѤ롣",
		"֡ؤ롣ˤѤ롣",
		"֡ƩʤΤ褦ˤʤ롣",
		"⤷塢ȿ¦ȴ롣",
		"֡AC徺롣",

		"βݤ롣",
		"󥹥1Τ𤵤롣񹳤̵",
		"֡Ǥؤ롣ˤѤ롣",
		"ݤ֡ҡʬˤʤꡢ䵤ŷؤ䵤ŷΥ롣ˤѤ롣",
		"ڤ̣Τ빶򷫤Ф",
		"֡®롣",
		"Фƹ⤹롣",
		"ƥŷ⡦бꡦ䵤ǽĤʤ褦ù롣",
		"ߤΥӡġ",
		"֡ˡɸϤAC夬ꡢܤȿǽϡΤ餺ͷ롣",

		"ɶˤ줿Ϥ˲롣",
		"ϤΥ󥸥ɤ餷ɤȾѤ롣",
		"֡ŷ⡢ꡢ䵤ǤФ롣ˤѤ롣",
		"βݤ®롣",
		"󥹥ۯ۰Ȥݤ빶򤹤롣",
		"̿Ψȥ᡼򶯲롣",
		"ɸ潤򶯲롣",
		"̵ŨΥХꥢڤԤ",
		"12ٹԤ",
		"ߤΥ֥쥹ƱιԤ",
		"Ǽ٤°Ĥ롣",
		"֡դACˡɸǽϤ徺롣"
	},
#else
	{
		"yet.",
		"yet.",
		"yet.",
		"yet.",
		"yet.",
		"yet.",
		"yet.",
		"yet.",
		"yet.",
		"yet.",

		"yet.",
		"yet.",
		"yet.",
		"yet.",
		"yet.",
		"yet.",
		"yet.",
		"yet.",
		"yet.",
		"yet.",

		"yet.",
		"yet.",
		"yet.",
		"yet.",
		"yet.",
		"yet.",
		"yet.",
		"yet.",
		"yet.",
		"yet.",
		"yet.",
		"yet.",
	},
	{
		"yet.",
		"yet.",
		"yet.",
		"yet.",
		"yet.",
		"yet.",
		"yet.",
		"yet.",
		"yet.",
		"yet.",

		"yet.",
		"yet.",
		"yet.",
		"yet.",
		"yet.",
		"yet.",
		"yet.",
		"yet.",
		"yet.",
		"yet.",

		"yet.",
		"yet.",
		"yet.",
		"yet.",
		"yet.",
		"yet.",
		"yet.",
		"yet.",
		"yet.",
		"yet.",
		"yet.",
		"yet.",
	},
	{
		"yet.",
		"yet.",
		"yet.",
		"yet.",
		"yet.",
		"yet.",
		"yet.",
		"yet.",
		"yet.",
		"yet.",

		"yet.",
		"yet.",
		"yet.",
		"yet.",
		"yet.",
		"yet.",
		"yet.",
		"yet.",
		"yet.",
		"yet.",

		"yet.",
		"yet.",
		"yet.",
		"yet.",
		"yet.",
		"yet.",
		"yet.",
		"yet.",
		"yet.",
		"yet.",
		"yet.",
		"yet.",
	},
#endif
};

/*
 * Allow user to choose a spell/prayer from the given book.
 *
 * If a valid spell is chosen, saves it in '*sn' and returns TRUE
 * If the user hits escape, returns FALSE, and set '*sn' to -1
 * If there are no legal choices, returns FALSE, and sets '*sn' to -2
 *
 * The "prompt" should be "cast", "recite", or "study"
 * The "known" should be TRUE for cast/pray, FALSE for study
 */

bool select_spellbook = FALSE;

static int get_spell(int *sn, cptr prompt, int sval, bool known, int use_realm)
{
	int         i;
	int         spell = -1;
	int         num = 0;
	int         ask;
	byte        spells[32];
	bool        flag, redraw, okay;
	char        choice;
	magic_type  *s_ptr;
	char        out_val[160];
#ifdef JP
	cptr        p = ((mp_ptr->spell_book == TV_LIFE_BOOK) ? "" : "ʸ");
	unsigned char jverb_buf[128];
#else
	cptr        p = ((mp_ptr->spell_book == TV_LIFE_BOOK) ? "prayer" : "spell");
#endif


#ifdef ALLOW_REPEAT /* TNB */

	/* Get the spell, if available */
	if (repeat_pull(sn))
	{
		/* Verify the spell */
		if (spell_okay(*sn, known, use_realm - 1))
		{
			/* Success */
			return (TRUE);
		}
	}

#endif /* ALLOW_REPEAT -- TNB */

	/* Extract spells */
	for (spell = 0; spell < 32; spell++)
	{
		/* Check for this spell */
		if ((fake_spell_flags[sval] & (1L << spell)))
		{
			/* Collect this spell */
			spells[num++] = spell;
		}
	}

	/* Assume no usable spells */
	okay = FALSE;

	/* Assume no spells available */
	(*sn) = -2;

	/* Check for "okay" spells */
	for (i = 0; i < num; i++)
	{
		/* Look for "okay" spells */
		if (spell_okay(spells[i], known, use_realm - 1)) okay = TRUE;
	}

	/* No "okay" spells */
	if (!okay) return (FALSE);

	/* Assume cancelled */
	*sn = (-1);

	/* Nothing chosen yet */
	flag = FALSE;

	/* No redraw yet */
	redraw = FALSE;

	/* Show choices */
	if (show_choices)
	{
		/* Update */
		p_ptr->window |= (PW_SPELL);

		/* Window stuff */
		window_stuff();
	}


	/* Build a prompt (accept all spells) */
#ifdef JP
	jverb( prompt, jverb_buf, JVERB_AND );
	(void) strnfmt(out_val, 78, "(%^s:%c-%c, '*'ǰ, ESC) ɤ%s%^sޤ? ",
	        p, I2A(0), I2A(num - 1), p, jverb_buf );
#else
	(void)strnfmt(out_val, 78, "(%^ss %c-%c, *=List, ESC=exit) %^s which %s? ",
		p, I2A(0), I2A(num - 1), prompt, p);
#endif


	/* Get a spell from the user */
#ifdef JP
        choice = always_show_list ? ESCAPE:1;
        while (!flag)
        {
          if( choice==ESCAPE ) choice = ' '; 
          else if( !get_com(out_val, &choice) )break; 
#else
	while (!flag && get_com(out_val, &choice))
	{
#endif

		/* Request redraw */
		if ((choice == ' ') || (choice == '*') || (choice == '?'))
		{
			/* Show the list */
			if (!redraw)
			{
				/* Show list */
				redraw = TRUE;

				/* Save the screen */
				screen_save();

				/* Display a list of spells */
				print_spells(spells, num, 1, 20, use_realm - 1);
			}

			/* Hide the list */
			else
			{
				/* Hide list */
				redraw = FALSE;

				/* Restore the screen */
				screen_load();
			}

			/* Redo asking */
			continue;
		}


		/* Note verify */
		ask = (isupper(choice));

		/* Lowercase */
		if (ask) choice = tolower(choice);

		/* Extract request */
		i = (islower(choice) ? A2I(choice) : -1);

		/* Totally Illegal */
		if ((i < 0) || (i >= num))
		{
			bell();
			continue;
		}

		/* Save the spell index */
		spell = spells[i];

		/* Require "okay" spells */
		if (!spell_okay(spell, known, use_realm - 1))
		{
			bell();
#ifdef JP
                        msg_format("%s%sȤϤǤޤ", p, prompt);
#else
			msg_format("You may not %s that %s.", prompt, p);
#endif

			continue;
		}

		/* Verify it */
		if (ask)
		{
			char tmp_val[160];

			/* Access the spell */
			s_ptr = &mp_ptr->info[use_realm - 1][spell % 32];

			/* Prompt */
#ifdef JP
	jverb( prompt, jverb_buf, JVERB_AND);
                        /* ڤؤǽб */
                        (void) strnfmt(tmp_val, 78, "%s(MP%d, Ψ%d%%)%sޤ? ",
				       spell_names[use_realm -1][spell % 32],
                                s_ptr->smana, spell_chance(spell, use_realm -1),jverb_buf);
#else
			(void)strnfmt(tmp_val, 78, "%^s %s (%d mana, %d%% fail)? ",
				prompt, spell_names[use_realm - 1][spell % 32],
				s_ptr->smana, spell_chance(spell, use_realm - 1));
#endif


			/* Belay that order */
			if (!get_check(tmp_val)) continue;
		}

		/* Stop the loop */
		flag = TRUE;
	}


	/* Restore the screen */
	if (redraw) screen_load();


	/* Show choices */
	if (show_choices)
	{
		/* Update */
		p_ptr->window |= (PW_SPELL);

		/* Window stuff */
		window_stuff();
	}


	/* Abort if needed */
	if (!flag) return (FALSE);

	/* Save the choice */
	(*sn) = spell;

#ifdef ALLOW_REPEAT /* TNB */

	repeat_push(*sn);

#endif /* ALLOW_REPEAT -- TNB */

	/* Success */
	return (TRUE);
}


/*
 * Peruse the spells/prayers in a book
 *
 * Note that *all* spells in the book are listed
 *
 * Note that browsing is allowed while confused or blind,
 * and in the dark, primarily to allow browsing in stores.
 */
void do_cmd_browse(void)
{
	int		item, sval, use_realm = 0, j, line;
	int		spell = -1;
	int		num = 0;

	byte		spells[32];
	char		temp[62 * 4];

	object_type	*o_ptr;
	magic_type	*s_ptr;

	cptr q, s;

	/* Warriors are illiterate */
	if (!(p_ptr->realm1 || p_ptr->realm2))
	{
#ifdef JP
msg_print("ܤɤळȤǤʤ");
#else
		msg_print("You cannot read books!");
#endif

		return;
	}

	/* Restrict choices to "useful" books */
	item_tester_tval = mp_ptr->spell_book;

	/* Get an item */
#ifdef JP
q = "ɤܤɤߤޤ? ";
#else
	q = "Browse which book? ";
#endif

#ifdef JP
s = "ɤܤʤ";
#else
	s = "You have no books that you can read.";
#endif

	select_spellbook = TRUE;
	if (!get_item(&item, q, s, (USE_INVEN | USE_FLOOR)))
	{
		select_spellbook = FALSE;
		return;
	}
	select_spellbook = FALSE;

	/* Get the item (in the pack) */
	if (item >= 0)
	{
		o_ptr = &inventory[item];
	}

	/* Get the item (on the floor) */
	else
	{
		o_ptr = &o_list[0 - item];
	}

	/* Access the item's sval */
	sval = o_ptr->sval;

	use_realm = tval2realm(o_ptr->tval);

	/* Track the object kind */
	object_kind_track(o_ptr->k_idx);

	/* Hack -- Handle stuff */
	handle_stuff();


	/* Extract spells */
	for (spell = 0; spell < 32; spell++)
	{
		/* Check for this spell */
		if ((fake_spell_flags[sval] & (1L << spell)))
		{
			/* Collect this spell */
			spells[num++] = spell;
		}
	}

	/* Save the screen */
	screen_save();

	/* Clear the top line */
	prt("", 0, 0);

	/* Keep browsing spells.  Exit browsing on cancel. */
	while(TRUE)
	{
		/* Ask for a spell, allow cancel */
#ifdef JP
		if (!get_spell(&spell, "ɤ", o_ptr->sval, TRUE, use_realm))
#else
		if (!get_spell(&spell, "browse", o_ptr->sval, TRUE, use_realm))
#endif
		{
			/* If cancelled, leave immediately. */
			if (spell == -1) break;

			/* Display a list of spells */
			print_spells(spells, num, 1, 15, use_realm - 1);

			/* Notify that there's nothing to see, and wait. */
#ifdef JP
			prt("ɤʸʤ", 0, 0);
#else
			prt("No spells to browse.", 0, 0);
#endif
			(void)inkey();

			/* Restore the screen */
			screen_load();

			return;
		}

		/* Clear lines, position cursor  (really should use strlen here) */
		Term_erase(14, 18, 255);
		Term_erase(14, 17, 255);
		Term_erase(14, 16, 255);
		Term_erase(14, 15, 255);

		s_ptr = &mp_ptr->info[use_realm - 1][spell];

		roff_to_buf(spell_tips[use_realm - 1][spell], 62, temp);
		for(j = 0, line = 15; temp[j]; j += (1 + strlen(&temp[j])))
		{
			prt(&temp[j], line, 15);
			line++;
		}
	}

	/* Restore the screen */
	screen_load();
}




/*
 * Study a book to gain a new spell/prayer
 */
void do_cmd_study(void)
{
	int	i, item, sval;
	int	increment = 0;

	/* Spells of realm2 will have an increment of +32 */
	int	spell = -1;

#ifdef JP
cptr p = ((mp_ptr->spell_book == TV_LIFE_BOOK) ? "" : "ʸ");
#else
	cptr p = ((mp_ptr->spell_book == TV_SORCERY_BOOK) ? "spell" : "prayer");
#endif


	object_type *o_ptr;

	cptr q, s;

	if (!p_ptr->realm1)
	{
#ifdef JP
msg_print("ܤɤळȤǤʤ");
#else
		msg_print("You cannot read books!");
#endif

		return;
	}

	if (p_ptr->blind || no_lite())
	{
#ifdef JP
msg_print("ܤʤ");
#else
		msg_print("You cannot see!");
#endif

		return;
	}

	if (p_ptr->confused)
	{
#ifdef JP
msg_print("𤷤Ƥɤʤ");
#else
		msg_print("You are too confused!");
#endif

		return;
	}

	if (!(p_ptr->new_spells))
	{
#ifdef JP
msg_format("%sФ뤳ȤϤǤʤ", p);
#else
		msg_format("You cannot learn any new %ss!", p);
#endif

		return;
	}

#ifdef JP
                        if( p_ptr->new_spells < 10 ){
                                msg_format(" %d Ĥ%sؤ٤롣", p_ptr->new_spells, p);
                        }else{
                                msg_format(" %d Ĥ%sؤ٤롣", p_ptr->new_spells, p);
                        }
#else
	msg_format("You can learn %d new %s%s.", p_ptr->new_spells, p,
		(p_ptr->new_spells == 1?"":"s"));
#endif

	msg_print(NULL);


	/* Restrict choices to "useful" books */
	item_tester_tval = mp_ptr->spell_book;

	/* Get an item */
#ifdef JP
q = "ɤܤؤӤޤ? ";
#else
	q = "Study which book? ";
#endif

#ifdef JP
s = "ɤܤʤ";
#else
	s = "You have no books that you can read.";
#endif

	select_spellbook = TRUE;
	if (!get_item(&item, q, s, (USE_INVEN | USE_FLOOR))) return;
	select_spellbook = FALSE;

	/* Get the item (in the pack) */
	if (item >= 0)
	{
		o_ptr = &inventory[item];
	}

	/* Get the item (on the floor) */
	else
	{
		o_ptr = &o_list[0 - item];
	}

	/* Access the item's sval */
	sval = o_ptr->sval;

#if 0
	if (o_ptr->tval == REALM2_BOOK) increment = 32;
#endif

	/* Track the object kind */
	object_kind_track(o_ptr->k_idx);

	/* Hack -- Handle stuff */
	handle_stuff();

	/* Mage -- Learn a selected spell */
	if (mp_ptr->spell_book != TV_LIFE_BOOK)
	{
		/* Ask for a spell, allow cancel */
#ifdef JP
		if (!get_spell(&spell, "ؤ", sval, FALSE, tval2realm(o_ptr->tval))
		    && (spell == -1)) return;
#else
		if (!get_spell(&spell, "study", sval, FALSE, tval2realm(o_ptr->tval))
		    && (spell == -1)) return;
#endif
	}

	/* Priest -- Learn a random prayer */
	else
	{
		int k = 0;

		int gift = -1;

		/* Extract spells */
		for (spell = 0; spell < 32; spell++)
		{
			/* Check spells in the book */
			if ((fake_spell_flags[sval] & (1L << spell)))
			{
				/* Skip non "okay" prayers */
				if (!spell_okay(spell, FALSE,
					(increment ? p_ptr->realm2 - 1 : p_ptr->realm1 - 1))) continue;

				/* Hack -- Prepare the randomizer */
				k++;

				/* Hack -- Apply the randomizer */
				if (rand_int(k) == 0) gift = spell;
			}
		}

		/* Accept gift */
		spell = gift;
	}

	/* Nothing to study */
	if (spell < 0)
	{
		/* Message */
#ifdef JP
msg_format("ܤˤϳؤ֤٤%sʤ", p);
#else
		msg_format("You cannot learn any %ss in that book.", p);
#endif


		/* Abort */
		return;
	}


	/* Take a turn */
	energy_use = 100;

	if (increment) spell += increment;

	/* Learn the spell */
	if (spell < 32)
	{
		spell_learned1 |= (1L << spell);
	}
	else
	{
		spell_learned2 |= (1L << (spell - 32));
	}

	/* Find the next open entry in "spell_order[]" */
	for (i = 0; i < 64; i++)
	{
		/* Stop at the first empty space */
		if (spell_order[i] == 99) break;
	}

	/* Add the spell to the known list */
	spell_order[i++] = spell;

	/* Mention the result */
#ifdef JP
        /* ڤؤǽб */
                msg_format("%s%sؤ",
			    spell_names
		[(increment ? p_ptr->realm2 - 1 : p_ptr->realm1 - 1)][spell % 32] ,p);
#else
	msg_format("You have learned the %s of %s.",
		p, spell_names
		[(increment ? p_ptr->realm2 - 1 : p_ptr->realm1 - 1)][spell % 32]);
#endif


	if (mp_ptr->spell_book == TV_LIFE_BOOK)
		chg_virtue(V_FAITH, 1);
	else
		chg_virtue(V_KNOWLEDGE, 1);

	/* Sound */
	sound(SOUND_STUDY);

	/* One less spell available */
	p_ptr->new_spells--;

	/* Message if needed */
	if (p_ptr->new_spells)
	{
		/* Message */
#ifdef JP
                        if( p_ptr->new_spells < 10 ){
                                msg_format(" %d Ĥ%sؤ٤롣", p_ptr->new_spells, p);
                        }else{
                                msg_format(" %d Ĥ%sؤ٤롣", p_ptr->new_spells, p);
                        }
#else
		msg_format("You can learn %d more %s%s.",
			p_ptr->new_spells, p,
			(p_ptr->new_spells != 1) ? "s" : "");
#endif

	}

	/* Save the new_spells value */
	p_ptr->old_spells = p_ptr->new_spells;

	/* Redraw Study Status */
	p_ptr->redraw |= (PR_STUDY);
}


#define MAX_BIZARRE		6


#if 0
static int bizarre_num[MAX_BIZARRE] =
{
	SUMMON_BIZARRE1,
	SUMMON_BIZARRE2,
	SUMMON_BIZARRE3,
	SUMMON_BIZARRE4,
	SUMMON_BIZARRE5,
	SUMMON_BIZARRE6,
};


static void wild_magic(int spell)
{
	switch (randint(spell) + randint(8) + 1)
	{
		case 1:
		case 2:
		case 3:
		{
			teleport_player(10);
			break;
		}
		case 4:
		case 5:
		case 6:
		{
			teleport_player(100);
			break;
		}
		case 7:
		case 8:
		{
			teleport_player(200);
			break;
		}
		case 9:
		case 10:
		case 11:
		{
			unlite_area(10, 3);
			break;
		}
		case 12:
		case 13:
		case 14:
		{
			lite_area(damroll(2, 3), 2);
			break;
		}
		case 15:
		{
			destroy_doors_touch();
			break;
		}
		case 16: case 17:
		{
			wall_breaker();
			break;
		}
		case 18:
		{
			sleep_monsters_touch();
			break;
		}
		case 19:
		case 20:
		{
			trap_creation();
			break;
		}
		case 21:
		case 22:
		{
			door_creation();
			break;
		}
		case 23:
		case 24:
		case 25:
		{
			aggravate_monsters(0);
			break;
		}
		case 26:
		{
			earthquake(py, px, 5);
			break;
		}
		case 27:
		case 28:
		{
			(void)gain_random_mutation(0);
			break;
		}
		case 29:
		case 30:
		{
			apply_disenchant(0);
			break;
		}
		case 31:
		{
			lose_all_info();
			break;
		}
		case 32:
		{
			fire_ball(GF_CHAOS, 0, spell + 5, 1 + (spell / 10));
			break;
		}
		case 33:
		{
			wall_stone();
			break;
		}
		case 34:
		case 35:
		{
			int i;
			int type = bizarre_num[rand_int(6)];

			for (i = 0; i < 8; i++)
			{
				(void)summon_specific(0, py, px, (dun_level * 3) / 2, type, TRUE, FALSE, FALSE);
			}
			break;
		}
		case 36:
		case 37:
		{
			(void)activate_hi_summon();
			break;
		}
		case 38:
		{
			(void)summon_cyber(-1, py, px);
			break;
		}
		default:
		{
			int count = 0;

			(void)activate_ty_curse(FALSE, &count);

			break;
		}
	}

	return;
}
#endif /* 0 */


static bool cast_life_spell(int spell)
{
	int	dir;
	int	plev = p_ptr->lev;

	switch (spell)
	{
	case 0: /* Detect Evil */
		(void)detect_monsters_evil(DETECT_RAD_DEFAULT);
		break;
	case 1: /* Cure Light Wounds */
		(void)hp_player(damroll(2, 10));
		(void)set_cut(p_ptr->cut - 10);
		break;
	case 2: /* Bless */
		(void)set_blessed(p_ptr->blessed + randint(12) + 12);
		break;
	case 3: /* Remove Fear */
		(void)set_afraid(0);
		break;
	case 4: /* Call Light */
		(void)lite_area(damroll(2, (plev / 2)), (plev / 10) + 1);
		break;
	case 5: /* Detect Traps + Secret Doors */
		(void)detect_traps(DETECT_RAD_DEFAULT);
		(void)detect_doors(DETECT_RAD_DEFAULT);
		(void)detect_stairs(DETECT_RAD_DEFAULT);
		break;
	case 6: /* Cure Medium Wounds */
		(void)hp_player(damroll(4, 10));
		(void)set_cut((p_ptr->cut / 2) - 20);
		break;
	case 7: /* Satisfy Hunger */
		(void)set_food(PY_FOOD_MAX - 1);
		break;
	case 8: /* Cure Poison */
		(void)set_poisoned(0);
		break;
	case 9: /* Holy Lite */
		if (!get_aim_dir(&dir)) return FALSE;
#ifdef JP
msg_print("ʤ줿");
#else
		msg_print("A line of sunlight appears.");
#endif

		(void)lite_line(dir);
		break;
	case 10: /* Remove Curse */
		remove_curse();
		break;
	case 11: /* Cure Critical Wounds */
		(void)hp_player(damroll(8, 10));
		(void)set_stun(0);
		(void)set_cut(0);
		break;
	case 12: /* Orb or Draining */
		if (!get_aim_dir(&dir)) return FALSE;

		fire_ball(GF_HOLY_FIRE, dir,
		          (damroll(3, 6) + plev +
		          (plev / ((p_ptr->pclass == CLASS_PRIEST) ? 2 : 4))),
		          ((plev < 30) ? 2 : 3));

		break;
	case 13: /* Nature Awareness -- downgraded */
		map_area(DETECT_RAD_MAP);
		(void)detect_traps(DETECT_RAD_DEFAULT);
		(void)detect_doors(DETECT_RAD_DEFAULT);
		(void)detect_stairs(DETECT_RAD_DEFAULT);
		(void)detect_monsters_normal(DETECT_RAD_DEFAULT);
		break;
	case 14: /* Heroism */
		(void)set_hero(p_ptr->hero + randint(25) + 25);
		(void)hp_player(10);
		(void)set_afraid(0);
		break;
	case 15: /* Charm Monster */
		if (!get_aim_dir(&dir)) return FALSE;

		(void)charm_monster(dir, plev);
		break;
	case 16: /* Protection from Evil */
		(void)set_protevil(p_ptr->protevil + randint(25) + 3 * p_ptr->lev);
		break;
	case 17: /* Healing */
		(void)hp_player(300);
		(void)set_stun(0);
		(void)set_cut(0);
		break;
	case 18: /* Dispel Evil */
		(void)dispel_evil(plev * 4);
		break;
	case 19: /* Glyph of Warding */
		warding_glyph();
		break;
	case 20: /* Dispel Curse */
		(void)remove_all_curse();
		break;
	case 21: /* Resistance True */
		(void)set_oppose_acid(p_ptr->oppose_acid + randint(20) + 20);
		(void)set_oppose_elec(p_ptr->oppose_elec + randint(20) + 20);
		(void)set_oppose_fire(p_ptr->oppose_fire + randint(20) + 20);
		(void)set_oppose_cold(p_ptr->oppose_cold + randint(20) + 20);
		(void)set_oppose_pois(p_ptr->oppose_pois + randint(20) + 20);
		break;
	case 22: /* Banishment */
		if (banish_evil(100))
		{
#ifdef JP
msg_print("θϤٰǤʧä");
#else
			msg_print("The power of your god banishes evil!");
#endif

		}
		break;
	case 23: /* 'Day of the Dove' */
		charm_monsters(plev * 2);
		break;
	case 24: /* Holy Word */
		(void)dispel_evil(plev * 4);
		(void)hp_player(500);
		(void)set_afraid(0);
		(void)set_poisoned(0);
		(void)set_stun(0);
		(void)set_cut(0);
		break;
	case 25: /* Bless Weapon */
		return bless_weapon();
	case 26: /* Restoration */
		(void)do_res_stat(A_STR);
		(void)do_res_stat(A_INT);
		(void)do_res_stat(A_WIS);
		(void)do_res_stat(A_DEX);
		(void)do_res_stat(A_CON);
		(void)do_res_stat(A_CHR);
		(void)restore_level();
		break;
	case 27: /* Nanka(ʤ) */
		project(0, 8, py, px, 150, GF_LITE, PROJECT_KILL | PROJECT_ITEM);
		(void)lite_area(damroll(2, (plev / 2)), (plev / 10) + 1);
		wiz_lite();
		break;
	case 28: /* Holy Vision */
		return identify_fully();
	case 29: /* Healing True */
		(void)hp_player(1000);
		(void)set_stun(0);
		(void)set_cut(0);
		break;
	case 30: /* Summon Angel */
		summon_specific(-1, py, px, plev, SUMMON_ANGEL, TRUE, TRUE, TRUE);
		break;
	case 31: /* Divine Intervention */
		project(0, 1, py, px, 500, GF_HOLY_FIRE, PROJECT_KILL);
		dispel_monsters(plev * 4);
		slow_monsters();
		stun_monsters(plev * 4);
		confuse_monsters(plev * 4);
		turn_monsters(plev * 4);
		stasis_monsters(plev * 4);
		(void)set_shero(p_ptr->shero + randint(25) + 25);
		(void)hp_player(300);
		if (!p_ptr->fast)
		{   /* Haste */
			(void)set_fast(randint(20 + plev) + plev);
		}
		else
		{
			(void)set_fast(p_ptr->fast + randint(5));
		}
		(void)set_afraid(0);
		break;
	default:
#ifdef JP
msg_format("ʤʥ饤դμʸ %d 򾧤", spell);
#else
		msg_format("You cast an unknown Life spell: %d.", spell);
#endif

		msg_print(NULL);
	}

	return TRUE;
}



static bool cast_sorcery_spell(int spell)
{
	int	dir;
	int	beam;
	int	plev = p_ptr->lev;

	if (p_ptr->pclass == CLASS_MAGE) beam = plev;
	else beam = plev / 2;

	switch (spell)
	{
	case 0: /* Magic Missile */
		if (!get_aim_dir(&dir)) return FALSE;

		fire_bolt_or_beam(beam - 10, GF_MISSILE, dir,
			damroll(3 + ((plev - 1) / 5), 4));
		break;
	case 1: /* Detect Monsters */
		(void)detect_monsters_normal(DETECT_RAD_DEFAULT);
		break;
	case 2: /* Phase Door */
		teleport_player(10);
		break;
	case 3: /* Detect Doors and Traps */
		(void)detect_traps(DETECT_RAD_DEFAULT);
		(void)detect_doors(DETECT_RAD_DEFAULT);
		(void)detect_stairs(DETECT_RAD_DEFAULT);
		break;
	case 4: /* Light Area */
		(void)lite_area(damroll(2, (plev / 2)), (plev / 10) + 1);
		break;
	case 5: /* Trap & Door Destruction */
		if (!get_aim_dir(&dir)) return FALSE;

		(void)destroy_door(dir);
		break;
	case 6: /* Teleport Self */
		teleport_player(plev * 5);
		break;
	case 7: /* Satisfy Hunger */
		(void)set_food(PY_FOOD_MAX - 1);
		break;
	case 8: /* Manaburst */
		if (!get_aim_dir(&dir)) return FALSE;

		fire_ball(GF_MISSILE, dir,
			  (damroll(3, 5) + plev +
			   (plev / ((p_ptr->pclass == CLASS_MAGE) ? 2 : 4))),
			   (plev < 30) ? 2 : 3);
			/* Shouldn't actually use GF_MANA, as it will destroy all
			 * items on the floor */
		break;
	case 9: /* Word of Recall */
		word_of_recall();
		break;
	case 10: /* Stone to Mud */
		if (!get_aim_dir(&dir)) return FALSE;

		(void)wall_to_mud(dir);
		break;
	case 11: /* Recharging */
		return recharge(plev * 4);
	case 12: /* Magic Mapping */
		map_area(DETECT_RAD_MAP);
		break;
	case 13: /* Identify */
		if(plev < 35)
		{
			return ident_spell();
		}
		else
		{
			return identify_fully();
		}
	case 14: /* Sense Minds */
		(void)set_tim_esp(p_ptr->tim_esp + randint(30) + 25);
		break;
	case 15: /* Doom Bolt -- always beam in 2.0.7 or later */
		if (!get_aim_dir(&dir)) return FALSE;

		fire_beam(GF_MANA, dir, damroll(11 + ((plev - 5) / 4), 8));
		break;
	case 16: /* Haste Self */
		if (!p_ptr->fast)
		{
			(void)set_fast(randint(20 + plev) + plev);
		}
		else
		{
			(void)set_fast(p_ptr->fast + randint(5));
		}
		break;
	case 17: /* Teleport Other */
		if (!get_aim_dir(&dir)) return FALSE;

		(void)fire_beam(GF_AWAY_ALL, dir, plev);
		break;
	case 18: /* Magic Rocket */
		if (!get_aim_dir(&dir)) return FALSE;

#ifdef JP
msg_print("åȯ͡");
#else
		msg_print("You launch a rocket!");
#endif

		fire_ball(GF_ROCKET, dir, 120 + plev, 2);
		break;
	case 19: /* Genocide */
		(void)genocide(plev + 50);
		break;
	case 20: /* Probing */
		probing();
		break;
	case 21: /* Teleport Level */
		(void)teleport_player_level();
		break;
	case 22: /* Death Ray */
		if (!get_aim_dir(&dir)) return FALSE;

		(void)death_ray(dir, plev);
		break;
	case 23: /* Detection */
		(void)detect_all(DETECT_RAD_DEFAULT);
		break;
	case 24: /* Word of Destruction */
		destroy_area(py, px, 15, TRUE);
		break;
	case 25: /* Clairvoyance */
		wiz_lite();
		if (!p_ptr->telepathy)
		{
			(void)set_tim_esp(p_ptr->tim_esp + randint(30) + 25);
		}
		break;
	case 26: /* Summon monster, demon */
	{
		bool pet = (randint(3) != 1);
		bool group = !(pet && (plev < 50));

		if (summon_specific((pet ? -1 : 0), py, px, plev, SUMMON_DEMON, group, FALSE, pet))
		{
#ifdef JP
msg_print("βΰ");
#else
			msg_print("The area fills with a stench of sulphur and brimstone.");
#endif


			if (pet)
#ifdef JP
msg_print("֤ѤǤޤ͡");
#else
				msg_print("'What is thy bidding... Master?'");
#endif

			else
#ifdef JP
msg_print("ܤԤ衢βͤˤ餺 κĺ");
#else
				msg_print("'NON SERVIAM! Wretch! I shall feast on thy mortal soul!'");
#endif

		}
		else
		{
#ifdef JP
msg_print("ϸʤä");
#else
			msg_print("No Greater Demon arrive.");
#endif
		}
		break;
	}
	case 27: /* Dimension Door */
#ifdef JP
msg_print("⤬ŪϤǲ");
#else
		msg_print("You open a dimensional gate. Choose a destination.");
#endif

		return dimension_door();
	case 28: /* Summon Ancient Dragon */
		summon_specific(-1, py, px, plev, SUMMON_HI_DRAGON_NO_UNIQUES, TRUE, TRUE, TRUE);

		break;
	case 29: /* Mass Genocide */
		(void)mass_genocide(plev + 50);
		break;
	case 30: /* Mana Storm */
		if (!get_aim_dir(&dir)) return FALSE;

		fire_ball(GF_MANA, dir, 300 + (plev * 4), 4);
		break;
	case 31: /* Wraithform */
		set_wraith_form(p_ptr->wraith_form + randint(plev / 2) + (plev / 2));
		break;
	default:
#ifdef JP
msg_format("ʤʥ꡼μʸ %d 򾧤", spell);
#else
		msg_format("You cast an unknown Sorcery spell: %d.", spell);
#endif

		msg_print(NULL);
	}

	return TRUE;
}


static bool cast_musou_spell(int spell)
{
	int	    dir;
	int	    plev = p_ptr->lev;
	int	    x, y;

	switch (spell)
	{
	case 0: /* Regenerate */
		(void)set_tim_regen(p_ptr->tim_regen + 80 + randint(80));
		break;
	case 1: /* Nanka(¤ -- 3way attack) */
	{
		int cdir;
		if (!get_rep_dir(&dir)) return FALSE;

		if (dir == 5) return FALSE;
		for (cdir = 0;cdir < 8; cdir++)
		{
			if (cdd[cdir] == dir) break;
		}
		if (cdir == 8) return FALSE;
		y = py + ddy_cdd[cdir];
		x = px + ddx_cdd[cdir];
		if (cave[y][x].m_idx)
			py_attack(y, x);
		else
			msg_print("϶ڤä");
		y = py + ddy_cdd[(cdir + 7) % 8];
		x = px + ddx_cdd[(cdir + 7) % 8];
		if (cave[y][x].m_idx)
			py_attack(y, x);
		else
			msg_print("϶ڤä");
		y = py + ddy_cdd[(cdir + 1) % 8];
		x = px + ddx_cdd[(cdir + 1) % 8];
		if (cave[y][x].m_idx)
			py_attack(y, x);
		else
			msg_print("϶ڤä");

		break;
	}
	case 2: /* Resist Cold */
		(void)set_oppose_cold(p_ptr->oppose_cold + randint(20) + 20);
		break;
	case 3: /* Resist Fire */
		(void)set_oppose_fire(p_ptr->oppose_fire + randint(20) + 20);
		break;
	case 4: /* Heroism */
		(void)set_hero(p_ptr->hero + randint(25) + 25);
		(void)hp_player(10);
		(void)set_afraid(0);
		break;
	case 5: /* Resist Lightning */
		(void)set_oppose_elec(p_ptr->oppose_elec + randint(20) + 20);
		break;
	case 6: /* Resist Acid */
		(void)set_oppose_acid(p_ptr->oppose_acid + randint(20) + 20);
		break;
	case 7: /* See Invisible */
		(void)set_tim_invis(p_ptr->tim_invis + randint(24) + 24);
		break;
	case 8: /* Nanka(ͷ) */
		return charge_monster();
	case 9: /* Stone Skin */
		(void)set_shield(p_ptr->shield + randint(25) + 30);
		break;
	case 10: /* Berserk */
		(void)set_shero(p_ptr->shero + randint(25) + 25);
		(void)hp_player(30);
		(void)set_afraid(0);
		break;
	case 11: /* Nanka(å) */
		if (!get_aim_dir(&dir)) return FALSE;

		(void)confuse_monster(dir, (plev * 3) / 2);
		break;
	case 12: /* Resist Poison */
		(void)set_oppose_pois(p_ptr->oppose_pois + randint(20) + 20);
		break;
	case 13: /* Nanka(Ʈγ) */
		(void)set_oppose_elec(p_ptr->oppose_elec + randint(20) + 20);
		(void)set_oppose_fire(p_ptr->oppose_fire + randint(20) + 20);
		(void)set_oppose_cold(p_ptr->oppose_cold + randint(20) + 20);
		(void)set_tim_sh_elec(p_ptr->tim_sh_elec + randint(20) + 20);
		(void)set_tim_sh_fire(p_ptr->tim_sh_fire + randint(20) + 20);
		(void)set_tim_sh_cold(p_ptr->tim_sh_cold + randint(20) + 20);
		(void)set_hero(p_ptr->hero + randint(20) + 20);
		(void)hp_player(10);
		(void)set_afraid(0);
		break;
	case 14: /* Nanka(ַ) */
		if (!get_rep_dir(&dir)) return FALSE;

		y = py + ddy[dir];
		x = px + ddx[dir];
		if(cave[y][x].m_idx)
		{
			py_attack_special(y, x, ATTACK_VORPAL);
		}
		else
		{
#ifdef JP
msg_print("ˤϥ󥹥Ϥޤ");
#else
			msg_print("You don't see any monster in this direction");
#endif
			return FALSE;
		}
		break;
	case 15: /* Haste Self */
		if (!p_ptr->fast)
		{
			(void)set_fast(randint(20 + plev) + plev);
		}
		else
		{
			(void)set_fast(p_ptr->fast + randint(5));
		}
		break;
	case 16: /* Whirlwind Attack */
		{
			int y = 0, x = 0;
			cave_type       *c_ptr;
			monster_type    *m_ptr;

			for (dir = 0; dir <= 9; dir++)
			{
				y = py + ddy[dir];
				x = px + ddx[dir];
				c_ptr = &cave[y][x];

				/* Get the monster */
				m_ptr = &m_list[c_ptr->m_idx];

				/* Hack -- attack monsters */
				if (c_ptr->m_idx && (m_ptr->ml || cave_floor_bold(y, x)))
					py_attack(y, x);
			}
		}
		break;
	case 17: /* Nanka(忩ɻ) */
		(void)coat_equip();
		break;
	case 18: /* Nanka() */
		if (!get_aim_dir(&dir)) return FALSE;

		fire_beam(GF_INERTIA, dir, plev + randint(plev * 2));
		break;
	case 19: /* Nanka(ˡγ) */
		(void)set_magicdef(p_ptr->magicdef + randint(20) + 20);
		break;
	case 20: /* Remove Enchantment */
		if(!mundane_spell()) return FALSE;
		break;
	case 21: /* Earthquake */
		earthquake(py, px, 10);
		break;
	case 22: /* Resistance True */
		(void)set_oppose_acid(p_ptr->oppose_acid + randint(20) + 20);
		(void)set_oppose_elec(p_ptr->oppose_elec + randint(20) + 20);
		(void)set_oppose_fire(p_ptr->oppose_fire + randint(20) + 20);
		(void)set_oppose_cold(p_ptr->oppose_cold + randint(20) + 20);
		(void)set_oppose_pois(p_ptr->oppose_pois + randint(20) + 20);
		break;
	case 23: /* Battle Frenzy */
		(void)set_shero(p_ptr->shero + randint(25) + 25);
		(void)hp_player(30);
		(void)set_afraid(0);
		if (!p_ptr->fast)
		{
			(void)set_fast(randint(20 + (plev / 2)) + (plev / 2));
		}
		else
		{
			(void)set_fast(p_ptr->fast + randint(5));
		}
		break;
	case 24: /* Nanka() */
		if (!get_rep_dir(&dir)) return FALSE;

		y = py + ddy[dir];
		x = px + ddx[dir];
		if(cave[y][x].m_idx)
		{
			py_attack_special(y, x, ATTACK_BAKUSIN);
		}
		else
		{
#ifdef JP
msg_print("ˤϥ󥹥Ϥޤ");
#else
			msg_print("You don't see any monster in this direction");
#endif
			return FALSE;
		}
		break;
	case 25: /* Enchant Weapon */
		return enchant_spell(rand_int(4) + 1, rand_int(4) + 1, 0);
	case 26: /* Enchant Armour */
		return enchant_spell(0, 0, rand_int(3) + 2);
	case 27: /* Nanka(Ʈη) */
		if (!get_rep_dir(&dir)) return FALSE;

		y = py + ddy[dir];
		x = px + ddx[dir];
		if(cave[y][x].m_idx)
		{
			py_attack_special(y, x, ATTACK_TOUKI);
		}
		else
		{
#ifdef JP
msg_print("ˤϥ󥹥Ϥޤ");
#else
			msg_print("You don't see any monster in this direction");
#endif
			return FALSE;
		}
		break;
	case 28: /* Nanka(Ȼ¤) */
		if (!get_rep_dir(&dir)) return FALSE;

		y = py + ddy[dir];
		x = px + ddx[dir];
		if(cave[y][x].m_idx)
		{
			py_attack(y, x);
		}
		else
		{
#ifdef JP
msg_print("ˤϥ󥹥Ϥޤ");
#else
			msg_print("You don't see any monster in this direction");
#endif
			return FALSE;
		}
		if (cave[y][x].m_idx)
		{
			handle_stuff();
			py_attack(y, x);
		}
		break;
	case 29: /* Nanka(ε) */
		if (!get_aim_dir(&dir)) return FALSE;

		fire_ball(GF_INERTIA, dir,
			150+randint(plev*2), -3);
		break;
	case 30: /* Nanka(Ǽ٤ο) */
		brand_weapon(5);
		break;
	case 31: /* Nanka(̵) */
	{
		int v = randint(plev / 2) + plev / 2;
		if (!p_ptr->fast)
		{
			(void)set_fast(v);
		}
		else
		{
			(void)set_fast(p_ptr->fast + randint(5));
		}
		(void)set_oppose_acid(p_ptr->oppose_acid + v);
		(void)set_oppose_elec(p_ptr->oppose_elec + v);
		(void)set_oppose_fire(p_ptr->oppose_fire + v);
		(void)set_oppose_cold(p_ptr->oppose_cold + v);
		(void)set_oppose_pois(p_ptr->oppose_pois + v);
		(void)set_musou(p_ptr->musou + v);
		break;
	}
	default:
#ifdef JP
msg_format("ʤ̵Фμʸ %d 򾧤", spell);
#else
		msg_format("You cast an unknown Musou spell: %d.", spell);
#endif

		msg_print(NULL);
	}

	return TRUE;
}


#if 0
static bool cast_chaos_spell(int spell)
{
	int	dir, i, beam;
	int	plev = p_ptr->lev;

	if (p_ptr->pclass == CLASS_MAGE) beam = plev;
	else if (p_ptr->pclass == CLASS_HIGH_MAGE) beam = plev + 10;
	else beam = plev / 2;

	switch (spell)
	{
	case 0: /* Magic Missile */
		if (!get_aim_dir(&dir)) return FALSE;

		fire_bolt_or_beam(beam - 10, GF_MISSILE, dir,
			damroll(3 + ((plev - 1) / 5), 4));
		break;
	case 1: /* Trap / Door destruction */
		(void)destroy_doors_touch();
		break;
	case 2: /* Flash of Light == Light Area */
		(void)lite_area(damroll(2, (plev / 2)), (plev / 10) + 1);
		break;
	case 3: /* Touch of Confusion */
		if (!p_ptr->confusing)
		{
#ifdef JP
msg_print("ʤμϸϤ᤿");
#else
			msg_print("Your hands start glowing.");
#endif

			p_ptr->confusing = TRUE;
			p_ptr->redraw |= (PR_STATUS);
		}
		break;
	case 4: /* Manaburst */
		if (!get_aim_dir(&dir)) return FALSE;

		fire_ball(GF_MISSILE, dir,
		    (damroll(3, 5) + plev +
		    (plev / (((p_ptr->pclass == CLASS_MAGE) ||
		    (p_ptr->pclass == CLASS_HIGH_MAGE)) ? 2 : 4))),
		    ((plev < 30) ? 2 : 3));
			/* Shouldn't actually use GF_MANA, as it will destroy all
			 * items on the floor */
		break;
	case 5: /* Fire Bolt */
		if (!get_aim_dir(&dir)) return FALSE;

		fire_bolt_or_beam(beam, GF_FIRE, dir,
			damroll(8 + ((plev - 5) / 4), 8));
		break;
	case 6: /* Fist of Force ("Fist of Fun") */
		if (!get_aim_dir(&dir)) return FALSE;

		fire_ball(GF_DISINTEGRATE, dir,
			damroll(8 + ((plev - 5) / 4), 8), 0);
		break;
	case 7: /* Teleport Self */
		teleport_player(plev * 5);
		break;
	case 8: /* Wonder */
		{
		/* This spell should become more useful (more
		controlled) as the player gains experience levels.
		Thus, add 1/5 of the player's level to the die roll.
		This eliminates the worst effects later on, while
		keeping the results quite random.  It also allows
			some potent effects only at high level. */

			int die = randint(100) + plev / 5;

			if (die < 26)
				chg_virtue(V_CHANCE, 1);

			if (!get_aim_dir(&dir)) return FALSE;
			if (die > 100)
#ifdef JP
msg_print("ʤϤߤʤΤ򴶤");
#else
				msg_print("You feel a surge of power!");
#endif

			if (die < 8) clone_monster(dir);
			else if (die < 14) speed_monster(dir);
			else if (die < 26) heal_monster(dir);
			else if (die < 31) poly_monster(dir);
			else if (die < 36)
				fire_bolt_or_beam(beam - 10, GF_MISSILE, dir,
				    damroll(3 + ((plev - 1) / 5), 4));
			else if (die < 41) confuse_monster(dir, plev);
			else if (die < 46) fire_ball(GF_POIS, dir, 20 + (plev / 2), 3);
			else if (die < 51) (void)lite_line(dir);
			else if (die < 56)
				fire_bolt_or_beam(beam - 10, GF_ELEC, dir,
				    damroll(3 + ((plev - 5) / 4), 8));
			else if (die < 61)
				fire_bolt_or_beam(beam - 10, GF_COLD, dir,
				    damroll(5 + ((plev - 5) / 4), 8));
			else if (die < 66)
				fire_bolt_or_beam(beam, GF_ACID, dir,
				    damroll(6 + ((plev - 5) / 4), 8));
			else if (die < 71)
				fire_bolt_or_beam(beam, GF_FIRE, dir,
					 damroll(8 + ((plev - 5) / 4), 8));
			else if (die < 76) drain_life(dir, 75);
			else if (die < 81) fire_ball(GF_ELEC, dir, 30 + plev / 2, 2);
			else if (die < 86) fire_ball(GF_ACID, dir, 40 + plev, 2);
			else if (die < 91) fire_ball(GF_ICE, dir, 70 + plev, 3);
			else if (die < 96) fire_ball(GF_FIRE, dir, 80 + plev, 3);
			else if (die < 101) drain_life(dir, 100 + plev);
			else if (die < 104)
			{
				earthquake(py, px, 12);
			}
			else if (die < 106)
			{
				destroy_area(py, px, 15, TRUE);
			}
			else if (die < 108)
			{
				genocide(TRUE);
			}
			else if (die < 110) dispel_monsters(120);
			else /* RARE */
			{
				dispel_monsters(150);
				slow_monsters();
				sleep_monsters();
				hp_player(300);
			}
			break;
		}
	case 9: /* Chaos Bolt */
		if (!get_aim_dir(&dir)) return FALSE;

		fire_bolt_or_beam(beam, GF_CHAOS, dir,
			damroll(10 + ((plev - 5) / 4), 8));
		break;
	case 10: /* Sonic Boom */
#ifdef JP
msg_print("ɡɤ줿");
#else
		msg_print("BOOM! Shake the room!");
#endif

		project(0, plev / 10 + 2, py, px,
			45 + plev, GF_SOUND, PROJECT_KILL | PROJECT_ITEM);
		break;
	case 11: /* Doom Bolt -- always beam in 2.0.7 or later */
		if (!get_aim_dir(&dir)) return FALSE;

		fire_beam(GF_MANA, dir, damroll(11 + ((plev - 5) / 4), 8));
		break;
	case 12: /* Fire Ball */
		if (!get_aim_dir(&dir)) return FALSE;

		fire_ball(GF_FIRE, dir, plev + 55, 2);
		break;
	case 13: /* Teleport Other */
		if (!get_aim_dir(&dir)) return FALSE;

		(void)fire_beam(GF_AWAY_ALL, dir, plev);
		break;
	case 14: /* Word of Destruction */
		destroy_area(py, px, 15, TRUE);
		break;
	case 15: /* Invoke Logrus */
		if (!get_aim_dir(&dir)) return FALSE;

		fire_ball(GF_CHAOS, dir, plev + 66, plev / 5);
		break;
	case 16: /* Polymorph Other */
		if (!get_aim_dir(&dir)) return FALSE;

		(void)poly_monster(dir);
		break;
	case 17: /* Chain Lightning */
		for (dir = 0; dir <= 9; dir++)
			fire_beam(GF_ELEC, dir, damroll(5 + (plev / 10), 8));
		break;
	case 18: /* Arcane Binding == Charging */
		return recharge(90);
	case 19: /* Disintegration */
		if (!get_aim_dir(&dir)) return FALSE;

		fire_ball(GF_DISINTEGRATE, dir, plev + 80, 3 + plev / 40);
		break;
	case 20: /* Alter Reality */
		alter_reality();
		break;
	case 21: /* Polymorph Self */
		do_poly_self();
		break;
	case 22: /* Chaos Branding */
		brand_weapon(1);
		break;
	case 23: /* Summon monster, demon */
		{
			bool pet = (randint(3) == 1);
			bool group = !(pet && (plev < 50));

			if (summon_specific((pet ? -1 : 0), py, px, (plev * 3) / 2, SUMMON_DEMON, group, FALSE, pet))
			{
#ifdef JP
msg_print("βΰ");
#else
				msg_print("The area fills with a stench of sulphur and brimstone.");
#endif


				if (pet)
#ifdef JP
msg_print("֤ѤǤޤ͡");
#else
					msg_print("'What is thy bidding... Master?'");
#endif

				else
#ifdef JP
msg_print("ܤԤ衢βͤˤ餺ĺ");
#else
					msg_print("'NON SERVIAM! Wretch! I shall feast on thy mortal soul!'");
#endif

			}
			break;
		}
	case 24: /* Beam of Gravity */
		if (!get_aim_dir(&dir)) return FALSE;

		fire_beam(GF_GRAVITY, dir, damroll(9 + ((plev - 5) / 4), 8));
		break;
	case 25: /* Meteor Swarm */
		{
			int x, y;
			int b = 10 + randint(10);
			for (i = 0; i < b; i++)
			{
				int count = 0;

				while (count < 1000)
				{
					count++;
					
					x = px - 5 + randint(10);
					y = py - 5 + randint(10);

					/* paranoia */
					if (!in_bounds(y, x)) continue;

					/* keep going if not in LOS */
					if (!player_has_los_bold(y,x)) continue;

					/* if close enough - exit */
					if (distance(py, px, y, x) < 6) break;
				}

				if (count >= 1000) break;

				project(0, 2, y, x, (plev * 3) / 2, GF_METEOR, PROJECT_KILL | PROJECT_JUMP | PROJECT_ITEM);
			}
		}
		break;

	case 26: /* Flame Strike */
		fire_ball(GF_FIRE, 0, 150 + (2 * plev), 8);
		break;
	case 27: /* Call Chaos */
		call_chaos();
		break;
	case 28: /* Magic Rocket */
		if (!get_aim_dir(&dir)) return FALSE;

#ifdef JP
msg_print("åȯ͡");
#else
		msg_print("You launch a rocket!");
#endif

		fire_ball(GF_ROCKET, dir, 120 + plev, 2);
		break;
	case 29: /* Mana Storm */
		if (!get_aim_dir(&dir)) return FALSE;

		fire_ball(GF_MANA, dir, plev * 8, 4);
		break;
	case 30: /* Breathe Logrus */
		if (!get_aim_dir(&dir)) return FALSE;

		fire_ball(GF_CHAOS, dir, p_ptr->chp, 2);
		break;
	case 31: /* Call the Void */
		call_the_();
		break;
	default:
#ifdef JP
msg_format("ʤʥμʸ %d 򾧤", spell);
#else
		msg_format("You cast an unknown Chaos spell: %d.", spell);
#endif

		msg_print(NULL);
	}

	return TRUE;
}


static bool cast_death_spell(int spell)
{
	int	dir;
	int	beam;
	int	plev = p_ptr->lev;
	int	dummy = 0;
	int	i;

	if (p_ptr->pclass == CLASS_MAGE) beam = plev;
	else if (p_ptr->pclass == CLASS_HIGH_MAGE) beam = plev + 10;
	else beam = plev / 2;

	switch (spell)
	{
	case 0: /* Detect Undead & Demons -> Unlife */
		(void)detect_monsters_nonliving();
		break;
	case 1: /* Malediction */
		if (!get_aim_dir(&dir)) return FALSE;
		/* A radius-0 ball may (1) be aimed at objects etc.,
		 * and will affect them; (2) may be aimed at ANY
		 * visible monster, unlike a 'bolt' which must travel
		 * to the monster. */

		fire_ball(GF_HELL_FIRE, dir,
			damroll(3 + ((plev - 1) / 5), 3), 0);

		if (randint(5) == 1)
		{   /* Special effect first */
			dummy = randint(1000);
			if (dummy == 666)
				fire_bolt(GF_DEATH_RAY, dir, plev * 200);
			else if (dummy < 500)
				fire_bolt(GF_TURN_ALL, dir, plev);
			else if (dummy < 800)
				fire_bolt(GF_OLD_CONF, dir, plev);
			else
				fire_bolt(GF_STUN, dir, plev);
		}
		break;
	case 2: /* Detect Evil */
		(void)detect_monsters_evil();
		break;
	case 3: /* Stinking Cloud */
		if (!get_aim_dir(&dir)) return FALSE;

		fire_ball(GF_POIS, dir, 10 + (plev / 2), 2);
		break;
	case 4: /* Black Sleep */
		if (!get_aim_dir(&dir)) return FALSE;

		(void)sleep_monster(dir);
		break;
	case 5: /* Resist Poison */
		(void)set_oppose_pois(p_ptr->oppose_pois + randint(20) + 20);
		break;
	case 6: /* Horrify */
		if (!get_aim_dir(&dir)) return FALSE;

		(void)fear_monster(dir, plev);
		(void)stun_monster(dir, plev);
		break;
	case 7: /* Enslave the Undead */
		if (!get_aim_dir(&dir)) return FALSE;

		(void)control_one_undead(dir, plev);
		break;
	case 8: /* Orb of Entropy */
		if (!get_aim_dir(&dir)) return FALSE;

		fire_ball(GF_OLD_DRAIN, dir,
			(damroll(3, 6) + plev +
			(plev / (((p_ptr->pclass == CLASS_MAGE) ||
			(p_ptr->pclass == CLASS_HIGH_MAGE)) ? 2 : 4))),
			((plev < 30) ? 2 : 3));
		break;
	case 9: /* Nether Bolt */
		if (!get_aim_dir(&dir)) return FALSE;

		fire_bolt_or_beam(beam, GF_NETHER, dir,
		    damroll(6 + ((plev - 5) / 4), 8));
		break;
	case 10: /* Terror */
		(void)turn_monsters(30 + plev);
		break;
	case 11: /* Vampiric Drain */
		if (!get_aim_dir(&dir)) return FALSE;

		dummy = plev + randint(plev) * MAX(1, plev/10);   /* Dmg */
		if (drain_life(dir, dummy))
		{
			chg_virtue(V_SACRIFICE, -1);
			chg_virtue(V_VITALITY, -1);

			(void)hp_player(dummy);
			/* Gain nutritional sustenance: 150/hp drained */
			/* A Food ration gives 5000 food points (by contrast) */
			/* Don't ever get more than "Full" this way */
			/* But if we ARE Gorged,  it won't cure us */
			dummy = p_ptr->food + MIN(5000, 100 * dummy);
			if (p_ptr->food < PY_FOOD_MAX)   /* Not gorged already */
				(void)set_food(dummy >= PY_FOOD_MAX ? PY_FOOD_MAX - 1 : dummy);
		}
		break;
	case 12: /* Poison Branding */
		brand_weapon(2);
		break;
	case 13: /* Dispel Good */
		(void)dispel_good(plev * 4);
		break;
	case 14: /* Genocide */
		(void)genocide(TRUE);
		break;
	case 15: /* Restore Life */
		(void)restore_level();
		break;
	case 16: /* Berserk */
		(void)set_shero(p_ptr->shero + randint(25) + 25);
		(void)hp_player(30);
		(void)set_afraid(0);
		break;
	case 17: /* Invoke Spirits */
		{
			int die = randint(100) + plev / 5;
			if (!get_aim_dir(&dir)) return FALSE;

#ifdef JP
msg_print("ʤϻԤϤ򾷽...");
#else
			msg_print("You call on the power of the dead...");
#endif


			if (die < 26)
				chg_virtue(V_CHANCE, 1);

			if (die > 100)
#ifdef JP
msg_print("ʤϤɤɤϤΤͤ򴶤");
#else
				msg_print("You feel a surge of eldritch force!");
#endif


			if (die < 8)
			{
#ifdef JP
msg_print("ʤƤäʤμ̤ͱƤΩ夬äƤ");
#else
				msg_print("Oh no! Mouldering forms rise from the earth around you!");
#endif

				(void)summon_specific(0, py, px, dun_level, SUMMON_UNDEAD, TRUE, FALSE, FALSE);

				chg_virtue(V_UNLIFE, 1);
			}
			else if (die < 14)
			{
#ifdef JP
msg_print("̾񤤼ٰ¸ߤʤο̤᤮ƹԤä...");
#else
				msg_print("An unnamable evil brushes against your mind...");
#endif

				set_afraid(p_ptr->afraid + randint(4) + 4);
			}
			else if (die < 26)
			{
#ifdef JP
msg_print("ʤƬ̤ͩ󤻤Ƥ...");
#else
				msg_print("Your head is invaded by a horde of gibbering spectral voices...");
#endif

				set_confused(p_ptr->confused + randint(4) + 4);
			}
			else if (die < 31)
			{
				poly_monster(dir);
			}
			else if (die < 36)
			{
				fire_bolt_or_beam(beam - 10, GF_MISSILE, dir,
					damroll(3 + ((plev - 1) / 5), 4));
			}
			else if (die < 41)
			{
				confuse_monster (dir, plev);
			}
			else if (die < 46)
			{
				fire_ball(GF_POIS, dir, 20 + (plev / 2), 3);
			}
			else if (die < 51)
			{
				(void)lite_line(dir);
			}
			else if (die < 56)
			{
				fire_bolt_or_beam(beam - 10, GF_ELEC, dir,
					damroll(3 + ((plev - 5) / 4), 8));
			}
			else if (die < 61)
			{
				fire_bolt_or_beam(beam - 10, GF_COLD, dir,
					damroll(5 + ((plev - 5) / 4), 8));
			}
			else if (die < 66)
			{
				fire_bolt_or_beam(beam, GF_ACID, dir,
					damroll(6 + ((plev - 5) / 4), 8));
			}
			else if (die < 71)
			{
				fire_bolt_or_beam(beam, GF_FIRE, dir,
					damroll(8 + ((plev - 5) / 4), 8));
			}
			else if (die < 76)
			{
				drain_life(dir, 75);
			}
			else if (die < 81)
			{
				fire_ball(GF_ELEC, dir, 30 + plev / 2, 2);
			}
			else if (die < 86)
			{
				fire_ball(GF_ACID, dir, 40 + plev, 2);
			}
			else if (die < 91)
			{
				fire_ball(GF_ICE, dir, 70 + plev, 3);
			}
			else if (die < 96)
			{
				fire_ball(GF_FIRE, dir, 80 + plev, 3);
			}
			else if (die < 101)
			{
				drain_life(dir, 100 + plev);
			}
			else if (die < 104)
			{
				earthquake(py, px, 12);
			}
			else if (die < 106)
			{
				destroy_area(py, px, 15, TRUE);
			}
			else if (die < 108)
			{
				genocide(TRUE);
			}
			else if (die < 110)
			{
				dispel_monsters(120);
			}
			else
			{ /* RARE */
				dispel_monsters(150);
				slow_monsters();
				sleep_monsters();
				hp_player(300);
			}

			if (die < 31)
#ifdef JP
msg_print("Ф֤⤦ޤϲ桹֤ˤʤ夭Ԥ衣");
#else
				msg_print("Sepulchral voices chuckle. 'Soon you will join us, mortal.'");
#endif

			break;
		}
	case 18: /* Dark Bolt */
		if (!get_aim_dir(&dir)) return FALSE;

		fire_bolt_or_beam(beam, GF_DARK, dir,
			damroll(4 + ((plev - 5) / 4), 8));
		break;
	case 19: /* Battle Frenzy */
		(void)set_shero(p_ptr->shero + randint(25) + 25);
		(void)hp_player(30);
		(void)set_afraid(0);
		if (!p_ptr->fast)
		{
			(void)set_fast(randint(20 + (plev / 2)) + (plev / 2));
		}
		else
		{
			(void)set_fast(p_ptr->fast + randint(5));
		}
		break;
	case 20: /* Vampirism True */
		if (!get_aim_dir(&dir)) return FALSE;

		chg_virtue(V_SACRIFICE, -1);
		chg_virtue(V_VITALITY, -1);

		for (dummy = 0; dummy < 3; dummy++)
		{
			if (drain_life(dir, 100))
				hp_player(100);
		}
		break;
	case 21: /* Vampiric Branding */
		brand_weapon(3);
		break;
	case 22: /* Darkness Storm */
		if (!get_aim_dir(&dir)) return FALSE;

		fire_ball(GF_DARK, dir, 120, 4);
		break;
	case 23: /* Mass Genocide */
		(void)mass_genocide(TRUE);
		break;
	case 24: /* Death Ray */
		if (!get_aim_dir(&dir)) return FALSE;

		(void)death_ray(dir, plev);
		break;
	case 25: /* Raise the Dead */
		{
			bool pet = (randint(3) == 1);
			bool group;
			int type;

			if (pet)
			{
				type = (plev > 47 ? SUMMON_HI_UNDEAD_NO_UNIQUES : SUMMON_UNDEAD);
				group = (((plev > 24) && (randint(3) == 1)) ? TRUE : FALSE);
			}
			else
			{
				type = (plev > 47 ? SUMMON_HI_UNDEAD : SUMMON_UNDEAD);
				group = TRUE;
			}

			if (summon_specific((pet ? -1 : 0), py, px, (plev * 3) / 2, type, group, FALSE, pet))
			{
#ifdef JP
msg_print("䤿ʤμ˿᤭Ϥ᤿Խ򱿤Ǥ...");
#else
				msg_print("Cold winds begin to blow around you, carrying with them the stench of decay...");
#endif


				if (pet)
#ifdef JP
msg_print("ŤλऻԶʤ˻Ť뤿ڤᴤä");
#else
					msg_print("Ancient, long-dead forms arise from the ground to serve you!");
#endif

				else
#ifdef JP
msg_print("Ԥᴤä̲˸뤢ʤȳ뤿ˡ");
#else
					msg_print("'The dead arise... to punish you for disturbing them!'");
#endif


				chg_virtue(V_UNLIFE, 1);
			}

			break;
		}
	case 26: /* Esoteria */
		if (randint(50) > plev)
			return ident_spell();
		else
			return identify_fully();
		break;
	case 27: /* Word of Death */
		(void)dispel_living(plev * 3);
		break;
	case 28: /* Evocation */
		(void)dispel_monsters(plev * 4);
		turn_monsters(plev * 4);
		banish_monsters(plev * 4);
		break;
	case 29: /* Hellfire */
		if (!get_aim_dir(&dir)) return FALSE;

		fire_ball(GF_HELL_FIRE, dir, 666, 3);
#ifdef JP
take_hit(50 + randint(50), "ϹιФμʸ򾧤ϫ");
#else
		take_hit(50 + randint(50), "the strain of casting Hellfire");
#endif

		break;
	case 30: /* Omnicide */
		p_ptr->csp -= 100;	/* Display doesn't show mana cost (100)
							 * as deleted until the spell has finished. This gives a
							 * false impression of how high your mana is climbing.
							 * Therefore, 'deduct' the cost temporarily before entering the
							 * loop, then add it back at the end so that the rest of the
							 * program can deduct it properly */
		for (i = 1; i < m_max; i++)
		{
			monster_type    *m_ptr = &m_list[i];
			monster_race    *r_ptr = &r_info[m_ptr->r_idx];

			/* Paranoia -- Skip dead monsters */
			if (!m_ptr->r_idx) continue;

			/* Hack -- Skip Unique Monsters */
			if (r_ptr->flags1 & (RF1_UNIQUE)) continue;

			/* Hack -- Skip Quest Monsters */
			if (r_ptr->flags1 & RF1_QUESTOR) continue;

			/* Delete the monster */
			delete_monster_idx(i);

			/* Take damage */
#ifdef JP
take_hit(randint(4), "μʸ򾧤ϫ");
#else
			take_hit(randint(4), "the strain of casting Omnicide");
#endif


			/* Absorb power of dead soul - up to twice max. mana */
			if (p_ptr->csp < (p_ptr->msp * 2))
				p_ptr->csp++;

			/* Visual feedback */
			move_cursor_relative(py, px);

			/* Redraw */
			p_ptr->redraw |= (PR_HP | PR_MANA);

			/* Window stuff */
			p_ptr->window |= (PW_PLAYER);
			p_ptr->window |= (PW_SPELL);

			/* Handle */
			handle_stuff();

			/* Fresh */
			Term_fresh();

			/* Delay */
			Term_xtra(TERM_XTRA_DELAY,
				delay_factor * delay_factor * delay_factor);
		}
		p_ptr->csp += 100;   /* Restore, ready to be deducted properly */

		break;
	case 31: /* Wraithform */
		set_wraith_form(p_ptr->wraith_form + randint(plev / 2) + (plev / 2));
		break;
	default:
		msg_format("You cast an unknown Death spell: %d.", spell);
		msg_print(NULL);
	}

	return TRUE;
}


static bool cast_trump_spell(int spell, bool success)
{
	int     dir;
	int     beam;
	int     plev = p_ptr->lev;
	int     dummy = 0;
	bool	no_trump = FALSE;
	char	ppp[80];
	char	tmp_val[160];


	if (p_ptr->pclass == CLASS_MAGE) beam = plev;
	else if (p_ptr->pclass == CLASS_HIGH_MAGE) beam = plev + 10;
	else beam = plev / 2;

	switch (spell)
	{
		case 0: /* Phase Door */
			if (success)
			{
				teleport_player(10);
			}
			break;
		case 1: /* Mind Blast */
			if (success)
			{
				if (!get_aim_dir(&dir)) return FALSE;
				fire_bolt_or_beam(beam-10, GF_PSI, dir,
				    damroll(3 + ((plev - 1) / 5), 3));
			}
			break;
		case 2: /* Shuffle */
			if (success)
			{
				/* A limited power 'wonder' spell */
				int die = randint(120);

				if ((p_ptr->pclass == CLASS_ROGUE) ||
					(p_ptr->pclass == CLASS_HIGH_MAGE))
					die = (randint(110)) + plev / 5;
				/* Card sharks and high mages get a level bonus */

#ifdef JP
msg_print("ʤϥɤڤäư...");
#else
				msg_print("You shuffle the deck and draw a card...");
#endif


				if (die < 30)
					chg_virtue(V_CHANCE, 1);

				if (die < 7)
				{
#ifdef JP
msg_print("ʤƤäԻդ");
#else
					msg_print("Oh no! It's Death!");
#endif

					for (dummy = 0; dummy < randint(3); dummy++)
						(void)activate_hi_summon();
				}
				else if (die < 14)
				{
#ifdef JP
msg_print("ʤƤä԰դ");
#else
					msg_print("Oh no! It's the Devil!");
#endif

					(void)summon_specific(0, py, px, dun_level, SUMMON_DEMON, TRUE, FALSE, FALSE);
				}
				else if (die < 18)
				{
					int count = 0;

#ifdef JP
msg_print("ʤƤäߤ줿ˡդ");
#else
					msg_print("Oh no! It's the Hanged Man.");
#endif

					(void)activate_ty_curse(FALSE, &count);
				}
				else if (die < 22)
				{
#ifdef JP
msg_print("Ĵ¤ηդ");
#else
					msg_print("It's the swords of discord.");
#endif

					aggravate_monsters(0);
				}
				else if (die < 26)
				{
#ifdef JP
msg_print("Զԡդ");
#else
					msg_print("It's the Fool.");
#endif

					(void)do_dec_stat(A_INT);
					(void)do_dec_stat(A_WIS);
				}
				else if (die < 30)
				{
#ifdef JP
msg_print("̯ʥ󥹥γ");
#else
					msg_print("It's the picture of a strange monster.");
#endif

					if (!(summon_specific(0, py, px, (dun_level * 3) / 2, 32 + randint(6), TRUE, FALSE, FALSE)))
						no_trump = TRUE;
				}
				else if (die < 33)
				{
#ifdef JP
msg_print("Էդ");
#else
					msg_print("It's the Moon.");
#endif

					unlite_area(10, 3);
				}
				else if (die < 38)
				{
#ifdef JP
msg_print("Ա̿ءդ");
#else
					msg_print("It's the Wheel of Fortune.");
#endif

					wild_magic(rand_int(32));
				}
				else if (die < 40)
				{
#ifdef JP
msg_print("ƥݡȡɤ");
#else
					msg_print("It's a teleport trump card.");
#endif

					teleport_player(10);
				}
				else if (die < 42)
				{
#ifdef JP
msg_print("դ");
#else
					msg_print("It's Justice.");
#endif

					set_blessed(p_ptr->blessed + p_ptr->lev);
				}
				else if (die < 47)
				{
#ifdef JP
msg_print("ƥݡȡɤ");
#else
					msg_print("It's a teleport trump card.");
#endif

					teleport_player(100);
				}
				else if (die < 52)
				{
#ifdef JP
msg_print("ƥݡȡɤ");
#else
					msg_print("It's a teleport trump card.");
#endif

					teleport_player(200);
				}
				else if (die < 60)
				{
#ifdef JP
msg_print("դ");
#else
					msg_print("It's the Tower.");
#endif

					wall_breaker();
				}
				else if (die < 72)
				{
#ifdef JP
msg_print("դ");
#else
					msg_print("It's Temperance.");
#endif

					sleep_monsters_touch();
				}
				else if (die < 80)
				{
#ifdef JP
msg_print("դ");
#else
					msg_print("It's the Tower.");
#endif

					earthquake(py, px, 5);
				}
				else if (die < 82)
				{
#ifdef JP
msg_print("ͧŪʥ󥹥γ");
#else
					msg_print("It's the picture of a friendly monster.");
#endif

					if (!(summon_specific(-1, py, px, (dun_level * 3) / 2, SUMMON_BIZARRE1, FALSE, TRUE, TRUE)))
						no_trump = TRUE;
				}
				else if (die < 84)
				{
#ifdef JP
msg_print("ͧŪʥ󥹥γ");
#else
					msg_print("It's the picture of a friendly monster.");
#endif

					if (!(summon_specific(-1, py, px, (dun_level * 3) / 2, SUMMON_BIZARRE2, FALSE, TRUE, TRUE)))
						no_trump = TRUE;
				}
				else if (die < 86)
				{
#ifdef JP
msg_print("ͧŪʥ󥹥γ");
#else
					msg_print("It's the picture of a friendly monster.");
#endif

					if (!(summon_specific(-1, py, px, (dun_level * 3) / 2, SUMMON_BIZARRE4, FALSE, TRUE, TRUE)))
						no_trump = TRUE;
				}
				else if (die < 88)
				{
#ifdef JP
msg_print("ͧŪʥ󥹥γ");
#else
					msg_print("It's the picture of a friendly monster.");
#endif

					if (!(summon_specific(-1, py, px, (dun_level * 3) / 2, SUMMON_BIZARRE5, FALSE, TRUE, TRUE)))
						no_trump = TRUE;
				}
				else if (die < 96)
				{
#ifdef JP
msg_print("͡դ");
#else
					msg_print("It's the Lovers.");
#endif

					if (get_aim_dir(&dir))
						(void)charm_monster(dir, MIN(p_ptr->lev, 20));
				}
				else if (die < 101)
				{
#ifdef JP
msg_print("Աԡդ");
#else
					msg_print("It's the Hermit.");
#endif

					wall_stone();
				}
				else if (die < 111)
				{
#ifdef JP
msg_print("ԿȽդ");
#else
					msg_print("It's the Judgement.");
#endif

					do_cmd_rerate();
					if (p_ptr->muta1 || p_ptr->muta2 || p_ptr->muta3)
					{
#ifdef JP
msg_print("ƤѰۤä");
#else
						msg_print("You are cured of all mutations.");
#endif

						p_ptr->muta1 = p_ptr->muta2 = p_ptr->muta3 = 0;
						p_ptr->update |= PU_BONUS;
						handle_stuff();
					}
				}
				else if (die < 120)
				{
#ifdef JP
msg_print("ۡդ");
#else
					msg_print("It's the Sun.");
#endif

					wiz_lite();
				}
				else
				{
#ifdef JP
msg_print("դ");
#else
					msg_print("It's the World.");
#endif

					if (p_ptr->exp < PY_MAX_EXP)
					{
						s32b ee = (p_ptr->exp / 25) + 1;
						if (ee > 5000) ee = 5000;
#ifdef JP
msg_print("˷иѤ褦ʵ롣");
#else
						msg_print("You feel more experienced.");
#endif

						gain_exp(ee);
					}
				}
			}
			break;
		case 3: /* Reset Recall */
			if (success)
			{
				/* Prompt */
#ifdef JP
sprintf(ppp, "˥åȤޤ (1-%d):", p_ptr->max_dlv);
#else
				sprintf(ppp, "Reset to which level (1-%d): ", p_ptr->max_dlv);
#endif


				/* Default */
				sprintf(tmp_val, "%d", MAX(dun_level, 1));

				/* Ask for a level */
				if (get_string(ppp, tmp_val, 10))
				{
					/* Extract request */
					dummy = atoi(tmp_val);

					/* Paranoia */
					if (dummy < 1) dummy = 1;

					/* Paranoia */
					if (dummy > p_ptr->max_dlv) dummy = p_ptr->max_dlv;

					p_ptr->max_dlv = dummy;

					/* Accept request */
#ifdef JP
msg_format("ԥ٥ %d %d եȡˤ˥åȡ", dummy, dummy * 50);
#else
					msg_format("Recall depth set to level %d (%d').", dummy, dummy * 50);
#endif

				}
				else
				{
					return FALSE;
				}
			}
			break;
		case 4: /* Teleport Self */
			if (success)
			{
				teleport_player(plev * 4);
			}
			break;
		case 5: /* Dimension Door */
			if (success)
			{
#ifdef JP
msg_print("⤬ŪϤǲ");
#else
				msg_print("You open a dimensional gate. Choose a destination.");
#endif

				return dimension_door();
			}
			break;
		case 6: /* Trump Spying */
			if (success)
			{
				(void)set_tim_esp(p_ptr->tim_esp + randint(30) + 25);
			}
			break;
		case 7: /* Teleport Away */
			if (success)
			{
				if (!get_aim_dir(&dir)) return FALSE;
				(void)fire_beam(GF_AWAY_ALL, dir, plev);
			}
			break;
		case 8: /* Trump Object */
			if (success)
			{
				if (!get_aim_dir(&dir)) return FALSE;
				fetch(dir, plev * 15, TRUE);
			}
			break;
		case 9: /* Trump Animal */
		{
			bool pet = success; /* was (randint(5) > 2) */
			int type = (pet ? SUMMON_ANIMAL_RANGER : SUMMON_ANIMAL);
			bool group = (pet ? FALSE : TRUE);

#ifdef JP
msg_print("ʤưʪΥɤ˽椹...");
#else
			msg_print("You concentrate on the trump of an animal...");
#endif


			if (summon_specific((pet ? -1 : 0), py, px, plev, type, group, FALSE, pet))
			{
				if (!pet)
#ifdef JP
msg_print("줿ưʪܤäƤ롪");
#else
					msg_print("The summoned animal gets angry!");
#endif

			}
			else
			{
				no_trump = TRUE;
			}

			break;
		}
		case 10: /* Phantasmal Servant */
			if (success)
			{
				if (summon_specific(-1, py, px, (plev * 3) / 2, SUMMON_PHANTOM, FALSE, TRUE, TRUE))
				{
#ifdef JP
msg_print("ѤǤޤ͡");
#else
					msg_print("'Your wish, master?'");
#endif

				}
				else
				{
					no_trump = TRUE;
				}
			}
			break;
		case 11: /* Trump Monster */
		{
			bool pet = success; /* was (randint(5) > 2) */
			int type = (pet ? SUMMON_NO_UNIQUES : 0);
			bool group = (pet ? FALSE : TRUE);

#ifdef JP
msg_print("ʤϥ󥹥Υɤ˽椹...");
#else
			msg_print("You concentrate on the trump of a monster...");
#endif


			if (summon_specific((pet ? -1 : 0), py, px, plev, type, group, FALSE, pet))
			{
				if (!pet)
#ifdef JP
msg_print("Ԥ줿󥹥ܤäƤ롪");
#else
					msg_print("The summoned creature gets angry!");
#endif

			}
			else
			{
				no_trump = TRUE;
			}

			break;
		}
		case 12: /* Conjure Elemental */
		{
			bool pet = success; /* was (randint(6) > 3) */
			bool group = (pet ? FALSE : TRUE);

#ifdef JP
msg_print("ʤϥ󥹥Υɤ˽椹...");
#else
			msg_print("You concentrate on the trump of a monster...");
#endif


			if (summon_specific((pet ? -1 : 0), py, px, plev, SUMMON_ELEMENTAL, group, FALSE, pet))
			{
				if (!pet)
#ifdef JP
msg_print("ʤϥ󥿥Υȥ˼Ԥ");
#else
					msg_print("You fail to control the elemental creature!");
#endif

			}
			else
			{
				no_trump = TRUE;
			}

			break;
		}
		case 13: /* Teleport Level */
			if (success)
			{
				(void)teleport_player_level();
			}
			break;
		case 14: /* Word of Recall */
			if (success)
			{
				word_of_recall();
			}
			break;
		case 15: /* Banish */
			if (success)
			{
				banish_monsters(plev * 4);
			}
			break;
		case 16: /* Joker Card */
		{
			bool pet = success; /* was (randint(2) == 1) */
			bool group = (pet ? FALSE : TRUE);

#ifdef JP
msg_print("ʤϥ硼˽椹...");
#else
			msg_print("You concentrate on a joker card...");
#endif


			switch (randint(4))
			{
				case 1: dummy = SUMMON_BIZARRE1; break;
				case 2: dummy = SUMMON_BIZARRE2; break;
				case 3: dummy = SUMMON_BIZARRE4; break;
				case 4: dummy = SUMMON_BIZARRE5; break;
			}

			if (summon_specific((pet ? -1 : 0), py, px, plev, dummy, group, FALSE, pet))
			{
				if (!pet)
#ifdef JP
msg_print("Ԥ줿󥹥ܤäƤ롪");
#else
					msg_print("The summoned creature gets angry!");
#endif

			}
			else
			{
				no_trump = TRUE;
			}
			break;
		}
		case 17: /* Trump Spiders */
		{
			bool pet = success; /* (randint(5) > 2) */
			bool group = (pet ? FALSE : TRUE);

#ifdef JP
msg_print("ʤΥɤ˽椹...");
#else
			msg_print("You concentrate on the trump of a spider...");
#endif


			if (summon_specific((pet ? -1 : 0), py, px, plev, SUMMON_SPIDER, group, FALSE, pet))
			{
				if (!pet)
#ifdef JP
msg_print("Ԥ줿ܤäƤ롪");
#else
					msg_print("The summoned spiders get angry!");
#endif

			}
			else
			{
				no_trump = TRUE;
			}

			break;
		}
		case 18: /* Trump Reptiles */
		{
			bool pet = success; /* was (randint(5) > 2) */

#ifdef JP
msg_print("ʤΥɤ˽椹...");
#else
			msg_print("You concentrate on the trump of a reptile...");
#endif


			if (summon_specific((pet ? -1 : 0), py, px, plev, SUMMON_HYDRA, TRUE, FALSE, pet))
			{
				if (!pet)
#ifdef JP
msg_print("Ԥ줿ܤäƤ롪");
#else
					msg_print("The summoned reptile gets angry!");
#endif

			}
			else
			{
				no_trump = TRUE;
			}

			break;
		}
		case 19: /* Trump Hounds */
		{
			bool pet = success; /* was (randint(5) > 2) */

#ifdef JP
msg_print("ʤϥϥɤΥɤ˽椹...");
#else
			msg_print("You concentrate on the trump of a hound...");
#endif


			if (summon_specific((pet ? -1 : 0), py, px, plev, SUMMON_HOUND, TRUE, FALSE, pet))
			{
				if (!pet)
#ifdef JP
msg_print("Ԥ줿ϥɤܤäƤ롪");
#else
					msg_print("The summoned hounds get angry!");
#endif

			}
			else
			{
				no_trump = TRUE;
			}

			break;
		}
		case 20: /* Trump Branding */
			if (success)
			{
				brand_weapon(4);
			}
			break;
		case 21: /* Living Trump */
			if (success)
			{
				if (randint(8) == 1)
					/* Teleport control */
					dummy = 12;
				else
					/* Random teleportation (uncontrolled) */
					dummy = 77;
				/* Gain the mutation */
				if (gain_random_mutation(dummy))
#ifdef JP
msg_print("ʤƤ륫ɤѤä");
#else
					msg_print("You have turned into a Living Trump.");
#endif

			}
			break;
		case 22: /* Death Dealing */
			if (success)
			{
				(void)dispel_living(plev * 3);
			}
			break;
		case 23: /* Trump Cyberdemon */
		{
			bool pet = success; /* was (randint(10) > 3) */

#ifdef JP
msg_print("ʤϥСǡΥɤ˽椹...");
#else
			msg_print("You concentrate on the trump of a Cyberdemon...");
#endif


			if (summon_specific((pet ? -1 : 0), py, px, plev * 2, SUMMON_CYBER, FALSE, FALSE, pet))
			{
				if (!pet)
#ifdef JP
msg_print("Ԥ줿СǡܤäƤ롪");
#else
					msg_print("The summoned Cyberdemon gets angry!");
#endif

			}
			else
			{
					no_trump = TRUE;
			}

			break;
		}
		case 24: /* Trump Divination */
			if (success)
			{
				(void)detect_all();
			}
			break;
		case 25: /* Trump Lore */
			if (success)
			{
				return identify_fully();
			}
			break;
		case 26: /* Trump Undead */
		{
			bool pet = success; /* (randint(10) > 3) */
			bool group = (pet ? FALSE : TRUE);

#ifdef JP
msg_print("ʤϥǥåɤΥɤ˽椹...");
#else
			msg_print("You concentrate on the trump of an undead creature...");
#endif


			if (summon_specific((pet ? -1 : 0), py, px, plev, SUMMON_UNDEAD, group, FALSE, pet))
			{
				if (!pet)
#ifdef JP
msg_print("Ԥ줿ǥåɤܤäƤ롪");
#else
					msg_print("The summoned undead creature gets angry!");
#endif

			}
			else
			{
				no_trump = TRUE;
			}

			break;
		}
		case 27: /* Trump Dragon */
		{
			bool pet = success; /* was (randint(10) > 3) */
			bool group = (pet ? FALSE : TRUE);

#ifdef JP
msg_print("ʤϥɥ饴Υɤ˽椹...");
#else
			msg_print("You concentrate on the trump of a dragon...");
#endif


			if (summon_specific((pet ? -1 : 0), py, px, plev, SUMMON_DRAGON, group, FALSE, pet))
			{
				if (!pet)
#ifdef JP
msg_print("Ԥ줿ɥ饴ܤäƤ롪");
#else
					msg_print("The summoned dragon gets angry!");
#endif

			}
			else
			{
				no_trump = TRUE;
			}

			break;
		}
		case 28: /* Mass Trump */
		{
			no_trump = TRUE;

#ifdef JP
msg_print("ʤϤĤΥɤ˽椹...");
#else
			msg_print("You concentrate on several trumps at once...");
#endif


			for (dummy = 0; dummy < 3 + (plev / 10); dummy++)
			{
				bool pet = success; /* was (randint(10) > 3) */
				bool group = (pet ? FALSE : TRUE);
				int type = (pet ? SUMMON_NO_UNIQUES : 0);

				if (summon_specific((pet ? -1 : 0), py, px, plev, type, group, FALSE, pet))
				{
					if (!pet)
#ifdef JP
msg_print("Ԥ줿󥹥ܤäƤ롪");
#else
						msg_print("The summoned creatures get angry!");
#endif

					no_trump = FALSE;
				}
			}
			break;
		}
		case 29: /* Trump Demon */
		{
			bool pet = success; /* was (randint(10) > 3) */
			bool group = (pet ? FALSE : TRUE);

#ifdef JP
msg_print("ʤϥǡΥɤ˽椹...");
#else
			msg_print("You concentrate on the trump of a demon...");
#endif


			if (summon_specific((pet ? -1 : 0), py, px, plev, SUMMON_DEMON, group, FALSE, pet))
			{
				if (!pet)
#ifdef JP
msg_print("Ԥ줿ǡܤäƤ롪");
#else
					msg_print("The summoned demon gets angry!");
#endif

			}
			else
			{
				no_trump = TRUE;
			}

			break;
		}
		case 30: /* Trump Ancient Dragon */
		{
			bool pet = success; /* was (randint(10) > 3) */
			bool group = (pet ? FALSE : TRUE);
			int type = (pet ? SUMMON_HI_DRAGON_NO_UNIQUES : SUMMON_HI_DRAGON);

#ifdef JP
msg_print("ʤϸɥ饴Υɤ˽椹...");
#else
			msg_print("You concentrate on the trump of an ancient dragon...");
#endif


			if (summon_specific((pet ? -1 : 0), py, px, plev, type, group, FALSE, pet))
			{
				if (!pet)
#ifdef JP
msg_print("Ԥ줿ɥ饴ܤäƤ롪");
#else
					msg_print("The summoned ancient dragon gets angry!");
#endif

			}
			else
			{
				no_trump = TRUE;
			}

			break;
		}
		case 31: /* Trump Greater Undead */
		{
			bool pet = success; /* was (randint(10) > 3) */
			bool group = (pet ? FALSE : TRUE);
			int type = (pet ? SUMMON_HI_UNDEAD_NO_UNIQUES : SUMMON_HI_UNDEAD);

#ifdef JP
msg_print("ʤ϶ϤʥǥåɤΥɤ˽椹...");
#else
			msg_print("You concentrate on the trump of a greater undead being...");
#endif


			if (summon_specific((pet ? -1 : 0), py, px, plev, type, group, FALSE, pet))
			{
				if (!pet)
#ifdef JP
msg_print("Ԥ줿ϤʥǥåɤܤäƤ롪");
#else
					msg_print("The summoned greater undead creature gets angry!");
#endif

			}
			else
			{
				no_trump = TRUE;
			}

			break;
		}
		default:
#ifdef JP
msg_format("̤ΤΥɤμʸǤ: %d", spell);
#else
			msg_format("You cast an unknown Trump spell: %d.", spell);
#endif

			msg_print(NULL);
	}

	if (no_trump)
	{
#ifdef JP
msg_print("ï⤢ʤΥɤθƤʤ");
#else
		msg_print("Nobody answers to your Trump call.");
#endif

	}

	return TRUE;
}


static bool cast_arcane_spell(int spell)
{
	int	dir;
	int	beam;
	int	plev = p_ptr->lev;
	int	dummy = 0;

	if (p_ptr->pclass == CLASS_MAGE) beam = plev;
	else if (p_ptr->pclass == CLASS_HIGH_MAGE) beam = plev + 10;
	else beam = plev / 2;

	switch (spell)
	{
	case 0: /* Zap */
		if (!get_aim_dir(&dir)) return FALSE;

		fire_bolt_or_beam(beam - 10, GF_ELEC, dir,
			damroll(3 + ((plev - 1) / 5), 3));
		break;
	case 1: /* Wizard Lock */
		if (!get_aim_dir(&dir)) return FALSE;

		(void)wizard_lock(dir);
		break;
	case 2: /* Detect Invisibility */
		(void)detect_monsters_invis();
		break;
	case 3: /* Detect Monsters */
		(void)detect_monsters_normal();
		break;
	case 4: /* Blink */
		teleport_player(10);
		break;
	case 5: /* Light Area */
		(void)lite_area(damroll(2, (plev / 2)), (plev / 10) + 1);
		break;
	case 6: /* Trap & Door Destruction */
		if (!get_aim_dir(&dir)) return FALSE;

		(void)destroy_door(dir);
		break;
	case 7: /* Cure Light Wounds */
		(void)hp_player(damroll(2, 8));
		(void)set_cut(p_ptr->cut - 10);
		break;
	case 8: /* Detect Doors & Traps */
		(void)detect_traps();
		(void)detect_doors();
		(void)detect_stairs();
		break;
	case 9: /* Phlogiston */
		phlogiston();
		break;
	case 10: /* Detect Treasure */
		(void)detect_treasure();
		(void)detect_objects_gold();
		break;
	case 11: /* Detect Enchantment */
		(void)detect_objects_magic();
		break;
	case 12: /* Detect Object */
		(void)detect_objects_normal();
		break;
	case 13: /* Cure Poison */
		(void)set_poisoned(0);
		break;
	case 14: /* Resist Cold */
		(void)set_oppose_cold(p_ptr->oppose_cold + randint(20) + 20);
		break;
	case 15: /* Resist Fire */
		(void)set_oppose_fire(p_ptr->oppose_fire + randint(20) + 20);
		break;
	case 16: /* Resist Lightning */
		(void)set_oppose_elec(p_ptr->oppose_elec + randint(20) + 20);
		break;
	case 17: /* Resist Acid */
		(void)set_oppose_acid(p_ptr->oppose_acid + randint(20) + 20);
		break;
	case 18: /* Cure Medium Wounds */
		(void)hp_player(damroll(4, 8));
		(void)set_cut((p_ptr->cut / 2) - 50);
		break;
	case 19: /* Teleport */
		teleport_player(plev * 5);
		break;
	case 20: /* Stone to Mud */
		if (!get_aim_dir(&dir)) return FALSE;

		(void)wall_to_mud(dir);
		break;
	case 21: /* Ray of Light */
		if (!get_aim_dir(&dir)) return FALSE;

#ifdef JP
msg_print("줿");
#else
		msg_print("A line of light appears.");
#endif

		(void)lite_line(dir);
		break;
	case 22: /* Satisfy Hunger */
		(void)set_food(PY_FOOD_MAX - 1);
		break;
	case 23: /* See Invisible */
		(void)set_tim_invis(p_ptr->tim_invis + randint(24) + 24);
		break;
	case 24: /* Recharging */
		return recharge(plev * 4);
	case 25: /* Teleport Level */
		(void)teleport_player_level();
		break;
	case 26: /* Identify */
		return ident_spell();
	case 27: /* Teleport Away */
		if (!get_aim_dir(&dir)) return FALSE;

		(void)fire_beam(GF_AWAY_ALL, dir, plev);
		break;
	case 28: /* Elemental Ball */
		if (!get_aim_dir(&dir)) return FALSE;

		switch (randint(4))
		{
			case 1:  dummy = GF_FIRE; break;
			case 2:  dummy = GF_ELEC; break;
			case 3:  dummy = GF_COLD; break;
			default: dummy = GF_ACID; break;
		}
		fire_ball(dummy, dir, 75 + (plev), 2);
		break;
	case 29: /* Detection */
		(void)detect_all();
		break;
	case 30: /* Word of Recall */
		word_of_recall();
		break;
	case 31: /* Clairvoyance */
		wiz_lite();
		if (!p_ptr->telepathy)
		{
			(void)set_tim_esp(p_ptr->tim_esp + randint(30) + 25);
		}
		break;
	default:
		msg_format("You cast an unknown Arcane spell: %d.", spell);
		msg_print(NULL);
	}

	return TRUE;
}
#endif /* 0 */

/*
 * Cast a spell
 */
void do_cmd_cast(void)
{
	int	item, sval, spell, realm;
	int	chance;
	int	increment = 0;
	int	use_realm;
	bool cast;

#ifdef JP
	const cptr prayer = ((mp_ptr->spell_book == TV_LIFE_BOOK) ? "" : "ʸ");
#else
	const cptr prayer = ((mp_ptr->spell_book == TV_LIFE_BOOK) ? "prayer" : "spell");
#endif


	object_type	*o_ptr;

	magic_type	*s_ptr;

	cptr q, s;

	/* Require spell ability */
	if (!p_ptr->realm1)
	{
#ifdef JP
msg_print("ʸ򾧤ʤ");
#else
		msg_print("You cannot cast spells!");
#endif

		return;
	}

	/* Require lite */
	if (p_ptr->blind || no_lite())
	{
#ifdef JP
msg_print("ܤʤ");
#else
		msg_print("You cannot see!");
#endif

		return;
	}

	/* Not when confused */
	if (p_ptr->confused)
	{
#ifdef JP
msg_print("𤷤ƤƳؤ٤ʤ");
#else
		msg_print("You are too confused!");
#endif

		return;
	}

	/* Restrict choices to spell books */
	item_tester_tval = mp_ptr->spell_book;

	/* Get an item */
#ifdef JP
q = "ɤμʸȤޤ? ";
#else
	q = "Use which book? ";
#endif

#ifdef JP
s = "ʸ񤬤ʤ";
#else
	s = "You have no spell books!";
#endif

	select_spellbook = TRUE;
	if (!get_item(&item, q, s, (USE_INVEN | USE_FLOOR)))
	{
		select_spellbook = FALSE;
		return;
	}
	select_spellbook = FALSE;

	/* Get the item (in the pack) */
	if (item >= 0)
	{
		o_ptr = &inventory[item];
	}

	/* Get the item (on the floor) */
	else
	{
		o_ptr = &o_list[0 - item];
	}

	/* Access the item's sval */
	sval = o_ptr->sval;

#if 0
	if (o_ptr->tval == REALM2_BOOK) increment = 32;
#endif


	/* Track the object kind */
	object_kind_track(o_ptr->k_idx);

	/* Hack -- Handle stuff */
	handle_stuff();

	if (increment) realm = p_ptr->realm2;
	else realm = p_ptr->realm1;

	/* Ask for a spell */
#ifdef JP
        if (!get_spell(&spell,  
		                ((mp_ptr->spell_book == TV_LIFE_BOOK) ? "Ӿ" : ""),
		       sval, TRUE, realm))
        {
                if (spell == -2) msg_format("ܤˤΤäƤ%sʤ", prayer);
                return;
        }
#else
	if (!get_spell(&spell, ((mp_ptr->spell_book == TV_LIFE_BOOK) ? "recite" : "cast"),
		sval, TRUE, realm))
	{
		if (spell == -2)
			msg_format("You don't know any %ss in that book.", prayer);
		return;
	}
#endif



	/* Access the spell */
	use_realm = (increment?p_ptr->realm2:p_ptr->realm1);

	s_ptr = &mp_ptr->info[use_realm - 1][spell];


	/* Verify "dangerous" spells */
	if (s_ptr->smana > p_ptr->csp)
	{
		/* Warning */
#ifdef JP
msg_format("%s%sΤ˽ʬʥޥåݥȤʤ",prayer,
((mp_ptr->spell_book == TV_LIFE_BOOK) ? "Ӿ" : ""));
#else
		msg_format("You do not have enough mana to %s this %s.",
			((mp_ptr->spell_book == TV_LIFE_BOOK) ? "recite" : "cast"),
			prayer);
#endif

		if (!over_exert) return;


		/* Verify */
#ifdef JP
if (!get_check("Ǥĩ路ޤ? ")) return;
#else
		if (!get_check("Attempt it anyway? ")) return;
#endif

	}


	/* Spell failure chance */
	chance = spell_chance(spell, use_realm - 1);

	/* Failed spell */
	if (rand_int(100) < chance)
	{
		if (flush_failure) flush();

#ifdef JP
msg_format("%s򤦤ޤʤä", prayer);
#else
		msg_format("You failed to get the %s off!", prayer);
#endif

		sound(SOUND_FAIL);

		if ((randint(100) < chance) && (mp_ptr->spell_book == TV_LIFE_BOOK))
			chg_virtue(V_FAITH, -1);
		else if (randint(100) < chance)
			chg_virtue(V_KNOWLEDGE, -1);


#if 0
		if (realm == REALM_TRUMP)
		{
			cast_trump_spell(spell, FALSE);
		}
		else if ((o_ptr->tval == TV_CHAOS_BOOK) && (randint(100) < spell))
		{
#ifdef JP
msg_print("Ūʸ̤ȯ");
#else
			msg_print("You produce a chaotic effect!");
#endif

			wild_magic(spell);
		}
		else if ((o_ptr->tval == TV_DEATH_BOOK) && (randint(100) < spell))
		{
			if ((sval == 3) && (randint(2) == 1))
			{
				sanity_blast(0, TRUE);
			}
			else
			{
#ifdef JP
				msg_print("ˤ");
#else
				msg_print("It hurts!");
#endif

#ifdef JP
				take_hit(damroll(o_ptr->sval + 1, 6), "Źˡεή");
#else
				take_hit(damroll(o_ptr->sval + 1, 6), "a miscast Death spell");
#endif

				if ((spell > 15) && (randint(6) == 1) && !p_ptr->hold_life)
					lose_exp(spell * 250);
			}
		}
#endif /* 0 */
	}

	/* Process spell */
	else
	{
		if ((randint(100) < chance) && (chance < 50))
		{
			if (mp_ptr->spell_book == TV_LIFE_BOOK)
				chg_virtue(V_FAITH, 1);
			else
				chg_virtue(V_KNOWLEDGE, 1);
		}

		/* Spells.  */
		switch (realm)
		{
		case REALM_LIFE: /* * LIFE * */
			cast = cast_life_spell(spell);
			break;
		case REALM_SORCERY: /* * SORCERY * */
			cast = cast_sorcery_spell(spell);
			break;
		case REALM_MUSOU: /* * MUSOU * */
			cast = cast_musou_spell(spell);
			break;
#if 0
		case REALM_CHAOS: /* * CHAOS * */
			cast = cast_chaos_spell(spell);
			break;
		case REALM_DEATH: /* * DEATH * */
			cast = cast_death_spell(spell);
			break;
		case REALM_TRUMP: /* TRUMP */
			cast = cast_trump_spell(spell, TRUE);
			break;
		case REALM_ARCANE: /* ARCANE */
			cast = cast_arcane_spell(spell);
			break;
#endif
		default:
			cast = FALSE;
			msg_format("You cast a spell from an unknown realm: realm %d, spell %d.", realm, spell);
			msg_print(NULL);
		}

		/* Canceled spells cost neither a turn nor mana */
		if (!cast) return;

		/* A spell was cast */
		if (!(increment ?
		    (spell_worked2 & (1L << spell)) :
		    (spell_worked1 & (1L << spell))))
		{
			int e = s_ptr->sexp;

			/* The spell worked */
			if (realm == p_ptr->realm1)
			{
				spell_worked1 |= (1L << spell);
			}
			else
			{
				spell_worked2 |= (1L << spell);
			}

			/* Gain experience */
			gain_exp(e * s_ptr->slevel);

			if (mp_ptr->spell_book == TV_LIFE_BOOK)
				chg_virtue(V_FAITH, 1);
			else
				chg_virtue(V_KNOWLEDGE, 1);
		}
	}

	/* Take a turn */
	energy_use = 100;

	/* Sufficient mana */
	if (s_ptr->smana <= p_ptr->csp)
	{
		/* Use some mana */
		p_ptr->csp -= s_ptr->smana;
	}

	/* Over-exert the player */
	else
	{
		int oops = s_ptr->smana - p_ptr->csp;

		/* No mana left */
		p_ptr->csp = 0;
		p_ptr->csp_frac = 0;

		/* Message */
#ifdef JP
msg_print("椷Ƶ򼺤äƤޤä");
#else
		msg_print("You faint from the effort!");
#endif


		/* Hack -- Bypass free action */
		(void)set_paralyzed(p_ptr->paralyzed + randint(5 * oops + 1));

		if (mp_ptr->spell_book == TV_LIFE_BOOK)
			chg_virtue(V_FAITH, -10);
		else
			chg_virtue(V_KNOWLEDGE, -10);

		/* Damage CON (possibly permanently) */
		if (rand_int(100) < 50)
		{
			bool perm = (rand_int(100) < 25);

			/* Message */
#ifdef JP
msg_print("Τ򰭤Ƥޤä");
#else
			msg_print("You have damaged your health!");
#endif


			/* Reduce constitution */
			(void)dec_stat(A_CON, 15 + randint(10), perm);
		}
	}

	/* Redraw mana */
	p_ptr->redraw |= (PR_MANA);

	/* Window stuff */
	p_ptr->window |= (PW_PLAYER);
	p_ptr->window |= (PW_SPELL);
}


/*
 * Pray a prayer -- Unused in Zangband
 */
void do_cmd_pray(void)
{
	msg_print("Praying is not used in Zangband. Use magic spell casting instead.");
}


/*
 * Issue a pet command
 */
void do_cmd_pet(void)
{
	int			i = 0;
	int			num;
	int			powers[36];
	cptr			power_desc[36];
	bool			flag, redraw;
	int			ask;
	char			choice;
	char			out_val[160];
	int			pets = 0, pet_ctr;
	bool			all_pets = FALSE;
	monster_type	*m_ptr;

	int mode = 0;

	byte y = 1, x = 0;
	int ctr = 0;
	char buf[160];

	num = 0;

	/* Calculate pets */
	/* Process the monsters (backwards) */
	for (pet_ctr = m_max - 1; pet_ctr >= 1; pet_ctr--)
	{
		/* Access the monster */
		m_ptr = &m_list[pet_ctr];

		if (is_pet(m_ptr)) pets++;
	}

	if (pets)
	{
#ifdef JP
		power_desc[num] = "ڥåȤ";
#else
		power_desc[num] = "dismiss pets";
#endif

		powers[num++] = PET_DISMISS;
	}

#ifdef JP
power_desc[num] = "᤯ˤ";
#else
	power_desc[num] = "stay close";
#endif

	if (p_ptr->pet_follow_distance == PET_CLOSE_DIST) mode = num;
	powers[num++] = PET_STAY_CLOSE;

#ifdef JP
	power_desc[num] = "Ĥ褤";
#else
	power_desc[num] = "follow me";
#endif

	if (p_ptr->pet_follow_distance == PET_FOLLOW_DIST) mode = num;
	powers[num++] = PET_FOLLOW_ME;

#ifdef JP
power_desc[num] = "Ũ򸫤Ĥݤ";
#else
	power_desc[num] = "seek and destroy";
#endif

	if (p_ptr->pet_follow_distance == PET_DESTROY_DIST) mode = num;
	powers[num++] = PET_SEEK_AND_DESTROY;

#ifdef JP
power_desc[num] = "ΥƤ";
#else
	power_desc[num] = "give me space";
#endif

	if (p_ptr->pet_follow_distance == PET_SPACE_DIST) mode = num;
	powers[num++] = PET_ALLOW_SPACE;

#ifdef JP
power_desc[num] = "ΥƤ";
#else
	power_desc[num] = "stay away";
#endif

	if (p_ptr->pet_follow_distance == PET_AWAY_DIST) mode = num;
	powers[num++] = PET_STAY_AWAY;

	if (p_ptr->pet_open_doors)
	{
#ifdef JP
		power_desc[num] = "ɥ򳫤";
#else
		power_desc[num] = "pets may open doors";
#endif

	}
	else
	{
#ifdef JP
		power_desc[num] = "ɥ򳫤ʤ";
#else
		power_desc[num] = "pets may not open doors";
#endif

	}
	powers[num++] = PET_OPEN_DOORS;

	if (p_ptr->pet_pickup_items)
	{
#ifdef JP
		power_desc[num] = "ƥ򽦤碌";
#else
		power_desc[num] = "pets may pick up items";
#endif

	}
	else
	{
#ifdef JP
		power_desc[num] = "ƥ򽦤碌ʤ";
#else
		power_desc[num] = "pets may not pick up items";
#endif

	}
	powers[num++] = PET_TAKE_ITEMS;

	/* Nothing chosen yet */
	flag = FALSE;

	/* Build a prompt (accept all spells) */
	if (num <= 26)
	{
		/* Build a prompt (accept all spells) */
#ifdef JP
strnfmt(out_val, 78, "(ޥ %c-%c'*'=ESC=λ) ޥɤǤ:",
#else
		strnfmt(out_val, 78, "(Command %c-%c, *=List, ESC=exit) Select a command: ",
#endif

			I2A(0), I2A(num - 1));
	}
	else
	{
#ifdef JP
strnfmt(out_val, 78, "(ޥ %c-%c'*'=ESC=λ) ޥɤǤ:",
#else
		strnfmt(out_val, 78, "(Command %c-%c, *=List, ESC=exit) Select a command: ",
#endif

			I2A(0), '0' + num - 27);
	}

	/* Show list */
	redraw = TRUE;

	/* Save the screen */
	Term_save();

	prt("", y++, x);

	while (ctr < num)
	{
		sprintf(buf, "%s%c) %s", (ctr == mode) ? "*" : " ", I2A(ctr), power_desc[ctr]);
		prt(buf, y + ctr, x);
		ctr++;
	}

	if (ctr < 17)
	{
		prt("", y + ctr, x);
	}
	else
	{
		prt("", y + 17, x);
	}

	/* Get a command from the user */
	while (!flag && get_com(out_val, &choice))
	{
		/* Request redraw */
		if ((choice == ' ') || (choice == '*') || (choice == '?'))
		{
			/* Show the list */
			if (!redraw)
			{
				y = 1;
				x = 0;
				ctr = 0;

				/* Show list */
				redraw = TRUE;

				/* Save the screen */
				Term_save();

				prt("", y++, x);

				while (ctr < num)
				{
					sprintf(buf, "%s%c) %s", (ctr == mode) ? "*" : " ", I2A(ctr), power_desc[ctr]);
					prt(buf, y + ctr, x);
					ctr++;
				}

				if (ctr < 17)
				{
					prt("", y + ctr, x);
				}
				else
				{
					prt("", y + 17, x);
				}
			}

			/* Hide the list */
			else
			{
				/* Hide list */
				redraw = FALSE;

				/* Restore the screen */
				Term_load();
			}

			/* Redo asking */
			continue;
		}

		if (choice == '\r' && num == 1)
		{
			choice = 'a';
		}

		if (isalpha(choice))
		{
			/* Note verify */
			ask = (isupper(choice));

			/* Lowercase */
			if (ask) choice = tolower(choice);

			/* Extract request */
			i = (islower(choice) ? A2I(choice) : -1);
		}
		else
		{
			ask = FALSE; /* Can't uppercase digits */

			i = choice - '0' + 26;
		}

		/* Totally Illegal */
		if ((i < 0) || (i >= num))
		{
			bell();
			continue;
		}

		/* Verify it */
		if (ask)
		{
			/* Prompt */
#ifdef JP
			strnfmt(buf, 78, "%sȤޤ ", power_desc[i]);
#else
			strnfmt(buf, 78, "Use %s? ", power_desc[i]);
#endif


			/* Belay that order */
			if (!get_check(buf)) continue;
		}

		/* Stop the loop */
		flag = TRUE;
	}

	/* Restore the screen */
	if (redraw) Term_load();

	/* Abort if needed */
	if (!flag)
	{
		energy_use = 0;
		return;
	}

	switch (powers[i])
	{
		case PET_DISMISS: /* Dismiss pets */
		{
			int Dismissed = 0;

#ifdef JP
if (get_check("٤ƤΥڥåȤޤ")) all_pets = TRUE;
#else
			if (get_check("Dismiss all pets? ")) all_pets = TRUE;
#endif


			/* Process the monsters (backwards) */
			for (pet_ctr = m_max - 1; pet_ctr >= 1; pet_ctr--)
			{
				/* Access the monster */
				m_ptr = &m_list[pet_ctr];

				if (is_pet(m_ptr))
				{
					bool delete_this = FALSE;

					if (all_pets)
						delete_this = TRUE;
					else
					{
						char friend_name[80], check_friend[80];
						monster_desc(friend_name, m_ptr, 0x80);
#ifdef JP
sprintf(check_friend, "%sޤ ", friend_name);
#else
						sprintf(check_friend, "Dismiss %s? ", friend_name);
#endif


						if (get_check(check_friend))
							delete_this = TRUE;
					}

					if (delete_this)
					{
						delete_monster_idx(pet_ctr);
						Dismissed++;
					}
				}
			}

#ifdef JP
msg_format("%d ɤΥڥåȤޤ", Dismissed);
#else
			msg_format("You have dismissed %d pet%s.", Dismissed,
				(Dismissed == 1 ? "" : "s"));
#endif

			break;
		}
		/* Call pets */
		case PET_STAY_CLOSE:
		{
			p_ptr->pet_follow_distance = PET_CLOSE_DIST;
			break;
		}
		/* "Follow Me" */
		case PET_FOLLOW_ME:
		{
			p_ptr->pet_follow_distance = PET_FOLLOW_DIST;
			break;
		}
		/* "Seek and destoy" */
		case PET_SEEK_AND_DESTROY:
		{
			p_ptr->pet_follow_distance = PET_DESTROY_DIST;
			break;
		}
		/* "Give me space" */
		case PET_ALLOW_SPACE:
		{
			p_ptr->pet_follow_distance = PET_SPACE_DIST;
			break;
		}
		/* "Stay away" */
		case PET_STAY_AWAY:
		{
			p_ptr->pet_follow_distance = PET_AWAY_DIST;
			break;
		}
		/* flag - allow pets to open doors */
		case PET_OPEN_DOORS:
		{
			p_ptr->pet_open_doors = !p_ptr->pet_open_doors;
			break;
		}
		/* flag - allow pets to pickup items */
		case PET_TAKE_ITEMS:
		{
			p_ptr->pet_pickup_items = !p_ptr->pet_pickup_items;

			/* Drop objects being carried by pets */
			if (!p_ptr->pet_pickup_items)
			{
				for (pet_ctr = m_max - 1; pet_ctr >= 1; pet_ctr--)
				{
					/* Access the monster */
					m_ptr = &m_list[pet_ctr];

					if (is_pet(m_ptr))
					{
						monster_drop_carried_objects(m_ptr);
					}
				}
			}

			break;
		}
	}
}

