/*
 * Decompiled with CFR 0.152.
 */
package org.xerial.util.cui;

import java.util.List;
import org.xerial.util.cui.OptionComposite;
import org.xerial.util.cui.OptionDescriptionContainer;
import org.xerial.util.cui.OptionGroup;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class Option<OptionID extends Comparable>
extends OptionComposite<OptionID> {
    private OptionID _optionID;
    private boolean _flag = false;
    protected String _shortName;
    protected String _longName;
    private String _description;

    public Option(OptionGroup<OptionID> parentGroup, OptionID optionID, String shortOptionName, String longOptionName, String description) {
        super(parentGroup);
        this.setValue(optionID, shortOptionName, longOptionName, description, false);
    }

    public Option(OptionGroup<OptionID> parentGroup, OptionID optionID, String shortOptionName, String longOptionName, String description, boolean presetValue) {
        super(parentGroup);
        this.setValue(optionID, shortOptionName, longOptionName, description, presetValue);
    }

    private void setValue(OptionID optionID, String shortOptionName, String longOptionName, String description, boolean presetValue) {
        this._optionID = optionID;
        this._shortName = shortOptionName;
        this._longName = longOptionName;
        this._description = description;
        this._flag = presetValue;
    }

    public boolean isSet() {
        return this._flag;
    }

    public void set() {
        this._flag = true;
        this.activateParentGroup();
    }

    public OptionID getOptionID() {
        return this._optionID;
    }

    public boolean takeArgument() {
        return false;
    }

    @Override
    protected Option<OptionID> findByLongOptionName(String longOption) {
        if (this._longName.equals(longOption)) {
            return this;
        }
        return null;
    }

    @Override
    protected Option<OptionID> findByShortOptionName(String shortOption) {
        if (this._shortName.equals(shortOption)) {
            return this;
        }
        return null;
    }

    @Override
    protected Option<OptionID> findOption(OptionID optionID) {
        if (optionID.compareTo(this._optionID) == 0) {
            return this;
        }
        return null;
    }

    @Override
    protected void collectOptionID(List<OptionID> optionIDList) {
        optionIDList.add(this._optionID);
    }

    @Override
    protected void collectOptionDescriptions(OptionDescriptionContainer container) {
        container.addDescription(this.getShortOptionName(), this.getLongOptionName(), this.getDescription());
    }

    public String getLongOptionName() {
        return this._longName.equals("") ? "" : "--" + this._longName;
    }

    public String getShortOptionName() {
        return this._shortName.equals("") ? "" : "-" + this._shortName + (this._longName.equals("") ? " " : ", ");
    }

    public String getDescription() {
        return this._description;
    }
}

