/*
 * Decompiled with CFR 0.152.
 */
package org.xerial.util.xml.bean;

import java.io.OutputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.HashMap;
import java.util.Set;
import java.util.TreeSet;
import org.xerial.algorithm.Algorithm;
import org.xerial.util.xml.InvalidXMLException;
import org.xerial.util.xml.XMLAttribute;
import org.xerial.util.xml.XMLGenerator;
import org.xerial.util.xml.bean.OutputRule;
import org.xerial.util.xml.bean.OutputRuleSet;
import org.xerial.util.xml.bean.OutputRuleType;
import org.xerial.util.xml.bean.XMLBeanException;
import org.xerial.util.xml.bean.XMLBeanUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class XMLOutputProcess {
    HashMap<Class, OutputRuleSet> _outputRuleOfEachClass = new HashMap();
    XMLGenerator _xmlOut;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    public XMLOutputProcess(OutputStream out) {
        this._xmlOut = new XMLGenerator(out);
    }

    public void outputAsXML(Object xmlBean) throws XMLBeanException, InvalidXMLException {
        if (xmlBean == null) {
            return;
        }
        this.inspectGettersInXMLBean(xmlBean);
        Class<?> xmlBeanClass = xmlBean.getClass();
        OutputRuleSet outputRuleSet = this._outputRuleOfEachClass.get(xmlBeanClass);
        if (outputRuleSet == null) {
            throw new XMLBeanException("cannot create any output rule for the class ", xmlBeanClass.getName());
        }
        String className = xmlBeanClass.getSimpleName();
        XMLAttribute attrib = new XMLAttribute();
        for (OutputRule attribRule : outputRuleSet.getAttributeRules()) {
            Object value = null;
            try {
                value = ((Method)attribRule.getSecond()).invoke(xmlBean, new Object[0]);
                if (value == null) continue;
                attrib.add((String)attribRule.getThird(), value.toString());
            }
            catch (IllegalArgumentException e) {
                e.printStackTrace();
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
            catch (InvocationTargetException e) {
                e.printStackTrace();
            }
        }
        this._xmlOut.startTag(String.valueOf(className.substring(0, 1).toLowerCase()) + className.substring(1), attrib);
        block16: for (OutputRule rule : outputRuleSet.getElementRules()) {
            OutputRuleType ruleType = (OutputRuleType)((Object)rule.getFirst());
            Method getter = (Method)rule.getSecond();
            String elementName = (String)rule.getThird();
            try {
                switch (ruleType.ordinal()) {
                    case 0: {
                        Object contentObj = getter.invoke(xmlBean, new Object[0]);
                        if (contentObj == null) break;
                        this._xmlOut.element(elementName, contentObj.toString());
                        break;
                    }
                    case 1: {
                        Collection c = (Collection)getter.invoke(xmlBean, new Object[0]);
                        for (Object obj : c) {
                            this.outputAsXML(c);
                        }
                        continue block16;
                    }
                    case 2: {
                        Object[] array;
                        Object[] objectArray = array = (Object[])getter.invoke(xmlBean, new Object[0]);
                        int n = 0;
                        int n2 = objectArray.length;
                        while (n < n2) {
                            Object obj = objectArray[n];
                            if (obj != null) {
                                this._xmlOut.element(elementName, obj.toString());
                            }
                            ++n;
                        }
                        continue block16;
                    }
                    case 3: {
                        Object nestedBean = getter.invoke(xmlBean, new Object[0]);
                        this.outputAsXML(nestedBean);
                        break;
                    }
                    case 4: {
                        Object[] arrayBean;
                        Object[] objectArray = arrayBean = (Object[])getter.invoke(xmlBean, new Object[0]);
                        int n = 0;
                        int n3 = objectArray.length;
                        while (n < n3) {
                            Object obj = objectArray[n];
                            this.outputAsXML(obj);
                            ++n;
                        }
                        continue block16;
                    }
                }
            }
            catch (IllegalArgumentException e) {
                e.printStackTrace();
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
            catch (InvocationTargetException e) {
                e.printStackTrace();
            }
        }
        this._xmlOut.endTag();
        this._xmlOut.flush();
    }

    protected void inspectGettersInXMLBean(Object xmlBean) {
        Method[] method;
        Class<?> beanClass = xmlBean.getClass();
        if (this._outputRuleOfEachClass.containsKey(beanClass)) {
            return;
        }
        OutputRuleSet outputRuleSet = new OutputRuleSet(beanClass);
        this._outputRuleOfEachClass.put(beanClass, outputRuleSet);
        Set<String> attributeNameSet = this.inspectAttributeNames(xmlBean);
        Method[] methodArray = method = beanClass.getMethods();
        int n = 0;
        int n2 = methodArray.length;
        while (n < n2) {
            String tagOrAttributeName;
            Class<?>[] parameterType;
            Method m = methodArray[n];
            String methodName = m.getName();
            if (!methodName.equals("getClass") && methodName.startsWith("get") && methodName.length() > 3 && (parameterType = m.getParameterTypes()).length == 0 && (tagOrAttributeName = XMLBeanUtil.pickPropertyName(methodName, XMLBeanUtil.SetterOrGetter.get)) != null) {
                Class<?> returnType = m.getReturnType();
                if (XMLBeanUtil.isPrimitive(returnType)) {
                    if (returnType.isArray()) {
                        outputRuleSet.addElementRule(OutputRuleType.iterateOverPrimitiveArray, m, tagOrAttributeName);
                    } else if (attributeNameSet.contains(tagOrAttributeName)) {
                        outputRuleSet.addAttributeRule(OutputRuleType.outputAsPrimitive, m, tagOrAttributeName);
                    } else {
                        outputRuleSet.addElementRule(OutputRuleType.outputAsPrimitive, m, tagOrAttributeName);
                    }
                } else if (Collection.class.isAssignableFrom(returnType)) {
                    outputRuleSet.addElementRule(OutputRuleType.iterateOverCollection, m, tagOrAttributeName);
                } else if (returnType.isArray()) {
                    outputRuleSet.addElementRule(OutputRuleType.arrayBean, m, tagOrAttributeName);
                } else if (attributeNameSet.contains(tagOrAttributeName)) {
                    outputRuleSet.addAttributeRule(OutputRuleType.outputAsPrimitive, m, tagOrAttributeName);
                } else {
                    outputRuleSet.addElementRule(OutputRuleType.nestedBean, m, tagOrAttributeName);
                }
            }
            ++n;
        }
        this._outputRuleOfEachClass.put(beanClass, outputRuleSet);
    }

    protected Set<String> inspectAttributeNames(Object xmlBean) {
        Class<?> beanClass = xmlBean.getClass();
        TreeSet<String> attributeNameSet = new TreeSet<String>();
        try {
            Method attributeNameGetter = beanClass.getMethod("attributes", new Class[0]);
            Object ret = attributeNameGetter.invoke(xmlBean, new Object[0]);
            Class<?> attributeNameArrayClass = ret.getClass();
            if (attributeNameArrayClass.isArray() && attributeNameArrayClass.getComponentType().equals(String.class)) {
                Algorithm.add(attributeNameSet, (String[])ret);
            }
        }
        catch (SecurityException securityException) {
        }
        catch (NoSuchMethodException noSuchMethodException) {
        }
        catch (IllegalArgumentException illegalArgumentException) {
        }
        catch (IllegalAccessException illegalAccessException) {
        }
        catch (InvocationTargetException invocationTargetException) {
            // empty catch block
        }
        return attributeNameSet;
    }
}

