/*
 * Decompiled with CFR 0.152.
 */
package org.xerial.index;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.NoSuchElementException;
import org.xerial.algorithm.Algorithm;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InvertedPath
implements Comparable<InvertedPath>,
Iterable<String> {
    private LinkedList<String> _path = new LinkedList();

    public InvertedPath() {
    }

    public InvertedPath(String stringRepresentationOfInvertedPath) {
        String[] pathComponent;
        String[] stringArray = pathComponent = stringRepresentationOfInvertedPath.split("\\.");
        int n = 0;
        int n2 = stringArray.length;
        while (n < n2) {
            String c = stringArray[n];
            this.addParent(c);
            ++n;
        }
    }

    public InvertedPath(InvertedPath invertedPath) {
        for (String s : invertedPath) {
            this.addParent(s);
        }
    }

    public void addParent(String tagName) {
        this._path.add(tagName);
    }

    public void addChild(String tagName) {
        this._path.addFirst(tagName);
    }

    public String getLastParent() {
        if (this._path.isEmpty()) {
            return "";
        }
        return this._path.getLast();
    }

    public void removeLastParent() throws NoSuchElementException {
        if (this._path.isEmpty()) {
            throw new NoSuchElementException("empty path");
        }
        this._path.removeLast();
    }

    public void removeFirstChild() throws NoSuchElementException {
        if (this._path.isEmpty()) {
            throw new NoSuchElementException("empty path");
        }
        this._path.removeFirst();
    }

    public Integer size() {
        return this._path.size();
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        for (String tag : this._path) {
            builder.append(".");
            builder.append(tag);
        }
        if (builder.length() > 1) {
            return builder.substring(1);
        }
        return "";
    }

    @Override
    public int compareTo(InvertedPath other) {
        return Algorithm.lexicographicalCompare(this.getPath(), other.getPath());
    }

    public boolean equals(Object obj) {
        InvertedPath other = (InvertedPath)obj;
        if (obj == null) {
            return false;
        }
        return this.compareTo(other) == 0;
    }

    private LinkedList<String> getPath() {
        return this._path;
    }

    protected InvertedPath clone() throws CloneNotSupportedException {
        InvertedPath newPath = new InvertedPath();
        newPath._path = (LinkedList)this._path.clone();
        return newPath;
    }

    @Override
    public Iterator<String> iterator() {
        return this._path.iterator();
    }
}

