/*
 * Decompiled with CFR 0.152.
 */
package org.xerial.index;

import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.Reader;
import java.util.Set;
import java.util.TreeMap;
import org.xerial.XerialException;
import org.xerial.index.InvertedPath;
import org.xerial.util.StringUtil;
import org.xerial.util.cui.OptionParser;
import org.xerial.util.cui.OptionParserException;
import org.xerial.util.graph.AdjacencyList;
import org.xerial.util.graph.GraphException;
import org.xerial.util.xml.XMLException;
import org.xerial.util.xml.pullparser.PullParserUtil;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InvertedPathTree {
    AdjacencyList _pathTree = new AdjacencyList();
    TreeMap<InvertedPath, Integer> _path2idMap = new TreeMap();
    TreeMap<Integer, InvertedPath> _id2pathMap = new TreeMap();
    InvertedPath _currentInvertedPath = new InvertedPath();
    int _rootID = this._pathTree.addVertex();

    public InvertedPathTree() {
        InvertedPath rootPath = new InvertedPath();
        this._path2idMap.put(rootPath, this._rootID);
        this._id2pathMap.put(this._rootID, rootPath);
    }

    public void generateFrom(String xmlFile) throws XMLException, GraphException, FileNotFoundException, IOException {
        this.generateFrom(new BufferedReader(new FileReader(xmlFile)));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void generateFrom(Reader xmlReader) throws IOException, XMLException, GraphException {
        XmlPullParser parser = PullParserUtil.newParser(xmlReader);
        try {
            block7: while (true) {
                int state;
                if ((state = parser.next()) == 1) {
                    return;
                }
                switch (state) {
                    case 2: {
                        this._currentInvertedPath.addChild(parser.getName());
                        int i = 0;
                        while (true) {
                            if (i >= parser.getAttributeCount()) continue block7;
                            this._currentInvertedPath.addChild("@" + parser.getAttributeName(i));
                            this.updateInvertedPathTree();
                            this._currentInvertedPath.removeFirstChild();
                            ++i;
                        }
                    }
                    case 3: {
                        this.updateInvertedPathTree();
                        this._currentInvertedPath.removeFirstChild();
                        continue block7;
                    }
                }
            }
        }
        catch (XmlPullParserException e) {
            throw new XMLException(e);
        }
        catch (GraphException e) {
            throw e;
        }
    }

    private void updateInvertedPathTree() throws GraphException {
        int cursor = this._rootID;
        InvertedPath cursorPath = new InvertedPath();
        for (String tag : this._currentInvertedPath) {
            cursorPath.addParent(tag);
            Set<Integer> destNodeID = this._pathTree.destNodeSet(cursor);
            int pathID = this.getPathID(cursorPath);
            if (!destNodeID.contains(pathID)) {
                this._pathTree.addEdge(cursor, pathID);
            }
            cursor = pathID;
        }
    }

    private int getPathID(InvertedPath path) {
        Integer pathID = this._path2idMap.get(path);
        if (pathID == null) {
            pathID = this._pathTree.addVertex();
            InvertedPath clonePath = new InvertedPath(path);
            this._path2idMap.put(clonePath, pathID);
            this._id2pathMap.put(pathID, clonePath);
        }
        return pathID;
    }

    public void outputGraphviz(OutputStream os) {
        PrintStream out = new PrintStream(os);
        out.println("digraph G {");
        for (int pathID : this._id2pathMap.keySet()) {
            InvertedPath path = this._id2pathMap.get(pathID);
            assert (path != null);
            out.println(String.valueOf(pathID) + " [label=" + StringUtil.quote(path.getLastParent(), "\"") + "];");
        }
        int cursor = this._rootID;
        this.outputGraphvizEdges(out, this._rootID);
        out.println("}");
        out.flush();
    }

    private void outputGraphvizEdges(PrintStream out, int currentNodeID) {
        try {
            Set<Integer> destNodeIDSet = this._pathTree.destNodeSet(currentNodeID);
            for (int dest : destNodeIDSet) {
                out.println(String.valueOf(currentNodeID) + " -> " + dest + ";");
                this.outputGraphvizEdges(out, dest);
            }
        }
        catch (GraphException e) {
            e.printStackTrace();
        }
    }

    public static void main(String[] args) throws OptionParserException {
        OptionParser<Opt> opt = new OptionParser<Opt>();
        opt.addOption(Opt.help, "h", "help", "display help messages");
        opt.parse(args);
        if (opt.isSet(Opt.help) || opt.getArgumentLength() < 1) {
            InvertedPathTree.printHelpMessage(opt);
            return;
        }
        InvertedPathTree ipt = new InvertedPathTree();
        try {
            ipt.generateFrom(opt.getArgument(0));
            ipt.outputGraphviz(System.out);
        }
        catch (XerialException e) {
            System.err.println(e.getMessage());
        }
        catch (IOException e) {
            System.err.println(e.getMessage());
        }
    }

    private static void printHelpMessage(OptionParser<Opt> opt) {
        System.out.println("usage: > java -jar DataGuide.jar [option] xml_file");
        System.out.println(opt.helpMessage());
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum Opt {
        help;

    }
}

