/*
 * Decompiled with CFR 0.152.
 */
package org.xerial.util.xml;

import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.HashMap;
import java.util.LinkedList;
import org.xerial.util.xml.InvalidXMLException;
import org.xerial.util.xml.XMLAttribute;

public class XMLGenerator {
    private int _currentLevel = 0;
    private String _indent = "  ";
    private PrintWriter _out;
    private LinkedList<String> _tagStack = new LinkedList();
    private HashMap<FormatStab, Boolean> _formatEnableFlag = new HashMap();
    private PreviousOutput _prevOut = PreviousOutput.EndTag;

    private boolean isEnable(FormatStab stabType) {
        Boolean b = this._formatEnableFlag.get((Object)stabType);
        return b == null ? false : b;
    }

    public XMLGenerator text(String textContent) {
        this._out.print(textContent);
        this._prevOut = PreviousOutput.TextContent;
        return this;
    }

    public XMLGenerator startTag(String tagName) {
        return this.startTag(tagName, null);
    }

    public XMLGenerator startTag(String tagName, XMLAttribute attribute) {
        switch (this._prevOut.ordinal()) {
            case 0: {
                if (this.isEnable(FormatStab.NewlineBeforeNestedElement)) {
                    this.newline();
                }
            }
            case 2: {
                if (!this.isEnable(FormatStab.IndentBeforeElement)) break;
                this.indent(this._currentLevel);
            }
        }
        this._out.print("<");
        this._out.print(tagName);
        if (attribute != null && attribute.length() > 0) {
            this._out.print(" ");
            this._out.print(attribute.toXMLString());
        }
        this._out.print(">");
        ++this._currentLevel;
        this._tagStack.add(tagName);
        this._prevOut = PreviousOutput.StartTag;
        return this;
    }

    public XMLGenerator element(String tagName, String textContent) throws InvalidXMLException {
        this.startTag(tagName, null);
        this.text(textContent);
        this.endTag();
        return this;
    }

    public XMLGenerator element(String tagName, XMLAttribute attribute, String textContent) throws InvalidXMLException {
        this.startTag(tagName, attribute);
        this.text(textContent);
        this.endTag();
        return this;
    }

    public XMLGenerator endTag() throws InvalidXMLException {
        if (this._currentLevel < 1) {
            throw new InvalidXMLException("");
        }
        switch (this._prevOut.ordinal()) {
            case 0: {
                if (this.isEnable(FormatStab.NewlineBeforeNestedElement)) {
                    this.newline();
                }
            }
            case 2: {
                if (!this.isEnable(FormatStab.IndentBeforeElement)) break;
                this.indent(this._currentLevel - 1);
            }
        }
        String tagName = this._tagStack.getLast();
        this._out.print("</");
        this._out.print(tagName);
        this._out.print(">");
        if (this.isEnable(FormatStab.NewlineAfterElement)) {
            this.newline();
        }
        --this._currentLevel;
        this._tagStack.removeLast();
        this._prevOut = PreviousOutput.EndTag;
        return this;
    }

    public XMLGenerator flush() {
        this._out.flush();
        return this;
    }

    public void endDocument() throws InvalidXMLException {
        while (!this._tagStack.isEmpty()) {
            this.endTag();
        }
        this._out.flush();
    }

    private void init() {
        this._formatEnableFlag.put(FormatStab.NewlineBeforeNestedElement, true);
        this._formatEnableFlag.put(FormatStab.NewlineAfterElement, true);
        this._formatEnableFlag.put(FormatStab.IndentBeforeElement, true);
    }

    public XMLGenerator() {
        this.init();
        this.setOutputStream(System.out);
    }

    public XMLGenerator(OutputStream out) {
        this.init();
        this.setOutputStream(out);
    }

    public XMLGenerator(Writer out) {
        this.init();
        this.setOutputWriter(out);
    }

    public void setOutputStream(OutputStream out) {
        this._out = new PrintWriter(out);
    }

    public void setOutputWriter(Writer writer) {
        this._out = new PrintWriter(writer);
    }

    public void setIndentCharacter(IndentType indentType, int length) {
        assert (length > 0);
        StringBuffer indent = new StringBuffer();
        switch (indentType.ordinal()) {
            case 0: {
                int i = 0;
                while (i < length) {
                    indent.append(" ");
                    ++i;
                }
                break;
            }
            case 1: {
                int i = 0;
                while (i < length) {
                    indent.append("\t");
                    ++i;
                }
                break;
            }
        }
        this._indent = indent.toString();
    }

    protected void indent(int level) {
        int i = 0;
        while (i < level) {
            this._out.print(this._indent);
            ++i;
        }
    }

    protected void newline() {
        this._out.println();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum IndentType {
        SPACE,
        TAB;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum FormatStab {
        NewlineBeforeNestedElement,
        NewlineAfterElement,
        IndentBeforeElement;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum PreviousOutput {
        StartTag,
        TextContent,
        EndTag;

    }
}

