/*
 * Decompiled with CFR 0.152.
 */
package org.xerial.index;

import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Reader;
import java.util.HashMap;
import java.util.Set;
import java.util.Stack;
import org.xerial.XerialException;
import org.xerial.util.StringUtil;
import org.xerial.util.XMLParserException;
import org.xerial.util.cui.OptionParser;
import org.xerial.util.cui.OptionParserException;
import org.xerial.util.graph.AdjacencyList;
import org.xerial.util.graph.GraphException;
import org.xerial.util.xml.XMLException;
import org.xerial.util.xml.pullparser.PullParserUtil;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DataGuide {
    private AdjacencyList _graph = new AdjacencyList();
    private HashMap<String, Integer> _tag2idMap = new HashMap();
    private HashMap<Integer, String> _id2tagMap = new HashMap();
    private int _currentNodeID = 0;
    private Stack<Integer> _cursorHistory = new Stack();

    public DataGuide() {
        this._currentNodeID = this._graph.addVertex();
        this._tag2idMap.put("_root", this._currentNodeID);
        this._id2tagMap.put(this._currentNodeID, "_root");
    }

    private static XmlPullParser getParser(Reader xmlReader) throws XMLParserException {
        XmlPullParser parser = PullParserUtil.newParser(xmlReader);
        return parser;
    }

    public void generateFrom(String xmlFile) throws FileNotFoundException, XMLParserException, XMLException, IOException, XerialException {
        BufferedReader reader = new BufferedReader(new FileReader(xmlFile));
        this.generateFrom(reader);
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void generateFrom(Reader xmlReader) throws XMLParserException, XMLException, IOException, XerialException {
        parser = DataGuide.getParser(xmlReader);
        try {
            block8: while (true) lbl-1000:
            // 5 sources

            {
                if ((state = parser.next()) == 1) {
                    return;
                }
                switch (state) {
                    case 2: {
                        tagID = this.getTagID(parser.getName());
                        this.moveCursor(tagID);
                        i = 0;
                        while (true) {
                            if (i >= parser.getAttributeCount()) continue block8;
                            attributeID = this.getTagID("@" + parser.getAttributeName(i));
                            this.moveCursor(attributeID);
                            this.traceBack();
                            ++i;
                        }
                    }
                    case 3: {
                        this.traceBack();
                        ** break;
                    }
                    case 4: {
                        ** break;
                    }
                }
            }
        }
        catch (XmlPullParserException e) {
            throw new XMLException(e);
        }
        catch (GraphException e) {
            throw new XerialException(e);
        }
    }

    private void moveCursor(int tagID) throws GraphException {
        Set<Integer> destNodeID = this._graph.destNodeSet(this._currentNodeID);
        if (!destNodeID.contains(tagID)) {
            this._graph.addEdge(this._currentNodeID, tagID);
        }
        this._cursorHistory.push(this._currentNodeID);
        this._currentNodeID = tagID;
    }

    private void traceBack() {
        assert (!this._cursorHistory.empty());
        this._currentNodeID = this._cursorHistory.pop();
    }

    private int getTagID(String tagName) {
        Integer tagID = this._tag2idMap.get(tagName);
        if (tagID == null) {
            tagID = this._graph.addVertex();
            this._tag2idMap.put(tagName, tagID);
            this._id2tagMap.put(tagID, tagName);
        }
        return tagID;
    }

    public void outputGraphviz(OutputStream out) {
        PrintWriter gout = new PrintWriter(out);
        gout.println("digraph G {");
        for (int tagID : this._graph.vertexSet()) {
            gout.println(String.valueOf(tagID) + " [label=" + StringUtil.quote(this._id2tagMap.get(tagID), "\"") + "];");
        }
        for (int tagID : this._graph.vertexSet()) {
            String tagName = this._id2tagMap.get(tagID);
            assert (tagName != null);
            try {
                Set<Integer> destNodeIDSet = this._graph.destNodeSet(tagID);
                for (int destNodeID : destNodeIDSet) {
                    gout.println(String.valueOf(tagID) + " -> " + destNodeID + ";");
                }
            }
            catch (GraphException e) {
                System.err.println(e.getMessage());
            }
        }
        gout.println("}");
        gout.flush();
    }

    public static void main(String[] args) throws OptionParserException {
        OptionParser<Opt> opt = new OptionParser<Opt>();
        opt.addOption(Opt.help, "h", "help", "display help messages");
        opt.parse(args);
        if (opt.isSet(Opt.help) || opt.getArgumentLength() < 1) {
            DataGuide.printHelpMessage(opt);
            return;
        }
        DataGuide dg = new DataGuide();
        try {
            dg.generateFrom(opt.getArgument(0));
            dg.outputGraphviz(System.out);
        }
        catch (XerialException e) {
            System.err.println(e.getMessage());
        }
        catch (IOException e) {
            System.err.println(e.getMessage());
        }
    }

    private static void printHelpMessage(OptionParser<Opt> opt) {
        System.out.println("usage: > java -jar DataGuide.jar [option] xml_file");
        System.out.println(opt.helpMessage());
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum Opt {
        help;

    }
}

