/*
 * Decompiled with CFR 0.152.
 */
package org.xerial.util.graph;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.Set;
import java.util.TreeSet;
import java.util.Vector;
import org.xerial.util.graph.Edge;
import org.xerial.util.graph.GraphException;
import org.xerial.util.graph.IteratorImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AdjacencyList {
    Vector<TreeSet<Integer>> _outEdgeList = new Vector();
    Vector<TreeSet<Integer>> _inEdgeList = new Vector();
    LinkedList<Integer> _freeNodeID = new LinkedList();
    TreeSet<Integer> _activeNodeIDSet = new TreeSet();
    int _vertexIDCount = 0;

    public AdjacencyList() {
    }

    public AdjacencyList(int numVertex) {
        int i = 0;
        while (i < numVertex) {
            this.addVertex();
            ++i;
        }
    }

    public int addVertex() {
        int nodeID;
        if (this._freeNodeID.isEmpty()) {
            nodeID = this._vertexIDCount++;
            this._outEdgeList.add(new TreeSet());
            this._inEdgeList.add(new TreeSet());
        } else {
            nodeID = this._freeNodeID.poll();
        }
        this._activeNodeIDSet.add(nodeID);
        return nodeID;
    }

    public void addEdge(int sourceVertexID, int destVertexID) throws GraphException {
        Set<Integer> destNodeListOfSourceNode = this.destNodeSet(sourceVertexID);
        Set<Integer> sourceNodeListdOfDestinationNode = this.sourceNodeSet(destVertexID);
        destNodeListOfSourceNode.add(destVertexID);
        sourceNodeListdOfDestinationNode.add(sourceVertexID);
    }

    protected boolean isValidNodeID(int vertexID) {
        return this._activeNodeIDSet.contains(vertexID);
    }

    public Set<Integer> vertexSet() {
        return this._activeNodeIDSet;
    }

    public Iterator<Integer> vertexIterator() {
        return new IteratorImpl<Integer>(this.vertexSet());
    }

    public Set<Integer> destNodeSet(int vertexID) throws GraphException {
        try {
            return this._outEdgeList.get(vertexID);
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new GraphException("unknown vertex ID %d", vertexID);
        }
    }

    public Set<Integer> sourceNodeSet(int vertexID) throws GraphException {
        try {
            return this._inEdgeList.get(vertexID);
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new GraphException("unknown vertex ID %d", vertexID);
        }
    }

    public Vector<Edge> outEdgeList(int vertexID) throws GraphException {
        Vector<Edge> edgeList = new Vector<Edge>();
        Set<Integer> destNodeSet = this.destNodeSet(vertexID);
        for (Integer destNodeID : destNodeSet) {
            edgeList.add(new Edge(vertexID, destNodeID));
        }
        return edgeList;
    }

    public Vector<Edge> inEdgeList(int vertexID) throws GraphException {
        Vector<Edge> edgeList = new Vector<Edge>();
        Set<Integer> sourceNodeSet = this.sourceNodeSet(vertexID);
        for (Integer sourceNodeID : sourceNodeSet) {
            edgeList.add(new Edge(sourceNodeID, vertexID));
        }
        return edgeList;
    }

    public Iterator<Edge> outEdgeIterator(int vertexID) throws GraphException {
        return new IteratorImpl<Edge>(this.outEdgeList(vertexID));
    }

    public Iterator<Edge> inEdgeIterator(int vertexID) throws GraphException {
        return new IteratorImpl<Edge>(this.inEdgeList(vertexID));
    }

    public void clear() {
        this._vertexIDCount = 0;
        this._outEdgeList.clear();
        this._inEdgeList.clear();
        this._freeNodeID.clear();
        this._activeNodeIDSet.clear();
    }

    public int numVertex() {
        return this._activeNodeIDSet.size();
    }
}

