/*
 * Decompiled with CFR 0.152.
 */
package org.xerial.util.graph;

import java.util.Vector;
import junit.framework.TestCase;
import org.xerial.util.graph.AdjacencyList;
import org.xerial.util.graph.Edge;
import org.xerial.util.graph.GraphException;

public class AdjacencyListTest
extends TestCase {
    AdjacencyList al;

    protected void setUp() throws Exception {
        this.al = new AdjacencyList(5);
        this.al.addEdge(0, 1);
        this.al.addEdge(1, 2);
        this.al.addEdge(0, 3);
        this.al.addEdge(4, 3);
        this.al.addEdge(1, 4);
        this.al.addEdge(4, 1);
    }

    protected void tearDown() throws Exception {
    }

    public void testAddVertex() {
        AdjacencyListTest.assertEquals((int)5, (int)this.al.numVertex());
        int n1 = this.al.addVertex();
        AdjacencyListTest.assertEquals((int)6, (int)this.al.numVertex());
    }

    public void testAddEdge() {
        try {
            Vector<Edge> edgeList = this.al.outEdgeList(0);
            AdjacencyListTest.assertEquals((int)2, (int)edgeList.size());
            AdjacencyListTest.assertTrue((boolean)edgeList.contains(new Edge(0, 1)));
            AdjacencyListTest.assertTrue((boolean)edgeList.contains(new Edge(0, 3)));
            Vector<Edge> edgeList1 = this.al.outEdgeList(1);
            AdjacencyListTest.assertEquals((int)2, (int)edgeList1.size());
            AdjacencyListTest.assertTrue((boolean)edgeList1.contains(new Edge(1, 2)));
            AdjacencyListTest.assertTrue((boolean)edgeList1.contains(new Edge(1, 4)));
        }
        catch (GraphException e) {
            AdjacencyListTest.fail((String)e.getMessage());
        }
    }

    public void testIsValidNodeID() {
        int i = 0;
        while (i < 5) {
            AdjacencyListTest.assertTrue((boolean)this.al.isValidNodeID(i));
            ++i;
        }
        i = 5;
        while (i < 10) {
            AdjacencyListTest.assertFalse((boolean)this.al.isValidNodeID(i));
            ++i;
        }
    }

    public void testVertexSet() {
    }

    public void testVertexIterator() {
    }

    public void testDestNodeSet() {
    }

    public void testSourceNodeSet() {
    }

    public void testOutEdgeList() throws GraphException {
        Vector<Edge> l = this.al.outEdgeList(4);
        AdjacencyListTest.assertEquals((int)2, (int)l.size());
        AdjacencyListTest.assertTrue((boolean)l.contains(new Edge(4, 3)));
        AdjacencyListTest.assertTrue((boolean)l.contains(new Edge(4, 1)));
    }

    public void testInEdgeList() throws GraphException {
        Vector<Edge> l = this.al.inEdgeList(3);
        AdjacencyListTest.assertEquals((int)2, (int)l.size());
        AdjacencyListTest.assertTrue((boolean)l.contains(new Edge(0, 3)));
        AdjacencyListTest.assertTrue((boolean)l.contains(new Edge(4, 3)));
    }

    public void testOutEdgeIterator() {
    }

    public void testInEdgeIterator() throws GraphException {
    }

    public void testClear() {
        this.al.clear();
        AdjacencyListTest.assertEquals((int)0, (int)this.al.numVertex());
    }
}

