/*
 * Decompiled with CFR 0.152.
 */
package org.xerial.util.xml;

import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XMLAttribute {
    protected LinkedList<String> _attributeNameList = new LinkedList();
    protected HashMap<String, String> _attributeValue = new HashMap();

    public XMLAttribute(String attributeName, String attributeValue) {
        this.add(attributeName, attributeValue);
    }

    public XMLAttribute(String attributeName, int attributeValue) {
        this.add(attributeName, attributeValue);
    }

    public XMLAttribute(String attributeName, double attributeValue) {
        this.add(attributeName, attributeValue);
    }

    public XMLAttribute(String attributeName, Object attributeValue) {
        this.add(attributeName, attributeValue);
    }

    public XMLAttribute() {
    }

    public XMLAttribute add(String attributeName, String attributeValue) {
        this._attributeNameList.add(attributeName);
        this._attributeValue.put(attributeName, attributeValue);
        return this;
    }

    public XMLAttribute add(String attributeName, int attributeValue) {
        return this.add(attributeName, Integer.toString(attributeValue));
    }

    public XMLAttribute add(String attributeName, double attributeValue) {
        return this.add(attributeName, Double.toString(attributeValue));
    }

    public XMLAttribute add(String attributeName, Object attributeValue) {
        return this.add(attributeName, attributeValue.toString());
    }

    public XMLAttribute(Properties properties) {
        Set<Object> keySet = properties.keySet();
        for (Object attributeObj : keySet) {
            String attribute = attributeObj.toString();
            String value = properties.getProperty(attribute);
            this.add(attribute, value);
        }
    }

    public XMLAttribute(Map properties) {
        Set keySet = properties.keySet();
        for (Object attributeObj : keySet) {
            String attribute = attributeObj.toString();
            String value = properties.get(attribute).toString();
            this.add(attribute, value);
        }
    }

    public String getValue(String attributeName) {
        return this._attributeValue.get(attributeName);
    }

    public List<String> getAttributes() {
        return this._attributeNameList;
    }

    public int length() {
        return this._attributeNameList.size();
    }

    public String toXMLString() {
        String returnString = "";
        for (String attributeName : this._attributeNameList) {
            String attributeValue = this._attributeValue.get(attributeName);
            returnString = String.valueOf(returnString) + attributeName + "=\"" + attributeValue + "\" ";
        }
        if (!returnString.equals("")) {
            return returnString.substring(0, returnString.length() - 1);
        }
        return returnString;
    }
}

